{- --unecht kann verwendet werden, um CD-Namen nachtrglich zu
   registrieren.  
-}

import HsShellScript
import System
import Arg
import CDs
import Maybe
import Monad
import System
import IO

normalziel      = "/usr/local/share/statisch"
normalgeraet    = "dvd"
header          = "cd-einlagern [Optionen]"

descs           = [ d_geraet, d_statisch, d_name, d_unecht, d_echo ]

d_statisch = argdesc [ desc_at_most_once
                     , desc_short 'S'
                     , desc_long "statisch"
                     , desc_argname "Verz"
                     , desc_value_required
                     , desc_description "Verzeichnis fr statische Daten"
                     ]


kzp = do

    args <- getargs header descs
    let geraet = fromMaybe normalgeraet $ optarg_req args d_geraet
        bv     = fromMaybe normalziel $ optarg_req args d_statisch
        name   = optarg_req args d_name
        unecht = arg_switch args d_unecht
        echo   = arg_switch args d_echo
        

    when (isJust name && any (== '/') (fromJust name)) $ 
        failIO "Der CD-Name darf keinen Schrgstrich enthalten."

    return (geraet, bv, name, not unecht, echo)


main = mainwrapper main'

main' = do
   (geraet, bv, name, echt, echo) <- kzp
   let mountp = "/mnt/" ++ geraet

       ausf  = run_ee echt echo
       ausf' = run_ee True echo

       mount = CDs.mount echo mountp
       umount = CDs.umount echo mountp
   
   cdname <- CDs.cdname echo mountp name
   let verz = bv ++ "/" ++ cdname

   ex_verz   <- path_exists verz
   ex_mountp <- path_exists mountp
   when ex_verz         $ failIO (shell_quote verz ++ " existiert schon.")
   when (not ex_mountp) $ failIO (shell_quote mountp ++ " existiert nicht.")

   mount
   ausf "cp" ["-av", mountp, verz]
   ausf "chattr" ["-R", "+d", verz]
   ausf "chmod" ["-R", "a-w", verz]
   umount
   catch (ausf "eject" [mountp])
         (\ioe -> return ())
   putStrLn $ shell_quote verz
