import HsShellScript
import Posix
import IO
import Maybe
import Monad
import List
import Random
import System

main =
    main'
    `catchDyn` (\argerror -> do
                    hPutStrLn stderr $ (argerror_message argerror) ++ "\n\n" ++ (argerror_usageinfo argerror)
                    exitFailure
               )

main' = do
   -- Kommandozeilenparameter parsen und bei Fehler abbrechen.
   (pakname, archivdatei, cvs, version, section, url, maintainer, beschreibung)
      <- parameter_auswerten

   -- Nur root darf das Programm ausfhren.
   test_root

   -- Verzeichnishierarchie erstellen
   verzeichnisse_erstellen pakname

   -- Archivdatei kopieren, verlinken und Entpackkommando aus Suffix bestimmen
   (link, entpackk) <- archiv_plazieren pakname archivdatei

   -- Im Archiv nachschauen, ob alles in einem Verzeichnis steckt.
   verpackt <- if isJust archivdatei then nachschauen (entpackk $ fromJust archivdatei)
                                     else return True

   -- Hilfsmittel fr die Erzeugung der Skripte und Dateien
   let qdoc            = shell_quote ("/usr/share/doc/" ++ pakname)
       qsrc            = shell_quote (pfad_src pakname)
       qdescrpak       = shell_quote (pfad pakname "lib/description-pak")
       qpak            = shell_quote (pfad pakname "pak")
       qlink           = shell_quote link
       catval dn       = "\"" ++ catval' dn ++ "\""
       catval' dn      = "`cat " ++ shell_quote (pfad pakname ("lib/" ++ dn)) ++ "`"
       rmlog logdatei  = "rm -f " ++ shell_quote (pfad pakname ("log/" ++ logdatei ++ ".log"))
       tee logdatei    = " 2>&1 | tee -a " ++ shell_quote (pfad pakname ("log/" ++ logdatei ++ ".log"))
       skript          = erz_skript pakname
       datei           = erz_datei pakname

   -- Textdateien erzeugen
   datei "lib/version"         (\zl -> zl $ fromMaybe "-" version)
   datei "lib/section"         (\zl -> zl $ fromMaybe "-" section)
   datei "lib/url"             (\zl -> zl $ fromMaybe "-" url)
   datei "lib/maintainer"      (\zl -> zl $ fromMaybe "-" maintainer)
   datei "lib/description-pak" (\zl -> zl $ fromMaybe "-" beschreibung)
   datei "lib/dokpfade"        (\zl -> zl $ "README")
   datei "Hinweise"            (const $ return ())


   -- Bash-Skripte erzeugen

   skript "sh/ausp.sh"
          "Alte Quellen lschen und neue auspacken."
          (\zl -> do
             zl $ shell_quote (pfad pakname "sh/entf.sh") ++ " || exit 1"
             zl ""
             zl $ "mkdir " ++ qsrc
             zl $ "cd " ++ qsrc
             zl $ uncurry shell_command (entpackk link)
             when verpackt $ do
                zl $ "VERZ=\"`ls`\""
                zl $ "mv \"$VERZ\"/{*,.*} . 2>/dev/null"
                zl $ "rmdir \"$VERZ\""
             zl ""
             zl $ "ls -d " ++ qsrc
          )

   skript "sh/subinst.sh"
          "wird von checkinstall aufgerufen"
          (\zl -> do
             zl "make install"
             zl $ "mkdir " ++ qdoc
             zl $ "cp -a " ++ catval' "dokpfade" ++ " " ++ qdoc
             zl $ "chown -R root.root " ++ qdoc
             zl $ "chmod -R u=rwX,go=rX " ++ qdoc
             zl $ "# find " ++ qdoc ++ " -type f -print0 | xargs -0 chmod a-x "
          )

   skript "sh/inst.sh"
          "Paket mithilfe checkinstall installieren."
          (\zl -> do
             zl $ "test \\! \"`id -u`\" = 0 && echo \"mu als root ausgefhrt werden\" && exit 1"
             zl $ rmlog "inst"
             zl $ "cd " ++ qsrc
             zl $ "cp " ++ qdescrpak ++ " " ++ qsrc
             zl $ "chmod a-w " ++ qdescrpak
             zl $ "PAKET=`realpath " ++ qlink
             zl $ "checkinstall \\"
             zl $ "   --default \\"
             zl $ "   --nodoc \\"
             zl $ "   --pkgname="         ++ pakname ++ " \\"
             zl $ "   --pkgversion="      ++ catval "version" ++ " \\"
             zl $ "   --pkggroup="        ++ catval "section" ++ " \\"
             zl $ "   --pkgsource=\"`basename \\\"$PAKET\\\"`\" \\"
             zl $ "   --pkgaltsource="    ++ catval "url" ++" \\"
             zl $ "   --pakdir="          ++ qpak ++ " \\"
             zl $ "   --maintainer="      ++ catval "maintainer" ++ " \\"
             zl $ "   " ++ shell_quote (pfad pakname "sh/subinst.sh") ++ " \\"
             zl $ "  " ++ tee "inst"
             zl $ "mv -i -f backup-*.tgz " ++ qpak ++ tee "inst"
          )

   skript "sh/bers.sh"
          "ausgepacktes Paket konfigurieren und bersetzen; noch nicht installieren"
          (\zl -> do
             zl $ "cd " ++ qsrc ++ " || exit 1"
             zl $ ""
             zl $ rmlog "configure"
             zl $ "./configure \\"
             zl $ "   --prefix=/usr \\"
             zl $ "  " ++ tee "configure"
             zl $ rmlog "make"
             zl $ "make" ++ tee "make"
             zl $ "echo \"" ++ (pfad pakname "sh/inst.sh") ++ "\""
          )

   skript "sh/entf.sh"
          ("Quellen in " ++ qsrc ++ " lschen.")
          (\zl -> do
             zl $ "test \\! -e " ++ qsrc ++ " && exit 0"
             zl $ "test \\! -d " ++ qsrc ++ " \\"
             zl $ "   && echo " ++ qsrc ++ " existiert, ist aber kein Verzeichnis \\"
             zl $ "   && exit 1"
             zl $ "echo \"Lsche den alten " ++ pakname ++ "-Quelltext in " ++ qsrc ++ ".\""
             zl $ "echo \"besttigen...\""
             zl $ "read"
             zl $ "rm -rf " ++ qsrc
          )

   when (isJust cvs) $ let cvsroot = fromJust cvs in do
      skript "sh/cvs.sh"
             "Aktuelle Quellen per CVS auschecken, verpacken und verlinken."
             (\zl -> do
                zl $ "echo In " ++ shell_quote (pfad pakname "sh/cvs.sh") ++ " die passenden CVS-Auscheckkommandos einfgen."
                zl $ "exit 1"
                zl $ ""
                zl $ shell_quote (pfad pakname "sh/entf.sh") ++ " || exit 1"
                zl $ ""
                zl $ "mkdir " ++ qsrc
                zl $ "cd " ++ qsrc
                when (cvsroot /= "") $ do
                   zl $ ""
                   zl $ "# mglicherweise:"
                   zl $ "export CVSROOT=" ++ shell_quote cvsroot
                   zl $ "cvs login"
                   zl $ "cvs -z3 co " ++ pakname
                zl $ ""
                zl $ "VERSION=cvs-\"`date +%Y-%m-%d`\""
                zl $ "echo \"$VERSION\" > " ++ shell_quote (pfad pakname "lib/version")
                zl $ shell_quote (pfad pakname "sh/pack.sh")
                zl $ "ARCHIV=" ++ pfad pakname ("pak/" ++ pakname ++ "-$VERSION.tar.bz2")
                zl $ "rm " ++ qlink
                zl $ "ln -s \"$ARCHIV\" " ++ qlink
             )

      skript "sh/pack.sh"
             "Archivdatei aus den aktuellen Quellen herstellen."
             (\zl -> do
                zl $ "test \\! -e " ++ qsrc ++ " \\"
                zl $ "   && echo Keine Quellen in " ++ qsrc ++ " vorhanden. \\"
                zl $ "   && exit 1"
                zl $ ""
                zl $ "cd " ++ qsrc
                zl $ "VERSION=\"`cat " ++ shell_quote (pfad pakname "lib/version") ++ "`\""
                zl $ "ARCHIV=" ++ pfad pakname ("pak/" ++ pakname ++ "-$VERSION.tar.bz2")
                zl $ "cd " ++ qsrc ++ "/.."
                zl $ "tar cfj \"$ARCHIV\" " ++ pakname
                zl $ ""
                zl $ "ls -l \"$ARCHIV\" "
                zl $ "ls -d " ++ qsrc
             )

   -- Zugriffsrechte setzen
   rechte pakname

   -- Wurzelverzeichnis der Hierarchie in /usr/local/sw ausgeben.
   putStrLn (shell_quote (pfad pakname ""))


---------------------------------------------------------------------------
-- Hilfsfunktionen

pfad pakname dn  = "/usr/local/sw/" ++ pakname ++ "/" ++ dn
pfad_src pakname = "/usr/local/src/" ++ pakname

-- Datei samt Inhalt mithilfe bergebener Aktion erzeugen.
erz_datei :: String                         -- Paketname
          -> String                         -- Dateiname relativ zum sw-Verzeichnis
          -> ((String -> IO ()) -> IO ())   -- Aktion, die mithilfe der bergebenen Zeilenschreibaktion das Skript schreibt
          -> IO ()
erz_datei pakname dn inhf = do
   h <- openFile (pfad pakname dn) WriteMode
   inhf (hPutStrLn h)
   hClose h


-- Shellskript samt Inhalt mithilfe bergebener Aktion erzeugen.
erz_skript :: String                         -- Paketname
           -> String                         -- Dateiname relativ zum sw-Verzeichnis
           -> String                         -- Kommentar
           -> ((String -> IO ()) -> IO ())   -- Aktion, die mithilfe der bergebenen Zeilenschreibaktion das Skript schreibt
           -> IO ()
erz_skript pakname dn kommentar inhf = do
   erz_datei pakname dn
      (\zl -> do zl "#! /bin/bash"
                 zl $ "# " ++ kommentar
                 zl ""
                 inhf zl)
   chmod ["u+x", pfad pakname dn]


---------------------------------------------------------------------------
-- Teilaufgaben

-- Kommandozeilenparameter auswerten und berprfen. Bei Fehler abbrechen.
parameter_auswerten :: IO ( String        -- Paketname
                          , Maybe String  -- Archivdatei, voller Pfad
                          , Maybe String  -- ob CVS-Skript, und ggF. Server (sonst Just "")
                          , Maybe String  -- Version
                          , Maybe String  -- Abteilung (section)
                          , Maybe String  -- URL
                          , Maybe String  -- Maintainer
                          , Maybe String  -- Beschreibung
                          )
parameter_auswerten = do
   let d_cvs          = argdesc [desc_at_most_once,
                                 desc_short 'c',
                                 desc_long "cvs",
                                 desc_argname "CVSROOT",
                                 desc_value_optional,
                                 desc_description "Skript zum Auschecken per CVS erzeugen" ]
       d_version      = argdesc [desc_at_most_once,
                                 desc_short 'v',
                                 desc_long "version",
                                 desc_argname "Version",
                                 desc_value_required,
                                 desc_description "Version eintragen" ]
       d_section      = argdesc [desc_at_most_once,
                                 desc_short 's',
                                 desc_long "section",
                                 desc_argname "Gruppe",
                                 desc_value_required,
                                 desc_description "Gruppe eintragen" ]
       d_url          = argdesc [desc_at_most_once,
                                 desc_short 'u',
                                 desc_long "url",
                                 desc_argname "URL",
                                 desc_value_required,
                                 desc_description "URL eintragen" ]
       d_maintainer   = argdesc [desc_at_most_once,
                                 desc_short 'm',
                                 desc_long "maintainer",
                                 desc_argname "EMail-Adresse",
                                 desc_value_required,
                                 desc_description "Maintainer eintragen" ]
       d_beschreibung = argdesc [desc_at_most_once,
                                 desc_short 'b',
                                 desc_long "beschreibung",
                                 desc_argname "Beschreibung",
                                 desc_value_required,
                                 desc_description "Paketbeschreibung eintragen" ]
       d_archivdatei  = argdesc [desc_at_most_once,
                                 desc_short 'a',
                                 desc_long "archiv",
                                 desc_argname "Paketdatei",
                                 desc_value_required,
                                 desc_description "angegebene Archivdatei verwenden" ]
       d_pakname      = argdesc [desc_once,
                                 desc_short 'p',
                                 desc_long "paket",
                                 desc_argname "Paketname",
                                 desc_value_required,
                                 desc_description "Name des neuen Paktes" ]
       header = "pak - Umgebung zum bersetzen und Installieren eines Pakets erzeugen.\n\
                \Syntax: pak [Optionen]\n"

   args <- getargs header [d_cvs, d_version, d_section, d_url, d_maintainer, d_beschreibung, d_archivdatei, d_pakname]

   let pakname 	   = reqarg_req args d_pakname
       swpfad      = pfad pakname ""
       archivdatei = optarg_req args d_archivdatei
   when (isJust archivdatei) $ do
        let archiv = fromJust archivdatei
        is_file archiv >>= \ex -> when (not ex) $ failIO ("Existiert nicht:\n" ++ archiv)
   is_dir  swpfad      >>= \ex -> when ex $ failIO ("Existiert schon:\n" ++ swpfad)
   archivdatei' <- if (isJust archivdatei) then realpath (fromJust archivdatei) >>= return . Just
                                           else return Nothing

   return ( pakname
          , archivdatei'
          , fmap (fromMaybe "") $ optarg_opt args d_cvs
          , optarg_req args d_version
          , optarg_req args d_section
          , optarg_req args d_url
          , optarg_req args d_maintainer
          , optarg_req args d_beschreibung
          )

-- Die Verzeichnishierarchie in /usr/local/sw erstellen
verzeichnisse_erstellen pakname = do
   run "mkdir" (map (pfad pakname) ["", "sh", "lib", "pak", "log"])


-- Archivdatei kopieren, verlinken und Entpackkommando bestimmen
archiv_plazieren pakname (Just archivdatei) =
   let (pfad_alt, datei)  = split_path archivdatei
       (suffix, entpackk) = pakettyp_analysieren archivdatei
       pfad_neu           = pfad pakname ("pak/" ++ datei)
       link               = pfad pakname ("lib/" ++ pakname ++ suffix)
   in do
     cp archivdatei pfad_neu
     symlink pfad_neu link
     return (link, entpackk)

-- Fr Aufruf ohne Archivdatei baumelnden Link erstellen und fr CVS-Skript
-- passendes Entpackkommando liefern
archiv_plazieren pakname Nothing =
   let datei              = pakname ++ "-cvs-1111-22-33.tar.bz2"
       (suffix, entpackk) = pakettyp_analysieren datei
       link               = pfad pakname ("lib/" ++ pakname ++ suffix)
   in do
     symlink (pfad pakname "pak/...") link
     return (link, entpackk)

-- Dateiname analysieren um das Kommando zu bestimmen, mit dem diese Datei
-- entpackt werden kann. Entpackkommando in fr run/shell_command
-- geeigneter Form.
pakettyp_analysieren :: String                             -- Paketdateiname
                     -> ( String                           -- dessen Suffix
                        , String -> ( String , [String]))  -- Entpackkommando
pakettyp_analysieren pakdatei =
   let methode = [ (".tar",     \dn -> ("tar", ["xf",  dn]))
                 , (".tar.gz",  \dn -> ("tar", ["xfz", dn]))
                 , (".tar.Z",   \dn -> ("tar", ["xfz", dn]))
                 , (".tgz",     \dn -> ("tar", ["xfz", dn]))
                 , (".tar.bz2", \dn -> ("tar", ["xfj", dn]))
                 ]
       anwb :: [ (String, String -> (String,[String])) ]
       anwb = [ (suffix,k) | (suffix,k) <- methode
                           , isSuffixOf suffix pakdatei
              ]
   in case anwb of
        []      -> error ("Wei nicht, wie ich das entpacken soll:\n" ++ pakdatei)
        (erg:_) -> erg


-- Nachschauen, ob der Inhalt des Pakets vollstndig in einem im Paket
-- enthaltenen Verzeichnis verpackt ist. Dazu wird das Paket probeweise entpackt.
nachschauen :: (String, [String])        -- Kommando zum entpacken
            -> IO Bool
nachschauen kommando = do
   tmpverz <- mktmpdir
   cd tmpverz
   uncurry run kommando
   (_:_:verz:rest) <- getDirectoryContents "."
   run "rm" ["-rf", tmpverz]
   return (rest == [])

test_root = do
   ausg <- pipe_from (exec "/usr/bin/id" ["-u"])
   when (chomp ausg /= "0") $ failIO "Mu als root ausgefhrt werden."


-- Zugriffsrechte des ganzen neu erzeugten Verzeichnisbaums korrekt setzen.
rechte pakname = do
   chmod ["-R", "ug=rwX,o=", pfad pakname ""]
   chown ["-R", "root:v",    pfad pakname ""]


mktmpdir :: IO String
mktmpdir = do
   zz <- getProcessID
   yy <- randomIO
   let verz = "/tmp/tmp-" ++ show zz ++ show (yy :: Int)
   mkdir verz
   return verz

