-- Siehe force_mv in der HsShellScript-API-Dokumentation

import HsShellScript
import Monad
import IO
import System

import Posix
import Data.Bits


header = "force_mv <Parameter an mv>\n\
         \Der Aufruf ist wie mv, auer da genau eine Quelle und ein Ziel erforderlich ist (also auch kein --target-directory)."


main = mainwrapper $ do
   (opts,pfade) <- fmap teilen $ getArgs
   case pfade of
      [quelle, ziel] -> force_cmd (\q z -> run "/bin/mv" (opts ++ [q, z])) quelle ziel
      _              -> failIO "Es mu genau eine Quelle und genau ein Ziel angegeben werden."


-- Optionen von Pfaden trennen
teilen [] = ([],[])
teilen ("--":rest) = ([], rest)
teilen (par1@('-':par1rest):rest) = 
   let (pars, pfade) = teilen rest
   in  (par1:pars, pfade)
teilen (pfad1:rest) =
   let (pars, pfade) = teilen rest
   in  (pars, pfad1:pfade)
