import {createStore, applyMiddleware, compose} from 'redux';
import thunk from 'redux-thunk';
import rootReducer from '../reducers/index';
import effects from '../utils/effects';
import * as plugins from '../utils/plugins';
import writeMiddleware from './write-middleware';

export default () => {
  const enhancer = compose(
    applyMiddleware(thunk, plugins.middleware, thunk, writeMiddleware, effects),
    window.devToolsExtension()
  );

  return createStore(rootReducer, enhancer);
};
