describe("Set", function() {
  describe('has', function() {
    it('with string', function() {
      var set = new Set();
      set.add('0');
      expect(set.has('0')).toBe(true);
    });

    it('with number', function() {
      var set = new Set();
      set.add(0);
      expect(set.has(0)).toBe(true);
      expect(set.has(-0)).toBe(true);  // SameValueZero
    });

    it('with boolean', function() {
      var set = new Set();
      set.add(true);
      expect(set.has(true)).toBe(true);
      expect(set.has(false)).toBe(false);
    });

    it('with NaN', function() {
      var set = new Set();
      set.add(NaN);
      expect(set.has(NaN)).toBe(true);
    });

    it('with object', function() {
      var set = new Set();
      var key = {};
      set.add(key);
      expect(set.has(key)).toBe(true);
      expect(set.has({})).toBe(false);
    });
  });
});
