/*
 * Decompiled with CFR 0.152.
 */
package com.ice.tar;

import com.ice.tar.InvalidHeaderException;
import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import com.ice.tar.TarOutputStream;
import com.ice.tar.TarProgressDisplay;
import com.ice.tar.TarTransFileTyper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.activation.FileTypeMap;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class TarArchive {
    protected boolean verbose;
    protected boolean debug;
    protected boolean keepOldFiles;
    protected boolean asciiTranslate;
    protected int userId;
    protected String userName;
    protected int groupId;
    protected String groupName;
    protected String rootPath;
    protected String tempPath;
    protected String pathPrefix;
    protected int recordSize;
    protected byte[] recordBuf;
    protected TarInputStream tarIn;
    protected TarOutputStream tarOut;
    protected TarTransFileTyper transTyper;
    protected TarProgressDisplay progressDisplay;

    public TarArchive(InputStream inputStream) {
        this(inputStream, 10240);
    }

    public TarArchive(InputStream inputStream, int n) {
        this(inputStream, n, 512);
    }

    public TarArchive(InputStream inputStream, int n, int n2) {
        this.tarIn = new TarInputStream(inputStream, n, n2);
        this.initialize(n2);
    }

    public TarArchive(OutputStream outputStream) {
        this(outputStream, 10240);
    }

    public TarArchive(OutputStream outputStream, int n) {
        this(outputStream, n, 512);
    }

    public TarArchive(OutputStream outputStream, int n, int n2) {
        this.tarOut = new TarOutputStream(outputStream, n, n2);
        this.initialize(n2);
    }

    private void initialize(int n) {
        this.rootPath = null;
        this.pathPrefix = null;
        this.tempPath = System.getProperty("user.dir");
        this.userId = 0;
        this.userName = "";
        this.groupId = 0;
        this.groupName = "";
        this.debug = false;
        this.verbose = false;
        this.keepOldFiles = false;
        this.progressDisplay = null;
        this.recordBuf = new byte[this.getRecordSize()];
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        if (this.tarIn != null) {
            this.tarIn.setDebug(bl);
        } else if (this.tarOut != null) {
            this.tarOut.setDebug(bl);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setTarProgressDisplay(TarProgressDisplay tarProgressDisplay) {
        this.progressDisplay = tarProgressDisplay;
    }

    public void setKeepOldFiles(boolean bl) {
        this.keepOldFiles = bl;
    }

    public void setAsciiTranslation(boolean bl) {
        this.asciiTranslate = bl;
    }

    public void setTransFileTyper(TarTransFileTyper tarTransFileTyper) {
        this.transTyper = tarTransFileTyper;
    }

    public void setUserInfo(int n, String string, int n2, String string2) {
        this.userId = n;
        this.userName = string;
        this.groupId = n2;
        this.groupName = string2;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getTempDirectory() {
        return this.tempPath;
    }

    public void setTempDirectory(String string) {
        this.tempPath = string;
    }

    public int getRecordSize() {
        if (this.tarIn != null) {
            return this.tarIn.getRecordSize();
        }
        if (this.tarOut != null) {
            return this.tarOut.getRecordSize();
        }
        return 512;
    }

    private String getTempFilePath(File file) {
        String string = this.tempPath + File.separator + file.getName() + ".tmp";
        int n = 1;
        while (n < 5) {
            File file2 = new File(string);
            if (!file2.exists()) break;
            string = this.tempPath + File.separator + file.getName() + "-" + n + ".tmp";
            ++n;
        }
        return string;
    }

    public void closeArchive() throws IOException {
        if (this.tarIn != null) {
            this.tarIn.close();
        } else if (this.tarOut != null) {
            this.tarOut.close();
        }
    }

    public void listContents() throws IOException, InvalidHeaderException {
        while (true) {
            TarEntry tarEntry;
            if ((tarEntry = this.tarIn.getNextEntry()) == null) {
                if (!this.debug) break;
                System.err.println("READ EOF RECORD");
                break;
            }
            if (this.progressDisplay == null) continue;
            this.progressDisplay.showTarProgressMessage(tarEntry.getName());
        }
    }

    public void extractContents(File file) throws IOException, InvalidHeaderException {
        while (true) {
            TarEntry tarEntry;
            if ((tarEntry = this.tarIn.getNextEntry()) == null) {
                if (!this.debug) break;
                System.err.println("READ EOF RECORD");
                break;
            }
            this.extractEntry(file, tarEntry);
        }
    }

    private void extractEntry(File file, TarEntry tarEntry) throws IOException {
        if (this.verbose && this.progressDisplay != null) {
            this.progressDisplay.showTarProgressMessage(tarEntry.getName());
        }
        String string = tarEntry.getName();
        string = string.replace('/', File.separatorChar);
        File file2 = new File(file, string);
        if (tarEntry.isDirectory()) {
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException("error making directory path '" + file2.getPath() + "'");
            }
        } else {
            File file3 = new File(file2.getParent());
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException("error making directory path '" + file3.getPath() + "'");
            }
            if (this.keepOldFiles && file2.exists()) {
                if (this.verbose && this.progressDisplay != null) {
                    this.progressDisplay.showTarProgressMessage("not overwriting " + tarEntry.getName());
                }
            } else {
                int n;
                Object object;
                Object object2;
                boolean bl = false;
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                if (this.asciiTranslate) {
                    object2 = null;
                    object = null;
                    try {
                        object = FileTypeMap.getDefaultFileTypeMap().getContentType(file2);
                        object2 = new MimeType((String)object);
                        if (((MimeType)object2).getPrimaryType().equalsIgnoreCase("text")) {
                            bl = true;
                        } else if (this.transTyper != null && this.transTyper.isAsciiFile(tarEntry.getName())) {
                            bl = true;
                        }
                    }
                    catch (MimeTypeParseException mimeTypeParseException) {
                        // empty catch block
                    }
                    if (this.debug) {
                        System.err.println("EXTRACT TRANS? '" + bl + "'  ContentType='" + (String)object + "'  PrimaryType='" + ((MimeType)object2).getPrimaryType() + "'");
                    }
                }
                object2 = null;
                if (bl) {
                    object2 = new PrintWriter(fileOutputStream);
                }
                object = new byte[32768];
                while ((n = this.tarIn.read((byte[])object)) != -1) {
                    if (bl) {
                        int n2 = 0;
                        int n3 = 0;
                        while (n3 < n) {
                            if (object[n3] == 10) {
                                String string2 = new String((byte[])object, n2, n3 - n2);
                                ((PrintWriter)object2).println(string2);
                                n2 = n3 + 1;
                            }
                            ++n3;
                        }
                        continue;
                    }
                    fileOutputStream.write((byte[])object, 0, n);
                }
                if (bl) {
                    ((PrintWriter)object2).close();
                } else {
                    fileOutputStream.close();
                }
            }
        }
    }

    public void writeEntry(TarEntry tarEntry, boolean bl) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl2 = false;
        boolean bl3 = tarEntry.isUnixTarFormat();
        File file = null;
        File file2 = tarEntry.getFile();
        TarEntry tarEntry2 = (TarEntry)tarEntry.clone();
        if (this.verbose && this.progressDisplay != null) {
            this.progressDisplay.showTarProgressMessage(tarEntry2.getName());
        }
        if (this.asciiTranslate && !tarEntry2.isDirectory()) {
            object4 = null;
            object3 = null;
            try {
                object3 = FileTypeMap.getDefaultFileTypeMap().getContentType(file2);
                object4 = new MimeType((String)object3);
                if (((MimeType)object4).getPrimaryType().equalsIgnoreCase("text")) {
                    bl2 = true;
                } else if (this.transTyper != null && this.transTyper.isAsciiFile(file2)) {
                    bl2 = true;
                }
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                // empty catch block
            }
            if (this.debug) {
                System.err.println("CREATE TRANS? '" + bl2 + "'  ContentType='" + (String)object3 + "'  PrimaryType='" + ((MimeType)object4).getPrimaryType() + "'");
            }
            if (bl2) {
                String string;
                object2 = this.getTempFilePath(file2);
                file = new File((String)object2);
                object = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    bufferedOutputStream.write(string.getBytes());
                    bufferedOutputStream.write(10);
                }
                ((BufferedReader)object).close();
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                tarEntry2.setSize(file.length());
                file2 = file;
            }
        }
        object4 = null;
        if (this.rootPath != null && tarEntry2.getName().startsWith(this.rootPath)) {
            object4 = tarEntry2.getName().substring(this.rootPath.length() + 1);
        }
        if (this.pathPrefix != null) {
            Object object5 = object4 = object4 == null ? this.pathPrefix + "/" + tarEntry2.getName() : this.pathPrefix + "/" + (String)object4;
        }
        if (object4 != null) {
            tarEntry2.setName((String)object4);
        }
        this.tarOut.putNextEntry(tarEntry2);
        if (tarEntry2.isDirectory()) {
            if (bl) {
                object3 = tarEntry2.getDirectoryEntries();
                int n = 0;
                while (n < ((TarEntry[])object3).length) {
                    object = object3[n];
                    if (bl3) {
                        ((TarEntry)object).setUnixTarFormat();
                    }
                    this.writeEntry((TarEntry)object, bl);
                    ++n;
                }
            }
        } else {
            int n;
            object3 = new FileInputStream(file2);
            object2 = new byte[32768];
            while ((n = ((FileInputStream)object3).read((byte[])object2, 0, ((Object)object2).length)) != -1) {
                this.tarOut.write((byte[])object2, 0, n);
            }
            ((FileInputStream)object3).close();
            if (file != null) {
                file.delete();
            }
            this.tarOut.closeEntry();
        }
    }
}

