/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.util.TableOrder;

public class ImageMapDemo6 {
    public void saveImageAndHTML() {
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        try {
            ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            File file = new File("multipiechart100.png");
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)600, (int)400, (ChartRenderingInfo)chartRenderingInfo);
            File file2 = new File("multipiechart100.html");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
            printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
            printWriter.println("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            printWriter.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">");
            printWriter.println("<head><title>JFreeChart Image Map Demo</title></head>");
            printWriter.println("<body><p>");
            ImageMapUtilities.writeImageMap((PrintWriter)printWriter, (String)"chart", (ChartRenderingInfo)chartRenderingInfo);
            printWriter.println("<img src=\"multipiechart100.png\" width=\"600\" height=\"400\" usemap=\"#chart\" alt=\"multipiechart100.png\"/>");
            printWriter.println("</p></body>");
            printWriter.println("</html>");
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    private CategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{3.0, 4.0, 3.0, 5.0}, {5.0, 7.0, 6.0, 8.0}, {5.0, 7.0, 3.0, 8.0}, {1.0, 2.0, 3.0, 4.0}, {2.0, 3.0, 2.0, 3.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset((String)"Region ", (String)"Sales/Q", (double[][])dArrayArray);
        return categoryDataset;
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createMultiplePieChart((String)"Multiple Pie Chart", (CategoryDataset)categoryDataset, (TableOrder)TableOrder.BY_ROW, (boolean)true, (boolean)true, (boolean)true);
        MultiplePiePlot multiplePiePlot = (MultiplePiePlot)jFreeChart.getPlot();
        JFreeChart jFreeChart2 = multiplePiePlot.getPieChart();
        PiePlot piePlot = (PiePlot)jFreeChart2.getPlot();
        piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieItemLabelGenerator("{0}"));
        piePlot.setLabelFont(new Font("SansSerif", 0, 8));
        piePlot.setInteriorGap(0.3);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        ImageMapDemo6 imageMapDemo6 = new ImageMapDemo6();
        imageMapDemo6.saveImageAndHTML();
    }
}

