/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class LineChartDemo2
extends ApplicationFrame {
    public LineChartDemo2(String string) {
        super(string);
        XYDataset xYDataset = LineChartDemo2.createDataset();
        JFreeChart jFreeChart = LineChartDemo2.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)chartPanel);
    }

    private static XYDataset createDataset() {
        XYSeries xYSeries = new XYSeries("First");
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 4.0);
        xYSeries.add(3.0, 3.0);
        xYSeries.add(4.0, 5.0);
        xYSeries.add(5.0, 5.0);
        xYSeries.add(6.0, 7.0);
        xYSeries.add(7.0, 7.0);
        xYSeries.add(8.0, 8.0);
        XYSeries xYSeries2 = new XYSeries("Second");
        xYSeries2.add(1.0, 5.0);
        xYSeries2.add(2.0, 7.0);
        xYSeries2.add(3.0, 6.0);
        xYSeries2.add(4.0, 8.0);
        xYSeries2.add(5.0, 4.0);
        xYSeries2.add(6.0, 4.0);
        xYSeries2.add(7.0, 2.0);
        xYSeries2.add(8.0, 1.0);
        XYSeries xYSeries3 = new XYSeries("Third");
        xYSeries3.add(3.0, 4.0);
        xYSeries3.add(4.0, 3.0);
        xYSeries3.add(5.0, 2.0);
        xYSeries3.add(6.0, 3.0);
        xYSeries3.add(7.0, 6.0);
        xYSeries3.add(8.0, 3.0);
        xYSeries3.add(9.0, 4.0);
        xYSeries3.add(10.0, 3.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        xYSeriesCollection.addSeries(xYSeries3);
        return xYSeriesCollection;
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)"Line Chart Demo 2", (String)"X", (String)"Y", (XYDataset)xYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint((Paint)Color.lightGray);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setDomainGridlinePaint((Paint)Color.white);
        xYPlot.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        xYLineAndShapeRenderer.setShapesVisible(true);
        xYLineAndShapeRenderer.setShapesFilled(true);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = LineChartDemo2.createChart(LineChartDemo2.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        LineChartDemo2 lineChartDemo2 = new LineChartDemo2("Line Chart Demo 2");
        lineChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)lineChartDemo2));
        lineChartDemo2.setVisible(true);
    }
}

