/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Log;
import org.jfree.util.LogTarget;
import org.jfree.util.PrintStreamLogTarget;

public class PieChartDemo4
extends ApplicationFrame {
    public PieChartDemo4(String string) {
        super(string);
        PieDataset pieDataset = this.createDataset(14);
        JFreeChart jFreeChart = ChartFactory.createPieChart((String)"Pie Chart Demo 4", (PieDataset)pieDataset, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)new Color(222, 222, 255));
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        piePlot.setBackgroundPaint((Paint)Color.white);
        piePlot.setCircular(true);
        piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieItemLabelGenerator("{0} = {2}", NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance()));
        piePlot.setNoDataMessage("No data available");
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)chartPanel);
        Rotator rotator = new Rotator(piePlot);
        rotator.start();
    }

    private PieDataset createDataset(int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        for (int i = 0; i < n; ++i) {
            double d = 100.0 * Math.random();
            defaultPieDataset.setValue((Comparable)((Object)("Section " + i)), d);
        }
        return defaultPieDataset;
    }

    public static void main(String[] stringArray) {
        Log.getInstance().addTarget((LogTarget)new PrintStreamLogTarget());
        PieChartDemo4 pieChartDemo4 = new PieChartDemo4("Pie Chart Demo 4");
        pieChartDemo4.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)pieChartDemo4));
        pieChartDemo4.setVisible(true);
    }

    static class Rotator
    extends Timer
    implements ActionListener {
        private PiePlot plot;
        private int angle = 270;

        Rotator(PiePlot piePlot) {
            super(100, null);
            this.plot = piePlot;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.plot.setStartAngle((double)this.angle);
            ++this.angle;
            if (this.angle == 360) {
                this.angle = 0;
            }
        }
    }
}

