/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PolarChartDemo1
extends ApplicationFrame {
    public PolarChartDemo1(String string) {
        super(string);
        XYDataset xYDataset = PolarChartDemo1.createDataset();
        JFreeChart jFreeChart = PolarChartDemo1.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)chartPanel);
    }

    private static XYDataset createDataset() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        XYSeries xYSeries = new XYSeries("Series 1");
        xYSeries.add(0.0, 2.0);
        xYSeries.add(90.0, 13.0);
        xYSeries.add(180.0, 9.0);
        xYSeries.add(270.0, 8.0);
        xYSeriesCollection.addSeries(xYSeries);
        XYSeries xYSeries2 = new XYSeries("Series 2");
        xYSeries2.add(90.0, -11.2);
        xYSeries2.add(180.0, 21.4);
        xYSeries2.add(250.0, 17.3);
        xYSeries2.add(355.0, 10.9);
        xYSeriesCollection.addSeries(xYSeries2);
        return xYSeriesCollection;
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createPolarChart((String)"Polar Chart Demo 1", (XYDataset)xYDataset, (boolean)true, (boolean)false, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        PolarPlot polarPlot = (PolarPlot)jFreeChart.getPlot();
        polarPlot.setBackgroundPaint((Paint)Color.lightGray);
        NumberAxis numberAxis = (NumberAxis)polarPlot.getAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = PolarChartDemo1.createChart(PolarChartDemo1.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        PolarChartDemo1 polarChartDemo1 = new PolarChartDemo1("Polar Chart Demo");
        polarChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)polarChartDemo1));
        polarChartDemo1.setVisible(true);
    }
}

