/*
 * (C) Copyright IBM Corp. 2001
 */
//$Id: OPT_NullConstantOperand.java,v 1.4 2002/08/23 11:28:40 dgrove-oss Exp $
package com.ibm.JikesRVM.opt.ir;

/**
 * This operand represents the null constant.
 * 
 * @see OPT_Operand
 * @author John Whaley
 */
public final class OPT_NullConstantOperand extends OPT_ConstantOperand {

  /**
   * Return a new operand that is semantically equivalent to <code>this</code>.
   * 
   * @return a copy of <code>this</code>
   */
  public OPT_Operand copy() {
    return new OPT_NullConstantOperand();
  }

  /**
   * Are two operands semantically equivalent?
   *
   * @param op other operand
   * @return   <code>true</code> if <code>this</code> and <code>op</code>
   *           are semantically equivalent or <code>false</code> 
   *           if they are not.
   */
  public boolean similar(OPT_Operand op) {
    return op instanceof OPT_NullConstantOperand;
  }

  /**
   * Returns the string representation of this operand.
   *
   * @return a string representation of this operand.
   */
  public String toString() {
    return "<null>";
  }
}
