/*
 * (C) Copyright IBM Corp. 2001
 */
//$Id: VM_ObjectAddressRemapper.java,v 1.4 2002/08/15 14:05:42 sjfink-oss Exp $
package com.ibm.JikesRVM;

/**
 * Facility for remapping object addresses across virtual machine address 
 * spaces.  Used by boot image writer to map local (jdk) objects into remote 
 * (boot image) addresses.  Used by debugger to map local (jdk) objects into 
 * remote (debugee vm) addresses.
 *
 * See also VM_Magic.setObjectAddressRemapper()
 *
 * @author Bowen Alpern
 * @author Derek Lieber
 */
public interface VM_ObjectAddressRemapper
   {
   // Map an object to an address.
   // Taken:    an object in "local" virtual machine
   // Returned: its address in a foreign virtual machine
   //
   public VM_Address objectAsAddress(Object object);

   // Map an address to an object.
   // Taken:    value obtained from "objectAsAddress"
   // Returned: corresponding object
   //
   public Object addressAsObject(VM_Address address);
   }
