/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.AliasToken;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;

public class Colons
extends TokenRule {
    public static final String OPTION_MAX_SPACES_BEFORE = "max-spaces-before";
    public static final String OPTION_MAX_SPACES_AFTER = "max-spaces-after";

    public Colons() {
        this.registerOption(OPTION_MAX_SPACES_BEFORE, 0);
        this.registerOption(OPTION_MAX_SPACES_AFTER, 1);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        LintProblem problem;
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (token instanceof ValueToken && (!(prev instanceof AliasToken) || token.getStartMark().getPointer() - prev.getEndMark().getPointer() != 1)) {
            problem = this.spacesBefore(token, prev, -1, (int)((Integer)conf.get(OPTION_MAX_SPACES_BEFORE)), null, "too many spaces before colon");
            if (problem != null) {
                problems.add(problem);
            }
            if ((problem = this.spacesAfter(token, next, -1, (int)((Integer)conf.get(OPTION_MAX_SPACES_AFTER)), null, "too many spaces after colon")) != null) {
                problems.add(problem);
            }
        }
        if (token instanceof KeyToken && this.isExplicitKey(token) && (problem = this.spacesAfter(token, next, -1, (int)((Integer)conf.get(OPTION_MAX_SPACES_AFTER)), null, "too many spaces after question mark")) != null) {
            problems.add(problem);
        }
        return problems;
    }
}

