/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import com.hierynomus.sshj.userauth.certificate.Certificate;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignature;
import net.schmizz.sshj.signature.Signature;

public class SignatureRSA
extends AbstractSignature {
    private KeyType keyType;

    public SignatureRSA(String algorithm, KeyType keyType, String name) {
        super(algorithm, name);
        this.keyType = keyType;
    }

    @Override
    public void initVerify(PublicKey publicKey) {
        try {
            if (this.keyType.equals((Object)KeyType.RSA_CERT) && publicKey instanceof Certificate) {
                this.signature.initVerify((PublicKey)((Certificate)publicKey).getKey());
            } else {
                this.signature.initVerify(publicKey);
            }
        }
        catch (InvalidKeyException e) {
            throw new SSHRuntimeException(e);
        }
    }

    @Override
    public byte[] encode(byte[] signature) {
        return signature;
    }

    @Override
    public boolean verify(byte[] sig) {
        sig = this.extractSig(sig, this.getSignatureName());
        try {
            return this.signature.verify(sig);
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public static class FactoryCERT
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureRSA("SHA1withRSA", KeyType.RSA_CERT, KeyType.RSA.toString());
        }

        @Override
        public String getName() {
            return KeyType.RSA_CERT.toString();
        }
    }

    public static class FactoryRSASHA512
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureRSA("SHA512withRSA", KeyType.RSA, "rsa-sha2-512");
        }

        @Override
        public String getName() {
            return "rsa-sha2-512";
        }
    }

    public static class FactoryRSASHA256
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureRSA("SHA256withRSA", KeyType.RSA, "rsa-sha2-256");
        }

        @Override
        public String getName() {
            return "rsa-sha2-256";
        }
    }

    public static class FactorySSHRSA
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureRSA("SHA1withRSA", KeyType.RSA, KeyType.RSA.toString());
        }

        @Override
        public String getName() {
            return KeyType.RSA.toString();
        }
    }
}

