/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class AsdfPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.AsdfPackager, AsdfPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private static final long serialVersionUID = 2289622050226719068L;
    private final AsdfRepository repository = new AsdfRepository();
    private String toolCheck;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.AsdfPackager immutable = new org.jreleaser.model.api.packagers.AsdfPackager(){
        private static final long serialVersionUID = 2602907890530867272L;

        public String getToolCheck() {
            return AsdfPackager.this.toolCheck;
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return AsdfPackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return AsdfPackager.this.getCommitAuthor().asImmutable();
        }

        public String getTemplateDirectory() {
            return AsdfPackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(AsdfPackager.this.getSkipTemplates());
        }

        public String getType() {
            return AsdfPackager.this.getType();
        }

        public String getDownloadUrl() {
            return AsdfPackager.this.getDownloadUrl();
        }

        public boolean supportsPlatform(String platform) {
            return AsdfPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return AsdfPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return AsdfPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return AsdfPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return AsdfPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return AsdfPackager.this.isContinueOnError();
        }

        public Active getActive() {
            return AsdfPackager.this.getActive();
        }

        public boolean isEnabled() {
            return AsdfPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(AsdfPackager.this.asMap(full));
        }

        public String getPrefix() {
            return AsdfPackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(AsdfPackager.this.getExtraProperties());
        }
    };

    public AsdfPackager() {
        super("asdf");
    }

    @Override
    public org.jreleaser.model.api.packagers.AsdfPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(AsdfPackager source) {
        super.merge(source);
        this.toolCheck = this.merge(this.toolCheck, source.toolCheck);
        this.setRepository(source.repository);
    }

    public String getToolCheck() {
        return this.toolCheck;
    }

    public void setToolCheck(String toolCheck) {
        this.toolCheck = toolCheck;
    }

    public AsdfRepository getRepository() {
        return this.repository;
    }

    public void setRepository(AsdfRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("toolcheck", this.toolCheck);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.getRepository();
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform) || PlatformUtils.isLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipAsdf"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.FLAT_BINARY, Collections.emptySet());
    }

    public static final class AsdfRepository
    extends PackagerRepository {
        private static final long serialVersionUID = -3477982615763115685L;

        public AsdfRepository() {
            super("asdf", "asdf");
        }
    }
}

