//------------------------------------------------------------------------------
// GraphBLAS/CUDA/Template/GB_cuda_kernel.cuh: definitions for CUDA kernels
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2024, All Rights Reserved.
// This file: Copyright (c) 2024, NVIDIA CORPORATION. All rights reserved.
// SPDX-License-Identifier: Apache-2.0

//------------------------------------------------------------------------------

// This file is #include'd into all device functions for CUDA JIT kernels for
// GraphBLAS.  It provides a subset of GraphBLAS.h and GB.h, plus other
// definitions.  It is not used on the host.

#pragma once

//------------------------------------------------------------------------------
// C++ and CUDA #include files
//------------------------------------------------------------------------------

#include <limits>
#include <type_traits>
#include <cstdint>
#include <cmath>
#include <stdio.h>
#include <cub/block/block_scan.cuh>
#include <cooperative_groups.h>
using namespace cooperative_groups ;

//------------------------------------------------------------------------------
// CUDA kernel definitions
//------------------------------------------------------------------------------

#define GB_CUDA_KERNEL

#undef  ASSERT
#define ASSERT(x)

//------------------------------------------------------------------------------
// NVIDIA warp size
//------------------------------------------------------------------------------

#define WARPSIZE 32
#define LOG2_WARPSIZE 5

//------------------------------------------------------------------------------

// for internal static inline functions
#undef  GB_STATIC_INLINE
#define GB_STATIC_INLINE static __device__ __inline__

//------------------------------------------------------------------------------
// subset of GraphBLAS.h
//------------------------------------------------------------------------------

#include "GraphBLAS_h_subset.cuh"

//------------------------------------------------------------------------------
// subset of GB.h
//------------------------------------------------------------------------------

#include "GB_h_subset.cuh"

//------------------------------------------------------------------------------
// final #include files
//------------------------------------------------------------------------------

#include "GB_cuda_error.hpp"
#include "GB_printf_kernels.h"
#include "GB_cuda_atomics.cuh"
#include "GB_hash.h"
#include "GB_hyper_hash_lookup.h"

extern "C"
{
    #include "GB_werk.h"
    #include "GB_callback.h"
}

