/*
 * Copyright (C) 2014, 2016 Karl Wette
 * Copyright (C) 2009-2013 Adam Mercer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * LALAppsVCSInfo.h - LALApps VCS Information Header
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALAPPSVCSINFOHEADER_H
#define _LALAPPSVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <LALAppsVCSInfo.h>
#include <config.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information */
#define LALAPPS_VCS_ID "285b3b8a27e050b32ed44366f046a6f43d47da77"
#define LALAPPS_VCS_DATE "2018-09-25 18:21:57 +0000"
#define LALAPPS_VCS_BRANCH "None"
#define LALAPPS_VCS_TAG "lalapps-v6.22.0"
#define LALAPPS_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALAPPS_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALAPPS_VCS_CLEAN "CLEAN"
#define LALAPPS_VCS_STATUS "CLEAN: All modifications committed"

#if LALAPPS_VERSION_DEVEL != 0
/* VCS header/library mismatch link check function */
#define LALAPPS_VCS_LINK_CHECK LALAPPS_CLEAN_285b3b8a27e050b32ed44366f046a6f43d47da77_VCS_HEADER_LIBRARY_MISMATCH
void LALAPPS_VCS_LINK_CHECK(void);
#endif

#ifdef __cplusplus
}
#endif

#endif /* _LALAPPSVCSINFOHEADER_H */

/** \endcond */
