%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts --enable-cfitsio GSL_LIBS="-lgsl" CFITSIO_LIBS="-lcfitsio"

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalpulsar
Version: 2.0.0
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LSC Algorithm Pulsar Library
License: GPLv2+
Group: LAL
Source0: http://software.ligo.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: cfitsio-devel
BuildRequires: fftw-devel
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: gsl-devel
BuildRequires: lal-devel >= 7.0.0
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.9

# python2
BuildRequires: python2-rpm-macros
BuildRequires: python-devel
BuildRequires: python2-astropy
BuildRequires: python2-lal >= 7.0.0
BuildRequires: python2-mock
BuildRequires: python2-numpy
BuildRequires: python-pathlib
BuildRequires: pytest

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: epel-rpm-macros
BuildRequires: python%{python3_pkgversion}
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-astropy
BuildRequires: python%{python3_pkgversion}-lal >= 7.0.0
BuildRequires: python%{python3_pkgversion}-numpy
BuildRequires: python%{python3_pkgversion}-pytest

# octave
BuildRequires: octave-devel
BuildRequires: lal-octave >= 7.0.0

# -- packages ---------------

# lalpulsar
Requires: cfitsio
Requires: fftw
Requires: gsl
Requires: lal >= 7.0.0

%description
The LSC Algorithm Pulsar Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Pulsar library.

# lalpulsar-devel
%package devel
Summary: Files and documentation needed for compiling programs that use LAL Pulsar
Group: LAL
Requires: %{name} = %{version}
Requires: cfitsio-devel
Requires: fftw-devel
Requires: fftw-static
Requires: gsl-devel
Requires: lal-devel >= 7.0.0
%description devel
The LSC Algorithm Pulsar Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL
Pulsar library.

# python2-lalpulsar
%package -n python2-%{name}
Summary: Python %{python2_version} bindings for LALPulsar
Group: LAL
Requires: %{name} = %{version}
Requires: python
Requires: python2-astropy
Requires: python2-lal >= 7.0.0
Requires: python2-numpy
Provides: %{name}-python = %{version}-%{release}
Obsoletes: %{name}-python < %{version}-%{release}
%{?python_provide:%python_provide python2-%{name}}
%description -n python2-%{name}
This package provides the Python %{python2_version} bindings for LALPulsar.

# python3x-lalpulsar
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version} bindings for LALPulsar
Group: LAL
Requires: %{name} = %{version}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-astropy
Requires: python%{python3_pkgversion}-lal >= 7.0.0
Requires: python%{python3_pkgversion}-numpy
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
This package provides the Python %{python3_version} bindings for LALPulsar.

# lalpulsar-octave
%package octave
Summary: Octave bindings for LALPulsar
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 7.0.0
%description octave
This package provides the Octave bindings for LALPulsar.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
# build C library with python2
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python2}
%{__make} %{?_smp_mflags} V=1

# build python3 library (copy things so we don't have to rebuild them)
rm -rf %py3dir
cp -r . %py3dir
pushd %py3dir
rm -rfv python/%{name}/*.{la,lo,o} python/%{name}/.libs
%configure %{configure_opts} --disable-doxygen --disable-gcc-flags --disable-swig-octave --enable-swig-python PYTHON=%{__python3}
%{__make} V=1 -C swig
%{__make} V=1 -C python/%{name}
popd

%check
# C + python2 + octave
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check
# python3
[ -d %py3dir/test/python ] && %{__make} %{?_smp_mflags} V=1 VERBOSE=1 -C %py3dir -C test/python check

%install
# C + python2 + octave
%make_install
# python3
%{__make} -C %py3dir -C swig install-exec-am DESTDIR=%{?buildroot}
%{__make} -C %py3dir -C python/%{name} install DESTDIR=%{?buildroot}
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files
%defattr(-,root,root)
%license COPYING
%{_bindir}/lalpulsar_version
%{_datarootdir}/lalpulsar/*
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python2-%{name}
%defattr(-,root,root)
%license COPYING
%{python2_sitearch}/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalpulsar.oct*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.0-1
- Update for 2.0.0

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.18.2-2
- Packaging updates

* Wed Nov 27 2019 Adam Mercer <adam.mercer@ligo.org> 1.18.2-1
- O3b release

* Tue Aug 06 2019 Adam Mercer <adam.mercer@ligo.org> 1.18.1-1
- O3 point release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.18.0-1
* O3 release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 1.17.1-1
- ER14 release

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.17.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.16.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.15.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.14.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.13.0-1
- Pre O2 packaging test release
