%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts --enable-cfitsio CFITSIO_LIBS="-lcfitsio" --disable-sistr

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalpulsar
Version: 7.0.0
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
License: GPLv2+
Source0: https://software.igwn.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: bc
BuildRequires: cfitsio-devel
BuildRequires: fftw-devel
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: gsl-devel
BuildRequires: help2man >= 1.37
BuildRequires: liblal-devel >= 7.6.0
BuildRequires: liblalframe-devel >= 3.0.0
BuildRequires: liblalsimulation-devel >= 6.0.0
BuildRequires: liblalinference-devel >= 4.1.0
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.11

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: epel-rpm-macros
BuildRequires: python%{python3_pkgversion}
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-astropy
BuildRequires: python%{python3_pkgversion}-h5py
BuildRequires: python%{python3_pkgversion}-lal >= 7.6.0
BuildRequires: python%{python3_pkgversion}-lalframe >= 3.0.0
BuildRequires: python%{python3_pkgversion}-lalsimulation >= 6.0.0
BuildRequires: python%{python3_pkgversion}-lalinference >= 4.1.0
BuildRequires: python%{python3_pkgversion}-lscsoft-glue >= 1.54.1
BuildRequires: python%{python3_pkgversion}-numpy >= 1.7
BuildRequires: python%{python3_pkgversion}-pytest

# octave
BuildRequires: octave-devel
BuildRequires: lal-octave >= 7.6.0
BuildRequires: lalframe-octave >= 3.0.0
BuildRequires: lalsimulation-octave >= 6.0.0
BuildRequires: lalinference-octave >= 4.1.0

# -- packages ---------------

# lalpulsar
Summary: LVK Algorithm Pulsar Library - runtime tools
Requires: gwdatafind
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}-%{name} = %{version}-%{release}
Requires: %{name}-data
Obsoletes: python2-%{name} <= 3.0.1-1
%description
The LVK Algorithm Pulsar Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Pulsar library.

# lalpulsar-data
%package data
BuildArch: noarch
Summary: Data files for LALPulsar
%description data
The LVK Algorithm Pulsar Library for gravitational wave data analysis.
This package contains the data files needed to run various applications and
rountines that use the LAL Pulsar Library.

# liblalpulsar
%package -n lib%{name}
Summary: LVK Algorithm Simulation Library - library package
Requires: liblal >= 7.6.0
Requires: liblalframe >= 3.0.0
Requires: liblalsimulation >= 6.0.0
Requires: liblalinference >= 4.1.0
Requires: %{name}-data
Conflicts: %{name} <= 2.1.0-1
%description -n lib%{name}
The LVK Algorithm Pulsar Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Pulsar library.

# liblalpulsar-devel
%package -n lib%{name}-devel
Summary: Files and documentation needed for compiling programs that use LAL Pulsar
Requires: lib%{name} = %{version}-%{release}
Requires: cfitsio-devel
Requires: fftw-devel
Requires: gsl-devel
Requires: liblal-devel >= 7.6.0
Requires: liblalframe-devel >= 3.0.0
Requires: liblalsimulation-devel >= 6.0.0
Requires: liblalinference-devel >= 4.1.0
Provides: %{name}-devel = %{version}-%{release}
Obsoletes: %{name}-devel < 3.0.0-1
%description -n lib%{name}-devel
The LVK Algorithm Pulsar Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL
Pulsar library.

# python3x-lalpulsar
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version} bindings for LALPulsar
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-astropy
Requires: python%{python3_pkgversion}-h5py
Requires: python%{python3_pkgversion}-lal >= 7.6.0
Requires: python%{python3_pkgversion}-lalframe >= 3.0.0
Requires: python%{python3_pkgversion}-lalsimulation >= 6.0.0
Requires: python%{python3_pkgversion}-lalinference >= 4.1.0
Requires: python%{python3_pkgversion}-lscsoft-glue >= 1.54.1
Requires: python%{python3_pkgversion}-numpy >= 1.7
Obsoletes: python2-%{name} < 3.1.0-1
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
This package provides the Python %{python3_version} bindings for LALPulsar.

# lalpulsar-octave
%package octave
Summary: Octave bindings for LALPulsar
Requires: lib%{name} = %{version}-%{release}
Requires: octave
Requires: lal-octave >= 7.6.0
Requires: lalframe-octave >= 3.0.0
Requires: lalsimulation-octave >= 6.0.0
Requires: lalinference-octave >= 4.1.0
%description octave
This package provides the Octave bindings for LALPulsar.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python3}
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post -n lib%{name} -p /sbin/ldconfig

%postun -n lib%{name} -p /sbin/ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files data
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_datarootdir}/%{name}/*

%files -n lib%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_libdir}/*.so.*

%files -n lib%{name}-devel
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalpulsar.oct*

%files
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_bindir}/*
%{_mandir}/man1/*
%{_sysconfdir}/*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Aug 05 2024 Adam Mercer <adam.mercer@ligo.org> 7.0.0-1
- Update for 7.0.0

* Mon Mar 11 2024 Duncan Macleod <duncan.macleod@ligo.org> 6.1.0-1
- Update for 6.1.0

* Fri Oct 20 2023 Adam Mercer <adam.mercer@ligo.org> 6.0.6-1
- Update for 6.0.6

* Fri Oct 06 2023 Adam Mercer <adam.mercer@ligo.org> 6.0.5-1
- Update for 6.0.5

* Wed Aug 02 2023 Adam Mercer <adam.mercer@ligo.org> 6.0.4-1
- Update for 6.0.4

* Fri Jul 28 2023 Adam Mercer <adam.mercer@ligo.org> 6.0.3-1
- Update for 6.0.3

* Thu Jul 27 2023 Adam Mercer <adam.mercer@ligo.org> 6.0.2-1
- Update for 6.0.2

* Thu Apr 06 2023 Adam Mercer <adam.mercer@ligo.org> 6.0.1-1
- Update for 6.0.1

* Mon Feb 06 2023 Adam Mercer <adam.mercer@ligo.org> 6.0.0-1
- Update for 6.0.0

* Thu Nov 03 2022 Adam Mercer <adam.mercer@ligo.org> 5.2.0-1
- Update for 5.2.0

* Fri Sep 30 2022 Adam Mercer <adam.mercer@ligo.org> 5.1.1-1
- Update for 5.1.1

* Wed Sep 28 2022 Adam Mercer <adam.mercer@ligo.org> 5.1.0-1
- Update for 5.1.0

* Mon Sep 05 2022 Adam Mercer <adam.mercer@ligo.org> 5.0.2-1
- Update for 5.0.2

* Thu Aug 18 2022 Adam Mercer <adam.mercer@ligo.org> 5.0.1-1
- Update for 5.0.1

* Tue Aug 02 2022 Adam Mercer <adam.mercer@ligo.org> 5.0.0-1
- Update for 5.0.0

* Thu Mar 03 2022 Adam Mercer <adam.mercer@ligo.org> 4.0.0-1
- Update for 4.0.0

* Mon Jan 10 2022 Adam Mercer <adam.mercer@ligo.org> 3.1.2-1
- Update for 3.1.2

* Fri Dec 03 2021 Adam Mercer <adam.mercer@ligo.org> 3.1.1-1
- Update for 3.1.1

* Mon May 17 2021 Adam Mercer <adam.mercer@ligo.org> 3.1.0-1
- Update for 3.1.0

* Fri Feb 05 2021 Adam Mercer <adam.mercer@ligo.org> 3.0.1-1
- Update for 3.0.1

* Mon Jan 11 2021 Adam Mercer <adam.mercer@ligo.org> 3.0.0-1
- Update for 3.0.0

* Wed Oct 28 2020 Adam Mercer <adam.mercer@ligo.org> 2.1.0-1
- Update for 2.1.0

* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.0-1
- Update for 2.0.0

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.18.2-2
- Packaging updates

* Wed Nov 27 2019 Adam Mercer <adam.mercer@ligo.org> 1.18.2-1
- O3b release

* Tue Aug 06 2019 Adam Mercer <adam.mercer@ligo.org> 1.18.1-1
- O3 point release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.18.0-1
* O3 release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 1.17.1-1
- ER14 release

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.17.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.16.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.15.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.14.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.13.0-1
- Pre O2 packaging test release
