dnl======================================================================
dnl AX_LDAS_SYS_64BIT_OS
dnl   Check to see if 64bit binaries are to be generated
dnl======================================================================
AC_DEFUN([AX_LDAS_SYS_64BIT_OS],[dnl
  dnl ========================================================
  dnl Checking for 64-bit OS
  dnl ========================================================
  AC_LANG_PUSH(C)
  AC_MSG_CHECKING(for 64-bit OS)
  AC_TRY_RUN([
    int main () {
    if (sizeof(void*) == 8) {
      return 0;
    }
    return 1; } ],
    [result="yes"],
    [result="no"],
    [result="maybe"])
  AC_MSG_RESULT("$result")
  AS_IF([test "$result" = "yes"],[
    AC_DEFINE([HAVE_64BIT_OS],[1],[Defined if being compiled as a 64bit executable])
    HAVE_64BIT_OS=1
    AS_CASE([$build_os],dnl
            [solaris*],[dnl
	      AS_CASE([$build_cpu],
	              [x86_64],[LIB_64_DIR="/amd64"],
	              [i86pc],[LIB_64_DIR="/amd64"],
	              [i386],[LIB_64_DIR="/amd64"],
		      [sparc*],[LIB_64_DIR="/sparcv9"])
            ],
	    [linux*],[dnl
	      AS_CASE([$build_cpu],
	              [x86_64],[LIB_64_DIR="64"],
		      [LIB_64_DIR="64"])dnl AS_CASE([$build_cpu])
            ],
	    [LIB_64_DIR="64"] dnl - default
    ) dnl AS_CASE([$build_os])
  ]) dnl AS_IF
  AC_SUBST(HAVE_64BIT_OS)
  AC_SUBST([LIB_64_DIR])
  AC_LANG_POP(C)
]) dnl LDAS_SYS_64BIT_OS
