/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_TABLES_COMPOSE_H
#define LEXBOR_UNICODE_TABLES_COMPOSE_H

#ifdef __cplusplus
extern "C" {
#endif


static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750306 = {.idx = 0x750306, .cp = 0x016D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f290342 = {.idx = 0x1f290342, .cp = 0x1F2F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f080300 = {.idx = 0x1f080300, .cp = 0x1F0A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_9af09bc = {.idx = 0x9af09bc, .cp = 0x09DF, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f590300 = {.idx = 0x1f590300, .cp = 0x1F5B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0302 = {.idx = 0x4f0302, .cp = 0x00D4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6a0302 = {.idx = 0x6a0302, .cp = 0x0135, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_a1c0a3c = {.idx = 0xa1c0a3c, .cp = 0x0A5B, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b70300 = {.idx = 0x3b70300, .cp = 0x1F74, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_570300 = {.idx = 0x570300, .cp = 0x1E80, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_a80300 = {.idx = 0xa80300, .cp = 0x1FED, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5db05bc = {.idx = 0x5db05bc, .cp = 0xFB3B, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22450338 = {.idx = 0x22450338, .cp = 0x2247, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_227b0338 = {.idx = 0x227b0338, .cp = 0x2281, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_bc70bbe = {.idx = 0xbc70bbe, .cp = 0x0BCB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_41e0308 = {.idx = 0x41e0308, .cp = 0x04E6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d005b8 = {.idx = 0x5d005b8, .cp = 0xFB2F, .exclusion = true};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_470304[67] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f290342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f080300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_9af09bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f590300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f0302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6a0302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_a1c0a3c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b70300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_570300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_a80300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5db05bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22450338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_227b0338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_bc70bbe, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_41e0308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d005b8, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_470304 = {.length = 67, .nodes = lxb_unicode_nodes_comp_map_470304};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_470304 = {.idx = 0x470304, .cp = 0x1E20, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5a0307 = {.idx = 0x5a0307, .cp = 0x017B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f40309 = {.idx = 0xf40309, .cp = 0x1ED5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_64032d = {.idx = 0x64032d, .cp = 0x1E13, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f080301 = {.idx = 0x1f080301, .cp = 0x1F0C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d160d16f = {.idx = 0xd160d16f, .cp = 0x1D160, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f590301 = {.idx = 0x1f590301, .cp = 0x1F5D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_55030f = {.idx = 0x55030f, .cp = 0x0214, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b70301 = {.idx = 0x3b70301, .cp = 0x03AE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3d20301 = {.idx = 0x3d20301, .cp = 0x03D3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_570301 = {.idx = 0x570301, .cp = 0x1E82, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_720301 = {.idx = 0x720301, .cp = 0x0155, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_304f3099 = {.idx = 0x304f3099, .cp = 0x3050, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_a80301 = {.idx = 0xa80301, .cp = 0x0385, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30bb3099 = {.idx = 0x30bb3099, .cp = 0x30BC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30f13099 = {.idx = 0x30f13099, .cp = 0x30F9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_540331 = {.idx = 0x540331, .cp = 0x1E6E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_560323 = {.idx = 0x560323, .cp = 0x1E7E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b3e1b35 = {.idx = 0x1b3e1b35, .cp = 0x1B40, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f060345 = {.idx = 0x1f060345, .cp = 0x1F86, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f210345 = {.idx = 0x1f210345, .cp = 0x1F91, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_4F0303[67] = {
    {.entry = &lxb_unicode_codepoints_5a0307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f40309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_64032d, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f080301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d160d16f, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f590301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_55030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b70301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3d20301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_570301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_720301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_304f3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_a80301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30bb3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30f13099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_540331, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_560323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b3e1b35, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f060345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f210345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_4F0303 = {.length = 67, .nodes = lxb_unicode_nodes_comp_map_4F0303};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0303 = {.idx = 0x4f0303, .cp = 0x00D5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_570302 = {.idx = 0x570302, .cp = 0x0174, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d160d170 = {.idx = 0xd160d170, .cp = 0x1D161, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0304 = {.idx = 0x4f0304, .cp = 0x014C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_65030c = {.idx = 0x65030c, .cp = 0x011B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610328 = {.idx = 0x610328, .cp = 0x0105, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_21900338 = {.idx = 0x21900338, .cp = 0x219A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_470306 = {.idx = 0x470306, .cp = 0x011E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_b470b3e = {.idx = 0xb470b3e, .cp = 0x0B4B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a50314 = {.idx = 0x3a50314, .cp = 0x1F59, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_224d0338 = {.idx = 0x224d0338, .cp = 0x226D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3bf0300 = {.idx = 0x3bf0300, .cp = 0x1F78, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f310342 = {.idx = 0x1f310342, .cp = 0x1F37, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f100300 = {.idx = 0x1f100300, .cp = 0x1F12, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e305bc = {.idx = 0x5e305bc, .cp = 0xFB43, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_92f093c = {.idx = 0x92f093c, .cp = 0x095F, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c50342 = {.idx = 0x3c50342, .cp = 0x1FE6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f610300 = {.idx = 0x1f610300, .cp = 0x1F63, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d60304 = {.idx = 0xd60304, .cp = 0x022A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22830338 = {.idx = 0x22830338, .cp = 0x2285, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750308 = {.idx = 0x750308, .cp = 0x00FC, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_3C0338[61] = {
    {.entry = &lxb_unicode_codepoints_570302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d160d170, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f0304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_65030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610328, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_21900338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_470306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_b470b3e, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a50314, .table = NULL},
    {.entry = &lxb_unicode_codepoints_224d0338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3bf0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f310342, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f100300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e305bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_92f093c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c50342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f610300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d60304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22830338, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_3C0338 = {.length = 61, .nodes = lxb_unicode_nodes_comp_map_3C0338};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c0338 = {.idx = 0x3c0338, .cp = 0x226E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_19361931 = {.idx = 0x19361931, .cp = 0x11938, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e0327 = {.idx = 0x4e0327, .cp = 0x0145, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30573099 = {.idx = 0x30573099, .cp = 0x3058, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_e60301 = {.idx = 0xe60301, .cp = 0x01FD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d160d171 = {.idx = 0xd160d171, .cp = 0x1D162, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550311 = {.idx = 0x550311, .cp = 0x0216, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3bf0301 = {.idx = 0x3bf0301, .cp = 0x03CC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5db05bf = {.idx = 0x5db05bf, .cp = 0xFB4D, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_7a0301 = {.idx = 0x7a0301, .cp = 0x017A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_790323 = {.idx = 0x790323, .cp = 0x1EF5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f290345 = {.idx = 0x1f290345, .cp = 0x1F99, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f100301 = {.idx = 0x1f100301, .cp = 0x1F14, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750309 = {.idx = 0x750309, .cp = 0x1EE7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f0e0345 = {.idx = 0x1f0e0345, .cp = 0x1F8E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f610301 = {.idx = 0x1f610301, .cp = 0x1F65, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30723099 = {.idx = 0x30723099, .cp = 0x3073, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_620307 = {.idx = 0x620307, .cp = 0x1E03, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6c032d = {.idx = 0x6c032d, .cp = 0x1E3D, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_470307[89] = {
    {.entry = &lxb_unicode_codepoints_19361931, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e0327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30573099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_e60301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d160d171, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550311, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3bf0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5db05bf, .table = NULL},
    {.entry = &lxb_unicode_codepoints_7a0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_790323, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f290345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f100301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f0e0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f610301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30723099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_620307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6c032d, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_470307 = {.length = 89, .nodes = lxb_unicode_nodes_comp_map_470307};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_470307 = {.idx = 0x470307, .cp = 0x0120, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d005bc = {.idx = 0x5d005bc, .cp = 0xFB30, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f180300 = {.idx = 0x1f180300, .cp = 0x1F1A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3910300 = {.idx = 0x3910300, .cp = 0x1FBA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_52030c = {.idx = 0x52030c, .cp = 0x0158, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_91c093c = {.idx = 0x91c093c, .cp = 0x095B, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4230304 = {.idx = 0x4230304, .cp = 0x04EE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f390342 = {.idx = 0x1f390342, .cp = 0x1F3F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690328 = {.idx = 0x690328, .cp = 0x012F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0306 = {.idx = 0x4f0306, .cp = 0x014E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f690300 = {.idx = 0x1f690300, .cp = 0x1F6B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_75030a = {.idx = 0x75030a, .cp = 0x016F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4180300 = {.idx = 0x4180300, .cp = 0x040D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_b210b3c = {.idx = 0xb210b3c, .cp = 0x0B5C, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d160d172 = {.idx = 0xd160d172, .cp = 0x1D163, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3072309a = {.idx = 0x3072309a, .cp = 0x3074, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4360306 = {.idx = 0x4360306, .cp = 0x04C2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_7a0302 = {.idx = 0x7a0302, .cp = 0x1E91, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_490330[101] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d005bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f180300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3910300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_52030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_91c093c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4230304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f390342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690328, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f0306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f690300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_75030a, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4180300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_b210b3c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d160d172, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3072309a, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4360306, .table = NULL},
    {.entry = &lxb_unicode_codepoints_7a0302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_490330 = {.length = 101, .nodes = lxb_unicode_nodes_comp_map_490330};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490330 = {.idx = 0x490330, .cp = 0x1E2C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_75030b = {.idx = 0x75030b, .cp = 0x0171, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_640331 = {.idx = 0x640331, .cp = 0x1E0F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_14ba14bb = {.idx = 0x14ba14bb, .cp = 0x114BB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1348133f = {.idx = 0x1348133f, .cp = 0x1134B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d160d173 = {.idx = 0xd160d173, .cp = 0x1D164, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_b920bd7 = {.idx = 0xb920bd7, .cp = 0x0B94, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f670345 = {.idx = 0x1f670345, .cp = 0x1FA7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0307 = {.idx = 0x4f0307, .cp = 0x022E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b50313 = {.idx = 0x3b50313, .cp = 0x1F10, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_74032d = {.idx = 0x74032d, .cp = 0x1E71, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f180301 = {.idx = 0x1f180301, .cp = 0x1F1C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f690301 = {.idx = 0x1f690301, .cp = 0x1F6D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3910301 = {.idx = 0x3910301, .cp = 0x0386, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_65030f = {.idx = 0x65030f, .cp = 0x0205, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4c0301 = {.idx = 0x4c0301, .cp = 0x0139, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_670301 = {.idx = 0x670301, .cp = 0x01F5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_305f3099 = {.idx = 0x305f3099, .cp = 0x3060, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4330301 = {.idx = 0x4330301, .cp = 0x0453, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_4B0323[67] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_75030b, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_640331, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_14ba14bb, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1348133f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d160d173, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_b920bd7, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f670345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f0307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b50313, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_74032d, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f180301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f690301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3910301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_65030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4c0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_670301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_305f3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4330301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_4B0323 = {.length = 67, .nodes = lxb_unicode_nodes_comp_map_4B0323};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4b0323 = {.idx = 0x4b0323, .cp = 0x1E32, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b50314 = {.idx = 0x3b50314, .cp = 0x1F11, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4360308 = {.idx = 0x4360308, .cp = 0x04DD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fc030c = {.idx = 0xfc030c, .cp = 0x01DA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4230306 = {.idx = 0x4230306, .cp = 0x040E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_75030c = {.idx = 0x75030c, .cp = 0x01D4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d805bc = {.idx = 0x5d805bc, .cp = 0xFB38, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4d80308 = {.idx = 0x4d80308, .cp = 0x04DA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ffe0342 = {.idx = 0x1ffe0342, .cp = 0x1FDF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0300 = {.idx = 0x6f0300, .cp = 0x00F2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3990300 = {.idx = 0x3990300, .cp = 0x1FDA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_e60304 = {.idx = 0xe60304, .cp = 0x01E3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_670302 = {.idx = 0x670302, .cp = 0x011D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f200300 = {.idx = 0x1f200300, .cp = 0x1F22, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5a030c = {.idx = 0x5a030c, .cp = 0x017D, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_4F0308[37] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b50314, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4360308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fc030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4230306, .table = NULL},
    {.entry = &lxb_unicode_codepoints_75030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d805bc, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4d80308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ffe0342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3990300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_e60304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_670302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f200300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5a030c, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_4F0308 = {.length = 37, .nodes = lxb_unicode_nodes_comp_map_4F0308};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0308 = {.idx = 0x4f0308, .cp = 0x00D6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_530323 = {.idx = 0x530323, .cp = 0x1E62, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f200301 = {.idx = 0x1f200301, .cp = 0x1F24, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f6f0345 = {.idx = 0x1f6f0345, .cp = 0x1FAF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3990301 = {.idx = 0x3990301, .cp = 0x038A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_52030f = {.idx = 0x52030f, .cp = 0x0210, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0301 = {.idx = 0x6f0301, .cp = 0x00F3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650311 = {.idx = 0x650311, .cp = 0x0207, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6e0323 = {.idx = 0x6e0323, .cp = 0x1E47, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3970345 = {.idx = 0x3970345, .cp = 0x1FCC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ff60345 = {.idx = 0x1ff60345, .cp = 0x1FF7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0309 = {.idx = 0x4f0309, .cp = 0x1ECE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_309d3099 = {.idx = 0x309d3099, .cp = 0x309E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6c0331 = {.idx = 0x6c0331, .cp = 0x1E3B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_570307 = {.idx = 0x570307, .cp = 0x1E86, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b051b35 = {.idx = 0x1b051b35, .cp = 0x1B06, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f4c0fb7 = {.idx = 0xf4c0fb7, .cp = 0x0F4D, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_720307 = {.idx = 0x720307, .cp = 0x1E59, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f030345 = {.idx = 0x1f030345, .cp = 0x1F83, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_430327[53] = {
    {.entry = &lxb_unicode_codepoints_530323, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f200301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f6f0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3990301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_52030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650311, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6e0323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3970345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ff60345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f0309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_309d3099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6c0331, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_570307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b051b35, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f4c0fb7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_720307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f030345, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_430327 = {.length = 53, .nodes = lxb_unicode_nodes_comp_map_430327};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_430327 = {.idx = 0x430327, .cp = 0x00C7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_47030c = {.idx = 0x47030c, .cp = 0x01E6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f710f72 = {.idx = 0xf710f72, .cp = 0x0F73, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_570308 = {.idx = 0x570308, .cp = 0x1E84, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22650338 = {.idx = 0x22650338, .cp = 0x2271, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_670304 = {.idx = 0x670304, .cp = 0x1E21, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d1bbd166 = {.idx = 0xd1bbd166, .cp = 0x1D1BC, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4100306 = {.idx = 0x4100306, .cp = 0x04D0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0302 = {.idx = 0x6f0302, .cp = 0x00F4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4180304 = {.idx = 0x4180304, .cp = 0x04E2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_770300 = {.idx = 0x770300, .cp = 0x1E81, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1e5b0304 = {.idx = 0x1e5b0304, .cp = 0x1E5D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4230308 = {.idx = 0x4230308, .cp = 0x04F0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3d20308 = {.idx = 0x3d20308, .cp = 0x03D4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_9c709be = {.idx = 0x9c709be, .cp = 0x09CB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3910304 = {.idx = 0x3910304, .cp = 0x1FB9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f280300 = {.idx = 0x1f280300, .cp = 0x1F2A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_14ba14be = {.idx = 0x14ba14be, .cp = 0x114BE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_43e0308 = {.idx = 0x43e0308, .cp = 0x04E7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1a00300 = {.idx = 0x1a00300, .cp = 0x1EDC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e005bc = {.idx = 0x5e005bc, .cp = 0xFB40, .exclusion = true};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410300[85] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_47030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f710f72, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_570308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22650338, .table = NULL},
    {.entry = &lxb_unicode_codepoints_670304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d1bbd166, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4100306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4180304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_770300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1e5b0304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4230308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3d20308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_9c709be, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3910304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f280300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_14ba14be, .table = NULL},
    {.entry = &lxb_unicode_codepoints_43e0308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1a00300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e005bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410300 = {.length = 85, .nodes = lxb_unicode_nodes_comp_map_410300};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410300 = {.idx = 0x410300, .cp = 0x00C0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_770301 = {.idx = 0x770301, .cp = 0x1E83, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_760323 = {.idx = 0x760323, .cp = 0x1E7F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d505b9 = {.idx = 0x5d505b9, .cp = 0xFB4B, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_75030f = {.idx = 0x75030f, .cp = 0x0215, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c50313 = {.idx = 0x3c50313, .cp = 0x1F50, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_740331 = {.idx = 0x740331, .cp = 0x1E6F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_440307 = {.idx = 0x440307, .cp = 0x1E0A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f0b0345 = {.idx = 0x1f0b0345, .cp = 0x1F8B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1a00301 = {.idx = 0x1a00301, .cp = 0x1EDA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_520311 = {.idx = 0x520311, .cp = 0x0212, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f280301 = {.idx = 0x1f280301, .cp = 0x1F2C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0303 = {.idx = 0x6f0303, .cp = 0x00F5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30db3099 = {.idx = 0x30db3099, .cp = 0x30DC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f260345 = {.idx = 0x1f260345, .cp = 0x1F96, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f030b = {.idx = 0x4f030b, .cp = 0x0150, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_306f3099 = {.idx = 0x306f3099, .cp = 0x3070, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e032d = {.idx = 0x4e032d, .cp = 0x1E4A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b0d1b35 = {.idx = 0x1b0d1b35, .cp = 0x1B0E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_7a0307 = {.idx = 0x7a0307, .cp = 0x017C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4b0327 = {.idx = 0x4b0327, .cp = 0x0136, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410301[55] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_770301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_760323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d505b9, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_75030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c50313, .table = NULL},
    {.entry = &lxb_unicode_codepoints_740331, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_440307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f0b0345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1a00301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_520311, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f280301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0303, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30db3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f260345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f030b, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_306f3099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e032d, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b0d1b35, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_7a0307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4b0327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410301 = {.length = 55, .nodes = lxb_unicode_nodes_comp_map_410301};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410301 = {.idx = 0x410301, .cp = 0x00C1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_306f309a = {.idx = 0x306f309a, .cp = 0x3071, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ea10302 = {.idx = 0x1ea10302, .cp = 0x1EAD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0304 = {.idx = 0x6f0304, .cp = 0x014D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30db309a = {.idx = 0x30db309a, .cp = 0x30DD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_2add0338 = {.idx = 0x2add0338, .cp = 0x2ADC, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_9a109bc = {.idx = 0x9a109bc, .cp = 0x09DC, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f60304 = {.idx = 0xf60304, .cp = 0x022B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a90300 = {.idx = 0x3a90300, .cp = 0x1FFA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_670306 = {.idx = 0x670306, .cp = 0x011F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4150300 = {.idx = 0x4150300, .cp = 0x0400, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f000342 = {.idx = 0x1f000342, .cp = 0x1F06, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f510342 = {.idx = 0x1f510342, .cp = 0x1F57, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e805bc = {.idx = 0x5e805bc, .cp = 0xFB48, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_15b915b0 = {.idx = 0x15b915b0, .cp = 0x115BA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3990304 = {.idx = 0x3990304, .cp = 0x1FD9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3ca0342 = {.idx = 0x3ca0342, .cp = 0x1FD7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3910306 = {.idx = 0x3910306, .cp = 0x1FB8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f030c = {.idx = 0x4f030c, .cp = 0x01D1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6a030c = {.idx = 0x6a030c, .cp = 0x01F0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490300 = {.idx = 0x490300, .cp = 0x00CC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4180306 = {.idx = 0x4180306, .cp = 0x0419, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_530326 = {.idx = 0x530326, .cp = 0x0218, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c50314 = {.idx = 0x3c50314, .cp = 0x1F51, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f710f74 = {.idx = 0xf710f74, .cp = 0x0F75, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4100308 = {.idx = 0x4100308, .cp = 0x04D2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_42b0308 = {.idx = 0x42b0308, .cp = 0x04F8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_770302 = {.idx = 0x770302, .cp = 0x0175, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f300300 = {.idx = 0x1f300300, .cp = 0x1F32, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e80308 = {.idx = 0x4e80308, .cp = 0x04EA, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410302[139] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_306f309a, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ea10302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0304, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30db309a, .table = NULL},
    {.entry = &lxb_unicode_codepoints_2add0338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_9a109bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f60304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a90300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_670306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4150300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f000342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f510342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e805bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_15b915b0, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3990304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3ca0342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3910306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6a030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_490300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4180306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_530326, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c50314, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f710f74, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4100308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_42b0308, .table = NULL},
    {.entry = &lxb_unicode_codepoints_770302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f300300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e80308, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410302 = {.length = 139, .nodes = lxb_unicode_nodes_comp_map_410302};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410302 = {.idx = 0x410302, .cp = 0x00C2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f920fb7 = {.idx = 0xf920fb7, .cp = 0x0F93, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_480323 = {.idx = 0x480323, .cp = 0x1E24, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_15a0307 = {.idx = 0x15a0307, .cp = 0x1E64, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f300301 = {.idx = 0x1f300301, .cp = 0x1F34, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1a00303 = {.idx = 0x1a00303, .cp = 0x1EE0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_670307 = {.idx = 0x670307, .cp = 0x0121, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3970313 = {.idx = 0x3970313, .cp = 0x1F28, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30c83099 = {.idx = 0x30c83099, .cp = 0x30C9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a90301 = {.idx = 0x3a90301, .cp = 0x038F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6e0327 = {.idx = 0x6e0327, .cp = 0x0146, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_423030b = {.idx = 0x423030b, .cp = 0x04F2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f2e0345 = {.idx = 0x1f2e0345, .cp = 0x1F9E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30ad3099 = {.idx = 0x30ad3099, .cp = 0x30AE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490301 = {.idx = 0x490301, .cp = 0x00CD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_530327 = {.idx = 0x530327, .cp = 0x015E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750311 = {.idx = 0x750311, .cp = 0x0217, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f640345 = {.idx = 0x1f640345, .cp = 0x1FA4, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410303[65] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f920fb7, .table = NULL},
    {.entry = &lxb_unicode_codepoints_480323, .table = NULL},
    {.entry = &lxb_unicode_codepoints_15a0307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f300301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1a00303, .table = NULL},
    {.entry = &lxb_unicode_codepoints_670307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3970313, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30c83099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a90301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6e0327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_423030b, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f2e0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30ad3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_490301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_530327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750311, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f640345, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410303 = {.length = 65, .nodes = lxb_unicode_nodes_comp_map_410303};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410303 = {.idx = 0x410303, .cp = 0x00C3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b10300 = {.idx = 0x3b10300, .cp = 0x1F70, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0306 = {.idx = 0x6f0306, .cp = 0x014F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4380300 = {.idx = 0x4380300, .cp = 0x045D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f080342 = {.idx = 0x1f080342, .cp = 0x1F0E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_2270304 = {.idx = 0x2270304, .cp = 0x01E1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f590342 = {.idx = 0x1f590342, .cp = 0x1F5F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d505bc = {.idx = 0x5d505bc, .cp = 0xFB35, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b70342 = {.idx = 0x3b70342, .cp = 0x1FC6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_a160a3c = {.idx = 0xa160a3c, .cp = 0x0A59, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4430304 = {.idx = 0x4430304, .cp = 0x04EF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_921093c = {.idx = 0x921093c, .cp = 0x095C, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690330 = {.idx = 0x690330, .cp = 0x1E2D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3990306 = {.idx = 0x3990306, .cp = 0x1FD8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_72030c = {.idx = 0x72030c, .cp = 0x0159, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3970314 = {.idx = 0x3970314, .cp = 0x1F29, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6d50654 = {.idx = 0x6d50654, .cp = 0x06C0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490302 = {.idx = 0x490302, .cp = 0x00CE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4180308 = {.idx = 0x4180308, .cp = 0x04E4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b00300 = {.idx = 0x1b00300, .cp = 0x1EEB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f380300 = {.idx = 0x1f380300, .cp = 0x1F3A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22ab0338 = {.idx = 0x22ab0338, .cp = 0x22AF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1fbf0300 = {.idx = 0x1fbf0300, .cp = 0x1FCD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_a80342 = {.idx = 0xa80342, .cp = 0x1FC1, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410304[139] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b10300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4380300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f080342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_2270304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f590342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d505bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b70342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_a160a3c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4430304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_921093c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690330, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3990306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_72030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3970314, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6d50654, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_490302, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4180308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b00300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f380300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22ab0338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1fbf0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_a80342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410304 = {.length = 139, .nodes = lxb_unicode_nodes_comp_map_410304};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410304 = {.idx = 0x410304, .cp = 0x0100, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0307 = {.idx = 0x6f0307, .cp = 0x022F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f6c0345 = {.idx = 0x1f6c0345, .cp = 0x1FAC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f380301 = {.idx = 0x1f380301, .cp = 0x1F3C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d80301 = {.idx = 0xd80301, .cp = 0x01FE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_55031b = {.idx = 0x55031b, .cp = 0x01AF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1e630307 = {.idx = 0x1e630307, .cp = 0x1E69, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_cca0cd5 = {.idx = 0xcca0cd5, .cp = 0x0CCB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_109a10bb = {.idx = 0x109a10bb, .cp = 0x1109A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f030f = {.idx = 0x4f030f, .cp = 0x020C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b10301 = {.idx = 0x3b10301, .cp = 0x03AC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f000345 = {.idx = 0x1f000345, .cp = 0x1F80, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b00301 = {.idx = 0x1b00301, .cp = 0x1EE9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30643099 = {.idx = 0x30643099, .cp = 0x3065, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_39f0313 = {.idx = 0x39f0313, .cp = 0x1F48, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6c0301 = {.idx = 0x6c0301, .cp = 0x013A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e0331 = {.idx = 0x4e0331, .cp = 0x1E48, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1af0323 = {.idx = 0x1af0323, .cp = 0x1EF0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_540307 = {.idx = 0x540307, .cp = 0x1E6A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1fbf0301 = {.idx = 0x1fbf0301, .cp = 0x1FCE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6b0323 = {.idx = 0x6b0323, .cp = 0x1E33, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30b53099 = {.idx = 0x30b53099, .cp = 0x30B6, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_490303[77] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f6c0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f380301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d80301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_55031b, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1e630307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_cca0cd5, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_109a10bb, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b10301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f000345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b00301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30643099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_39f0313, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6c0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e0331, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1af0323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_540307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1fbf0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6b0323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30b53099, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_490303 = {.length = 77, .nodes = lxb_unicode_nodes_comp_map_490303};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490303 = {.idx = 0x490303, .cp = 0x0128, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ecc0302 = {.idx = 0x1ecc0302, .cp = 0x1ED8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4560308 = {.idx = 0x4560308, .cp = 0x0457, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d460d3e = {.idx = 0xd460d3e, .cp = 0x0D4A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4430306 = {.idx = 0x4430306, .cp = 0x045E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22b30338 = {.idx = 0x22b30338, .cp = 0x22EB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_39f0314 = {.idx = 0x39f0314, .cp = 0x1F49, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22f0304 = {.idx = 0x22f0304, .cp = 0x0231, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b90300 = {.idx = 0x3b90300, .cp = 0x1F76, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_44030c = {.idx = 0x44030c, .cp = 0x010E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_14c0300 = {.idx = 0x14c0300, .cp = 0x1E50, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ea10306 = {.idx = 0x1ea10306, .cp = 0x1EB7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_590300 = {.idx = 0x590300, .cp = 0x1EF2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_227d0338 = {.idx = 0x227d0338, .cp = 0x22E1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0308 = {.idx = 0x6f0308, .cp = 0x00F6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_7a030c = {.idx = 0x7a030c, .cp = 0x017E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f610342 = {.idx = 0x1f610342, .cp = 0x1F67, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f400300 = {.idx = 0x1f400300, .cp = 0x1F42, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3990308 = {.idx = 0x3990308, .cp = 0x03AA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490304 = {.idx = 0x490304, .cp = 0x012A, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410306[61] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ecc0302, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4560308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d460d3e, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4430306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22b30338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_39f0314, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22f0304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b90300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_44030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_14c0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ea10306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_590300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_227d0338, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_7a030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f610342, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f400300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3990308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_490304, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410306 = {.length = 61, .nodes = lxb_unicode_nodes_comp_map_410306};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410306 = {.idx = 0x410306, .cp = 0x0102, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_730323 = {.idx = 0x730323, .cp = 0x1E63, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_14c0301 = {.idx = 0x14c0301, .cp = 0x1E52, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b90301 = {.idx = 0x3b90301, .cp = 0x03AF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0311 = {.idx = 0x4f0311, .cp = 0x020E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f080345 = {.idx = 0x1f080345, .cp = 0x1F88, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f230345 = {.idx = 0x1f230345, .cp = 0x1F93, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30513099 = {.idx = 0x30513099, .cp = 0x3052, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f740345 = {.idx = 0x1f740345, .cp = 0x1FC2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30bd3099 = {.idx = 0x30bd3099, .cp = 0x30BE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30d83099 = {.idx = 0x30d83099, .cp = 0x30D9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b00303 = {.idx = 0x1b00303, .cp = 0x1EEF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_474030f = {.idx = 0x474030f, .cp = 0x0476, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_480327 = {.idx = 0x480327, .cp = 0x1E28, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f400301 = {.idx = 0x1f400301, .cp = 0x1F44, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_630327 = {.idx = 0x630327, .cp = 0x00E7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_770307 = {.idx = 0x770307, .cp = 0x1E87, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_590301 = {.idx = 0x590301, .cp = 0x00DD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b70345 = {.idx = 0x3b70345, .cp = 0x1FC3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f510fb7 = {.idx = 0xf510fb7, .cp = 0x0F52, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_c50301 = {.idx = 0xc50301, .cp = 0x01FA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_72030f = {.idx = 0x72030f, .cp = 0x0211, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0309 = {.idx = 0x6f0309, .cp = 0x1ECF, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410307[113] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_730323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_14c0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b90301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f0311, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f080345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f230345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30513099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f740345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30bd3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30d83099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b00303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_474030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_480327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f400301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_630327, .table = NULL},
    {.entry = &lxb_unicode_codepoints_770307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_590301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b70345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f510fb7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_c50301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_72030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410307 = {.length = 113, .nodes = lxb_unicode_nodes_comp_map_410307};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410307 = {.idx = 0x410307, .cp = 0x0226, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4c030c = {.idx = 0x4c030c, .cp = 0x013D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b10304 = {.idx = 0x3b10304, .cp = 0x1FB1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4300306 = {.idx = 0x4300306, .cp = 0x04D1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_21920338 = {.idx = 0x21920338, .cp = 0x219B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610300 = {.idx = 0x610300, .cp = 0x00E0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1030300 = {.idx = 0x1030300, .cp = 0x1EB1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_67030c = {.idx = 0x67030c, .cp = 0x01E7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1eb90302 = {.idx = 0x1eb90302, .cp = 0x1EC7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490306 = {.idx = 0x490306, .cp = 0x012C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_770308 = {.idx = 0x770308, .cp = 0x1E85, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30d8309a = {.idx = 0x30d8309a, .cp = 0x30DA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_16a0308 = {.idx = 0x16a0308, .cp = 0x1E7A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_590302 = {.idx = 0x590302, .cp = 0x0176, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f690342 = {.idx = 0x1f690342, .cp = 0x1F6F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f480300 = {.idx = 0x1f480300, .cp = 0x1F4A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4380304 = {.idx = 0x4380304, .cp = 0x04E3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_ddc0dca = {.idx = 0xddc0dca, .cp = 0x0DDD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4150306 = {.idx = 0x4150306, .cp = 0x04D6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_916093c = {.idx = 0x916093c, .cp = 0x0959, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410308 = {.idx = 0x410308, .cp = 0x00C4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4430308 = {.idx = 0x4430308, .cp = 0x04F1, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_3E0338[35] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4c030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b10304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4300306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_21920338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1030300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_67030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1eb90302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_490306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_770308, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30d8309a, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_16a0308, .table = NULL},
    {.entry = &lxb_unicode_codepoints_590302, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f690342, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f480300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4380304, .table = NULL},
    {.entry = &lxb_unicode_codepoints_ddc0dca, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4150306, .table = NULL},
    {.entry = &lxb_unicode_codepoints_916093c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_410308, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4430308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_3E0338 = {.length = 35, .nodes = lxb_unicode_nodes_comp_map_3E0338};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3e0338 = {.idx = 0x3e0338, .cp = 0x226F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f7c0345 = {.idx = 0x1f7c0345, .cp = 0x1FF2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_590303 = {.idx = 0x590303, .cp = 0x1EF8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490307 = {.idx = 0x490307, .cp = 0x0130, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30593099 = {.idx = 0x30593099, .cp = 0x305A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_640307 = {.idx = 0x640307, .cp = 0x1E0B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f2b0345 = {.idx = 0x1f2b0345, .cp = 0x1F9B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450323 = {.idx = 0x450323, .cp = 0x1EB8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_720311 = {.idx = 0x720311, .cp = 0x0213, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f480301 = {.idx = 0x1f480301, .cp = 0x1F4C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1a00309 = {.idx = 0x1a00309, .cp = 0x1EDE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610301 = {.idx = 0x610301, .cp = 0x00E1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f030b = {.idx = 0x6f030b, .cp = 0x0151, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6e032d = {.idx = 0x6e032d, .cp = 0x1E4B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_cbf0cd5 = {.idx = 0xcbf0cd5, .cp = 0x0CC0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f610345 = {.idx = 0x1f610345, .cp = 0x1FA1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1030301 = {.idx = 0x1030301, .cp = 0x1EAF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6b0327 = {.idx = 0x6b0327, .cp = 0x0137, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410309[55] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f7c0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_590303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_490307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30593099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_640307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f2b0345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_450323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_720311, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f480301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1a00309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f030b, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6e032d, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_cbf0cd5, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f610345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1030301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6b0327, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410309 = {.length = 55, .nodes = lxb_unicode_nodes_comp_map_410309};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410309 = {.idx = 0x410309, .cp = 0x1EA2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_590304 = {.idx = 0x590304, .cp = 0x0232, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_21d00338 = {.idx = 0x21d00338, .cp = 0x21CD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_223c0338 = {.idx = 0x223c0338, .cp = 0x2241, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4150308 = {.idx = 0x4150308, .cp = 0x0401, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22720338 = {.idx = 0x22720338, .cp = 0x2274, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4300308 = {.idx = 0x4300308, .cp = 0x04D3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_44b0308 = {.idx = 0x44b0308, .cp = 0x04F9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22a80338 = {.idx = 0x22a80338, .cp = 0x22AD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c90300 = {.idx = 0x3c90300, .cp = 0x1F7C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4350300 = {.idx = 0x4350300, .cp = 0x0450, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490308 = {.idx = 0x490308, .cp = 0x00CF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_730326 = {.idx = 0x730326, .cp = 0x0219, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f200342 = {.idx = 0x1f200342, .cp = 0x1F26, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e0300 = {.idx = 0x4e0300, .cp = 0x01F8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690300 = {.idx = 0x690300, .cp = 0x00EC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fb20f80 = {.idx = 0xfb20f80, .cp = 0x0F76, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_77030a = {.idx = 0x77030a, .cp = 0x1E98, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b90304 = {.idx = 0x3b90304, .cp = 0x1FD1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6d20654 = {.idx = 0x6d20654, .cp = 0x06D3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f500300 = {.idx = 0x1f500300, .cp = 0x1F52, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610302 = {.idx = 0x610302, .cp = 0x00E2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_54030c = {.idx = 0x54030c, .cp = 0x0164, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f030c = {.idx = 0x6f030c, .cp = 0x01D2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d205bc = {.idx = 0x5d205bc, .cp = 0xFB32, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b10306 = {.idx = 0x3b10306, .cp = 0x1FB0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4380306 = {.idx = 0x4380306, .cp = 0x0439, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_41030A[95] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_590304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_21d00338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_223c0338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4150308, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22720338, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4300308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_44b0308, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22a80338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c90300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4350300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_490308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_730326, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f200342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fb20f80, .table = NULL},
    {.entry = &lxb_unicode_codepoints_77030a, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b90304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6d20654, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f500300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_54030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d205bc, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b10306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4380306, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_41030A = {.length = 95, .nodes = lxb_unicode_nodes_comp_map_41030A};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_41030a = {.idx = 0x41030a, .cp = 0x00C5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d50301 = {.idx = 0xd50301, .cp = 0x1E4C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3ac0345 = {.idx = 0x3ac0345, .cp = 0x1FB4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_680323 = {.idx = 0x680323, .cp = 0x1E25, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3910345 = {.idx = 0x3910345, .cp = 0x1FBC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4b0331 = {.idx = 0x4b0331, .cp = 0x1E34, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4d0323 = {.idx = 0x4d0323, .cp = 0x1E42, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_41a0301 = {.idx = 0x41a0301, .cp = 0x040C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f690345 = {.idx = 0x1f690345, .cp = 0x1FA9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1030303 = {.idx = 0x1030303, .cp = 0x1EB5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690301 = {.idx = 0x690301, .cp = 0x00ED, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e0301 = {.idx = 0x4e0301, .cp = 0x0143, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c90301 = {.idx = 0x3c90301, .cp = 0x03CE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_443030b = {.idx = 0x443030b, .cp = 0x04F3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30613099 = {.idx = 0x30613099, .cp = 0x3062, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610303 = {.idx = 0x610303, .cp = 0x00E3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30463099 = {.idx = 0x30463099, .cp = 0x3094, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f500301 = {.idx = 0x1f500301, .cp = 0x1F54, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_730327 = {.idx = 0x730327, .cp = 0x015F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b70313 = {.idx = 0x3b70313, .cp = 0x1F20, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_490309[83] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d50301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3ac0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_680323, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3910345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4b0331, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4d0323, .table = NULL},
    {.entry = &lxb_unicode_codepoints_41a0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f690345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1030303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e0301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c90301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_443030b, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30613099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30463099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f500301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_730327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b70313, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_490309 = {.length = 83, .nodes = lxb_unicode_nodes_comp_map_490309};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490309 = {.idx = 0x490309, .cp = 0x1EC8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_cc60cc2 = {.idx = 0xcc60cc2, .cp = 0x0CCA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_227a0338 = {.idx = 0x227a0338, .cp = 0x2280, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_bc60bbe = {.idx = 0xbc60bbe, .cp = 0x0BCA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f280342 = {.idx = 0x1f280342, .cp = 0x1F2E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1130300 = {.idx = 0x1130300, .cp = 0x1E15, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5da05bc = {.idx = 0x5da05bc, .cp = 0xFB3A, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4380308 = {.idx = 0x4380308, .cp = 0x04E5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b90306 = {.idx = 0x3b90306, .cp = 0x1FD0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690302 = {.idx = 0x690302, .cp = 0x00EE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b70314 = {.idx = 0x3b70314, .cp = 0x1F21, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_c20300 = {.idx = 0xc20300, .cp = 0x1EA6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610304 = {.idx = 0x610304, .cp = 0x0101, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_41030C[43] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_cc60cc2, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_227a0338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_bc60bbe, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f280342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1130300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5da05bc, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4380308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b90306, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b70314, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_c20300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610304, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_41030C = {.length = 43, .nodes = lxb_unicode_nodes_comp_map_41030C};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_41030c = {.idx = 0x41030c, .cp = 0x01CD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30d53099 = {.idx = 0x30d53099, .cp = 0x30D6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f200345 = {.idx = 0x1f200345, .cp = 0x1F90, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f050345 = {.idx = 0x1f050345, .cp = 0x1F85, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5f205b7 = {.idx = 0x5f205b7, .cp = 0xFB1F, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690303 = {.idx = 0x690303, .cp = 0x0129, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e0303 = {.idx = 0x4e0303, .cp = 0x00D1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b00309 = {.idx = 0x1b00309, .cp = 0x1EED, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1130301 = {.idx = 0x1130301, .cp = 0x1E17, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b071b35 = {.idx = 0x1b071b35, .cp = 0x1B08, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3bf0313 = {.idx = 0x3bf0313, .cp = 0x1F40, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_75031b = {.idx = 0x75031b, .cp = 0x01B0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f80301 = {.idx = 0xf80301, .cp = 0x01FF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6e0331 = {.idx = 0x6e0331, .cp = 0x1E49, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_c20301 = {.idx = 0xc20301, .cp = 0x1EA4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_740307 = {.idx = 0x740307, .cp = 0x1E6B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550323 = {.idx = 0x550323, .cp = 0x1EE4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_590307 = {.idx = 0x590307, .cp = 0x1E8E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30f03099 = {.idx = 0x30f03099, .cp = 0x30F8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f030f = {.idx = 0x6f030f, .cp = 0x020D, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_450327[83] = {
    {.entry = &lxb_unicode_codepoints_30d53099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f200345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f050345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5f205b7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e0303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b00309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1130301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b071b35, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3bf0313, .table = NULL},
    {.entry = &lxb_unicode_codepoints_75031b, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f80301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6e0331, .table = NULL},
    {.entry = &lxb_unicode_codepoints_c20301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_740307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_590307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30f03099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_450327 = {.length = 83, .nodes = lxb_unicode_nodes_comp_map_450327};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450327 = {.idx = 0x450327, .cp = 0x0228, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690304 = {.idx = 0x690304, .cp = 0x012B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30d5309a = {.idx = 0x30d5309a, .cp = 0x30D7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550324 = {.idx = 0x550324, .cp = 0x1E72, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d50304 = {.idx = 0xd50304, .cp = 0x022C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b90308 = {.idx = 0x3b90308, .cp = 0x03CA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_ca0300 = {.idx = 0xca0300, .cp = 0x1EC0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f710f80 = {.idx = 0xf710f80, .cp = 0x0F81, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_49030c = {.idx = 0x49030c, .cp = 0x01CF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_48032e = {.idx = 0x48032e, .cp = 0x1E2A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_790300 = {.idx = 0x790300, .cp = 0x1EF3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_dd90dca = {.idx = 0xdd90dca, .cp = 0x0DDA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3bf0314 = {.idx = 0x3bf0314, .cp = 0x1F41, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_64030c = {.idx = 0x64030c, .cp = 0x010F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22820338 = {.idx = 0x22820338, .cp = 0x2284, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_590308 = {.idx = 0x590308, .cp = 0x0178, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f300342 = {.idx = 0x1f300342, .cp = 0x1F36, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f600300 = {.idx = 0x1f600300, .cp = 0x1F62, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610306 = {.idx = 0x610306, .cp = 0x0103, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_740308 = {.idx = 0x740308, .cp = 0x1E97, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_450328[53] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690304, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30d5309a, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550324, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d50304, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b90308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_ca0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f710f80, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_49030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_48032e, .table = NULL},
    {.entry = &lxb_unicode_codepoints_790300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_dd90dca, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3bf0314, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_64030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22820338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_590308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f300342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f600300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_740308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_450328 = {.length = 53, .nodes = lxb_unicode_nodes_comp_map_450328};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450328 = {.idx = 0x450328, .cp = 0x0118, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3910313 = {.idx = 0x3910313, .cp = 0x1F08, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_e50301 = {.idx = 0xe50301, .cp = 0x01FB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_790301 = {.idx = 0x790301, .cp = 0x00FD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f280345 = {.idx = 0x1f280345, .cp = 0x1F98, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f600301 = {.idx = 0x1f600301, .cp = 0x1F64, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_ca0301 = {.idx = 0xca0301, .cp = 0x1EBE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1a10323 = {.idx = 0x1a10323, .cp = 0x1EE3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f0d0345 = {.idx = 0x1f0d0345, .cp = 0x1F8D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_c20303 = {.idx = 0xc20303, .cp = 0x1EAA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_560303 = {.idx = 0x560303, .cp = 0x1E7C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610307 = {.idx = 0x610307, .cp = 0x0227, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_680327 = {.idx = 0x680327, .cp = 0x1E29, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_430301 = {.idx = 0x430301, .cp = 0x0106, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_590309 = {.idx = 0x590309, .cp = 0x1EF6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f560fb7 = {.idx = 0xf560fb7, .cp = 0x0F57, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0311 = {.idx = 0x6f0311, .cp = 0x020F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_460307 = {.idx = 0x460307, .cp = 0x1E1E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_420323 = {.idx = 0x420323, .cp = 0x1E04, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_41030F[61] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3910313, .table = NULL},
    {.entry = &lxb_unicode_codepoints_e50301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_790301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f280345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f600301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_ca0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1a10323, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f0d0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_c20303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_560303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_680327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_430301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_590309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f560fb7, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0311, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_460307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_420323, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_41030F = {.length = 61, .nodes = lxb_unicode_nodes_comp_map_41030F};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_41030f = {.idx = 0x41030f, .cp = 0x0200, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3910314 = {.idx = 0x3910314, .cp = 0x1F09, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d159d166 = {.idx = 0xd159d166, .cp = 0x1D15F, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610308 = {.idx = 0x610308, .cp = 0x00E4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_42d0308 = {.idx = 0x42d0308, .cp = 0x04EC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6480654 = {.idx = 0x6480654, .cp = 0x0624, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690306 = {.idx = 0x690306, .cp = 0x012D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f380342 = {.idx = 0x1f380342, .cp = 0x1F3E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4350306 = {.idx = 0x4350306, .cp = 0x04D7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1fbf0342 = {.idx = 0x1fbf0342, .cp = 0x1FCF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f680300 = {.idx = 0x1f680300, .cp = 0x1F6A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b10342 = {.idx = 0x3b10342, .cp = 0x1FB6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_790302 = {.idx = 0x790302, .cp = 0x0177, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_a2b0a3c = {.idx = 0xa2b0a3c, .cp = 0x0A5E, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6c030c = {.idx = 0x6c030c, .cp = 0x013E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1eb0304 = {.idx = 0x1eb0304, .cp = 0x01ED, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22030338 = {.idx = 0x22030338, .cp = 0x2204, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5ea05bc = {.idx = 0x5ea05bc, .cp = 0xFB4A, .exclusion = true};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_430302[67] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3910314, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d159d166, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_42d0308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6480654, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f380342, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4350306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1fbf0342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f680300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b10342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_790302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_a2b0a3c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6c030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1eb0304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22030338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5ea05bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_430302 = {.length = 67, .nodes = lxb_unicode_nodes_comp_map_430302};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_430302 = {.idx = 0x430302, .cp = 0x0108, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e0307 = {.idx = 0x4e0307, .cp = 0x1E44, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610309 = {.idx = 0x610309, .cp = 0x1EA3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30af3099 = {.idx = 0x30af3099, .cp = 0x30B0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650323 = {.idx = 0x650323, .cp = 0x1EB9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a90345 = {.idx = 0x3a90345, .cp = 0x1FFC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f680301 = {.idx = 0x1f680301, .cp = 0x1F6C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f660345 = {.idx = 0x1f660345, .cp = 0x1FA6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4b0301 = {.idx = 0x4b0301, .cp = 0x1E30, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_790303 = {.idx = 0x790303, .cp = 0x1EF9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f031b = {.idx = 0x4f031b, .cp = 0x01A0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1030309 = {.idx = 0x1030309, .cp = 0x1EB3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3990313 = {.idx = 0x3990313, .cp = 0x1F38, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_ca0303 = {.idx = 0xca0303, .cp = 0x1EC4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_49030f = {.idx = 0x49030f, .cp = 0x0208, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410311[31] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e0307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30af3099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650323, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a90345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f680301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f660345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4b0301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_790303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f031b, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1030309, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3990313, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_ca0303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_49030f, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410311 = {.length = 31, .nodes = lxb_unicode_nodes_comp_map_410311};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410311 = {.idx = 0x410311, .cp = 0x0202, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_74030c = {.idx = 0x74030c, .cp = 0x0165, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22920338 = {.idx = 0x22920338, .cp = 0x22E3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690308 = {.idx = 0x690308, .cp = 0x00EF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d50308 = {.idx = 0xd50308, .cp = 0x1E4E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b90342 = {.idx = 0x3b90342, .cp = 0x1FD6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3990314 = {.idx = 0x3990314, .cp = 0x1F39, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_790304 = {.idx = 0x790304, .cp = 0x0233, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6e0300 = {.idx = 0x6e0300, .cp = 0x01F9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4350308 = {.idx = 0x4350308, .cp = 0x0451, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_220b0338 = {.idx = 0x220b0338, .cp = 0x220C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22770338 = {.idx = 0x22770338, .cp = 0x2279, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_61030a = {.idx = 0x61030a, .cp = 0x00E5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_b470b56 = {.idx = 0xb470b56, .cp = 0x0B48, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1e370304 = {.idx = 0x1e370304, .cp = 0x1E39, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_550328[53] = {
    {.entry = &lxb_unicode_codepoints_74030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22920338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d50308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b90342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3990314, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_790304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6e0300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4350308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_220b0338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22770338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_61030a, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_b470b56, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1e370304, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_550328 = {.length = 53, .nodes = lxb_unicode_nodes_comp_map_550328};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550328 = {.idx = 0x550328, .cp = 0x0172, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f020345 = {.idx = 0x1f020345, .cp = 0x1F82, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_304b3099 = {.idx = 0x304b3099, .cp = 0x304C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30663099 = {.idx = 0x30663099, .cp = 0x3067, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f6e0345 = {.idx = 0x1f6e0345, .cp = 0x1FAE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_b470b57 = {.idx = 0xb470b57, .cp = 0x0B4C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30b73099 = {.idx = 0x30b73099, .cp = 0x30B8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30d23099 = {.idx = 0x30d23099, .cp = 0x30D3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b3a1b35 = {.idx = 0x1b3a1b35, .cp = 0x1B3B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_520323 = {.idx = 0x520323, .cp = 0x1E5A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6d0323 = {.idx = 0x6d0323, .cp = 0x1E43, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f9c0fb7 = {.idx = 0xf9c0fb7, .cp = 0x0F9D, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_109c10bb = {.idx = 0x109c10bb, .cp = 0x1109C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490311 = {.idx = 0x490311, .cp = 0x020A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b10345 = {.idx = 0x3b10345, .cp = 0x1FB3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_43a0301 = {.idx = 0x43a0301, .cp = 0x045C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690309 = {.idx = 0x690309, .cp = 0x1EC9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_17f0307 = {.idx = 0x17f0307, .cp = 0x1E9B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_dd90dcf = {.idx = 0xdd90dcf, .cp = 0x0DDC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6b0331 = {.idx = 0x6b0331, .cp = 0x1E35, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_530301 = {.idx = 0x530301, .cp = 0x015A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6e0301 = {.idx = 0x6e0301, .cp = 0x0144, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f50301 = {.idx = 0xf50301, .cp = 0x1E4D, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_45032D[95] = {
    {.entry = &lxb_unicode_codepoints_1f020345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_304b3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30663099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f6e0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_b470b57, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30b73099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30d23099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b3a1b35, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_520323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6d0323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f9c0fb7, .table = NULL},
    {.entry = &lxb_unicode_codepoints_109c10bb, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_490311, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b10345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_43a0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690309, .table = NULL},
    {.entry = &lxb_unicode_codepoints_17f0307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_dd90dcf, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6b0331, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_530301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6e0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f50301, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_45032D = {.length = 95, .nodes = lxb_unicode_nodes_comp_map_45032D};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_45032d = {.idx = 0x45032d, .cp = 0x1E18, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_92b093c = {.idx = 0x92b093c, .cp = 0x095E, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22640338 = {.idx = 0x22640338, .cp = 0x2270, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_2290306 = {.idx = 0x2290306, .cp = 0x1E1D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d1bad166 = {.idx = 0xd1bad166, .cp = 0x1D1BB, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1e5a0304 = {.idx = 0x1e5a0304, .cp = 0x1E5C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22b50338 = {.idx = 0x22b50338, .cp = 0x22ED, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_61030c = {.idx = 0x61030c, .cp = 0x01CE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30d2309a = {.idx = 0x30d2309a, .cp = 0x30D4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_e20300 = {.idx = 0xe20300, .cp = 0x1EA7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a10314 = {.idx = 0x3a10314, .cp = 0x1FEC, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_530302[19] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_92b093c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22640338, .table = NULL},
    {.entry = &lxb_unicode_codepoints_2290306, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d1bad166, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1e5a0304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22b50338, .table = NULL},
    {.entry = &lxb_unicode_codepoints_61030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30d2309a, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_e20300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a10314, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_530302 = {.length = 19, .nodes = lxb_unicode_nodes_comp_map_530302};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_530302 = {.idx = 0x530302, .cp = 0x015C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b421b35 = {.idx = 0x1b421b35, .cp = 0x1B43, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30bf3099 = {.idx = 0x30bf3099, .cp = 0x30C0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f400fb5 = {.idx = 0xf400fb5, .cp = 0x0F69, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a90313 = {.idx = 0x3a90313, .cp = 0x1F68, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1690301 = {.idx = 0x1690301, .cp = 0x1E79, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f0a0345 = {.idx = 0x1f0a0345, .cp = 0x1F8A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6e0303 = {.idx = 0x6e0303, .cp = 0x00F1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_c70301 = {.idx = 0xc70301, .cp = 0x1E08, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_c20309 = {.idx = 0xc20309, .cp = 0x1EA8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5a0323 = {.idx = 0x5a0323, .cp = 0x1E92, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_790307 = {.idx = 0x790307, .cp = 0x1E8F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f250345 = {.idx = 0x1f250345, .cp = 0x1F95, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650327 = {.idx = 0x650327, .cp = 0x0229, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_e20301 = {.idx = 0xe20301, .cp = 0x1EA5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750323 = {.idx = 0x750323, .cp = 0x1EE5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30533099 = {.idx = 0x30533099, .cp = 0x3054, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_430307[85] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b421b35, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30bf3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f400fb5, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a90313, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1690301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f0a0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6e0303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_c70301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_c20309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5a0323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_790307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f250345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_e20301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30533099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_430307 = {.length = 85, .nodes = lxb_unicode_nodes_comp_map_430307};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_430307 = {.idx = 0x430307, .cp = 0x010A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_21940338 = {.idx = 0x21940338, .cp = 0x21AE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c90342 = {.idx = 0x3c90342, .cp = 0x1FF6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_13481358 = {.idx = 0x13481358, .cp = 0x1134C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e030c = {.idx = 0x4e030c, .cp = 0x0147, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f50304 = {.idx = 0xf50304, .cp = 0x022D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_69030c = {.idx = 0x69030c, .cp = 0x01D0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ea00302 = {.idx = 0x1ea00302, .cp = 0x1EAC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22870338 = {.idx = 0x22870338, .cp = 0x2289, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22a20338 = {.idx = 0x22a20338, .cp = 0x22AC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e705bc = {.idx = 0x5e705bc, .cp = 0xFB47, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_ea0300 = {.idx = 0xea0300, .cp = 0x1EC1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_68032e = {.idx = 0x68032e, .cp = 0x1E2B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_933093c = {.idx = 0x933093c, .cp = 0x0934, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650328 = {.idx = 0x650328, .cp = 0x0119, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_790308 = {.idx = 0x790308, .cp = 0x00FF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f500342 = {.idx = 0x1f500342, .cp = 0x1F56, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a90314 = {.idx = 0x3a90314, .cp = 0x1F69, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750324 = {.idx = 0x750324, .cp = 0x1E73, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_450330[113] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_21940338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c90342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_13481358, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f50304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_69030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ea00302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22870338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22a20338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e705bc, .table = NULL},
    {.entry = &lxb_unicode_codepoints_ea0300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_68032e, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_933093c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650328, .table = NULL},
    {.entry = &lxb_unicode_codepoints_790308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f500342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a90314, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750324, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_450330 = {.length = 113, .nodes = lxb_unicode_nodes_comp_map_450330};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450330 = {.idx = 0x450330, .cp = 0x1E1A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f630345 = {.idx = 0x1f630345, .cp = 0x1FA3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d1bdd16f = {.idx = 0xd1bdd16f, .cp = 0x1D1BE, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_790309 = {.idx = 0x790309, .cp = 0x1EF7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_e20303 = {.idx = 0xe20303, .cp = 0x1EAB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_305b3099 = {.idx = 0x305b3099, .cp = 0x305C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_760303 = {.idx = 0x760303, .cp = 0x1E7D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_660307 = {.idx = 0x660307, .cp = 0x1E1F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f2d0345 = {.idx = 0x1f2d0345, .cp = 0x1F9D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_cf0301 = {.idx = 0xcf0301, .cp = 0x1E2E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_55032d = {.idx = 0x55032d, .cp = 0x1E76, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30fd3099 = {.idx = 0x30fd3099, .cp = 0x30FE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_630301 = {.idx = 0x630301, .cp = 0x0107, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f5b0fb7 = {.idx = 0xf5b0fb7, .cp = 0x0F5C, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_620323 = {.idx = 0x620323, .cp = 0x1E05, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_ea0301 = {.idx = 0xea0301, .cp = 0x1EBF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_61030f = {.idx = 0x61030f, .cp = 0x0201, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b10313 = {.idx = 0x3b10313, .cp = 0x1F00, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_ca0309 = {.idx = 0xca0309, .cp = 0x1EC2, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_520327[55] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f630345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d1bdd16f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_790309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_e20303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_305b3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_760303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_660307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f2d0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_cf0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_55032d, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30fd3099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_630301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f5b0fb7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_620323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_ea0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_61030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b10313, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_ca0309, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_520327 = {.length = 55, .nodes = lxb_unicode_nodes_comp_map_520327};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_520327 = {.idx = 0x520327, .cp = 0x0156, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_44d0308 = {.idx = 0x44d0308, .cp = 0x04ED, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3cb0300 = {.idx = 0x3cb0300, .cp = 0x1FE2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_2260304 = {.idx = 0x2260304, .cp = 0x01E0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1af0300 = {.idx = 0x1af0300, .cp = 0x1EEA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d905b4 = {.idx = 0x5d905b4, .cp = 0xFB1D, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_21d20338 = {.idx = 0x21d20338, .cp = 0x21CF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_11331128 = {.idx = 0x11331128, .cp = 0x1112F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d405bc = {.idx = 0x5d405bc, .cp = 0xFB34, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22230338 = {.idx = 0x22230338, .cp = 0x2224, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4170308 = {.idx = 0x4170308, .cp = 0x04DE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3950300 = {.idx = 0x3950300, .cp = 0x1FC8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d1bdd170 = {.idx = 0xd1bdd170, .cp = 0x1D1C0, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b10314 = {.idx = 0x3b10314, .cp = 0x1F01, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_79030a = {.idx = 0x79030a, .cp = 0x1E99, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22080338 = {.idx = 0x22080338, .cp = 0x2209, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_630302 = {.idx = 0x630302, .cp = 0x0109, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f010300 = {.idx = 0x1f010300, .cp = 0x1F03, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_480302[91] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_44d0308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3cb0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_2260304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1af0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d905b4, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_21d20338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_11331128, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d405bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22230338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4170308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3950300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d1bdd170, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b10314, .table = NULL},
    {.entry = &lxb_unicode_codepoints_79030a, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22080338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_630302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f010300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_480302 = {.length = 91, .nodes = lxb_unicode_nodes_comp_map_480302};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_480302 = {.idx = 0x480302, .cp = 0x0124, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_500301 = {.idx = 0x500301, .cp = 0x1E54, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3cb0301 = {.idx = 0x3cb0301, .cp = 0x03B0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_680331 = {.idx = 0x680331, .cp = 0x1E96, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6b0301 = {.idx = 0x6b0301, .cp = 0x1E31, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1e620307 = {.idx = 0x1e620307, .cp = 0x1E68, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_69030f = {.idx = 0x69030f, .cp = 0x0209, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f031b = {.idx = 0x6f031b, .cp = 0x01A1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f010301 = {.idx = 0x1f010301, .cp = 0x1F05, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610311 = {.idx = 0x610311, .cp = 0x0203, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b90313 = {.idx = 0x3b90313, .cp = 0x1F30, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f6b0345 = {.idx = 0x1f6b0345, .cp = 0x1FAB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_530307 = {.idx = 0x530307, .cp = 0x1E60, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30cf3099 = {.idx = 0x30cf3099, .cp = 0x30D0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3ae0345 = {.idx = 0x3ae0345, .cp = 0x1FC4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1af0301 = {.idx = 0x1af0301, .cp = 0x1EE8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6e0307 = {.idx = 0x6e0307, .cp = 0x1E45, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c90345 = {.idx = 0x3c90345, .cp = 0x1FF3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1610307 = {.idx = 0x1610307, .cp = 0x1E67, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3950301 = {.idx = 0x3950301, .cp = 0x0388, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_ea0303 = {.idx = 0xea0303, .cp = 0x1EC5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_9c709d7 = {.idx = 0x9c709d7, .cp = 0x09CC, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_4F0323[107] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_500301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3cb0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_680331, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6b0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1e620307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_69030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f031b, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f010301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610311, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b90313, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f6b0345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_530307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30cf3099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3ae0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1af0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6e0307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c90345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1610307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3950301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_ea0303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_9c709d7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_4F0323 = {.length = 107, .nodes = lxb_unicode_nodes_comp_map_4F0323};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0323 = {.idx = 0x4f0323, .cp = 0x1ECC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b90314 = {.idx = 0x3b90314, .cp = 0x1F31, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_928093c = {.idx = 0x928093c, .cp = 0x0929, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f50308 = {.idx = 0xf50308, .cp = 0x1E4F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6c10654 = {.idx = 0x6c10654, .cp = 0x06C2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f600342 = {.idx = 0x1f600342, .cp = 0x1F66, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f090300 = {.idx = 0x1f090300, .cp = 0x1F0B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750328 = {.idx = 0x750328, .cp = 0x0173, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_a380a3c = {.idx = 0xa380a3c, .cp = 0x0A36, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30cf309a = {.idx = 0x30cf309a, .cp = 0x30D1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ea00306 = {.idx = 0x1ea00306, .cp = 0x1EB6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5dc05bc = {.idx = 0x5dc05bc, .cp = 0xFB3C, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22e0304 = {.idx = 0x22e0304, .cp = 0x0230, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550330 = {.idx = 0x550330, .cp = 0x1E74, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22610338 = {.idx = 0x22610338, .cp = 0x2262, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_227c0338 = {.idx = 0x227c0338, .cp = 0x22E0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22b20338 = {.idx = 0x22b20338, .cp = 0x22EA, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_43030C[67] = {
    {.entry = &lxb_unicode_codepoints_3b90314, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_928093c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f50308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6c10654, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f600342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f090300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750328, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_a380a3c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30cf309a, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ea00306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5dc05bc, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22e0304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550330, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22610338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_227c0338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22b20338, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_43030C = {.length = 67, .nodes = lxb_unicode_nodes_comp_map_43030C};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_43030c = {.idx = 0x43030c, .cp = 0x010C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_570323 = {.idx = 0x570323, .cp = 0x1E88, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f090301 = {.idx = 0x1f090301, .cp = 0x1F0D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b091b35 = {.idx = 0x1b091b35, .cp = 0x1B0A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1af0303 = {.idx = 0x1af0303, .cp = 0x1EEE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b3f1b35 = {.idx = 0x1b3f1b35, .cp = 0x1B41, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f070345 = {.idx = 0x1f070345, .cp = 0x1F87, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fa10fb7 = {.idx = 0xfa10fb7, .cp = 0x0FA2, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_730301 = {.idx = 0x730301, .cp = 0x015B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690311 = {.idx = 0x690311, .cp = 0x020B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30f23099 = {.idx = 0x30f23099, .cp = 0x30FA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_720323 = {.idx = 0x720323, .cp = 0x1E5B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_65032d = {.idx = 0x65032d, .cp = 0x1E19, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6270653 = {.idx = 0x6270653, .cp = 0x0622, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c10313 = {.idx = 0x3c10313, .cp = 0x1FE4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f220345 = {.idx = 0x1f220345, .cp = 0x1F92, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_470327[76] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_570323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f090301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b091b35, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1af0303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b3f1b35, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f070345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fa10fb7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_730301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690311, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30f23099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_720323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_65032d, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6270653, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c10313, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f220345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_470327 = {.length = 76, .nodes = lxb_unicode_nodes_comp_map_470327};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_470327 = {.idx = 0x470327, .cp = 0x0122, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4b030c = {.idx = 0x4b030c, .cp = 0x01E8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6270654 = {.idx = 0x6270654, .cp = 0x0623, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_915093c = {.idx = 0x915093c, .cp = 0x0958, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450300 = {.idx = 0x450300, .cp = 0x00C8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f680342 = {.idx = 0x1f680342, .cp = 0x1F6E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e405bc = {.idx = 0x5e405bc, .cp = 0xFB44, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1eb80302 = {.idx = 0x1eb80302, .cp = 0x1EC6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_730302 = {.idx = 0x730302, .cp = 0x015D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a50300 = {.idx = 0x3a50300, .cp = 0x1FEA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f110300 = {.idx = 0x1f110300, .cp = 0x1F13, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c10314 = {.idx = 0x3c10314, .cp = 0x1FE5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_930093c = {.idx = 0x930093c, .cp = 0x0931, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1020300 = {.idx = 0x1020300, .cp = 0x1EB0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4270308 = {.idx = 0x4270308, .cp = 0x04F4, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_3D0338[43] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4b030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6270654, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_915093c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_450300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f680342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e405bc, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1eb80302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_730302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a50300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f110300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c10314, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_930093c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1020300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4270308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_3D0338 = {.length = 43, .nodes = lxb_unicode_nodes_comp_map_3D0338};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3d0338 = {.idx = 0x3d0338, .cp = 0x2260, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b111b35 = {.idx = 0x1b111b35, .cp = 0x1B12, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_e70301 = {.idx = 0xe70301, .cp = 0x1E09, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6270655 = {.idx = 0x6270655, .cp = 0x0625, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f600345 = {.idx = 0x1f600345, .cp = 0x1FA0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_7a0323 = {.idx = 0x7a0323, .cp = 0x1E93, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1020301 = {.idx = 0x1020301, .cp = 0x1EAE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c90313 = {.idx = 0x3c90313, .cp = 0x1F60, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_e20309 = {.idx = 0xe20309, .cp = 0x1EA9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f110301 = {.idx = 0x1f110301, .cp = 0x1F15, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30c43099 = {.idx = 0x30c43099, .cp = 0x30C5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_480307 = {.idx = 0x480307, .cp = 0x1E22, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f0f0345 = {.idx = 0x1f0f0345, .cp = 0x1F8F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a50301 = {.idx = 0x3a50301, .cp = 0x038E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450301 = {.idx = 0x450301, .cp = 0x00C9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_630307 = {.idx = 0x630307, .cp = 0x010B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f2a0345 = {.idx = 0x1f2a0345, .cp = 0x1F9A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_440323 = {.idx = 0x440323, .cp = 0x1E0C, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_420331[55] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b111b35, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_e70301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6270655, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f600345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_7a0323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1020301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c90313, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_e20309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f110301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30c43099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_480307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f0f0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a50301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_450301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_630307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f2a0345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_440323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_420331 = {.length = 55, .nodes = lxb_unicode_nodes_comp_map_420331};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_420331 = {.idx = 0x420331, .cp = 0x1E06, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_64a0654 = {.idx = 0x64a0654, .cp = 0x0626, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0328 = {.idx = 0x4f0328, .cp = 0x01EA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6e030c = {.idx = 0x6e030c, .cp = 0x0148, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f190300 = {.idx = 0x1f190300, .cp = 0x1F1B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d105bc = {.idx = 0x5d105bc, .cp = 0xFB31, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d40300 = {.idx = 0xd40300, .cp = 0x1ED2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_53030c = {.idx = 0x53030c, .cp = 0x0160, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_c40304 = {.idx = 0xc40304, .cp = 0x01DE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_b220b3c = {.idx = 0xb220b3c, .cp = 0x0B5D, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_480308 = {.idx = 0x480308, .cp = 0x1E26, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650330 = {.idx = 0x650330, .cp = 0x1E1B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c90314 = {.idx = 0x3c90314, .cp = 0x1F61, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_450302[31] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_64a0654, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f0328, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6e030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f190300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d105bc, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d40300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_53030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_c40304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_b220b3c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_480308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650330, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c90314, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_450302 = {.length = 31, .nodes = lxb_unicode_nodes_comp_map_450302};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450302 = {.idx = 0x450302, .cp = 0x00CA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30b13099 = {.idx = 0x30b13099, .cp = 0x30B2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_75032d = {.idx = 0x75032d, .cp = 0x1E77, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4d0301 = {.idx = 0x4d0301, .cp = 0x1E3E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_ea0309 = {.idx = 0xea0309, .cp = 0x1EC3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4c0323 = {.idx = 0x4c0323, .cp = 0x1E36, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f190301 = {.idx = 0x1f190301, .cp = 0x1F1D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f680345 = {.idx = 0x1f680345, .cp = 0x1FA8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e405bf = {.idx = 0x5e405bf, .cp = 0xFB4E, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_720327 = {.idx = 0x720327, .cp = 0x0157, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_307b3099 = {.idx = 0x307b3099, .cp = 0x307C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d40301 = {.idx = 0xd40301, .cp = 0x1ED0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_cc60cd5 = {.idx = 0xcc60cd5, .cp = 0x0CC7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d460d57 = {.idx = 0xd460d57, .cp = 0x0D4C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_ef0301 = {.idx = 0xef0301, .cp = 0x1E2F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1020303 = {.idx = 0x1020303, .cp = 0x1EB4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_500307 = {.idx = 0x500307, .cp = 0x1E56, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fb4905c1 = {.idx = 0xfb4905c1, .cp = 0xFB2C, .exclusion = true};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_450303[53] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30b13099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_75032d, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4d0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_ea0309, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4c0323, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f190301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f680345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e405bf, .table = NULL},
    {.entry = &lxb_unicode_codepoints_720327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_307b3099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d40301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_cc60cd5, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d460d57, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_ef0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1020303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_500307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fb4905c1, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_450303 = {.length = 53, .nodes = lxb_unicode_nodes_comp_map_450303};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450303 = {.idx = 0x450303, .cp = 0x1EBC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b50300 = {.idx = 0x3b50300, .cp = 0x1F72, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f210300 = {.idx = 0x1f210300, .cp = 0x1F23, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1120300 = {.idx = 0x1120300, .cp = 0x1E14, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4370308 = {.idx = 0x4370308, .cp = 0x04DF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fb4905c2 = {.idx = 0xfb4905c2, .cp = 0xFB2D, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4d90308 = {.idx = 0x4d90308, .cp = 0x04DB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_307b309a = {.idx = 0x307b309a, .cp = 0x307D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_680302 = {.idx = 0x680302, .cp = 0x0125, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550300 = {.idx = 0x550300, .cp = 0x00D9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d905bc = {.idx = 0x5d905bc, .cp = 0xFB39, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a50304 = {.idx = 0x3a50304, .cp = 0x1FE9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_292030c = {.idx = 0x292030c, .cp = 0x01EF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22430338 = {.idx = 0x22430338, .cp = 0x2244, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_dc0300 = {.idx = 0xdc0300, .cp = 0x01DB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_cc60cd6 = {.idx = 0xcc60cd6, .cp = 0x0CC8, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_450304[49] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b50300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f210300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1120300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4370308, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fb4905c2, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4d90308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_307b309a, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_680302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d905bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a50304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_292030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22430338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_dc0300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_cc60cd6, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_450304 = {.length = 49, .nodes = lxb_unicode_nodes_comp_map_450304};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450304 = {.idx = 0x450304, .cp = 0x0112, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f700345 = {.idx = 0x1f700345, .cp = 0x1FB2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_580307 = {.idx = 0x580307, .cp = 0x1E8A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_dc0301 = {.idx = 0xdc0301, .cp = 0x01D7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_730307 = {.idx = 0x730307, .cp = 0x1E61, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30ef3099 = {.idx = 0x30ef3099, .cp = 0x30F7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3ce0345 = {.idx = 0x3ce0345, .cp = 0x1FF4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d40303 = {.idx = 0xd40303, .cp = 0x1ED6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_540323 = {.idx = 0x540323, .cp = 0x1E6C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1120301 = {.idx = 0x1120301, .cp = 0x1E16, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b3c1b35 = {.idx = 0x1b3c1b35, .cp = 0x1B3D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d105bf = {.idx = 0x5d105bf, .cp = 0xFB4C, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3b50301 = {.idx = 0x3b50301, .cp = 0x03AD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_304d3099 = {.idx = 0x304d3099, .cp = 0x304E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0323 = {.idx = 0x6f0323, .cp = 0x1ECD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_520331 = {.idx = 0x520331, .cp = 0x1E5E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550301 = {.idx = 0x550301, .cp = 0x00DA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f040345 = {.idx = 0x1f040345, .cp = 0x1F84, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30683099 = {.idx = 0x30683099, .cp = 0x3069, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_700301 = {.idx = 0x700301, .cp = 0x1E55, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1af0309 = {.idx = 0x1af0309, .cp = 0x1EEC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30b93099 = {.idx = 0x30b93099, .cp = 0x30BA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f210301 = {.idx = 0x1f210301, .cp = 0x1F25, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_440327[107] = {
    {.entry = &lxb_unicode_codepoints_1f700345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_580307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_dc0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_730307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30ef3099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3ce0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d40303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_540323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1120301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b3c1b35, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d105bf, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3b50301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_304d3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_520331, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f040345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30683099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_700301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1af0309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30b93099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f210301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_440327 = {.length = 107, .nodes = lxb_unicode_nodes_comp_map_440327};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_440327 = {.idx = 0x440327, .cp = 0x1E10, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a50306 = {.idx = 0x3a50306, .cp = 0x1FE8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550302 = {.idx = 0x550302, .cp = 0x00DB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f290300 = {.idx = 0x1f290300, .cp = 0x1F2B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e105bc = {.idx = 0x5e105bc, .cp = 0xFB41, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_63030c = {.idx = 0x63030c, .cp = 0x010D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_c460c56 = {.idx = 0xc460c56, .cp = 0x0C48, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1a10300 = {.idx = 0x1a10300, .cp = 0x1EDD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_580308 = {.idx = 0x580308, .cp = 0x1E8C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_48030c = {.idx = 0x48030c, .cp = 0x021E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750330 = {.idx = 0x750330, .cp = 0x1E75, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_450306[31] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a50306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f290300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e105bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_63030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_c460c56, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1a10300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_580308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_48030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750330, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_450306 = {.length = 31, .nodes = lxb_unicode_nodes_comp_map_450306};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450306 = {.idx = 0x450306, .cp = 0x0114, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f270345 = {.idx = 0x1f270345, .cp = 0x1F97, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_770323 = {.idx = 0x770323, .cp = 0x1E89, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450307 = {.idx = 0x450307, .cp = 0x0116, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30a63099 = {.idx = 0x30a63099, .cp = 0x30F4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fa60fb7 = {.idx = 0xfa60fb7, .cp = 0x0FA7, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4c0327 = {.idx = 0x4c0327, .cp = 0x013B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30553099 = {.idx = 0x30553099, .cp = 0x3056, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_10a610bb = {.idx = 0x10a610bb, .cp = 0x110AB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550303 = {.idx = 0x550303, .cp = 0x0168, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30c13099 = {.idx = 0x30c13099, .cp = 0x30C2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_670327 = {.idx = 0x670327, .cp = 0x0123, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f0c0345 = {.idx = 0x1f0c0345, .cp = 0x1F8C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f290301 = {.idx = 0x1f290301, .cp = 0x1F2D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1a10301 = {.idx = 0x1a10301, .cp = 0x1EDB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_dd90ddf = {.idx = 0xdd90ddf, .cp = 0x0DDE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1a00323 = {.idx = 0x1a00323, .cp = 0x1EE2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5a0331 = {.idx = 0x5a0331, .cp = 0x1E94, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410323[53] = {
    {.entry = &lxb_unicode_codepoints_1f270345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_770323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_450307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30a63099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fa60fb7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4c0327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30553099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_10a610bb, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550303, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30c13099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_670327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f0c0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f290301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1a10301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_dd90ddf, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1a00323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5a0331, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410323 = {.length = 53, .nodes = lxb_unicode_nodes_comp_map_410323};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410323 = {.idx = 0x410323, .cp = 0x1EA0, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_540326 = {.idx = 0x540326, .cp = 0x021A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_dc0304 = {.idx = 0xdc0304, .cp = 0x01D5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f310300 = {.idx = 0x1f310300, .cp = 0x1F33, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550304 = {.idx = 0x550304, .cp = 0x016A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_9a209bc = {.idx = 0x9a209bc, .cp = 0x09DD, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650300 = {.idx = 0x650300, .cp = 0x00E8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3a50308 = {.idx = 0x3a50308, .cp = 0x03AB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c50300 = {.idx = 0x3c50300, .cp = 0x1F7A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e905bc = {.idx = 0x5e905bc, .cp = 0xFB49, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_15ba15b0 = {.idx = 0x15ba15b0, .cp = 0x115BB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4470308 = {.idx = 0x4470308, .cp = 0x04F5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f010342 = {.idx = 0x1f010342, .cp = 0x1F07, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d158d166 = {.idx = 0xd158d166, .cp = 0x1D15E, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3cb0342 = {.idx = 0x3cb0342, .cp = 0x1FE7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6b030c = {.idx = 0x6b030c, .cp = 0x01E9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e90308 = {.idx = 0x4e90308, .cp = 0x04EB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ea0304 = {.idx = 0x1ea0304, .cp = 0x01EC, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_450308[79] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_540326, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_dc0304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f310300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_9a209bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3a50308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c50300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e905bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_15ba15b0, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4470308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f010342, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d158d166, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3cb0342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6b030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e90308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ea0304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_450308 = {.length = 79, .nodes = lxb_unicode_nodes_comp_map_450308};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450308 = {.idx = 0x450308, .cp = 0x00CB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f310301 = {.idx = 0x1f310301, .cp = 0x1F35, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450309 = {.idx = 0x450309, .cp = 0x1EBA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_620331 = {.idx = 0x620331, .cp = 0x1E07, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f2f0345 = {.idx = 0x1f2f0345, .cp = 0x1F9F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4d0307 = {.idx = 0x4d0307, .cp = 0x1E40, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c50301 = {.idx = 0x3c50301, .cp = 0x03CD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f420fb7 = {.idx = 0xf420fb7, .cp = 0x0F43, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_bc60bd7 = {.idx = 0xbc60bd7, .cp = 0x0BCC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1fb60345 = {.idx = 0x1fb60345, .cp = 0x1FB7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_680307 = {.idx = 0x680307, .cp = 0x1E23, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_540327 = {.idx = 0x540327, .cp = 0x0162, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_305d3099 = {.idx = 0x305d3099, .cp = 0x305E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490323 = {.idx = 0x490323, .cp = 0x1ECA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f650345 = {.idx = 0x1f650345, .cp = 0x1FA5, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1a10303 = {.idx = 0x1a10303, .cp = 0x1EE1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650301 = {.idx = 0x650301, .cp = 0x00E9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30783099 = {.idx = 0x30783099, .cp = 0x3079, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_15b0307 = {.idx = 0x15b0307, .cp = 0x1E65, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1020309 = {.idx = 0x1020309, .cp = 0x1EB2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_640323 = {.idx = 0x640323, .cp = 0x1E0D, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410325[53] = {
    {.entry = &lxb_unicode_codepoints_1f310301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_450309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_620331, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f2f0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4d0307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c50301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f420fb7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_bc60bd7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1fb60345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_680307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_540327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_305d3099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_490323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f650345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1a10303, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30783099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_15b0307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1020309, .table = NULL},
    {.entry = &lxb_unicode_codepoints_640323, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410325 = {.length = 53, .nodes = lxb_unicode_nodes_comp_map_410325};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410325 = {.idx = 0x410325, .cp = 0x1E00, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6f0328 = {.idx = 0x6f0328, .cp = 0x01EB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_21d40338 = {.idx = 0x21d40338, .cp = 0x21CE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22250338 = {.idx = 0x22250338, .cp = 0x2226, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22760338 = {.idx = 0x22760338, .cp = 0x2278, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3970300 = {.idx = 0x3970300, .cp = 0x1FCA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f390300 = {.idx = 0x1f390300, .cp = 0x1F3B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d605bc = {.idx = 0x5d605bc, .cp = 0xFB36, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_e40304 = {.idx = 0xe40304, .cp = 0x01DF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_922093c = {.idx = 0x922093c, .cp = 0x095D, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22910338 = {.idx = 0x22910338, .cp = 0x22E2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_a170a3c = {.idx = 0xa170a3c, .cp = 0x0A5A, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550306 = {.idx = 0x550306, .cp = 0x016C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f40300 = {.idx = 0xf40300, .cp = 0x1ED3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_680308 = {.idx = 0x680308, .cp = 0x1E27, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_73030c = {.idx = 0x73030c, .cp = 0x0161, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3078309a = {.idx = 0x3078309a, .cp = 0x307A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f090342 = {.idx = 0x1f090342, .cp = 0x1F0F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b7030c = {.idx = 0x1b7030c, .cp = 0x01EE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650302 = {.idx = 0x650302, .cp = 0x00EA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1e360304 = {.idx = 0x1e360304, .cp = 0x1E38, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_a320a3c = {.idx = 0xa320a3c, .cp = 0x0A33, .exclusion = true};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_4A0302[103] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6f0328, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_21d40338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22250338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22760338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3970300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f390300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d605bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_e40304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_922093c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22910338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_a170a3c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f40300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_680308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_73030c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3078309a, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f090342, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b7030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650302, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1e360304, .table = NULL},
    {.entry = &lxb_unicode_codepoints_a320a3c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_4A0302 = {.length = 103, .nodes = lxb_unicode_nodes_comp_map_4A0302};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4a0302 = {.idx = 0x4a0302, .cp = 0x0134, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3970301 = {.idx = 0x3970301, .cp = 0x0389, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d40309 = {.idx = 0xd40309, .cp = 0x1ED4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650303 = {.idx = 0x650303, .cp = 0x1EBD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f010345 = {.idx = 0x1f010345, .cp = 0x1F81, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6c0323 = {.idx = 0x6c0323, .cp = 0x1E37, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_700307 = {.idx = 0x700307, .cp = 0x1E57, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b00323 = {.idx = 0x1b00323, .cp = 0x1EF1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_520301 = {.idx = 0x520301, .cp = 0x0154, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f40301 = {.idx = 0xf40301, .cp = 0x1ED1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f6d0345 = {.idx = 0x1f6d0345, .cp = 0x1FAD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6d0301 = {.idx = 0x6d0301, .cp = 0x1E3F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f390301 = {.idx = 0x1f390301, .cp = 0x1F3D, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_44032D[35] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3970301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d40309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f010345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6c0323, .table = NULL},
    {.entry = &lxb_unicode_codepoints_700307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b00323, .table = NULL},
    {.entry = &lxb_unicode_codepoints_520301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f40301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f6d0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6d0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f390301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_44032D = {.length = 35, .nodes = lxb_unicode_nodes_comp_map_44032D};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_44032d = {.idx = 0x44032d, .cp = 0x1E12, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d470d3e = {.idx = 0xd470d3e, .cp = 0x0D4B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5de05bc = {.idx = 0x5de05bc, .cp = 0xFB3E, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_45030c = {.idx = 0x45030c, .cp = 0x011A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ecd0302 = {.idx = 0x1ecd0302, .cp = 0x1ED9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_2280306 = {.idx = 0x2280306, .cp = 0x1E1C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550308 = {.idx = 0x550308, .cp = 0x00DC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f410300 = {.idx = 0x1f410300, .cp = 0x1F43, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fc0300 = {.idx = 0xfc0300, .cp = 0x01DC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650304 = {.idx = 0x650304, .cp = 0x0113, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750300 = {.idx = 0x750300, .cp = 0x00F9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_14d0300 = {.idx = 0x14d0300, .cp = 0x1E51, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22480338 = {.idx = 0x22480338, .cp = 0x2249, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c50304 = {.idx = 0x3c50304, .cp = 0x1FE1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4060308 = {.idx = 0x4060308, .cp = 0x0407, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_39f0300 = {.idx = 0x39f0300, .cp = 0x1FF8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ffe0300 = {.idx = 0x1ffe0300, .cp = 0x1FDD, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22b40338 = {.idx = 0x22b40338, .cp = 0x22EC, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_410328[79] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d470d3e, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5de05bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_45030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ecd0302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_2280306, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550308, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f410300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fc0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_14d0300, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22480338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c50304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4060308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_39f0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ffe0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22b40338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_410328 = {.length = 79, .nodes = lxb_unicode_nodes_comp_map_410328};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_410328 = {.idx = 0x410328, .cp = 0x0104, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1680301 = {.idx = 0x1680301, .cp = 0x1E78, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_475030f = {.idx = 0x475030f, .cp = 0x0477, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_14d0301 = {.idx = 0x14d0301, .cp = 0x1E53, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_14ba14b1 = {.idx = 0x14ba14b1, .cp = 0x114BC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_740323 = {.idx = 0x740323, .cp = 0x1E6D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750301 = {.idx = 0x750301, .cp = 0x00FA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_590323 = {.idx = 0x590323, .cp = 0x1EF4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f900fb5 = {.idx = 0xf900fb5, .cp = 0x0FB9, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_640327 = {.idx = 0x640327, .cp = 0x1E11, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_780307 = {.idx = 0x780307, .cp = 0x1E8B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5a0301 = {.idx = 0x5a0301, .cp = 0x0179, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1b0b1b35 = {.idx = 0x1b0b1b35, .cp = 0x1B0C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_720331 = {.idx = 0x720331, .cp = 0x1E5F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fc0301 = {.idx = 0xfc0301, .cp = 0x01D8, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f240345 = {.idx = 0x1f240345, .cp = 0x1F94, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1ffe0301 = {.idx = 0x1ffe0301, .cp = 0x1FDE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4c032d = {.idx = 0x4c032d, .cp = 0x1E3C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_f40303 = {.idx = 0xf40303, .cp = 0x1ED7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f410301 = {.idx = 0x1f410301, .cp = 0x1F45, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_550309 = {.idx = 0x550309, .cp = 0x1EE6, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1fc60345 = {.idx = 0x1fc60345, .cp = 0x1FC7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f090345 = {.idx = 0x1f090345, .cp = 0x1F89, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_c60301 = {.idx = 0xc60301, .cp = 0x01FC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_39f0301 = {.idx = 0x39f0301, .cp = 0x038C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e905c1 = {.idx = 0x5e905c1, .cp = 0xFB2A, .exclusion = true};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_420307[137] = {
    {.entry = &lxb_unicode_codepoints_1680301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_475030f, .table = NULL},
    {.entry = &lxb_unicode_codepoints_14d0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_14ba14b1, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_740323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_590323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f900fb5, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_640327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_780307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5a0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1b0b1b35, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_720331, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fc0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f240345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1ffe0301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4c032d, .table = NULL},
    {.entry = &lxb_unicode_codepoints_f40303, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f410301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_550309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1fc60345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f090345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_c60301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_39f0301, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e905c1, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_420307 = {.length = 137, .nodes = lxb_unicode_nodes_comp_map_420307};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_420307 = {.idx = 0x420307, .cp = 0x1E02, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650306 = {.idx = 0x650306, .cp = 0x0115, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_55030a = {.idx = 0x55030a, .cp = 0x016E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f490300 = {.idx = 0x1f490300, .cp = 0x1F4B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22860338 = {.idx = 0x22860338, .cp = 0x2288, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_917093c = {.idx = 0x917093c, .cp = 0x095A, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e905c2 = {.idx = 0x5e905c2, .cp = 0xFB2B, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4160306 = {.idx = 0x4160306, .cp = 0x04C1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_16b0308 = {.idx = 0x16b0308, .cp = 0x1E7B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5a0302 = {.idx = 0x5a0302, .cp = 0x1E90, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_780308 = {.idx = 0x780308, .cp = 0x1E8D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5e605bc = {.idx = 0x5e605bc, .cp = 0xFB46, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_68030c = {.idx = 0x68030c, .cp = 0x021F, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750302 = {.idx = 0x750302, .cp = 0x00FB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c50306 = {.idx = 0x3c50306, .cp = 0x1FE0, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_490328[55] = {
    {.entry = &lxb_unicode_codepoints_650306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_55030a, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f490300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22860338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_917093c, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e905c2, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4160306, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_16b0308, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5a0302, .table = NULL},
    {.entry = &lxb_unicode_codepoints_780308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5e605bc, .table = NULL},
    {.entry = &lxb_unicode_codepoints_68030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750302, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c50306, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_490328 = {.length = 55, .nodes = lxb_unicode_nodes_comp_map_490328};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_490328 = {.idx = 0x490328, .cp = 0x012E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_470301 = {.idx = 0x470301, .cp = 0x01F4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30c63099 = {.idx = 0x30c63099, .cp = 0x30C7, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f620345 = {.idx = 0x1f620345, .cp = 0x1FA2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d1bcd16f = {.idx = 0xd1bcd16f, .cp = 0x1D1BD, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_45030f = {.idx = 0x45030f, .cp = 0x0204, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6c0327 = {.idx = 0x6c0327, .cp = 0x013C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3950313 = {.idx = 0x3950313, .cp = 0x1F18, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30753099 = {.idx = 0x30753099, .cp = 0x3076, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750303 = {.idx = 0x750303, .cp = 0x0169, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610323 = {.idx = 0x610323, .cp = 0x1EA1, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4130301 = {.idx = 0x4130301, .cp = 0x0403, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_55030b = {.idx = 0x55030b, .cp = 0x0170, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f2c0345 = {.idx = 0x1f2c0345, .cp = 0x1F9C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f490301 = {.idx = 0x1f490301, .cp = 0x1F4D, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_54032d = {.idx = 0x54032d, .cp = 0x1E70, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30ab3099 = {.idx = 0x30ab3099, .cp = 0x30AC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_7a0331 = {.idx = 0x7a0331, .cp = 0x1E95, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fab0fb7 = {.idx = 0xfab0fb7, .cp = 0x0FAC, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1a10309 = {.idx = 0x1a10309, .cp = 0x1EDF, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650307 = {.idx = 0x650307, .cp = 0x0117, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_440331[53] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_470301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30c63099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f620345, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d1bcd16f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_45030f, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6c0327, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3950313, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30753099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750303, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4130301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_55030b, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f2c0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f490301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_54032d, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30ab3099, .table = NULL},
    {.entry = &lxb_unicode_codepoints_7a0331, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fab0fb7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1a10309, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650307, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_440331 = {.length = 53, .nodes = lxb_unicode_nodes_comp_map_440331};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_440331 = {.idx = 0x440331, .cp = 0x1E0E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4160308 = {.idx = 0x4160308, .cp = 0x04DC, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22730338 = {.idx = 0x22730338, .cp = 0x2275, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_22a90338 = {.idx = 0x22a90338, .cp = 0x22AE, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3ca0300 = {.idx = 0x3ca0300, .cp = 0x1FD2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3950314 = {.idx = 0x3950314, .cp = 0x1F19, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650308 = {.idx = 0x650308, .cp = 0x00EB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_740326 = {.idx = 0x740326, .cp = 0x021B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f210342 = {.idx = 0x1f210342, .cp = 0x1F27, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0300 = {.idx = 0x4f0300, .cp = 0x00D2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fb30f80 = {.idx = 0xfb30f80, .cp = 0x0F78, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_11321128 = {.idx = 0x11321128, .cp = 0x1112E, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1025102e = {.idx = 0x1025102e, .cp = 0x1026, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f000300 = {.idx = 0x1f000300, .cp = 0x1F02, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f510300 = {.idx = 0x1f510300, .cp = 0x1F53, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_55030c = {.idx = 0x55030c, .cp = 0x01D3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d305bc = {.idx = 0x5d305bc, .cp = 0xFB33, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_dc030c = {.idx = 0xdc030c, .cp = 0x01D9, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3075309a = {.idx = 0x3075309a, .cp = 0x3077, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_d1bcd170 = {.idx = 0xd1bcd170, .cp = 0x1D1BF, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_750304 = {.idx = 0x750304, .cp = 0x016B, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_c60304 = {.idx = 0xc60304, .cp = 0x01E2, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3c50308 = {.idx = 0x3c50308, .cp = 0x03CB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_fc0304 = {.idx = 0xfc0304, .cp = 0x01D6, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_470302[95] = {
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4160308, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22730338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_22a90338, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3ca0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3950314, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_740326, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f210342, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f0300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fb30f80, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_11321128, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1025102e, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f000300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f510300, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_55030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d305bc, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_dc030c, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3075309a, .table = NULL},
    {.entry = &lxb_unicode_codepoints_d1bcd170, .table = NULL},
    {.entry = &lxb_unicode_codepoints_750304, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_c60304, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3c50308, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_fc0304, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_470302 = {.length = 95, .nodes = lxb_unicode_nodes_comp_map_470302};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_470302 = {.idx = 0x470302, .cp = 0x011C, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_650309 = {.idx = 0x650309, .cp = 0x1EBB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_30b33099 = {.idx = 0x30b33099, .cp = 0x30B4, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f000301 = {.idx = 0x1f000301, .cp = 0x1F04, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_6d0307 = {.idx = 0x6d0307, .cp = 0x1E41, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4f0301 = {.idx = 0x4f0301, .cp = 0x00D3, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4e0323 = {.idx = 0x4e0323, .cp = 0x1E46, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f6a0345 = {.idx = 0x1f6a0345, .cp = 0x1FAA, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_610325 = {.idx = 0x610325, .cp = 0x1E01, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_740327 = {.idx = 0x740327, .cp = 0x0163, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_4c0331 = {.idx = 0x4c0331, .cp = 0x1E3A, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1600307 = {.idx = 0x1600307, .cp = 0x1E66, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_690323 = {.idx = 0x690323, .cp = 0x1ECB, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_5d005b7 = {.idx = 0x5d005b7, .cp = 0xFB2E, .exclusion = true};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_1f510301 = {.idx = 0x1f510301, .cp = 0x1F55, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_520307 = {.idx = 0x520307, .cp = 0x1E58, .exclusion = false};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_3ca0301 = {.idx = 0x3ca0301, .cp = 0x0390, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_comp_map_450311[53] = {
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_650309, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_30b33099, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f000301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_6d0307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4f0301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4e0323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f6a0345, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_610325, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_740327, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_4c0331, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1600307, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_690323, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_5d005b7, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_1f510301, .table = NULL},
    {.entry = NULL, .table = NULL},
    {.entry = &lxb_unicode_codepoints_520307, .table = NULL},
    {.entry = &lxb_unicode_codepoints_3ca0301, .table = NULL},
    {.entry = NULL, .table = NULL}
};
static const lxb_unicode_compose_table_t lxb_unicode_comp_map_450311 = {.length = 53, .nodes = lxb_unicode_nodes_comp_map_450311};
static const lxb_unicode_compose_entry_t lxb_unicode_codepoints_450311 = {.idx = 0x450311, .cp = 0x0206, .exclusion = false};
static const lxb_unicode_compose_node_t lxb_unicode_nodes_composition[54] = {
    {.entry = &lxb_unicode_codepoints_470304, .table = &lxb_unicode_comp_map_470304},
    {.entry = &lxb_unicode_codepoints_4f0303, .table = &lxb_unicode_comp_map_4F0303},
    {.entry = &lxb_unicode_codepoints_3c0338, .table = &lxb_unicode_comp_map_3C0338},
    {.entry = &lxb_unicode_codepoints_470307, .table = &lxb_unicode_comp_map_470307},
    {.entry = &lxb_unicode_codepoints_490330, .table = &lxb_unicode_comp_map_490330},
    {.entry = &lxb_unicode_codepoints_4b0323, .table = &lxb_unicode_comp_map_4B0323},
    {.entry = &lxb_unicode_codepoints_4f0308, .table = &lxb_unicode_comp_map_4F0308},
    {.entry = &lxb_unicode_codepoints_430327, .table = &lxb_unicode_comp_map_430327},
    {.entry = &lxb_unicode_codepoints_410300, .table = &lxb_unicode_comp_map_410300},
    {.entry = &lxb_unicode_codepoints_410301, .table = &lxb_unicode_comp_map_410301},
    {.entry = &lxb_unicode_codepoints_410302, .table = &lxb_unicode_comp_map_410302},
    {.entry = &lxb_unicode_codepoints_410303, .table = &lxb_unicode_comp_map_410303},
    {.entry = &lxb_unicode_codepoints_410304, .table = &lxb_unicode_comp_map_410304},
    {.entry = &lxb_unicode_codepoints_490303, .table = &lxb_unicode_comp_map_490303},
    {.entry = &lxb_unicode_codepoints_410306, .table = &lxb_unicode_comp_map_410306},
    {.entry = &lxb_unicode_codepoints_410307, .table = &lxb_unicode_comp_map_410307},
    {.entry = &lxb_unicode_codepoints_3e0338, .table = &lxb_unicode_comp_map_3E0338},
    {.entry = &lxb_unicode_codepoints_410309, .table = &lxb_unicode_comp_map_410309},
    {.entry = &lxb_unicode_codepoints_41030a, .table = &lxb_unicode_comp_map_41030A},
    {.entry = &lxb_unicode_codepoints_490309, .table = &lxb_unicode_comp_map_490309},
    {.entry = &lxb_unicode_codepoints_41030c, .table = &lxb_unicode_comp_map_41030C},
    {.entry = &lxb_unicode_codepoints_450327, .table = &lxb_unicode_comp_map_450327},
    {.entry = &lxb_unicode_codepoints_450328, .table = &lxb_unicode_comp_map_450328},
    {.entry = &lxb_unicode_codepoints_41030f, .table = &lxb_unicode_comp_map_41030F},
    {.entry = &lxb_unicode_codepoints_430302, .table = &lxb_unicode_comp_map_430302},
    {.entry = &lxb_unicode_codepoints_410311, .table = &lxb_unicode_comp_map_410311},
    {.entry = &lxb_unicode_codepoints_550328, .table = &lxb_unicode_comp_map_550328},
    {.entry = &lxb_unicode_codepoints_45032d, .table = &lxb_unicode_comp_map_45032D},
    {.entry = &lxb_unicode_codepoints_530302, .table = &lxb_unicode_comp_map_530302},
    {.entry = &lxb_unicode_codepoints_430307, .table = &lxb_unicode_comp_map_430307},
    {.entry = &lxb_unicode_codepoints_450330, .table = &lxb_unicode_comp_map_450330},
    {.entry = &lxb_unicode_codepoints_520327, .table = &lxb_unicode_comp_map_520327},
    {.entry = &lxb_unicode_codepoints_480302, .table = &lxb_unicode_comp_map_480302},
    {.entry = &lxb_unicode_codepoints_4f0323, .table = &lxb_unicode_comp_map_4F0323},
    {.entry = &lxb_unicode_codepoints_43030c, .table = &lxb_unicode_comp_map_43030C},
    {.entry = &lxb_unicode_codepoints_470327, .table = &lxb_unicode_comp_map_470327},
    {.entry = &lxb_unicode_codepoints_3d0338, .table = &lxb_unicode_comp_map_3D0338},
    {.entry = &lxb_unicode_codepoints_420331, .table = &lxb_unicode_comp_map_420331},
    {.entry = &lxb_unicode_codepoints_450302, .table = &lxb_unicode_comp_map_450302},
    {.entry = &lxb_unicode_codepoints_450303, .table = &lxb_unicode_comp_map_450303},
    {.entry = &lxb_unicode_codepoints_450304, .table = &lxb_unicode_comp_map_450304},
    {.entry = &lxb_unicode_codepoints_440327, .table = &lxb_unicode_comp_map_440327},
    {.entry = &lxb_unicode_codepoints_450306, .table = &lxb_unicode_comp_map_450306},
    {.entry = &lxb_unicode_codepoints_410323, .table = &lxb_unicode_comp_map_410323},
    {.entry = &lxb_unicode_codepoints_450308, .table = &lxb_unicode_comp_map_450308},
    {.entry = &lxb_unicode_codepoints_410325, .table = &lxb_unicode_comp_map_410325},
    {.entry = &lxb_unicode_codepoints_4a0302, .table = &lxb_unicode_comp_map_4A0302},
    {.entry = &lxb_unicode_codepoints_44032d, .table = &lxb_unicode_comp_map_44032D},
    {.entry = &lxb_unicode_codepoints_410328, .table = &lxb_unicode_comp_map_410328},
    {.entry = &lxb_unicode_codepoints_420307, .table = &lxb_unicode_comp_map_420307},
    {.entry = &lxb_unicode_codepoints_490328, .table = &lxb_unicode_comp_map_490328},
    {.entry = &lxb_unicode_codepoints_440331, .table = &lxb_unicode_comp_map_440331},
    {.entry = &lxb_unicode_codepoints_470302, .table = &lxb_unicode_comp_map_470302},
    {.entry = &lxb_unicode_codepoints_450311, .table = &lxb_unicode_comp_map_450311}
};
static const lxb_unicode_compose_table_t lxb_unicode_composition = {.length = 54, .nodes = lxb_unicode_nodes_composition};


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* LEXBOR_UNICODE_TABLES_COMPOSE_H */
