/* LIBDS
 * =====
 * This software is Copyright (c) 2002-04 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */

#ifndef WIN32_NO_CONFIG_H
#include "../config.h"
#else
#include "../winconf.h"
#endif
#define WIN32_LEAN_AND_MEAN
#include <DSComponent.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef WITH_OSX_DLFCN
#include <dlfcn_osx.h>
#else
#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif
#endif
#ifdef _WIN32_
#include <windows.h>
#endif

#ifdef HAVE_IO_H
#include <io.h>
#endif

DSComponent::DSComponent(DSHashTable * hash)
{
	tshashreg=NULL;
	hashreg=hash;
	listreg=NULL;
}

DSComponent::DSComponent(DSList * list)
{
	tshashreg=NULL;
	hashreg=NULL;
	listreg=list;
}

DSComponent::DSComponent(DSTSHashTable * hash)
{
	tshashreg=hash;
	hashreg=NULL;
	listreg=NULL;
}

DSComponent::~DSComponent()
{
}

int DSComponent::loadcomponents(char * dir, char * key_symbol, char * value_symbol)
{
	return loadComponentsPrefixed(dir, key_symbol, value_symbol, FALSE);
}


int DSComponent::loadComponentsPrefixed(char * dir, char * key_symbol, char * value_symbol,BOOL with_prefix)
{
	char szSymbol[256];
	int count;
#ifndef _WIN32_
	DIR * dh;
	struct dirent * thisfile;
	void * libhandle;
	int (*keysym)();
	void * valsym;
	char * tmp;
	int key;
	count=0;
	dh=opendir(dir);
	if (!dh) return count;
	while ((thisfile=readdir(dh))>0) {
		tmp=strrchr(thisfile->d_name,'.');
		if ((tmp)&&((strcmp(tmp,".so")==0)||(strcmp(tmp,".dylib")==0))) {
			tmp=(char *)malloc(thisfile->d_reclen+strlen(dir)+2);
			sprintf(tmp,"%s/%s",dir, thisfile->d_name);
			libhandle=dlopen(tmp, RTLD_NOW|RTLD_GLOBAL);
			if (!libhandle) printf("dlopen failed on %s\n",tmp);
			free(tmp);
			tmp=(char *)dlerror();
			if (tmp) printf("dlopen error was %s\n",tmp);
			if (libhandle) {
				if (with_prefix) {
					strcpy(szSymbol,thisfile->d_name);
					tmp=strchr(szSymbol,'.');
					if (tmp) tmp[0]='\0';
					strcat(szSymbol,"_");
					strcat(szSymbol,key_symbol);
				} else {
					strcpy(szSymbol,key_symbol);
				}

				keysym=(int (*)())dlsym(libhandle, szSymbol);
				tmp=(char *)dlerror();
				if (tmp) printf("dlsym failed on %s\n",szSymbol);
				if (tmp==NULL) {
					if (with_prefix) {
						strcpy(szSymbol,thisfile->d_name);
						tmp=strchr(szSymbol,'.');
						if (tmp) tmp[0]='\0';
						strcat(szSymbol,"_");
						strcat(szSymbol,value_symbol);
					} else {
						strcpy(szSymbol,value_symbol);
					}
					valsym=dlsym(libhandle, szSymbol);
					if (dlerror()==NULL) {
						key=keysym();
						if (key>=0) {

							if (tshashreg) {
								tshashreg->lock();
								tshashreg->insert(key, valsym);
								tshashreg->unlock();
							}
	
							if (hashreg)
								hashreg->insert(key, valsym);
							if (listreg)
								listreg->append(key, valsym);
							count++;
						} else {
							dlclose(libhandle);
						}
					} else {
						dlclose(libhandle);
					}
				} else {
					dlclose(libhandle);
				}
				/* Note, not calling dlclose() */
			}
		}
		
	}
	closedir(dh);
	return count;
#else
	HANDLE finder;
	WIN32_FIND_DATA wfd;
	HINSTANCE libhandle;
	BOOL finished;
	int (*keysym)();
	void * valsym;
	char * tmp;
	int key;
	count=0;
	tmp=(char *)malloc(strlen(dir)+7);
	sprintf(tmp, "%s\\*.DLL", dir);
	finder=FindFirstFile(tmp, &wfd);
	if (finder==INVALID_HANDLE_VALUE) return count;
	finished=FALSE;
	free(tmp);
	while (!finished) {
#ifdef HAVE_STRCASECMP
		if (strcasecmp(strrchr(wfd.cFileName,'.'),".DLL")==0) {
#else
#ifdef HAVE_STRICMP
		if (stricmp(strrchr(wfd.cFileName,'.'),".DLL")==0) {
#endif
#endif
			tmp=(char *)malloc(strlen(dir)+strlen(wfd.cFileName)+2);
			sprintf(tmp,"%s\\%s",dir, wfd.cFileName);
			libhandle=LoadLibrary(tmp);
			free(tmp);
			if (libhandle) {
				if (with_prefix) {
					strcpy(szSymbol,wfd.cFileName);
					tmp=strchr(szSymbol,'.');
					if (tmp) tmp[0]='\0';
					strcat(szSymbol,"_");
					strcat(szSymbol,key_symbol);
				} else {
					strcpy(szSymbol,key_symbol);
				}
				keysym=(int (*)())GetProcAddress(libhandle, szSymbol);
				if (keysym!=NULL) {
					if (with_prefix) {
						strcpy(szSymbol,wfd.cFileName);
						tmp=strchr(szSymbol,'.');
						if (tmp) tmp[0]='\0';
						strcat(szSymbol,"_");
						strcat(szSymbol,value_symbol);
					} else {
						strcpy(szSymbol,value_symbol);
					}
					valsym=(void *)GetProcAddress(libhandle, szSymbol);
					if (valsym!=NULL) {
						key=keysym();
						if (key>=0) {

							if (tshashreg) {
								tshashreg->lock();
								tshashreg->insert(key, valsym);
								tshashreg->unlock();
							}

							if (hashreg)
								hashreg->insert(key, valsym);
							if (listreg)
								listreg->append(key, valsym);
							count++;
						} else {
							FreeLibrary(libhandle);
						}
					} else {
						FreeLibrary(libhandle);
					}
				} else {
					FreeLibrary(libhandle);
				}
				/* Note, not calling FreeLibrary() */
			}
		}
		finished=!FindNextFile(finder, &wfd);
	}
	FindClose(finder);
	return count;
#endif
}


