/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */
#include "DSMutex.h"

DSMutex::DSMutex()
{
#ifndef _WIN32_
	pthread_mutex_init(&mutex,NULL);
#else
	mutex=CreateMutex(NULL, FALSE, NULL);
#endif
}

DSMutex::~DSMutex()
{
#ifndef _WIN32_
	pthread_mutex_destroy(&mutex);
#else
	CloseHandle(mutex);
#endif
}

void DSMutex::lock()
{
#ifndef _WIN32_
	pthread_mutex_lock(&mutex);
#else
	WaitForSingleObject(mutex, INFINITE);
#endif
}

void DSMutex::unlock()
{
#ifndef _WIN32_
	pthread_mutex_unlock(&mutex);
#else
	ReleaseMutex(mutex);
#endif
}

