/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */
#ifndef DS_TSHASHTABLE_H
#define DS_TSHASHTABLE_H
#include <DSCore.h>

#include <DSHashTable.h>
#include <DSMutex.h>

/*!
 * @header DSTSHashTable
 * @discussion This class extends a plain HashTable by adding support for global locking.  This can be useful to make a HashTable threadsafe.
 */

/*!
 * @class DSTSHashTable : public DSHashTable, public DSMutex
 * @discussion This class extends a plain HashTable by adding support for global locking.  This can be useful to make a HashTable threadsafe.
 */
class EXPSYM DSTSHashTable: public DSHashTable, public DSMutex
{
	private:

	public:
		/*!
			@function TSHashTable
			@discussion Create a TSHashTable.
			@param newBuckets Specify the number of buckets to be used in the HashTable.  The more buckets, the more memory is required; but the faster data access will be on large datasets.  You may wish to increase the default for areas involving large quantities of data.
			@param newPrimeA Specify a large prime number to be used in hashing.  You only need to do this if it's important to you to have a different hashing algorithm between two HashTables.
			@param newPrimeB Specify a large prime number to be used in hashing.  You only need to do this if it's important to you to have a different hashing algorithm between two HashTables.
		*/
		DSTSHashTable(unsigned int newBuckets=100,unsigned int newPrimeA=89258459,unsigned int newPrimeB=252584539);
		/*!
			@function ~TSHashTable
			@discussion Destroy a TSHashTable.
		*/
		~DSTSHashTable();

};

#endif

