/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */
#include "DSThread.h"

DSThread::DSThread()
{
#ifdef _WIN32_
	hThread=NULL;
#endif
}

DSThread::~DSThread()
{
#ifdef _WIN32_
	if (hThread) CloseHandle(hThread);
#endif
}

void DSThread::detach()
{
#ifndef _WIN32_
	pthread_detach(tid);
#endif
}

int DSThread::exec(void* (*start)(void *), void * arg)
{
#ifndef _WIN32_
	pthread_attr_t atts;
	pthread_attr_init(&atts);
#ifdef HAVE_PTHREAD_ATTR_SETSCOPE
	pthread_attr_setscope(&atts, PTHREAD_SCOPE_SYSTEM);
#endif
	return !pthread_create(&tid, &atts, start, arg);
#else
	if (hThread) CloseHandle(hThread);
	hThread=CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) start,
		arg, 0, &tid);
	if (hThread!=INVALID_HANDLE_VALUE) return -1;
	return 0;
#endif
}


