/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */
#ifndef DS_THREAD_H
#define DS_THREAD_H
#include <DSCore.h>

#ifdef _WIN32_
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#else
#define _REENTRANT
#include <pthread.h>
#endif

/*!
 * @header DSThread
 * @discussion This class provides simple methods for handling threads.
 */

/*!
 * @class DSThread
 * @discussion This class provides simple methods for handling threads.
 */
class EXPSYM DSThread
{
	private:
#ifndef _WIN32_
		pthread_t tid;
#else
		HANDLE hThread;
		DWORD tid;
#endif

	public:
		/*!
			@function DSThread
			@discussion Create a thread object.  The thread is not spawned until a subsequent exec() call.
		*/
		DSThread();
		/*!
			@function ~TSThread
			@discussion Destroy a Thread object.  If a thread has been initiated, it is not terminated.
		*/
		~DSThread();

		/*!
		 * @function detach
		 * @discussion Detaches a thread.
		 */
		void detach();

		/*!
		 * @function exec
		 * @discussion Executes a thread.
		 * @param start This is the name of a function to be executed when the thread initiates.
		 * @param arg This is a pointer to data that the thread function will receive.
		 */
		int          exec(void *(*start)(void *), void * arg);

};

#endif

