/*
 * Library ltree section functions test program
 *
 * Copyright (C) 2006-2023, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <file_stream.h>
#include <memory.h>
#include <types.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#include "ewf_test_functions.h"
#include "ewf_test_libbfio.h"
#include "ewf_test_libcerror.h"
#include "ewf_test_libewf.h"
#include "ewf_test_macros.h"
#include "ewf_test_memory.h"
#include "ewf_test_unused.h"

#include "../libewf/libewf_io_handle.h"
#include "../libewf/libewf_ltree_section.h"
#include "../libewf/libewf_section_descriptor.h"

uint8_t ewf_test_ltree_section_data1[ 5748 ] = {
	0x31, 0x2b, 0x5d, 0x1c, 0x04, 0x3b, 0x2a, 0x68, 0x09, 0x2a, 0x39, 0x1c, 0x16, 0x91, 0xdb, 0x63,
	0x44, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x04, 0x4a, 0xa9, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x35, 0x00, 0x0a, 0x00, 0x72, 0x00, 0x65, 0x00, 0x63, 0x00, 0x0a, 0x00, 0x74, 0x00, 0x62, 0x00,
	0x09, 0x00, 0x63, 0x00, 0x6c, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x66, 0x00, 0x70, 0x00,
	0x09, 0x00, 0x70, 0x00, 0x67, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x67, 0x00, 0x09, 0x00, 0x69, 0x00,
	0x67, 0x00, 0x09, 0x00, 0x63, 0x00, 0x64, 0x00, 0x09, 0x00, 0x77, 0x00, 0x64, 0x00, 0x09, 0x00,
	0x6d, 0x00, 0x64, 0x00, 0x09, 0x00, 0x61, 0x00, 0x64, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00,
	0x31, 0x00, 0x39, 0x00, 0x39, 0x00, 0x32, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6d, 0x00, 0x0a, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x09, 0x00, 0x70, 0x00, 0x72, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x61, 0x00,
	0x09, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x69, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00,
	0x73, 0x00, 0x72, 0x00, 0x63, 0x00, 0x65, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x0a, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00,
	0x65, 0x00, 0x76, 0x00, 0x09, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x6f, 0x00,
	0x63, 0x00, 0x09, 0x00, 0x73, 0x00, 0x65, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x66, 0x00, 0x72, 0x00,
	0x09, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x74, 0x00, 0x62, 0x00, 0x09, 0x00, 0x6c, 0x00,
	0x6f, 0x00, 0x09, 0x00, 0x70, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x61, 0x00, 0x68, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x68, 0x00, 0x09, 0x00, 0x67, 0x00, 0x75, 0x00, 0x09, 0x00, 0x70, 0x00, 0x67, 0x00,
	0x75, 0x00, 0x09, 0x00, 0x61, 0x00, 0x71, 0x00, 0x09, 0x00, 0x69, 0x00, 0x70, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x69, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x09, 0x00, 0x64, 0x00, 0x74, 0x00,
	0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x66, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00,
	0x09, 0x00, 0x46, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x04, 0x5f, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x46, 0x00, 0x6c, 0x00, 0x61, 0x00,
	0x73, 0x00, 0x68, 0x00, 0x20, 0x00, 0x44, 0x00, 0x69, 0x00, 0x73, 0x00, 0x6b, 0x00, 0x09, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x32, 0x00, 0x31, 0x00, 0x34, 0x00, 0x34, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x37, 0x00, 0x37, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00, 0x42, 0x00,
	0x39, 0x00, 0x32, 0x00, 0x41, 0x00, 0x35, 0x00, 0x38, 0x00, 0x43, 0x00, 0x38, 0x00, 0x37, 0x00,
	0x43, 0x00, 0x34, 0x00, 0x38, 0x00, 0x30, 0x00, 0x41, 0x00, 0x33, 0x00, 0x30, 0x00, 0x46, 0x00,
	0x42, 0x00, 0x43, 0x00, 0x35, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x31, 0x00, 0x41, 0x00,
	0x36, 0x00, 0x35, 0x00, 0x09, 0x00, 0x37, 0x00, 0x37, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x42, 0x00, 0x39, 0x00, 0x32, 0x00, 0x41, 0x00, 0x35, 0x00, 0x38, 0x00, 0x43, 0x00, 0x38, 0x00,
	0x37, 0x00, 0x43, 0x00, 0x34, 0x00, 0x38, 0x00, 0x30, 0x00, 0x41, 0x00, 0x33, 0x00, 0x30, 0x00,
	0x46, 0x00, 0x42, 0x00, 0x43, 0x00, 0x35, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x31, 0x00,
	0x41, 0x00, 0x36, 0x00, 0x35, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x72, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x73, 0x00,
	0x75, 0x00, 0x62, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x70, 0x00,
	0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x75, 0x00,
	0x09, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x67, 0x00, 0x75, 0x00, 0x0a, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x72, 0x00,
	0x79, 0x00, 0x0a, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x6d, 0x00, 0x69, 0x00,
	0x64, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x73, 0x00, 0x09, 0x00, 0x62, 0x00, 0x65, 0x00, 0x09, 0x00,
	0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x63, 0x00, 0x72, 0x00, 0x09, 0x00, 0x61, 0x00, 0x63, 0x00,
	0x09, 0x00, 0x77, 0x00, 0x72, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x64, 0x00,
	0x6c, 0x00, 0x09, 0x00, 0x73, 0x00, 0x69, 0x00, 0x67, 0x00, 0x09, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x68, 0x00, 0x61, 0x00, 0x09, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x6e, 0x00, 0x68, 0x00, 0x09, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00,
	0x09, 0x00, 0x64, 0x00, 0x75, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x70, 0x00,
	0x6f, 0x00, 0x09, 0x00, 0x70, 0x00, 0x6d, 0x00, 0x09, 0x00, 0x6f, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x70, 0x00, 0x74, 0x00, 0x68, 0x00, 0x09, 0x00, 0x6f, 0x00, 0x70, 0x00,
	0x72, 0x00, 0x09, 0x00, 0x73, 0x00, 0x72, 0x00, 0x63, 0x00, 0x09, 0x00, 0x73, 0x00, 0x75, 0x00,
	0x62, 0x00, 0x09, 0x00, 0x63, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x6a, 0x00, 0x71, 0x00,
	0x09, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x74, 0x00, 0x09, 0x00, 0x65, 0x00, 0x70, 0x00, 0x09, 0x00,
	0x61, 0x00, 0x71, 0x00, 0x09, 0x00, 0x63, 0x00, 0x66, 0x00, 0x69, 0x00, 0x09, 0x00, 0x73, 0x00,
	0x67, 0x00, 0x09, 0x00, 0x65, 0x00, 0x61, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x70, 0x00, 0x74, 0x00,
	0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x36, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x44, 0x00,
	0x31, 0x00, 0x43, 0x00, 0x34, 0x00, 0x31, 0x00, 0x42, 0x00, 0x42, 0x00, 0x33, 0x00, 0x46, 0x00,
	0x31, 0x00, 0x42, 0x00, 0x37, 0x00, 0x34, 0x00, 0x38, 0x00, 0x43, 0x00, 0x39, 0x00, 0x30, 0x00,
	0x45, 0x00, 0x34, 0x00, 0x38, 0x00, 0x34, 0x00, 0x44, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00,
	0x37, 0x00, 0x43, 0x00, 0x31, 0x00, 0x33, 0x00, 0x39, 0x00, 0x44, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x4c, 0x00, 0x6f, 0x00, 0x67, 0x00, 0x69, 0x00, 0x63, 0x00, 0x61, 0x00,
	0x6c, 0x00, 0x45, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x32, 0x00,
	0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x35, 0x00, 0x38, 0x00, 0x30, 0x00, 0x42, 0x00,
	0x41, 0x00, 0x33, 0x00, 0x30, 0x00, 0x44, 0x00, 0x42, 0x00, 0x38, 0x00, 0x34, 0x00, 0x32, 0x00,
	0x41, 0x00, 0x39, 0x00, 0x38, 0x00, 0x45, 0x00, 0x39, 0x00, 0x44, 0x00, 0x46, 0x00, 0x31, 0x00,
	0x31, 0x00, 0x32, 0x00, 0x34, 0x00, 0x30, 0x00, 0x34, 0x00, 0x37, 0x00, 0x46, 0x00, 0x42, 0x00,
	0x36, 0x00, 0x30, 0x00, 0x36, 0x00, 0x41, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00,
	0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x39, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00,
	0x38, 0x00, 0x39, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x44, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x44, 0x00, 0x38, 0x00, 0x43, 0x00, 0x44, 0x00, 0x39, 0x00, 0x38, 0x00, 0x46, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x42, 0x00, 0x32, 0x00, 0x30, 0x00, 0x34, 0x00, 0x45, 0x00, 0x39, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x39, 0x00, 0x39, 0x00, 0x38, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
	0x38, 0x00, 0x34, 0x00, 0x32, 0x00, 0x37, 0x00, 0x45, 0x00, 0x09, 0x00, 0x44, 0x00, 0x41, 0x00,
	0x33, 0x00, 0x39, 0x00, 0x41, 0x00, 0x33, 0x00, 0x45, 0x00, 0x45, 0x00, 0x35, 0x00, 0x45, 0x00,
	0x36, 0x00, 0x42, 0x00, 0x34, 0x00, 0x42, 0x00, 0x30, 0x00, 0x44, 0x00, 0x33, 0x00, 0x32, 0x00,
	0x35, 0x00, 0x35, 0x00, 0x42, 0x00, 0x46, 0x00, 0x45, 0x00, 0x46, 0x00, 0x39, 0x00, 0x35, 0x00,
	0x36, 0x00, 0x30, 0x00, 0x31, 0x00, 0x38, 0x00, 0x39, 0x00, 0x30, 0x00, 0x41, 0x00, 0x46, 0x00,
	0x44, 0x00, 0x38, 0x00, 0x30, 0x00, 0x37, 0x00, 0x30, 0x00, 0x39, 0x00, 0x09, 0x00, 0x45, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x54, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x39, 0x00,
	0x46, 0x00, 0x42, 0x00, 0x44, 0x00, 0x32, 0x00, 0x44, 0x00, 0x41, 0x00, 0x42, 0x00, 0x31, 0x00,
	0x30, 0x00, 0x45, 0x00, 0x41, 0x00, 0x38, 0x00, 0x38, 0x00, 0x33, 0x00, 0x38, 0x00, 0x46, 0x00,
	0x36, 0x00, 0x35, 0x00, 0x32, 0x00, 0x39, 0x00, 0x46, 0x00, 0x41, 0x00, 0x34, 0x00, 0x45, 0x00,
	0x34, 0x00, 0x44, 0x00, 0x39, 0x00, 0x37, 0x00, 0x41, 0x00, 0x38, 0x00, 0x09, 0x00, 0x32, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x34, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00,
	0x38, 0x00, 0x39, 0x00, 0x38, 0x00, 0x32, 0x00, 0x33, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00,
	0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x39, 0x00,
	0x38, 0x00, 0x31, 0x00, 0x36, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x38, 0x00, 0x09, 0x00, 0x35, 0x00, 0x44, 0x00, 0x44, 0x00, 0x33, 0x00, 0x39, 0x00, 0x43, 0x00,
	0x41, 0x00, 0x42, 0x00, 0x31, 0x00, 0x43, 0x00, 0x35, 0x00, 0x33, 0x00, 0x43, 0x00, 0x32, 0x00,
	0x43, 0x00, 0x37, 0x00, 0x37, 0x00, 0x43, 0x00, 0x44, 0x00, 0x33, 0x00, 0x35, 0x00, 0x32, 0x00,
	0x39, 0x00, 0x38, 0x00, 0x33, 0x00, 0x46, 0x00, 0x39, 0x00, 0x36, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x45, 0x00, 0x31, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x20, 0x00, 0x54, 0x00, 0x45, 0x00, 0x53, 0x00, 0x54, 0x00, 0x46, 0x00, 0x49, 0x00, 0x4c, 0x00,
	0x45, 0x00, 0x2e, 0x00, 0x54, 0x00, 0x58, 0x00, 0x54, 0x00, 0x09, 0x00, 0x09, 0x00, 0x74, 0x00,
	0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x2e, 0x00,
	0x74, 0x00, 0x78, 0x00, 0x74, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x37, 0x00, 0x32, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x31, 0x00, 0x34, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x33, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00,
	0x34, 0x00, 0x31, 0x00, 0x39, 0x00, 0x34, 0x00, 0x33, 0x00, 0x31, 0x00, 0x32, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x0a, 0x00, 0x41, 0x00, 0x44, 0x00, 0x39, 0x00, 0x39, 0x00, 0x36, 0x00, 0x35, 0x00, 0x46, 0x00,
	0x34, 0x00, 0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00, 0x33, 0x00, 0x37, 0x00, 0x38, 0x00,
	0x43, 0x00, 0x39, 0x00, 0x45, 0x00, 0x45, 0x00, 0x30, 0x00, 0x43, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x33, 0x00, 0x46, 0x00, 0x44, 0x00, 0x32, 0x00, 0x33, 0x00, 0x31, 0x00, 0x34, 0x00, 0x45, 0x00,
	0x34, 0x00, 0x09, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x43, 0x00, 0x39, 0x00, 0x30, 0x00, 0x41, 0x00,
	0x33, 0x00, 0x41, 0x00, 0x33, 0x00, 0x35, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00, 0x35, 0x00,
	0x41, 0x00, 0x45, 0x00, 0x43, 0x00, 0x37, 0x00, 0x38, 0x00, 0x41, 0x00, 0x43, 0x00, 0x31, 0x00,
	0x36, 0x00, 0x46, 0x00, 0x31, 0x00, 0x31, 0x00, 0x34, 0x00, 0x44, 0x00, 0x38, 0x00, 0x36, 0x00,
	0x34, 0x00, 0x38, 0x00, 0x41, 0x00, 0x32, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x56, 0x00, 0x6f, 0x00, 0x6c, 0x00, 0x75, 0x00,
	0x6d, 0x00, 0x65, 0x00, 0x20, 0x00, 0x42, 0x00, 0x6f, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x35, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x39, 0x00, 0x34, 0x00, 0x33, 0x00, 0x30, 0x00, 0x34, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x44, 0x00,
	0x31, 0x00, 0x46, 0x00, 0x45, 0x00, 0x36, 0x00, 0x45, 0x00, 0x42, 0x00, 0x39, 0x00, 0x30, 0x00,
	0x33, 0x00, 0x39, 0x00, 0x45, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x44, 0x00, 0x41, 0x00,
	0x38, 0x00, 0x35, 0x00, 0x44, 0x00, 0x32, 0x00, 0x30, 0x00, 0x41, 0x00, 0x31, 0x00, 0x37, 0x00,
	0x33, 0x00, 0x43, 0x00, 0x43, 0x00, 0x31, 0x00, 0x43, 0x00, 0x41, 0x00, 0x42, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x33, 0x00, 0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x37, 0x00,
	0x46, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00, 0x36, 0x00, 0x38, 0x00, 0x43, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0x35, 0x00, 0x44, 0x00, 0x32, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x33, 0x00, 0x34, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x46, 0x00,
	0x43, 0x00, 0x43, 0x00, 0x46, 0x00, 0x46, 0x00, 0x33, 0x00, 0x35, 0x00, 0x35, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x50, 0x00,
	0x72, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x72, 0x00, 0x79, 0x00, 0x20, 0x00, 0x46, 0x00,
	0x41, 0x00, 0x54, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00,
	0x36, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x35, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x34, 0x00, 0x31, 0x00, 0x39, 0x00, 0x34, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x34, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x35, 0x00, 0x39, 0x00, 0x42, 0x00,
	0x42, 0x00, 0x39, 0x00, 0x34, 0x00, 0x30, 0x00, 0x43, 0x00, 0x31, 0x00, 0x39, 0x00, 0x38, 0x00,
	0x39, 0x00, 0x35, 0x00, 0x44, 0x00, 0x38, 0x00, 0x39, 0x00, 0x42, 0x00, 0x32, 0x00, 0x31, 0x00,
	0x34, 0x00, 0x34, 0x00, 0x37, 0x00, 0x42, 0x00, 0x37, 0x00, 0x44, 0x00, 0x35, 0x00, 0x38, 0x00,
	0x37, 0x00, 0x45, 0x00, 0x37, 0x00, 0x33, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00,
	0x62, 0x00, 0x09, 0x00, 0x37, 0x00, 0x46, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x38, 0x00, 0x43, 0x00, 0x33, 0x00, 0x30, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00,
	0x35, 0x00, 0x44, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x33, 0x00, 0x34, 0x00, 0x39, 0x00,
	0x45, 0x00, 0x33, 0x00, 0x46, 0x00, 0x43, 0x00, 0x43, 0x00, 0x46, 0x00, 0x46, 0x00, 0x33, 0x00,
	0x35, 0x00, 0x35, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x53, 0x00, 0x65, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x64, 0x00,
	0x61, 0x00, 0x72, 0x00, 0x79, 0x00, 0x20, 0x00, 0x46, 0x00, 0x41, 0x00, 0x54, 0x00, 0x09, 0x00,
	0x34, 0x00, 0x31, 0x00, 0x31, 0x00, 0x37, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x35, 0x00, 0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x38, 0x00, 0x20, 0x00, 0x20, 0x00, 0x35, 0x00,
	0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x37, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x30, 0x00, 0x33, 0x00, 0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x37, 0x00,
	0x30, 0x00, 0x43, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x33, 0x00, 0x35, 0x00, 0x44, 0x00,
	0x32, 0x00, 0x39, 0x00, 0x45, 0x00, 0x45, 0x00, 0x42, 0x00, 0x38, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x37, 0x00, 0x39, 0x00, 0x33, 0x00, 0x45, 0x00, 0x38, 0x00, 0x42, 0x00, 0x37, 0x00,
	0x45, 0x00, 0x44, 0x00, 0x37, 0x00, 0x36, 0x00, 0x34, 0x00, 0x30, 0x00, 0x36, 0x00, 0x09, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x31, 0x00, 0x38, 0x00, 0x35, 0x00, 0x37, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x31, 0x00,
	0x36, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x32, 0x00, 0x39, 0x00, 0x39, 0x00,
	0x37, 0x00, 0x44, 0x00, 0x44, 0x00, 0x36, 0x00, 0x31, 0x00, 0x39, 0x00, 0x30, 0x00, 0x38, 0x00,
	0x44, 0x00, 0x33, 0x00, 0x44, 0x00, 0x31, 0x00, 0x38, 0x00, 0x30, 0x00, 0x36, 0x00, 0x37, 0x00,
	0x38, 0x00, 0x44, 0x00, 0x33, 0x00, 0x31, 0x00, 0x41, 0x00, 0x44, 0x00, 0x35, 0x00, 0x45, 0x00,
	0x42, 0x00, 0x34, 0x00, 0x32, 0x00, 0x41, 0x00, 0x38, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x55, 0x00, 0x6e, 0x00, 0x61, 0x00,
	0x6c, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00, 0x64, 0x00,
	0x20, 0x00, 0x43, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x73, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x32, 0x00, 0x38, 0x00, 0x32, 0x00, 0x36, 0x00,
	0x32, 0x00, 0x34, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00,
	0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00,
	0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x32, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00, 0x32, 0x00, 0x20, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x32, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x20, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x34, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x39, 0x00, 0x20, 0x00,
	0x32, 0x00, 0x33, 0x00, 0x38, 0x00, 0x20, 0x00, 0x37, 0x00, 0x63, 0x00, 0x64, 0x00, 0x63, 0x00,
	0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x36, 0x00, 0x32, 0x00, 0x39, 0x00,
	0x31, 0x00, 0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x0a, 0x00, 0x0a, 0x00 };

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

/* Tests the libewf_ltree_section_read_data function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_ltree_section_read_data(
     void )
{
	libcerror_error_t *error      = NULL;
	uint8_t *single_files_data    = NULL;
	size_t single_files_data_size = 0;
	int result                    = 0;

	/* Test regular cases
	 */
	single_files_data      = NULL;
	single_files_data_size = 0;

	result = libewf_ltree_section_read_data(
	          ewf_test_ltree_section_data1,
	          5748,
	          1,
	          &single_files_data,
	          &single_files_data_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	single_files_data      = NULL;
	single_files_data_size = 0;

	result = libewf_ltree_section_read_data(
	          NULL,
	          5748,
	          1,
	          &single_files_data,
	          &single_files_data_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_ltree_section_read_data(
	          ewf_test_ltree_section_data1,
	          (size_t) SSIZE_MAX + 1,
	          1,
	          &single_files_data,
	          &single_files_data_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_ltree_section_read_data(
	          ewf_test_ltree_section_data1,
	          0,
	          1,
	          &single_files_data,
	          &single_files_data_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_ltree_section_read_data(
	          ewf_test_ltree_section_data1,
	          5748,
	          0,
	          &single_files_data,
	          &single_files_data_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_ltree_section_read_data(
	          ewf_test_ltree_section_data1,
	          5748,
	          1,
	          NULL,
	          &single_files_data_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	single_files_data = (uint8_t *) 0x12345678UL;

	result = libewf_ltree_section_read_data(
	          ewf_test_ltree_section_data1,
	          5748,
	          1,
	          &single_files_data,
	          &single_files_data_size,
	          &error );

	single_files_data = NULL;

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_ltree_section_read_data(
	          ewf_test_ltree_section_data1,
	          5748,
	          1,
	          &single_files_data,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_ltree_section_read_data(
	          ewf_test_ltree_section_data1,
	          0,
	          1,
	          &single_files_data,
	          &single_files_data_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

#if defined( HAVE_EWF_TEST_MEMORY ) && defined( OPTIMIZATION_DISABLED )

	/* Test libewf_ltree_section_read_data with memcpy failing
	 */
	ewf_test_memcpy_attempts_before_fail = 0;

	result = libewf_ltree_section_read_data(
	          ewf_test_ltree_section_data1,
	          5748,
	          1,
	          &single_files_data,
	          &single_files_data_size,
	          &error );

	if( ewf_test_memcpy_attempts_before_fail != -1 )
	{
		ewf_test_memcpy_attempts_before_fail = -1;
	}
	else
	{
		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
#endif /* defined( HAVE_EWF_TEST_MEMORY ) && defined( OPTIMIZATION_DISABLED ) */

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_ltree_section_read_file_io_pool function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_ltree_section_read_file_io_pool(
     void )
{
	libbfio_pool_t *file_io_pool                    = NULL;
	libcerror_error_t *error                        = NULL;
	libewf_io_handle_t *io_handle                   = NULL;
	libewf_section_descriptor_t *section_descriptor = NULL;
	uint8_t *section_data                           = NULL;
	uint8_t *single_files_data                      = NULL;
	size_t section_data_size                        = 0;
	size_t single_files_data_size                   = 0;
	ssize_t read_count                              = 0;
	int result                                      = 0;

	/* Initialize test
	 */
	result = libewf_section_descriptor_initialize(
	          &section_descriptor,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "section_descriptor",
	 section_descriptor );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	section_descriptor->data_size = 5748;

	result = libewf_io_handle_initialize(
	          &io_handle,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "io_handle",
	 io_handle );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Initialize file IO pool
	 */
	result = ewf_test_open_file_io_pool(
	          &file_io_pool,
	          ewf_test_ltree_section_data1,
	          5748,
	          LIBBFIO_OPEN_READ,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "file_io_pool",
	 file_io_pool );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	single_files_data      = NULL;
	single_files_data_size = 0;

	read_count = libewf_ltree_section_read_file_io_pool(
	              section_descriptor,
	              io_handle,
	              file_io_pool,
	              0,
	              2,
	              &section_data,
	              &section_data_size,
	              &single_files_data,
	              &single_files_data_size,
	              &error );

	EWF_TEST_ASSERT_EQUAL_SSIZE(
	 "read_count",
	 read_count,
	 (ssize_t) 5748 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "section_data",
	 section_data );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	memory_free(
	 section_data );

	section_data = NULL;

	/* Test error cases
	 */
	read_count = libewf_ltree_section_read_file_io_pool(
	              NULL,
	              io_handle,
	              file_io_pool,
	              0,
	              2,
	              &section_data,
	              &section_data_size,
	              &single_files_data,
	              &single_files_data_size,
	              &error );

	EWF_TEST_ASSERT_EQUAL_SSIZE(
	 "read_count",
	 read_count,
	 (ssize_t) -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Test libewf_ltree_section_read_file_io_pool failing in libewf_section_read_data
	 */
	section_descriptor->data_size = 0;

	read_count = libewf_ltree_section_read_file_io_pool(
	              NULL,
	              io_handle,
	              file_io_pool,
	              0,
	              2,
	              &section_data,
	              &section_data_size,
	              &single_files_data,
	              &single_files_data_size,
	              &error );

	section_descriptor->data_size = 5748;

	EWF_TEST_ASSERT_EQUAL_SSIZE(
	 "read_count",
	 read_count,
	 (ssize_t) -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Clean up file IO pool
	 */
	result = ewf_test_close_file_io_pool(
	          &file_io_pool,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 0 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Clean up
	 */
	result = libewf_io_handle_free(
	          &io_handle,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "io_handle",
	 io_handle );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_section_descriptor_free(
	          &section_descriptor,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "section_descriptor",
	 section_descriptor );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( file_io_pool != NULL )
	{
		libbfio_pool_free(
		 &file_io_pool,
		 NULL );
	}
	if( io_handle != NULL )
	{
		libewf_io_handle_free(
		 &io_handle,
		 NULL );
	}
	if( section_descriptor != NULL )
	{
		libewf_section_descriptor_free(
		 &section_descriptor,
		 NULL );
	}
	return( 0 );
}

/* Tests the libewf_ltree_section_write_file_io_pool function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_ltree_section_write_file_io_pool(
     void )
{
	uint8_t section_data[ 512 ];
	uint8_t single_files_section_data[ 386 ];

	libbfio_pool_t *file_io_pool                    = NULL;
	libcerror_error_t *error                        = NULL;
	libewf_io_handle_t *io_handle                   = NULL;
	libewf_section_descriptor_t *section_descriptor = NULL;
	ssize_t write_count                             = 0;
	off64_t offset                                  = 0;
	int result                                      = 0;

	/* Initialize test
	 */
	result = libewf_section_descriptor_initialize(
	          &section_descriptor,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "section_descriptor",
	 section_descriptor );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_io_handle_initialize(
	          &io_handle,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "io_handle",
	 io_handle );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Initialize file IO pool
	 */
	result = ewf_test_open_file_io_pool(
	          &file_io_pool,
	          section_data,
	          512,
	          LIBBFIO_OPEN_WRITE,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "file_io_pool",
	 file_io_pool );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	write_count = libewf_ltree_section_write_file_io_pool(
	               section_descriptor,
	               io_handle,
	               file_io_pool,
	               0,
	               1,
	               0,
	               single_files_section_data,
	               386,
	               &( single_files_section_data[ 48 ] ),
	               256,
	               &error );

	EWF_TEST_ASSERT_EQUAL_SSIZE(
	 "write_count",
	 write_count,
	 (ssize_t) 380 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	offset = libbfio_pool_seek_offset(
	          file_io_pool,
	          0,
	          0,
	          SEEK_SET,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT64(
	 "offset",
	 offset,
	 (int64_t) 0 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	write_count = libewf_ltree_section_write_file_io_pool(
	               section_descriptor,
	               io_handle,
	               file_io_pool,
	               0,
	               2,
	               0,
	               single_files_section_data,
	               386,
	               &( single_files_section_data[ 48 ] ),
	               256,
	               &error );

	EWF_TEST_ASSERT_EQUAL_SSIZE(
	 "write_count",
	 write_count,
	 (ssize_t) 320 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	offset = libbfio_pool_seek_offset(
	          file_io_pool,
	          0,
	          0,
	          SEEK_SET,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT64(
	 "offset",
	 offset,
	 (int64_t) 0 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	write_count = libewf_ltree_section_write_file_io_pool(
	               NULL,
	               io_handle,
	               file_io_pool,
	               0,
	               1,
	               0,
	               single_files_section_data,
	               256,
	               single_files_section_data,
	               256,
	               &error );

	EWF_TEST_ASSERT_EQUAL_SSIZE(
	 "write_count",
	 write_count,
	 (ssize_t) -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

/* TODO add test coverage */

	/* Clean up file IO pool
	 */
	result = ewf_test_close_file_io_pool(
	          &file_io_pool,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 0 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Clean up
	 */
	result = libewf_io_handle_free(
	          &io_handle,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "io_handle",
	 io_handle );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_section_descriptor_free(
	          &section_descriptor,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "section_descriptor",
	 section_descriptor );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( file_io_pool != NULL )
	{
		libbfio_pool_free(
		 &file_io_pool,
		 NULL );
	}
	if( io_handle != NULL )
	{
		libewf_io_handle_free(
		 &io_handle,
		 NULL );
	}
	if( section_descriptor != NULL )
	{
		libewf_section_descriptor_free(
		 &section_descriptor,
		 NULL );
	}
	return( 0 );
}

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

/* The main program
 */
#if defined( HAVE_WIDE_SYSTEM_CHARACTER )
int wmain(
     int argc EWF_TEST_ATTRIBUTE_UNUSED,
     wchar_t * const argv[] EWF_TEST_ATTRIBUTE_UNUSED )
#else
int main(
     int argc EWF_TEST_ATTRIBUTE_UNUSED,
     char * const argv[] EWF_TEST_ATTRIBUTE_UNUSED )
#endif
{
	EWF_TEST_UNREFERENCED_PARAMETER( argc )
	EWF_TEST_UNREFERENCED_PARAMETER( argv )

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

	EWF_TEST_RUN(
	 "libewf_ltree_section_read_data",
	 ewf_test_ltree_section_read_data );

	EWF_TEST_RUN(
	 "libewf_ltree_section_read_file_io_pool",
	 ewf_test_ltree_section_read_file_io_pool );

	EWF_TEST_RUN(
	 "libewf_ltree_section_write_file_io_pool",
	 ewf_test_ltree_section_write_file_io_pool );

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

	return( EXIT_SUCCESS );

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

on_error:
	return( EXIT_FAILURE );

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */
}

