/**
 * @file
 * @brief Function prototypes for the new opcode functions.
 * @note  DO NOT EDIT THIS FILE, your changes will be lost.
 *        Edit ir/be/amd64/amd64_spec.pl instead.
 *        created by: ir/be/scripts/generate_new_opcodes.pl ir/be/amd64/amd64_spec.pl ir/be/amd64
 * @date  Mon Nov 19 18:12:23 2012
 */
#ifndef FIRM_BE_AMD64_GEN_AMD64_NEW_NODES_H
#define FIRM_BE_AMD64_GEN_AMD64_NEW_NODES_H

typedef enum amd64_opcodes {
	iro_amd64_Add,
	iro_amd64_Store,
	iro_amd64_FrameAddr,
	iro_amd64_Jcc,
	iro_amd64_Immediate,
	iro_amd64_Push,
	iro_amd64_Neg,
	iro_amd64_Cmp,
	iro_amd64_SymConst,
	iro_amd64_Load,
	iro_amd64_Sub,
	iro_amd64_Jmp,
	iro_amd64_Mul,
	iro_amd64_Conv,
	iro_amd64_last_generated,
	iro_amd64_last = iro_amd64_last_generated
} amd64_opcodes;

int is_amd64_irn(const ir_node *node);
int is_amd64_op(const ir_op *op);

int get_amd64_opcode_first(void);
int get_amd64_opcode_last(void);
int get_amd64_irn_opcode(const ir_node *node);
void amd64_create_opcodes(const arch_irn_ops_t *be_ops);
void amd64_free_opcodes(void);
extern ir_op *op_amd64_Add;
ir_op *get_op_amd64_Add(void);
int is_amd64_Add(const ir_node *n);
/**
 * construct Add node
 */
ir_node *new_bd_amd64_Add(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_amd64_Store;
ir_op *get_op_amd64_Store(void);
int is_amd64_Store(const ir_node *n);
/**
 * construct Store node
 */
ir_node *new_bd_amd64_Store(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_entity *entity);

extern ir_op *op_amd64_FrameAddr;
ir_op *get_op_amd64_FrameAddr(void);
int is_amd64_FrameAddr(const ir_node *n);
/**
 * construct FrameAddr node
 */
ir_node *new_bd_amd64_FrameAddr(dbg_info *dbgi, ir_node *block, ir_node *base, ir_entity *entity);

extern ir_op *op_amd64_Jcc;
ir_op *get_op_amd64_Jcc(void);
int is_amd64_Jcc(const ir_node *n);
/**
 * construct Jcc node
 */
ir_node *new_bd_amd64_Jcc(dbg_info *dbgi, ir_node *block, ir_node *eflags, ir_relation relation);

extern ir_op *op_amd64_Immediate;
ir_op *get_op_amd64_Immediate(void);
int is_amd64_Immediate(const ir_node *n);
/**
 * construct Immediate node
 */
ir_node *new_bd_amd64_Immediate(dbg_info *dbgi, ir_node *block, unsigned imm_value);

extern ir_op *op_amd64_Push;
ir_op *get_op_amd64_Push(void);
int is_amd64_Push(const ir_node *n);
/**
 * construct Push node
 */
ir_node *new_bd_amd64_Push(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val, ir_node *stack);

extern ir_op *op_amd64_Neg;
ir_op *get_op_amd64_Neg(void);
int is_amd64_Neg(const ir_node *n);
/**
 * construct Neg node
 */
ir_node *new_bd_amd64_Neg(dbg_info *dbgi, ir_node *block, ir_node *val);

extern ir_op *op_amd64_Cmp;
ir_op *get_op_amd64_Cmp(void);
int is_amd64_Cmp(const ir_node *n);
/**
 * construct Cmp node
 */
ir_node *new_bd_amd64_Cmp(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, int ins_permuted, int cmp_unsigned);

extern ir_op *op_amd64_SymConst;
ir_op *get_op_amd64_SymConst(void);
int is_amd64_SymConst(const ir_node *n);
/**
 * construct SymConst node
 */
ir_node *new_bd_amd64_SymConst(dbg_info *dbgi, ir_node *block, ir_entity *entity);

extern ir_op *op_amd64_Load;
ir_op *get_op_amd64_Load(void);
int is_amd64_Load(const ir_node *n);
/**
 * construct Load node
 */
ir_node *new_bd_amd64_Load(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity);

extern ir_op *op_amd64_Sub;
ir_op *get_op_amd64_Sub(void);
int is_amd64_Sub(const ir_node *n);
/**
 * construct Sub node
 */
ir_node *new_bd_amd64_Sub(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_amd64_Jmp;
ir_op *get_op_amd64_Jmp(void);
int is_amd64_Jmp(const ir_node *n);
/**
 * construct Jmp node
 */
ir_node *new_bd_amd64_Jmp(dbg_info *dbgi, ir_node *block);

extern ir_op *op_amd64_Mul;
ir_op *get_op_amd64_Mul(void);
int is_amd64_Mul(const ir_node *n);
/**
 * construct Mul node
 */
ir_node *new_bd_amd64_Mul(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_amd64_Conv;
ir_op *get_op_amd64_Conv(void);
int is_amd64_Conv(const ir_node *n);
/**
 * construct Conv node
 */
ir_node *new_bd_amd64_Conv(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *smaller_mode);



enum pn_amd64_Add {
	pn_amd64_Add_res = 0,
};

enum n_amd64_Add {
	n_amd64_Add_left = 0,
	n_amd64_Add_right = 1,
};

enum pn_amd64_Store {
	pn_amd64_Store_M = 0,
};

enum n_amd64_Store {
	n_amd64_Store_ptr = 0,
	n_amd64_Store_val = 1,
	n_amd64_Store_mem = 2,
};

enum n_amd64_FrameAddr {
	n_amd64_FrameAddr_base = 0,
};

enum pn_amd64_Jcc {
	pn_amd64_Jcc_false = 0,
	pn_amd64_Jcc_true = 1,
};

enum n_amd64_Jcc {
	n_amd64_Jcc_eflags = 0,
};

enum pn_amd64_Push {
	pn_amd64_Push_stack = 0,
	pn_amd64_Push_M = 1,
};

enum n_amd64_Push {
	n_amd64_Push_base = 0,
	n_amd64_Push_index = 1,
	n_amd64_Push_mem = 2,
	n_amd64_Push_val = 3,
	n_amd64_Push_stack = 4,
};

enum pn_amd64_Neg {
	pn_amd64_Neg_res = 0,
	pn_amd64_Neg_flags = 1,
};

enum n_amd64_Neg {
	n_amd64_Neg_val = 0,
};

enum pn_amd64_Cmp {
	pn_amd64_Cmp_eflags = 0,
};

enum n_amd64_Cmp {
	n_amd64_Cmp_left = 0,
	n_amd64_Cmp_right = 1,
};

enum pn_amd64_SymConst {
	pn_amd64_SymConst_res = 0,
};

enum pn_amd64_Load {
	pn_amd64_Load_res = 0,
	pn_amd64_Load_M = 1,
};

enum n_amd64_Load {
	n_amd64_Load_ptr = 0,
	n_amd64_Load_mem = 1,
};

enum pn_amd64_Sub {
	pn_amd64_Sub_res = 0,
};

enum n_amd64_Sub {
	n_amd64_Sub_left = 0,
	n_amd64_Sub_right = 1,
};

enum pn_amd64_Mul {
	pn_amd64_Mul_res = 0,
};

enum n_amd64_Mul {
	n_amd64_Mul_left = 0,
	n_amd64_Mul_right = 1,
};

enum pn_amd64_Conv {
	pn_amd64_Conv_res = 0,
};

enum n_amd64_Conv {
	n_amd64_Conv_val = 0,
};


#endif
