/**
 * @file
 * @brief Contains additional external requirements defs for external includes.
 * @note   DO NOT EDIT THIS FILE, your changes will be lost.
 *         Edit ir/be/arm/arm_spec.pl instead.
 *         created by: ir/be/scripts/generate_regalloc_if.pl ir/be/arm/arm_spec.pl ir/be/arm
 * @date   Mon Nov 19 18:12:23 2012
 */
#ifndef FIRM_BE_ARM_GEN_ARM_REGALLOC_IF_H
#define FIRM_BE_ARM_GEN_ARM_REGALLOC_IF_H

#include "bearch.h"
#include "arm_nodes_attr.h"

/** global register indices for arm registers */
enum reg_indices {
	REG_FL,
	REG_R0,
	REG_R1,
	REG_R2,
	REG_R3,
	REG_R4,
	REG_R5,
	REG_R6,
	REG_R7,
	REG_R8,
	REG_R9,
	REG_R10,
	REG_R11,
	REG_R12,
	REG_SP,
	REG_LR,
	REG_PC,
	REG_F0,
	REG_F1,
	REG_F2,
	REG_F3,
	REG_F4,
	REG_F5,
	REG_F6,
	REG_F7,

	N_ARM_REGISTERS
};
/** local register indices for arm registers */
enum {
	REG_FLAGS_FL = 0,
	REG_GP_R0 = 0,
	REG_GP_R1 = 1,
	REG_GP_R2 = 2,
	REG_GP_R3 = 3,
	REG_GP_R4 = 4,
	REG_GP_R5 = 5,
	REG_GP_R6 = 6,
	REG_GP_R7 = 7,
	REG_GP_R8 = 8,
	REG_GP_R9 = 9,
	REG_GP_R10 = 10,
	REG_GP_R11 = 11,
	REG_GP_R12 = 12,
	REG_GP_SP = 13,
	REG_GP_LR = 14,
	REG_GP_PC = 15,
	REG_FPA_F0 = 0,
	REG_FPA_F1 = 1,
	REG_FPA_F2 = 2,
	REG_FPA_F3 = 3,
	REG_FPA_F4 = 4,
	REG_FPA_F5 = 5,
	REG_FPA_F6 = 6,
	REG_FPA_F7 = 7,

};

/** number of registers in arm register classes. */
enum {
	N_arm_flags_REGS = 1,
	N_arm_gp_REGS = 16,
	N_arm_fpa_REGS = 8,

};
enum reg_classes {
	CLASS_arm_flags = 0,
	CLASS_arm_gp = 1,
	CLASS_arm_fpa = 2,
	N_ARM_CLASSES = 3
};



extern const arch_register_t arm_registers[N_ARM_REGISTERS];

extern arch_register_class_t arm_reg_classes[N_ARM_CLASSES];

void arm_register_init(void);

#endif
