/**
 * @file
 * @brief     Generated functions to emit code for assembler ir nodes.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit ir/be/ia32/ia32_spec.pl instead.
 *            created by: ir/be/scripts/generate_emitter.pl ir/be/ia32/ia32_spec.pl ir/be/ia32
 * @date      Mon Nov 19 18:12:23 2012
 */
#include "config.h"

#include <stdio.h>
#include <assert.h>

#include "irnode.h"
#include "irop_t.h"
#include "irprog_t.h"
#include "beemitter.h"

#include "gen_ia32_emitter.h"
#include "ia32_new_nodes.h"
#include "ia32_emitter.h"

static void emit_ia32_xZero(const ir_node *node)
{
	ia32_emitf(node, "xorp%FX %D0, %D0");
}

static void emit_ia32_FldCW(const ir_node *node)
{
	ia32_emitf(node, "fldcw %AM");
}

static void emit_ia32_fadd(const ir_node *node)
{
	ia32_emitf(node, "fadd%FP%FM %AF");
}

static void emit_ia32_ShrMem(const ir_node *node)
{
	ia32_emitf(node, "shr%M %<S3, %AM");
}

static void emit_ia32_CvtSI2SS(const ir_node *node)
{
	ia32_emitf(node, "cvtsi2ss %AS3, %D0");
}

static void emit_ia32_Bsf(const ir_node *node)
{
	ia32_emitf(node, "bsf%M %AS3, %D0");
}

static void emit_ia32_LdTls(const ir_node *node)
{
	ia32_emitf(node, "movl %%gs:0, %D0");
}

static void emit_ia32_ShlD(const ir_node *node)
{
	ia32_emitf(node, "shld%M %<S2, %S1, %D0");
}

static void emit_ia32_PopEbp(const ir_node *node)
{
	ia32_emitf(node, "pop%M %D0");
}

static void emit_ia32_Inc(const ir_node *node)
{
	ia32_emitf(node, "inc%M %S0");
}

static void emit_ia32_xStore(const ir_node *node)
{
	ia32_emitf(node, "movs%FX %S3, %AM");
}

static void emit_ia32_xxLoad(const ir_node *node)
{
	ia32_emitf(node, "movdqu %D0, %AM");
}

static void emit_ia32_xAnd(const ir_node *node)
{
	ia32_emitf(node, "andp%FX %B");
}

static void emit_ia32_xAdd(const ir_node *node)
{
	ia32_emitf(node, "adds%FX %B");
}

static void emit_ia32_xPsllq(const ir_node *node)
{
	ia32_emitf(node, "psllq %#S1, %D0");
}

static void emit_ia32_xxStore(const ir_node *node)
{
	ia32_emitf(node, "movdqu %B");
}

static void emit_ia32_Call(const ir_node *node)
{
	ia32_emitf(node, "call %*AS3");
}

static void emit_ia32_FnstCWNOP(const ir_node *node)
{
	(void) node;
}

static void emit_ia32_XorMem8Bit(const ir_node *node)
{
	ia32_emitf(node, "xor%M %#S3, %AM");
}

static void emit_ia32_fldl2t(const ir_node *node)
{
	ia32_emitf(node, "fldll2t");
}

static void emit_ia32_fisttp(const ir_node *node)
{
	ia32_emitf(node, "fisttp%FM %AM");
}

static void emit_ia32_DecMem(const ir_node *node)
{
	ia32_emitf(node, "dec%M %AM");
}

static void emit_ia32_emms(const ir_node *node)
{
	ia32_emitf(node, "emms");
}

static void emit_ia32_xLoad(const ir_node *node)
{
	ia32_emitf(node, "movs%FX %AM, %D0");
}

static void emit_ia32_CvtSI2SD(const ir_node *node)
{
	ia32_emitf(node, "cvtsi2sd %AS3, %D0");
}

static void emit_ia32_XorMem(const ir_node *node)
{
	ia32_emitf(node, "xor%M %#S3, %AM");
}

static void emit_ia32_Xor0(const ir_node *node)
{
	ia32_emitf(node, "xor%M %D0, %D0");
}

static void emit_ia32_Sar(const ir_node *node)
{
	ia32_emitf(node, "sar%M %<S1, %S0");
}

static void emit_ia32_Div(const ir_node *node)
{
	ia32_emitf(node, "div%M %AS3");
}

static void emit_ia32_fpushCopy(const ir_node *node)
{
	ia32_emitf(node, "fld %F0");
}

static void emit_ia32_Stc(const ir_node *node)
{
	ia32_emitf(node, "stc");
}

static void emit_ia32_Fucomi(const ir_node *node)
{
	ia32_emitf(node, "fucom%FPi %F0");
}

static void emit_ia32_fldl2e(const ir_node *node)
{
	ia32_emitf(node, "fldl2e");
}

static void emit_ia32_Enter(const ir_node *node)
{
	ia32_emitf(node, "enter");
}

static void emit_ia32_fmul(const ir_node *node)
{
	ia32_emitf(node, "fmul%FP%FM %AF");
}

static void emit_ia32_NoReg_XMM(const ir_node *node)
{
	(void) node;
}

static void emit_ia32_xMax(const ir_node *node)
{
	ia32_emitf(node, "maxs%FX %B");
}

static void emit_ia32_OrMem8Bit(const ir_node *node)
{
	ia32_emitf(node, "or%M %#S3, %AM");
}

static void emit_ia32_Prefetch1(const ir_node *node)
{
	ia32_emitf(node, "prefetcht1 %AM");
}

static void emit_ia32_fsub(const ir_node *node)
{
	ia32_emitf(node, "fsub%FR%FP%FM %AF");
}

static void emit_ia32_Lea(const ir_node *node)
{
	ia32_emitf(node, "leal %AM, %D0");
}

static void emit_ia32_FtstFnstsw(const ir_node *node)
{
	ia32_emitf(node, "ftst");
	ia32_emitf(node, "fnstsw %%ax");
}

static void emit_ia32_NotMem(const ir_node *node)
{
	ia32_emitf(node, "not%M %AM");
}

static void emit_ia32_Sbb0(const ir_node *node)
{
	ia32_emitf(node, "sbb%M %D0, %D0");
}

static void emit_ia32_Bt(const ir_node *node)
{
	ia32_emitf(node, "bt%M %S1, %S0");
}

static void emit_ia32_Or(const ir_node *node)
{
	ia32_emitf(node, "or%M %B");
}

static void emit_ia32_Xor(const ir_node *node)
{
	ia32_emitf(node, "xor%M %B");
}

static void emit_ia32_IncMem(const ir_node *node)
{
	ia32_emitf(node, "inc%M %AM");
}

static void emit_ia32_xAllOnes(const ir_node *node)
{
	ia32_emitf(node, "pcmpeqb %D0, %D0");
}

static void emit_ia32_Breakpoint(const ir_node *node)
{
	ia32_emitf(node, "int3");
}

static void emit_ia32_ffreep(const ir_node *node)
{
	ia32_emitf(node, "ffreep %F0");
}

static void emit_ia32_SubMem(const ir_node *node)
{
	ia32_emitf(node, "sub%M %#S3, %AM");
}

static void emit_ia32_AddMem(const ir_node *node)
{
	ia32_emitf(node, "add%M %#S3, %AM");
}

static void emit_ia32_ShlMem(const ir_node *node)
{
	ia32_emitf(node, "shl%M %<S3, %AM");
}

static void emit_ia32_fdiv(const ir_node *node)
{
	ia32_emitf(node, "fdiv%FR%FP%FM %AF");
}

static void emit_ia32_Outport(const ir_node *node)
{
	ia32_emitf(node, "out%M %^S0, %#S1");
}

static void emit_ia32_xMin(const ir_node *node)
{
	ia32_emitf(node, "mins%FX %B");
}

static void emit_ia32_fist(const ir_node *node)
{
	ia32_emitf(node, "fist%FP%FM %AM");
}

static void emit_ia32_xXor(const ir_node *node)
{
	ia32_emitf(node, "xorp%FX %B");
}

static void emit_ia32_IJmp(const ir_node *node)
{
	ia32_emitf(node, "jmp %*AS3");
}

static void emit_ia32_NegMem(const ir_node *node)
{
	ia32_emitf(node, "neg%M %AM");
}

static void emit_ia32_Mul(const ir_node *node)
{
	ia32_emitf(node, "mul%M %AS4");
}

static void emit_ia32_Sahf(const ir_node *node)
{
	ia32_emitf(node, "sahf");
}

static void emit_ia32_SubMem8Bit(const ir_node *node)
{
	ia32_emitf(node, "sub%M %#S3, %AM");
}

static void emit_ia32_AddMem8Bit(const ir_node *node)
{
	ia32_emitf(node, "add%M %#S3, %AM");
}

static void emit_ia32_fst(const ir_node *node)
{
	ia32_emitf(node, "fst%FP%FM %AM");
}

static void emit_ia32_FucomppFnstsw(const ir_node *node)
{
	ia32_emitf(node, "fucompp");
	ia32_emitf(node, "fnstsw %%ax");
}

static void emit_ia32_RorMem(const ir_node *node)
{
	ia32_emitf(node, "ror%M %<S3, %AM");
}

static void emit_ia32_fpush(const ir_node *node)
{
	ia32_emitf(node, "fld %F0");
}

static void emit_ia32_fild(const ir_node *node)
{
	ia32_emitf(node, "fild%FM %AM");
}

static void emit_ia32_xOr(const ir_node *node)
{
	ia32_emitf(node, "orp%FX %B");
}

static void emit_ia32_Conv_I2I8Bit(const ir_node *node)
{
	ia32_emitf(node, "mov%#Ml %#AS3, %D0");
}

static void emit_ia32_Store(const ir_node *node)
{
	ia32_emitf(node, "mov%M %#S3, %AM");
}

static void emit_ia32_fldln2(const ir_node *node)
{
	ia32_emitf(node, "fldln2");
}

static void emit_ia32_Ucomi(const ir_node *node)
{
	ia32_emitf(node, "ucomis%FX %B");
}

static void emit_ia32_fldz(const ir_node *node)
{
	ia32_emitf(node, "fldz");
}

static void emit_ia32_Store8Bit(const ir_node *node)
{
	ia32_emitf(node, "mov%M %#S3, %AM");
}

static void emit_ia32_fpop(const ir_node *node)
{
	ia32_emitf(node, "fstp %F0");
}

static void emit_ia32_Sbb(const ir_node *node)
{
	ia32_emitf(node, "sbb%M %B");
}

static void emit_ia32_FucomFnstsw(const ir_node *node)
{
	ia32_emitf(node, "fucom%FP %F0");
	ia32_emitf(node, "fnstsw %%ax");
}

static void emit_ia32_xMul(const ir_node *node)
{
	ia32_emitf(node, "muls%FX %B");
}

static void emit_ia32_Push(const ir_node *node)
{
	ia32_emitf(node, "push%M %AS3");
}

static void emit_ia32_xPslld(const ir_node *node)
{
	ia32_emitf(node, "pslld %#S1, %D0");
}

static void emit_ia32_Cmp(const ir_node *node)
{
	ia32_emitf(node, "cmp%M %B");
}

static void emit_ia32_xSub(const ir_node *node)
{
	ia32_emitf(node, "subs%FX %B");
}

static void emit_ia32_xMovd(const ir_node *node)
{
	ia32_emitf(node, "movd %S0, %D0");
}

static void emit_ia32_Cltd(const ir_node *node)
{
	ia32_emitf(node, "cltd");
}

static void emit_ia32_xPsrld(const ir_node *node)
{
	ia32_emitf(node, "psrld %#S1, %D0");
}

static void emit_ia32_PushEax(const ir_node *node)
{
	ia32_emitf(node, "pushl %%eax");
}

static void emit_ia32_XorHighLow(const ir_node *node)
{
	ia32_emitf(node, "xorb %>S0, %<S0");
}

static void emit_ia32_xPzero(const ir_node *node)
{
	ia32_emitf(node, "pxor %D0, %D0");
}

static void emit_ia32_Rol(const ir_node *node)
{
	ia32_emitf(node, "rol%M %<S1, %D0");
}

static void emit_ia32_Cmc(const ir_node *node)
{
	ia32_emitf(node, "cmc");
}

static void emit_ia32_Cmp8Bit(const ir_node *node)
{
	ia32_emitf(node, "cmpb %B");
}

static void emit_ia32_xDiv(const ir_node *node)
{
	ia32_emitf(node, "divs%FX %B");
}

static void emit_ia32_xUnknown(const ir_node *node)
{
	(void) node;
}

static void emit_ia32_Test8Bit(const ir_node *node)
{
	ia32_emitf(node, "testb %B");
}

static void emit_ia32_Sub(const ir_node *node)
{
	ia32_emitf(node, "sub%M %B");
}

static void emit_ia32_PrefetchNTA(const ir_node *node)
{
	ia32_emitf(node, "prefetchnta %AM");
}

static void emit_ia32_Shr(const ir_node *node)
{
	ia32_emitf(node, "shr%M %<S1, %S0");
}

static void emit_ia32_fprem(const ir_node *node)
{
	ia32_emitf(node, "fprem1");
}

static void emit_ia32_IDiv(const ir_node *node)
{
	ia32_emitf(node, "idiv%M %AS3");
}

static void emit_ia32_ProduceVal(const ir_node *node)
{
	(void) node;
}

static void emit_ia32_Bswap(const ir_node *node)
{
	ia32_emitf(node, "bswap%M %S0");
}

static void emit_ia32_SetccMem(const ir_node *node)
{
	ia32_emitf(node, "set%P3 %AM");
}

static void emit_ia32_Test(const ir_node *node)
{
	ia32_emitf(node, "test%M %B");
}

static void emit_ia32_AddSP(const ir_node *node)
{
	ia32_emitf(node, "addl %B");
}

static void emit_ia32_RolMem(const ir_node *node)
{
	ia32_emitf(node, "rol%M %<S3, %AM");
}

static void emit_ia32_Prefetch2(const ir_node *node)
{
	ia32_emitf(node, "prefetcht2 %AM");
}

static void emit_ia32_NoReg_GP(const ir_node *node)
{
	(void) node;
}

static void emit_ia32_Const(const ir_node *node)
{
	ia32_emitf(node, "movl %I, %D0");
}

static void emit_ia32_FnstCW(const ir_node *node)
{
	ia32_emitf(node, "fnstcw %AM");
}

static void emit_ia32_Prefetch0(const ir_node *node)
{
	ia32_emitf(node, "prefetcht0 %AM");
}

static void emit_ia32_OrMem(const ir_node *node)
{
	ia32_emitf(node, "or%M %#S3, %AM");
}

static void emit_ia32_fldlg2(const ir_node *node)
{
	ia32_emitf(node, "fldlg2");
}

static void emit_ia32_fld1(const ir_node *node)
{
	ia32_emitf(node, "fld1");
}

static void emit_ia32_Popcnt(const ir_node *node)
{
	ia32_emitf(node, "popcnt%M %AS3, %D0");
}

static void emit_ia32_Ror(const ir_node *node)
{
	ia32_emitf(node, "ror%M %<S1, %S0");
}

static void emit_ia32_Shl(const ir_node *node)
{
	ia32_emitf(node, "shl%M %<S1, %S0");
}

static void emit_ia32_AndMem8Bit(const ir_node *node)
{
	ia32_emitf(node, "and%M %#S3, %AM");
}

static void emit_ia32_Add(const ir_node *node)
{
	ia32_emitf(node, "add%M %B");
}

static void emit_ia32_SubSP(const ir_node *node)
{
	ia32_emitf(node, "subl %B");
	ia32_emitf(node, "movl %%esp, %D1");
}

static void emit_ia32_PrefetchW(const ir_node *node)
{
	ia32_emitf(node, "prefetchw %AM");
}

static void emit_ia32_Conv_I2I(const ir_node *node)
{
	ia32_emitf(node, "mov%#Ml %#AS3, %D0");
}

static void emit_ia32_fxch(const ir_node *node)
{
	ia32_emitf(node, "fxch %F0");
}

static void emit_ia32_fchs(const ir_node *node)
{
	ia32_emitf(node, "fchs");
}

static void emit_ia32_ShrD(const ir_node *node)
{
	ia32_emitf(node, "shrd%M %<S2, %S1, %D0");
}

static void emit_ia32_Unknown(const ir_node *node)
{
	(void) node;
}

static void emit_ia32_UD2(const ir_node *node)
{
	ia32_emitf(node, "ud2");
}

static void emit_ia32_Cwtl(const ir_node *node)
{
	ia32_emitf(node, "cwtl");
}

static void emit_ia32_fabs(const ir_node *node)
{
	ia32_emitf(node, "fabs");
}

static void emit_ia32_fldpi(const ir_node *node)
{
	ia32_emitf(node, "fldpi");
}

static void emit_ia32_Leave(const ir_node *node)
{
	ia32_emitf(node, "leave");
}

static void emit_ia32_Neg(const ir_node *node)
{
	ia32_emitf(node, "neg%M %S0");
}

static void emit_ia32_IMul1OP(const ir_node *node)
{
	ia32_emitf(node, "imul%M %AS4");
}

static void emit_ia32_PopMem(const ir_node *node)
{
	ia32_emitf(node, "pop%M %AM");
}

static void emit_ia32_fld(const ir_node *node)
{
	ia32_emitf(node, "fld%FM %AM");
}

static void emit_ia32_Dec(const ir_node *node)
{
	ia32_emitf(node, "dec%M %S0");
}

static void emit_ia32_Pop(const ir_node *node)
{
	ia32_emitf(node, "pop%M %D0");
}

static void emit_ia32_CopyEbpEsp(const ir_node *node)
{
	ia32_emitf(node, "movl %S0, %D0");
}

static void emit_ia32_Not(const ir_node *node)
{
	ia32_emitf(node, "not%M %S0");
}

static void emit_ia32_NoReg_FP(const ir_node *node)
{
	(void) node;
}

static void emit_ia32_AndMem(const ir_node *node)
{
	ia32_emitf(node, "and%M %#S3, %AM");
}

static void emit_ia32_femms(const ir_node *node)
{
	ia32_emitf(node, "femms");
}

static void emit_ia32_xStoreSimple(const ir_node *node)
{
	ia32_emitf(node, "movs%FX %S3, %AM");
}

static void emit_ia32_And(const ir_node *node)
{
	ia32_emitf(node, "and%M %B");
}

static void emit_ia32_Bsr(const ir_node *node)
{
	ia32_emitf(node, "bsr%M %AS3, %D0");
}

static void emit_ia32_Bswap16(const ir_node *node)
{
	ia32_emitf(node, "xchg %<S0, %>S0");
}

static void emit_ia32_Inport(const ir_node *node)
{
	ia32_emitf(node, "in%M %#D0, %^S0");
}

static void emit_ia32_SarMem(const ir_node *node)
{
	ia32_emitf(node, "sar%M %<S3, %AM");
}

static void emit_ia32_RepPrefix(const ir_node *node)
{
	ia32_emitf(node, "rep");
}

static void emit_ia32_Adc(const ir_node *node)
{
	ia32_emitf(node, "adc%M %B");
}

static void emit_ia32_xAndNot(const ir_node *node)
{
	ia32_emitf(node, "andnp%FX %B");
}

static void emit_ia32_Load(const ir_node *node)
{
	ia32_emitf(node, "mov%#Ml %AM, %D0");
}

static void emit_ia32_Prefetch(const ir_node *node)
{
	ia32_emitf(node, "prefetch %AM");
}


typedef void (*emit_func)(const ir_node *node);

static void ia32_register_emitter(ir_op *op, emit_func func)
{
	assert(op->ops.generic == NULL);
	op->ops.generic = (op_func)func;
}

/**
 * Enters the emitter functions for handled nodes into the generic
 * pointer of an opcode.
 */
void ia32_register_spec_emitters(void)
{
  ia32_register_emitter(op_ia32_xZero, emit_ia32_xZero);
  ia32_register_emitter(op_ia32_FldCW, emit_ia32_FldCW);
  ia32_register_emitter(op_ia32_fadd, emit_ia32_fadd);
  ia32_register_emitter(op_ia32_ShrMem, emit_ia32_ShrMem);
  ia32_register_emitter(op_ia32_CvtSI2SS, emit_ia32_CvtSI2SS);
  ia32_register_emitter(op_ia32_Bsf, emit_ia32_Bsf);
  ia32_register_emitter(op_ia32_LdTls, emit_ia32_LdTls);
  ia32_register_emitter(op_ia32_ShlD, emit_ia32_ShlD);
  ia32_register_emitter(op_ia32_PopEbp, emit_ia32_PopEbp);
  ia32_register_emitter(op_ia32_Inc, emit_ia32_Inc);
  ia32_register_emitter(op_ia32_xStore, emit_ia32_xStore);
  ia32_register_emitter(op_ia32_xxLoad, emit_ia32_xxLoad);
  ia32_register_emitter(op_ia32_xAnd, emit_ia32_xAnd);
  ia32_register_emitter(op_ia32_xAdd, emit_ia32_xAdd);
  ia32_register_emitter(op_ia32_xPsllq, emit_ia32_xPsllq);
  ia32_register_emitter(op_ia32_xxStore, emit_ia32_xxStore);
  ia32_register_emitter(op_ia32_Call, emit_ia32_Call);
  ia32_register_emitter(op_ia32_FnstCWNOP, emit_ia32_FnstCWNOP);
  ia32_register_emitter(op_ia32_XorMem8Bit, emit_ia32_XorMem8Bit);
  ia32_register_emitter(op_ia32_fldl2t, emit_ia32_fldl2t);
  ia32_register_emitter(op_ia32_fisttp, emit_ia32_fisttp);
  ia32_register_emitter(op_ia32_DecMem, emit_ia32_DecMem);
  ia32_register_emitter(op_ia32_emms, emit_ia32_emms);
  ia32_register_emitter(op_ia32_xLoad, emit_ia32_xLoad);
  ia32_register_emitter(op_ia32_CvtSI2SD, emit_ia32_CvtSI2SD);
  ia32_register_emitter(op_ia32_XorMem, emit_ia32_XorMem);
  ia32_register_emitter(op_ia32_Xor0, emit_ia32_Xor0);
  ia32_register_emitter(op_ia32_Sar, emit_ia32_Sar);
  ia32_register_emitter(op_ia32_Div, emit_ia32_Div);
  ia32_register_emitter(op_ia32_fpushCopy, emit_ia32_fpushCopy);
  ia32_register_emitter(op_ia32_Stc, emit_ia32_Stc);
  ia32_register_emitter(op_ia32_Fucomi, emit_ia32_Fucomi);
  ia32_register_emitter(op_ia32_fldl2e, emit_ia32_fldl2e);
  ia32_register_emitter(op_ia32_Enter, emit_ia32_Enter);
  ia32_register_emitter(op_ia32_fmul, emit_ia32_fmul);
  ia32_register_emitter(op_ia32_NoReg_XMM, emit_ia32_NoReg_XMM);
  ia32_register_emitter(op_ia32_xMax, emit_ia32_xMax);
  ia32_register_emitter(op_ia32_OrMem8Bit, emit_ia32_OrMem8Bit);
  ia32_register_emitter(op_ia32_Prefetch1, emit_ia32_Prefetch1);
  ia32_register_emitter(op_ia32_fsub, emit_ia32_fsub);
  ia32_register_emitter(op_ia32_Lea, emit_ia32_Lea);
  ia32_register_emitter(op_ia32_FtstFnstsw, emit_ia32_FtstFnstsw);
  ia32_register_emitter(op_ia32_NotMem, emit_ia32_NotMem);
  ia32_register_emitter(op_ia32_Sbb0, emit_ia32_Sbb0);
  ia32_register_emitter(op_ia32_Bt, emit_ia32_Bt);
  ia32_register_emitter(op_ia32_Or, emit_ia32_Or);
  ia32_register_emitter(op_ia32_Xor, emit_ia32_Xor);
  ia32_register_emitter(op_ia32_IncMem, emit_ia32_IncMem);
  ia32_register_emitter(op_ia32_xAllOnes, emit_ia32_xAllOnes);
  ia32_register_emitter(op_ia32_Breakpoint, emit_ia32_Breakpoint);
  ia32_register_emitter(op_ia32_ffreep, emit_ia32_ffreep);
  ia32_register_emitter(op_ia32_SubMem, emit_ia32_SubMem);
  ia32_register_emitter(op_ia32_AddMem, emit_ia32_AddMem);
  ia32_register_emitter(op_ia32_ShlMem, emit_ia32_ShlMem);
  ia32_register_emitter(op_ia32_fdiv, emit_ia32_fdiv);
  ia32_register_emitter(op_ia32_Outport, emit_ia32_Outport);
  ia32_register_emitter(op_ia32_xMin, emit_ia32_xMin);
  ia32_register_emitter(op_ia32_fist, emit_ia32_fist);
  ia32_register_emitter(op_ia32_xXor, emit_ia32_xXor);
  ia32_register_emitter(op_ia32_IJmp, emit_ia32_IJmp);
  ia32_register_emitter(op_ia32_NegMem, emit_ia32_NegMem);
  ia32_register_emitter(op_ia32_Mul, emit_ia32_Mul);
  ia32_register_emitter(op_ia32_Sahf, emit_ia32_Sahf);
  ia32_register_emitter(op_ia32_SubMem8Bit, emit_ia32_SubMem8Bit);
  ia32_register_emitter(op_ia32_AddMem8Bit, emit_ia32_AddMem8Bit);
  ia32_register_emitter(op_ia32_fst, emit_ia32_fst);
  ia32_register_emitter(op_ia32_FucomppFnstsw, emit_ia32_FucomppFnstsw);
  ia32_register_emitter(op_ia32_RorMem, emit_ia32_RorMem);
  ia32_register_emitter(op_ia32_fpush, emit_ia32_fpush);
  ia32_register_emitter(op_ia32_fild, emit_ia32_fild);
  ia32_register_emitter(op_ia32_xOr, emit_ia32_xOr);
  ia32_register_emitter(op_ia32_Conv_I2I8Bit, emit_ia32_Conv_I2I8Bit);
  ia32_register_emitter(op_ia32_Store, emit_ia32_Store);
  ia32_register_emitter(op_ia32_fldln2, emit_ia32_fldln2);
  ia32_register_emitter(op_ia32_Ucomi, emit_ia32_Ucomi);
  ia32_register_emitter(op_ia32_fldz, emit_ia32_fldz);
  ia32_register_emitter(op_ia32_Store8Bit, emit_ia32_Store8Bit);
  ia32_register_emitter(op_ia32_fpop, emit_ia32_fpop);
  ia32_register_emitter(op_ia32_Sbb, emit_ia32_Sbb);
  ia32_register_emitter(op_ia32_FucomFnstsw, emit_ia32_FucomFnstsw);
  ia32_register_emitter(op_ia32_xMul, emit_ia32_xMul);
  ia32_register_emitter(op_ia32_Push, emit_ia32_Push);
  ia32_register_emitter(op_ia32_xPslld, emit_ia32_xPslld);
  ia32_register_emitter(op_ia32_Cmp, emit_ia32_Cmp);
  ia32_register_emitter(op_ia32_xSub, emit_ia32_xSub);
  ia32_register_emitter(op_ia32_xMovd, emit_ia32_xMovd);
  ia32_register_emitter(op_ia32_Cltd, emit_ia32_Cltd);
  ia32_register_emitter(op_ia32_xPsrld, emit_ia32_xPsrld);
  ia32_register_emitter(op_ia32_PushEax, emit_ia32_PushEax);
  ia32_register_emitter(op_ia32_XorHighLow, emit_ia32_XorHighLow);
  ia32_register_emitter(op_ia32_xPzero, emit_ia32_xPzero);
  ia32_register_emitter(op_ia32_Rol, emit_ia32_Rol);
  ia32_register_emitter(op_ia32_Cmc, emit_ia32_Cmc);
  ia32_register_emitter(op_ia32_Cmp8Bit, emit_ia32_Cmp8Bit);
  ia32_register_emitter(op_ia32_xDiv, emit_ia32_xDiv);
  ia32_register_emitter(op_ia32_xUnknown, emit_ia32_xUnknown);
  ia32_register_emitter(op_ia32_Test8Bit, emit_ia32_Test8Bit);
  ia32_register_emitter(op_ia32_Sub, emit_ia32_Sub);
  ia32_register_emitter(op_ia32_PrefetchNTA, emit_ia32_PrefetchNTA);
  ia32_register_emitter(op_ia32_Shr, emit_ia32_Shr);
  ia32_register_emitter(op_ia32_fprem, emit_ia32_fprem);
  ia32_register_emitter(op_ia32_IDiv, emit_ia32_IDiv);
  ia32_register_emitter(op_ia32_ProduceVal, emit_ia32_ProduceVal);
  ia32_register_emitter(op_ia32_Bswap, emit_ia32_Bswap);
  ia32_register_emitter(op_ia32_SetccMem, emit_ia32_SetccMem);
  ia32_register_emitter(op_ia32_Test, emit_ia32_Test);
  ia32_register_emitter(op_ia32_AddSP, emit_ia32_AddSP);
  ia32_register_emitter(op_ia32_RolMem, emit_ia32_RolMem);
  ia32_register_emitter(op_ia32_Prefetch2, emit_ia32_Prefetch2);
  ia32_register_emitter(op_ia32_NoReg_GP, emit_ia32_NoReg_GP);
  ia32_register_emitter(op_ia32_Const, emit_ia32_Const);
  ia32_register_emitter(op_ia32_FnstCW, emit_ia32_FnstCW);
  ia32_register_emitter(op_ia32_Prefetch0, emit_ia32_Prefetch0);
  ia32_register_emitter(op_ia32_OrMem, emit_ia32_OrMem);
  ia32_register_emitter(op_ia32_fldlg2, emit_ia32_fldlg2);
  ia32_register_emitter(op_ia32_fld1, emit_ia32_fld1);
  ia32_register_emitter(op_ia32_Popcnt, emit_ia32_Popcnt);
  ia32_register_emitter(op_ia32_Ror, emit_ia32_Ror);
  ia32_register_emitter(op_ia32_Shl, emit_ia32_Shl);
  ia32_register_emitter(op_ia32_AndMem8Bit, emit_ia32_AndMem8Bit);
  ia32_register_emitter(op_ia32_Add, emit_ia32_Add);
  ia32_register_emitter(op_ia32_SubSP, emit_ia32_SubSP);
  ia32_register_emitter(op_ia32_PrefetchW, emit_ia32_PrefetchW);
  ia32_register_emitter(op_ia32_Conv_I2I, emit_ia32_Conv_I2I);
  ia32_register_emitter(op_ia32_fxch, emit_ia32_fxch);
  ia32_register_emitter(op_ia32_fchs, emit_ia32_fchs);
  ia32_register_emitter(op_ia32_ShrD, emit_ia32_ShrD);
  ia32_register_emitter(op_ia32_Unknown, emit_ia32_Unknown);
  ia32_register_emitter(op_ia32_UD2, emit_ia32_UD2);
  ia32_register_emitter(op_ia32_Cwtl, emit_ia32_Cwtl);
  ia32_register_emitter(op_ia32_fabs, emit_ia32_fabs);
  ia32_register_emitter(op_ia32_fldpi, emit_ia32_fldpi);
  ia32_register_emitter(op_ia32_Leave, emit_ia32_Leave);
  ia32_register_emitter(op_ia32_Neg, emit_ia32_Neg);
  ia32_register_emitter(op_ia32_IMul1OP, emit_ia32_IMul1OP);
  ia32_register_emitter(op_ia32_PopMem, emit_ia32_PopMem);
  ia32_register_emitter(op_ia32_fld, emit_ia32_fld);
  ia32_register_emitter(op_ia32_Dec, emit_ia32_Dec);
  ia32_register_emitter(op_ia32_Pop, emit_ia32_Pop);
  ia32_register_emitter(op_ia32_CopyEbpEsp, emit_ia32_CopyEbpEsp);
  ia32_register_emitter(op_ia32_Not, emit_ia32_Not);
  ia32_register_emitter(op_ia32_NoReg_FP, emit_ia32_NoReg_FP);
  ia32_register_emitter(op_ia32_AndMem, emit_ia32_AndMem);
  ia32_register_emitter(op_ia32_femms, emit_ia32_femms);
  ia32_register_emitter(op_ia32_xStoreSimple, emit_ia32_xStoreSimple);
  ia32_register_emitter(op_ia32_And, emit_ia32_And);
  ia32_register_emitter(op_ia32_Bsr, emit_ia32_Bsr);
  ia32_register_emitter(op_ia32_Bswap16, emit_ia32_Bswap16);
  ia32_register_emitter(op_ia32_Inport, emit_ia32_Inport);
  ia32_register_emitter(op_ia32_SarMem, emit_ia32_SarMem);
  ia32_register_emitter(op_ia32_RepPrefix, emit_ia32_RepPrefix);
  ia32_register_emitter(op_ia32_Adc, emit_ia32_Adc);
  ia32_register_emitter(op_ia32_xAndNot, emit_ia32_xAndNot);
  ia32_register_emitter(op_ia32_Load, emit_ia32_Load);
  ia32_register_emitter(op_ia32_Prefetch, emit_ia32_Prefetch);
}

