/**
 * @file
 * @brief Function prototypes for the new opcode functions.
 * @note  DO NOT EDIT THIS FILE, your changes will be lost.
 *        Edit ir/be/ia32/ia32_spec.pl instead.
 *        created by: ir/be/scripts/generate_new_opcodes.pl ir/be/ia32/ia32_spec.pl ir/be/ia32
 * @date  Mon Nov 19 18:12:23 2012
 */
#ifndef FIRM_BE_IA32_GEN_IA32_NEW_NODES_H
#define FIRM_BE_IA32_GEN_IA32_NEW_NODES_H

typedef enum ia32_opcodes {
	iro_ia32_xZero,
	iro_ia32_FldCW,
	iro_ia32_fadd,
	iro_ia32_ShrMem,
	iro_ia32_Immediate,
	iro_ia32_CvtSI2SS,
	iro_ia32_Bsf,
	iro_ia32_LdTls,
	iro_ia32_ShlD,
	iro_ia32_PopEbp,
	iro_ia32_Inc,
	iro_ia32_xStore,
	iro_ia32_xxLoad,
	iro_ia32_xAnd,
	iro_ia32_GetEIP,
	iro_ia32_xAdd,
	iro_ia32_xPsllq,
	iro_ia32_xxStore,
	iro_ia32_Call,
	iro_ia32_FnstCWNOP,
	iro_ia32_XorMem8Bit,
	iro_ia32_fldl2t,
	iro_ia32_fisttp,
	iro_ia32_DecMem,
	iro_ia32_emms,
	iro_ia32_xLoad,
	iro_ia32_l_FloattoLL,
	iro_ia32_CvtSI2SD,
	iro_ia32_XorMem,
	iro_ia32_CopyB,
	iro_ia32_Xor0,
	iro_ia32_Sar,
	iro_ia32_Div,
	iro_ia32_fpushCopy,
	iro_ia32_Stc,
	iro_ia32_Fucomi,
	iro_ia32_fldl2e,
	iro_ia32_Enter,
	iro_ia32_fmul,
	iro_ia32_l_IMul,
	iro_ia32_NoReg_XMM,
	iro_ia32_xMax,
	iro_ia32_OrMem8Bit,
	iro_ia32_Prefetch1,
	iro_ia32_fsub,
	iro_ia32_Lea,
	iro_ia32_FtstFnstsw,
	iro_ia32_NotMem,
	iro_ia32_Sbb0,
	iro_ia32_Bt,
	iro_ia32_Or,
	iro_ia32_Xor,
	iro_ia32_CopyB_i,
	iro_ia32_IncMem,
	iro_ia32_xAllOnes,
	iro_ia32_Breakpoint,
	iro_ia32_ClimbFrame,
	iro_ia32_ffreep,
	iro_ia32_SubMem,
	iro_ia32_AddMem,
	iro_ia32_ShlMem,
	iro_ia32_fdiv,
	iro_ia32_Outport,
	iro_ia32_xMin,
	iro_ia32_fist,
	iro_ia32_xXor,
	iro_ia32_IJmp,
	iro_ia32_NegMem,
	iro_ia32_CMovcc,
	iro_ia32_Mul,
	iro_ia32_Sahf,
	iro_ia32_SubMem8Bit,
	iro_ia32_AddMem8Bit,
	iro_ia32_fst,
	iro_ia32_FucomppFnstsw,
	iro_ia32_RorMem,
	iro_ia32_fpush,
	iro_ia32_fild,
	iro_ia32_xOr,
	iro_ia32_Conv_I2I8Bit,
	iro_ia32_Store,
	iro_ia32_fldln2,
	iro_ia32_SwitchJmp,
	iro_ia32_IMul,
	iro_ia32_Ucomi,
	iro_ia32_fldz,
	iro_ia32_Store8Bit,
	iro_ia32_fpop,
	iro_ia32_l_Sub,
	iro_ia32_Sbb,
	iro_ia32_FucomFnstsw,
	iro_ia32_xMul,
	iro_ia32_Push,
	iro_ia32_xPslld,
	iro_ia32_Cmp,
	iro_ia32_xSub,
	iro_ia32_xMovd,
	iro_ia32_Cltd,
	iro_ia32_xPsrld,
	iro_ia32_PushEax,
	iro_ia32_XorHighLow,
	iro_ia32_xPzero,
	iro_ia32_Rol,
	iro_ia32_Cmc,
	iro_ia32_Cmp8Bit,
	iro_ia32_xDiv,
	iro_ia32_xUnknown,
	iro_ia32_Test8Bit,
	iro_ia32_Sub,
	iro_ia32_PrefetchNTA,
	iro_ia32_Shr,
	iro_ia32_fprem,
	iro_ia32_IDiv,
	iro_ia32_l_Adc,
	iro_ia32_Setcc,
	iro_ia32_l_LLtoFloat,
	iro_ia32_ProduceVal,
	iro_ia32_Bswap,
	iro_ia32_SetccMem,
	iro_ia32_Test,
	iro_ia32_l_Add,
	iro_ia32_AddSP,
	iro_ia32_RolMem,
	iro_ia32_Conv_I2FP,
	iro_ia32_Conv_FP2FP,
	iro_ia32_ChangeCW,
	iro_ia32_Prefetch2,
	iro_ia32_NoReg_GP,
	iro_ia32_Const,
	iro_ia32_Minus64Bit,
	iro_ia32_Jmp,
	iro_ia32_FnstCW,
	iro_ia32_Prefetch0,
	iro_ia32_OrMem,
	iro_ia32_fldlg2,
	iro_ia32_fld1,
	iro_ia32_Conv_FP2I,
	iro_ia32_Popcnt,
	iro_ia32_Ror,
	iro_ia32_Shl,
	iro_ia32_AndMem8Bit,
	iro_ia32_Add,
	iro_ia32_SubSP,
	iro_ia32_PrefetchW,
	iro_ia32_Conv_I2I,
	iro_ia32_fxch,
	iro_ia32_fchs,
	iro_ia32_ShrD,
	iro_ia32_Unknown,
	iro_ia32_UD2,
	iro_ia32_Cwtl,
	iro_ia32_fabs,
	iro_ia32_fldpi,
	iro_ia32_Leave,
	iro_ia32_Neg,
	iro_ia32_IMul1OP,
	iro_ia32_PopMem,
	iro_ia32_fld,
	iro_ia32_Dec,
	iro_ia32_Pop,
	iro_ia32_CopyEbpEsp,
	iro_ia32_Not,
	iro_ia32_NoReg_FP,
	iro_ia32_AndMem,
	iro_ia32_femms,
	iro_ia32_xStoreSimple,
	iro_ia32_And,
	iro_ia32_Jcc,
	iro_ia32_Asm,
	iro_ia32_l_Sbb,
	iro_ia32_Bsr,
	iro_ia32_Bswap16,
	iro_ia32_Inport,
	iro_ia32_SarMem,
	iro_ia32_RepPrefix,
	iro_ia32_Adc,
	iro_ia32_l_Mul,
	iro_ia32_xAndNot,
	iro_ia32_Load,
	iro_ia32_Prefetch,
	iro_ia32_last_generated,
	iro_ia32_last = iro_ia32_last_generated
} ia32_opcodes;

int is_ia32_irn(const ir_node *node);
int is_ia32_op(const ir_op *op);

int get_ia32_opcode_first(void);
int get_ia32_opcode_last(void);
int get_ia32_irn_opcode(const ir_node *node);
void ia32_create_opcodes(const arch_irn_ops_t *be_ops);
void ia32_free_opcodes(void);
extern ir_op *op_ia32_xZero;
ir_op *get_op_ia32_xZero(void);
int is_ia32_xZero(const ir_node *n);
/**
 * construct xZero node
 */
ir_node *new_bd_ia32_xZero(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_FldCW;
ir_op *get_op_ia32_FldCW(void);
int is_ia32_FldCW(const ir_node *n);
/**
 * construct FldCW node
 */
ir_node *new_bd_ia32_FldCW(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_fadd;
ir_op *get_op_ia32_fadd(void);
int is_ia32_fadd(const ir_node *n);
/**
 * construct fadd node
 */
ir_node *new_bd_ia32_fadd(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right, ir_node *fpcw);

extern ir_op *op_ia32_ShrMem;
ir_op *get_op_ia32_ShrMem(void);
int is_ia32_ShrMem(const ir_node *n);
/**
 * construct ShrMem node
 */
ir_node *new_bd_ia32_ShrMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *count);

extern ir_op *op_ia32_Immediate;
ir_op *get_op_ia32_Immediate(void);
int is_ia32_Immediate(const ir_node *n);
/**
 * construct Immediate node
 */
ir_node *new_bd_ia32_Immediate(dbg_info *dbgi, ir_node *block, ir_entity *symconst, int symconst_sign, int no_pic_adjust, long offset);

extern ir_op *op_ia32_CvtSI2SS;
ir_op *get_op_ia32_CvtSI2SS(void);
int is_ia32_CvtSI2SS(const ir_node *n);
/**
 * construct CvtSI2SS node
 */
ir_node *new_bd_ia32_CvtSI2SS(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_Bsf;
ir_op *get_op_ia32_Bsf(void);
int is_ia32_Bsf(const ir_node *n);
/**
 * construct Bsf node
 */
ir_node *new_bd_ia32_Bsf(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *operand);

extern ir_op *op_ia32_LdTls;
ir_op *get_op_ia32_LdTls(void);
int is_ia32_LdTls(const ir_node *n);
/**
 * construct LdTls node
 */
ir_node *new_bd_ia32_LdTls(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_ShlD;
ir_op *get_op_ia32_ShlD(void);
int is_ia32_ShlD(const ir_node *n);
/**
 * construct ShlD node
 */
ir_node *new_bd_ia32_ShlD(dbg_info *dbgi, ir_node *block, ir_node *val_high, ir_node *val_low, ir_node *count);

extern ir_op *op_ia32_PopEbp;
ir_op *get_op_ia32_PopEbp(void);
int is_ia32_PopEbp(const ir_node *n);
/**
 * construct PopEbp node
 */
ir_node *new_bd_ia32_PopEbp(dbg_info *dbgi, ir_node *block, ir_node *mem, ir_node *stack);

extern ir_op *op_ia32_Inc;
ir_op *get_op_ia32_Inc(void);
int is_ia32_Inc(const ir_node *n);
/**
 * construct Inc node
 */
ir_node *new_bd_ia32_Inc(dbg_info *dbgi, ir_node *block, ir_node *val);

extern ir_op *op_ia32_xStore;
ir_op *get_op_ia32_xStore(void);
int is_ia32_xStore(const ir_node *n);
/**
 * construct xStore node
 */
ir_node *new_bd_ia32_xStore(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_xxLoad;
ir_op *get_op_ia32_xxLoad(void);
int is_ia32_xxLoad(const ir_node *n);
/**
 * construct xxLoad node
 */
ir_node *new_bd_ia32_xxLoad(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_xAnd;
ir_op *get_op_ia32_xAnd(void);
int is_ia32_xAnd(const ir_node *n);
/**
 * construct xAnd node
 */
ir_node *new_bd_ia32_xAnd(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_GetEIP;
ir_op *get_op_ia32_GetEIP(void);
int is_ia32_GetEIP(const ir_node *n);
/**
 * construct GetEIP node
 */
ir_node *new_bd_ia32_GetEIP(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_xAdd;
ir_op *get_op_ia32_xAdd(void);
int is_ia32_xAdd(const ir_node *n);
/**
 * construct xAdd node
 */
ir_node *new_bd_ia32_xAdd(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_xPsllq;
ir_op *get_op_ia32_xPsllq(void);
int is_ia32_xPsllq(const ir_node *n);
/**
 * construct xPsllq node
 */
ir_node *new_bd_ia32_xPsllq(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ia32_xxStore;
ir_op *get_op_ia32_xxStore(void);
int is_ia32_xxStore(const ir_node *n);
/**
 * construct xxStore node
 */
ir_node *new_bd_ia32_xxStore(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_Call;
ir_op *get_op_ia32_Call(void);
int is_ia32_Call(const ir_node *n);
/**
 * construct Call node
 */
ir_node *new_bd_ia32_Call(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *addr, ir_node *stack, ir_node *fpcw, ir_node *eax, ir_node *ecx, ir_node *edx, unsigned pop, ir_type *call_tp);

extern ir_op *op_ia32_FnstCWNOP;
ir_op *get_op_ia32_FnstCWNOP(void);
int is_ia32_FnstCWNOP(const ir_node *n);
/**
 * construct FnstCWNOP node
 */
ir_node *new_bd_ia32_FnstCWNOP(dbg_info *dbgi, ir_node *block, ir_node *fpcw);

extern ir_op *op_ia32_XorMem8Bit;
ir_op *get_op_ia32_XorMem8Bit(void);
int is_ia32_XorMem8Bit(const ir_node *n);
/**
 * construct XorMem8Bit node
 */
ir_node *new_bd_ia32_XorMem8Bit(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_fldl2t;
ir_op *get_op_ia32_fldl2t(void);
int is_ia32_fldl2t(const ir_node *n);
/**
 * construct fldl2t node
 */
ir_node *new_bd_ia32_fldl2t(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_fisttp;
ir_op *get_op_ia32_fisttp(void);
int is_ia32_fisttp(const ir_node *n);
/**
 * construct fisttp node
 */
ir_node *new_bd_ia32_fisttp(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_DecMem;
ir_op *get_op_ia32_DecMem(void);
int is_ia32_DecMem(const ir_node *n);
/**
 * construct DecMem node
 */
ir_node *new_bd_ia32_DecMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_emms;
ir_op *get_op_ia32_emms(void);
int is_ia32_emms(const ir_node *n);
/**
 * construct emms node
 */
ir_node *new_bd_ia32_emms(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_xLoad;
ir_op *get_op_ia32_xLoad(void);
int is_ia32_xLoad(const ir_node *n);
/**
 * construct xLoad node
 */
ir_node *new_bd_ia32_xLoad(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_mode *load_mode);

extern ir_op *op_ia32_l_FloattoLL;
ir_op *get_op_ia32_l_FloattoLL(void);
int is_ia32_l_FloattoLL(const ir_node *n);
/**
 * construct l_FloattoLL node
 */
ir_node *new_bd_ia32_l_FloattoLL(dbg_info *dbgi, ir_node *block, ir_node *val);

extern ir_op *op_ia32_CvtSI2SD;
ir_op *get_op_ia32_CvtSI2SD(void);
int is_ia32_CvtSI2SD(const ir_node *n);
/**
 * construct CvtSI2SD node
 */
ir_node *new_bd_ia32_CvtSI2SD(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_XorMem;
ir_op *get_op_ia32_XorMem(void);
int is_ia32_XorMem(const ir_node *n);
/**
 * construct XorMem node
 */
ir_node *new_bd_ia32_XorMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_CopyB;
ir_op *get_op_ia32_CopyB(void);
int is_ia32_CopyB(const ir_node *n);
/**
 * construct CopyB node
 */
ir_node *new_bd_ia32_CopyB(dbg_info *dbgi, ir_node *block, ir_node *dest, ir_node *source, ir_node *count, ir_node *mem, unsigned size);

extern ir_op *op_ia32_Xor0;
ir_op *get_op_ia32_Xor0(void);
int is_ia32_Xor0(const ir_node *n);
/**
 * construct Xor0 node
 */
ir_node *new_bd_ia32_Xor0(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Sar;
ir_op *get_op_ia32_Sar(void);
int is_ia32_Sar(const ir_node *n);
/**
 * construct Sar node
 */
ir_node *new_bd_ia32_Sar(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *count);

extern ir_op *op_ia32_Div;
ir_op *get_op_ia32_Div(void);
int is_ia32_Div(const ir_node *n);
/**
 * construct Div node
 */
ir_node *new_bd_ia32_Div(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *divisor, ir_node *dividend_low, ir_node *dividend_high);

extern ir_op *op_ia32_fpushCopy;
ir_op *get_op_ia32_fpushCopy(void);
int is_ia32_fpushCopy(const ir_node *n);
/**
 * construct fpushCopy node
 */
ir_node *new_bd_ia32_fpushCopy(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ia32_Stc;
ir_op *get_op_ia32_Stc(void);
int is_ia32_Stc(const ir_node *n);
/**
 * construct Stc node
 */
ir_node *new_bd_ia32_Stc(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Fucomi;
ir_op *get_op_ia32_Fucomi(void);
int is_ia32_Fucomi(const ir_node *n);
/**
 * construct Fucomi node
 */
ir_node *new_bd_ia32_Fucomi(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, bool ins_permuted);

extern ir_op *op_ia32_fldl2e;
ir_op *get_op_ia32_fldl2e(void);
int is_ia32_fldl2e(const ir_node *n);
/**
 * construct fldl2e node
 */
ir_node *new_bd_ia32_fldl2e(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Enter;
ir_op *get_op_ia32_Enter(void);
int is_ia32_Enter(const ir_node *n);
/**
 * construct Enter node
 */
ir_node *new_bd_ia32_Enter(dbg_info *dbgi, ir_node *block, ir_node *op0);

extern ir_op *op_ia32_fmul;
ir_op *get_op_ia32_fmul(void);
int is_ia32_fmul(const ir_node *n);
/**
 * construct fmul node
 */
ir_node *new_bd_ia32_fmul(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right, ir_node *fpcw);

extern ir_op *op_ia32_l_IMul;
ir_op *get_op_ia32_l_IMul(void);
int is_ia32_l_IMul(const ir_node *n);
/**
 * construct l_IMul node
 */
ir_node *new_bd_ia32_l_IMul(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_ia32_NoReg_XMM;
ir_op *get_op_ia32_NoReg_XMM(void);
int is_ia32_NoReg_XMM(const ir_node *n);
/**
 * construct NoReg_XMM node
 */
ir_node *new_bd_ia32_NoReg_XMM(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_xMax;
ir_op *get_op_ia32_xMax(void);
int is_ia32_xMax(const ir_node *n);
/**
 * construct xMax node
 */
ir_node *new_bd_ia32_xMax(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_OrMem8Bit;
ir_op *get_op_ia32_OrMem8Bit(void);
int is_ia32_OrMem8Bit(const ir_node *n);
/**
 * construct OrMem8Bit node
 */
ir_node *new_bd_ia32_OrMem8Bit(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_Prefetch1;
ir_op *get_op_ia32_Prefetch1(void);
int is_ia32_Prefetch1(const ir_node *n);
/**
 * construct Prefetch1 node
 */
ir_node *new_bd_ia32_Prefetch1(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_fsub;
ir_op *get_op_ia32_fsub(void);
int is_ia32_fsub(const ir_node *n);
/**
 * construct fsub node
 */
ir_node *new_bd_ia32_fsub(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *minuend, ir_node *subtrahend, ir_node *fpcw);

extern ir_op *op_ia32_Lea;
ir_op *get_op_ia32_Lea(void);
int is_ia32_Lea(const ir_node *n);
/**
 * construct Lea node
 */
ir_node *new_bd_ia32_Lea(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index);

extern ir_op *op_ia32_FtstFnstsw;
ir_op *get_op_ia32_FtstFnstsw(void);
int is_ia32_FtstFnstsw(const ir_node *n);
/**
 * construct FtstFnstsw node
 */
ir_node *new_bd_ia32_FtstFnstsw(dbg_info *dbgi, ir_node *block, ir_node *left, bool ins_permuted);

extern ir_op *op_ia32_NotMem;
ir_op *get_op_ia32_NotMem(void);
int is_ia32_NotMem(const ir_node *n);
/**
 * construct NotMem node
 */
ir_node *new_bd_ia32_NotMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_Sbb0;
ir_op *get_op_ia32_Sbb0(void);
int is_ia32_Sbb0(const ir_node *n);
/**
 * construct Sbb0 node
 */
ir_node *new_bd_ia32_Sbb0(dbg_info *dbgi, ir_node *block, ir_node *op0);

extern ir_op *op_ia32_Bt;
ir_op *get_op_ia32_Bt(void);
int is_ia32_Bt(const ir_node *n);
/**
 * construct Bt node
 */
ir_node *new_bd_ia32_Bt(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_ia32_Or;
ir_op *get_op_ia32_Or(void);
int is_ia32_Or(const ir_node *n);
/**
 * construct Or node
 */
ir_node *new_bd_ia32_Or(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_Xor;
ir_op *get_op_ia32_Xor(void);
int is_ia32_Xor(const ir_node *n);
/**
 * construct Xor node
 */
ir_node *new_bd_ia32_Xor(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_CopyB_i;
ir_op *get_op_ia32_CopyB_i(void);
int is_ia32_CopyB_i(const ir_node *n);
/**
 * construct CopyB_i node
 */
ir_node *new_bd_ia32_CopyB_i(dbg_info *dbgi, ir_node *block, ir_node *dest, ir_node *source, ir_node *mem, unsigned size);

extern ir_op *op_ia32_IncMem;
ir_op *get_op_ia32_IncMem(void);
int is_ia32_IncMem(const ir_node *n);
/**
 * construct IncMem node
 */
ir_node *new_bd_ia32_IncMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_xAllOnes;
ir_op *get_op_ia32_xAllOnes(void);
int is_ia32_xAllOnes(const ir_node *n);
/**
 * construct xAllOnes node
 */
ir_node *new_bd_ia32_xAllOnes(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Breakpoint;
ir_op *get_op_ia32_Breakpoint(void);
int is_ia32_Breakpoint(const ir_node *n);
/**
 * construct Breakpoint node
 */
ir_node *new_bd_ia32_Breakpoint(dbg_info *dbgi, ir_node *block, ir_node *mem);

extern ir_op *op_ia32_ClimbFrame;
ir_op *get_op_ia32_ClimbFrame(void);
int is_ia32_ClimbFrame(const ir_node *n);
/**
 * construct ClimbFrame node
 */
ir_node *new_bd_ia32_ClimbFrame(dbg_info *dbgi, ir_node *block, ir_node *frame, ir_node *cnt, ir_node *tmp, unsigned count);

extern ir_op *op_ia32_ffreep;
ir_op *get_op_ia32_ffreep(void);
int is_ia32_ffreep(const ir_node *n);
/**
 * construct ffreep node
 */
ir_node *new_bd_ia32_ffreep(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_SubMem;
ir_op *get_op_ia32_SubMem(void);
int is_ia32_SubMem(const ir_node *n);
/**
 * construct SubMem node
 */
ir_node *new_bd_ia32_SubMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *subtrahend);

extern ir_op *op_ia32_AddMem;
ir_op *get_op_ia32_AddMem(void);
int is_ia32_AddMem(const ir_node *n);
/**
 * construct AddMem node
 */
ir_node *new_bd_ia32_AddMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_ShlMem;
ir_op *get_op_ia32_ShlMem(void);
int is_ia32_ShlMem(const ir_node *n);
/**
 * construct ShlMem node
 */
ir_node *new_bd_ia32_ShlMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *count);

extern ir_op *op_ia32_fdiv;
ir_op *get_op_ia32_fdiv(void);
int is_ia32_fdiv(const ir_node *n);
/**
 * construct fdiv node
 */
ir_node *new_bd_ia32_fdiv(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *dividend, ir_node *divisor, ir_node *fpcw);

extern ir_op *op_ia32_Outport;
ir_op *get_op_ia32_Outport(void);
int is_ia32_Outport(const ir_node *n);
/**
 * construct Outport node
 */
ir_node *new_bd_ia32_Outport(dbg_info *dbgi, ir_node *block, ir_node *port, ir_node *value, ir_node *mem);

extern ir_op *op_ia32_xMin;
ir_op *get_op_ia32_xMin(void);
int is_ia32_xMin(const ir_node *n);
/**
 * construct xMin node
 */
ir_node *new_bd_ia32_xMin(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_fist;
ir_op *get_op_ia32_fist(void);
int is_ia32_fist(const ir_node *n);
/**
 * construct fist node
 */
ir_node *new_bd_ia32_fist(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val, ir_node *fpcw);

extern ir_op *op_ia32_xXor;
ir_op *get_op_ia32_xXor(void);
int is_ia32_xXor(const ir_node *n);
/**
 * construct xXor node
 */
ir_node *new_bd_ia32_xXor(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_IJmp;
ir_op *get_op_ia32_IJmp(void);
int is_ia32_IJmp(const ir_node *n);
/**
 * construct IJmp node
 */
ir_node *new_bd_ia32_IJmp(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *target);

extern ir_op *op_ia32_NegMem;
ir_op *get_op_ia32_NegMem(void);
int is_ia32_NegMem(const ir_node *n);
/**
 * construct NegMem node
 */
ir_node *new_bd_ia32_NegMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_CMovcc;
ir_op *get_op_ia32_CMovcc(void);
int is_ia32_CMovcc(const ir_node *n);
/**
 * construct CMovcc node
 */
ir_node *new_bd_ia32_CMovcc(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val_false, ir_node *val_true, ir_node *eflags, ia32_condition_code_t condition_code);

extern ir_op *op_ia32_Mul;
ir_op *get_op_ia32_Mul(void);
int is_ia32_Mul(const ir_node *n);
/**
 * construct Mul node
 */
ir_node *new_bd_ia32_Mul(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_Sahf;
ir_op *get_op_ia32_Sahf(void);
int is_ia32_Sahf(const ir_node *n);
/**
 * construct Sahf node
 */
ir_node *new_bd_ia32_Sahf(dbg_info *dbgi, ir_node *block, ir_node *val);

extern ir_op *op_ia32_SubMem8Bit;
ir_op *get_op_ia32_SubMem8Bit(void);
int is_ia32_SubMem8Bit(const ir_node *n);
/**
 * construct SubMem8Bit node
 */
ir_node *new_bd_ia32_SubMem8Bit(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *subtrahend);

extern ir_op *op_ia32_AddMem8Bit;
ir_op *get_op_ia32_AddMem8Bit(void);
int is_ia32_AddMem8Bit(const ir_node *n);
/**
 * construct AddMem8Bit node
 */
ir_node *new_bd_ia32_AddMem8Bit(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_fst;
ir_op *get_op_ia32_fst(void);
int is_ia32_fst(const ir_node *n);
/**
 * construct fst node
 */
ir_node *new_bd_ia32_fst(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val, ir_mode *store_mode);

extern ir_op *op_ia32_FucomppFnstsw;
ir_op *get_op_ia32_FucomppFnstsw(void);
int is_ia32_FucomppFnstsw(const ir_node *n);
/**
 * construct FucomppFnstsw node
 */
ir_node *new_bd_ia32_FucomppFnstsw(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, bool ins_permuted);

extern ir_op *op_ia32_RorMem;
ir_op *get_op_ia32_RorMem(void);
int is_ia32_RorMem(const ir_node *n);
/**
 * construct RorMem node
 */
ir_node *new_bd_ia32_RorMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *count);

extern ir_op *op_ia32_fpush;
ir_op *get_op_ia32_fpush(void);
int is_ia32_fpush(const ir_node *n);
/**
 * construct fpush node
 */
ir_node *new_bd_ia32_fpush(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_fild;
ir_op *get_op_ia32_fild(void);
int is_ia32_fild(const ir_node *n);
/**
 * construct fild node
 */
ir_node *new_bd_ia32_fild(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_xOr;
ir_op *get_op_ia32_xOr(void);
int is_ia32_xOr(const ir_node *n);
/**
 * construct xOr node
 */
ir_node *new_bd_ia32_xOr(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_Conv_I2I8Bit;
ir_op *get_op_ia32_Conv_I2I8Bit(void);
int is_ia32_Conv_I2I8Bit(const ir_node *n);
/**
 * construct Conv_I2I8Bit node
 */
ir_node *new_bd_ia32_Conv_I2I8Bit(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val, ir_mode *smaller_mode);

extern ir_op *op_ia32_Store;
ir_op *get_op_ia32_Store(void);
int is_ia32_Store(const ir_node *n);
/**
 * construct Store node
 */
ir_node *new_bd_ia32_Store(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_fldln2;
ir_op *get_op_ia32_fldln2(void);
int is_ia32_fldln2(const ir_node *n);
/**
 * construct fldln2 node
 */
ir_node *new_bd_ia32_fldln2(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_SwitchJmp;
ir_op *get_op_ia32_SwitchJmp(void);
int is_ia32_SwitchJmp(const ir_node *n);
/**
 * construct SwitchJmp node
 */
ir_node *new_bd_ia32_SwitchJmp(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, int n_res, const ir_switch_table *switch_table);

extern ir_op *op_ia32_IMul;
ir_op *get_op_ia32_IMul(void);
int is_ia32_IMul(const ir_node *n);
/**
 * construct IMul node
 */
ir_node *new_bd_ia32_IMul(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_Ucomi;
ir_op *get_op_ia32_Ucomi(void);
int is_ia32_Ucomi(const ir_node *n);
/**
 * construct Ucomi node
 */
ir_node *new_bd_ia32_Ucomi(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right, bool ins_permuted);

extern ir_op *op_ia32_fldz;
ir_op *get_op_ia32_fldz(void);
int is_ia32_fldz(const ir_node *n);
/**
 * construct fldz node
 */
ir_node *new_bd_ia32_fldz(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Store8Bit;
ir_op *get_op_ia32_Store8Bit(void);
int is_ia32_Store8Bit(const ir_node *n);
/**
 * construct Store8Bit node
 */
ir_node *new_bd_ia32_Store8Bit(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_fpop;
ir_op *get_op_ia32_fpop(void);
int is_ia32_fpop(const ir_node *n);
/**
 * construct fpop node
 */
ir_node *new_bd_ia32_fpop(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_l_Sub;
ir_op *get_op_ia32_l_Sub(void);
int is_ia32_l_Sub(const ir_node *n);
/**
 * construct l_Sub node
 */
ir_node *new_bd_ia32_l_Sub(dbg_info *dbgi, ir_node *block, ir_node *minuend, ir_node *subtrahend, ir_mode *mode);

extern ir_op *op_ia32_Sbb;
ir_op *get_op_ia32_Sbb(void);
int is_ia32_Sbb(const ir_node *n);
/**
 * construct Sbb node
 */
ir_node *new_bd_ia32_Sbb(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *minuend, ir_node *subtrahend, ir_node *eflags);

extern ir_op *op_ia32_FucomFnstsw;
ir_op *get_op_ia32_FucomFnstsw(void);
int is_ia32_FucomFnstsw(const ir_node *n);
/**
 * construct FucomFnstsw node
 */
ir_node *new_bd_ia32_FucomFnstsw(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, bool ins_permuted);

extern ir_op *op_ia32_xMul;
ir_op *get_op_ia32_xMul(void);
int is_ia32_xMul(const ir_node *n);
/**
 * construct xMul node
 */
ir_node *new_bd_ia32_xMul(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_Push;
ir_op *get_op_ia32_Push(void);
int is_ia32_Push(const ir_node *n);
/**
 * construct Push node
 */
ir_node *new_bd_ia32_Push(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val, ir_node *stack);

extern ir_op *op_ia32_xPslld;
ir_op *get_op_ia32_xPslld(void);
int is_ia32_xPslld(const ir_node *n);
/**
 * construct xPslld node
 */
ir_node *new_bd_ia32_xPslld(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ia32_Cmp;
ir_op *get_op_ia32_Cmp(void);
int is_ia32_Cmp(const ir_node *n);
/**
 * construct Cmp node
 */
ir_node *new_bd_ia32_Cmp(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right, bool ins_permuted);

extern ir_op *op_ia32_xSub;
ir_op *get_op_ia32_xSub(void);
int is_ia32_xSub(const ir_node *n);
/**
 * construct xSub node
 */
ir_node *new_bd_ia32_xSub(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *minuend, ir_node *subtrahend);

extern ir_op *op_ia32_xMovd;
ir_op *get_op_ia32_xMovd(void);
int is_ia32_xMovd(const ir_node *n);
/**
 * construct xMovd node
 */
ir_node *new_bd_ia32_xMovd(dbg_info *dbgi, ir_node *block, ir_node *op0);

extern ir_op *op_ia32_Cltd;
ir_op *get_op_ia32_Cltd(void);
int is_ia32_Cltd(const ir_node *n);
/**
 * construct Cltd node
 */
ir_node *new_bd_ia32_Cltd(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *clobbered);

extern ir_op *op_ia32_xPsrld;
ir_op *get_op_ia32_xPsrld(void);
int is_ia32_xPsrld(const ir_node *n);
/**
 * construct xPsrld node
 */
ir_node *new_bd_ia32_xPsrld(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ia32_PushEax;
ir_op *get_op_ia32_PushEax(void);
int is_ia32_PushEax(const ir_node *n);
/**
 * construct PushEax node
 */
ir_node *new_bd_ia32_PushEax(dbg_info *dbgi, ir_node *block, ir_node *stack);

extern ir_op *op_ia32_XorHighLow;
ir_op *get_op_ia32_XorHighLow(void);
int is_ia32_XorHighLow(const ir_node *n);
/**
 * construct XorHighLow node
 */
ir_node *new_bd_ia32_XorHighLow(dbg_info *dbgi, ir_node *block, ir_node *value);

extern ir_op *op_ia32_xPzero;
ir_op *get_op_ia32_xPzero(void);
int is_ia32_xPzero(const ir_node *n);
/**
 * construct xPzero node
 */
ir_node *new_bd_ia32_xPzero(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Rol;
ir_op *get_op_ia32_Rol(void);
int is_ia32_Rol(const ir_node *n);
/**
 * construct Rol node
 */
ir_node *new_bd_ia32_Rol(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *count);

extern ir_op *op_ia32_Cmc;
ir_op *get_op_ia32_Cmc(void);
int is_ia32_Cmc(const ir_node *n);
/**
 * construct Cmc node
 */
ir_node *new_bd_ia32_Cmc(dbg_info *dbgi, ir_node *block, ir_node *op0);

extern ir_op *op_ia32_Cmp8Bit;
ir_op *get_op_ia32_Cmp8Bit(void);
int is_ia32_Cmp8Bit(const ir_node *n);
/**
 * construct Cmp8Bit node
 */
ir_node *new_bd_ia32_Cmp8Bit(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right, bool ins_permuted);

extern ir_op *op_ia32_xDiv;
ir_op *get_op_ia32_xDiv(void);
int is_ia32_xDiv(const ir_node *n);
/**
 * construct xDiv node
 */
ir_node *new_bd_ia32_xDiv(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *dividend, ir_node *divisor);

extern ir_op *op_ia32_xUnknown;
ir_op *get_op_ia32_xUnknown(void);
int is_ia32_xUnknown(const ir_node *n);
/**
 * construct xUnknown node
 */
ir_node *new_bd_ia32_xUnknown(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Test8Bit;
ir_op *get_op_ia32_Test8Bit(void);
int is_ia32_Test8Bit(const ir_node *n);
/**
 * construct Test8Bit node
 */
ir_node *new_bd_ia32_Test8Bit(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right, bool ins_permuted);

extern ir_op *op_ia32_Sub;
ir_op *get_op_ia32_Sub(void);
int is_ia32_Sub(const ir_node *n);
/**
 * construct Sub node
 */
ir_node *new_bd_ia32_Sub(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *minuend, ir_node *subtrahend);

extern ir_op *op_ia32_PrefetchNTA;
ir_op *get_op_ia32_PrefetchNTA(void);
int is_ia32_PrefetchNTA(const ir_node *n);
/**
 * construct PrefetchNTA node
 */
ir_node *new_bd_ia32_PrefetchNTA(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_Shr;
ir_op *get_op_ia32_Shr(void);
int is_ia32_Shr(const ir_node *n);
/**
 * construct Shr node
 */
ir_node *new_bd_ia32_Shr(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *count);

extern ir_op *op_ia32_fprem;
ir_op *get_op_ia32_fprem(void);
int is_ia32_fprem(const ir_node *n);
/**
 * construct fprem node
 */
ir_node *new_bd_ia32_fprem(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *fpcw);

extern ir_op *op_ia32_IDiv;
ir_op *get_op_ia32_IDiv(void);
int is_ia32_IDiv(const ir_node *n);
/**
 * construct IDiv node
 */
ir_node *new_bd_ia32_IDiv(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *divisor, ir_node *dividend_low, ir_node *dividend_high);

extern ir_op *op_ia32_l_Adc;
ir_op *get_op_ia32_l_Adc(void);
int is_ia32_l_Adc(const ir_node *n);
/**
 * construct l_Adc node
 */
ir_node *new_bd_ia32_l_Adc(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *eflags, ir_mode *mode);

extern ir_op *op_ia32_Setcc;
ir_op *get_op_ia32_Setcc(void);
int is_ia32_Setcc(const ir_node *n);
/**
 * construct Setcc node
 */
ir_node *new_bd_ia32_Setcc(dbg_info *dbgi, ir_node *block, ir_node *eflags, ia32_condition_code_t condition_code);

extern ir_op *op_ia32_l_LLtoFloat;
ir_op *get_op_ia32_l_LLtoFloat(void);
int is_ia32_l_LLtoFloat(const ir_node *n);
/**
 * construct l_LLtoFloat node
 */
ir_node *new_bd_ia32_l_LLtoFloat(dbg_info *dbgi, ir_node *block, ir_node *val_high, ir_node *val_low, ir_mode *mode);

extern ir_op *op_ia32_ProduceVal;
ir_op *get_op_ia32_ProduceVal(void);
int is_ia32_ProduceVal(const ir_node *n);
/**
 * construct ProduceVal node
 */
ir_node *new_bd_ia32_ProduceVal(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Bswap;
ir_op *get_op_ia32_Bswap(void);
int is_ia32_Bswap(const ir_node *n);
/**
 * construct Bswap node
 */
ir_node *new_bd_ia32_Bswap(dbg_info *dbgi, ir_node *block, ir_node *val);

extern ir_op *op_ia32_SetccMem;
ir_op *get_op_ia32_SetccMem(void);
int is_ia32_SetccMem(const ir_node *n);
/**
 * construct SetccMem node
 */
ir_node *new_bd_ia32_SetccMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *eflags, ia32_condition_code_t condition_code);

extern ir_op *op_ia32_Test;
ir_op *get_op_ia32_Test(void);
int is_ia32_Test(const ir_node *n);
/**
 * construct Test node
 */
ir_node *new_bd_ia32_Test(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right, bool ins_permuted);

extern ir_op *op_ia32_l_Add;
ir_op *get_op_ia32_l_Add(void);
int is_ia32_l_Add(const ir_node *n);
/**
 * construct l_Add node
 */
ir_node *new_bd_ia32_l_Add(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *mode);

extern ir_op *op_ia32_AddSP;
ir_op *get_op_ia32_AddSP(void);
int is_ia32_AddSP(const ir_node *n);
/**
 * construct AddSP node
 */
ir_node *new_bd_ia32_AddSP(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *stack, ir_node *size);

extern ir_op *op_ia32_RolMem;
ir_op *get_op_ia32_RolMem(void);
int is_ia32_RolMem(const ir_node *n);
/**
 * construct RolMem node
 */
ir_node *new_bd_ia32_RolMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *count);

extern ir_op *op_ia32_Conv_I2FP;
ir_op *get_op_ia32_Conv_I2FP(void);
int is_ia32_Conv_I2FP(const ir_node *n);
/**
 * construct Conv_I2FP node
 */
ir_node *new_bd_ia32_Conv_I2FP(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_Conv_FP2FP;
ir_op *get_op_ia32_Conv_FP2FP(void);
int is_ia32_Conv_FP2FP(const ir_node *n);
/**
 * construct Conv_FP2FP node
 */
ir_node *new_bd_ia32_Conv_FP2FP(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_ChangeCW;
ir_op *get_op_ia32_ChangeCW(void);
int is_ia32_ChangeCW(const ir_node *n);
/**
 * construct ChangeCW node
 */
ir_node *new_bd_ia32_ChangeCW(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Prefetch2;
ir_op *get_op_ia32_Prefetch2(void);
int is_ia32_Prefetch2(const ir_node *n);
/**
 * construct Prefetch2 node
 */
ir_node *new_bd_ia32_Prefetch2(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_NoReg_GP;
ir_op *get_op_ia32_NoReg_GP(void);
int is_ia32_NoReg_GP(const ir_node *n);
/**
 * construct NoReg_GP node
 */
ir_node *new_bd_ia32_NoReg_GP(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Const;
ir_op *get_op_ia32_Const(void);
int is_ia32_Const(const ir_node *n);
/**
 * construct Const node
 */
ir_node *new_bd_ia32_Const(dbg_info *dbgi, ir_node *block, ir_entity *symconst, int symconst_sign, int no_pic_adjust, long offset);

extern ir_op *op_ia32_Minus64Bit;
ir_op *get_op_ia32_Minus64Bit(void);
int is_ia32_Minus64Bit(const ir_node *n);
/**
 * construct Minus64Bit node
 */
ir_node *new_bd_ia32_Minus64Bit(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ia32_Jmp;
ir_op *get_op_ia32_Jmp(void);
int is_ia32_Jmp(const ir_node *n);
/**
 * construct Jmp node
 */
ir_node *new_bd_ia32_Jmp(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_FnstCW;
ir_op *get_op_ia32_FnstCW(void);
int is_ia32_FnstCW(const ir_node *n);
/**
 * construct FnstCW node
 */
ir_node *new_bd_ia32_FnstCW(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *fpcw);

extern ir_op *op_ia32_Prefetch0;
ir_op *get_op_ia32_Prefetch0(void);
int is_ia32_Prefetch0(const ir_node *n);
/**
 * construct Prefetch0 node
 */
ir_node *new_bd_ia32_Prefetch0(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_OrMem;
ir_op *get_op_ia32_OrMem(void);
int is_ia32_OrMem(const ir_node *n);
/**
 * construct OrMem node
 */
ir_node *new_bd_ia32_OrMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_fldlg2;
ir_op *get_op_ia32_fldlg2(void);
int is_ia32_fldlg2(const ir_node *n);
/**
 * construct fldlg2 node
 */
ir_node *new_bd_ia32_fldlg2(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_fld1;
ir_op *get_op_ia32_fld1(void);
int is_ia32_fld1(const ir_node *n);
/**
 * construct fld1 node
 */
ir_node *new_bd_ia32_fld1(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Conv_FP2I;
ir_op *get_op_ia32_Conv_FP2I(void);
int is_ia32_Conv_FP2I(const ir_node *n);
/**
 * construct Conv_FP2I node
 */
ir_node *new_bd_ia32_Conv_FP2I(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_Popcnt;
ir_op *get_op_ia32_Popcnt(void);
int is_ia32_Popcnt(const ir_node *n);
/**
 * construct Popcnt node
 */
ir_node *new_bd_ia32_Popcnt(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *operand);

extern ir_op *op_ia32_Ror;
ir_op *get_op_ia32_Ror(void);
int is_ia32_Ror(const ir_node *n);
/**
 * construct Ror node
 */
ir_node *new_bd_ia32_Ror(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *count);

extern ir_op *op_ia32_Shl;
ir_op *get_op_ia32_Shl(void);
int is_ia32_Shl(const ir_node *n);
/**
 * construct Shl node
 */
ir_node *new_bd_ia32_Shl(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *count);

extern ir_op *op_ia32_AndMem8Bit;
ir_op *get_op_ia32_AndMem8Bit(void);
int is_ia32_AndMem8Bit(const ir_node *n);
/**
 * construct AndMem8Bit node
 */
ir_node *new_bd_ia32_AndMem8Bit(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_Add;
ir_op *get_op_ia32_Add(void);
int is_ia32_Add(const ir_node *n);
/**
 * construct Add node
 */
ir_node *new_bd_ia32_Add(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_SubSP;
ir_op *get_op_ia32_SubSP(void);
int is_ia32_SubSP(const ir_node *n);
/**
 * construct SubSP node
 */
ir_node *new_bd_ia32_SubSP(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *stack, ir_node *size);

extern ir_op *op_ia32_PrefetchW;
ir_op *get_op_ia32_PrefetchW(void);
int is_ia32_PrefetchW(const ir_node *n);
/**
 * construct PrefetchW node
 */
ir_node *new_bd_ia32_PrefetchW(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_Conv_I2I;
ir_op *get_op_ia32_Conv_I2I(void);
int is_ia32_Conv_I2I(const ir_node *n);
/**
 * construct Conv_I2I node
 */
ir_node *new_bd_ia32_Conv_I2I(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val, ir_mode *smaller_mode);

extern ir_op *op_ia32_fxch;
ir_op *get_op_ia32_fxch(void);
int is_ia32_fxch(const ir_node *n);
/**
 * construct fxch node
 */
ir_node *new_bd_ia32_fxch(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_fchs;
ir_op *get_op_ia32_fchs(void);
int is_ia32_fchs(const ir_node *n);
/**
 * construct fchs node
 */
ir_node *new_bd_ia32_fchs(dbg_info *dbgi, ir_node *block, ir_node *value);

extern ir_op *op_ia32_ShrD;
ir_op *get_op_ia32_ShrD(void);
int is_ia32_ShrD(const ir_node *n);
/**
 * construct ShrD node
 */
ir_node *new_bd_ia32_ShrD(dbg_info *dbgi, ir_node *block, ir_node *val_high, ir_node *val_low, ir_node *count);

extern ir_op *op_ia32_Unknown;
ir_op *get_op_ia32_Unknown(void);
int is_ia32_Unknown(const ir_node *n);
/**
 * construct Unknown node
 */
ir_node *new_bd_ia32_Unknown(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_UD2;
ir_op *get_op_ia32_UD2(void);
int is_ia32_UD2(const ir_node *n);
/**
 * construct UD2 node
 */
ir_node *new_bd_ia32_UD2(dbg_info *dbgi, ir_node *block, ir_node *mem);

extern ir_op *op_ia32_Cwtl;
ir_op *get_op_ia32_Cwtl(void);
int is_ia32_Cwtl(const ir_node *n);
/**
 * construct Cwtl node
 */
ir_node *new_bd_ia32_Cwtl(dbg_info *dbgi, ir_node *block, ir_node *val);

extern ir_op *op_ia32_fabs;
ir_op *get_op_ia32_fabs(void);
int is_ia32_fabs(const ir_node *n);
/**
 * construct fabs node
 */
ir_node *new_bd_ia32_fabs(dbg_info *dbgi, ir_node *block, ir_node *value);

extern ir_op *op_ia32_fldpi;
ir_op *get_op_ia32_fldpi(void);
int is_ia32_fldpi(const ir_node *n);
/**
 * construct fldpi node
 */
ir_node *new_bd_ia32_fldpi(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Leave;
ir_op *get_op_ia32_Leave(void);
int is_ia32_Leave(const ir_node *n);
/**
 * construct Leave node
 */
ir_node *new_bd_ia32_Leave(dbg_info *dbgi, ir_node *block, ir_node *op0);

extern ir_op *op_ia32_Neg;
ir_op *get_op_ia32_Neg(void);
int is_ia32_Neg(const ir_node *n);
/**
 * construct Neg node
 */
ir_node *new_bd_ia32_Neg(dbg_info *dbgi, ir_node *block, ir_node *val);

extern ir_op *op_ia32_IMul1OP;
ir_op *get_op_ia32_IMul1OP(void);
int is_ia32_IMul1OP(const ir_node *n);
/**
 * construct IMul1OP node
 */
ir_node *new_bd_ia32_IMul1OP(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_PopMem;
ir_op *get_op_ia32_PopMem(void);
int is_ia32_PopMem(const ir_node *n);
/**
 * construct PopMem node
 */
ir_node *new_bd_ia32_PopMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *stack);

extern ir_op *op_ia32_fld;
ir_op *get_op_ia32_fld(void);
int is_ia32_fld(const ir_node *n);
/**
 * construct fld node
 */
ir_node *new_bd_ia32_fld(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_mode *load_mode);

extern ir_op *op_ia32_Dec;
ir_op *get_op_ia32_Dec(void);
int is_ia32_Dec(const ir_node *n);
/**
 * construct Dec node
 */
ir_node *new_bd_ia32_Dec(dbg_info *dbgi, ir_node *block, ir_node *val);

extern ir_op *op_ia32_Pop;
ir_op *get_op_ia32_Pop(void);
int is_ia32_Pop(const ir_node *n);
/**
 * construct Pop node
 */
ir_node *new_bd_ia32_Pop(dbg_info *dbgi, ir_node *block, ir_node *mem, ir_node *stack);

extern ir_op *op_ia32_CopyEbpEsp;
ir_op *get_op_ia32_CopyEbpEsp(void);
int is_ia32_CopyEbpEsp(const ir_node *n);
/**
 * construct CopyEbpEsp node
 */
ir_node *new_bd_ia32_CopyEbpEsp(dbg_info *dbgi, ir_node *block, ir_node *ebp);

extern ir_op *op_ia32_Not;
ir_op *get_op_ia32_Not(void);
int is_ia32_Not(const ir_node *n);
/**
 * construct Not node
 */
ir_node *new_bd_ia32_Not(dbg_info *dbgi, ir_node *block, ir_node *val);

extern ir_op *op_ia32_NoReg_FP;
ir_op *get_op_ia32_NoReg_FP(void);
int is_ia32_NoReg_FP(const ir_node *n);
/**
 * construct NoReg_FP node
 */
ir_node *new_bd_ia32_NoReg_FP(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_AndMem;
ir_op *get_op_ia32_AndMem(void);
int is_ia32_AndMem(const ir_node *n);
/**
 * construct AndMem node
 */
ir_node *new_bd_ia32_AndMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_femms;
ir_op *get_op_ia32_femms(void);
int is_ia32_femms(const ir_node *n);
/**
 * construct femms node
 */
ir_node *new_bd_ia32_femms(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_xStoreSimple;
ir_op *get_op_ia32_xStoreSimple(void);
int is_ia32_xStoreSimple(const ir_node *n);
/**
 * construct xStoreSimple node
 */
ir_node *new_bd_ia32_xStoreSimple(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *val);

extern ir_op *op_ia32_And;
ir_op *get_op_ia32_And(void);
int is_ia32_And(const ir_node *n);
/**
 * construct And node
 */
ir_node *new_bd_ia32_And(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_Jcc;
ir_op *get_op_ia32_Jcc(void);
int is_ia32_Jcc(const ir_node *n);
/**
 * construct Jcc node
 */
ir_node *new_bd_ia32_Jcc(dbg_info *dbgi, ir_node *block, ir_node *eflags, ia32_condition_code_t condition_code);

extern ir_op *op_ia32_Asm;
ir_op *get_op_ia32_Asm(void);
int is_ia32_Asm(const ir_node *n);
/**
 * construct Asm node
 */
ir_node *new_bd_ia32_Asm(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, ident *asm_text, const ia32_asm_reg_t *register_map);

extern ir_op *op_ia32_l_Sbb;
ir_op *get_op_ia32_l_Sbb(void);
int is_ia32_l_Sbb(const ir_node *n);
/**
 * construct l_Sbb node
 */
ir_node *new_bd_ia32_l_Sbb(dbg_info *dbgi, ir_node *block, ir_node *minuend, ir_node *subtrahend, ir_node *eflags, ir_mode *mode);

extern ir_op *op_ia32_Bsr;
ir_op *get_op_ia32_Bsr(void);
int is_ia32_Bsr(const ir_node *n);
/**
 * construct Bsr node
 */
ir_node *new_bd_ia32_Bsr(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *operand);

extern ir_op *op_ia32_Bswap16;
ir_op *get_op_ia32_Bswap16(void);
int is_ia32_Bswap16(const ir_node *n);
/**
 * construct Bswap16 node
 */
ir_node *new_bd_ia32_Bswap16(dbg_info *dbgi, ir_node *block, ir_node *val);

extern ir_op *op_ia32_Inport;
ir_op *get_op_ia32_Inport(void);
int is_ia32_Inport(const ir_node *n);
/**
 * construct Inport node
 */
ir_node *new_bd_ia32_Inport(dbg_info *dbgi, ir_node *block, ir_node *port, ir_node *mem);

extern ir_op *op_ia32_SarMem;
ir_op *get_op_ia32_SarMem(void);
int is_ia32_SarMem(const ir_node *n);
/**
 * construct SarMem node
 */
ir_node *new_bd_ia32_SarMem(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *count);

extern ir_op *op_ia32_RepPrefix;
ir_op *get_op_ia32_RepPrefix(void);
int is_ia32_RepPrefix(const ir_node *n);
/**
 * construct RepPrefix node
 */
ir_node *new_bd_ia32_RepPrefix(dbg_info *dbgi, ir_node *block);

extern ir_op *op_ia32_Adc;
ir_op *get_op_ia32_Adc(void);
int is_ia32_Adc(const ir_node *n);
/**
 * construct Adc node
 */
ir_node *new_bd_ia32_Adc(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right, ir_node *eflags);

extern ir_op *op_ia32_l_Mul;
ir_op *get_op_ia32_l_Mul(void);
int is_ia32_l_Mul(const ir_node *n);
/**
 * construct l_Mul node
 */
ir_node *new_bd_ia32_l_Mul(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_ia32_xAndNot;
ir_op *get_op_ia32_xAndNot(void);
int is_ia32_xAndNot(const ir_node *n);
/**
 * construct xAndNot node
 */
ir_node *new_bd_ia32_xAndNot(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem, ir_node *left, ir_node *right);

extern ir_op *op_ia32_Load;
ir_op *get_op_ia32_Load(void);
int is_ia32_Load(const ir_node *n);
/**
 * construct Load node
 */
ir_node *new_bd_ia32_Load(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);

extern ir_op *op_ia32_Prefetch;
ir_op *get_op_ia32_Prefetch(void);
int is_ia32_Prefetch(const ir_node *n);
/**
 * construct Prefetch node
 */
ir_node *new_bd_ia32_Prefetch(dbg_info *dbgi, ir_node *block, ir_node *base, ir_node *index, ir_node *mem);



enum n_ia32_FldCW {
	n_ia32_FldCW_base = 0,
	n_ia32_FldCW_index = 1,
	n_ia32_FldCW_mem = 2,
};

enum pn_ia32_fadd {
	pn_ia32_fadd_res = 0,
	pn_ia32_fadd_dummy = 1,
	pn_ia32_fadd_M = 2,
};

enum n_ia32_fadd {
	n_ia32_fadd_base = 0,
	n_ia32_fadd_index = 1,
	n_ia32_fadd_mem = 2,
	n_ia32_fadd_left = 3,
	n_ia32_fadd_right = 4,
	n_ia32_fadd_fpcw = 5,
};

enum n_ia32_ShrMem {
	n_ia32_ShrMem_base = 0,
	n_ia32_ShrMem_index = 1,
	n_ia32_ShrMem_mem = 2,
	n_ia32_ShrMem_count = 3,
};

enum n_ia32_CvtSI2SS {
	n_ia32_CvtSI2SS_base = 0,
	n_ia32_CvtSI2SS_index = 1,
	n_ia32_CvtSI2SS_mem = 2,
	n_ia32_CvtSI2SS_val = 3,
};

enum pn_ia32_Bsf {
	pn_ia32_Bsf_res = 0,
	pn_ia32_Bsf_flags = 1,
	pn_ia32_Bsf_M = 2,
};

enum n_ia32_Bsf {
	n_ia32_Bsf_base = 0,
	n_ia32_Bsf_index = 1,
	n_ia32_Bsf_mem = 2,
	n_ia32_Bsf_operand = 3,
};

enum pn_ia32_ShlD {
	pn_ia32_ShlD_res = 0,
	pn_ia32_ShlD_flags = 1,
};

enum n_ia32_ShlD {
	n_ia32_ShlD_val_high = 0,
	n_ia32_ShlD_val_low = 1,
	n_ia32_ShlD_count = 2,
};

enum pn_ia32_PopEbp {
	pn_ia32_PopEbp_res = 0,
	pn_ia32_PopEbp_M = 1,
	pn_ia32_PopEbp_unused = 2,
	pn_ia32_PopEbp_stack = 3,
};

enum n_ia32_PopEbp {
	n_ia32_PopEbp_mem = 0,
	n_ia32_PopEbp_stack = 1,
};

enum pn_ia32_Inc {
	pn_ia32_Inc_res = 0,
	pn_ia32_Inc_flags = 1,
};

enum n_ia32_Inc {
	n_ia32_Inc_val = 0,
};

enum pn_ia32_xStore {
	pn_ia32_xStore_M = 0,
	pn_ia32_xStore_X_regular = 1,
	pn_ia32_xStore_X_except = 2,
};

enum n_ia32_xStore {
	n_ia32_xStore_base = 0,
	n_ia32_xStore_index = 1,
	n_ia32_xStore_mem = 2,
	n_ia32_xStore_val = 3,
};

enum pn_ia32_xxLoad {
	pn_ia32_xxLoad_res = 0,
	pn_ia32_xxLoad_M = 1,
	pn_ia32_xxLoad_X_regular = 2,
	pn_ia32_xxLoad_X_except = 3,
};

enum n_ia32_xxLoad {
	n_ia32_xxLoad_base = 0,
	n_ia32_xxLoad_index = 1,
	n_ia32_xxLoad_mem = 2,
};

enum pn_ia32_xAnd {
	pn_ia32_xAnd_res = 0,
	pn_ia32_xAnd_flags = 1,
	pn_ia32_xAnd_M = 2,
};

enum n_ia32_xAnd {
	n_ia32_xAnd_base = 0,
	n_ia32_xAnd_index = 1,
	n_ia32_xAnd_mem = 2,
	n_ia32_xAnd_left = 3,
	n_ia32_xAnd_right = 4,
};

enum pn_ia32_xAdd {
	pn_ia32_xAdd_res = 0,
	pn_ia32_xAdd_flags = 1,
	pn_ia32_xAdd_M = 2,
};

enum n_ia32_xAdd {
	n_ia32_xAdd_base = 0,
	n_ia32_xAdd_index = 1,
	n_ia32_xAdd_mem = 2,
	n_ia32_xAdd_left = 3,
	n_ia32_xAdd_right = 4,
};

enum pn_ia32_xxStore {
	pn_ia32_xxStore_M = 0,
	pn_ia32_xxStore_X_regular = 1,
	pn_ia32_xxStore_X_except = 2,
};

enum n_ia32_xxStore {
	n_ia32_xxStore_base = 0,
	n_ia32_xxStore_index = 1,
	n_ia32_xxStore_mem = 2,
	n_ia32_xxStore_val = 3,
};

enum pn_ia32_Call {
	pn_ia32_Call_stack = 0,
	pn_ia32_Call_fpcw = 1,
	pn_ia32_Call_M = 2,
	pn_ia32_Call_eax = 3,
	pn_ia32_Call_ecx = 4,
	pn_ia32_Call_edx = 5,
	pn_ia32_Call_st0 = 6,
	pn_ia32_Call_st1 = 7,
	pn_ia32_Call_st2 = 8,
	pn_ia32_Call_st3 = 9,
	pn_ia32_Call_st4 = 10,
	pn_ia32_Call_st5 = 11,
	pn_ia32_Call_st6 = 12,
	pn_ia32_Call_st7 = 13,
	pn_ia32_Call_xmm0 = 14,
	pn_ia32_Call_xmm1 = 15,
	pn_ia32_Call_xmm2 = 16,
	pn_ia32_Call_xmm3 = 17,
	pn_ia32_Call_xmm4 = 18,
	pn_ia32_Call_xmm5 = 19,
	pn_ia32_Call_xmm6 = 20,
	pn_ia32_Call_xmm7 = 21,
	pn_ia32_Call_X_regular = 22,
	pn_ia32_Call_X_except = 23,
};

enum n_ia32_Call {
	n_ia32_Call_base = 0,
	n_ia32_Call_index = 1,
	n_ia32_Call_mem = 2,
	n_ia32_Call_addr = 3,
	n_ia32_Call_stack = 4,
	n_ia32_Call_fpcw = 5,
	n_ia32_Call_eax = 6,
	n_ia32_Call_ecx = 7,
	n_ia32_Call_edx = 8,
};

enum n_ia32_FnstCWNOP {
	n_ia32_FnstCWNOP_fpcw = 0,
};

enum n_ia32_XorMem8Bit {
	n_ia32_XorMem8Bit_base = 0,
	n_ia32_XorMem8Bit_index = 1,
	n_ia32_XorMem8Bit_mem = 2,
	n_ia32_XorMem8Bit_val = 3,
};

enum pn_ia32_fldl2t {
	pn_ia32_fldl2t_res = 0,
};

enum pn_ia32_fisttp {
	pn_ia32_fisttp_res = 0,
	pn_ia32_fisttp_M = 1,
	pn_ia32_fisttp_X_regular = 2,
	pn_ia32_fisttp_X_except = 3,
};

enum n_ia32_fisttp {
	n_ia32_fisttp_base = 0,
	n_ia32_fisttp_index = 1,
	n_ia32_fisttp_mem = 2,
	n_ia32_fisttp_val = 3,
};

enum n_ia32_DecMem {
	n_ia32_DecMem_base = 0,
	n_ia32_DecMem_index = 1,
	n_ia32_DecMem_mem = 2,
};

enum pn_ia32_xLoad {
	pn_ia32_xLoad_res = 0,
	pn_ia32_xLoad_unused = 1,
	pn_ia32_xLoad_M = 2,
	pn_ia32_xLoad_X_regular = 3,
	pn_ia32_xLoad_X_except = 4,
};

enum n_ia32_xLoad {
	n_ia32_xLoad_base = 0,
	n_ia32_xLoad_index = 1,
	n_ia32_xLoad_mem = 2,
};

enum pn_ia32_l_FloattoLL {
	pn_ia32_l_FloattoLL_res_high = 0,
	pn_ia32_l_FloattoLL_res_low = 1,
};

enum n_ia32_l_FloattoLL {
	n_ia32_l_FloattoLL_val = 0,
};

enum n_ia32_CvtSI2SD {
	n_ia32_CvtSI2SD_base = 0,
	n_ia32_CvtSI2SD_index = 1,
	n_ia32_CvtSI2SD_mem = 2,
	n_ia32_CvtSI2SD_val = 3,
};

enum n_ia32_XorMem {
	n_ia32_XorMem_base = 0,
	n_ia32_XorMem_index = 1,
	n_ia32_XorMem_mem = 2,
	n_ia32_XorMem_val = 3,
};

enum pn_ia32_CopyB {
	pn_ia32_CopyB_dest = 0,
	pn_ia32_CopyB_source = 1,
	pn_ia32_CopyB_count = 2,
	pn_ia32_CopyB_M = 3,
	pn_ia32_CopyB_X_regular = 4,
	pn_ia32_CopyB_X_except = 5,
};

enum n_ia32_CopyB {
	n_ia32_CopyB_dest = 0,
	n_ia32_CopyB_source = 1,
	n_ia32_CopyB_count = 2,
	n_ia32_CopyB_mem = 3,
};

enum pn_ia32_Xor0 {
	pn_ia32_Xor0_res = 0,
	pn_ia32_Xor0_flags = 1,
};

enum pn_ia32_Sar {
	pn_ia32_Sar_res = 0,
	pn_ia32_Sar_flags = 1,
};

enum n_ia32_Sar {
	n_ia32_Sar_val = 0,
	n_ia32_Sar_count = 1,
};

enum pn_ia32_Div {
	pn_ia32_Div_div_res = 0,
	pn_ia32_Div_flags = 1,
	pn_ia32_Div_M = 2,
	pn_ia32_Div_mod_res = 3,
	pn_ia32_Div_X_regular = 4,
	pn_ia32_Div_X_except = 5,
};

enum n_ia32_Div {
	n_ia32_Div_base = 0,
	n_ia32_Div_index = 1,
	n_ia32_Div_mem = 2,
	n_ia32_Div_divisor = 3,
	n_ia32_Div_dividend_low = 4,
	n_ia32_Div_dividend_high = 5,
};

enum pn_ia32_Fucomi {
	pn_ia32_Fucomi_flags = 0,
};

enum n_ia32_Fucomi {
	n_ia32_Fucomi_left = 0,
	n_ia32_Fucomi_right = 1,
};

enum pn_ia32_fldl2e {
	pn_ia32_fldl2e_res = 0,
};

enum pn_ia32_Enter {
	pn_ia32_Enter_frame = 0,
	pn_ia32_Enter_stack = 1,
	pn_ia32_Enter_M = 2,
};

enum pn_ia32_fmul {
	pn_ia32_fmul_res = 0,
	pn_ia32_fmul_dummy = 1,
	pn_ia32_fmul_M = 2,
};

enum n_ia32_fmul {
	n_ia32_fmul_base = 0,
	n_ia32_fmul_index = 1,
	n_ia32_fmul_mem = 2,
	n_ia32_fmul_left = 3,
	n_ia32_fmul_right = 4,
	n_ia32_fmul_fpcw = 5,
};

enum pn_ia32_l_IMul {
	pn_ia32_l_IMul_res_low = 0,
	pn_ia32_l_IMul_flags = 1,
	pn_ia32_l_IMul_M = 2,
	pn_ia32_l_IMul_res_high = 3,
};

enum n_ia32_l_IMul {
	n_ia32_l_IMul_left = 0,
	n_ia32_l_IMul_right = 1,
};

enum pn_ia32_xMax {
	pn_ia32_xMax_res = 0,
	pn_ia32_xMax_flags = 1,
	pn_ia32_xMax_M = 2,
};

enum n_ia32_xMax {
	n_ia32_xMax_base = 0,
	n_ia32_xMax_index = 1,
	n_ia32_xMax_mem = 2,
	n_ia32_xMax_left = 3,
	n_ia32_xMax_right = 4,
};

enum n_ia32_OrMem8Bit {
	n_ia32_OrMem8Bit_base = 0,
	n_ia32_OrMem8Bit_index = 1,
	n_ia32_OrMem8Bit_mem = 2,
	n_ia32_OrMem8Bit_val = 3,
};

enum pn_ia32_Prefetch1 {
	pn_ia32_Prefetch1_M = 0,
};

enum n_ia32_Prefetch1 {
	n_ia32_Prefetch1_base = 0,
	n_ia32_Prefetch1_index = 1,
	n_ia32_Prefetch1_mem = 2,
};

enum pn_ia32_fsub {
	pn_ia32_fsub_res = 0,
	pn_ia32_fsub_dummy = 1,
	pn_ia32_fsub_M = 2,
};

enum n_ia32_fsub {
	n_ia32_fsub_base = 0,
	n_ia32_fsub_index = 1,
	n_ia32_fsub_mem = 2,
	n_ia32_fsub_minuend = 3,
	n_ia32_fsub_subtrahend = 4,
	n_ia32_fsub_fpcw = 5,
};

enum n_ia32_Lea {
	n_ia32_Lea_base = 0,
	n_ia32_Lea_index = 1,
};

enum pn_ia32_FtstFnstsw {
	pn_ia32_FtstFnstsw_flags = 0,
};

enum n_ia32_FtstFnstsw {
	n_ia32_FtstFnstsw_left = 0,
};

enum n_ia32_NotMem {
	n_ia32_NotMem_base = 0,
	n_ia32_NotMem_index = 1,
	n_ia32_NotMem_mem = 2,
};

enum pn_ia32_Sbb0 {
	pn_ia32_Sbb0_res = 0,
	pn_ia32_Sbb0_flags = 1,
};

enum n_ia32_Bt {
	n_ia32_Bt_left = 0,
	n_ia32_Bt_right = 1,
};

enum pn_ia32_Or {
	pn_ia32_Or_res = 0,
	pn_ia32_Or_flags = 1,
	pn_ia32_Or_M = 2,
};

enum n_ia32_Or {
	n_ia32_Or_base = 0,
	n_ia32_Or_index = 1,
	n_ia32_Or_mem = 2,
	n_ia32_Or_left = 3,
	n_ia32_Or_right = 4,
};

enum pn_ia32_Xor {
	pn_ia32_Xor_res = 0,
	pn_ia32_Xor_flags = 1,
	pn_ia32_Xor_M = 2,
};

enum n_ia32_Xor {
	n_ia32_Xor_base = 0,
	n_ia32_Xor_index = 1,
	n_ia32_Xor_mem = 2,
	n_ia32_Xor_left = 3,
	n_ia32_Xor_right = 4,
};

enum pn_ia32_CopyB_i {
	pn_ia32_CopyB_i_dest = 0,
	pn_ia32_CopyB_i_source = 1,
	pn_ia32_CopyB_i_M = 2,
	pn_ia32_CopyB_i_X_regular = 3,
	pn_ia32_CopyB_i_X_except = 4,
};

enum n_ia32_CopyB_i {
	n_ia32_CopyB_i_dest = 0,
	n_ia32_CopyB_i_source = 1,
	n_ia32_CopyB_i_mem = 2,
};

enum n_ia32_IncMem {
	n_ia32_IncMem_base = 0,
	n_ia32_IncMem_index = 1,
	n_ia32_IncMem_mem = 2,
};

enum n_ia32_Breakpoint {
	n_ia32_Breakpoint_mem = 0,
};

enum pn_ia32_ClimbFrame {
	pn_ia32_ClimbFrame_res = 0,
};

enum n_ia32_ClimbFrame {
	n_ia32_ClimbFrame_frame = 0,
	n_ia32_ClimbFrame_cnt = 1,
	n_ia32_ClimbFrame_tmp = 2,
};

enum n_ia32_SubMem {
	n_ia32_SubMem_base = 0,
	n_ia32_SubMem_index = 1,
	n_ia32_SubMem_mem = 2,
	n_ia32_SubMem_subtrahend = 3,
};

enum n_ia32_AddMem {
	n_ia32_AddMem_base = 0,
	n_ia32_AddMem_index = 1,
	n_ia32_AddMem_mem = 2,
	n_ia32_AddMem_val = 3,
};

enum n_ia32_ShlMem {
	n_ia32_ShlMem_base = 0,
	n_ia32_ShlMem_index = 1,
	n_ia32_ShlMem_mem = 2,
	n_ia32_ShlMem_count = 3,
};

enum pn_ia32_fdiv {
	pn_ia32_fdiv_res = 0,
	pn_ia32_fdiv_dummy = 1,
	pn_ia32_fdiv_M = 2,
};

enum n_ia32_fdiv {
	n_ia32_fdiv_base = 0,
	n_ia32_fdiv_index = 1,
	n_ia32_fdiv_mem = 2,
	n_ia32_fdiv_dividend = 3,
	n_ia32_fdiv_divisor = 4,
	n_ia32_fdiv_fpcw = 5,
};

enum n_ia32_Outport {
	n_ia32_Outport_port = 0,
	n_ia32_Outport_value = 1,
	n_ia32_Outport_mem = 2,
};

enum pn_ia32_xMin {
	pn_ia32_xMin_res = 0,
	pn_ia32_xMin_flags = 1,
	pn_ia32_xMin_M = 2,
};

enum n_ia32_xMin {
	n_ia32_xMin_base = 0,
	n_ia32_xMin_index = 1,
	n_ia32_xMin_mem = 2,
	n_ia32_xMin_left = 3,
	n_ia32_xMin_right = 4,
};

enum pn_ia32_fist {
	pn_ia32_fist_dummy = 0,
	pn_ia32_fist_M = 1,
	pn_ia32_fist_X_regular = 2,
	pn_ia32_fist_X_except = 3,
};

enum n_ia32_fist {
	n_ia32_fist_base = 0,
	n_ia32_fist_index = 1,
	n_ia32_fist_mem = 2,
	n_ia32_fist_val = 3,
	n_ia32_fist_fpcw = 4,
};

enum pn_ia32_xXor {
	pn_ia32_xXor_res = 0,
	pn_ia32_xXor_flags = 1,
	pn_ia32_xXor_M = 2,
};

enum n_ia32_xXor {
	n_ia32_xXor_base = 0,
	n_ia32_xXor_index = 1,
	n_ia32_xXor_mem = 2,
	n_ia32_xXor_left = 3,
	n_ia32_xXor_right = 4,
};

enum pn_ia32_IJmp {
	pn_ia32_IJmp_jmp = 0,
	pn_ia32_IJmp_flags = 1,
	pn_ia32_IJmp_M = 2,
};

enum n_ia32_IJmp {
	n_ia32_IJmp_base = 0,
	n_ia32_IJmp_index = 1,
	n_ia32_IJmp_mem = 2,
	n_ia32_IJmp_target = 3,
};

enum n_ia32_NegMem {
	n_ia32_NegMem_base = 0,
	n_ia32_NegMem_index = 1,
	n_ia32_NegMem_mem = 2,
};

enum pn_ia32_CMovcc {
	pn_ia32_CMovcc_res = 0,
	pn_ia32_CMovcc_flags = 1,
	pn_ia32_CMovcc_M = 2,
};

enum n_ia32_CMovcc {
	n_ia32_CMovcc_base = 0,
	n_ia32_CMovcc_index = 1,
	n_ia32_CMovcc_mem = 2,
	n_ia32_CMovcc_val_false = 3,
	n_ia32_CMovcc_val_true = 4,
	n_ia32_CMovcc_eflags = 5,
};

enum pn_ia32_Mul {
	pn_ia32_Mul_res_low = 0,
	pn_ia32_Mul_flags = 1,
	pn_ia32_Mul_M = 2,
	pn_ia32_Mul_res_high = 3,
};

enum n_ia32_Mul {
	n_ia32_Mul_base = 0,
	n_ia32_Mul_index = 1,
	n_ia32_Mul_mem = 2,
	n_ia32_Mul_left = 3,
	n_ia32_Mul_right = 4,
};

enum pn_ia32_Sahf {
	pn_ia32_Sahf_flags = 0,
};

enum n_ia32_Sahf {
	n_ia32_Sahf_val = 0,
};

enum n_ia32_SubMem8Bit {
	n_ia32_SubMem8Bit_base = 0,
	n_ia32_SubMem8Bit_index = 1,
	n_ia32_SubMem8Bit_mem = 2,
	n_ia32_SubMem8Bit_subtrahend = 3,
};

enum n_ia32_AddMem8Bit {
	n_ia32_AddMem8Bit_base = 0,
	n_ia32_AddMem8Bit_index = 1,
	n_ia32_AddMem8Bit_mem = 2,
	n_ia32_AddMem8Bit_val = 3,
};

enum pn_ia32_fst {
	pn_ia32_fst_M = 0,
	pn_ia32_fst_X_regular = 1,
	pn_ia32_fst_X_except = 2,
};

enum n_ia32_fst {
	n_ia32_fst_base = 0,
	n_ia32_fst_index = 1,
	n_ia32_fst_mem = 2,
	n_ia32_fst_val = 3,
};

enum pn_ia32_FucomppFnstsw {
	pn_ia32_FucomppFnstsw_flags = 0,
};

enum n_ia32_FucomppFnstsw {
	n_ia32_FucomppFnstsw_left = 0,
	n_ia32_FucomppFnstsw_right = 1,
};

enum n_ia32_RorMem {
	n_ia32_RorMem_base = 0,
	n_ia32_RorMem_index = 1,
	n_ia32_RorMem_mem = 2,
	n_ia32_RorMem_count = 3,
};

enum pn_ia32_fild {
	pn_ia32_fild_res = 0,
	pn_ia32_fild_unused = 1,
	pn_ia32_fild_M = 2,
};

enum n_ia32_fild {
	n_ia32_fild_base = 0,
	n_ia32_fild_index = 1,
	n_ia32_fild_mem = 2,
};

enum pn_ia32_xOr {
	pn_ia32_xOr_res = 0,
	pn_ia32_xOr_flags = 1,
	pn_ia32_xOr_M = 2,
};

enum n_ia32_xOr {
	n_ia32_xOr_base = 0,
	n_ia32_xOr_index = 1,
	n_ia32_xOr_mem = 2,
	n_ia32_xOr_left = 3,
	n_ia32_xOr_right = 4,
};

enum pn_ia32_Conv_I2I8Bit {
	pn_ia32_Conv_I2I8Bit_res = 0,
	pn_ia32_Conv_I2I8Bit_flags = 1,
	pn_ia32_Conv_I2I8Bit_M = 2,
	pn_ia32_Conv_I2I8Bit_X_regular = 3,
	pn_ia32_Conv_I2I8Bit_X_except = 4,
};

enum n_ia32_Conv_I2I8Bit {
	n_ia32_Conv_I2I8Bit_base = 0,
	n_ia32_Conv_I2I8Bit_index = 1,
	n_ia32_Conv_I2I8Bit_mem = 2,
	n_ia32_Conv_I2I8Bit_val = 3,
};

enum pn_ia32_Store {
	pn_ia32_Store_M = 0,
	pn_ia32_Store_X_regular = 1,
	pn_ia32_Store_X_except = 2,
};

enum n_ia32_Store {
	n_ia32_Store_base = 0,
	n_ia32_Store_index = 1,
	n_ia32_Store_mem = 2,
	n_ia32_Store_val = 3,
};

enum pn_ia32_fldln2 {
	pn_ia32_fldln2_res = 0,
};

enum n_ia32_SwitchJmp {
	n_ia32_SwitchJmp_base = 0,
	n_ia32_SwitchJmp_index = 1,
};

enum pn_ia32_IMul {
	pn_ia32_IMul_res = 0,
	pn_ia32_IMul_flags = 1,
	pn_ia32_IMul_M = 2,
};

enum n_ia32_IMul {
	n_ia32_IMul_base = 0,
	n_ia32_IMul_index = 1,
	n_ia32_IMul_mem = 2,
	n_ia32_IMul_left = 3,
	n_ia32_IMul_right = 4,
};

enum pn_ia32_Ucomi {
	pn_ia32_Ucomi_flags = 0,
};

enum n_ia32_Ucomi {
	n_ia32_Ucomi_base = 0,
	n_ia32_Ucomi_index = 1,
	n_ia32_Ucomi_mem = 2,
	n_ia32_Ucomi_left = 3,
	n_ia32_Ucomi_right = 4,
};

enum pn_ia32_fldz {
	pn_ia32_fldz_res = 0,
};

enum pn_ia32_Store8Bit {
	pn_ia32_Store8Bit_M = 0,
	pn_ia32_Store8Bit_X_regular = 1,
	pn_ia32_Store8Bit_X_except = 2,
};

enum n_ia32_Store8Bit {
	n_ia32_Store8Bit_base = 0,
	n_ia32_Store8Bit_index = 1,
	n_ia32_Store8Bit_mem = 2,
	n_ia32_Store8Bit_val = 3,
};

enum n_ia32_l_Sub {
	n_ia32_l_Sub_minuend = 0,
	n_ia32_l_Sub_subtrahend = 1,
};

enum pn_ia32_Sbb {
	pn_ia32_Sbb_res = 0,
	pn_ia32_Sbb_flags = 1,
	pn_ia32_Sbb_M = 2,
};

enum n_ia32_Sbb {
	n_ia32_Sbb_base = 0,
	n_ia32_Sbb_index = 1,
	n_ia32_Sbb_mem = 2,
	n_ia32_Sbb_minuend = 3,
	n_ia32_Sbb_subtrahend = 4,
	n_ia32_Sbb_eflags = 5,
};

enum pn_ia32_FucomFnstsw {
	pn_ia32_FucomFnstsw_flags = 0,
};

enum n_ia32_FucomFnstsw {
	n_ia32_FucomFnstsw_left = 0,
	n_ia32_FucomFnstsw_right = 1,
};

enum pn_ia32_xMul {
	pn_ia32_xMul_res = 0,
	pn_ia32_xMul_flags = 1,
	pn_ia32_xMul_M = 2,
};

enum n_ia32_xMul {
	n_ia32_xMul_base = 0,
	n_ia32_xMul_index = 1,
	n_ia32_xMul_mem = 2,
	n_ia32_xMul_left = 3,
	n_ia32_xMul_right = 4,
};

enum pn_ia32_Push {
	pn_ia32_Push_stack = 0,
	pn_ia32_Push_M = 1,
};

enum n_ia32_Push {
	n_ia32_Push_base = 0,
	n_ia32_Push_index = 1,
	n_ia32_Push_mem = 2,
	n_ia32_Push_val = 3,
	n_ia32_Push_stack = 4,
};

enum pn_ia32_Cmp {
	pn_ia32_Cmp_eflags = 0,
	pn_ia32_Cmp_unused = 1,
	pn_ia32_Cmp_M = 2,
};

enum n_ia32_Cmp {
	n_ia32_Cmp_base = 0,
	n_ia32_Cmp_index = 1,
	n_ia32_Cmp_mem = 2,
	n_ia32_Cmp_left = 3,
	n_ia32_Cmp_right = 4,
};

enum pn_ia32_xSub {
	pn_ia32_xSub_res = 0,
	pn_ia32_xSub_flags = 1,
	pn_ia32_xSub_M = 2,
};

enum n_ia32_xSub {
	n_ia32_xSub_base = 0,
	n_ia32_xSub_index = 1,
	n_ia32_xSub_mem = 2,
	n_ia32_xSub_minuend = 3,
	n_ia32_xSub_subtrahend = 4,
};

enum n_ia32_Cltd {
	n_ia32_Cltd_val = 0,
	n_ia32_Cltd_clobbered = 1,
};

enum pn_ia32_PushEax {
	pn_ia32_PushEax_stack = 0,
};

enum n_ia32_PushEax {
	n_ia32_PushEax_stack = 0,
};

enum pn_ia32_XorHighLow {
	pn_ia32_XorHighLow_res = 0,
	pn_ia32_XorHighLow_flags = 1,
};

enum n_ia32_XorHighLow {
	n_ia32_XorHighLow_value = 0,
};

enum pn_ia32_Rol {
	pn_ia32_Rol_res = 0,
	pn_ia32_Rol_flags = 1,
};

enum n_ia32_Rol {
	n_ia32_Rol_val = 0,
	n_ia32_Rol_count = 1,
};

enum pn_ia32_Cmp8Bit {
	pn_ia32_Cmp8Bit_eflags = 0,
	pn_ia32_Cmp8Bit_unused = 1,
	pn_ia32_Cmp8Bit_M = 2,
};

enum n_ia32_Cmp8Bit {
	n_ia32_Cmp8Bit_base = 0,
	n_ia32_Cmp8Bit_index = 1,
	n_ia32_Cmp8Bit_mem = 2,
	n_ia32_Cmp8Bit_left = 3,
	n_ia32_Cmp8Bit_right = 4,
};

enum pn_ia32_xDiv {
	pn_ia32_xDiv_res = 0,
	pn_ia32_xDiv_flags = 1,
	pn_ia32_xDiv_M = 2,
};

enum n_ia32_xDiv {
	n_ia32_xDiv_base = 0,
	n_ia32_xDiv_index = 1,
	n_ia32_xDiv_mem = 2,
	n_ia32_xDiv_dividend = 3,
	n_ia32_xDiv_divisor = 4,
};

enum pn_ia32_Test8Bit {
	pn_ia32_Test8Bit_eflags = 0,
	pn_ia32_Test8Bit_unused = 1,
	pn_ia32_Test8Bit_M = 2,
};

enum n_ia32_Test8Bit {
	n_ia32_Test8Bit_base = 0,
	n_ia32_Test8Bit_index = 1,
	n_ia32_Test8Bit_mem = 2,
	n_ia32_Test8Bit_left = 3,
	n_ia32_Test8Bit_right = 4,
};

enum pn_ia32_Sub {
	pn_ia32_Sub_res = 0,
	pn_ia32_Sub_flags = 1,
	pn_ia32_Sub_M = 2,
};

enum n_ia32_Sub {
	n_ia32_Sub_base = 0,
	n_ia32_Sub_index = 1,
	n_ia32_Sub_mem = 2,
	n_ia32_Sub_minuend = 3,
	n_ia32_Sub_subtrahend = 4,
};

enum pn_ia32_PrefetchNTA {
	pn_ia32_PrefetchNTA_M = 0,
};

enum n_ia32_PrefetchNTA {
	n_ia32_PrefetchNTA_base = 0,
	n_ia32_PrefetchNTA_index = 1,
	n_ia32_PrefetchNTA_mem = 2,
};

enum pn_ia32_Shr {
	pn_ia32_Shr_res = 0,
	pn_ia32_Shr_flags = 1,
};

enum n_ia32_Shr {
	n_ia32_Shr_val = 0,
	n_ia32_Shr_count = 1,
};

enum n_ia32_fprem {
	n_ia32_fprem_left = 0,
	n_ia32_fprem_right = 1,
	n_ia32_fprem_fpcw = 2,
};

enum pn_ia32_IDiv {
	pn_ia32_IDiv_div_res = 0,
	pn_ia32_IDiv_flags = 1,
	pn_ia32_IDiv_M = 2,
	pn_ia32_IDiv_mod_res = 3,
	pn_ia32_IDiv_X_regular = 4,
	pn_ia32_IDiv_X_except = 5,
};

enum n_ia32_IDiv {
	n_ia32_IDiv_base = 0,
	n_ia32_IDiv_index = 1,
	n_ia32_IDiv_mem = 2,
	n_ia32_IDiv_divisor = 3,
	n_ia32_IDiv_dividend_low = 4,
	n_ia32_IDiv_dividend_high = 5,
};

enum n_ia32_l_Adc {
	n_ia32_l_Adc_left = 0,
	n_ia32_l_Adc_right = 1,
	n_ia32_l_Adc_eflags = 2,
};

enum pn_ia32_Setcc {
	pn_ia32_Setcc_res = 0,
};

enum n_ia32_Setcc {
	n_ia32_Setcc_eflags = 0,
};

enum n_ia32_l_LLtoFloat {
	n_ia32_l_LLtoFloat_val_high = 0,
	n_ia32_l_LLtoFloat_val_low = 1,
};

enum pn_ia32_Bswap {
	pn_ia32_Bswap_res = 0,
};

enum n_ia32_Bswap {
	n_ia32_Bswap_val = 0,
};

enum n_ia32_SetccMem {
	n_ia32_SetccMem_base = 0,
	n_ia32_SetccMem_index = 1,
	n_ia32_SetccMem_mem = 2,
	n_ia32_SetccMem_eflags = 3,
};

enum pn_ia32_Test {
	pn_ia32_Test_eflags = 0,
	pn_ia32_Test_unused = 1,
	pn_ia32_Test_M = 2,
};

enum n_ia32_Test {
	n_ia32_Test_base = 0,
	n_ia32_Test_index = 1,
	n_ia32_Test_mem = 2,
	n_ia32_Test_left = 3,
	n_ia32_Test_right = 4,
};

enum n_ia32_l_Add {
	n_ia32_l_Add_left = 0,
	n_ia32_l_Add_right = 1,
};

enum pn_ia32_AddSP {
	pn_ia32_AddSP_stack = 0,
	pn_ia32_AddSP_M = 1,
};

enum n_ia32_AddSP {
	n_ia32_AddSP_base = 0,
	n_ia32_AddSP_index = 1,
	n_ia32_AddSP_mem = 2,
	n_ia32_AddSP_stack = 3,
	n_ia32_AddSP_size = 4,
};

enum n_ia32_RolMem {
	n_ia32_RolMem_base = 0,
	n_ia32_RolMem_index = 1,
	n_ia32_RolMem_mem = 2,
	n_ia32_RolMem_count = 3,
};

enum n_ia32_Conv_I2FP {
	n_ia32_Conv_I2FP_base = 0,
	n_ia32_Conv_I2FP_index = 1,
	n_ia32_Conv_I2FP_mem = 2,
	n_ia32_Conv_I2FP_val = 3,
};

enum n_ia32_Conv_FP2FP {
	n_ia32_Conv_FP2FP_base = 0,
	n_ia32_Conv_FP2FP_index = 1,
	n_ia32_Conv_FP2FP_mem = 2,
	n_ia32_Conv_FP2FP_val = 3,
};

enum pn_ia32_Prefetch2 {
	pn_ia32_Prefetch2_M = 0,
};

enum n_ia32_Prefetch2 {
	n_ia32_Prefetch2_base = 0,
	n_ia32_Prefetch2_index = 1,
	n_ia32_Prefetch2_mem = 2,
};

enum pn_ia32_Minus64Bit {
	pn_ia32_Minus64Bit_low_res = 0,
	pn_ia32_Minus64Bit_high_res = 1,
};

enum n_ia32_FnstCW {
	n_ia32_FnstCW_base = 0,
	n_ia32_FnstCW_index = 1,
	n_ia32_FnstCW_mem = 2,
	n_ia32_FnstCW_fpcw = 3,
};

enum pn_ia32_Prefetch0 {
	pn_ia32_Prefetch0_M = 0,
};

enum n_ia32_Prefetch0 {
	n_ia32_Prefetch0_base = 0,
	n_ia32_Prefetch0_index = 1,
	n_ia32_Prefetch0_mem = 2,
};

enum n_ia32_OrMem {
	n_ia32_OrMem_base = 0,
	n_ia32_OrMem_index = 1,
	n_ia32_OrMem_mem = 2,
	n_ia32_OrMem_val = 3,
};

enum pn_ia32_fldlg2 {
	pn_ia32_fldlg2_res = 0,
};

enum pn_ia32_fld1 {
	pn_ia32_fld1_res = 0,
};

enum n_ia32_Conv_FP2I {
	n_ia32_Conv_FP2I_base = 0,
	n_ia32_Conv_FP2I_index = 1,
	n_ia32_Conv_FP2I_mem = 2,
	n_ia32_Conv_FP2I_val = 3,
};

enum pn_ia32_Popcnt {
	pn_ia32_Popcnt_res = 0,
	pn_ia32_Popcnt_flags = 1,
	pn_ia32_Popcnt_M = 2,
};

enum n_ia32_Popcnt {
	n_ia32_Popcnt_base = 0,
	n_ia32_Popcnt_index = 1,
	n_ia32_Popcnt_mem = 2,
	n_ia32_Popcnt_operand = 3,
};

enum pn_ia32_Ror {
	pn_ia32_Ror_res = 0,
	pn_ia32_Ror_flags = 1,
};

enum n_ia32_Ror {
	n_ia32_Ror_val = 0,
	n_ia32_Ror_count = 1,
};

enum pn_ia32_Shl {
	pn_ia32_Shl_res = 0,
	pn_ia32_Shl_flags = 1,
};

enum n_ia32_Shl {
	n_ia32_Shl_val = 0,
	n_ia32_Shl_count = 1,
};

enum n_ia32_AndMem8Bit {
	n_ia32_AndMem8Bit_base = 0,
	n_ia32_AndMem8Bit_index = 1,
	n_ia32_AndMem8Bit_mem = 2,
	n_ia32_AndMem8Bit_val = 3,
};

enum pn_ia32_Add {
	pn_ia32_Add_res = 0,
	pn_ia32_Add_flags = 1,
	pn_ia32_Add_M = 2,
};

enum n_ia32_Add {
	n_ia32_Add_base = 0,
	n_ia32_Add_index = 1,
	n_ia32_Add_mem = 2,
	n_ia32_Add_left = 3,
	n_ia32_Add_right = 4,
};

enum pn_ia32_SubSP {
	pn_ia32_SubSP_stack = 0,
	pn_ia32_SubSP_addr = 1,
	pn_ia32_SubSP_M = 2,
};

enum n_ia32_SubSP {
	n_ia32_SubSP_base = 0,
	n_ia32_SubSP_index = 1,
	n_ia32_SubSP_mem = 2,
	n_ia32_SubSP_stack = 3,
	n_ia32_SubSP_size = 4,
};

enum pn_ia32_PrefetchW {
	pn_ia32_PrefetchW_M = 0,
};

enum n_ia32_PrefetchW {
	n_ia32_PrefetchW_base = 0,
	n_ia32_PrefetchW_index = 1,
	n_ia32_PrefetchW_mem = 2,
};

enum pn_ia32_Conv_I2I {
	pn_ia32_Conv_I2I_res = 0,
	pn_ia32_Conv_I2I_flags = 1,
	pn_ia32_Conv_I2I_M = 2,
	pn_ia32_Conv_I2I_X_regular = 3,
	pn_ia32_Conv_I2I_X_except = 4,
};

enum n_ia32_Conv_I2I {
	n_ia32_Conv_I2I_base = 0,
	n_ia32_Conv_I2I_index = 1,
	n_ia32_Conv_I2I_mem = 2,
	n_ia32_Conv_I2I_val = 3,
};

enum n_ia32_fchs {
	n_ia32_fchs_value = 0,
};

enum pn_ia32_ShrD {
	pn_ia32_ShrD_res = 0,
	pn_ia32_ShrD_flags = 1,
};

enum n_ia32_ShrD {
	n_ia32_ShrD_val_high = 0,
	n_ia32_ShrD_val_low = 1,
	n_ia32_ShrD_count = 2,
};

enum n_ia32_UD2 {
	n_ia32_UD2_mem = 0,
};

enum pn_ia32_Cwtl {
	pn_ia32_Cwtl_res = 0,
};

enum n_ia32_Cwtl {
	n_ia32_Cwtl_val = 0,
};

enum n_ia32_fabs {
	n_ia32_fabs_value = 0,
};

enum pn_ia32_fldpi {
	pn_ia32_fldpi_res = 0,
};

enum pn_ia32_Leave {
	pn_ia32_Leave_frame = 0,
	pn_ia32_Leave_stack = 1,
};

enum pn_ia32_Neg {
	pn_ia32_Neg_res = 0,
	pn_ia32_Neg_flags = 1,
};

enum n_ia32_Neg {
	n_ia32_Neg_val = 0,
};

enum pn_ia32_IMul1OP {
	pn_ia32_IMul1OP_res_low = 0,
	pn_ia32_IMul1OP_flags = 1,
	pn_ia32_IMul1OP_M = 2,
	pn_ia32_IMul1OP_res_high = 3,
};

enum n_ia32_IMul1OP {
	n_ia32_IMul1OP_base = 0,
	n_ia32_IMul1OP_index = 1,
	n_ia32_IMul1OP_mem = 2,
	n_ia32_IMul1OP_left = 3,
	n_ia32_IMul1OP_right = 4,
};

enum pn_ia32_PopMem {
	pn_ia32_PopMem_unused0 = 0,
	pn_ia32_PopMem_M = 1,
	pn_ia32_PopMem_unused1 = 2,
	pn_ia32_PopMem_stack = 3,
};

enum n_ia32_PopMem {
	n_ia32_PopMem_base = 0,
	n_ia32_PopMem_index = 1,
	n_ia32_PopMem_mem = 2,
	n_ia32_PopMem_stack = 3,
};

enum pn_ia32_fld {
	pn_ia32_fld_res = 0,
	pn_ia32_fld_unused = 1,
	pn_ia32_fld_M = 2,
	pn_ia32_fld_X_regular = 3,
	pn_ia32_fld_X_except = 4,
};

enum n_ia32_fld {
	n_ia32_fld_base = 0,
	n_ia32_fld_index = 1,
	n_ia32_fld_mem = 2,
};

enum pn_ia32_Dec {
	pn_ia32_Dec_res = 0,
	pn_ia32_Dec_flags = 1,
};

enum n_ia32_Dec {
	n_ia32_Dec_val = 0,
};

enum pn_ia32_Pop {
	pn_ia32_Pop_res = 0,
	pn_ia32_Pop_M = 1,
	pn_ia32_Pop_unused = 2,
	pn_ia32_Pop_stack = 3,
};

enum n_ia32_Pop {
	n_ia32_Pop_mem = 0,
	n_ia32_Pop_stack = 1,
};

enum pn_ia32_CopyEbpEsp {
	pn_ia32_CopyEbpEsp_esp = 0,
};

enum n_ia32_CopyEbpEsp {
	n_ia32_CopyEbpEsp_ebp = 0,
};

enum pn_ia32_Not {
	pn_ia32_Not_res = 0,
};

enum n_ia32_Not {
	n_ia32_Not_val = 0,
};

enum n_ia32_AndMem {
	n_ia32_AndMem_base = 0,
	n_ia32_AndMem_index = 1,
	n_ia32_AndMem_mem = 2,
	n_ia32_AndMem_val = 3,
};

enum pn_ia32_xStoreSimple {
	pn_ia32_xStoreSimple_M = 0,
	pn_ia32_xStoreSimple_X_regular = 1,
	pn_ia32_xStoreSimple_X_except = 2,
};

enum n_ia32_xStoreSimple {
	n_ia32_xStoreSimple_base = 0,
	n_ia32_xStoreSimple_index = 1,
	n_ia32_xStoreSimple_mem = 2,
	n_ia32_xStoreSimple_val = 3,
};

enum pn_ia32_And {
	pn_ia32_And_res = 0,
	pn_ia32_And_flags = 1,
	pn_ia32_And_M = 2,
};

enum n_ia32_And {
	n_ia32_And_base = 0,
	n_ia32_And_index = 1,
	n_ia32_And_mem = 2,
	n_ia32_And_left = 3,
	n_ia32_And_right = 4,
};

enum pn_ia32_Jcc {
	pn_ia32_Jcc_false = 0,
	pn_ia32_Jcc_true = 1,
};

enum n_ia32_Jcc {
	n_ia32_Jcc_eflags = 0,
};

enum n_ia32_l_Sbb {
	n_ia32_l_Sbb_minuend = 0,
	n_ia32_l_Sbb_subtrahend = 1,
	n_ia32_l_Sbb_eflags = 2,
};

enum pn_ia32_Bsr {
	pn_ia32_Bsr_res = 0,
	pn_ia32_Bsr_flags = 1,
	pn_ia32_Bsr_M = 2,
};

enum n_ia32_Bsr {
	n_ia32_Bsr_base = 0,
	n_ia32_Bsr_index = 1,
	n_ia32_Bsr_mem = 2,
	n_ia32_Bsr_operand = 3,
};

enum n_ia32_Bswap16 {
	n_ia32_Bswap16_val = 0,
};

enum pn_ia32_Inport {
	pn_ia32_Inport_res = 0,
	pn_ia32_Inport_M = 1,
};

enum n_ia32_Inport {
	n_ia32_Inport_port = 0,
	n_ia32_Inport_mem = 1,
};

enum n_ia32_SarMem {
	n_ia32_SarMem_base = 0,
	n_ia32_SarMem_index = 1,
	n_ia32_SarMem_mem = 2,
	n_ia32_SarMem_count = 3,
};

enum pn_ia32_Adc {
	pn_ia32_Adc_res = 0,
	pn_ia32_Adc_flags = 1,
	pn_ia32_Adc_M = 2,
};

enum n_ia32_Adc {
	n_ia32_Adc_base = 0,
	n_ia32_Adc_index = 1,
	n_ia32_Adc_mem = 2,
	n_ia32_Adc_left = 3,
	n_ia32_Adc_right = 4,
	n_ia32_Adc_eflags = 5,
};

enum pn_ia32_l_Mul {
	pn_ia32_l_Mul_res_low = 0,
	pn_ia32_l_Mul_flags = 1,
	pn_ia32_l_Mul_M = 2,
	pn_ia32_l_Mul_res_high = 3,
};

enum n_ia32_l_Mul {
	n_ia32_l_Mul_left = 0,
	n_ia32_l_Mul_right = 1,
};

enum pn_ia32_xAndNot {
	pn_ia32_xAndNot_res = 0,
	pn_ia32_xAndNot_flags = 1,
	pn_ia32_xAndNot_M = 2,
};

enum n_ia32_xAndNot {
	n_ia32_xAndNot_base = 0,
	n_ia32_xAndNot_index = 1,
	n_ia32_xAndNot_mem = 2,
	n_ia32_xAndNot_left = 3,
	n_ia32_xAndNot_right = 4,
};

enum pn_ia32_Load {
	pn_ia32_Load_res = 0,
	pn_ia32_Load_unused = 1,
	pn_ia32_Load_M = 2,
	pn_ia32_Load_X_regular = 3,
	pn_ia32_Load_X_except = 4,
};

enum n_ia32_Load {
	n_ia32_Load_base = 0,
	n_ia32_Load_index = 1,
	n_ia32_Load_mem = 2,
};

enum pn_ia32_Prefetch {
	pn_ia32_Prefetch_M = 0,
};

enum n_ia32_Prefetch {
	n_ia32_Prefetch_base = 0,
	n_ia32_Prefetch_index = 1,
	n_ia32_Prefetch_mem = 2,
};


#endif
