/**
 * @file
 * @brief     Generated functions to emit code for assembler ir nodes.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit ir/be/sparc/sparc_spec.pl instead.
 *            created by: ir/be/scripts/generate_emitter.pl ir/be/sparc/sparc_spec.pl ir/be/sparc
 * @date      Mon Nov 19 18:12:23 2012
 */
#include "config.h"

#include <stdio.h>
#include <assert.h>

#include "irnode.h"
#include "irop_t.h"
#include "irprog_t.h"
#include "beemitter.h"

#include "gen_sparc_emitter.h"
#include "sparc_new_nodes.h"
#include "sparc_emitter.h"

static void emit_sparc_SubCCZero(const ir_node *node)
{
	sparc_emitf(node, "subcc %S0, %SI1, %%g0");
}

static void emit_sparc_Sra(const ir_node *node)
{
	sparc_emitf(node, "sra %S0, %SI1, %D0");
}

static void emit_sparc_Ld(const ir_node *node)
{
	sparc_emitf(node, "ld%ML [%S0%O1], %D0");
}

static void emit_sparc_fitof(const ir_node *node)
{
	sparc_emitf(node, "fito%FM %S0, %D0");
}

static void emit_sparc_fadd(const ir_node *node)
{
	sparc_emitf(node, "fadd%FM %S0, %S1, %D0");
}

static void emit_sparc_RestoreZero(const ir_node *node)
{
	sparc_emitf(node, "restore");
}

static void emit_sparc_SetHi(const ir_node *node)
{
	sparc_emitf(node, "sethi %H, %D0");
}

static void emit_sparc_Xor(const ir_node *node)
{
	sparc_emitf(node, "xor %S0, %SI1, %D0");
}

static void emit_sparc_Or(const ir_node *node)
{
	sparc_emitf(node, "or %S0, %SI1, %D0");
}

static void emit_sparc_UMulh(const ir_node *node)
{
	sparc_emitf(node, "umul %S0, %SI1, %D0\nmov %%y, %D0");
}

static void emit_sparc_Cmp(const ir_node *node)
{
	sparc_emitf(node, "cmp %S0, %SI1");
}

static void emit_sparc_fftof(const ir_node *node)
{
	sparc_emitf(node, "f%FSto%FD %S0, %D0");
}

static void emit_sparc_XNorCCZero(const ir_node *node)
{
	sparc_emitf(node, "xnorcc %S0, %SI1, %%g0");
}

static void emit_sparc_AddX(const ir_node *node)
{
	sparc_emitf(node, "addx %S0, %SI1, %D0");
}

static void emit_sparc_Add(const ir_node *node)
{
	sparc_emitf(node, "add %S0, %SI1, %D0");
}

static void emit_sparc_SubCC(const ir_node *node)
{
	sparc_emitf(node, "subcc %S0, %SI1, %D0");
}

static void emit_sparc_Ldf(const ir_node *node)
{
	sparc_emitf(node, "ld%ML [%S0%O1], %D0");
}

static void emit_sparc_fdiv(const ir_node *node)
{
	sparc_emitf(node, "fdiv%FM %S0, %S1, %D0");
}

static void emit_sparc_AndN(const ir_node *node)
{
	sparc_emitf(node, "andn %S0, %SI1, %D0");
}

static void emit_sparc_fftoi(const ir_node *node)
{
	sparc_emitf(node, "f%FMtoi %S0, %D0");
}

static void emit_sparc_XorCCZero(const ir_node *node)
{
	sparc_emitf(node, "xorcc %S0, %SI1, %%g0");
}

static void emit_sparc_St(const ir_node *node)
{
	sparc_emitf(node, "st%MS %S0, [%S1%O2]");
}

static void emit_sparc_MulCCZero(const ir_node *node)
{
	sparc_emitf(node, "smulcc %S0, %SI1, %%g0");
}

static void emit_sparc_Save(const ir_node *node)
{
	sparc_emitf(node, "save %S0, %SI1, %D0");
}

static void emit_sparc_Sub(const ir_node *node)
{
	sparc_emitf(node, "sub %S0, %SI1, %D0");
}

static void emit_sparc_Mul(const ir_node *node)
{
	sparc_emitf(node, "smul %S0, %SI1, %D0");
}

static void emit_sparc_Stf(const ir_node *node)
{
	sparc_emitf(node, "st%MS %S0, [%S1%O2]");
}

static void emit_sparc_fabs(const ir_node *node)
{
	sparc_emitf(node, "fabs %S0, %D0");
}

static void emit_sparc_AddCC(const ir_node *node)
{
	sparc_emitf(node, "addcc %S0, %SI1, %D0");
}

static void emit_sparc_OrN(const ir_node *node)
{
	sparc_emitf(node, "orn %S0, %SI1, %D0");
}

static void emit_sparc_SubX(const ir_node *node)
{
	sparc_emitf(node, "subx %S0, %SI1, %D0");
}

static void emit_sparc_fcmp(const ir_node *node)
{
	sparc_emitf(node, "fcmp%FM %S0, %S1");
}

static void emit_sparc_OrCCZero(const ir_node *node)
{
	sparc_emitf(node, "orcc %S0, %SI1, %%g0");
}

static void emit_sparc_AddSP(const ir_node *node)
{
	sparc_emitf(node, "add %S0, %S1, %D0");
}

static void emit_sparc_SMulh(const ir_node *node)
{
	sparc_emitf(node, "smul %S0, %SI1, %D0\nmov %%y, %D0");
}

static void emit_sparc_XNor(const ir_node *node)
{
	sparc_emitf(node, "xnor %S0, %SI1, %D0");
}

static void emit_sparc_AndNCCZero(const ir_node *node)
{
	sparc_emitf(node, "andncc %S0, %SI1, %%g0");
}

static void emit_sparc_AndCCZero(const ir_node *node)
{
	sparc_emitf(node, "andcc %S0, %SI1, %%g0");
}

static void emit_sparc_OrNCCZero(const ir_node *node)
{
	sparc_emitf(node, "orncc %S0, %SI1, %%g0");
}

static void emit_sparc_And(const ir_node *node)
{
	sparc_emitf(node, "and %S0, %SI1, %D0");
}

static void emit_sparc_fmul(const ir_node *node)
{
	sparc_emitf(node, "fmul%FM %S0, %S1, %D0");
}

static void emit_sparc_AddCCZero(const ir_node *node)
{
	sparc_emitf(node, "addcc %S0, %SI1, %%g0");
}

static void emit_sparc_Sll(const ir_node *node)
{
	sparc_emitf(node, "sll %S0, %SI1, %D0");
}

static void emit_sparc_Srl(const ir_node *node)
{
	sparc_emitf(node, "srl %S0, %SI1, %D0");
}

static void emit_sparc_fneg(const ir_node *node)
{
	sparc_emitf(node, "fnegs %S0, %D0");
}

static void emit_sparc_fsub(const ir_node *node)
{
	sparc_emitf(node, "fsub%FM %S0, %S1, %D0");
}


typedef void (*emit_func)(const ir_node *node);

static void sparc_register_emitter(ir_op *op, emit_func func)
{
	assert(op->ops.generic == NULL);
	op->ops.generic = (op_func)func;
}

/**
 * Enters the emitter functions for handled nodes into the generic
 * pointer of an opcode.
 */
void sparc_register_spec_emitters(void)
{
  sparc_register_emitter(op_sparc_SubCCZero, emit_sparc_SubCCZero);
  sparc_register_emitter(op_sparc_Sra, emit_sparc_Sra);
  sparc_register_emitter(op_sparc_Ld, emit_sparc_Ld);
  sparc_register_emitter(op_sparc_fitof, emit_sparc_fitof);
  sparc_register_emitter(op_sparc_fadd, emit_sparc_fadd);
  sparc_register_emitter(op_sparc_RestoreZero, emit_sparc_RestoreZero);
  sparc_register_emitter(op_sparc_SetHi, emit_sparc_SetHi);
  sparc_register_emitter(op_sparc_Xor, emit_sparc_Xor);
  sparc_register_emitter(op_sparc_Or, emit_sparc_Or);
  sparc_register_emitter(op_sparc_UMulh, emit_sparc_UMulh);
  sparc_register_emitter(op_sparc_Cmp, emit_sparc_Cmp);
  sparc_register_emitter(op_sparc_fftof, emit_sparc_fftof);
  sparc_register_emitter(op_sparc_XNorCCZero, emit_sparc_XNorCCZero);
  sparc_register_emitter(op_sparc_AddX, emit_sparc_AddX);
  sparc_register_emitter(op_sparc_Add, emit_sparc_Add);
  sparc_register_emitter(op_sparc_SubCC, emit_sparc_SubCC);
  sparc_register_emitter(op_sparc_Ldf, emit_sparc_Ldf);
  sparc_register_emitter(op_sparc_fdiv, emit_sparc_fdiv);
  sparc_register_emitter(op_sparc_AndN, emit_sparc_AndN);
  sparc_register_emitter(op_sparc_fftoi, emit_sparc_fftoi);
  sparc_register_emitter(op_sparc_XorCCZero, emit_sparc_XorCCZero);
  sparc_register_emitter(op_sparc_St, emit_sparc_St);
  sparc_register_emitter(op_sparc_MulCCZero, emit_sparc_MulCCZero);
  sparc_register_emitter(op_sparc_Save, emit_sparc_Save);
  sparc_register_emitter(op_sparc_Sub, emit_sparc_Sub);
  sparc_register_emitter(op_sparc_Mul, emit_sparc_Mul);
  sparc_register_emitter(op_sparc_Stf, emit_sparc_Stf);
  sparc_register_emitter(op_sparc_fabs, emit_sparc_fabs);
  sparc_register_emitter(op_sparc_AddCC, emit_sparc_AddCC);
  sparc_register_emitter(op_sparc_OrN, emit_sparc_OrN);
  sparc_register_emitter(op_sparc_SubX, emit_sparc_SubX);
  sparc_register_emitter(op_sparc_fcmp, emit_sparc_fcmp);
  sparc_register_emitter(op_sparc_OrCCZero, emit_sparc_OrCCZero);
  sparc_register_emitter(op_sparc_AddSP, emit_sparc_AddSP);
  sparc_register_emitter(op_sparc_SMulh, emit_sparc_SMulh);
  sparc_register_emitter(op_sparc_XNor, emit_sparc_XNor);
  sparc_register_emitter(op_sparc_AndNCCZero, emit_sparc_AndNCCZero);
  sparc_register_emitter(op_sparc_AndCCZero, emit_sparc_AndCCZero);
  sparc_register_emitter(op_sparc_OrNCCZero, emit_sparc_OrNCCZero);
  sparc_register_emitter(op_sparc_And, emit_sparc_And);
  sparc_register_emitter(op_sparc_fmul, emit_sparc_fmul);
  sparc_register_emitter(op_sparc_AddCCZero, emit_sparc_AddCCZero);
  sparc_register_emitter(op_sparc_Sll, emit_sparc_Sll);
  sparc_register_emitter(op_sparc_Srl, emit_sparc_Srl);
  sparc_register_emitter(op_sparc_fneg, emit_sparc_fneg);
  sparc_register_emitter(op_sparc_fsub, emit_sparc_fsub);
}

