#include "gen_sparc_regalloc_if.h"
#include "irverify_t.h"
#include "fourcc.h"


ir_op *op_sparc_SubCCZero = NULL;
ir_op *op_sparc_Sra = NULL;
ir_op *op_sparc_Ld = NULL;
ir_op *op_sparc_fitof = NULL;
ir_op *op_sparc_fadd = NULL;
ir_op *op_sparc_Start = NULL;
ir_op *op_sparc_RestoreZero = NULL;
ir_op *op_sparc_SetHi = NULL;
ir_op *op_sparc_Xor = NULL;
ir_op *op_sparc_Or = NULL;
ir_op *op_sparc_Restore = NULL;
ir_op *op_sparc_SubX_t = NULL;
ir_op *op_sparc_UMulh = NULL;
ir_op *op_sparc_Ba = NULL;
ir_op *op_sparc_Cmp = NULL;
ir_op *op_sparc_fftof = NULL;
ir_op *op_sparc_XNorCCZero = NULL;
ir_op *op_sparc_Call = NULL;
ir_op *op_sparc_AddX = NULL;
ir_op *op_sparc_SubSP = NULL;
ir_op *op_sparc_Add = NULL;
ir_op *op_sparc_SubCC = NULL;
ir_op *op_sparc_Ldf = NULL;
ir_op *op_sparc_fdiv = NULL;
ir_op *op_sparc_AndN = NULL;
ir_op *op_sparc_fftoi = NULL;
ir_op *op_sparc_XorCCZero = NULL;
ir_op *op_sparc_St = NULL;
ir_op *op_sparc_MulCCZero = NULL;
ir_op *op_sparc_Save = NULL;
ir_op *op_sparc_fbfcc = NULL;
ir_op *op_sparc_Sub = NULL;
ir_op *op_sparc_Mul = NULL;
ir_op *op_sparc_SubCC_t = NULL;
ir_op *op_sparc_Stf = NULL;
ir_op *op_sparc_SDiv = NULL;
ir_op *op_sparc_AddX_t = NULL;
ir_op *op_sparc_fabs = NULL;
ir_op *op_sparc_AddCC = NULL;
ir_op *op_sparc_Bicc = NULL;
ir_op *op_sparc_OrN = NULL;
ir_op *op_sparc_SubX = NULL;
ir_op *op_sparc_fcmp = NULL;
ir_op *op_sparc_OrCCZero = NULL;
ir_op *op_sparc_AddSP = NULL;
ir_op *op_sparc_SMulh = NULL;
ir_op *op_sparc_AddCC_t = NULL;
ir_op *op_sparc_Return = NULL;
ir_op *op_sparc_XNor = NULL;
ir_op *op_sparc_AndNCCZero = NULL;
ir_op *op_sparc_AndCCZero = NULL;
ir_op *op_sparc_FrameAddr = NULL;
ir_op *op_sparc_OrNCCZero = NULL;
ir_op *op_sparc_And = NULL;
ir_op *op_sparc_fmul = NULL;
ir_op *op_sparc_AddCCZero = NULL;
ir_op *op_sparc_UDiv = NULL;
ir_op *op_sparc_Sll = NULL;
ir_op *op_sparc_SwitchJmp = NULL;
ir_op *op_sparc_Srl = NULL;
ir_op *op_sparc_fneg = NULL;
ir_op *op_sparc_fsub = NULL;

ir_op *get_op_sparc_SubCCZero(void)         { return op_sparc_SubCCZero; }
int    is_sparc_SubCCZero(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_SubCCZero; }

ir_op *get_op_sparc_Sra(void)         { return op_sparc_Sra; }
int    is_sparc_Sra(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Sra; }

ir_op *get_op_sparc_Ld(void)         { return op_sparc_Ld; }
int    is_sparc_Ld(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Ld; }

ir_op *get_op_sparc_fitof(void)         { return op_sparc_fitof; }
int    is_sparc_fitof(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fitof; }

ir_op *get_op_sparc_fadd(void)         { return op_sparc_fadd; }
int    is_sparc_fadd(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fadd; }

ir_op *get_op_sparc_Start(void)         { return op_sparc_Start; }
int    is_sparc_Start(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Start; }

ir_op *get_op_sparc_RestoreZero(void)         { return op_sparc_RestoreZero; }
int    is_sparc_RestoreZero(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_RestoreZero; }

ir_op *get_op_sparc_SetHi(void)         { return op_sparc_SetHi; }
int    is_sparc_SetHi(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_SetHi; }

ir_op *get_op_sparc_Xor(void)         { return op_sparc_Xor; }
int    is_sparc_Xor(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Xor; }

ir_op *get_op_sparc_Or(void)         { return op_sparc_Or; }
int    is_sparc_Or(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Or; }

ir_op *get_op_sparc_Restore(void)         { return op_sparc_Restore; }
int    is_sparc_Restore(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Restore; }

ir_op *get_op_sparc_SubX_t(void)         { return op_sparc_SubX_t; }
int    is_sparc_SubX_t(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_SubX_t; }

ir_op *get_op_sparc_UMulh(void)         { return op_sparc_UMulh; }
int    is_sparc_UMulh(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_UMulh; }

ir_op *get_op_sparc_Ba(void)         { return op_sparc_Ba; }
int    is_sparc_Ba(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Ba; }

ir_op *get_op_sparc_Cmp(void)         { return op_sparc_Cmp; }
int    is_sparc_Cmp(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Cmp; }

ir_op *get_op_sparc_fftof(void)         { return op_sparc_fftof; }
int    is_sparc_fftof(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fftof; }

ir_op *get_op_sparc_XNorCCZero(void)         { return op_sparc_XNorCCZero; }
int    is_sparc_XNorCCZero(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_XNorCCZero; }

ir_op *get_op_sparc_Call(void)         { return op_sparc_Call; }
int    is_sparc_Call(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Call; }

ir_op *get_op_sparc_AddX(void)         { return op_sparc_AddX; }
int    is_sparc_AddX(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_AddX; }

ir_op *get_op_sparc_SubSP(void)         { return op_sparc_SubSP; }
int    is_sparc_SubSP(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_SubSP; }

ir_op *get_op_sparc_Add(void)         { return op_sparc_Add; }
int    is_sparc_Add(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Add; }

ir_op *get_op_sparc_SubCC(void)         { return op_sparc_SubCC; }
int    is_sparc_SubCC(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_SubCC; }

ir_op *get_op_sparc_Ldf(void)         { return op_sparc_Ldf; }
int    is_sparc_Ldf(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Ldf; }

ir_op *get_op_sparc_fdiv(void)         { return op_sparc_fdiv; }
int    is_sparc_fdiv(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fdiv; }

ir_op *get_op_sparc_AndN(void)         { return op_sparc_AndN; }
int    is_sparc_AndN(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_AndN; }

ir_op *get_op_sparc_fftoi(void)         { return op_sparc_fftoi; }
int    is_sparc_fftoi(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fftoi; }

ir_op *get_op_sparc_XorCCZero(void)         { return op_sparc_XorCCZero; }
int    is_sparc_XorCCZero(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_XorCCZero; }

ir_op *get_op_sparc_St(void)         { return op_sparc_St; }
int    is_sparc_St(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_St; }

ir_op *get_op_sparc_MulCCZero(void)         { return op_sparc_MulCCZero; }
int    is_sparc_MulCCZero(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_MulCCZero; }

ir_op *get_op_sparc_Save(void)         { return op_sparc_Save; }
int    is_sparc_Save(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Save; }

ir_op *get_op_sparc_fbfcc(void)         { return op_sparc_fbfcc; }
int    is_sparc_fbfcc(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fbfcc; }

ir_op *get_op_sparc_Sub(void)         { return op_sparc_Sub; }
int    is_sparc_Sub(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Sub; }

ir_op *get_op_sparc_Mul(void)         { return op_sparc_Mul; }
int    is_sparc_Mul(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Mul; }

ir_op *get_op_sparc_SubCC_t(void)         { return op_sparc_SubCC_t; }
int    is_sparc_SubCC_t(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_SubCC_t; }

ir_op *get_op_sparc_Stf(void)         { return op_sparc_Stf; }
int    is_sparc_Stf(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Stf; }

ir_op *get_op_sparc_SDiv(void)         { return op_sparc_SDiv; }
int    is_sparc_SDiv(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_SDiv; }

ir_op *get_op_sparc_AddX_t(void)         { return op_sparc_AddX_t; }
int    is_sparc_AddX_t(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_AddX_t; }

ir_op *get_op_sparc_fabs(void)         { return op_sparc_fabs; }
int    is_sparc_fabs(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fabs; }

ir_op *get_op_sparc_AddCC(void)         { return op_sparc_AddCC; }
int    is_sparc_AddCC(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_AddCC; }

ir_op *get_op_sparc_Bicc(void)         { return op_sparc_Bicc; }
int    is_sparc_Bicc(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Bicc; }

ir_op *get_op_sparc_OrN(void)         { return op_sparc_OrN; }
int    is_sparc_OrN(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_OrN; }

ir_op *get_op_sparc_SubX(void)         { return op_sparc_SubX; }
int    is_sparc_SubX(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_SubX; }

ir_op *get_op_sparc_fcmp(void)         { return op_sparc_fcmp; }
int    is_sparc_fcmp(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fcmp; }

ir_op *get_op_sparc_OrCCZero(void)         { return op_sparc_OrCCZero; }
int    is_sparc_OrCCZero(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_OrCCZero; }

ir_op *get_op_sparc_AddSP(void)         { return op_sparc_AddSP; }
int    is_sparc_AddSP(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_AddSP; }

ir_op *get_op_sparc_SMulh(void)         { return op_sparc_SMulh; }
int    is_sparc_SMulh(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_SMulh; }

ir_op *get_op_sparc_AddCC_t(void)         { return op_sparc_AddCC_t; }
int    is_sparc_AddCC_t(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_AddCC_t; }

ir_op *get_op_sparc_Return(void)         { return op_sparc_Return; }
int    is_sparc_Return(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Return; }

ir_op *get_op_sparc_XNor(void)         { return op_sparc_XNor; }
int    is_sparc_XNor(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_XNor; }

ir_op *get_op_sparc_AndNCCZero(void)         { return op_sparc_AndNCCZero; }
int    is_sparc_AndNCCZero(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_AndNCCZero; }

ir_op *get_op_sparc_AndCCZero(void)         { return op_sparc_AndCCZero; }
int    is_sparc_AndCCZero(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_AndCCZero; }

ir_op *get_op_sparc_FrameAddr(void)         { return op_sparc_FrameAddr; }
int    is_sparc_FrameAddr(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_FrameAddr; }

ir_op *get_op_sparc_OrNCCZero(void)         { return op_sparc_OrNCCZero; }
int    is_sparc_OrNCCZero(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_OrNCCZero; }

ir_op *get_op_sparc_And(void)         { return op_sparc_And; }
int    is_sparc_And(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_And; }

ir_op *get_op_sparc_fmul(void)         { return op_sparc_fmul; }
int    is_sparc_fmul(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fmul; }

ir_op *get_op_sparc_AddCCZero(void)         { return op_sparc_AddCCZero; }
int    is_sparc_AddCCZero(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_AddCCZero; }

ir_op *get_op_sparc_UDiv(void)         { return op_sparc_UDiv; }
int    is_sparc_UDiv(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_UDiv; }

ir_op *get_op_sparc_Sll(void)         { return op_sparc_Sll; }
int    is_sparc_Sll(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Sll; }

ir_op *get_op_sparc_SwitchJmp(void)         { return op_sparc_SwitchJmp; }
int    is_sparc_SwitchJmp(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_SwitchJmp; }

ir_op *get_op_sparc_Srl(void)         { return op_sparc_Srl; }
int    is_sparc_Srl(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_Srl; }

ir_op *get_op_sparc_fneg(void)         { return op_sparc_fneg; }
int    is_sparc_fneg(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fneg; }

ir_op *get_op_sparc_fsub(void)         { return op_sparc_fsub; }
int    is_sparc_fsub(const ir_node *n) { return get_sparc_irn_opcode(n) == iro_sparc_fsub; }



static int sparc_opcode_start = -1;
static int sparc_opcode_end   = -1;


/** A tag for the sparc opcodes. Note that the address is used as a tag value, NOT the FOURCC code. */
#define sparc_op_tag FOURCC('S', 'P', 'A', 'R')

/** Return the opcode number of the first sparc opcode. */
int get_sparc_opcode_first(void) {
	return sparc_opcode_start;
}

/** Return the opcode number of the last sparc opcode + 1. */
int get_sparc_opcode_last(void) {
	return sparc_opcode_end;
}

/** Return 1 if the given opcode is a sparc machine op, 0 otherwise */
int is_sparc_op(const ir_op *op) {
	return get_op_tag(op) == sparc_op_tag;
}

/** Return 1 if the given node is a sparc machine node, 0 otherwise */
int is_sparc_irn(const ir_node *node) {
	return is_sparc_op(get_irn_op(node));
}

int get_sparc_irn_opcode(const ir_node *node) {
	if (is_sparc_irn(node))
		return get_irn_opcode(node) - sparc_opcode_start;
	return -1;
}

#ifdef BIT
#undef BIT
#endif
#define BIT(x)  (1 << (x))

static const unsigned sparc_limit_flags_class_flags[] = { BIT(REG_FLAGS_CLASS_FLAGS) };
static const unsigned sparc_limit_gp_sp[] = { BIT(REG_GP_SP), 0 };
static const unsigned sparc_limit_gp_frame_pointer[] = { BIT(REG_GP_FRAME_POINTER), 0 };
static const unsigned sparc_limit_fpflags_class_fpflags[] = { BIT(REG_FPFLAGS_CLASS_FPFLAGS) };

static const arch_register_req_t sparc_requirements_gp_gp = {
	arch_register_req_type_normal,
	& sparc_reg_classes[CLASS_sparc_gp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0,           /* different pos */
	1            /* width */
};


static const arch_register_req_t sparc_requirements_flags_class_flags = {
	arch_register_req_type_limited,
	& sparc_reg_classes[CLASS_sparc_flags_class],
	sparc_limit_flags_class_flags,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};


static const arch_register_req_t sparc_requirements__none = {
	arch_register_req_type_none,
	NULL,                         /* regclass */
	NULL,                         /* limit bitset */
	0,                            /* same pos */
	0,                            /* different pos */
	0                             /* width */
};


static const arch_register_req_t sparc_requirements_fp_fp = {
	arch_register_req_type_normal,
	& sparc_reg_classes[CLASS_sparc_fp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0,           /* different pos */
	1            /* width */
};


static const arch_register_req_t sparc_requirements_fp_fp_a_4 = {
	arch_register_req_type_aligned | arch_register_req_type_normal,
	& sparc_reg_classes[CLASS_sparc_fp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0,           /* different pos */
	4            /* width */
};


static const arch_register_req_t sparc_requirements_fp_fp_a_2 = {
	arch_register_req_type_aligned | arch_register_req_type_normal,
	& sparc_reg_classes[CLASS_sparc_fp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0,           /* different pos */
	2            /* width */
};


static const arch_register_req_t sparc_requirements_gp_sp = {
	arch_register_req_type_limited,
	& sparc_reg_classes[CLASS_sparc_gp],
	sparc_limit_gp_sp,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};


static const arch_register_req_t sparc_requirements_gp_frame_pointer = {
	arch_register_req_type_limited,
	& sparc_reg_classes[CLASS_sparc_gp],
	sparc_limit_gp_frame_pointer,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};


static const arch_register_req_t sparc_requirements_gp_sp_I_S = {
	arch_register_req_type_ignore | arch_register_req_type_produces_sp | arch_register_req_type_limited,
	& sparc_reg_classes[CLASS_sparc_gp],
	sparc_limit_gp_sp,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};


static const arch_register_req_t sparc_requirements_fpflags_class_fpflags = {
	arch_register_req_type_limited,
	& sparc_reg_classes[CLASS_sparc_fpflags_class],
	sparc_limit_fpflags_class_fpflags,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};



/**
 * construct SubCCZero node
 */
ir_node *new_bd_sparc_SubCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SubCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SubCCZero node
 */
ir_node *new_bd_sparc_SubCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SubCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sra node
 */
ir_node *new_bd_sparc_Sra_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Sra;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sra node
 */
ir_node *new_bd_sparc_Sra_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Sra;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Ld node
 */
ir_node *new_bd_sparc_Ld_imm(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Ld;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_load_store_attributes(res, ls_mode, entity, offset, is_frame_entity, false);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;
	info->out_infos[1].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Ld node
 */
ir_node *new_bd_sparc_Ld_reg(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *ptr2, ir_node *mem, ir_mode *ls_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Ld;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = ptr2;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_load_store_attributes(res, ls_mode, NULL, 0, false, true);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;
	info->out_infos[1].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fitof node
 */
ir_node *new_bd_sparc_fitof_q(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fitof;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Q;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_4;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fitof node
 */
ir_node *new_bd_sparc_fitof_d(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fitof;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_D;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fitof node
 */
ir_node *new_bd_sparc_fitof_s(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fitof;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fadd node
 */
ir_node *new_bd_sparc_fadd_q(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fadd;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Q;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
		& sparc_requirements_fp_fp_a_4,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_4;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fadd node
 */
ir_node *new_bd_sparc_fadd_d(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fadd;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_D;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
		& sparc_requirements_fp_fp_a_2,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fadd node
 */
ir_node *new_bd_sparc_fadd_s(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fadd;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Start node
 */
ir_node *new_bd_sparc_Start(dbg_info *dbgi, ir_node *block, int n_res)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Start;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t **in_reqs = NULL;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct RestoreZero node
 */
ir_node *new_bd_sparc_RestoreZero(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *frame_pointer)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_RestoreZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_sp,
		& sparc_requirements_gp_frame_pointer,
	};

	/* construct in array */
	in[0] = stack;
	in[1] = frame_pointer;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_sp_I_S;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SetHi node
 */
ir_node *new_bd_sparc_SetHi(dbg_info *dbgi, ir_node *block, ir_entity *entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SetHi;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Xor node
 */
ir_node *new_bd_sparc_Xor_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Xor;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Xor node
 */
ir_node *new_bd_sparc_Xor_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Xor;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Or node
 */
ir_node *new_bd_sparc_Or_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Or;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Or node
 */
ir_node *new_bd_sparc_Or_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Or;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Restore node
 */
ir_node *new_bd_sparc_Restore_imm(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *frame_pointer, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Restore;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_sp,
		& sparc_requirements_gp_frame_pointer,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = stack;
	in[1] = frame_pointer;
	in[2] = left;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_sp_I_S;
	info->out_infos[1].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Restore node
 */
ir_node *new_bd_sparc_Restore_reg(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *frame_pointer, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Restore;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 4;
	ir_node        *in[4];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_sp,
		& sparc_requirements_gp_frame_pointer,
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = stack;
	in[1] = frame_pointer;
	in[2] = left;
	in[3] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_sp_I_S;
	info->out_infos[1].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SubX_t node
 */
ir_node *new_bd_sparc_SubX_t(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *flags_input, ir_mode *mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SubX_t;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 0;
	static const arch_register_req_t **in_reqs = NULL;

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = flags_input;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
	(void)in;(void)irn_flags_;(void)in_reqs;(void)n_res;
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct UMulh node
 */
ir_node *new_bd_sparc_UMulh_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_UMulh;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct UMulh node
 */
ir_node *new_bd_sparc_UMulh_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_UMulh;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Ba node
 */
ir_node *new_bd_sparc_Ba(dbg_info *dbgi, ir_node *block)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Ba;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = mode_X;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= arch_irn_flags_simple_jump;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Cmp node
 */
ir_node *new_bd_sparc_Cmp_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Cmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Cmp node
 */
ir_node *new_bd_sparc_Cmp_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Cmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_d_s(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fftof;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);	init_sparc_fp_conv_attributes(res, src_mode, dest_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_q_s(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fftof;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);	init_sparc_fp_conv_attributes(res, src_mode, dest_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_q_d(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fftof;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_D;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);	init_sparc_fp_conv_attributes(res, src_mode, dest_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_s_q(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fftof;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Q;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);	init_sparc_fp_conv_attributes(res, src_mode, dest_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_s_d(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fftof;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_D;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);	init_sparc_fp_conv_attributes(res, src_mode, dest_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_d_q(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fftof;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Q;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);	init_sparc_fp_conv_attributes(res, src_mode, dest_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_4;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct XNorCCZero node
 */
ir_node *new_bd_sparc_XNorCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_XNorCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct XNorCCZero node
 */
ir_node *new_bd_sparc_XNorCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_XNorCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Call node
 */
ir_node *new_bd_sparc_Call_imm(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, ir_entity *entity, int32_t offset, bool aggregate_return)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Call;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
		sparc_set_attr_imm(res, entity, offset);	if (aggregate_return) arch_add_irn_flags(res, (arch_irn_flags_t)sparc_arch_irn_flag_aggregate_return);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Call node
 */
ir_node *new_bd_sparc_Call_reg(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, bool aggregate_return)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Call;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
		if (aggregate_return) arch_add_irn_flags(res, (arch_irn_flags_t)sparc_arch_irn_flag_aggregate_return);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AddX node
 */
ir_node *new_bd_sparc_AddX_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *carry, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AddX;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_flags_class_flags,
	};

	/* construct in array */
	in[0] = left;
	in[1] = carry;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AddX node
 */
ir_node *new_bd_sparc_AddX_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *carry)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AddX;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
		& sparc_requirements_flags_class_flags,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = carry;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SubSP node
 */
ir_node *new_bd_sparc_SubSP_imm(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *mem, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SubSP;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 3;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_sp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = stack;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_sp_I_S;
	info->out_infos[1].req = &sparc_requirements_gp_gp;
	info->out_infos[2].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SubSP node
 */
ir_node *new_bd_sparc_SubSP_reg(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *size, ir_node *mem)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SubSP;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 3;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_sp,
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = stack;
	in[1] = size;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_sp_I_S;
	info->out_infos[1].req = &sparc_requirements_gp_gp;
	info->out_infos[2].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Add node
 */
ir_node *new_bd_sparc_Add_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Add;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Add node
 */
ir_node *new_bd_sparc_Add_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Add;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SubCC node
 */
ir_node *new_bd_sparc_SubCC_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SubCC;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;
	info->out_infos[1].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SubCC node
 */
ir_node *new_bd_sparc_SubCC_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SubCC;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;
	info->out_infos[1].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Ldf node
 */
ir_node *new_bd_sparc_Ldf_q(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Ldf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_load_store_attributes(res, ls_mode, entity, offset, is_frame_entity, false);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_4;
	info->out_infos[1].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Ldf node
 */
ir_node *new_bd_sparc_Ldf_d(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Ldf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_load_store_attributes(res, ls_mode, entity, offset, is_frame_entity, false);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;
	info->out_infos[1].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Ldf node
 */
ir_node *new_bd_sparc_Ldf_s(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Ldf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_load_store_attributes(res, ls_mode, entity, offset, is_frame_entity, false);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;
	info->out_infos[1].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fdiv node
 */
ir_node *new_bd_sparc_fdiv_q(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fdiv;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
		& sparc_requirements_fp_fp_a_4,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_4;
	info->out_infos[1].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fdiv node
 */
ir_node *new_bd_sparc_fdiv_d(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fdiv;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
		& sparc_requirements_fp_fp_a_2,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;
	info->out_infos[1].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fdiv node
 */
ir_node *new_bd_sparc_fdiv_s(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fdiv;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;
	info->out_infos[1].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AndN node
 */
ir_node *new_bd_sparc_AndN_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AndN;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AndN node
 */
ir_node *new_bd_sparc_AndN_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AndN;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fftoi node
 */
ir_node *new_bd_sparc_fftoi_q(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fftoi;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fftoi node
 */
ir_node *new_bd_sparc_fftoi_d(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fftoi;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fftoi node
 */
ir_node *new_bd_sparc_fftoi_s(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fftoi;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct XorCCZero node
 */
ir_node *new_bd_sparc_XorCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_XorCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct XorCCZero node
 */
ir_node *new_bd_sparc_XorCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_XorCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct St node
 */
ir_node *new_bd_sparc_St_imm(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_St;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_M;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = val;
	in[1] = ptr;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_load_store_attributes(res, ls_mode, entity, offset, is_frame_entity, false);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct St node
 */
ir_node *new_bd_sparc_St_reg(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *ptr, ir_node *ptr2, ir_node *mem, ir_mode *ls_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_St;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 4;
	ir_node        *in[4];
	int             n_res   = 1;
	ir_mode        *mode    = mode_M;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = val;
	in[1] = ptr;
	in[2] = ptr2;
	in[3] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_load_store_attributes(res, ls_mode, NULL, 0, false, true);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct MulCCZero node
 */
ir_node *new_bd_sparc_MulCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_MulCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct MulCCZero node
 */
ir_node *new_bd_sparc_MulCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_MulCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Save node
 */
ir_node *new_bd_sparc_Save_imm(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Save;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_sp,
	};

	/* construct in array */
	in[0] = stack;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_sp_I_S;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Save node
 */
ir_node *new_bd_sparc_Save_reg(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *increment)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Save;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_sp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = stack;
	in[1] = increment;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_sp_I_S;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fbfcc node
 */
ir_node *new_bd_sparc_fbfcc(dbg_info *dbgi, ir_node *block, ir_node *flags, ir_relation relation)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fbfcc;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fpflags_class_fpflags,
	};
	sparc_jmp_cond_attr_t *attr;

	/* construct in array */
	in[0] = flags;

	/* flags */
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements__none;
	info->out_infos[1].req = &sparc_requirements__none;


	attr = (sparc_jmp_cond_attr_t*)get_irn_generic_attr(res);
	(void) attr; /* avoid potential warning */
		init_sparc_jmp_cond_attr(res, relation, false);
	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sub node
 */
ir_node *new_bd_sparc_Sub_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Sub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sub node
 */
ir_node *new_bd_sparc_Sub_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Sub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mul node
 */
ir_node *new_bd_sparc_Mul_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Mul;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mul node
 */
ir_node *new_bd_sparc_Mul_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Mul;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SubCC_t node
 */
ir_node *new_bd_sparc_SubCC_t(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SubCC_t;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t **in_reqs = NULL;

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
	(void)in;(void)irn_flags_;(void)in_reqs;(void)n_res;
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Stf node
 */
ir_node *new_bd_sparc_Stf_q(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Stf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_M;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = val;
	in[1] = ptr;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_load_store_attributes(res, ls_mode, entity, offset, is_frame_entity, false);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Stf node
 */
ir_node *new_bd_sparc_Stf_d(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Stf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_M;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = val;
	in[1] = ptr;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_load_store_attributes(res, ls_mode, entity, offset, is_frame_entity, false);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Stf node
 */
ir_node *new_bd_sparc_Stf_s(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Stf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_M;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
		& sparc_requirements_gp_gp,
		& sparc_requirements__none,
	};

	/* construct in array */
	in[0] = val;
	in[1] = ptr;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_load_store_attributes(res, ls_mode, entity, offset, is_frame_entity, false);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SDiv node
 */
ir_node *new_bd_sparc_SDiv_imm(dbg_info *dbgi, ir_node *block, ir_node *dividend_high, ir_node *dividend_low, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SDiv;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = dividend_high;
	in[1] = dividend_low;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SDiv node
 */
ir_node *new_bd_sparc_SDiv_reg(dbg_info *dbgi, ir_node *block, ir_node *dividend_high, ir_node *dividend_low, ir_node *divisor)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SDiv;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = dividend_high;
	in[1] = dividend_low;
	in[2] = divisor;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AddX_t node
 */
ir_node *new_bd_sparc_AddX_t(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *flags_input, ir_mode *mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AddX_t;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 0;
	static const arch_register_req_t **in_reqs = NULL;

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = flags_input;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
	(void)in;(void)irn_flags_;(void)in_reqs;(void)n_res;
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fabs node
 */
ir_node *new_bd_sparc_fabs_q(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fabs;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Q;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
	};

	/* construct in array */
	in[0] = val;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_4;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fabs node
 */
ir_node *new_bd_sparc_fabs_d(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fabs;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_D;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
	};

	/* construct in array */
	in[0] = val;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fabs node
 */
ir_node *new_bd_sparc_fabs_s(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fabs;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = val;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AddCC node
 */
ir_node *new_bd_sparc_AddCC_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AddCC;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;
	info->out_infos[1].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AddCC node
 */
ir_node *new_bd_sparc_AddCC_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AddCC;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;
	info->out_infos[1].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Bicc node
 */
ir_node *new_bd_sparc_Bicc(dbg_info *dbgi, ir_node *block, ir_node *flags, ir_relation relation, bool is_unsigned)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Bicc;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_flags_class_flags,
	};
	sparc_jmp_cond_attr_t *attr;

	/* construct in array */
	in[0] = flags;

	/* flags */
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements__none;
	info->out_infos[1].req = &sparc_requirements__none;


	attr = (sparc_jmp_cond_attr_t*)get_irn_generic_attr(res);
	(void) attr; /* avoid potential warning */
		init_sparc_jmp_cond_attr(res, relation, is_unsigned);
	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct OrN node
 */
ir_node *new_bd_sparc_OrN_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_OrN;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct OrN node
 */
ir_node *new_bd_sparc_OrN_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_OrN;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SubX node
 */
ir_node *new_bd_sparc_SubX_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *carry, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SubX;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_flags_class_flags,
	};

	/* construct in array */
	in[0] = left;
	in[1] = carry;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SubX node
 */
ir_node *new_bd_sparc_SubX_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *carry)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SubX;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
		& sparc_requirements_flags_class_flags,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = carry;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fcmp node
 */
ir_node *new_bd_sparc_fcmp_q(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fcmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
		& sparc_requirements_fp_fp_a_4,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fpflags_class_fpflags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fcmp node
 */
ir_node *new_bd_sparc_fcmp_d(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fcmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
		& sparc_requirements_fp_fp_a_2,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fpflags_class_fpflags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fcmp node
 */
ir_node *new_bd_sparc_fcmp_s(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fcmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fpflags_class_fpflags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct OrCCZero node
 */
ir_node *new_bd_sparc_OrCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_OrCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct OrCCZero node
 */
ir_node *new_bd_sparc_OrCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_OrCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AddSP node
 */
ir_node *new_bd_sparc_AddSP(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *size)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AddSP;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_sp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = stack;
	in[1] = size;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_sp_I_S;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SMulh node
 */
ir_node *new_bd_sparc_SMulh_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SMulh;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SMulh node
 */
ir_node *new_bd_sparc_SMulh_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SMulh;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AddCC_t node
 */
ir_node *new_bd_sparc_AddCC_t(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AddCC_t;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t **in_reqs = NULL;

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
	(void)in;(void)irn_flags_;(void)in_reqs;(void)n_res;
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Return node
 */
ir_node *new_bd_sparc_Return_imm(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], ir_entity *entity, int32_t offset)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Return;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             n_res   = 1;
	ir_mode        *mode    = mode_X;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
		sparc_set_attr_imm(res, entity, offset);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Return node
 */
ir_node *new_bd_sparc_Return_reg(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[])
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Return;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             n_res   = 1;
	ir_mode        *mode    = mode_X;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct XNor node
 */
ir_node *new_bd_sparc_XNor_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_XNor;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct XNor node
 */
ir_node *new_bd_sparc_XNor_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_XNor;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AndNCCZero node
 */
ir_node *new_bd_sparc_AndNCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AndNCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AndNCCZero node
 */
ir_node *new_bd_sparc_AndNCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AndNCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AndCCZero node
 */
ir_node *new_bd_sparc_AndCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AndCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AndCCZero node
 */
ir_node *new_bd_sparc_AndCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AndCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct FrameAddr node
 */
ir_node *new_bd_sparc_FrameAddr(dbg_info *dbgi, ir_node *block, ir_node *base, ir_entity *entity, int32_t offset)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_FrameAddr;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = base;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, entity, offset);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct OrNCCZero node
 */
ir_node *new_bd_sparc_OrNCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_OrNCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct OrNCCZero node
 */
ir_node *new_bd_sparc_OrNCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_OrNCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct And node
 */
ir_node *new_bd_sparc_And_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_And;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct And node
 */
ir_node *new_bd_sparc_And_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_And;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fmul node
 */
ir_node *new_bd_sparc_fmul_q(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fmul;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Q;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
		& sparc_requirements_fp_fp_a_4,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_4;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fmul node
 */
ir_node *new_bd_sparc_fmul_d(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fmul;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_D;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
		& sparc_requirements_fp_fp_a_2,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fmul node
 */
ir_node *new_bd_sparc_fmul_s(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fmul;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AddCCZero node
 */
ir_node *new_bd_sparc_AddCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AddCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct AddCCZero node
 */
ir_node *new_bd_sparc_AddCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_AddCCZero;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_flags_class_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct UDiv node
 */
ir_node *new_bd_sparc_UDiv_imm(dbg_info *dbgi, ir_node *block, ir_node *dividend_high, ir_node *dividend_low, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_UDiv;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = dividend_high;
	in[1] = dividend_low;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct UDiv node
 */
ir_node *new_bd_sparc_UDiv_reg(dbg_info *dbgi, ir_node *block, ir_node *dividend_high, ir_node *dividend_low, ir_node *divisor)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_UDiv;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = dividend_high;
	in[1] = dividend_low;
	in[2] = divisor;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sll node
 */
ir_node *new_bd_sparc_Sll_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Sll;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sll node
 */
ir_node *new_bd_sparc_Sll_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Sll;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SwitchJmp node
 */
ir_node *new_bd_sparc_SwitchJmp(dbg_info *dbgi, ir_node *block, ir_node *op0, int n_res, const ir_switch_table *table, ir_entity *jump_table)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_SwitchJmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= (arch_irn_flags_t)sparc_arch_irn_flag_has_delay_slot;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_switch_jmp_attributes(res, table, jump_table);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Srl node
 */
ir_node *new_bd_sparc_Srl_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Srl;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	sparc_set_attr_imm(res, immediate_entity, immediate_value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Srl node
 */
ir_node *new_bd_sparc_Srl_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_Srl;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_gp_gp,
		& sparc_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fneg node
 */
ir_node *new_bd_sparc_fneg_q(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fneg;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Q;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
	};

	/* construct in array */
	in[0] = val;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_4;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fneg node
 */
ir_node *new_bd_sparc_fneg_d(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fneg;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_D;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
	};

	/* construct in array */
	in[0] = val;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fneg node
 */
ir_node *new_bd_sparc_fneg_s(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fneg;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = val;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fsub node
 */
ir_node *new_bd_sparc_fsub_q(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fsub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Q;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_4,
		& sparc_requirements_fp_fp_a_4,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_4;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fsub node
 */
ir_node *new_bd_sparc_fsub_d(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fsub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_D;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp_a_2,
		& sparc_requirements_fp_fp_a_2,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp_a_2;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fsub node
 */
ir_node *new_bd_sparc_fsub_s(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_sparc_fsub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& sparc_requirements_fp_fp,
		& sparc_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_sparc_attributes(res, irn_flags_, in_reqs, n_res);
	init_sparc_fp_attributes(res, fp_mode);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &sparc_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}



/**
 * Creates the sparc specific Firm machine operations
 * needed for the assembler irgs.
 */
void sparc_create_opcodes(const arch_irn_ops_t *be_ops)
{
	ir_op *op;
	int    cur_opcode = get_next_ir_opcodes(iro_sparc_last);

	sparc_opcode_start = cur_opcode;
	op = new_ir_op(cur_opcode + iro_sparc_SubCCZero, "sparc_SubCCZero", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_SubCCZero = op;
	op = new_ir_op(cur_opcode + iro_sparc_Sra, "sparc_Sra", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Sra = op;
	op = new_ir_op(cur_opcode + iro_sparc_Ld, "sparc_Ld", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_binary, 0, sizeof(sparc_load_store_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_load_store;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Ld = op;
	op = new_ir_op(cur_opcode + iro_sparc_fitof, "sparc_fitof", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_fp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_fp;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fitof = op;
	op = new_ir_op(cur_opcode + iro_sparc_fadd, "sparc_fadd", op_pin_state_floats, irop_flag_commutative, oparity_binary, 0, sizeof(sparc_fp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_fp;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fadd = op;
	op = new_ir_op(cur_opcode + iro_sparc_Start, "sparc_Start", op_pin_state_pinned, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Start = op;
	op = new_ir_op(cur_opcode + iro_sparc_RestoreZero, "sparc_RestoreZero", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_RestoreZero = op;
	op = new_ir_op(cur_opcode + iro_sparc_SetHi, "sparc_SetHi", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_SetHi = op;
	op = new_ir_op(cur_opcode + iro_sparc_Xor, "sparc_Xor", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Xor = op;
	op = new_ir_op(cur_opcode + iro_sparc_Or, "sparc_Or", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Or = op;
	op = new_ir_op(cur_opcode + iro_sparc_Restore, "sparc_Restore", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Restore = op;
	op = new_ir_op(cur_opcode + iro_sparc_SubX_t, "sparc_SubX_t", op_pin_state_floats, irop_flag_none, oparity_trinary, 0, 0);
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = NULL;
	op->ops.node_cmp_attr = NULL;
	set_op_tag(op, sparc_op_tag);
	op_sparc_SubX_t = op;
	op = new_ir_op(cur_opcode + iro_sparc_UMulh, "sparc_UMulh", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_UMulh = op;
	op = new_ir_op(cur_opcode + iro_sparc_Ba, "sparc_Ba", op_pin_state_pinned, irop_flag_cfopcode, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Ba = op;
	op = new_ir_op(cur_opcode + iro_sparc_Cmp, "sparc_Cmp", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Cmp = op;
	op = new_ir_op(cur_opcode + iro_sparc_fftof, "sparc_fftof", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_fp_conv_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_fp_conv;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fftof = op;
	op = new_ir_op(cur_opcode + iro_sparc_XNorCCZero, "sparc_XNorCCZero", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_XNorCCZero = op;
	op = new_ir_op(cur_opcode + iro_sparc_Call, "sparc_Call", op_pin_state_exc_pinned, irop_flag_none, oparity_variable, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Call = op;
	op = new_ir_op(cur_opcode + iro_sparc_AddX, "sparc_AddX", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_AddX = op;
	op = new_ir_op(cur_opcode + iro_sparc_SubSP, "sparc_SubSP", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_SubSP = op;
	op = new_ir_op(cur_opcode + iro_sparc_Add, "sparc_Add", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Add = op;
	op = new_ir_op(cur_opcode + iro_sparc_SubCC, "sparc_SubCC", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_SubCC = op;
	op = new_ir_op(cur_opcode + iro_sparc_Ldf, "sparc_Ldf", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_binary, 0, sizeof(sparc_load_store_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_load_store;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Ldf = op;
	op = new_ir_op(cur_opcode + iro_sparc_fdiv, "sparc_fdiv", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(sparc_fp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_fp;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fdiv = op;
	op = new_ir_op(cur_opcode + iro_sparc_AndN, "sparc_AndN", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_AndN = op;
	op = new_ir_op(cur_opcode + iro_sparc_fftoi, "sparc_fftoi", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_fp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_fp;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fftoi = op;
	op = new_ir_op(cur_opcode + iro_sparc_XorCCZero, "sparc_XorCCZero", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_XorCCZero = op;
	op = new_ir_op(cur_opcode + iro_sparc_St, "sparc_St", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_trinary, 0, sizeof(sparc_load_store_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_load_store;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_St = op;
	op = new_ir_op(cur_opcode + iro_sparc_MulCCZero, "sparc_MulCCZero", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_MulCCZero = op;
	op = new_ir_op(cur_opcode + iro_sparc_Save, "sparc_Save", op_pin_state_floats, irop_flag_none, oparity_unary, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Save = op;
	op = new_ir_op(cur_opcode + iro_sparc_fbfcc, "sparc_fbfcc", op_pin_state_pinned, irop_flag_cfopcode|irop_flag_forking, oparity_unary, 0, sizeof(sparc_jmp_cond_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_jmp_cond;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fbfcc = op;
	op = new_ir_op(cur_opcode + iro_sparc_Sub, "sparc_Sub", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Sub = op;
	op = new_ir_op(cur_opcode + iro_sparc_Mul, "sparc_Mul", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Mul = op;
	op = new_ir_op(cur_opcode + iro_sparc_SubCC_t, "sparc_SubCC_t", op_pin_state_floats, irop_flag_none, oparity_binary, 0, 0);
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = NULL;
	op->ops.node_cmp_attr = NULL;
	set_op_tag(op, sparc_op_tag);
	op_sparc_SubCC_t = op;
	op = new_ir_op(cur_opcode + iro_sparc_Stf, "sparc_Stf", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_trinary, 0, sizeof(sparc_load_store_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_load_store;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Stf = op;
	op = new_ir_op(cur_opcode + iro_sparc_SDiv, "sparc_SDiv", op_pin_state_exc_pinned, irop_flag_none, oparity_trinary, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_SDiv = op;
	op = new_ir_op(cur_opcode + iro_sparc_AddX_t, "sparc_AddX_t", op_pin_state_floats, irop_flag_none, oparity_trinary, 0, 0);
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = NULL;
	op->ops.node_cmp_attr = NULL;
	set_op_tag(op, sparc_op_tag);
	op_sparc_AddX_t = op;
	op = new_ir_op(cur_opcode + iro_sparc_fabs, "sparc_fabs", op_pin_state_floats, irop_flag_none, oparity_unary, 0, sizeof(sparc_fp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_fp;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fabs = op;
	op = new_ir_op(cur_opcode + iro_sparc_AddCC, "sparc_AddCC", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_AddCC = op;
	op = new_ir_op(cur_opcode + iro_sparc_Bicc, "sparc_Bicc", op_pin_state_pinned, irop_flag_cfopcode|irop_flag_forking, oparity_unary, 0, sizeof(sparc_jmp_cond_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_jmp_cond;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Bicc = op;
	op = new_ir_op(cur_opcode + iro_sparc_OrN, "sparc_OrN", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_OrN = op;
	op = new_ir_op(cur_opcode + iro_sparc_SubX, "sparc_SubX", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_SubX = op;
	op = new_ir_op(cur_opcode + iro_sparc_fcmp, "sparc_fcmp", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_fp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_fp;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fcmp = op;
	op = new_ir_op(cur_opcode + iro_sparc_OrCCZero, "sparc_OrCCZero", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_OrCCZero = op;
	op = new_ir_op(cur_opcode + iro_sparc_AddSP, "sparc_AddSP", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_AddSP = op;
	op = new_ir_op(cur_opcode + iro_sparc_SMulh, "sparc_SMulh", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_SMulh = op;
	op = new_ir_op(cur_opcode + iro_sparc_AddCC_t, "sparc_AddCC_t", op_pin_state_floats, irop_flag_none, oparity_binary, 0, 0);
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = NULL;
	op->ops.node_cmp_attr = NULL;
	set_op_tag(op, sparc_op_tag);
	op_sparc_AddCC_t = op;
	op = new_ir_op(cur_opcode + iro_sparc_Return, "sparc_Return", op_pin_state_pinned, irop_flag_cfopcode, oparity_variable, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Return = op;
	op = new_ir_op(cur_opcode + iro_sparc_XNor, "sparc_XNor", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_XNor = op;
	op = new_ir_op(cur_opcode + iro_sparc_AndNCCZero, "sparc_AndNCCZero", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_AndNCCZero = op;
	op = new_ir_op(cur_opcode + iro_sparc_AndCCZero, "sparc_AndCCZero", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_AndCCZero = op;
	op = new_ir_op(cur_opcode + iro_sparc_FrameAddr, "sparc_FrameAddr", op_pin_state_floats, irop_flag_constlike, oparity_unary, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_FrameAddr = op;
	op = new_ir_op(cur_opcode + iro_sparc_OrNCCZero, "sparc_OrNCCZero", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_OrNCCZero = op;
	op = new_ir_op(cur_opcode + iro_sparc_And, "sparc_And", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_And = op;
	op = new_ir_op(cur_opcode + iro_sparc_fmul, "sparc_fmul", op_pin_state_floats, irop_flag_commutative, oparity_binary, 0, sizeof(sparc_fp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_fp;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fmul = op;
	op = new_ir_op(cur_opcode + iro_sparc_AddCCZero, "sparc_AddCCZero", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_AddCCZero = op;
	op = new_ir_op(cur_opcode + iro_sparc_UDiv, "sparc_UDiv", op_pin_state_exc_pinned, irop_flag_none, oparity_trinary, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_UDiv = op;
	op = new_ir_op(cur_opcode + iro_sparc_Sll, "sparc_Sll", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Sll = op;
	op = new_ir_op(cur_opcode + iro_sparc_SwitchJmp, "sparc_SwitchJmp", op_pin_state_pinned, irop_flag_cfopcode|irop_flag_forking, oparity_unary, 0, sizeof(sparc_switch_jmp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_SwitchJmp = op;
	op = new_ir_op(cur_opcode + iro_sparc_Srl, "sparc_Srl", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(sparc_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_Srl = op;
	op = new_ir_op(cur_opcode + iro_sparc_fneg, "sparc_fneg", op_pin_state_floats, irop_flag_none, oparity_unary, 0, sizeof(sparc_fp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_fp;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fneg = op;
	op = new_ir_op(cur_opcode + iro_sparc_fsub, "sparc_fsub", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(sparc_fp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = sparc_dump_node;
	op->ops.node_cmp_attr = cmp_attr_sparc_fp;
	op->ops.copy_attr     = sparc_copy_attr;
	set_op_tag(op, sparc_op_tag);
	op_sparc_fsub = op;

	sparc_opcode_end = cur_opcode + iro_sparc_last;
}

void sparc_free_opcodes(void)
{
	free_ir_op(op_sparc_SubCCZero); op_sparc_SubCCZero = NULL;
	free_ir_op(op_sparc_Sra); op_sparc_Sra = NULL;
	free_ir_op(op_sparc_Ld); op_sparc_Ld = NULL;
	free_ir_op(op_sparc_fitof); op_sparc_fitof = NULL;
	free_ir_op(op_sparc_fadd); op_sparc_fadd = NULL;
	free_ir_op(op_sparc_Start); op_sparc_Start = NULL;
	free_ir_op(op_sparc_RestoreZero); op_sparc_RestoreZero = NULL;
	free_ir_op(op_sparc_SetHi); op_sparc_SetHi = NULL;
	free_ir_op(op_sparc_Xor); op_sparc_Xor = NULL;
	free_ir_op(op_sparc_Or); op_sparc_Or = NULL;
	free_ir_op(op_sparc_Restore); op_sparc_Restore = NULL;
	free_ir_op(op_sparc_SubX_t); op_sparc_SubX_t = NULL;
	free_ir_op(op_sparc_UMulh); op_sparc_UMulh = NULL;
	free_ir_op(op_sparc_Ba); op_sparc_Ba = NULL;
	free_ir_op(op_sparc_Cmp); op_sparc_Cmp = NULL;
	free_ir_op(op_sparc_fftof); op_sparc_fftof = NULL;
	free_ir_op(op_sparc_XNorCCZero); op_sparc_XNorCCZero = NULL;
	free_ir_op(op_sparc_Call); op_sparc_Call = NULL;
	free_ir_op(op_sparc_AddX); op_sparc_AddX = NULL;
	free_ir_op(op_sparc_SubSP); op_sparc_SubSP = NULL;
	free_ir_op(op_sparc_Add); op_sparc_Add = NULL;
	free_ir_op(op_sparc_SubCC); op_sparc_SubCC = NULL;
	free_ir_op(op_sparc_Ldf); op_sparc_Ldf = NULL;
	free_ir_op(op_sparc_fdiv); op_sparc_fdiv = NULL;
	free_ir_op(op_sparc_AndN); op_sparc_AndN = NULL;
	free_ir_op(op_sparc_fftoi); op_sparc_fftoi = NULL;
	free_ir_op(op_sparc_XorCCZero); op_sparc_XorCCZero = NULL;
	free_ir_op(op_sparc_St); op_sparc_St = NULL;
	free_ir_op(op_sparc_MulCCZero); op_sparc_MulCCZero = NULL;
	free_ir_op(op_sparc_Save); op_sparc_Save = NULL;
	free_ir_op(op_sparc_fbfcc); op_sparc_fbfcc = NULL;
	free_ir_op(op_sparc_Sub); op_sparc_Sub = NULL;
	free_ir_op(op_sparc_Mul); op_sparc_Mul = NULL;
	free_ir_op(op_sparc_SubCC_t); op_sparc_SubCC_t = NULL;
	free_ir_op(op_sparc_Stf); op_sparc_Stf = NULL;
	free_ir_op(op_sparc_SDiv); op_sparc_SDiv = NULL;
	free_ir_op(op_sparc_AddX_t); op_sparc_AddX_t = NULL;
	free_ir_op(op_sparc_fabs); op_sparc_fabs = NULL;
	free_ir_op(op_sparc_AddCC); op_sparc_AddCC = NULL;
	free_ir_op(op_sparc_Bicc); op_sparc_Bicc = NULL;
	free_ir_op(op_sparc_OrN); op_sparc_OrN = NULL;
	free_ir_op(op_sparc_SubX); op_sparc_SubX = NULL;
	free_ir_op(op_sparc_fcmp); op_sparc_fcmp = NULL;
	free_ir_op(op_sparc_OrCCZero); op_sparc_OrCCZero = NULL;
	free_ir_op(op_sparc_AddSP); op_sparc_AddSP = NULL;
	free_ir_op(op_sparc_SMulh); op_sparc_SMulh = NULL;
	free_ir_op(op_sparc_AddCC_t); op_sparc_AddCC_t = NULL;
	free_ir_op(op_sparc_Return); op_sparc_Return = NULL;
	free_ir_op(op_sparc_XNor); op_sparc_XNor = NULL;
	free_ir_op(op_sparc_AndNCCZero); op_sparc_AndNCCZero = NULL;
	free_ir_op(op_sparc_AndCCZero); op_sparc_AndCCZero = NULL;
	free_ir_op(op_sparc_FrameAddr); op_sparc_FrameAddr = NULL;
	free_ir_op(op_sparc_OrNCCZero); op_sparc_OrNCCZero = NULL;
	free_ir_op(op_sparc_And); op_sparc_And = NULL;
	free_ir_op(op_sparc_fmul); op_sparc_fmul = NULL;
	free_ir_op(op_sparc_AddCCZero); op_sparc_AddCCZero = NULL;
	free_ir_op(op_sparc_UDiv); op_sparc_UDiv = NULL;
	free_ir_op(op_sparc_Sll); op_sparc_Sll = NULL;
	free_ir_op(op_sparc_SwitchJmp); op_sparc_SwitchJmp = NULL;
	free_ir_op(op_sparc_Srl); op_sparc_Srl = NULL;
	free_ir_op(op_sparc_fneg); op_sparc_fneg = NULL;
	free_ir_op(op_sparc_fsub); op_sparc_fsub = NULL;
}
