%define _prefix /usr
%define _docdir %{_datadir}/doc

Name: libframe
Version: 8.20
Release: 1.lscsoft
Summary: LIGO/VIRGO frame library
License: ?
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: http://lappweb.in2p3.fr/virgo/FrameL
Packager: Xavier Amador (xavier.amador@gravity.phys.uwm.edu)
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Obsoletes: frame
Prefix: %{_prefix}
%description
A Common Data Frame Format for Interferometric Gravitational Wave Detector
has been developed by VIRGO and LIGO.  The Frame Library is a software
dedicated to the frame manipulation including file input/output.

This package contains the shared-object library needed to run libframe
applications.


%package devel
Summary: Files and documentation needed for compiling libframe programs
Group: LAL
Requires: %{name} = %{version}
%description devel
A Common Data Frame Format for Interferometric Gravitational Wave Detector
has been developed by VIRGO and LIGO.  The Frame Library is a software
dedicated to the frame manipulation including file input/output.

This package contains the files needed for building libframe programs, as
well as the documentation for the library.


%package utils
Summary: Frame file manipulation utilities
Group: LAL
Requires: %{name} = %{version}
%description utils
A Common Data Frame Format for Interferometric Gravitational Wave Detector
has been developed by VIRGO and LIGO.  The Frame Library is a software
dedicated to the frame manipulation including file input/output.

This package contains some utilities for manipulating frame files.


%package matlab
Summary: Matlab bindings for libframe
Group: LAL
Requires: %{name} = %{version}
%description matlab
A Common Data Frame Format for Interferometric Gravitational Wave Detector
has been developed by VIRGO and LIGO.  The Frame Library is a software
dedicated to the frame manipulation including file input/output.

This package contains Matlab bindings for manipulating frame files from
within Matlab.



%prep
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}
%setup -q


%build
%configure
%{__make}


%install
%{__make} install DESTDIR=%{buildroot} docdir=%{_docdir}/%{name}-devel-%{version}


%post
ldconfig


%postun
ldconfig


%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}


%files
%defattr(-,root,root)
%{_libdir}/*.so.*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*
%{_includedir}/*
%{_docdir}/*

%files utils
%defattr(-,root,root)
%{_bindir}/*

%files matlab
%defattr(-,root,root)
%{_datadir}/libframe/src/matlab/*
