/* DbField.c generated by valac 0.40.8.18-c87af, the Vala compiler
 * generated from DbField.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgda/libgda.h>


#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())
#define __vala_GdaNumeric_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdaNumeric_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gboolean (*equal) (GdaDataDbField* self, GdaDataDbField* field);
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};



GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GdaDataDbFieldAttribute* gda_data_db_field_attribute_items (int* result_length1);
gchar* gda_data_db_field_attribute_to_string (GdaDataDbFieldAttribute self);
gboolean gda_data_db_field_equal (GdaDataDbField* self,
                                  GdaDataDbField* field);
static gboolean gda_data_db_field_real_equal (GdaDataDbField* self,
                                       GdaDataDbField* field);
const gchar* gda_data_db_field_get_name (GdaDataDbField* self);
const gchar* gda_data_db_field_get_column_name (GdaDataDbField* self);
GdaDataDbFieldAttribute gda_data_db_field_get_attributes (GdaDataDbField* self);
static gboolean _vala_gda_data_db_field_attribute_array_contains (GdaDataDbFieldAttribute * stack,
                                                           int stack_length,
                                                           GdaDataDbFieldAttribute needle);
GValue* gda_data_db_field_value_from_string (const gchar* as_string,
                                             GType type);
static void _vala_GdaNumeric_free (GdaNumeric* self);
gchar* gda_data_db_field_to_string (GdaDataDbField* self);
static gchar* gda_data_db_field_real_to_string (GdaDataDbField* self);
GValue* gda_data_db_field_get_value (GdaDataDbField* self);
void gda_data_db_field_set_value (GdaDataDbField* self,
                                  GValue* value);
void gda_data_db_field_set_name (GdaDataDbField* self,
                                 const gchar* value);


GdaDataDbFieldAttribute*
gda_data_db_field_attribute_items (int* result_length1)
{
	GdaDataDbFieldAttribute* result = NULL;
	GdaDataDbFieldAttribute* _tmp0_;
	GdaDataDbFieldAttribute* _tmp1_;
	gint _tmp1__length1;
	_tmp0_ = g_new0 (GdaDataDbFieldAttribute, 11);
	_tmp0_[0] = GDA_DATA_DB_FIELD_ATTRIBUTE_NONE;
	_tmp0_[1] = GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL;
	_tmp0_[2] = GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL;
	_tmp0_[3] = GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT;
	_tmp0_[4] = GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT;
	_tmp0_[5] = GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED;
	_tmp0_[6] = GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN;
	_tmp0_[7] = GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID;
	_tmp0_[8] = GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG;
	_tmp0_[9] = GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF;
	_tmp0_[10] = GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 11;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


gchar*
gda_data_db_field_attribute_to_string (GdaDataDbFieldAttribute self)
{
	gchar* result = NULL;
	switch (self) {
		case GDA_DATA_DB_FIELD_ATTRIBUTE_NONE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("None");
			result = _tmp0_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("IsNull");
			result = _tmp1_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("CanBeNull");
			result = _tmp2_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("IsDefault");
			result = _tmp3_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("CanBeDefault");
			result = _tmp4_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("IsUnchanged");
			result = _tmp5_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("ActionsShown");
			result = _tmp6_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("DataNonValid");
			result = _tmp7_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("HasValueOrig");
			result = _tmp8_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("NoModif");
			result = _tmp9_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("CanBeNull");
			result = _tmp10_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType
gda_data_db_field_attribute_get_type (void)
{
	static volatile gsize gda_data_db_field_attribute_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_field_attribute_type_id__volatile)) {
		static const GFlagsValue values[] = {{GDA_DATA_DB_FIELD_ATTRIBUTE_NONE, "GDA_DATA_DB_FIELD_ATTRIBUTE_NONE", "none"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL, "GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL", "is-null"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL, "GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL", "can-be-null"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT, "GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT", "is-default"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT, "GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT", "can-be-default"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED, "GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED", "is-unchanged"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN, "GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN", "actions-shown"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID, "GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID", "data-non-valid"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG, "GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG", "has-value-orig"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF, "GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF", "no-modif"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED, "GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED", "unused"}, {0, NULL, NULL}};
		GType gda_data_db_field_attribute_type_id;
		gda_data_db_field_attribute_type_id = g_flags_register_static ("GdaDataDbFieldAttribute", values);
		g_once_init_leave (&gda_data_db_field_attribute_type_id__volatile, gda_data_db_field_attribute_type_id);
	}
	return gda_data_db_field_attribute_type_id__volatile;
}


static gboolean
_vala_gda_data_db_field_attribute_array_contains (GdaDataDbFieldAttribute * stack,
                                                  int stack_length,
                                                  GdaDataDbFieldAttribute needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean
gda_data_db_field_real_equal (GdaDataDbField* self,
                              GdaDataDbField* field)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GdaDataDbFieldAttribute* attributes = NULL;
	gint _tmp8_;
	GdaDataDbFieldAttribute* _tmp9_;
	gint attributes_length1;
	gint _attributes_size_;
	GdaDataDbFieldAttribute* _tmp10_;
	gint _tmp10__length1;
	g_return_val_if_fail (field != NULL, FALSE);
	_tmp0_ = gda_data_db_field_get_name (field);
	_tmp1_ = _tmp0_;
	_tmp2_ = gda_data_db_field_get_name (self);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp1_, _tmp3_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp4_ = gda_data_db_field_get_column_name (field);
	_tmp5_ = _tmp4_;
	_tmp6_ = gda_data_db_field_get_column_name (self);
	_tmp7_ = _tmp6_;
	if (g_strcmp0 (_tmp5_, _tmp7_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp9_ = gda_data_db_field_attribute_items (&_tmp8_);
	attributes = _tmp9_;
	attributes_length1 = _tmp8_;
	_attributes_size_ = attributes_length1;
	_tmp10_ = attributes;
	_tmp10__length1 = attributes_length1;
	{
		GdaDataDbFieldAttribute* att_collection = NULL;
		gint att_collection_length1 = 0;
		gint _att_collection_size_ = 0;
		gint att_it = 0;
		att_collection = _tmp10_;
		att_collection_length1 = _tmp10__length1;
		for (att_it = 0; att_it < _tmp10__length1; att_it = att_it + 1) {
			GdaDataDbFieldAttribute att = 0;
			att = att_collection[att_it];
			{
				gboolean _tmp11_ = FALSE;
				GdaDataDbFieldAttribute _tmp12_;
				GdaDataDbFieldAttribute _tmp13_;
				GdaDataDbFieldAttribute _tmp14_;
				_tmp12_ = att;
				_tmp13_ = gda_data_db_field_get_attributes (field);
				_tmp14_ = _tmp13_;
				if ((_tmp14_ & _tmp12_) == _tmp12_) {
					GdaDataDbFieldAttribute _tmp15_;
					GdaDataDbFieldAttribute* _tmp16_;
					gint _tmp16__length1;
					_tmp15_ = att;
					_tmp16_ = attributes;
					_tmp16__length1 = attributes_length1;
					_tmp11_ = !_vala_gda_data_db_field_attribute_array_contains (_tmp16_, _tmp16__length1, _tmp15_);
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					result = FALSE;
					attributes = (g_free (attributes), NULL);
					return result;
				}
			}
		}
	}
	result = TRUE;
	attributes = (g_free (attributes), NULL);
	return result;
}


gboolean
gda_data_db_field_equal (GdaDataDbField* self,
                         GdaDataDbField* field)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->equal (self, field);
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gint64
int64_parse (const gchar* str)
{
	gint64 result = 0LL;
	gint64 _tmp0_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = g_ascii_strtoll (str, NULL, (guint) 0);
	result = _tmp0_;
	return result;
}


static guint64
uint64_parse (const gchar* str)
{
	guint64 result = 0ULL;
	guint64 _tmp0_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = g_ascii_strtoull (str, NULL, (guint) 0);
	result = _tmp0_;
	return result;
}


static glong
long_parse (const gchar* str)
{
	glong result = 0L;
	glong _tmp0_;
	g_return_val_if_fail (str != NULL, 0L);
	_tmp0_ = strtol (str, NULL, (guint) 0);
	result = _tmp0_;
	return result;
}


static gdouble
double_parse (const gchar* str)
{
	gdouble result = 0.0;
	gdouble _tmp0_;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = g_ascii_strtod (str, NULL);
	result = _tmp0_;
	return result;
}


static void
_vala_GdaNumeric_free (GdaNumeric* self)
{
	g_boxed_free (gda_numeric_get_type (), self);
}


GValue*
gda_data_db_field_value_from_string (const gchar* as_string,
                                     GType type)
{
	GValue* result = NULL;
	GValue* _tmp17_ = NULL;
	g_return_val_if_fail (as_string != NULL, NULL);
	if (type == G_TYPE_BOOLEAN) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gint i = 0;
		gboolean _tmp6_ = FALSE;
		gint _tmp7_;
		GValue* _tmp8_ = NULL;
		if (string_get (as_string, (glong) 0) == 't') {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = string_get (as_string, (glong) 0) == 'T';
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = g_strcmp0 (as_string, "true") == 0;
		}
		if (_tmp0_) {
			GValue* _tmp2_ = NULL;
			_tmp2_ = g_new0 (GValue, 1);
			g_value_init (_tmp2_, G_TYPE_BOOLEAN);
			g_value_set_boolean (_tmp2_, TRUE);
			result = _tmp2_;
			return result;
		}
		if (string_get (as_string, (glong) 0) == 'f') {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = string_get (as_string, (glong) 0) == 'F';
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = g_strcmp0 (as_string, "false") == 0;
		}
		if (_tmp3_) {
			GValue* _tmp5_ = NULL;
			_tmp5_ = g_new0 (GValue, 1);
			g_value_init (_tmp5_, G_TYPE_BOOLEAN);
			g_value_set_boolean (_tmp5_, FALSE);
			result = _tmp5_;
			return result;
		}
		i = atoi (as_string);
		_tmp7_ = i;
		if (_tmp7_ == 0) {
			_tmp6_ = FALSE;
		} else {
			_tmp6_ = TRUE;
		}
		_tmp8_ = g_new0 (GValue, 1);
		g_value_init (_tmp8_, G_TYPE_BOOLEAN);
		g_value_set_boolean (_tmp8_, _tmp6_);
		result = _tmp8_;
		return result;
	}
	if (type == G_TYPE_INT64) {
		GValue* _tmp9_ = NULL;
		_tmp9_ = g_new0 (GValue, 1);
		g_value_init (_tmp9_, G_TYPE_INT64);
		g_value_set_int64 (_tmp9_, int64_parse (as_string));
		result = _tmp9_;
		return result;
	}
	if (type == G_TYPE_UINT64) {
		GValue* _tmp10_ = NULL;
		_tmp10_ = g_new0 (GValue, 1);
		g_value_init (_tmp10_, G_TYPE_UINT64);
		g_value_set_uint64 (_tmp10_, uint64_parse (as_string));
		result = _tmp10_;
		return result;
	}
	if (type == G_TYPE_INT) {
		GValue* _tmp11_ = NULL;
		_tmp11_ = g_new0 (GValue, 1);
		g_value_init (_tmp11_, G_TYPE_INT);
		g_value_set_int (_tmp11_, atoi (as_string));
		result = _tmp11_;
		return result;
	}
	if (type == G_TYPE_LONG) {
		GValue* _tmp12_ = NULL;
		_tmp12_ = g_new0 (GValue, 1);
		g_value_init (_tmp12_, G_TYPE_LONG);
		g_value_set_long (_tmp12_, long_parse (as_string));
		result = _tmp12_;
		return result;
	}
	if (type == G_TYPE_DOUBLE) {
		GValue* _tmp13_ = NULL;
		_tmp13_ = g_new0 (GValue, 1);
		g_value_init (_tmp13_, G_TYPE_DOUBLE);
		g_value_set_double (_tmp13_, double_parse (as_string));
		result = _tmp13_;
		return result;
	}
	if (type == gda_numeric_get_type ()) {
		GdaNumeric* n = NULL;
		GdaNumeric* _tmp14_;
		GdaNumeric* _tmp15_;
		GValue* _tmp16_ = NULL;
		_tmp14_ = gda_numeric_new ();
		n = _tmp14_;
		_tmp15_ = n;
		gda_numeric_set_from_string (_tmp15_, as_string);
		_tmp16_ = g_new0 (GValue, 1);
		g_value_init (_tmp16_, gda_numeric_get_type ());
		g_value_take_boxed (_tmp16_, n);
		result = _tmp16_;
		return result;
	}
	_tmp17_ = g_new0 (GValue, 1);
	g_value_init (_tmp17_, G_TYPE_STRING);
	g_value_set_string (_tmp17_, as_string);
	result = _tmp17_;
	return result;
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar*
gda_data_db_field_real_to_string (GdaDataDbField* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GdaDataDbFieldAttribute _tmp6_;
	GdaDataDbFieldAttribute _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GValue* _tmp12_;
	GValue* _tmp13_;
	GValue _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	_tmp0_ = gda_data_db_field_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = gda_data_db_field_get_column_name (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = gda_data_db_field_get_attributes (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = gda_data_db_field_attribute_to_string (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("([", _tmp2_, "],[", _tmp5_, "],[%s],[", _tmp9_, "])", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = gda_data_db_field_get_value (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = *_tmp13_;
	_tmp15_ = gda_value_stringify (&_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup_printf (_tmp11_, _tmp16_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	result = _tmp18_;
	return result;
}


gchar*
gda_data_db_field_to_string (GdaDataDbField* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->to_string (self);
}


GValue*
gda_data_db_field_get_value (GdaDataDbField* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->get_value (self);
}


void
gda_data_db_field_set_value (GdaDataDbField* self,
                             GValue* value)
{
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_GET_INTERFACE (self)->set_value (self, value);
}


const gchar*
gda_data_db_field_get_name (GdaDataDbField* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->get_name (self);
}


void
gda_data_db_field_set_name (GdaDataDbField* self,
                            const gchar* value)
{
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_GET_INTERFACE (self)->set_name (self, value);
}


const gchar*
gda_data_db_field_get_column_name (GdaDataDbField* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->get_column_name (self);
}


GdaDataDbFieldAttribute
gda_data_db_field_get_attributes (GdaDataDbField* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->get_attributes (self);
}


static void
gda_data_db_field_default_init (GdaDataDbFieldIface * iface)
{
	g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("column-name", "column-name", "column-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_flags ("attributes", "attributes", "attributes", GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	iface->equal = gda_data_db_field_real_equal;
	iface->to_string = gda_data_db_field_real_to_string;
}


GType
gda_data_db_field_get_type (void)
{
	static volatile gsize gda_data_db_field_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataDbFieldIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gda_data_db_field_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gda_data_db_field_type_id;
		gda_data_db_field_type_id = g_type_register_static (G_TYPE_INTERFACE, "GdaDataDbField", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gda_data_db_field_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gda_data_db_field_type_id__volatile, gda_data_db_field_type_id);
	}
	return gda_data_db_field_type_id__volatile;
}



