/* testmap.c generated by valac 0.44.7, the Vala compiler
 * generated from testmap.vala, do not modify */

/* testmap.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters, Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_MAP_TESTS (map_tests_get_type ())
#define MAP_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP_TESTS, MapTests))
#define MAP_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP_TESTS, MapTestsClass))
#define IS_MAP_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP_TESTS))
#define IS_MAP_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP_TESTS))
#define MAP_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP_TESTS, MapTestsClass))

typedef struct _MapTests MapTests;
typedef struct _MapTestsClass MapTestsClass;
typedef struct _MapTestsPrivate MapTestsPrivate;
enum  {
	MAP_TESTS_0_PROPERTY,
	MAP_TESTS_NUM_PROPERTIES
};
static GParamSpec* map_tests_properties[MAP_TESTS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*GeeTestCaseTestMethod) (gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAP_TESTS_TYPE_TEST_ENTRY (map_tests_test_entry_get_type ())
#define MAP_TESTS_TEST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntry))
#define MAP_TESTS_TEST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntryClass))
#define MAP_TESTS_IS_TEST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAP_TESTS_TYPE_TEST_ENTRY))
#define MAP_TESTS_IS_TEST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAP_TESTS_TYPE_TEST_ENTRY))
#define MAP_TESTS_TEST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntryClass))

typedef struct _MapTestsTestEntry MapTestsTestEntry;
typedef struct _MapTestsTestEntryClass MapTestsTestEntryClass;
typedef struct _Block12Data Block12Data;
typedef struct _MapTestsTestEntryPrivate MapTestsTestEntryPrivate;
enum  {
	MAP_TESTS_TEST_ENTRY_0_PROPERTY,
	MAP_TESTS_TEST_ENTRY_K_TYPE,
	MAP_TESTS_TEST_ENTRY_K_DUP_FUNC,
	MAP_TESTS_TEST_ENTRY_K_DESTROY_FUNC,
	MAP_TESTS_TEST_ENTRY_V_TYPE,
	MAP_TESTS_TEST_ENTRY_V_DUP_FUNC,
	MAP_TESTS_TEST_ENTRY_V_DESTROY_FUNC,
	MAP_TESTS_TEST_ENTRY_KEY_PROPERTY,
	MAP_TESTS_TEST_ENTRY_VALUE_PROPERTY,
	MAP_TESTS_TEST_ENTRY_READ_ONLY_PROPERTY,
	MAP_TESTS_TEST_ENTRY_NUM_PROPERTIES
};
static GParamSpec* map_tests_test_entry_properties[MAP_TESTS_TEST_ENTRY_NUM_PROPERTIES];
#define _k_destroy_func0(var) (((var == NULL) || (k_destroy_func == NULL)) ? NULL : (var = (k_destroy_func (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _MapTests {
	GeeTestCase parent_instance;
	MapTestsPrivate * priv;
	GeeMap* test_map;
};

struct _MapTestsClass {
	GeeTestCaseClass parent_class;
};

struct _Block12Data {
	int _ref_count_;
	MapTests* self;
	gint count;
};

struct _MapTestsTestEntry {
	GeeMapEntry parent_instance;
	MapTestsTestEntryPrivate * priv;
};

struct _MapTestsTestEntryClass {
	GeeMapEntryClass parent_class;
};

struct _MapTestsTestEntryPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	gpointer _key;
	gpointer _value;
};

static gpointer map_tests_parent_class = NULL;
static gint MapTestsTestEntry_private_offset;
static gpointer map_tests_test_entry_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType map_tests_get_type (void) G_GNUC_CONST;
MapTests* map_tests_construct (GType object_type,
                               const gchar* name);
GeeTestCase* gee_test_case_construct (GType object_type,
                                      const gchar* name);
void gee_test_case_add_test (GeeTestCase* self,
                             const gchar* name,
                             GeeTestCaseTestMethod test,
                             gpointer test_target,
                             GDestroyNotify test_target_destroy_notify);
void map_tests_test_type_correctness (MapTests* self);
static void _map_tests_test_type_correctness_gee_test_case_test_method (gpointer self);
void map_tests_test_has_key_size_is_empty (MapTests* self);
static void _map_tests_test_has_key_size_is_empty_gee_test_case_test_method (gpointer self);
void map_tests_test_keys (MapTests* self);
static void _map_tests_test_keys_gee_test_case_test_method (gpointer self);
void map_tests_test_values (MapTests* self);
static void _map_tests_test_values_gee_test_case_test_method (gpointer self);
void map_tests_test_entries (MapTests* self);
static void _map_tests_test_entries_gee_test_case_test_method (gpointer self);
static void map_tests_test_entry_weak_pointer_lifetime (MapTests* self);
static void _map_tests_test_entry_weak_pointer_lifetime_gee_test_case_test_method (gpointer self);
void map_tests_test_set_all (MapTests* self);
static void _map_tests_test_set_all_gee_test_case_test_method (gpointer self);
void map_tests_test_unset_all (MapTests* self);
static void _map_tests_test_unset_all_gee_test_case_test_method (gpointer self);
void map_tests_test_has_all (MapTests* self);
static void _map_tests_test_has_all_gee_test_case_test_method (gpointer self);
void map_tests_test_gobject_properties (MapTests* self);
static void _map_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
void map_tests_test_fold (MapTests* self);
static void _map_tests_test_fold_gee_test_case_test_method (gpointer self);
void map_tests_test_foreach (MapTests* self);
static void _map_tests_test_foreach_gee_test_case_test_method (gpointer self);
static MapTestsTestEntry* map_tests_test_entry_new (GType k_type,
                                             GBoxedCopyFunc k_dup_func,
                                             GDestroyNotify k_destroy_func,
                                             GType v_type,
                                             GBoxedCopyFunc v_dup_func,
                                             GDestroyNotify v_destroy_func,
                                             gconstpointer key,
                                             gconstpointer value);
static MapTestsTestEntry* map_tests_test_entry_construct (GType object_type,
                                                   GType k_type,
                                                   GBoxedCopyFunc k_dup_func,
                                                   GDestroyNotify k_destroy_func,
                                                   GType v_type,
                                                   GBoxedCopyFunc v_dup_func,
                                                   GDestroyNotify v_destroy_func,
                                                   gconstpointer key,
                                                   gconstpointer value);
static GType map_tests_test_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void map_tests_test_clear (MapTests* self);
static gint __lambda50_ (MapTests* self,
                  const gchar* x,
                  const gchar* y,
                  gint z);
static gpointer ___lambda50__gee_fold_map_func (gconstpointer k,
                                         gconstpointer v,
                                         gpointer a,
                                         gpointer self);
static gint __lambda51_ (MapTests* self,
                  const gchar* x,
                  const gchar* y,
                  gint z);
static gpointer ___lambda51__gee_fold_map_func (gconstpointer k,
                                         gconstpointer v,
                                         gpointer a,
                                         gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean __lambda52_ (Block12Data* _data12_,
                      const gchar* x,
                      const gchar* y);
static gboolean ___lambda52__gee_forall_map_func (gconstpointer k,
                                           gconstpointer v,
                                           gpointer self);
static gboolean __lambda53_ (Block12Data* _data12_,
                      const gchar* x,
                      const gchar* y);
static gboolean ___lambda53__gee_forall_map_func (gconstpointer k,
                                           gconstpointer v,
                                           gpointer self);
GeeMapEntry* map_tests_entry_for (const gchar* key,
                                  const gchar* value);
gboolean map_tests_check_entry (GeeMapEntry* e,
                                const gchar* key,
                                const gchar* value);
void map_tests_assert_entry (GeeMapEntry* e,
                             const gchar* key,
                             const gchar* value);
static void map_tests_test_entry_finalize (GObject * obj);
static void _vala_map_tests_test_entry_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_map_tests_test_entry_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void map_tests_finalize (GObject * obj);

static void
_map_tests_test_type_correctness_gee_test_case_test_method (gpointer self)
{
	map_tests_test_type_correctness ((MapTests*) self);
}

static void
_map_tests_test_has_key_size_is_empty_gee_test_case_test_method (gpointer self)
{
	map_tests_test_has_key_size_is_empty ((MapTests*) self);
}

static void
_map_tests_test_keys_gee_test_case_test_method (gpointer self)
{
	map_tests_test_keys ((MapTests*) self);
}

static void
_map_tests_test_values_gee_test_case_test_method (gpointer self)
{
	map_tests_test_values ((MapTests*) self);
}

static void
_map_tests_test_entries_gee_test_case_test_method (gpointer self)
{
	map_tests_test_entries ((MapTests*) self);
}

static void
_map_tests_test_entry_weak_pointer_lifetime_gee_test_case_test_method (gpointer self)
{
	map_tests_test_entry_weak_pointer_lifetime ((MapTests*) self);
}

static void
_map_tests_test_set_all_gee_test_case_test_method (gpointer self)
{
	map_tests_test_set_all ((MapTests*) self);
}

static void
_map_tests_test_unset_all_gee_test_case_test_method (gpointer self)
{
	map_tests_test_unset_all ((MapTests*) self);
}

static void
_map_tests_test_has_all_gee_test_case_test_method (gpointer self)
{
	map_tests_test_has_all ((MapTests*) self);
}

static void
_map_tests_test_gobject_properties_gee_test_case_test_method (gpointer self)
{
	map_tests_test_gobject_properties ((MapTests*) self);
}

static void
_map_tests_test_fold_gee_test_case_test_method (gpointer self)
{
	map_tests_test_fold ((MapTests*) self);
}

static void
_map_tests_test_foreach_gee_test_case_test_method (gpointer self)
{
	map_tests_test_foreach ((MapTests*) self);
}

MapTests*
map_tests_construct (GType object_type,
                     const gchar* name)
{
	MapTests * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (MapTests*) gee_test_case_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] type correctness", _map_tests_test_type_correctness_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] has_key, size and is_empty", _map_tests_test_has_key_size_is_empty_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] keys", _map_tests_test_keys_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] values", _map_tests_test_values_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] entries", _map_tests_test_entries_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] entry weak pointer lifetime", _map_tests_test_entry_weak_pointer_lifetime_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] set all", _map_tests_test_set_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] unset all", _map_tests_test_unset_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] has all", _map_tests_test_has_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] GObject properties", _map_tests_test_gobject_properties_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] fold", _map_tests_test_fold_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] foreach", _map_tests_test_foreach_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	return self;
}

void
map_tests_test_type_correctness (MapTests* self)
{
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GType _tmp2_;
	GType _tmp3_;
	GeeMap* _tmp4_;
	GType _tmp5_;
	GType _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_map;
	_vala_assert (_tmp0_ != NULL, "test_map != null");
	_tmp1_ = self->test_map;
	_tmp2_ = gee_map_get_key_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ == G_TYPE_STRING, "test_map.key_type == typeof (string)");
	_tmp4_ = self->test_map;
	_tmp5_ = gee_map_get_value_type (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_ == G_TYPE_STRING, "test_map.value_type == typeof (string)");
}

void
map_tests_test_has_key_size_is_empty (MapTests* self)
{
	GeeMap* _tmp0_;
	gchar* value = NULL;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeeMap* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GeeMap* _tmp10_;
	GeeMap* _tmp11_;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	GeeMap* _tmp14_;
	gpointer _tmp15_;
	gchar* _tmp16_;
	GeeMap* _tmp17_;
	GeeMap* _tmp18_;
	gpointer _tmp19_;
	gchar* _tmp20_;
	GeeMap* _tmp21_;
	GeeMap* _tmp22_;
	gpointer _tmp23_;
	gchar* _tmp24_;
	GeeMap* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GeeMap* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	GeeMap* _tmp31_;
	GeeMap* _tmp32_;
	GeeMap* _tmp33_;
	GeeMap* _tmp34_;
	GeeMap* _tmp35_;
	gpointer _tmp36_;
	gchar* _tmp37_;
	GeeMap* _tmp38_;
	GeeMap* _tmp39_;
	gpointer _tmp40_;
	gchar* _tmp41_;
	GeeMap* _tmp42_;
	GeeMap* _tmp43_;
	gpointer _tmp44_;
	gchar* _tmp45_;
	GeeMap* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GeeMap* _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	GeeMap* _tmp52_;
	GeeMap* _tmp53_;
	GeeMap* _tmp54_;
	gpointer _tmp55_;
	gchar* _tmp56_;
	GeeMap* _tmp57_;
	GeeMap* _tmp58_;
	gpointer _tmp59_;
	gchar* _tmp60_;
	GeeMap* _tmp61_;
	GeeMap* _tmp62_;
	gpointer _tmp63_;
	gchar* _tmp64_;
	GeeMap* _tmp65_;
	gint _tmp66_;
	gint _tmp67_;
	GeeMap* _tmp68_;
	gboolean _tmp69_;
	gboolean _tmp70_;
	GeeMap* _tmp71_;
	GeeMap* _tmp72_;
	GeeMap* _tmp73_;
	gpointer _tmp74_;
	gchar* _tmp75_;
	GeeMap* _tmp76_;
	GeeMap* _tmp77_;
	gpointer _tmp78_;
	gchar* _tmp79_;
	GeeMap* _tmp80_;
	GeeMap* _tmp81_;
	gpointer _tmp82_;
	gchar* _tmp83_;
	GeeMap* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	GeeMap* _tmp87_;
	gboolean _tmp88_;
	gboolean _tmp89_;
	GeeMap* _tmp90_;
	GeeMap* _tmp91_;
	GeeMap* _tmp92_;
	gpointer _tmp93_;
	gchar* _tmp94_;
	GeeMap* _tmp95_;
	GeeMap* _tmp96_;
	gpointer _tmp97_;
	gchar* _tmp98_;
	GeeMap* _tmp99_;
	GeeMap* _tmp100_;
	gpointer _tmp101_;
	gchar* _tmp102_;
	GeeMap* _tmp103_;
	gint _tmp104_;
	gint _tmp105_;
	GeeMap* _tmp106_;
	gboolean _tmp107_;
	gboolean _tmp108_;
	GeeMap* _tmp109_;
	GeeMap* _tmp110_;
	GeeMap* _tmp111_;
	gpointer _tmp112_;
	gchar* _tmp113_;
	GeeMap* _tmp114_;
	GeeMap* _tmp115_;
	gpointer _tmp116_;
	gchar* _tmp117_;
	GeeMap* _tmp118_;
	GeeMap* _tmp119_;
	gpointer _tmp120_;
	gchar* _tmp121_;
	GeeMap* _tmp122_;
	gint _tmp123_;
	gint _tmp124_;
	GeeMap* _tmp125_;
	gboolean _tmp126_;
	gboolean _tmp127_;
	GeeMap* _tmp128_;
	gpointer _tmp129_ = NULL;
	gboolean _tmp130_;
	const gchar* _tmp131_;
	GeeMap* _tmp132_;
	GeeMap* _tmp133_;
	gpointer _tmp134_;
	gchar* _tmp135_;
	GeeMap* _tmp136_;
	GeeMap* _tmp137_;
	gpointer _tmp138_;
	gchar* _tmp139_;
	GeeMap* _tmp140_;
	GeeMap* _tmp141_;
	gpointer _tmp142_;
	gchar* _tmp143_;
	GeeMap* _tmp144_;
	gint _tmp145_;
	gint _tmp146_;
	GeeMap* _tmp147_;
	gboolean _tmp148_;
	gboolean _tmp149_;
	GeeMap* _tmp150_;
	gpointer _tmp151_ = NULL;
	gboolean _tmp152_;
	const gchar* _tmp153_;
	GeeMap* _tmp154_;
	GeeMap* _tmp155_;
	GeeMap* _tmp156_;
	GeeMap* _tmp157_;
	gint _tmp158_;
	gint _tmp159_;
	GeeMap* _tmp160_;
	gboolean _tmp161_;
	gboolean _tmp162_;
	GeeMap* _tmp163_;
	GeeMap* _tmp164_;
	GeeMap* _tmp165_;
	gpointer _tmp166_;
	gchar* _tmp167_;
	GeeMap* _tmp168_;
	GeeMap* _tmp169_;
	gpointer _tmp170_;
	gchar* _tmp171_;
	GeeMap* _tmp172_;
	GeeMap* _tmp173_;
	gpointer _tmp174_;
	gchar* _tmp175_;
	GeeMap* _tmp176_;
	gint _tmp177_;
	gint _tmp178_;
	GeeMap* _tmp179_;
	gboolean _tmp180_;
	gboolean _tmp181_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_map;
	_vala_assert (_tmp0_ != NULL, "test_map != null");
	_tmp1_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp1_, "one"), "! test_map.has_key (\"one\")");
	_tmp2_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp2_, "two"), "! test_map.has_key (\"two\")");
	_tmp3_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp3_, "three"), "! test_map.has_key (\"three\")");
	_tmp4_ = self->test_map;
	_tmp5_ = gee_map_get_size (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_ == 0, "test_map.size == 0");
	_tmp7_ = self->test_map;
	_tmp8_ = gee_map_get_is_empty (_tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_, "test_map.is_empty");
	_tmp10_ = self->test_map;
	gee_map_set (_tmp10_, "one", "value_of_one");
	_tmp11_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp11_, "one"), "test_map.has_key (\"one\")");
	_tmp12_ = self->test_map;
	_vala_assert (gee_map_has (_tmp12_, "one", "value_of_one"), "test_map.has (\"one\", \"value_of_one\")");
	_tmp13_ = self->test_map;
	_vala_assert (!gee_map_has (_tmp13_, "one", "another_value_for_one"), "! test_map.has (\"one\", \"another_value_for_one\")");
	_tmp14_ = self->test_map;
	_tmp15_ = gee_map_get (_tmp14_, "one");
	_tmp16_ = (gchar*) _tmp15_;
	_vala_assert (g_strcmp0 (_tmp16_, "value_of_one") == 0, "test_map.get (\"one\") == \"value_of_one\"");
	_g_free0 (_tmp16_);
	_tmp17_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp17_, "two"), "! test_map.has_key (\"two\")");
	_tmp18_ = self->test_map;
	_tmp19_ = gee_map_get (_tmp18_, "two");
	_tmp20_ = (gchar*) _tmp19_;
	_vala_assert (_tmp20_ == NULL, "test_map.get (\"two\") == null");
	_g_free0 (_tmp20_);
	_tmp21_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp21_, "three"), "! test_map.has_key (\"three\")");
	_tmp22_ = self->test_map;
	_tmp23_ = gee_map_get (_tmp22_, "three");
	_tmp24_ = (gchar*) _tmp23_;
	_vala_assert (_tmp24_ == NULL, "test_map.get (\"three\") == null");
	_g_free0 (_tmp24_);
	_tmp25_ = self->test_map;
	_tmp26_ = gee_map_get_size (_tmp25_);
	_tmp27_ = _tmp26_;
	_vala_assert (_tmp27_ == 1, "test_map.size == 1");
	_tmp28_ = self->test_map;
	_tmp29_ = gee_map_get_is_empty (_tmp28_);
	_tmp30_ = _tmp29_;
	_vala_assert (!_tmp30_, "! test_map.is_empty");
	_tmp31_ = self->test_map;
	_vala_assert (gee_map_unset (_tmp31_, "one", NULL), "test_map.unset (\"one\")");
	_tmp32_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp32_, "one"), "! test_map.has_key (\"one\")");
	_tmp33_ = self->test_map;
	_vala_assert (!gee_map_has (_tmp33_, "one", "value_of_one"), "! test_map.has (\"one\", \"value_of_one\")");
	_tmp34_ = self->test_map;
	_vala_assert (!gee_map_has (_tmp34_, "one", "another_value_for_one"), "! test_map.has (\"one\", \"another_value_for_one\")");
	_tmp35_ = self->test_map;
	_tmp36_ = gee_map_get (_tmp35_, "one");
	_tmp37_ = (gchar*) _tmp36_;
	_vala_assert (_tmp37_ == NULL, "test_map.get (\"one\") == null");
	_g_free0 (_tmp37_);
	_tmp38_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp38_, "two"), "! test_map.has_key (\"two\")");
	_tmp39_ = self->test_map;
	_tmp40_ = gee_map_get (_tmp39_, "two");
	_tmp41_ = (gchar*) _tmp40_;
	_vala_assert (_tmp41_ == NULL, "test_map.get (\"two\") ==  null");
	_g_free0 (_tmp41_);
	_tmp42_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp42_, "three"), "! test_map.has_key (\"three\")");
	_tmp43_ = self->test_map;
	_tmp44_ = gee_map_get (_tmp43_, "three");
	_tmp45_ = (gchar*) _tmp44_;
	_vala_assert (_tmp45_ == NULL, "test_map.get (\"three\") == null");
	_g_free0 (_tmp45_);
	_tmp46_ = self->test_map;
	_tmp47_ = gee_map_get_size (_tmp46_);
	_tmp48_ = _tmp47_;
	_vala_assert (_tmp48_ == 0, "test_map.size == 0");
	_tmp49_ = self->test_map;
	_tmp50_ = gee_map_get_is_empty (_tmp49_);
	_tmp51_ = _tmp50_;
	_vala_assert (_tmp51_, "test_map.is_empty");
	_tmp52_ = self->test_map;
	gee_map_set (_tmp52_, "one", "value_of_one");
	_tmp53_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp53_, "one"), "test_map.has_key (\"one\")");
	_tmp54_ = self->test_map;
	_tmp55_ = gee_map_get (_tmp54_, "one");
	_tmp56_ = (gchar*) _tmp55_;
	_vala_assert (g_strcmp0 (_tmp56_, "value_of_one") == 0, "test_map.get (\"one\") == \"value_of_one\"");
	_g_free0 (_tmp56_);
	_tmp57_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp57_, "two"), "! test_map.has_key (\"two\")");
	_tmp58_ = self->test_map;
	_tmp59_ = gee_map_get (_tmp58_, "two");
	_tmp60_ = (gchar*) _tmp59_;
	_vala_assert (_tmp60_ == NULL, "test_map.get (\"two\") == null");
	_g_free0 (_tmp60_);
	_tmp61_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp61_, "three"), "! test_map.has_key (\"three\")");
	_tmp62_ = self->test_map;
	_tmp63_ = gee_map_get (_tmp62_, "three");
	_tmp64_ = (gchar*) _tmp63_;
	_vala_assert (_tmp64_ == NULL, "test_map.get (\"three\") == null");
	_g_free0 (_tmp64_);
	_tmp65_ = self->test_map;
	_tmp66_ = gee_map_get_size (_tmp65_);
	_tmp67_ = _tmp66_;
	_vala_assert (_tmp67_ == 1, "test_map.size == 1");
	_tmp68_ = self->test_map;
	_tmp69_ = gee_map_get_is_empty (_tmp68_);
	_tmp70_ = _tmp69_;
	_vala_assert (!_tmp70_, "! test_map.is_empty");
	_tmp71_ = self->test_map;
	gee_map_set (_tmp71_, "two", "value_of_two");
	_tmp72_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp72_, "one"), "test_map.has_key (\"one\")");
	_tmp73_ = self->test_map;
	_tmp74_ = gee_map_get (_tmp73_, "one");
	_tmp75_ = (gchar*) _tmp74_;
	_vala_assert (g_strcmp0 (_tmp75_, "value_of_one") == 0, "test_map.get (\"one\") == \"value_of_one\"");
	_g_free0 (_tmp75_);
	_tmp76_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp76_, "two"), "test_map.has_key (\"two\")");
	_tmp77_ = self->test_map;
	_tmp78_ = gee_map_get (_tmp77_, "two");
	_tmp79_ = (gchar*) _tmp78_;
	_vala_assert (g_strcmp0 (_tmp79_, "value_of_two") == 0, "test_map.get (\"two\") == \"value_of_two\"");
	_g_free0 (_tmp79_);
	_tmp80_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp80_, "three"), "! test_map.has_key (\"three\")");
	_tmp81_ = self->test_map;
	_tmp82_ = gee_map_get (_tmp81_, "three");
	_tmp83_ = (gchar*) _tmp82_;
	_vala_assert (_tmp83_ == NULL, "test_map.get (\"three\") == null");
	_g_free0 (_tmp83_);
	_tmp84_ = self->test_map;
	_tmp85_ = gee_map_get_size (_tmp84_);
	_tmp86_ = _tmp85_;
	_vala_assert (_tmp86_ == 2, "test_map.size == 2");
	_tmp87_ = self->test_map;
	_tmp88_ = gee_map_get_is_empty (_tmp87_);
	_tmp89_ = _tmp88_;
	_vala_assert (!_tmp89_, "! test_map.is_empty");
	_tmp90_ = self->test_map;
	gee_map_set (_tmp90_, "three", "value_of_three");
	_tmp91_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp91_, "one"), "test_map.has_key (\"one\")");
	_tmp92_ = self->test_map;
	_tmp93_ = gee_map_get (_tmp92_, "one");
	_tmp94_ = (gchar*) _tmp93_;
	_vala_assert (g_strcmp0 (_tmp94_, "value_of_one") == 0, "test_map.get (\"one\") == \"value_of_one\"");
	_g_free0 (_tmp94_);
	_tmp95_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp95_, "two"), "test_map.has_key (\"two\")");
	_tmp96_ = self->test_map;
	_tmp97_ = gee_map_get (_tmp96_, "two");
	_tmp98_ = (gchar*) _tmp97_;
	_vala_assert (g_strcmp0 (_tmp98_, "value_of_two") == 0, "test_map.get (\"two\") == \"value_of_two\"");
	_g_free0 (_tmp98_);
	_tmp99_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp99_, "three"), "test_map.has_key (\"three\")");
	_tmp100_ = self->test_map;
	_tmp101_ = gee_map_get (_tmp100_, "three");
	_tmp102_ = (gchar*) _tmp101_;
	_vala_assert (g_strcmp0 (_tmp102_, "value_of_three") == 0, "test_map.get (\"three\") == \"value_of_three\"");
	_g_free0 (_tmp102_);
	_tmp103_ = self->test_map;
	_tmp104_ = gee_map_get_size (_tmp103_);
	_tmp105_ = _tmp104_;
	_vala_assert (_tmp105_ == 3, "test_map.size == 3");
	_tmp106_ = self->test_map;
	_tmp107_ = gee_map_get_is_empty (_tmp106_);
	_tmp108_ = _tmp107_;
	_vala_assert (!_tmp108_, "! test_map.is_empty");
	_tmp109_ = self->test_map;
	gee_map_set (_tmp109_, "two", "value_of_two_new");
	_tmp110_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp110_, "one"), "test_map.has_key (\"one\")");
	_tmp111_ = self->test_map;
	_tmp112_ = gee_map_get (_tmp111_, "one");
	_tmp113_ = (gchar*) _tmp112_;
	_vala_assert (g_strcmp0 (_tmp113_, "value_of_one") == 0, "test_map.get (\"one\") == \"value_of_one\"");
	_g_free0 (_tmp113_);
	_tmp114_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp114_, "two"), "test_map.has_key (\"two\")");
	_tmp115_ = self->test_map;
	_tmp116_ = gee_map_get (_tmp115_, "two");
	_tmp117_ = (gchar*) _tmp116_;
	_vala_assert (g_strcmp0 (_tmp117_, "value_of_two_new") == 0, "test_map.get (\"two\") == \"value_of_two_new\"");
	_g_free0 (_tmp117_);
	_tmp118_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp118_, "three"), "test_map.has_key (\"three\")");
	_tmp119_ = self->test_map;
	_tmp120_ = gee_map_get (_tmp119_, "three");
	_tmp121_ = (gchar*) _tmp120_;
	_vala_assert (g_strcmp0 (_tmp121_, "value_of_three") == 0, "test_map.get (\"three\") == \"value_of_three\"");
	_g_free0 (_tmp121_);
	_tmp122_ = self->test_map;
	_tmp123_ = gee_map_get_size (_tmp122_);
	_tmp124_ = _tmp123_;
	_vala_assert (_tmp124_ == 3, "test_map.size == 3");
	_tmp125_ = self->test_map;
	_tmp126_ = gee_map_get_is_empty (_tmp125_);
	_tmp127_ = _tmp126_;
	_vala_assert (!_tmp127_, "! test_map.is_empty");
	_tmp128_ = self->test_map;
	_tmp130_ = gee_map_unset (_tmp128_, "two", &_tmp129_);
	_g_free0 (value);
	value = _tmp129_;
	_vala_assert (_tmp130_, "test_map.unset (\"two\", out value)");
	_tmp131_ = value;
	_vala_assert (g_strcmp0 (_tmp131_, "value_of_two_new") == 0, "value == \"value_of_two_new\"");
	_tmp132_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp132_, "one"), "test_map.has_key (\"one\")");
	_tmp133_ = self->test_map;
	_tmp134_ = gee_map_get (_tmp133_, "one");
	_tmp135_ = (gchar*) _tmp134_;
	_vala_assert (g_strcmp0 (_tmp135_, "value_of_one") == 0, "test_map.get (\"one\") == \"value_of_one\"");
	_g_free0 (_tmp135_);
	_tmp136_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp136_, "two"), "! test_map.has_key (\"two\")");
	_tmp137_ = self->test_map;
	_tmp138_ = gee_map_get (_tmp137_, "two");
	_tmp139_ = (gchar*) _tmp138_;
	_vala_assert (_tmp139_ == NULL, "test_map.get (\"two\") == null");
	_g_free0 (_tmp139_);
	_tmp140_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp140_, "three"), "test_map.has_key (\"three\")");
	_tmp141_ = self->test_map;
	_tmp142_ = gee_map_get (_tmp141_, "three");
	_tmp143_ = (gchar*) _tmp142_;
	_vala_assert (g_strcmp0 (_tmp143_, "value_of_three") == 0, "test_map.get (\"three\") == \"value_of_three\"");
	_g_free0 (_tmp143_);
	_tmp144_ = self->test_map;
	_tmp145_ = gee_map_get_size (_tmp144_);
	_tmp146_ = _tmp145_;
	_vala_assert (_tmp146_ == 2, "test_map.size == 2");
	_tmp147_ = self->test_map;
	_tmp148_ = gee_map_get_is_empty (_tmp147_);
	_tmp149_ = _tmp148_;
	_vala_assert (!_tmp149_, "! test_map.is_empty");
	_tmp150_ = self->test_map;
	_tmp152_ = gee_map_unset (_tmp150_, "two", &_tmp151_);
	_g_free0 (value);
	value = _tmp151_;
	_vala_assert (!_tmp152_, "! test_map.unset (\"two\", out value)");
	_tmp153_ = value;
	_vala_assert (_tmp153_ == NULL, "value == null");
	_tmp154_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp154_, "one"), "test_map.has_key (\"one\")");
	_tmp155_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp155_, "two"), "! test_map.has_key (\"two\")");
	_tmp156_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp156_, "three"), "test_map.has_key (\"three\")");
	_tmp157_ = self->test_map;
	_tmp158_ = gee_map_get_size (_tmp157_);
	_tmp159_ = _tmp158_;
	_vala_assert (_tmp159_ == 2, "test_map.size == 2");
	_tmp160_ = self->test_map;
	_tmp161_ = gee_map_get_is_empty (_tmp160_);
	_tmp162_ = _tmp161_;
	_vala_assert (!_tmp162_, "! test_map.is_empty");
	_tmp163_ = self->test_map;
	gee_map_clear (_tmp163_);
	_tmp164_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp164_, "one"), "! test_map.has_key (\"one\")");
	_tmp165_ = self->test_map;
	_tmp166_ = gee_map_get (_tmp165_, "one");
	_tmp167_ = (gchar*) _tmp166_;
	_vala_assert (_tmp167_ == NULL, "test_map.get (\"one\") == null");
	_g_free0 (_tmp167_);
	_tmp168_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp168_, "two"), "! test_map.has_key (\"two\")");
	_tmp169_ = self->test_map;
	_tmp170_ = gee_map_get (_tmp169_, "two");
	_tmp171_ = (gchar*) _tmp170_;
	_vala_assert (_tmp171_ == NULL, "test_map.get (\"two\") == null");
	_g_free0 (_tmp171_);
	_tmp172_ = self->test_map;
	_vala_assert (!gee_map_has_key (_tmp172_, "three"), "! test_map.has_key (\"three\")");
	_tmp173_ = self->test_map;
	_tmp174_ = gee_map_get (_tmp173_, "three");
	_tmp175_ = (gchar*) _tmp174_;
	_vala_assert (_tmp175_ == NULL, "test_map.get (\"three\") == null");
	_g_free0 (_tmp175_);
	_tmp176_ = self->test_map;
	_tmp177_ = gee_map_get_size (_tmp176_);
	_tmp178_ = _tmp177_;
	_vala_assert (_tmp178_ == 0, "test_map.size == 0");
	_tmp179_ = self->test_map;
	_tmp180_ = gee_map_get_is_empty (_tmp179_);
	_tmp181_ = _tmp180_;
	_vala_assert (_tmp181_, "test_map.is_empty");
	_g_free0 (value);
}

void
map_tests_test_keys (MapTests* self)
{
	GeeSet* keys = NULL;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeMap* _tmp6_;
	GeeSet* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeSet* _tmp10_;
	GeeMap* _tmp11_;
	GeeSet* _tmp12_;
	GeeSet* _tmp13_;
	GeeSet* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeSet* _tmp17_;
	GeeMap* _tmp19_;
	GeeSet* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GeeSet* _tmp23_;
	GeeSet* _tmp24_;
	GeeMap* _tmp25_;
	GeeSet* _tmp26_;
	GeeSet* _tmp27_;
	GeeSet* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GeeSet* _tmp31_;
	GeeSet* _tmp32_;
	GeeMap* _tmp33_;
	GeeSet* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	GeeMap* _tmp37_;
	GeeSet* _tmp38_;
	GeeSet* _tmp39_;
	GeeSet* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_map;
	_tmp1_ = gee_map_get_keys (_tmp0_);
	_tmp2_ = _tmp1_;
	keys = _tmp2_;
	_tmp3_ = keys;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 0, "keys.size == 0");
	_tmp6_ = self->test_map;
	gee_map_set (_tmp6_, "one", "value_of_one");
	_tmp7_ = keys;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ == 1, "keys.size == 1");
	_tmp10_ = keys;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp10_, "one"), "keys.contains (\"one\")");
	_tmp11_ = self->test_map;
	_tmp12_ = gee_map_get_keys (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (keys);
	keys = _tmp13_;
	_tmp14_ = keys;
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	_vala_assert (_tmp16_ == 1, "keys.size == 1");
	_tmp17_ = keys;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp17_, "one"), "keys.contains (\"one\")");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeSet* _tmp18_;
		_tmp18_ = keys;
		_vala_assert (!gee_collection_add ((GeeCollection*) _tmp18_, "three"), "! keys.add (\"three\")");
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr ("*code should not be reached*");
	_tmp19_ = self->test_map;
	gee_map_set (_tmp19_, "two", "value_of_two");
	_tmp20_ = keys;
	_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	_vala_assert (_tmp22_ == 2, "keys.size == 2");
	_tmp23_ = keys;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp23_, "one"), "keys.contains (\"one\")");
	_tmp24_ = keys;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp24_, "two"), "keys.contains (\"two\")");
	_tmp25_ = self->test_map;
	_tmp26_ = gee_map_get_keys (_tmp25_);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (keys);
	keys = _tmp27_;
	_tmp28_ = keys;
	_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	_vala_assert (_tmp30_ == 2, "keys.size == 2");
	_tmp31_ = keys;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp31_, "one"), "keys.contains (\"one\")");
	_tmp32_ = keys;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp32_, "two"), "keys.contains (\"two\")");
	_tmp33_ = self->test_map;
	gee_map_clear (_tmp33_);
	_tmp34_ = keys;
	_tmp35_ = gee_collection_get_size ((GeeCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	_vala_assert (_tmp36_ == 0, "keys.size == 0");
	_tmp37_ = self->test_map;
	_tmp38_ = gee_map_get_keys (_tmp37_);
	_tmp39_ = _tmp38_;
	_g_object_unref0 (keys);
	keys = _tmp39_;
	_tmp40_ = keys;
	_tmp41_ = gee_collection_get_size ((GeeCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	_vala_assert (_tmp42_ == 0, "keys.size == 0");
	_g_object_unref0 (keys);
}

void
map_tests_test_values (MapTests* self)
{
	GeeCollection* values = NULL;
	GeeMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeMap* _tmp6_;
	GeeCollection* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeCollection* _tmp10_;
	GeeMap* _tmp11_;
	GeeCollection* _tmp12_;
	GeeCollection* _tmp13_;
	GeeCollection* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeCollection* _tmp17_;
	GeeMap* _tmp19_;
	GeeCollection* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GeeCollection* _tmp23_;
	GeeCollection* _tmp24_;
	GeeMap* _tmp25_;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	GeeCollection* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GeeCollection* _tmp31_;
	GeeCollection* _tmp32_;
	GeeMap* _tmp33_;
	GeeCollection* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	GeeMap* _tmp37_;
	GeeCollection* _tmp38_;
	GeeCollection* _tmp39_;
	GeeCollection* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_map;
	_tmp1_ = gee_map_get_values (_tmp0_);
	_tmp2_ = _tmp1_;
	values = _tmp2_;
	_tmp3_ = values;
	_tmp4_ = gee_collection_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 0, "values.size == 0");
	_tmp6_ = self->test_map;
	gee_map_set (_tmp6_, "one", "value_of_one");
	_tmp7_ = values;
	_tmp8_ = gee_collection_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ == 1, "values.size == 1");
	_tmp10_ = values;
	_vala_assert (gee_collection_contains (_tmp10_, "value_of_one"), "values.contains (\"value_of_one\")");
	_tmp11_ = self->test_map;
	_tmp12_ = gee_map_get_values (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (values);
	values = _tmp13_;
	_tmp14_ = values;
	_tmp15_ = gee_collection_get_size (_tmp14_);
	_tmp16_ = _tmp15_;
	_vala_assert (_tmp16_ == 1, "values.size == 1");
	_tmp17_ = values;
	_vala_assert (gee_collection_contains (_tmp17_, "value_of_one"), "values.contains (\"value_of_one\")");
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeCollection* _tmp18_;
		_tmp18_ = values;
		_vala_assert (!gee_collection_add (_tmp18_, "two"), "! values.add (\"two\")");
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr ("*code should not be reached*");
	_tmp19_ = self->test_map;
	gee_map_set (_tmp19_, "two", "value_of_two");
	_tmp20_ = values;
	_tmp21_ = gee_collection_get_size (_tmp20_);
	_tmp22_ = _tmp21_;
	_vala_assert (_tmp22_ == 2, "values.size == 2");
	_tmp23_ = values;
	_vala_assert (gee_collection_contains (_tmp23_, "value_of_one"), "values.contains (\"value_of_one\")");
	_tmp24_ = values;
	_vala_assert (gee_collection_contains (_tmp24_, "value_of_two"), "values.contains (\"value_of_two\")");
	_tmp25_ = self->test_map;
	_tmp26_ = gee_map_get_values (_tmp25_);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (values);
	values = _tmp27_;
	_tmp28_ = values;
	_tmp29_ = gee_collection_get_size (_tmp28_);
	_tmp30_ = _tmp29_;
	_vala_assert (_tmp30_ == 2, "values.size == 2");
	_tmp31_ = values;
	_vala_assert (gee_collection_contains (_tmp31_, "value_of_one"), "values.contains (\"value_of_one\")");
	_tmp32_ = values;
	_vala_assert (gee_collection_contains (_tmp32_, "value_of_two"), "values.contains (\"value_of_two\")");
	_tmp33_ = self->test_map;
	gee_map_clear (_tmp33_);
	_tmp34_ = values;
	_tmp35_ = gee_collection_get_size (_tmp34_);
	_tmp36_ = _tmp35_;
	_vala_assert (_tmp36_ == 0, "values.size == 0");
	_tmp37_ = self->test_map;
	_tmp38_ = gee_map_get_values (_tmp37_);
	_tmp39_ = _tmp38_;
	_g_object_unref0 (values);
	values = _tmp39_;
	_tmp40_ = values;
	_tmp41_ = gee_collection_get_size (_tmp40_);
	_tmp42_ = _tmp41_;
	_vala_assert (_tmp42_ == 0, "values.size == 0");
	_g_object_unref0 (values);
}

void
map_tests_test_entries (MapTests* self)
{
	GeeSet* entries = NULL;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeMap* _tmp6_;
	GeeSet* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeSet* _tmp10_;
	MapTestsTestEntry* _tmp11_;
	MapTestsTestEntry* _tmp12_;
	GeeMap* _tmp13_;
	GeeSet* _tmp14_;
	GeeSet* _tmp15_;
	GeeSet* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeSet* _tmp19_;
	MapTestsTestEntry* _tmp20_;
	MapTestsTestEntry* _tmp21_;
	GeeMap* _tmp25_;
	GeeSet* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GeeSet* _tmp29_;
	MapTestsTestEntry* _tmp30_;
	MapTestsTestEntry* _tmp31_;
	GeeSet* _tmp32_;
	MapTestsTestEntry* _tmp33_;
	MapTestsTestEntry* _tmp34_;
	GeeMap* _tmp35_;
	GeeSet* _tmp36_;
	GeeSet* _tmp37_;
	GeeSet* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	GeeSet* _tmp41_;
	MapTestsTestEntry* _tmp42_;
	MapTestsTestEntry* _tmp43_;
	GeeSet* _tmp44_;
	MapTestsTestEntry* _tmp45_;
	MapTestsTestEntry* _tmp46_;
	GeeMap* _tmp47_;
	GeeSet* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	GeeMap* _tmp51_;
	GeeSet* _tmp52_;
	GeeSet* _tmp53_;
	GeeSet* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_map;
	_tmp1_ = gee_map_get_entries (_tmp0_);
	_tmp2_ = _tmp1_;
	entries = _tmp2_;
	_tmp3_ = entries;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 0, "entries.size == 0");
	_tmp6_ = self->test_map;
	gee_map_set (_tmp6_, "one", "value_of_one");
	_tmp7_ = entries;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ == 1, "entries.size == 1");
	_tmp10_ = entries;
	_tmp11_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, "one", "value_of_one");
	_tmp12_ = _tmp11_;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp10_, (GeeMapEntry*) _tmp12_), "entries.contains (new TestEntry<string,string> (\"one\", \"value_of_one\"))");
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->test_map;
	_tmp14_ = gee_map_get_entries (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (entries);
	entries = _tmp15_;
	_tmp16_ = entries;
	_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	_vala_assert (_tmp18_ == 1, "entries.size == 1");
	_tmp19_ = entries;
	_tmp20_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, "one", "value_of_one");
	_tmp21_ = _tmp20_;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp19_, (GeeMapEntry*) _tmp21_), "entries.contains (new TestEntry<string,string> (\"one\", \"value_of_one\"))");
	_g_object_unref0 (_tmp21_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeSet* _tmp22_;
		MapTestsTestEntry* _tmp23_;
		MapTestsTestEntry* _tmp24_;
		_tmp22_ = entries;
		_tmp23_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, "two", "value_of_two");
		_tmp24_ = _tmp23_;
		_vala_assert (!gee_collection_add ((GeeCollection*) _tmp22_, (GeeMapEntry*) _tmp24_), "! entries.add (new TestEntry<string,string> (\"two\", \"value_of_two\"))");
		_g_object_unref0 (_tmp24_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr ("*code should not be reached*");
	_tmp25_ = self->test_map;
	gee_map_set (_tmp25_, "two", "value_of_two");
	_tmp26_ = entries;
	_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_ == 2, "entries.size == 2");
	_tmp29_ = entries;
	_tmp30_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, "one", "value_of_one");
	_tmp31_ = _tmp30_;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp29_, (GeeMapEntry*) _tmp31_), "entries.contains (new TestEntry<string,string> (\"one\", \"value_of_one\"))");
	_g_object_unref0 (_tmp31_);
	_tmp32_ = entries;
	_tmp33_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, "two", "value_of_two");
	_tmp34_ = _tmp33_;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp32_, (GeeMapEntry*) _tmp34_), "entries.contains (new TestEntry<string,string> (\"two\", \"value_of_two\"))");
	_g_object_unref0 (_tmp34_);
	_tmp35_ = self->test_map;
	_tmp36_ = gee_map_get_entries (_tmp35_);
	_tmp37_ = _tmp36_;
	_g_object_unref0 (entries);
	entries = _tmp37_;
	_tmp38_ = entries;
	_tmp39_ = gee_collection_get_size ((GeeCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	_vala_assert (_tmp40_ == 2, "entries.size == 2");
	_tmp41_ = entries;
	_tmp42_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, "one", "value_of_one");
	_tmp43_ = _tmp42_;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp41_, (GeeMapEntry*) _tmp43_), "entries.contains (new TestEntry<string,string> (\"one\", \"value_of_one\"))");
	_g_object_unref0 (_tmp43_);
	_tmp44_ = entries;
	_tmp45_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, "two", "value_of_two");
	_tmp46_ = _tmp45_;
	_vala_assert (gee_collection_contains ((GeeCollection*) _tmp44_, (GeeMapEntry*) _tmp46_), "entries.contains (new TestEntry<string,string> (\"two\", \"value_of_two\"))");
	_g_object_unref0 (_tmp46_);
	_tmp47_ = self->test_map;
	gee_map_clear (_tmp47_);
	_tmp48_ = entries;
	_tmp49_ = gee_collection_get_size ((GeeCollection*) _tmp48_);
	_tmp50_ = _tmp49_;
	_vala_assert (_tmp50_ == 0, "entries.size == 0");
	_tmp51_ = self->test_map;
	_tmp52_ = gee_map_get_entries (_tmp51_);
	_tmp53_ = _tmp52_;
	_g_object_unref0 (entries);
	entries = _tmp53_;
	_tmp54_ = entries;
	_tmp55_ = gee_collection_get_size ((GeeCollection*) _tmp54_);
	_tmp56_ = _tmp55_;
	_vala_assert (_tmp56_ == 0, "entries.size == 0");
	_g_object_unref0 (entries);
}

static void
map_tests_test_entry_weak_pointer_lifetime (MapTests* self)
{
	GeeMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_map;
	gee_map_set (_tmp0_, "1337", "Badger");
	{
		GeeIterator* _entry_it = NULL;
		GeeMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->test_map;
		_tmp2_ = gee_map_get_entries (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_entry_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GeeMapEntry* _tmp10_;
			gconstpointer _tmp11_;
			const gchar* _tmp12_;
			_tmp7_ = _entry_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _entry_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			entry = (GeeMapEntry*) _tmp9_;
			_tmp10_ = entry;
			_tmp11_ = gee_map_entry_get_value (_tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 ((const gchar*) _tmp12_, "Badger") == 0) {
				GeeMap* _tmp13_;
				GeeMapEntry* _tmp14_;
				gconstpointer _tmp15_;
				const gchar* _tmp16_;
				_tmp13_ = self->test_map;
				_tmp14_ = entry;
				_tmp15_ = gee_map_entry_get_key (_tmp14_);
				_tmp16_ = _tmp15_;
				gee_map_unset (_tmp13_, (const gchar*) _tmp16_, NULL);
				_g_object_unref0 (entry);
				break;
			}
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}

void
map_tests_test_clear (MapTests* self)
{
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeeSet* keys = NULL;
	GeeMap* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	GeeIterator* ikeys = NULL;
	GeeIterator* _tmp10_;
	GeeCollection* vals = NULL;
	GeeMap* _tmp11_;
	GeeCollection* _tmp12_;
	GeeCollection* _tmp13_;
	GeeIterator* ivals = NULL;
	GeeIterator* _tmp14_;
	GeeSet* ents = NULL;
	GeeMap* _tmp15_;
	GeeSet* _tmp16_;
	GeeSet* _tmp17_;
	GeeIterator* ients = NULL;
	GeeIterator* _tmp18_;
	GeeMapIterator* iter = NULL;
	GeeMap* _tmp19_;
	GeeMapIterator* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_map;
	gee_map_set (_tmp0_, "one", "value_of_one");
	_tmp1_ = self->test_map;
	gee_map_set (_tmp1_, "two", "value_of_two");
	_tmp2_ = self->test_map;
	gee_map_set (_tmp2_, "three", "value_of_three");
	_tmp3_ = self->test_map;
	gee_map_clear (_tmp3_);
	_tmp4_ = self->test_map;
	_tmp5_ = gee_map_get_size (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_ == 0, "test_map.size == 0");
	_tmp7_ = self->test_map;
	_tmp8_ = gee_map_get_keys (_tmp7_);
	_tmp9_ = _tmp8_;
	keys = _tmp9_;
	_vala_assert (keys != NULL, "keys != null");
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) keys);
	ikeys = _tmp10_;
	_vala_assert (ikeys != NULL, "ikeys != null");
	_vala_assert (!gee_iterator_has_next (ikeys), "!ikeys.has_next ()");
	_tmp11_ = self->test_map;
	_tmp12_ = gee_map_get_values (_tmp11_);
	_tmp13_ = _tmp12_;
	vals = _tmp13_;
	_vala_assert (vals != NULL, "vals != null");
	_tmp14_ = gee_iterable_iterator ((GeeIterable*) vals);
	ivals = _tmp14_;
	_vala_assert (ivals != NULL, "ivals != null");
	_vala_assert (!gee_iterator_has_next (ivals), "!ivals.has_next ()");
	_tmp15_ = self->test_map;
	_tmp16_ = gee_map_get_entries (_tmp15_);
	_tmp17_ = _tmp16_;
	ents = _tmp17_;
	_vala_assert (ents != NULL, "ents != null");
	_tmp18_ = gee_iterable_iterator ((GeeIterable*) ents);
	ients = _tmp18_;
	_vala_assert (ients != NULL, "ients != null");
	_vala_assert (!gee_iterator_has_next (ients), "!ients.has_next ()");
	_tmp19_ = self->test_map;
	_tmp20_ = gee_map_map_iterator (_tmp19_);
	iter = _tmp20_;
	_vala_assert (iter != NULL, "iter != null");
	_vala_assert (!gee_map_iterator_has_next (iter), "!iter.has_next ()");
	_g_object_unref0 (iter);
	_g_object_unref0 (ients);
	_g_object_unref0 (ents);
	_g_object_unref0 (ivals);
	_g_object_unref0 (vals);
	_g_object_unref0 (ikeys);
	_g_object_unref0 (keys);
}

void
map_tests_test_set_all (MapTests* self)
{
	GeeHashMap* another_map = NULL;
	GeeHashMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	GeeMap* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeMap* _tmp8_;
	GeeMap* _tmp9_;
	GeeMap* _tmp10_;
	GeeMap* _tmp11_;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	GeeMap* _tmp14_;
	gpointer _tmp15_;
	gchar* _tmp16_;
	GeeMap* _tmp17_;
	gpointer _tmp18_;
	gchar* _tmp19_;
	GeeMap* _tmp20_;
	gpointer _tmp21_;
	gchar* _tmp22_;
	GeeMap* _tmp23_;
	gpointer _tmp24_;
	gchar* _tmp25_;
	GeeMap* _tmp26_;
	gpointer _tmp27_;
	gchar* _tmp28_;
	GeeMap* _tmp29_;
	gpointer _tmp30_;
	gchar* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	another_map = _tmp0_;
	_tmp1_ = self->test_map;
	gee_map_set (_tmp1_, "one", "value_of_one");
	_tmp2_ = self->test_map;
	gee_map_set (_tmp2_, "two", "value_of_two");
	_tmp3_ = self->test_map;
	gee_map_set (_tmp3_, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "five", "value_of_five");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "six", "value_of_six");
	_tmp4_ = self->test_map;
	gee_map_set_all (_tmp4_, (GeeMap*) another_map);
	_tmp5_ = self->test_map;
	_tmp6_ = gee_map_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_ == 6, "test_map.size == 6");
	_tmp8_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp8_, "one"), "test_map.has_key (\"one\")");
	_tmp9_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp9_, "two"), "test_map.has_key (\"two\")");
	_tmp10_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp10_, "three"), "test_map.has_key (\"three\")");
	_tmp11_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp11_, "four"), "test_map.has_key (\"four\")");
	_tmp12_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp12_, "five"), "test_map.has_key (\"five\")");
	_tmp13_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp13_, "six"), "test_map.has_key (\"six\")");
	_tmp14_ = self->test_map;
	_tmp15_ = gee_map_get (_tmp14_, "one");
	_tmp16_ = (gchar*) _tmp15_;
	_vala_assert (g_strcmp0 (_tmp16_, "value_of_one") == 0, "test_map.get (\"one\") == \"value_of_one\"");
	_g_free0 (_tmp16_);
	_tmp17_ = self->test_map;
	_tmp18_ = gee_map_get (_tmp17_, "two");
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (g_strcmp0 (_tmp19_, "value_of_two") == 0, "test_map.get (\"two\") == \"value_of_two\"");
	_g_free0 (_tmp19_);
	_tmp20_ = self->test_map;
	_tmp21_ = gee_map_get (_tmp20_, "three");
	_tmp22_ = (gchar*) _tmp21_;
	_vala_assert (g_strcmp0 (_tmp22_, "value_of_three") == 0, "test_map.get (\"three\") == \"value_of_three\"");
	_g_free0 (_tmp22_);
	_tmp23_ = self->test_map;
	_tmp24_ = gee_map_get (_tmp23_, "four");
	_tmp25_ = (gchar*) _tmp24_;
	_vala_assert (g_strcmp0 (_tmp25_, "value_of_four") == 0, "test_map.get (\"four\") == \"value_of_four\"");
	_g_free0 (_tmp25_);
	_tmp26_ = self->test_map;
	_tmp27_ = gee_map_get (_tmp26_, "five");
	_tmp28_ = (gchar*) _tmp27_;
	_vala_assert (g_strcmp0 (_tmp28_, "value_of_five") == 0, "test_map.get (\"five\") == \"value_of_five\"");
	_g_free0 (_tmp28_);
	_tmp29_ = self->test_map;
	_tmp30_ = gee_map_get (_tmp29_, "six");
	_tmp31_ = (gchar*) _tmp30_;
	_vala_assert (g_strcmp0 (_tmp31_, "value_of_six") == 0, "test_map.get (\"six\") == \"value_of_six\"");
	_g_free0 (_tmp31_);
	_g_object_unref0 (another_map);
}

void
map_tests_test_unset_all (MapTests* self)
{
	GeeHashMap* another_map = NULL;
	GeeHashMap* _tmp0_;
	GeeMap* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GeeMap* _tmp6_;
	GeeMap* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GeeMap* _tmp18_;
	GeeMap* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GeeMap* _tmp24_;
	GeeMap* _tmp25_;
	GeeMap* _tmp26_;
	GeeMap* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GeeMap* _tmp32_;
	GeeMap* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	GeeMap* _tmp38_;
	GeeMap* _tmp39_;
	GeeMap* _tmp40_;
	GeeMap* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	GeeMap* _tmp46_;
	GeeMap* _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GeeMap* _tmp52_;
	GeeMap* _tmp53_;
	GeeMap* _tmp54_;
	GeeMap* _tmp55_;
	GeeMap* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	GeeMap* _tmp61_;
	GeeMap* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	GeeMap* _tmp67_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	another_map = _tmp0_;
	_tmp1_ = self->test_map;
	_tmp2_ = gee_map_get_is_empty (_tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_, "test_map.is_empty");
	_tmp4_ = gee_map_get_is_empty ((GeeMap*) another_map);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_, "another_map.is_empty");
	_tmp6_ = self->test_map;
	_vala_assert (!gee_map_unset_all (_tmp6_, (GeeMap*) another_map), "! test_map.unset_all (another_map)");
	_tmp7_ = self->test_map;
	_tmp8_ = gee_map_get_is_empty (_tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_, "test_map.is_empty");
	_tmp10_ = gee_map_get_is_empty ((GeeMap*) another_map);
	_tmp11_ = _tmp10_;
	_vala_assert (_tmp11_, "another_map.is_empty");
	_tmp12_ = self->test_map;
	gee_map_clear (_tmp12_);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	_tmp13_ = self->test_map;
	_tmp14_ = gee_map_get_is_empty (_tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_, "test_map.is_empty");
	_tmp16_ = gee_abstract_map_get_size ((GeeAbstractMap*) another_map);
	_tmp17_ = _tmp16_;
	_vala_assert (_tmp17_ == 2, "another_map.size == 2");
	_tmp18_ = self->test_map;
	_vala_assert (!gee_map_unset_all (_tmp18_, (GeeMap*) another_map), "! test_map.unset_all (another_map)");
	_tmp19_ = self->test_map;
	_tmp20_ = gee_map_get_is_empty (_tmp19_);
	_tmp21_ = _tmp20_;
	_vala_assert (_tmp21_, "test_map.is_empty");
	_tmp22_ = gee_abstract_map_get_size ((GeeAbstractMap*) another_map);
	_tmp23_ = _tmp22_;
	_vala_assert (_tmp23_ == 2, "another_map.size == 2");
	_tmp24_ = self->test_map;
	gee_map_clear (_tmp24_);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	_tmp25_ = self->test_map;
	gee_map_set (_tmp25_, "one", "value_of_one");
	_tmp26_ = self->test_map;
	gee_map_set (_tmp26_, "two", "value_of_two");
	_tmp27_ = self->test_map;
	_tmp28_ = gee_map_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	_vala_assert (_tmp29_ == 2, "test_map.size == 2");
	_tmp30_ = gee_map_get_is_empty ((GeeMap*) another_map);
	_tmp31_ = _tmp30_;
	_vala_assert (_tmp31_, "another_map.is_empty");
	_tmp32_ = self->test_map;
	_vala_assert (!gee_map_unset_all (_tmp32_, (GeeMap*) another_map), "! test_map.unset_all (another_map)");
	_tmp33_ = self->test_map;
	_tmp34_ = gee_map_get_size (_tmp33_);
	_tmp35_ = _tmp34_;
	_vala_assert (_tmp35_ == 2, "test_map.size == 2");
	_tmp36_ = gee_map_get_is_empty ((GeeMap*) another_map);
	_tmp37_ = _tmp36_;
	_vala_assert (_tmp37_, "another_map.is_empty");
	_tmp38_ = self->test_map;
	gee_map_clear (_tmp38_);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	_tmp39_ = self->test_map;
	gee_map_set (_tmp39_, "one", "value_of_one");
	_tmp40_ = self->test_map;
	gee_map_set (_tmp40_, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	_tmp41_ = self->test_map;
	_tmp42_ = gee_map_get_size (_tmp41_);
	_tmp43_ = _tmp42_;
	_vala_assert (_tmp43_ == 2, "test_map.size == 2");
	_tmp44_ = gee_abstract_map_get_size ((GeeAbstractMap*) another_map);
	_tmp45_ = _tmp44_;
	_vala_assert (_tmp45_ == 2, "another_map.size == 2");
	_tmp46_ = self->test_map;
	_vala_assert (gee_map_unset_all (_tmp46_, (GeeMap*) another_map), "test_map.unset_all (another_map)");
	_tmp47_ = self->test_map;
	_tmp48_ = gee_map_get_is_empty (_tmp47_);
	_tmp49_ = _tmp48_;
	_vala_assert (_tmp49_, "test_map.is_empty");
	_tmp50_ = gee_abstract_map_get_size ((GeeAbstractMap*) another_map);
	_tmp51_ = _tmp50_;
	_vala_assert (_tmp51_ == 2, "another_map.size == 2");
	_tmp52_ = self->test_map;
	gee_map_clear (_tmp52_);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	_tmp53_ = self->test_map;
	gee_map_set (_tmp53_, "one", "value_of_one");
	_tmp54_ = self->test_map;
	gee_map_set (_tmp54_, "two", "value_of_two");
	_tmp55_ = self->test_map;
	gee_map_set (_tmp55_, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "five", "value_of_five");
	_tmp56_ = self->test_map;
	_tmp57_ = gee_map_get_size (_tmp56_);
	_tmp58_ = _tmp57_;
	_vala_assert (_tmp58_ == 3, "test_map.size == 3");
	_tmp59_ = gee_abstract_map_get_size ((GeeAbstractMap*) another_map);
	_tmp60_ = _tmp59_;
	_vala_assert (_tmp60_ == 4, "another_map.size == 4");
	_tmp61_ = self->test_map;
	_vala_assert (gee_map_unset_all (_tmp61_, (GeeMap*) another_map), "test_map.unset_all (another_map)");
	_tmp62_ = self->test_map;
	_tmp63_ = gee_map_get_size (_tmp62_);
	_tmp64_ = _tmp63_;
	_vala_assert (_tmp64_ == 1, "test_map.size == 1");
	_tmp65_ = gee_abstract_map_get_size ((GeeAbstractMap*) another_map);
	_tmp66_ = _tmp65_;
	_vala_assert (_tmp66_ == 4, "another_map.size == 4");
	_tmp67_ = self->test_map;
	_vala_assert (gee_map_has_key (_tmp67_, "one"), "test_map.has_key (\"one\")");
	_g_object_unref0 (another_map);
}

void
map_tests_test_has_all (MapTests* self)
{
	GeeHashMap* another_map = NULL;
	GeeHashMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	GeeMap* _tmp5_;
	GeeMap* _tmp6_;
	GeeMap* _tmp7_;
	GeeMap* _tmp8_;
	GeeMap* _tmp9_;
	GeeMap* _tmp10_;
	GeeMap* _tmp11_;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	GeeMap* _tmp14_;
	GeeMap* _tmp15_;
	GeeMap* _tmp16_;
	GeeMap* _tmp17_;
	GeeMap* _tmp18_;
	GeeMap* _tmp19_;
	GeeMap* _tmp20_;
	GeeMap* _tmp21_;
	GeeMap* _tmp22_;
	GeeMap* _tmp23_;
	GeeMap* _tmp24_;
	GeeMap* _tmp25_;
	GeeMap* _tmp26_;
	GeeMap* _tmp27_;
	GeeMap* _tmp28_;
	GeeMap* _tmp29_;
	GeeMap* _tmp30_;
	GeeMap* _tmp31_;
	GeeMap* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	another_map = _tmp0_;
	_tmp1_ = self->test_map;
	_vala_assert (gee_map_has_all (_tmp1_, (GeeMap*) another_map), "test_map.has_all (another_map)");
	_tmp2_ = self->test_map;
	gee_map_set (_tmp2_, "one", "value_of_one");
	_tmp3_ = self->test_map;
	_vala_assert (gee_map_has_all (_tmp3_, (GeeMap*) another_map), "test_map.has_all (another_map)");
	_tmp4_ = self->test_map;
	gee_map_clear (_tmp4_);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	_tmp5_ = self->test_map;
	_vala_assert (!gee_map_has_all (_tmp5_, (GeeMap*) another_map), "! test_map.has_all (another_map)");
	_tmp6_ = self->test_map;
	gee_map_clear (_tmp6_);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	_tmp7_ = self->test_map;
	gee_map_set (_tmp7_, "one", "value_of_one");
	_tmp8_ = self->test_map;
	gee_map_set (_tmp8_, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	_tmp9_ = self->test_map;
	_vala_assert (gee_map_has_all (_tmp9_, (GeeMap*) another_map), "test_map.has_all (another_map)");
	_tmp10_ = self->test_map;
	gee_map_clear (_tmp10_);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	_tmp11_ = self->test_map;
	gee_map_set (_tmp11_, "one", "value_of_one");
	_tmp12_ = self->test_map;
	gee_map_set (_tmp12_, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "another_value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "another_value_of_two");
	_tmp13_ = self->test_map;
	_vala_assert (!gee_map_has_all (_tmp13_, (GeeMap*) another_map), "! test_map.has_all (another_map)");
	_tmp14_ = self->test_map;
	gee_map_clear (_tmp14_);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	_tmp15_ = self->test_map;
	gee_map_set (_tmp15_, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	_tmp16_ = self->test_map;
	_vala_assert (!gee_map_has_all (_tmp16_, (GeeMap*) another_map), "! test_map.has_all (another_map)");
	_tmp17_ = self->test_map;
	gee_map_clear (_tmp17_);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	_tmp18_ = self->test_map;
	gee_map_set (_tmp18_, "one", "value_of_one");
	_tmp19_ = self->test_map;
	gee_map_set (_tmp19_, "two", "value_of_two");
	_tmp20_ = self->test_map;
	gee_map_set (_tmp20_, "three", "value_of_three");
	_tmp21_ = self->test_map;
	gee_map_set (_tmp21_, "four", "value_of_four");
	_tmp22_ = self->test_map;
	gee_map_set (_tmp22_, "five", "value_of_five");
	_tmp23_ = self->test_map;
	gee_map_set (_tmp23_, "six", "value_of_six");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	_tmp24_ = self->test_map;
	_vala_assert (gee_map_has_all (_tmp24_, (GeeMap*) another_map), "test_map.has_all (another_map)");
	_tmp25_ = self->test_map;
	gee_map_clear (_tmp25_);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	_tmp26_ = self->test_map;
	gee_map_set (_tmp26_, "one", "value_of_one");
	_tmp27_ = self->test_map;
	gee_map_set (_tmp27_, "two", "value_of_two");
	_tmp28_ = self->test_map;
	gee_map_set (_tmp28_, "three", "value_of_three");
	_tmp29_ = self->test_map;
	gee_map_set (_tmp29_, "four", "value_of_four");
	_tmp30_ = self->test_map;
	gee_map_set (_tmp30_, "five", "value_of_five");
	_tmp31_ = self->test_map;
	gee_map_set (_tmp31_, "six", "value_of_six");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "height", "value_of_height");
	_tmp32_ = self->test_map;
	_vala_assert (!gee_map_has_all (_tmp32_, (GeeMap*) another_map), "! test_map.has_all (another_map)");
	_g_object_unref0 (another_map);
}

void
map_tests_test_gobject_properties (MapTests* self)
{
	GeeMap* _tmp0_;
	GValue value = {0};
	GValue _tmp1_ = {0};
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_map;
	_vala_assert (_tmp0_ != NULL, "test_map != null");
	g_value_init (&_tmp1_, G_TYPE_INT);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp1_;
	_tmp2_ = self->test_map;
	g_object_get_property ((GObject*) _tmp2_, "size", &value);
	_tmp3_ = self->test_map;
	_tmp4_ = gee_map_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (g_value_get_int (&value) == _tmp5_, "value.get_int () == test_map.size");
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}

static gint
__lambda50_ (MapTests* self,
             const gchar* x,
             const gchar* y,
             gint z)
{
	gint result = 0;
	g_return_val_if_fail (x != NULL, 0);
	g_return_val_if_fail (y != NULL, 0);
	result = z + 1;
	return result;
}

static gpointer
___lambda50__gee_fold_map_func (gconstpointer k,
                                gconstpointer v,
                                gpointer a,
                                gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda50_ ((MapTests*) self, (const gchar*) k, (const gchar*) v, (gint) ((gintptr) a)));
	return result;
}

static gint
__lambda51_ (MapTests* self,
             const gchar* x,
             const gchar* y,
             gint z)
{
	gint result = 0;
	g_return_val_if_fail (x != NULL, 0);
	g_return_val_if_fail (y != NULL, 0);
	result = z + 1;
	return result;
}

static gpointer
___lambda51__gee_fold_map_func (gconstpointer k,
                                gconstpointer v,
                                gpointer a,
                                gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda51_ ((MapTests*) self, (const gchar*) k, (const gchar*) v, (gint) ((gintptr) a)));
	return result;
}

void
map_tests_test_fold (MapTests* self)
{
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	gint count = 0;
	GeeMap* _tmp3_;
	GeeMapIterator* _tmp4_;
	GeeMapIterator* _tmp5_;
	gpointer _tmp6_;
	GeeMapIterator* iter = NULL;
	GeeMap* _tmp7_;
	GeeMapIterator* _tmp8_;
	gpointer _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_map;
	gee_map_set (_tmp0_, "one", "one");
	_tmp1_ = self->test_map;
	gee_map_set (_tmp1_, "two", "two");
	_tmp2_ = self->test_map;
	gee_map_set (_tmp2_, "three", "three");
	_tmp3_ = self->test_map;
	_tmp4_ = gee_map_map_iterator (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_map_iterator_fold (_tmp5_, G_TYPE_INT, NULL, NULL, ___lambda50__gee_fold_map_func, self, (gpointer) ((gintptr) 0));
	count = (gint) ((gintptr) _tmp6_);
	_g_object_unref0 (_tmp5_);
	_vala_assert (count == 3, "count == 3");
	_tmp7_ = self->test_map;
	_tmp8_ = gee_map_map_iterator (_tmp7_);
	iter = _tmp8_;
	_vala_assert (gee_map_iterator_next (iter), "iter.next ()");
	_tmp9_ = gee_map_iterator_fold (iter, G_TYPE_INT, NULL, NULL, ___lambda51__gee_fold_map_func, self, (gpointer) ((gintptr) 0));
	count = (gint) ((gintptr) _tmp9_);
	_vala_assert (count == 3, "count == 3");
	_g_object_unref0 (iter);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		MapTests* self;
		self = _data12_->self;
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
__lambda52_ (Block12Data* _data12_,
             const gchar* x,
             const gchar* y)
{
	MapTests* self;
	gboolean result = FALSE;
	gint _tmp0_;
	self = _data12_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	g_return_val_if_fail (y != NULL, FALSE);
	_tmp0_ = _data12_->count;
	_data12_->count = _tmp0_ + 1;
	result = TRUE;
	return result;
}

static gboolean
___lambda52__gee_forall_map_func (gconstpointer k,
                                  gconstpointer v,
                                  gpointer self)
{
	gboolean result;
	result = __lambda52_ (self, (const gchar*) k, (const gchar*) v);
	return result;
}

static gboolean
__lambda53_ (Block12Data* _data12_,
             const gchar* x,
             const gchar* y)
{
	MapTests* self;
	gboolean result = FALSE;
	gint _tmp0_;
	self = _data12_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	g_return_val_if_fail (y != NULL, FALSE);
	_tmp0_ = _data12_->count;
	_data12_->count = _tmp0_ + 1;
	result = TRUE;
	return result;
}

static gboolean
___lambda53__gee_forall_map_func (gconstpointer k,
                                  gconstpointer v,
                                  gpointer self)
{
	gboolean result;
	result = __lambda53_ (self, (const gchar*) k, (const gchar*) v);
	return result;
}

void
map_tests_test_foreach (MapTests* self)
{
	Block12Data* _data12_;
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeMapIterator* _tmp4_;
	GeeMapIterator* _tmp5_;
	GeeMapIterator* iter = NULL;
	GeeMap* _tmp6_;
	GeeMapIterator* _tmp7_;
	g_return_if_fail (self != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = self->test_map;
	gee_map_set (_tmp0_, "one", "one");
	_tmp1_ = self->test_map;
	gee_map_set (_tmp1_, "two", "two");
	_tmp2_ = self->test_map;
	gee_map_set (_tmp2_, "three", "three");
	_data12_->count = 0;
	_tmp3_ = self->test_map;
	_tmp4_ = gee_map_map_iterator (_tmp3_);
	_tmp5_ = _tmp4_;
	gee_map_iterator_foreach (_tmp5_, ___lambda52__gee_forall_map_func, _data12_);
	_g_object_unref0 (_tmp5_);
	_vala_assert (_data12_->count == 3, "count == 3");
	_tmp6_ = self->test_map;
	_tmp7_ = gee_map_map_iterator (_tmp6_);
	iter = _tmp7_;
	_vala_assert (gee_map_iterator_next (iter), "iter.next ()");
	gee_map_iterator_foreach (iter, ___lambda53__gee_forall_map_func, _data12_);
	_vala_assert (_data12_->count == 6, "count == 6");
	_g_object_unref0 (iter);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

GeeMapEntry*
map_tests_entry_for (const gchar* key,
                     const gchar* value)
{
	GeeMapEntry* result = NULL;
	MapTestsTestEntry* _tmp0_;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, key, value);
	result = (GeeMapEntry*) _tmp0_;
	return result;
}

gboolean
map_tests_check_entry (GeeMapEntry* e,
                       const gchar* key,
                       const gchar* value)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (e != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp1_ = gee_map_entry_get_key (e);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 ((const gchar*) _tmp2_, key) == 0) {
		gconstpointer _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = gee_map_entry_get_value (e);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 ((const gchar*) _tmp4_, value) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	_g_object_unref0 (e);
	return result;
}

void
map_tests_assert_entry (GeeMapEntry* e,
                        const gchar* key,
                        const gchar* value)
{
	gconstpointer _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (e != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = gee_map_entry_get_key (e);
	_tmp1_ = _tmp0_;
	_vala_assert (g_strcmp0 ((const gchar*) _tmp1_, key) == 0, "e.key == key");
	_tmp2_ = gee_map_entry_get_value (e);
	_tmp3_ = _tmp2_;
	_vala_assert (g_strcmp0 ((const gchar*) _tmp3_, value) == 0, "e.value == value");
}

static inline gpointer
map_tests_test_entry_get_instance_private (MapTestsTestEntry* self)
{
	return G_STRUCT_MEMBER_P (self, MapTestsTestEntry_private_offset);
}

static MapTestsTestEntry*
map_tests_test_entry_construct (GType object_type,
                                GType k_type,
                                GBoxedCopyFunc k_dup_func,
                                GDestroyNotify k_destroy_func,
                                GType v_type,
                                GBoxedCopyFunc v_dup_func,
                                GDestroyNotify v_destroy_func,
                                gconstpointer key,
                                gconstpointer value)
{
	MapTestsTestEntry * self = NULL;
	gpointer _tmp0_;
	self = (MapTestsTestEntry*) gee_map_entry_construct (object_type, k_type, (GBoxedCopyFunc) k_dup_func, (GDestroyNotify) k_destroy_func, v_type, (GBoxedCopyFunc) v_dup_func, (GDestroyNotify) v_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	_tmp0_ = ((key != NULL) && (k_dup_func != NULL)) ? k_dup_func ((gpointer) key) : ((gpointer) key);
	_k_destroy_func0 (self->priv->_key);
	self->priv->_key = _tmp0_;
	gee_map_entry_set_value ((GeeMapEntry*) self, value);
	return self;
}

static MapTestsTestEntry*
map_tests_test_entry_new (GType k_type,
                          GBoxedCopyFunc k_dup_func,
                          GDestroyNotify k_destroy_func,
                          GType v_type,
                          GBoxedCopyFunc v_dup_func,
                          GDestroyNotify v_destroy_func,
                          gconstpointer key,
                          gconstpointer value)
{
	return map_tests_test_entry_construct (MAP_TESTS_TYPE_TEST_ENTRY, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, key, value);
}

static gconstpointer
map_tests_test_entry_real_get_key (GeeMapEntry* base)
{
	gconstpointer result;
	MapTestsTestEntry* self;
	gconstpointer _tmp0_;
	self = (MapTestsTestEntry*) base;
	_tmp0_ = self->priv->_key;
	result = _tmp0_;
	return result;
}

static gconstpointer
map_tests_test_entry_real_get_value (GeeMapEntry* base)
{
	gconstpointer result;
	MapTestsTestEntry* self;
	gconstpointer _tmp0_;
	self = (MapTestsTestEntry*) base;
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static void
map_tests_test_entry_real_set_value (GeeMapEntry* base,
                                     gconstpointer value)
{
	MapTestsTestEntry* self;
	self = (MapTestsTestEntry*) base;
	if (map_tests_test_entry_real_get_value (base) != value) {
		gpointer _tmp0_;
		_tmp0_ = ((value != NULL) && (self->priv->v_dup_func != NULL)) ? self->priv->v_dup_func ((gpointer) value) : ((gpointer) value);
		((self->priv->_value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->v_destroy_func (self->priv->_value), NULL));
		self->priv->_value = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, map_tests_test_entry_properties[MAP_TESTS_TEST_ENTRY_VALUE_PROPERTY]);
	}
}

static gboolean
map_tests_test_entry_real_get_read_only (GeeMapEntry* base)
{
	gboolean result;
	MapTestsTestEntry* self;
	self = (MapTestsTestEntry*) base;
	result = FALSE;
	return result;
}

static void
map_tests_test_entry_class_init (MapTestsTestEntryClass * klass,
                                 gpointer klass_data)
{
	map_tests_test_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MapTestsTestEntry_private_offset);
	GEE_MAP_ENTRY_CLASS (klass)->get_key = map_tests_test_entry_real_get_key;
	GEE_MAP_ENTRY_CLASS (klass)->get_value = map_tests_test_entry_real_get_value;
	GEE_MAP_ENTRY_CLASS (klass)->set_value = map_tests_test_entry_real_set_value;
	GEE_MAP_ENTRY_CLASS (klass)->get_read_only = map_tests_test_entry_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_map_tests_test_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_map_tests_test_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = map_tests_test_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_K_TYPE, g_param_spec_gtype ("k-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_K_DUP_FUNC, g_param_spec_pointer ("k-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_K_DESTROY_FUNC, g_param_spec_pointer ("k-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_V_TYPE, g_param_spec_gtype ("v-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_V_DUP_FUNC, g_param_spec_pointer ("v-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_V_DESTROY_FUNC, g_param_spec_pointer ("v-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_KEY_PROPERTY, map_tests_test_entry_properties[MAP_TESTS_TEST_ENTRY_KEY_PROPERTY] = g_param_spec_pointer ("key", "key", "key", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_VALUE_PROPERTY, map_tests_test_entry_properties[MAP_TESTS_TEST_ENTRY_VALUE_PROPERTY] = g_param_spec_pointer ("value", "value", "value", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_READ_ONLY_PROPERTY, map_tests_test_entry_properties[MAP_TESTS_TEST_ENTRY_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
map_tests_test_entry_instance_init (MapTestsTestEntry * self,
                                    gpointer klass)
{
	self->priv = map_tests_test_entry_get_instance_private (self);
}

static void
map_tests_test_entry_finalize (GObject * obj)
{
	MapTestsTestEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntry);
	((self->priv->_key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (self->priv->_key = (self->priv->k_destroy_func (self->priv->_key), NULL));
	((self->priv->_value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->v_destroy_func (self->priv->_value), NULL));
	G_OBJECT_CLASS (map_tests_test_entry_parent_class)->finalize (obj);
}

static GType
map_tests_test_entry_get_type (void)
{
	static volatile gsize map_tests_test_entry_type_id__volatile = 0;
	if (g_once_init_enter (&map_tests_test_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MapTestsTestEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) map_tests_test_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MapTestsTestEntry), 0, (GInstanceInitFunc) map_tests_test_entry_instance_init, NULL };
		GType map_tests_test_entry_type_id;
		map_tests_test_entry_type_id = g_type_register_static (GEE_MAP_TYPE_ENTRY, "MapTestsTestEntry", &g_define_type_info, 0);
		MapTestsTestEntry_private_offset = g_type_add_instance_private (map_tests_test_entry_type_id, sizeof (MapTestsTestEntryPrivate));
		g_once_init_leave (&map_tests_test_entry_type_id__volatile, map_tests_test_entry_type_id);
	}
	return map_tests_test_entry_type_id__volatile;
}

static void
_vala_map_tests_test_entry_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	MapTestsTestEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntry);
	switch (property_id) {
		case MAP_TESTS_TEST_ENTRY_KEY_PROPERTY:
		g_value_set_pointer (value, gee_map_entry_get_key ((GeeMapEntry*) self));
		break;
		case MAP_TESTS_TEST_ENTRY_VALUE_PROPERTY:
		g_value_set_pointer (value, gee_map_entry_get_value ((GeeMapEntry*) self));
		break;
		case MAP_TESTS_TEST_ENTRY_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_map_entry_get_read_only ((GeeMapEntry*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_map_tests_test_entry_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	MapTestsTestEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntry);
	switch (property_id) {
		case MAP_TESTS_TEST_ENTRY_VALUE_PROPERTY:
		gee_map_entry_set_value ((GeeMapEntry*) self, g_value_get_pointer (value));
		break;
		case MAP_TESTS_TEST_ENTRY_K_TYPE:
		self->priv->k_type = g_value_get_gtype (value);
		break;
		case MAP_TESTS_TEST_ENTRY_K_DUP_FUNC:
		self->priv->k_dup_func = g_value_get_pointer (value);
		break;
		case MAP_TESTS_TEST_ENTRY_K_DESTROY_FUNC:
		self->priv->k_destroy_func = g_value_get_pointer (value);
		break;
		case MAP_TESTS_TEST_ENTRY_V_TYPE:
		self->priv->v_type = g_value_get_gtype (value);
		break;
		case MAP_TESTS_TEST_ENTRY_V_DUP_FUNC:
		self->priv->v_dup_func = g_value_get_pointer (value);
		break;
		case MAP_TESTS_TEST_ENTRY_V_DESTROY_FUNC:
		self->priv->v_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
map_tests_class_init (MapTestsClass * klass,
                      gpointer klass_data)
{
	map_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = map_tests_finalize;
}

static void
map_tests_instance_init (MapTests * self,
                         gpointer klass)
{
}

static void
map_tests_finalize (GObject * obj)
{
	MapTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAP_TESTS, MapTests);
	_g_object_unref0 (self->test_map);
	G_OBJECT_CLASS (map_tests_parent_class)->finalize (obj);
}

GType
map_tests_get_type (void)
{
	static volatile gsize map_tests_type_id__volatile = 0;
	if (g_once_init_enter (&map_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MapTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) map_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MapTests), 0, (GInstanceInitFunc) map_tests_instance_init, NULL };
		GType map_tests_type_id;
		map_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "MapTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&map_tests_type_id__volatile, map_tests_type_id);
	}
	return map_tests_type_id__volatile;
}

