/**
 * @license
 * Copyright (C) 2010 The Libphonenumber Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generated metadata for file
 * ../resources/ShortNumberMetadata.xml
 * @author Nikolaos Trogkanis
 */

goog.provide('i18n.phonenumbers.shortnumbermetadata');

/**
 * A mapping from a country calling code to the region codes which denote the
 * region represented by that country calling code. In the case of multiple
 * countries sharing a calling code, such as the NANPA regions, the one
 * indicated with "isMainCountryForCode" in the metadata should be first.
 * @type {!Object.<number, Array.<string>>}
 */
i18n.phonenumbers.shortnumbermetadata.countryCodeToRegionCodeMap = {
0:["AC","AD","AE","AF","AG","AI","AL","AM","AO","AR","AS","AT","AU","AW","AX","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BL","BM","BN","BO","BQ","BR","BS","BT","BW","BY","BZ","CA","CC","CD","CF","CG","CH","CI","CK","CL","CM","CN","CO","CR","CU","CV","CW","CX","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG","EH","ER","ES","ET","FI","FJ","FK","FM","FO","FR","GA","GB","GD","GE","GF","GG","GH","GI","GL","GM","GN","GP","GR","GT","GU","GW","GY","HK","HN","HR","HT","HU","ID","IE","IL","IM","IN","IQ","IR","IS","IT","JE","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KY","KZ","LA","LB","LC","LI","LK","LR","LS","LT","LU","LV","LY","MA","MC","MD","ME","MF","MG","MH","MK","ML","MM","MN","MO","MP","MQ","MR","MS","MT","MU","MV","MW","MX","MY","MZ","NA","NC","NE","NF","NG","NI","NL","NO","NP","NR","NU","NZ","OM","PA","PE","PF","PG","PH","PK","PL","PM","PR","PS","PT","PW","PY","QA","RE","RO","RS","RU","RW","SA","SB","SC","SD","SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO","SR","ST","SV","SX","SY","SZ","TC","TD","TG","TH","TJ","TL","TM","TN","TO","TR","TT","TV","TW","TZ","UA","UG","US","UY","UZ","VA","VC","VE","VG","VI","VN","VU","WF","WS","XK","YE","YT","ZA","ZM","ZW"]
};

/**
 * A mapping from a region code to the PhoneMetadata for that region.
 * @type {!Object.<string, Array>}
 */
i18n.phonenumbers.shortnumbermetadata.countryToMetadata = {
"AC":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"AC",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"AD":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[0268]",,,,"110"]
,[,,,,,,,,,[-1]
]
,,,,"AD",,,,,,,,,,,,,,,,,,[,,"11[0268]",,,,"110"]
,,[,,"11[0268]",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"AE":[,[,,"[149]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"112|99[7-9]",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"AE",,,,,,,,,,,,,,,,,,[,,"112|99[7-9]",,,,"112",,,[3]
]
,,[,,"112|445[16]|99[7-9]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"445\\d",,,,"4450",,,[4]
]
]
,"AF":[,[,,"[14]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"1(?:02|19)",,,,"102",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"AF",,,,,,,,,,,,,,,,,,[,,"1(?:02|19)",,,,"102",,,[3]
]
,,[,,"1(?:02|19)|40404",,,,"102"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d",,,,"40400",,,[5]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"AG":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"AG",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"176|9(?:11|99)",,,,"176"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"AI":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"AI",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"176|911",,,,"176"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"AL":[,[,,"[15]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:1(?:2|6[01]\\d\\d)|2[7-9]|3[15]|41)",,,,"112",,,[3,6]
]
,[,,"5\\d{4}",,,,"50000",,,[5]
]
,,,,"AL",,,,,,,,,,,,,,,,,,[,,"1(?:12|2[7-9])",,,,"112",,,[3]
]
,,[,,"1(?:1(?:6(?:000|1(?:06|11|23))|8\\d\\d)|65\\d|89[12])|5\\d{4}|1(?:[1349]\\d|2[2-9])",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,"123",,,,"123",,,[3]
]
,,[,,"131|5\\d{4}",,,,"131",,,[3,5]
]
]
,"AM":[,[,,"[148]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"10[1-3]",,,,"101",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"AM",,,,,,,,,,,,,,,,,,[,,"10[1-3]",,,,"101",,,[3]
]
,,[,,"(?:1|8[1-7])\\d\\d|40404",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d",,,,"40400",,,[5]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"AO":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[235]",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"AO",,,,,,,,,,,,,,,,,,[,,"11[235]",,,,"112"]
,,[,,"11[235]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"AR":[,[,,"[01389]\\d{1,4}",,,,,,,[2,3,4,5]
]
,,,[,,"000|1(?:0[0-35-7]|1[0245]|2[15]|9)|911",,,,"19",,,[2,3]
]
,[,,,,,,,,,[-1]
]
,,,,"AR",,,,,,,,,,,,,,,,,,[,,"10[017]|911",,,,"100",,,[3]
]
,,[,,"000|1(?:0[0-35-7]|1[02-5]|2[15]|9)|3372|89338|911",,,,"19"]
,[,,,,,,,,,[-1]
]
,[,,"893\\d\\d",,,,"89300",,,[5]
]
,,[,,"(?:337|893\\d)\\d",,,,"3370",,,[4,5]
]
]
,"AS":[,[,,"[49]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"911",,,,"911",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"AS",,,,,,,,,,,,,,,,,,[,,"911",,,,"911",,,[3]
]
,,[,,"40404|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"AT":[,[,,"1\\d\\d(?:\\d{3})?",,,,,,,[3,6]
]
,,,[,,"116\\d{3}|1(?:[12]2|33|44)",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"AT",,,,,,,,,,,,,,,,,,[,,"1(?:[12]2|33|44)",,,,"112",,,[3]
]
,,[,,"116(?:00[06]|1(?:17|23))|1(?:[12]2|33|44)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"AU":[,[,,"[0-27]\\d{2,7}",,,,,,,[3,4,5,6,7,8]
]
,,,[,,"000|1(?:06|12|258885|55\\d)|733",,,,"000",,,[3,4,7]
]
,[,,"1(?:2(?:34|456)|9\\d{4,6})",,,,"1234",,,[4,5,6,7,8]
]
,,,,"AU",,,,,,,,,,,,,,,,,,[,,"000|1(?:06|12)",,,,"000",,,[3]
]
,,[,,"000|1(?:06|1(?:00|2|9[46])|2(?:[23]\\d|(?:4|5\\d)\\d{2,3}|8(?:[013-9]\\d|2))|555|9\\d{4,6})|225|7(?:33|67)",,,,"000"]
,[,,"1(?:1[09]\\d|24733)|225|767",,,,"225",,,[3,4,6]
]
,[,,"1(?:258885|55\\d)",,,,"1550",,,[4,7]
]
,,[,,"19\\d{4,6}",,,,"190000",,,[6,7,8]
]
]
,"AW":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"100|911",,,,"100"]
,[,,,,,,,,,[-1]
]
,,,,"AW",,,,,,,,,,,,,,,,,,[,,"100|911",,,,"100"]
,,[,,"1(?:00|76)|911",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"AX":[,[,,"[17]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"112",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"AX",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"112|75[12]\\d\\d",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"AZ":[,[,,"[148]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:0[1-3]|12)",,,,"101",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"AZ",,,,,,,,,,,,,,,,,,[,,"1(?:0[1-3]|12)",,,,"101",,,[3]
]
,,[,,"1(?:0[1-3]|12)|(?:404|880)0",,,,"101"]
,[,,,,,,,,,[-1]
]
,[,,"(?:404|880)\\d",,,,"4040",,,[4]
]
,,[,,"(?:404|880)\\d",,,,"4040",,,[4]
]
]
,"BA":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:16\\d{3}|2[2-4])",,,,"122",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"BA",,,,,,,,,,,,,,,,,,[,,"12[2-4]",,,,"122",,,[3]
]
,,[,,"1(?:16(?:00[06]|1(?:1[17]|23))|2(?:0[0-7]|[2-5]|6[0-26])|(?:[3-5]|7\\d)\\d\\d)|1(?:18|2[78])\\d\\d?",,,,"122"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BB":[,[,,"[2-689]\\d\\d",,,,,,,[3]
]
,,,[,,"[2359]11",,,,"211"]
,[,,,,,,,,,[-1]
]
,,,,"BB",,,,,,,,,,,,,,,,,,[,,"[2359]11",,,,"211"]
,,[,,"[2-689]11",,,,"211"]
,[,,,,,,,,,[-1]
]
,[,,"[468]11",,,,"411"]
,,[,,,,,,,,,[-1]
]
]
,"BD":[,[,,"[1579]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"10[0-26]|[19]99",,,,"100",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"BD",,,,,,,,,,,,,,,,,,[,,"10[0-2]|[19]99",,,,"100",,,[3]
]
,,[,,"1(?:0(?:[0-369]|5[1-4]|7[0-4]|8[0-29])|1[16-9]|2(?:[134]|2[0-5])|3(?:1\\d?|6[3-6])|5[2-9])|5012|786|9594|[19]99|1(?:0(?:50|6\\d)|33|4(?:0|1\\d))\\d",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"1(?:11|2[13])|(?:501|959)\\d|786",,,,"111",,,[3,4]
]
,,[,,"959\\d",,,,"9590",,,[4]
]
]
,"BE":[,[,,"[1-9]\\d\\d(?:\\d(?:\\d{2})?)?",,,,,,,[3,4,6]
]
,,,[,,"1(?:0[0-25-8]|1[02]|7(?:12|77)|813)|(?:116|8)\\d{3}",,,,"100"]
,[,,"1(?:2[03]|40)4|(?:1(?:[24]1|3[01])|[2-79]\\d\\d)\\d",,,,"1204",,,[4]
]
,,,,"BE",,,,,,,,,,,,,,,,,,[,,"1(?:0[01]|12)",,,,"100",,,[3]
]
,,[,,"1(?:0[0-8]|1(?:[027]|6117)|2(?:12|3[0-24])|313|414|5(?:1[05]|5[15]|66|95)|6(?:1[167]|36|6[16])|7(?:0[07]|1[27-9]|22|33|65|7[017])|81[39])|[2-9]\\d{3}|1(?:1600|45)0|1(?:[2-4]9|78)9|1[2-4]0[47]",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"[2-9]\\d{3}",,,,"2000",,,[4]
]
]
,"BF":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,,,,"BF",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17"]
,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BG":[,[,,"1\\d\\d(?:\\d{3})?",,,,,,,[3,6]
]
,,,[,,"1(?:1(?:2|6\\d{3})|50|6[06])",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"BG",,,,,,,,,,,,,,,,,,[,,"1(?:12|50|6[06])",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:000|111))|50|6[06])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BH":[,[,,"[0189]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"(?:0[167]|81)\\d{3}|[19]99",,,,"199"]
,[,,"9[148]\\d{3}",,,,"91000",,,[5]
]
,,,,"BH",,,,,,,,,,,,,,,,,,[,,"[19]99",,,,"199",,,[3]
]
,,[,,"1(?:[02]\\d|12|4[01]|51|8[18]|9[169])|99[02489]|(?:0[167]|8[158]|9[148])\\d{3}",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"0[67]\\d{3}|88000|98555",,,,"06000",,,[5]
]
,,[,,"88000|98555",,,,"88000",,,[5]
]
]
,"BI":[,[,,"[16-9]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"11[237]|611",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"BI",,,,,,,,,,,,,,,,,,[,,"11[237]",,,,"112",,,[3]
]
,,[,,"1(?:1\\d|5[2-9]|6[0-256])|611|7(?:10|77|979)|8[28]8|900",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,"611|7(?:10|77)|888|900",,,,"611",,,[3]
]
,,[,,"(?:71|90)0",,,,"710",,,[3]
]
]
,"BJ":[,[,,"[17]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"11[78]|7[3-5]\\d\\d",,,,"117"]
,[,,,,,,,,,[-1]
]
,,,,"BJ",,,,,,,,,,,,,,,,,,[,,"11[78]",,,,"117",,,[3]
]
,,[,,"1(?:1[78]|2[02-5]|60)|7[0-5]\\d\\d",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,"12[02-5]",,,,"120",,,[3]
]
,,[,,,,,,,,,[-1]
]
]
,"BL":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"18",,,,"18"]
,[,,,,,,,,,[-1]
]
,,,,"BL",,,,,,,,,,,,,,,,,,[,,"18",,,,"18"]
,,[,,"18",,,,"18"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BM":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"BM",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"176|911",,,,"176"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"BN":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"99[135]",,,,"991"]
,[,,,,,,,,,[-1]
]
,,,,"BN",,,,,,,,,,,,,,,,,,[,,"99[135]",,,,"991"]
,,[,,"99[135]",,,,"991"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BO":[,[,,"[14]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"11[089]",,,,"110",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"BO",,,,,,,,,,,,,,,,,,[,,"11[089]",,,,"110",,,[3]
]
,,[,,"11[089]|40404",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"BQ":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"112|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"BQ",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112"]
,,[,,"1(?:12|76)|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"BR":[,[,,"[124-69]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:00|12|28|8[015]|9[0-47-9])|4(?:57|82\\d)|911",,,,"100",,,[3,4]
]
,[,,,,,,,,,[-1]
]
,,,,"BR",,,,,,,,,,,,,,,,,,[,,"1(?:12|28|9[023])|911",,,,"112",,,[3]
]
,,[,,"1(?:0(?:[02]|3(?:1[2-579]|2[13-9]|3[124-9]|4[1-3578]|5[1-468]|6[139]|8[149]|9[168])|5[0-35-9]|6(?:0|1[0-35-8]?|2[0145]|3[0137]?|4[37-9]?|5[0-35]|6[016]?|7[137]?|8[5-8]|9[1359]))|1[25-8]|2[357-9]|3[024-68]|4[12568]|5\\d|6[0-8]|8[015]|9[0-47-9])|2(?:7(?:330|878)|85959?)|4(?:0404?|57|828)|55555|6(?:0\\d{4}|10000)|911|(?:133|411)[12]",,,,"100"]
,[,,"102|273\\d\\d",,,,"102",,,[3,5]
]
,[,,"151|(?:278|555)\\d\\d|4(?:04\\d\\d?|11\\d|57)",,,,"151",,,[3,4,5]
]
,,[,,"285\\d{2,3}|40404|(?:27[38]\\d|482)\\d|6(?:0\\d|10)\\d{3}",,,,"4820",,,[4,5,6]
]
]
,"BS":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"91[19]",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"BS",,,,,,,,,,,,,,,,,,[,,"91[19]",,,,"911"]
,,[,,"91[19]",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BT":[,[,,"[14]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"11[023]",,,,"110",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"BT",,,,,,,,,,,,,,,,,,[,,"11[023]",,,,"110",,,[3]
]
,,[,,"11[0-6]|40404",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"BW":[,[,,"[19]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"99[7-9]",,,,"997",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"BW",,,,,,,,,,,,,,,,,,[,,"99[7-9]",,,,"997",,,[3]
]
,,[,,"13123|99[7-9]",,,,"997"]
,[,,,,,,,,,[-1]
]
,[,,"131\\d\\d",,,,"13100",,,[5]
]
,,[,,"131\\d\\d",,,,"13100",,,[5]
]
]
,"BY":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"1(?:0[1-3]|12)",,,,"101"]
,[,,,,,,,,,[-1]
]
,,,,"BY",,,,,,,,,,,,,,,,,,[,,"1(?:0[1-3]|12)",,,,"101"]
,,[,,"1(?:0[1-79]|1[246]|35|5[1-35]|6[89]|7[5-7]|8[58]|9[1-7])",,,,"101"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BZ":[,[,,"9\\d\\d?",,,,,,,[2,3]
]
,,,[,,"9(?:0|11)",,,,"90"]
,[,,,,,,,,,[-1]
]
,,,,"BZ",,,,,,,,,,,,,,,,,,[,,"9(?:0|11)",,,,"90"]
,,[,,"9(?:0|11)",,,,"90"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CA":[,[,,"[1-9]\\d\\d(?:\\d\\d(?:\\d(?:\\d{2})?)?)?",,,,,,,[3,5,6,8]
]
,,,[,,"112|[29]11",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"CA",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112",,,[3]
]
,,[,,"112|30000\\d{3}|[1-35-9]\\d{4,5}|[2-9]11",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"[235-7]11",,,,"211",,,[3]
]
,,[,,"300\\d{5}|[1-35-9]\\d{4,5}",,,,"10000",,,[5,6,8]
]
]
,"CC":[,[,,"[01]\\d\\d",,,,,,,[3]
]
,,,[,,"000|112",,,,"000"]
,[,,,,,,,,,[-1]
]
,,,,"CC",,,,,,,,,,,,,,,,,,[,,"000|112",,,,"000"]
,,[,,"000|112",,,,"000"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CD":[,[,,"[14]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"1(?:1[348]|77|88)",,,,"113",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"CD",,,,,,,,,,,,,,,,,,[,,"1(?:1[348]|77|88)",,,,"113",,,[3]
]
,,[,,"1(?:1[348]|23|77|88)|40404",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d",,,,"40400",,,[5]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"CF":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:1[78]|22\\d)",,,,"117"]
,[,,,,,,,,,[-1]
]
,,,,"CF",,,,,,,,,,,,,,,,,,[,,"1(?:1[78]|220)",,,,"117"]
,,[,,"1(?:1[478]|220)",,,,"114"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CG":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[178]",,,,"111"]
,[,,,,,,,,,[-1]
]
,,,,"CG",,,,,,,,,,,,,,,,,,[,,"11[78]",,,,"117"]
,,[,,"11[126-8]",,,,"111"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CH":[,[,,"[1-9]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:1(?:[278]|6\\d{3})|4[47])|5200",,,,"112",,,[3,4,6]
]
,[,,"1(?:14|8[01589])\\d|543|83111",,,,"543",,,[3,4,5]
]
,,,,"CH",,,,,,,,,,,,,,,,,,[,,"1(?:1[278]|44)",,,,"112",,,[3]
]
,,[,,"1(?:0[78]\\d\\d|1(?:[278]|45|6(?:000|111))|4(?:[03-57]|1[45])|6(?:00|[1-46])|8(?:02|1[189]|50|7|8[08]|99))|[2-9]\\d{2,4}",,,,"112"]
,[,,"1(?:4[035]|6[1-46])|1(?:41|60)\\d",,,,"140",,,[3,4]
]
,[,,"5(?:200|35)",,,,"535",,,[3,4]
]
,,[,,"[2-9]\\d{2,4}",,,,"200",,,[3,4,5]
]
]
,"CI":[,[,,"[14]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:1[01]|[78]0)",,,,"110",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"CI",,,,,,,,,,,,,,,,,,[,,"1(?:1[01]|[78]0)",,,,"110",,,[3]
]
,,[,,"1(?:1[01]|[78]0)|4443",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,"444\\d",,,,"4440",,,[4]
]
,,[,,"444\\d",,,,"4440",,,[4]
]
]
,"CK":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"99[689]",,,,"996"]
,[,,,,,,,,,[-1]
]
,,,,"CK",,,,,,,,,,,,,,,,,,[,,"99[689]",,,,"996"]
,,[,,"99[689]",,,,"996"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CL":[,[,,"[1-9]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:213|3[1-3])|434\\d|911",,,,"131",,,[3,4]
]
,[,,"1(?:211|3(?:13|[348]0|5[01]))|(?:1(?:[05]6|[48]1|9[18])|2(?:01\\d|[23]2|77|88)|3(?:0[59]|13|3[279]|66)|4(?:[12]4|36\\d|4[017]|55)|5(?:00|41\\d|5[67]|99)|6(?:07\\d|13|22|3[06]|50|69)|787|8(?:[01]1|[48]8)|9(?:01|[12]0|33))\\d",,,,"1060",,,[4,5]
]
,,,,"CL",,,,,,,,,,,,,,,,,,[,,"13[1-3]|911",,,,"131",,,[3]
]
,,[,,"1(?:00|21[13]|3(?:13|[348]0|5[01])|4(?:0[02-6]|17|[379])|818|919)|2(?:0(?:01|122)|22[47]|323|777|882)|3(?:0(?:51|99)|132|3(?:29|[37]7)|665)|43656|5(?:(?:00|415)4|5(?:66|77)|995)|6(?:131|222|366|699)|7878|8(?:011|11[28]|482|889)|9(?:01|1)1|13\\d|4(?:[13]42|243|4(?:02|15|77)|554)|(?:1(?:[05]6|98)|339|6(?:07|[35])0|9(?:[12]0|33))0",,,,"100"]
,[,,"(?:200|333)\\d",,,,"2000",,,[4]
]
,[,,,,,,,,,[-1]
]
,,[,,"13(?:13|[348]0|5[01])|(?:1(?:[05]6|[28]1|4[01]|9[18])|2(?:0(?:0|1\\d)|[23]2|77|88)|3(?:0[59]|13|3[2379]|66)|436\\d|5(?:00|41\\d|5[67]|99)|6(?:07\\d|13|22|3[06]|50|69)|787|8(?:[01]1|[48]8)|9(?:01|[12]0|33))\\d|4(?:[1-3]4|4[017]|55)\\d",,,,"1060",,,[4,5]
]
]
,"CM":[,[,,"[18]\\d{1,3}",,,,,,,[2,3,4]
]
,,,[,,"1(?:1[37]|[37])",,,,"13",,,[2,3]
]
,[,,,,,,,,,[-1]
]
,,,,"CM",,,,,,,,,,,,,,,,,,[,,"1(?:1[37]|[37])",,,,"13",,,[2,3]
]
,,[,,"1(?:1[37]|[37])|8711",,,,"13"]
,[,,,,,,,,,[-1]
]
,[,,"871\\d",,,,"8710",,,[4]
]
,,[,,"871\\d",,,,"8710",,,[4]
]
]
,"CN":[,[,,"[19]\\d\\d(?:\\d{2,3})?",,,,,,,[3,5,6]
]
,,,[,,"1(?:1[09]|20)",,,,"110",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"CN",,,,,,,,,,,,,,,,,,[,,"1(?:1[09]|20)",,,,"110",,,[3]
]
,,[,,"1(?:00\\d\\d|1[09]|20)|95\\d{3,4}",,,,"110"]
,[,,"100\\d\\d|95\\d{3,4}",,,,"10000",,,[5,6]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CO":[,[,,"[148]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"1(?:1[29]|23|32|56)",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"CO",,,,,,,,,,,,,,,,,,[,,"1(?:1[29]|23|32|56)",,,,"112",,,[3]
]
,,[,,"1(?:06|1[2569]|2[357]|3[27]|4[467]|5[36]|6[45]|95)|40404|85432",,,,"106"]
,[,,,,,,,,,[-1]
]
,[,,"(?:40|85)4\\d\\d",,,,"40400",,,[5]
]
,,[,,"(?:40|85)4\\d\\d",,,,"40400",,,[5]
]
]
,"CR":[,[,,"[1359]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"112|911",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"CR",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112",,,[3]
]
,,[,,"1(?:0(?:00|15|2[2-4679])|1(?:1[0-35-9]|2|37|[46]6|7[57]|8[79]|9[0-379])|2(?:00|[12]2|34|55)|3(?:21|33)|4(?:0[06]|1[4-6])|5(?:15|5[15])|693|7(?:00|1[7-9]|2[02]|[67]7)|975)|3855|5(?:0(?:30|49)|510)|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"(?:385|5(?:0[34]|51))\\d",,,,"3850",,,[4]
]
]
,"CU":[,[,,"[12]\\d\\d(?:\\d{3,4})?",,,,,,,[3,6,7]
]
,,,[,,"10[4-7]|(?:116|204\\d)\\d{3}",,,,"104"]
,[,,,,,,,,,[-1]
]
,,,,"CU",,,,,,,,,,,,,,,,,,[,,"10[4-6]",,,,"104",,,[3]
]
,,[,,"1(?:0[4-7]|1(?:6111|8)|40)|2045252",,,,"104"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CV":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"13[0-2]",,,,"130"]
,[,,,,,,,,,[-1]
]
,,,,"CV",,,,,,,,,,,,,,,,,,[,,"13[0-2]",,,,"130"]
,,[,,"13[0-2]",,,,"130"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CW":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"112|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"CW",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112"]
,,[,,"1(?:12|76)|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"CX":[,[,,"[01]\\d\\d",,,,,,,[3]
]
,,,[,,"000|112",,,,"000"]
,[,,,,,,,,,[-1]
]
,,,,"CX",,,,,,,,,,,,,,,,,,[,,"000|112",,,,"000"]
,,[,,"000|112",,,,"000"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CY":[,[,,"1\\d\\d(?:\\d{3})?",,,,,,,[3,6]
]
,,,[,,"1(?:1(?:2|6\\d{3})|99)",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"CY",,,,,,,,,,,,,,,,,,[,,"1(?:12|99)",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:000|111))|99)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CZ":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:1(?:2|6(?:00[06]|1(?:11|23)))|5[0568])",,,,"112",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"CZ",,,,,,,,,,,,,,,,,,[,,"1(?:12|5[0568])",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|8\\d)|(?:2|3\\d)\\d{2,3}|5[0568]|99)|1(?:16|4)\\d{3}",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DE":[,[,,"1\\d\\d(?:\\d{3})?",,,,,,,[3,6]
]
,,,[,,"11(?:[02]|6\\d{3})",,,,"110"]
,[,,,,,,,,,[-1]
]
,,,,"DE",,,,,,,,,,,,,,,,,,[,,"11[02]",,,,"110",,,[3]
]
,,[,,"11(?:[025]|6(?:00[06]|1(?:1[17]|23)))",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DJ":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,,,,"DJ",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17"]
,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DK":[,[,,"1\\d\\d(?:\\d(?:\\d{2})?)?",,,,,,,[3,4,6]
]
,,,[,,"11(?:[24]|6\\d{3})",,,,"112",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"DK",,,,,,,,,,,,,,,,,,[,,"11[24]",,,,"112",,,[3]
]
,,[,,"1(?:1(?:[2-48]|6(?:00[06]|111))|8(?:[08]1|1[0238]|28|30|5[13]))",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DM":[,[,,"[39]\\d\\d",,,,,,,[3]
]
,,,[,,"333|9(?:11|99)",,,,"333"]
,[,,,,,,,,,[-1]
]
,,,,"DM",,,,,,,,,,,,,,,,,,[,,"333|9(?:11|99)",,,,"333"]
,,[,,"333|9(?:11|99)",,,,"333"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DO":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"112|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"DO",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112"]
,,[,,"112|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DZ":[,[,,"[17]\\d\\d?",,,,,,,[2,3]
]
,,,[,,"1[47]",,,,"14",,,[2]
]
,[,,,,,,,,,[-1]
]
,,,,"DZ",,,,,,,,,,,,,,,,,,[,,"1[47]",,,,"14",,,[2]
]
,,[,,"1[47]|730",,,,"14"]
,[,,,,,,,,,[-1]
]
,[,,"730",,,,"730",,,[3]
]
,,[,,"730",,,,"730",,,[3]
]
]
,"EC":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"1(?:0[12]|12)|911",,,,"101"]
,[,,,,,,,,,[-1]
]
,,,,"EC",,,,,,,,,,,,,,,,,,[,,"1(?:0[12]|12)|911",,,,"101"]
,,[,,"1(?:0[12]|12)|911",,,,"101"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"EE":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:1(?:[02]|6\\d{3})|2(?:05|28)|3(?:014|3(?:21|5\\d?)|660)|492|5(?:1[03]|410|501)|6(?:112|333|644)|7(?:012|127|89)|8(?:10|8[57])|9(?:0[134]|14))",,,,"110"]
,[,,"1(?:18(?:00|[12458]\\d?)|2(?:0(?:[02-46-8]\\d?|1[0-36])|1(?:[0-4]\\d?|6[06])|2(?:[0-4]\\d?|5[25])|[367]|4(?:0[04]|[12]\\d?|4[24]|54)|55[12457])|3(?:0(?:[02]\\d?|1[13578]|3[356])|1[1347]|2[02-5]|3(?:[01347]\\d?|2[023]|88)|4(?:[35]\\d?|4[34])|5(?:3[134]|5[035])|666)|4(?:2(?:00|4\\d?)|4(?:0[01358]|1[024]|50|7\\d?)|900)|5(?:0[0-35]|1(?:[1267]\\d?|5[0-7]|82)|2(?:[014-6]\\d?|22)|330|4(?:[35]\\d?|44)|5(?:00|[1-69]\\d?)|9(?:[159]\\d?|[38]0|77))|6(?:1(?:00|1[19]|[35-9]\\d?)|2(?:2[26]|[68]\\d?)|3(?:22|36|6[36])|5|6(?:[0-359]\\d?|6[0-26])|7(?:00|55|7\\d?|8[89])|9(?:00|1\\d?|69))|7(?:0(?:[023]\\d?|1[0578])|1(?:00|2[034]|[4-9]\\d?)|2(?:[07]\\d?|20|44)|7(?:[0-57]\\d?|9[79])|8(?:0[08]|2\\d?|8[0178])|9(?:00|97))|8(?:1[127]|8[1268]|9[269])|9(?:0(?:[02]\\d?|69|9[0269])|1[1-3689]|21))",,,,"123",,,[3,4,5]
]
,,,,"EE",,,,,,,,,,,,,,,,,,[,,"11[02]",,,,"110",,,[3]
]
,,[,,"1(?:1(?:[02-579]|6(?:000|111)|8(?:[09]\\d|[1-8]))|2[36-9]|3[7-9]|4[05-7]|5[6-8]|6[05]|7[3-6]|8[02-7]|9[3-9])|1(?:2[0-245]|3[0-6]|4[1-489]|5[0-59]|6[1-46-9]|7[0-27-9]|8[189]|9[0-2])\\d\\d?",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"1(?:18[1258]|2(?:0(?:1[036]|[46]\\d?)|166|21|4(?:0[04]|1\\d?|5[47])|[67])|3(?:0(?:1[13-578]|2\\d?|3[56])|1[15]|2[045]|3(?:[13]\\d?|2[13])|43|5(?:00|3[34]|53))|44(?:0[0135]|14|50|7\\d?)|5(?:05|1(?:[12]\\d?|5[1246]|8[12])|2(?:[01]\\d?|22)|3(?:00|3[03])|4(?:15|5\\d?)|500|9(?:5\\d?|77|80))|6(?:1[35-8]|226|3(?:22|3[36]|66)|644|7(?:00|7\\d?|89)|9(?:00|69))|7(?:01[258]|1(?:00|[15]\\d?)|2(?:44|7\\d?)|8(?:00|87|9\\d?))|8(?:1[128]|8[56]|9(?:[26]\\d?|77))|90(?:2\\d?|69|92))",,,,"126",,,[3,4,5]
]
]
,"EG":[,[,,"[13]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"1(?:2[23]|80)",,,,"122",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"EG",,,,,,,,,,,,,,,,,,[,,"1(?:2[23]|80)",,,,"122",,,[3]
]
,,[,,"1(?:2[23]|[69]\\d{3}|80)|34400",,,,"122"]
,[,,,,,,,,,[-1]
]
,[,,"344\\d\\d",,,,"34400",,,[5]
]
,,[,,"344\\d\\d",,,,"34400",,,[5]
]
]
,"EH":[,[,,"1\\d\\d?",,,,,,,[2,3]
]
,,,[,,"1(?:[59]|77)",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"EH",,,,,,,,,,,,,,,,,,[,,"1(?:[59]|77)",,,,"15"]
,,[,,"1(?:[59]|77)",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ER":[,[,,"[12]\\d\\d(?:\\d{3})?",,,,,,,[3,6]
]
,,,[,,"11[2-46]|(?:12[47]|20[12])\\d{3}",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"ER",,,,,,,,,,,,,,,,,,[,,"1(?:1[2-46]|24422)|20(?:1(?:606|917)|2914)|(?:1277|2020)99",,,,"112"]
,,[,,"1(?:1[2-6]|24422)|20(?:1(?:606|917)|2914)|(?:1277|2020)99",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ES":[,[,,"[0-379]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"0(?:16|6[57]|8[58])|1(?:006|12|[3-7]\\d\\d)|(?:116|20\\d)\\d{3}",,,,"016",,,[3,4,6]
]
,[,,"[12]2\\d{1,4}|90(?:5\\d|7)|(?:118|2(?:[357]\\d|80)|3[357]\\d)\\d\\d|[79]9[57]\\d{3}",,,,"120"]
,,,,"ES",,,,,,,,,,,,,,,,,,[,,"08[58]|112",,,,"085",,,[3]
]
,,[,,"0(?:1[0-26]|6[0-257]|8[058]|9[12])|1(?:0[03-57]\\d{1,3}|1(?:2|6(?:000|111)|8\\d\\d)|2\\d{1,4}|[3-9]\\d\\d)|2(?:2\\d{1,4}|80\\d\\d)|90(?:5[124578]|7)|1(?:3[34]|77)|(?:2[01]\\d|[79]9[57])\\d{3}|[23][357]\\d{3}",,,,"010"]
,[,,"0(?:[16][0-2]|80|9[12])|21\\d{4}",,,,"010",,,[3,6]
]
,[,,"1(?:3[34]|77)|[12]2\\d{1,4}",,,,"120"]
,,[,,"(?:2[0-2]\\d|3[357]|[79]9[57])\\d{3}|2(?:[2357]\\d|80)\\d\\d",,,,"22000",,,[5,6]
]
]
,"ET":[,[,,"9\\d\\d?",,,,,,,[2,3]
]
,,,[,,"9(?:11?|[23]|9[17])",,,,"91"]
,[,,,,,,,,,[-1]
]
,,,,"ET",,,,,,,,,,,,,,,,,,[,,"9(?:11?|[23]|9[17])",,,,"91"]
,,[,,"9(?:11?|[23]|9[17])",,,,"91"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"FI":[,[,,"[17]\\d\\d(?:\\d{2,3})?",,,,,,,[3,5,6]
]
,,,[,,"11(?:2|6\\d{3})",,,,"112",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"FI",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"11(?:2|6111)|75[12]\\d\\d",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"FJ":[,[,,"[0-579]\\d(?:\\d(?:\\d{2})?)?",,,,,,,[2,3,5]
]
,,,[,,"91[17]",,,,"911",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"FJ",,,,,,,,,,,,,,,,,,[,,"91[17]",,,,"911",,,[3]
]
,,[,,"0(?:1[34]|8[1-4])|1(?:0[1-3]|[25]9)|2[289]|30|40404|91[137]|[45]4|75",,,,"22"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"FK":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,,,,"FK",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"1\\d\\d|999",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"FM":[,[,,"[39]\\d\\d(?:\\d{3})?",,,,,,,[3,6]
]
,,,[,,"320\\d{3}|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"FM",,,,,,,,,,,,,,,,,,[,,"(?:32022|91)1",,,,"911"]
,,[,,"(?:32022|91)1",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"FO":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"11[24]",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"FO",,,,,,,,,,,,,,,,,,[,,"11[24]",,,,"112",,,[3]
]
,,[,,"11[248]|1(?:4[124]|71|8[7-9])\\d",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"FR":[,[,,"[1-8]\\d{1,5}",,,,,,,[2,3,4,5,6]
]
,,,[,,"1(?:0(?:07|13)|1[02459]|[578]|9[167])|224|(?:3370|74)0|(?:116\\d|3[01])\\d\\d",,,,"15"]
,[,,"(?:118|[4-8]\\d)\\d{3}|36665",,,,"36665",,,[5,6]
]
,,,,"FR",,,,,,,,,,,,,,,,,,[,,"1(?:12|[578])",,,,"15",,,[2,3]
]
,,[,,"1(?:0\\d\\d|1(?:[02459]|6(?:000|111)|8\\d{3})|[578]|9[167])|2(?:0(?:00|2)0|24)|[3-8]\\d{4}|3\\d{3}|6(?:1[14]|34)|7(?:0[06]|22|40)",,,,"15"]
,[,,"10(?:[13]4|2[23]|99)|202\\d|3(?:646|9[07]0)|634|70[06]|(?:106|61)[14]",,,,"611",,,[3,4]
]
,[,,"118777|224|6(?:1[14]|34)|7(?:0[06]|22|40)|20(?:0\\d|2)\\d",,,,"224",,,[3,4,5,6]
]
,,[,,"114|[3-8]\\d{4}",,,,"114",,,[3,5]
]
]
,"GA":[,[,,"1\\d(?:\\d{2})?",,,,,,,[2,4]
]
,,,[,,"18|1(?:3\\d|73)\\d",,,,"18"]
,[,,,,,,,,,[-1]
]
,,,,"GA",,,,,,,,,,,,,,,,,,[,,"1(?:3\\d\\d|730|8)",,,,"18"]
,,[,,"1(?:3\\d\\d|730|8)",,,,"18"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GB":[,[,,"[1-46-9]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:05|1(?:2|6\\d{3})|7[56]\\d|8000)|2(?:20\\d|48)|4444|999",,,,"105"]
,[,,,,,,,,,[-1]
]
,,,,"GB",,,,,,,,,,,,,,,,,,[,,"112|999",,,,"112",,,[3]
]
,,[,,"1(?:0[015]|1(?:[12]|6(?:000|1(?:11|23))|8\\d{3})|2(?:[1-3]|50)|33|4(?:1|7\\d)|571|7(?:0\\d|[56]0)|800\\d|9[15])|2(?:0202|1300|2(?:02|11)|3(?:02|336|45)|4(?:25|8))|3[13]3|4(?:0[02]|35[01]|44[45]|5\\d)|(?:[68]\\d|7[089])\\d{3}|15\\d|2[02]2|650|789|9(?:01|99)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"1(?:(?:25|7[56])\\d|571)|2(?:02(?:\\d{2})?|[13]3\\d\\d|48)|4444|901",,,,"202",,,[3,4,5]
]
,,[,,"(?:125|2(?:020|13\\d)|(?:7[089]|8[01])\\d\\d)\\d",,,,"1250",,,[4,5]
]
]
,"GD":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"GD",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"176|911",,,,"176"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"GE":[,[,,"[014]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"0(?:11|33)|11[1-3]|[01]22",,,,"011",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"GE",,,,,,,,,,,,,,,,,,[,,"0(?:11|33)|11[1-3]|[01]22",,,,"011",,,[3]
]
,,[,,"0(?:11|33)|11[1-3]|40404|[01]22",,,,"011"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d",,,,"40400",,,[5]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"GF":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"GF",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"15"]
,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GG":[,[,,"[19]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"112|999",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"GG",,,,,,,,,,,,,,,,,,[,,"112|999",,,,"112",,,[3]
]
,,[,,"1(?:0[01]|1[12]|23|41|55|9[05])|999|1(?:1[68]\\d\\d|47|800)\\d",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GH":[,[,,"[14589]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"19[1-3]|999",,,,"191",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"GH",,,,,,,,,,,,,,,,,,[,,"19[1-3]|999",,,,"191",,,[3]
]
,,[,,"19[1-3]|40404|(?:54|83)00|999",,,,"191"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d|(?:54|83)0\\d",,,,"5400",,,[4,5]
]
,,[,,"404\\d\\d|(?:54|83)0\\d",,,,"5400",,,[4,5]
]
]
,"GI":[,[,,"[158]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:00|1[25]|23|4(?:1|7\\d)|5[15]|9[02-49])|555|(?:116\\d|80)\\d\\d",,,,"100",,,[3,4,6]
]
,[,,"8[1-69]\\d\\d",,,,"8100",,,[4]
]
,,,,"GI",,,,,,,,,,,,,,,,,,[,,"1(?:12|9[09])",,,,"112",,,[3]
]
,,[,,"1(?:00|1(?:[25]|6(?:00[06]|1(?:1[17]|23))|8\\d\\d)|23|4(?:1|7[014])|5[015]|9[02-49])|555|8[0-79]\\d\\d|8(?:00|4[0-2]|8[0-589])",,,,"100"]
,[,,"150|87\\d\\d",,,,"150",,,[3,4]
]
,[,,"1(?:00|1(?:5|8\\d\\d)|23|51|9[2-4])|555|8(?:00|4[0-2]|8[0-589])",,,,"100",,,[3,5]
]
,,[,,,,,,,,,[-1]
]
]
,"GL":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"GL",,,,,,,,,,,,,,,,,,[,,"112",,,,"112"]
,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GM":[,[,,"1\\d\\d?",,,,,,,[2,3]
]
,,,[,,"1(?:1[6-8]|[6-8])",,,,"16"]
,[,,,,,,,,,[-1]
]
,,,,"GM",,,,,,,,,,,,,,,,,,[,,"1(?:1[6-8]|[6-8])",,,,"16"]
,,[,,"1(?:1[6-8]|[6-8])",,,,"16"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GN":[,[,,"4\\d{4}",,,,,,,[5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GN",,,,,,,,,,,,,,,,,,[,,,,,,,,,[-1]
]
,,[,,"40404",,,,"40404"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d",,,,"40400"]
,,[,,"404\\d\\d",,,,"40400"]
]
,"GP":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"GP",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"15"]
,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GR":[,[,,"1\\d\\d(?:\\d{3})?",,,,,,,[3,6]
]
,,,[,,"1(?:00|1(?:2|6\\d{3})|66|99)",,,,"100"]
,[,,,,,,,,,[-1]
]
,,,,"GR",,,,,,,,,,,,,,,,,,[,,"1(?:00|12|66|99)",,,,"100",,,[3]
]
,,[,,"1(?:00|1(?:2|6(?:000|1(?:11|23)))|66|99)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GT":[,[,,"[14]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:10|2[03])",,,,"110",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"GT",,,,,,,,,,,,,,,,,,[,,"1(?:10|2[03])",,,,"110",,,[3]
]
,,[,,"110|40404|1(?:2|[57]\\d)\\d",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d",,,,"40400",,,[5]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"GU":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"GU",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GW":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[378]",,,,"113"]
,[,,,,,,,,,[-1]
]
,,,,"GW",,,,,,,,,,,,,,,,,,[,,"11[378]",,,,"113"]
,,[,,"11[378]",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GY":[,[,,"[019]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"91[1-3]",,,,"911",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"GY",,,,,,,,,,,,,,,,,,[,,"91[1-3]",,,,"911",,,[3]
]
,,[,,"0(?:02|(?:17|80)1|444|7(?:[67]7|9)|9(?:0[78]|[2-47]))|1(?:443|5[568])|91[1-3]",,,,"002"]
,[,,,,,,,,,[-1]
]
,[,,"144\\d",,,,"1440",,,[4]
]
,,[,,"144\\d",,,,"1440",,,[4]
]
]
,"HK":[,[,,"[19]\\d{2,6}",,,,,,,[3,4,5,6,7]
]
,,,[,,"112|99[29]",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"HK",,,,,,,,,,,,,,,,,,[,,"112|99[29]",,,,"112",,,[3]
]
,,[,,"1(?:0(?:(?:[0136]\\d|2[14])\\d{0,3}|8[138])|12|2(?:[0-3]\\d{0,4}|(?:58|8[13])\\d{0,3})|7(?:[135-9]\\d{0,4}|219\\d{0,2})|8(?:0(?:(?:[13]|60\\d)\\d|8)|1(?:0\\d|[2-8])|2(?:0[5-9]|(?:18|2)2|3|8[128])|(?:(?:3[0-689]\\d|7(?:2[1-389]|8[0235-9]|93))\\d|8)\\d|50[138]|6(?:1(?:11|86)|8)))|99[29]|10[0139]",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"109|1(?:08|85\\d)\\d",,,,"109",,,[3,4,5]
]
,,[,,"992",,,,"992",,,[3]
]
]
,"HN":[,[,,"[14]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"199",,,,"199",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"HN",,,,,,,,,,,,,,,,,,[,,"199",,,,"199",,,[3]
]
,,[,,"199|40404",,,,"199"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d",,,,"40400",,,[5]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"HR":[,[,,"[19]\\d{1,5}",,,,,,,[2,3,4,5,6]
]
,,,[,,"1(?:12|9[2-4])|9[34]|1(?:16\\d|39)\\d\\d",,,,"93",,,[2,3,5,6]
]
,[,,"118\\d\\d",,,,"11800",,,[5]
]
,,,,"HR",,,,,,,,,,,,,,,,,,[,,"1(?:12|9[2-4])|9[34]",,,,"93",,,[2,3]
]
,,[,,"1(?:1(?:2|6(?:00[06]|1(?:1[17]|23))|8\\d\\d)|3977|9(?:[2-5]|87))|9[34]",,,,"93"]
,[,,,,,,,,,[-1]
]
,[,,"139\\d\\d",,,,"13900",,,[5]
]
,,[,,"139\\d\\d",,,,"13900",,,[5]
]
]
,"HT":[,[,,"[14]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"11[48]",,,,"114",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"HT",,,,,,,,,,,,,,,,,,[,,"11[48]",,,,"114",,,[3]
]
,,[,,"11[48]|40404",,,,"114"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d",,,,"40400",,,[5]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"HU":[,[,,"1\\d\\d(?:\\d{3})?",,,,,,,[3,6]
]
,,,[,,"1(?:0[457]|1(?:2|6\\d{3}))",,,,"104"]
,[,,,,,,,,,[-1]
]
,,,,"HU",,,,,,,,,,,,,,,,,,[,,"1(?:0[457]|12)",,,,"104",,,[3]
]
,,[,,"1(?:0[457]|1(?:2|6(?:000|1(?:11|23))))",,,,"104"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ID":[,[,,"[178]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"11[02389]",,,,"110",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"ID",,,,,,,,,,,,,,,,,,[,,"11[02389]",,,,"110",,,[3]
]
,,[,,"1(?:1[02389]|40\\d\\d)|71400|89887",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,"(?:714|898)\\d\\d",,,,"71400",,,[5]
]
,,[,,"714\\d\\d",,,,"71400",,,[5]
]
]
,"IE":[,[,,"[159]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"11(?:2|6\\d{3})|999",,,,"112",,,[3,6]
]
,[,,"5[37]\\d{3}",,,,"53000",,,[5]
]
,,,,"IE",,,,,,,,,,,,,,,,,,[,,"112|999",,,,"112",,,[3]
]
,,[,,"11(?:2|6(?:00[06]|1(?:1[17]|23)))|999|(?:1(?:18|9)|5[0137]\\d)\\d\\d",,,,"112"]
,[,,"51\\d{3}",,,,"51000",,,[5]
]
,[,,"51210",,,,"51210",,,[5]
]
,,[,,"51210|(?:118|5[037]\\d)\\d\\d",,,,"11800",,,[5]
]
]
,"IL":[,[,,"1\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:0[0-2]|12)",,,,"100",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"IL",,,,,,,,,,,,,,,,,,[,,"1(?:0[0-2]|12)",,,,"100",,,[3]
]
,,[,,"1(?:0(?:[0-2]|400)|1(?:[013-9]\\d|2)|[2-9]\\d\\d)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"104\\d\\d",,,,"10400",,,[5]
]
,,[,,"104\\d\\d",,,,"10400",,,[5]
]
]
,"IM":[,[,,"[189]\\d\\d(?:\\d{2,3})?",,,,,,,[3,5,6]
]
,,,[,,"999",,,,"999",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"IM",,,,,,,,,,,,,,,,,,[,,"999",,,,"999",,,[3]
]
,,[,,"1\\d\\d(?:\\d{3})?|8(?:6444|9887)|999",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"8(?:64|98)\\d\\d",,,,"86400",,,[5]
]
]
,"IN":[,[,,"[12578]\\d{2,8}",,,,,,,[3,4,5,6,7,8,9]
]
,,,[,,"1(?:0[0-248]|1[289]|21|[39][89]|4[01]|6(?:1|6\\d?)|8[12])|777|800|1[05]5\\d|1(?:07|51|94)\\d\\d?|(?:1(?:[05]5\\d|70)\\d|261)\\d|1(?:0[369]|10|29|3[126]|9[0-256])\\d",,,,"100",,,[3,4,5,6]
]
,[,,"11[67]\\d{4}|56161561",,,,"1160000",,,[7,8]
]
,,,,"IN",,,,,,,,,,,,,,,,,,[,,"1(?:0[0-28]|12|298)|2611",,,,"100",,,[3,4]
]
,,[,,"1(?:0(?:[0-248]|3[39]|5(?:010|6)|6[3468]|7(?:[01357]|[28]0?|4[01])|9[0135-9])|1(?:00|[289])|2(?:1|98)|3(?:11|2[0-2]|63|[89])|4[01]|5(?:1(?:0[0-36]|[127])|54)|6(?:1|6[01]?)|7000|8[12]|9(?:0[013-59]|12|25|4[4-9]\\d?|50|6[1347]|[89]))|2611|5(?:0(?:0(?:0\\d|1|20?)|325|5[2-79]\\d{3,5})|1(?:234|555|717|818|96[49])|2(?:0(?:0[01]|[14]0)|151|555|666|888|9(?:06|99\\d?))|3(?:0[01]0|131|553|(?:66|77)6)|(?:464|55[05])\\d{1,3}|6(?:070|3[68]|43)|717\\d)|777|800|5(?:05(?:0|1\\d)|221|3(?:03|3[23]))\\d{1,4}|5(?:(?:04|88)0|2(?:2[0267]|3[16])|4(?:1[04]|20|3[02])|5(?:3[16]|67)|6(?:06|[67]\\d)|787|9(?:64|90))\\d\\d?|(?:1(?:05[79]|(?:1[67][0-2]|802)\\d|55[23])\\d|5(?:(?:00(?:0\\d|1)|(?:304|616)\\d\\d)\\d|1(?:0[12]|4[2-4])|2(?:2[3589]|3(?:1\\d{3}|2)|4[04]|7[78])|4(?:[02]4|32\\d{4}|4[04]|99)|5(?:1[25]|[36]5|4[45]|93)|7(?:(?:17\\d|57)\\d\\d|[27]7|88)|8(?:3[4-69]|4[01]|5[58]|88(?:8\\d\\d|9)|99)|9(?:0(?:0|2\\d{3})|55|6[67]|77|88)))\\d",,,,"100"]
,[,,"5(?:14(?:2[5-9]|[34]\\d)|757555)",,,,"51425",,,[5,7]
]
,[,,"1(?:(?:1[67]\\d\\d|70)\\d\\d|55330|909)|5(?:300\\d|6161(?:17[89]|561))|1(?:[19][89]|21|4[01])",,,,"118",,,[3,4,5,6,7,8]
]
,,[,,"1(?:39|90[019])|5(?:14(?:2[5-9]|[34]\\d)|6161(?:17[89]|561)|757555)",,,,"139",,,[3,4,5,7,8]
]
]
,"IQ":[,[,,"[1479]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:0[04]|15|22)",,,,"100",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"IQ",,,,,,,,,,,,,,,,,,[,,"1(?:0[04]|15|22)",,,,"100",,,[3]
]
,,[,,"1(?:0[04]|15|22)|4432|71117|9988",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"(?:443|711\\d|998)\\d",,,,"4430",,,[4,5]
]
,,[,,"(?:443|711\\d|998)\\d",,,,"4430",,,[4,5]
]
]
,"IR":[,[,,"[129]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:1[0-68]|2[0-59]|9[0-579])|911",,,,"110",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"IR",,,,,,,,,,,,,,,,,,[,,"1(?:1[025]|25)|911",,,,"110",,,[3]
]
,,[,,"1(?:1[0-68]|2[0-59]|3[346-8]|4(?:[0147]|[289]0)|5(?:0[14]|1[02479]|2[0-3]|39|[49]0|65)|6(?:[16]6|[27]|90)|8(?:03|1[18]|22|3[37]|4[28]|88|99)|9[0-579])|20(?:[09]0|1(?:[038]|1[079]|26|9[69])|2[01])|9(?:11|9(?:0009|90))",,,,"110"]
,[,,"1(?:5[0-469]|8[0-489])\\d",,,,"1500",,,[4]
]
,[,,"(?:1(?:5[0-469]|8[0-489])|99(?:0\\d\\d|9))\\d",,,,"1500",,,[4,6]
]
,,[,,"990\\d{3}",,,,"990000",,,[6]
]
]
,"IS":[,[,,"1\\d\\d(?:\\d(?:\\d{2})?)?",,,,,,,[3,4,6]
]
,,,[,,"1(?:12|71\\d)",,,,"112",,,[3,4]
]
,[,,,,,,,,,[-1]
]
,,,,"IS",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"1(?:1(?:[28]|61(?:16|23))|4(?:00|1[145]|4[0146])|55|7(?:00|17|7[07-9])|8(?:[02]0|1[16-9]|88)|900)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"14(?:0\\d|41)",,,,"1400",,,[4]
]
,,[,,"1(?:415|90\\d)",,,,"1415",,,[4]
]
]
,"IT":[,[,,"[14]\\d{2,6}",,,,,,,[3,4,5,6,7]
]
,,,[,,"1(?:1(?:[2358]|6\\d{3})|87)",,,,"112",,,[3,6]
]
,[,,"(?:12|4(?:[478](?:[0-4]|[5-9]\\d\\d)|55))\\d\\d",,,,"1200",,,[4,5,7]
]
,,,,"IT",,,,,,,,,,,,,,,,,,[,,"11[2358]",,,,"112",,,[3]
]
,,[,,"1(?:0\\d{2,3}|1(?:[2-57-9]|6(?:000|111))|3[39]|4(?:82|9\\d{1,3})|5(?:00|1[58]|2[25]|3[03]|44|[59])|60|8[67]|9(?:[01]|2[2-9]|4\\d|696))|4(?:2323|5045)|(?:1(?:2|92[01])|4(?:3(?:[01]|[45]\\d\\d)|[478](?:[0-4]|[5-9]\\d\\d)|55))\\d\\d",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"4(?:3(?:[01]|[45]\\d\\d)|[478](?:[0-4]|[5-9]\\d\\d)|5[05])\\d\\d",,,,"43000",,,[5,7]
]
]
,"JE":[,[,,"[129]\\d\\d(?:\\d(?:\\d{2})?)?",,,,,,,[3,4,6]
]
,,,[,,"112|999",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"JE",,,,,,,,,,,,,,,,,,[,,"112|999",,,,"112",,,[3]
]
,,[,,"1(?:00|1(?:2|8\\d{3})|23|4(?:[14]|28|7\\d)|5\\d|7(?:0[12]|[128]|35?)|808|9[0135])|23[2-4]|999",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"JM":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"11[029]|911",,,,"110"]
,[,,,,,,,,,[-1]
]
,,,,"JM",,,,,,,,,,,,,,,,,,[,,"11[029]|911",,,,"110"]
,,[,,"1(?:1[029]|76)|911",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"JO":[,[,,"[19]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"1(?:12|9[127])|911",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"JO",,,,,,,,,,,,,,,,,,[,,"1(?:12|9[127])|911",,,,"112",,,[3]
]
,,[,,"1(?:09|1[0-2]|9[0-24-79])|9(?:0903|11|8788)",,,,"109"]
,[,,,,,,,,,[-1]
]
,[,,"9(?:09|87)\\d\\d",,,,"90900",,,[5]
]
,,[,,"9(?:09|87)\\d\\d",,,,"90900",,,[5]
]
]
,"JP":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[09]",,,,"110"]
,[,,,,,,,,,[-1]
]
,,,,"JP",,,,,,,,,,,,,,,,,,[,,"11[09]",,,,"110"]
,,[,,"11[09]",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KE":[,[,,"[1-9]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:1(?:[246]|9\\d)|5(?:01|2[127]|6[26]\\d))|999",,,,"112"]
,[,,"909\\d\\d",,,,"90900",,,[5]
]
,,,,"KE",,,,,,,,,,,,,,,,,,[,,"11[24]|999",,,,"112",,,[3]
]
,,[,,"1(?:0(?:[07-9]|1[0-25]|400)|1(?:[024-6]|9[0-579])|2[1-3]|3[01]|4[14]|5(?:[01][01]|2[0-24-79]|33|4[05]|5[59]|6(?:00|29|6[67]))|(?:6[035]\\d|[78])\\d|9(?:[02-9]\\d\\d|19))|(?:(?:2[0-79]|[37][0-29]|4[0-4]|6[2357]|8\\d)\\d|5(?:[0-7]\\d|99))\\d\\d|9(?:09\\d\\d|99)|8988",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"1(?:(?:04|6[35])\\d\\d|3[01]|4[14]|5(?:1\\d|2[25]))|(?:(?:2[0-79]|[37][0-29]|4[0-4]|6[2357]|8\\d)\\d|5(?:[0-7]\\d|99)|909)\\d\\d|898\\d",,,,"130"]
,,[,,"1(?:(?:04|6[035])\\d\\d|4[14]|5(?:01|55|6[26]\\d))|40404|8988|909\\d\\d",,,,"141"]
]
,"KG":[,[,,"[14]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"10[1-3]",,,,"101",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"KG",,,,,,,,,,,,,,,,,,[,,"10[1-3]",,,,"101",,,[3]
]
,,[,,"10[1-3]|4040",,,,"101"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d",,,,"4040",,,[4]
]
,,[,,"404\\d",,,,"4040",,,[4]
]
]
,"KH":[,[,,"[146]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"11[7-9]|666",,,,"117",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"KH",,,,,,,,,,,,,,,,,,[,,"11[7-9]|666",,,,"117",,,[3]
]
,,[,,"11[7-9]|40404|666",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d",,,,"40400",,,[5]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"KI":[,[,,"[17]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"19[2-5]",,,,"192",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"KI",,,,,,,,,,,,,,,,,,[,,"19[2-5]",,,,"192",,,[3]
]
,,[,,"1(?:05[0-259]|88|9[2-5])|777|10[0-8]",,,,"100"]
,[,,"103",,,,"103",,,[3]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KM":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,,,,"KM",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17"]
,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KN":[,[,,"[39]\\d\\d",,,,,,,[3]
]
,,,[,,"333|9(?:11|99)",,,,"333"]
,[,,,,,,,,,[-1]
]
,,,,"KN",,,,,,,,,,,,,,,,,,[,,"333|9(?:11|99)",,,,"333"]
,,[,,"333|9(?:11|99)",,,,"333"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KP":[,[,,"[18]\\d\\d",,,,,,,[3]
]
,,,[,,"11[29]|819",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"KP",,,,,,,,,,,,,,,,,,[,,"11[29]|819",,,,"112"]
,,[,,"11[29]|819",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KR":[,[,,"1\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:1[27-9]|28|330|82)",,,,"112",,,[3,4]
]
,[,,,,,,,,,[-1]
]
,,,,"KR",,,,,,,,,,,,,,,,,,[,,"11[29]",,,,"112",,,[3]
]
,,[,,"1(?:[016-9]114|3(?:2|3[039]|45|66|88|9[18]))|1(?:0[01]|1[0247-9]|2[01389]|82)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"1[016-9]1\\d\\d|1(?:0[01]|14)",,,,"100",,,[3,5]
]
,,[,,,,,,,,,[-1]
]
]
,"KW":[,[,,"[18]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"112",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"KW",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"1[0-7]\\d|89887",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"898\\d\\d",,,,"89800",,,[5]
]
,,[,,,,,,,,,[-1]
]
]
,"KY":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"KY",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KZ":[,[,,"[134]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:0[1-3]|12)",,,,"101",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"KZ",,,,,,,,,,,,,,,,,,[,,"1(?:0[1-3]|12)",,,,"101",,,[3]
]
,,[,,"1(?:0[1-4]|12)|(?:3040|404)0",,,,"101"]
,[,,,,,,,,,[-1]
]
,[,,"(?:304\\d|404)\\d",,,,"4040",,,[4,5]
]
,,[,,"(?:304\\d|404)\\d",,,,"4040",,,[4,5]
]
]
,"LA":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"19[015]",,,,"190"]
,[,,,,,,,,,[-1]
]
,,,,"LA",,,,,,,,,,,,,,,,,,[,,"19[015]",,,,"190"]
,,[,,"19[015]",,,,"190"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LB":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"1(?:12|40|75)|999",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"LB",,,,,,,,,,,,,,,,,,[,,"1(?:12|40|75)|999",,,,"112"]
,,[,,"1(?:12|40|75)|999",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LC":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"LC",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LI":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:1[278]|44)",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"LI",,,,,,,,,,,,,,,,,,[,,"1(?:1[278]|44)",,,,"112",,,[3]
]
,,[,,"1(?:1(?:[278]|45)|4[3-57]|50|75|81[18])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LK":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[02689]",,,,"110"]
,[,,,,,,,,,[-1]
]
,,,,"LK",,,,,,,,,,,,,,,,,,[,,"11[02689]",,,,"110"]
,,[,,"11[024-9]",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LR":[,[,,"[3489]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"355|911",,,,"355",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"LR",,,,,,,,,,,,,,,,,,[,,"355|911",,,,"355",,,[3]
]
,,[,,"355|4040|8(?:400|933)|911",,,,"355"]
,[,,,,,,,,,[-1]
]
,[,,"(?:404|8(?:40|93))\\d",,,,"4040",,,[4]
]
,,[,,"(?:404|8(?:40|93))\\d",,,,"4040",,,[4]
]
]
,"LS":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[257]",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"LS",,,,,,,,,,,,,,,,,,[,,"11[257]",,,,"112"]
,,[,,"11[257]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LT":[,[,,"[01]\\d(?:\\d(?:\\d{3})?)?",,,,,,,[2,3,6]
]
,,,[,,"0(?:11?|22?|33?)|1(?:0[1-3]|1(?:2|6\\d{3}))",,,,"01"]
,[,,,,,,,,,[-1]
]
,,,,"LT",,,,,,,,,,,,,,,,,,[,,"0(?:11?|22?|33?)|1(?:0[1-3]|12)",,,,"01",,,[2,3]
]
,,[,,"0(?:11?|22?|33?)|1(?:0[1-3]|1(?:2|6(?:000|1(?:11|23))))",,,,"01"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LU":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"11(?:[23]|6\\d{3})",,,,"112",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"LU",,,,,,,,,,,,,,,,,,[,,"11[23]",,,,"112",,,[3]
]
,,[,,"11(?:[23]|6(?:000|111))|1(?:18|[25]\\d|3)\\d\\d",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LV":[,[,,"[018]\\d{1,5}",,,,,,,[2,3,4,5,6]
]
,,,[,,"0[1-3]|11(?:[023]|6\\d{3})",,,,"01",,,[2,3,6]
]
,[,,"1180|821\\d\\d",,,,"1180",,,[4,5]
]
,,,,"LV",,,,,,,,,,,,,,,,,,[,,"0[1-3]|11[023]",,,,"01",,,[2,3]
]
,,[,,"0[1-4]|1(?:1(?:[02-4]|6(?:000|111)|8[0189])|(?:5|65)5|77)|821[57]4",,,,"01"]
,[,,"1181",,,,"1181",,,[4]
]
,[,,"165\\d",,,,"1650",,,[4]
]
,,[,,,,,,,,,[-1]
]
]
,"LY":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"19[013]",,,,"190"]
,[,,,,,,,,,[-1]
]
,,,,"LY",,,,,,,,,,,,,,,,,,[,,"19[013]",,,,"190"]
,,[,,"19[013]",,,,"190"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MA":[,[,,"1\\d\\d?",,,,,,,[2,3]
]
,,,[,,"1(?:[59]|77)",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"MA",,,,,,,,,,,,,,,,,,[,,"1(?:[59]|77)",,,,"15"]
,,[,,"1(?:[59]|77)",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MC":[,[,,"1\\d\\d?",,,,,,,[2,3]
]
,,,[,,"1(?:12|[578])",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"MC",,,,,,,,,,,,,,,,,,[,,"1(?:12|[578])",,,,"15"]
,,[,,"1(?:12|41|[578])",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MD":[,[,,"[19]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"11(?:2|6\\d{3})|90[1-3]",,,,"112",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"MD",,,,,,,,,,,,,,,,,,[,,"112|90[1-3]",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:000|1(?:11|23))|8\\d\\d?|99)|90[04-9])|90[1-3]|1(?:4\\d\\d|6[0-389]|9[1-4])\\d",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ME":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:12|2[2-4])",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"ME",,,,,,,,,,,,,,,,,,[,,"1(?:12|2[2-4])",,,,"112",,,[3]
]
,,[,,"1(?:1(?:(?:[013-57-9]|6\\d\\d)\\d|2)|[249]\\d{3}|5999|8(?:0[089]|1[0-8]|888))|1(?:[02-5]\\d\\d|60[06]|700)|12\\d",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MF":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"MF",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"15"]
,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MG":[,[,,"1\\d\\d?",,,,,,,[2,3]
]
,,,[,,"1(?:1[78]|[78])",,,,"17"]
,[,,,,,,,,,[-1]
]
,,,,"MG",,,,,,,,,,,,,,,,,,[,,"1(?:1[78]|[78])",,,,"17"]
,,[,,"1(?:1[78]|[78])",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MH":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"MH",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MK":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"1(?:12|9[2-4])",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"MK",,,,,,,,,,,,,,,,,,[,,"1(?:12|9[2-4])",,,,"112"]
,,[,,"1(?:12|9[2-4])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ML":[,[,,"[136-8]\\d{1,4}",,,,,,,[2,3,4,5]
]
,,,[,,"1[578]|(?:352|67)00|7402|(?:677|744|8000)\\d",,,,"15",,,[2,4,5]
]
,[,,"(?:12|800)2\\d|3(?:52(?:11|2[02]|3[04-6]|99)|7574)",,,,"1220",,,[4,5]
]
,,,,"ML",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"15",,,[2]
]
,,[,,"1(?:1(?:[013-9]\\d|2)|2(?:1[02-469]|2[13])|[578])|350(?:35|57)|67(?:0[09]|[59]9|77|8[89])|74(?:0[02]|44|55)|800[0-2][12]|3(?:52|[67]\\d)\\d\\d",,,,"15"]
,[,,"37(?:433|575)|7400|8001\\d",,,,"7400",,,[4,5]
]
,[,,"3503\\d|(?:3[67]\\d|800)\\d\\d",,,,"35030",,,[5]
]
,,[,,"374(?:0[24-9]|[1-9]\\d)|7400|3(?:6\\d|75)\\d\\d",,,,"7400",,,[4,5]
]
]
,"MM":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"199",,,,"199"]
,[,,,,,,,,,[-1]
]
,,,,"MM",,,,,,,,,,,,,,,,,,[,,"199",,,,"199"]
,,[,,"199",,,,"199"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MN":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"10[0-3]",,,,"100"]
,[,,,,,,,,,[-1]
]
,,,,"MN",,,,,,,,,,,,,,,,,,[,,"10[0-3]",,,,"100"]
,,[,,"10[0-3]",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MO":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,,,,"MO",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MP":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"MP",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MQ":[,[,,"1\\d\\d?",,,,,,,[2,3]
]
,,,[,,"1(?:12|[578])",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"MQ",,,,,,,,,,,,,,,,,,[,,"1(?:12|[578])",,,,"15"]
,,[,,"1(?:12|[578])",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MR":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,,,,"MR",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17"]
,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MS":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"MS",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MT":[,[,,"1\\d\\d(?:\\d{3})?",,,,,,,[3,6]
]
,,,[,,"11(?:2|6\\d{3})",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"MT",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"11(?:2|6(?:000|1(?:11|23)))",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MU":[,[,,"[189]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"11[45]|99[59]",,,,"114",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"MU",,,,,,,,,,,,,,,,,,[,,"11[45]|99[59]",,,,"114",,,[3]
]
,,[,,"1\\d{2,4}|(?:8\\d\\d|99)\\d",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MV":[,[,,"[14]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:02|1[89])",,,,"102",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"MV",,,,,,,,,,,,,,,,,,[,,"1(?:02|1[89])",,,,"102",,,[3]
]
,,[,,"1(?:[0-37-9]|[4-6]\\d)\\d|4040|1[45]1",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,"1[45]1",,,,"141",,,[3]
]
,,[,,,,,,,,,[-1]
]
]
,"MW":[,[,,"[189]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"199|99[7-9]",,,,"199",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"MW",,,,,,,,,,,,,,,,,,[,,"199|99[7-9]",,,,"199",,,[3]
]
,,[,,"199|80400|99[7-9]",,,,"199"]
,[,,,,,,,,,[-1]
]
,[,,"804\\d\\d",,,,"80400",,,[5]
]
,,[,,"804\\d\\d",,,,"80400",,,[5]
]
]
,"MX":[,[,,"[0579]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"0(?:6[0568]|80)|911",,,,"060",,,[3]
]
,[,,"(?:530\\d|776)\\d",,,,"7760",,,[4,5]
]
,,,,"MX",,,,,,,,,,,,,,,,,,[,,"0(?:6[0568]|80)|911",,,,"060",,,[3]
]
,,[,,"0[1-9]\\d|53053|7766|911",,,,"010"]
,[,,,,,,,,,[-1]
]
,[,,"0(?:[249]0|[35][01])",,,,"020",,,[3]
]
,,[,,,,,,,,,[-1]
]
]
,"MY":[,[,,"[1369]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"112|999",,,,"112",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"MY",,,,,,,,,,,,,,,,,,[,,"112|999",,,,"112",,,[3]
]
,,[,,"1(?:0[01348]|1(?:[02]|1[128]|311)|2(?:0[125]|[13-6]|2\\d{0,2})|(?:3[1-35-79]|7[45])\\d\\d?|5(?:454|5\\d\\d?|77|888|999?)|8(?:18?|2|8[18])|9(?:[124]\\d?|68|71|9[0679]))|66628|99[1-469]|13[5-7]|(?:1(?:0[569]|309|5[12]|7[136-9]|9[03])|3[23679]\\d\\d)\\d",,,,"100"]
,[,,"666\\d\\d",,,,"66600",,,[5]
]
,[,,,,,,,,,[-1]
]
,,[,,"(?:3[23679]\\d|666)\\d\\d",,,,"32000",,,[5]
]
]
,"MZ":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:1[79]|9[78])",,,,"117",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"MZ",,,,,,,,,,,,,,,,,,[,,"1(?:1[79]|9[78])",,,,"117",,,[3]
]
,,[,,"1(?:[02-5]\\d\\d|1[79]|9[78])",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NA":[,[,,"[19]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"10111",,,,"10111",,,[5]
]
,[,,,,,,,,,[-1]
]
,,,,"NA",,,,,,,,,,,,,,,,,,[,,"10111",,,,"10111",,,[5]
]
,,[,,"(?:10|93)111|(?:1\\d|9)\\d\\d",,,,"900"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NC":[,[,,"[135]\\d{1,3}",,,,,,,[2,3,4]
]
,,,[,,"1(?:0(?:00|1[23]|3[0-2]|8\\d)|[5-8])|363\\d|577",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"NC",,,,,,,,,,,,,,,,,,[,,"1[5-8]",,,,"15",,,[2]
]
,,[,,"1(?:0(?:0[06]|1[02-46]|20|3[0-25]|42|5[058]|77|88)|[5-8])|3631|5[6-8]\\d",,,,"15"]
,[,,"5(?:67|88)",,,,"567",,,[3]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NE":[,[,,"[1-3578]\\d(?:\\d(?:\\d{3})?)?",,,,,,,[2,3,6]
]
,,,[,,"1[578]|723\\d{3}",,,,"15",,,[2,6]
]
,[,,,,,,,,,[-1]
]
,,,,"NE",,,,,,,,,,,,,,,,,,[,,"1[578]|723141",,,,"15",,,[2,6]
]
,,[,,"1(?:0[01]|1[12]|2[034]|3[013]|[46]0|55?|[78])|222|333|555|723141|888",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,"1(?:0[01]|1[12]|2[034]|3[013]|[46]0|55)|222|333|555|888",,,,"100",,,[3]
]
,,[,,,,,,,,,[-1]
]
]
,"NF":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"9(?:11|55|77)",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"NF",,,,,,,,,,,,,,,,,,[,,"9(?:11|55|77)",,,,"911"]
,,[,,"9(?:11|55|77)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NG":[,[,,"[14]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"199",,,,"199",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"NG",,,,,,,,,,,,,,,,,,[,,"199",,,,"199",,,[3]
]
,,[,,"199|40700",,,,"199"]
,[,,,,,,,,,[-1]
]
,[,,"407\\d\\d",,,,"40700",,,[5]
]
,,[,,"407\\d\\d",,,,"40700",,,[5]
]
]
,"NI":[,[,,"[12467]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:1[58]|2[08])|737\\d",,,,"115"]
,[,,,,,,,,,[-1]
]
,,,,"NI",,,,,,,,,,,,,,,,,,[,,"1(?:1[58]|2[08])",,,,"115",,,[3]
]
,,[,,"1(?:1[58]|200)|4878|7(?:010|373)|12[0158]|(?:19|[267]1)00",,,,"115"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NL":[,[,,"[1349]\\d\\d(?:\\d(?:\\d{2})?)?",,,,,,,[3,4,6]
]
,,,[,,"11(?:2|6\\d{3})|911",,,,"112",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"NL",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:00[06]|1(?:11|23)))|2(?:0[0-4]|3[34]|44)|3[03-9]\\d|400|8(?:[02-9]\\d|1[0-79]))|[34]000|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"120\\d",,,,"1200",,,[4]
]
,,[,,"[34]00\\d",,,,"3000",,,[4]
]
]
,"NO":[,[,,"1\\d\\d(?:\\d(?:\\d{2})?)?",,,,,,,[3,4,6]
]
,,,[,,"11(?:[023]|6\\d{3})",,,,"110",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"NO",,,,,,,,,,,,,,,,,,[,,"11[023]",,,,"110",,,[3]
]
,,[,,"1(?:1(?:[0239]|61(?:1[17]|23))|2[048]|4(?:12|[59])|7[57]|90)",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NP":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"1(?:0[0-3]|12)",,,,"100"]
,[,,,,,,,,,[-1]
]
,,,,"NP",,,,,,,,,,,,,,,,,,[,,"1(?:0[0-3]|12)",,,,"100"]
,,[,,"1(?:0[0-3]|12)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NR":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[0-2]",,,,"110"]
,[,,,,,,,,,[-1]
]
,,,,"NR",,,,,,,,,,,,,,,,,,[,,"11[0-2]",,,,"110"]
,,[,,"1(?:1[0-2]|23|92)",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NU":[,[,,"[019]\\d\\d",,,,,,,[3]
]
,,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,,,,"NU",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"01[05]|101|999",,,,"010"]
,[,,,,,,,,,[-1]
]
,[,,"010",,,,"010"]
,,[,,,,,,,,,[-1]
]
]
,"NZ":[,[,,"\\d{3,4}",,,,,,,[3,4]
]
,,,[,,"111",,,,"111",,,[3]
]
,[,,"018",,,,"018",,,[3]
]
,,,,"NZ",,,,,,,,,,,,,,,,,,[,,"111",,,,"111",,,[3]
]
,,[,,"018|1(?:(?:1|37)1|(?:23|94)4|7[03]7)|[2-57-9]\\d{2,3}|6(?:161|26[0-3]|742)",,,,"018"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"018|(?:1(?:23|37|7[03]|94)|6(?:[12]6|74))\\d|[2-57-9]\\d{2,3}",,,,"018"]
]
,"OM":[,[,,"9\\d{3}",,,,,,,[4]
]
,,,[,,"999\\d",,,,"9990"]
,[,,,,,,,,,[-1]
]
,,,,"OM",,,,,,,,,,,,,,,,,,[,,"9999",,,,"9999"]
,,[,,"9999",,,,"9999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PA":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"PA",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"10[2-4]|911",,,,"102"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PE":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"1(?:05|1[67])",,,,"105"]
,[,,,,,,,,,[-1]
]
,,,,"PE",,,,,,,,,,,,,,,,,,[,,"1(?:05|1[67])",,,,"105"]
,,[,,"1(?:05|1[67])",,,,"105"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PF":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"PF",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"15"]
,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PG":[,[,,"[01]\\d{2,6}",,,,,,,[3,4,5,6,7]
]
,,,[,,"000|11[01]",,,,"000",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"PG",,,,,,,,,,,,,,,,,,[,,"000|11[01]",,,,"000",,,[3]
]
,,[,,"000|1(?:1[01]|5\\d\\d|6\\d{2,5})",,,,"000"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"16\\d{2,5}",,,,"1600",,,[4,5,6,7]
]
]
,"PH":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"11[27]|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"PH",,,,,,,,,,,,,,,,,,[,,"11[27]|911",,,,"112"]
,,[,,"11[27]|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PK":[,[,,"1\\d{1,3}",,,,,,,[2,3,4]
]
,,,[,,"1(?:1(?:2\\d?|5)|[56])",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"PK",,,,,,,,,,,,,,,,,,[,,"1(?:1(?:22?|5)|[56])",,,,"15"]
,,[,,"1(?:1(?:22?|5)|[56])",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PL":[,[,,"[19]\\d\\d(?:\\d{2,3})?",,,,,,,[3,5,6]
]
,,,[,,"11(?:2|6\\d{3})|99[7-9]",,,,"112",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"PL",,,,,,,,,,,,,,,,,,[,,"112|99[7-9]",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|61(?:11|23)|891[23])|9\\d{3})|9(?:8[4-7]|9[1-9])|11[68]000",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PM":[,[,,"[13]\\d(?:\\d{2})?",,,,,,,[2,4]
]
,,,[,,"1[578]",,,,"15",,,[2]
]
,[,,,,,,,,,[-1]
]
,,,,"PM",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"15",,,[2]
]
,,[,,"1[578]|3103",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,"310\\d",,,,"3100",,,[4]
]
,,[,,,,,,,,,[-1]
]
]
,"PR":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"PR",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PS":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"1(?:0[0-2]|66)",,,,"100"]
,[,,,,,,,,,[-1]
]
,,,,"PS",,,,,,,,,,,,,,,,,,[,,"10[0-2]",,,,"100"]
,,[,,"1(?:0[0-2]|44|66|99)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PT":[,[,,"1\\d\\d(?:\\d{3})?",,,,,,,[3,6]
]
,,,[,,"11(?:[25]|6\\d{3})",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"PT",,,,,,,,,,,,,,,,,,[,,"11[25]",,,,"112",,,[3]
]
,,[,,"11(?:[2578]|6(?:000|111))",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PW":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"PW",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PY":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"128|911",,,,"128"]
,[,,,,,,,,,[-1]
]
,,,,"PY",,,,,,,,,,,,,,,,,,[,,"128|911",,,,"128"]
,,[,,"1[1-4]\\d|911",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"QA":[,[,,"[129]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"999",,,,"999",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"QA",,,,,,,,,,,,,,,,,,[,,"999",,,,"999",,,[3]
]
,,[,,"999|(?:1|20|9[27]\\d)\\d\\d",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"RE":[,[,,"1\\d\\d?",,,,,,,[2,3]
]
,,,[,,"1(?:12|[578])",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"RE",,,,,,,,,,,,,,,,,,[,,"1(?:12|[578])",,,,"15"]
,,[,,"1(?:12|[578])",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"RO":[,[,,"[18]\\d\\d(?:\\d(?:\\d{2})?)?",,,,,,,[3,4,6]
]
,,,[,,"11(?:2|6\\d{3})",,,,"112",,,[3,6]
]
,[,,"(?:1(?:18\\d|[24])|8[48])\\d\\d",,,,"1200",,,[4,6]
]
,,,,"RO",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6111|8932)|[24]\\d\\d|9(?:21|3[02]|5[178]))|8[48]\\d\\d|11(?:60|83)00",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"(?:1[24]|8[48])\\d\\d",,,,"1200",,,[4]
]
]
,"RS":[,[,,"[19]\\d{1,5}",,,,,,,[2,3,4,5,6]
]
,,,[,,"112|9[2-4]",,,,"92",,,[2,3]
]
,[,,,,,,,,,[-1]
]
,,,,"RS",,,,,,,,,,,,,,,,,,[,,"112|9[2-4]",,,,"92",,,[2,3]
]
,,[,,"1[189]\\d{1,4}|9[2-4]",,,,"92"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"RU":[,[,,"[01]\\d\\d?",,,,,,,[2,3]
]
,,,[,,"112|(?:0|10)[1-3]",,,,"01"]
,[,,,,,,,,,[-1]
]
,,,,"RU",,,,,,,,,,,,,,,,,,[,,"112|(?:0|10)[1-3]",,,,"01"]
,,[,,"112|(?:0|10)[1-4]",,,,"01"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"RW":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"RW",,,,,,,,,,,,,,,,,,[,,"112",,,,"112"]
,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SA":[,[,,"[19]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"11(?:2|6\\d{3})|9(?:11|37|9[7-9])",,,,"112",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"SA",,,,,,,,,,,,,,,,,,[,,"112|9(?:11|9[79])",,,,"112",,,[3]
]
,,[,,"1(?:1(?:00|2|6111)|410|9(?:00|1[89]|9(?:099|22|91)))|9(?:0[24-79]|11|3[379]|40|66|8[5-9]|9[02-9])",,,,"112"]
,[,,"141\\d",,,,"1410",,,[4]
]
,[,,"1(?:10|41)\\d|90[24679]",,,,"902",,,[3,4]
]
,,[,,,,,,,,,[-1]
]
]
,"SB":[,[,,"[127-9]\\d\\d",,,,,,,[3]
]
,,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,,,,"SB",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"1(?:[02]\\d|1[12]|[35][01]|[49][1-9]|6[2-9]|7[7-9]|8[0-8])|269|777|835|9(?:[01]1|22|33|55|77|88|99)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SC":[,[,,"[19]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"999",,,,"999",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"SC",,,,,,,,,,,,,,,,,,[,,"999",,,,"999",,,[3]
]
,,[,,"1(?:0\\d|1[027]|2[0-8]|3[13]|4[0-2]|[59][15]|6[1-9]|7[124-6]|8[158])|9(?:6\\d\\d|99)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SD":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,,,,"SD",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SE":[,[,,"[1-37-9]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"112|(?:116\\d|900)\\d\\d",,,,"112",,,[3,5,6]
]
,[,,"11811[89]|72\\d{3}",,,,"72000",,,[5,6]
]
,,,,"SE",,,,,,,,,,,,,,,,,,[,,"112|90000",,,,"112",,,[3,5]
]
,,[,,"11(?:[25]|313|6(?:00[06]|1(?:1[17]|23))|7[0-8])|2(?:2[02358]|33|4[01]|50|6[1-4])|32[13]|8(?:22|88)|9(?:0(?:00|51)0|12)|(?:11(?:4|8[02-46-9])|7\\d\\d|90[2-4])\\d\\d|(?:118|90)1(?:[02-9]\\d|1[013-9])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"2(?:2[02358]|33|4[01]|50|6[1-4])|32[13]|8(?:22|88)|912",,,,"220",,,[3]
]
,,[,,"7\\d{4}",,,,"70000",,,[5]
]
]
,"SG":[,[,,"[179]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"99[359]",,,,"993",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"SG",,,,,,,,,,,,,,,,,,[,,"99[359]",,,,"993",,,[3]
]
,,[,,"1(?:[0136]\\d\\d|[57]\\d{2,3}|[89](?:0[1-9]|[1-9]\\d))|77222|99[02-9]",,,,"990"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"772\\d\\d",,,,"77200",,,[5]
]
]
,"SH":[,[,,"[19]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"9(?:11|99)",,,,"911",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"SH",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911",,,[3]
]
,,[,,"1\\d{2,3}|9(?:11|99)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SI":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"11(?:(?:0|6\\d)\\d\\d|[23]|8\\d\\d?)",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"SI",,,,,,,,,,,,,,,,,,[,,"11[23]",,,,"112",,,[3]
]
,,[,,"1(?:1(?:00[146]|[23]|6(?:000|1(?:11|23))|8(?:[08]|99))|9(?:059|1(?:0[12]|16)|5|70|87|9(?:00|[149])))|19(?:08|81)[09]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SJ":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[023]",,,,"110"]
,[,,,,,,,,,[-1]
]
,,,,"SJ",,,,,,,,,,,,,,,,,,[,,"11[023]",,,,"110"]
,,[,,"11[023]",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SK":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:1(?:2|6\\d{3})|5[058])",,,,"112",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"SK",,,,,,,,,,,,,,,,,,[,,"1(?:12|5[058])",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:000|111)|8[0-8])|[248]\\d{3}|5[0589])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SL":[,[,,"[069]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"(?:01|99)9",,,,"019",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"SL",,,,,,,,,,,,,,,,,,[,,"(?:01|99)9",,,,"019",,,[3]
]
,,[,,"(?:01|99)9|60400",,,,"019"]
,[,,,,,,,,,[-1]
]
,[,,"604\\d\\d",,,,"60400",,,[5]
]
,,[,,"604\\d\\d",,,,"60400",,,[5]
]
]
,"SM":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[358]",,,,"113"]
,[,,,,,,,,,[-1]
]
,,,,"SM",,,,,,,,,,,,,,,,,,[,,"11[358]",,,,"113"]
,,[,,"11[358]",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SN":[,[,,"[12]\\d{1,5}",,,,,,,[2,3,4,5,6]
]
,,,[,,"1(?:515|[78])|2(?:00|1)\\d{3}",,,,"17",,,[2,4,5,6]
]
,[,,"2(?:0[246]|[468])\\d{3}",,,,"24000",,,[5,6]
]
,,,,"SN",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17",,,[2]
]
,,[,,"1(?:1[69]|(?:[246]\\d|51)\\d)|2(?:0[0-246]|[12468])\\d{3}|1[278]",,,,"12"]
,[,,"2(?:01|2)\\d{3}",,,,"22000",,,[5,6]
]
,[,,"1[46]\\d\\d",,,,"1400",,,[4]
]
,,[,,"2[468]\\d{3}",,,,"24000",,,[5]
]
]
,"SO":[,[,,"[57-9]\\d\\d",,,,,,,[3]
]
,,,[,,"555|888|999",,,,"555"]
,[,,,,,,,,,[-1]
]
,,,,"SO",,,,,,,,,,,,,,,,,,[,,"555|888|999",,,,"555"]
,,[,,"555|777|888|999",,,,"555"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SR":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"115",,,,"115",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"SR",,,,,,,,,,,,,,,,,,[,,"115",,,,"115",,,[3]
]
,,[,,"1\\d{2,3}",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ST":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"ST",,,,,,,,,,,,,,,,,,[,,"112",,,,"112"]
,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SV":[,[,,"[49]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"911",,,,"911",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"SV",,,,,,,,,,,,,,,,,,[,,"911",,,,"911",,,[3]
]
,,[,,"40404|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,"404\\d\\d",,,,"40400",,,[5]
]
,,[,,"404\\d\\d",,,,"40400",,,[5]
]
]
,"SX":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"919",,,,"919"]
,[,,,,,,,,,[-1]
]
,,,,"SX",,,,,,,,,,,,,,,,,,[,,"919",,,,"919"]
,,[,,"919",,,,"919"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SY":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[023]",,,,"110"]
,[,,,,,,,,,[-1]
]
,,,,"SY",,,,,,,,,,,,,,,,,,[,,"11[023]",,,,"110"]
,,[,,"11[023]",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SZ":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,,,,"SZ",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TC":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"TC",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TD":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,,,,"TD",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17"]
,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TG":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:1[78]|7[127])",,,,"117",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"TG",,,,,,,,,,,,,,,,,,[,,"1(?:1[78]|7[127])",,,,"117",,,[3]
]
,,[,,"1(?:011|1[078]|7[127])",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TH":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:1(?:00|2[03]|3[3479]|7[67]|9[0246])|578|6(?:44|6[79]|88|9[16])|88\\d|9[19])|1[15]55",,,,"191"]
,[,,"1(?:113|2[23]\\d|5(?:09|56))",,,,"1113",,,[4]
]
,,,,"TH",,,,,,,,,,,,,,,,,,[,,"1(?:669|9[19])",,,,"191"]
,,[,,"1(?:0[0-2]|1(?:0[03]|1[1-35]|2[0358]|3[03-79]|4[02-489]|5[04-9]|6[04-79]|7[03-9]|8[027-9]|9[02-79])|2(?:22|3[89])|3(?:18|2[23]|3[013]|5[56]|6[45]|73)|477|5(?:0\\d|4[0-37-9]|5[1-8]|6[01679]|7[12568]|8[0-24589]|9[013589])|6(?:0[0-29]|2[03]|4[3-6]|6[1-9]|7[0257-9]|8[0158]|9[014-9])|7(?:[14]9|7[27]|90)|888|9[19])",,,,"100"]
,[,,"1(?:1(?:03|1[15]|2[58]|3[056]|4[02-49]|5[046-9]|7[03-589]|9[579])|5(?:0[0-8]|4[0-378]|5[1-478]|7[156])|6(?:20|4[356]|6[1-68]|7[057-9]|8[015]|9[0457-9]))|1(?:1[68]|3[1-35]|5[689]|60|7[17])\\d",,,,"1103",,,[4]
]
,[,,"114[89]",,,,"1148",,,[4]
]
,,[,,,,,,,,,[-1]
]
]
,"TJ":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"1(?:0[1-3]|12)",,,,"101"]
,[,,,,,,,,,[-1]
]
,,,,"TJ",,,,,,,,,,,,,,,,,,[,,"1(?:0[1-3]|12)",,,,"101"]
,,[,,"1(?:0[1-3]|12)",,,,"101"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TL":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[25]",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"TL",,,,,,,,,,,,,,,,,,[,,"11[25]",,,,"112"]
,,[,,"1(?:0[02]|1[25]|2[0138]|72|9[07])",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TM":[,[,,"0\\d",,,,,,,[2]
]
,,,[,,"0[1-3]",,,,"01"]
,[,,,,,,,,,[-1]
]
,,,,"TM",,,,,,,,,,,,,,,,,,[,,"0[1-3]",,,,"01"]
,,[,,"0[1-3]",,,,"01"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TN":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"19[078]",,,,"190"]
,[,,,,,,,,,[-1]
]
,,,,"TN",,,,,,,,,,,,,,,,,,[,,"19[078]",,,,"190"]
,,[,,"19[078]",,,,"190"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TO":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"9(?:11|22|33|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"TO",,,,,,,,,,,,,,,,,,[,,"9(?:11|22|33|99)",,,,"911"]
,,[,,"9(?:11|22|33|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TR":[,[,,"[1-9]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:1[02]|22|3[126]|4[04]|5[15-9]|6[18]|77|83)",,,,"110",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"TR",,,,,,,,,,,,,,,,,,[,,"1(?:1[02]|55)",,,,"110",,,[3]
]
,,[,,"1(?:1(?:[0239]|811)|2[126]|3(?:[12]|37?|[58]6|65?)|4(?:[014]|71)|5(?:07|[135689]|78?)|6(?:[02]6|[138]|99?)|7[0-79]|8(?:[0-578]|63?|95?))|2(?:077|268|4(?:17|23)|5(?:7[26]|82)|6[14]4|8\\d\\d|9(?:30|89))|3(?:0(?:05|72)|353|4(?:06|30|64)|502|674|747|851|9(?:1[29]|60))|4(?:0(?:25|3[12]|[47]2)|3(?:3[13]|[89]1)|439|5(?:43|55)|717|832)|5(?:145|290|[4-6]\\d\\d|772|833|9(?:[06]1|92))|6(?:236|6(?:12|39|8[59])|769)|7890|8(?:688|7(?:28|65)|85[06])|9(?:159|290)",,,,"110"]
,[,,"(?:285|542)0",,,,"2850",,,[4]
]
,[,,,,,,,,,[-1]
]
,,[,,"1(?:3(?:37|65)|44|578|699|8(?:3|63|95))|(?:1(?:3[58]|47|50|6[02])|2(?:07|26|4[12]|5[78]|6[14]|8\\d|9[38])|3(?:0[07]|[38]5|4[036]|50|67|74|9[16])|4(?:0[2-47]|3[389]|[48]3|5[45]|71)|5(?:14|29|[4-6]\\d|77|83|9[069])|6(?:23|6[138]|76)|789|8(?:68|7[26]|85)|9(?:15|29))\\d",,,,"144",,,[3,4]
]
]
,"TT":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"99[09]",,,,"990"]
,[,,,,,,,,,[-1]
]
,,,,"TT",,,,,,,,,,,,,,,,,,[,,"99[09]",,,,"990"]
,,[,,"99[09]",,,,"990"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TV":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"TV",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"1\\d\\d|911",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TW":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:1[0289]|92\\d)",,,,"110"]
,[,,"10[56]",,,,"105",,,[3]
]
,,,,"TW",,,,,,,,,,,,,,,,,,[,,"11[029]",,,,"110",,,[3]
]
,,[,,"1(?:0[4-6]|1[02389]|6[5-8]|9(?:1[0-29]|22|5[057]|68|8[05]|9[15689]))",,,,"104"]
,[,,"1(?:65|9(?:19|50|85|98))",,,,"165"]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TZ":[,[,,"[149]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"11[12]|999",,,,"111",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"TZ",,,,,,,,,,,,,,,,,,[,,"11[12]|999",,,,"111",,,[3]
]
,,[,,"11[12]|46400|999",,,,"111"]
,[,,,,,,,,,[-1]
]
,[,,"464\\d\\d",,,,"46400",,,[5]
]
,,[,,"464\\d\\d",,,,"46400",,,[5]
]
]
,"UA":[,[,,"[189]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:0[1-3]|1(?:2|6\\d{3}))",,,,"101",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"UA",,,,,,,,,,,,,,,,,,[,,"1(?:0[1-3]|12)",,,,"101",,,[3]
]
,,[,,"1(?:0[1-49]|1(?:2|6(?:000|1(?:11|23))|8\\d\\d?)|(?:[278]|5\\d)\\d)|[89]00\\d\\d?|151|1(?:06|4\\d|6)\\d\\d",,,,"101"]
,[,,,,,,,,,[-1]
]
,[,,"(?:118|[89]00)\\d\\d?",,,,"1180",,,[4,5]
]
,,[,,,,,,,,,[-1]
]
]
,"UG":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,,,,"UG",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"US":[,[,,"[1-9]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"112|[69]11",,,,"112",,,[3]
]
,[,,"24280|(?:381|968)35|4(?:3355|7553|8221)|5(?:(?:489|934)2|5928)|72078|(?:323|960)40|(?:276|414)63|(?:2(?:520|744)|7390|9968)9|(?:693|732|976)88|(?:3(?:556|825)|5294|8623|9729)4|(?:3378|4136|7642|8961|9979)6|(?:4(?:6(?:15|32)|827)|(?:591|720)8|9529)7",,,,"24280",,,[5]
]
,,,,"US",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112",,,[3]
]
,,[,,"11(?:2|5[1-47]|[68]\\d|7[0-57]|98)|[2-9]\\d{3,5}|[2-9]11",,,,"112"]
,[,,"2(?:3333|(?:4224|7562|900)2|56447|6688)|3(?:1010|2665|7404)|40404|560560|6(?:0060|22639|5246|7622)|7(?:0701|3822|4666)|8(?:(?:3825|7226)5|4816)|99099",,,,"23333",,,[5,6]
]
,[,,"336\\d\\d|[2-9]\\d{3}|[2356]11",,,,"211",,,[3,4,5]
]
,,[,,"[2-9]\\d{4,5}",,,,"20000",,,[5,6]
]
]
,"UY":[,[,,"[19]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"128|911",,,,"128",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"UY",,,,,,,,,,,,,,,,,,[,,"128|911",,,,"128",,,[3]
]
,,[,,"1(?:0[4-9]|1[2368]|2[0-3568]|787)|911",,,,"104"]
,[,,"178\\d",,,,"1780",,,[4]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"UZ":[,[,,"[04]\\d(?:\\d(?:\\d{2})?)?",,,,,,,[2,3,5]
]
,,,[,,"0(?:0[1-3]|[1-3]|50)",,,,"01",,,[2,3]
]
,[,,,,,,,,,[-1]
]
,,,,"UZ",,,,,,,,,,,,,,,,,,[,,"0(?:0[1-3]|[1-3]|50)",,,,"01",,,[2,3]
]
,,[,,"0(?:0[1-3]|[1-3]|50)|45400",,,,"01"]
,[,,,,,,,,,[-1]
]
,[,,"454\\d\\d",,,,"45400",,,[5]
]
,,[,,"454\\d\\d",,,,"45400",,,[5]
]
]
,"VA":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[2358]",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"VA",,,,,,,,,,,,,,,,,,[,,"11[2358]",,,,"112"]
,,[,,"11[2358]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VC":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"VC",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VE":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"1(?:12|71)|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"VE",,,,,,,,,,,,,,,,,,[,,"1(?:12|71)|911",,,,"112"]
,,[,,"1(?:12|71)|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VG":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"VG",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VI":[,[,,"9\\d\\d",,,,,,,[3]
]
,,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"VI",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VN":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"11[3-5]",,,,"113"]
,[,,,,,,,,,[-1]
]
,,,,"VN",,,,,,,,,,,,,,,,,,[,,"11[3-5]",,,,"113"]
,,[,,"11[3-5]",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VU":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"VU",,,,,,,,,,,,,,,,,,[,,"112",,,,"112"]
,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"WF":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"WF",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"15"]
,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"WS":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"9(?:11|9[4-69])",,,,"911"]
,[,,,,,,,,,[-1]
]
,,,,"WS",,,,,,,,,,,,,,,,,,[,,"9(?:11|9[4-69])",,,,"911"]
,,[,,"1(?:1[12]|2[0-6])|9(?:11|9[4-79])",,,,"111"]
,[,,,,,,,,,[-1]
]
,[,,"12[0-6]",,,,"120"]
,,[,,,,,,,,,[-1]
]
]
,"XK":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"1(?:12|9[2-4])",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"XK",,,,,,,,,,,,,,,,,,[,,"1(?:12|9[2-4])",,,,"112"]
,,[,,"1(?:12|9[2-4])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"YE":[,[,,"1\\d\\d",,,,,,,[3]
]
,,,[,,"19[1459]",,,,"191"]
,[,,,,,,,,,[-1]
]
,,,,"YE",,,,,,,,,,,,,,,,,,[,,"19[1459]",,,,"191"]
,,[,,"19[1459]",,,,"191"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"YT":[,[,,"1\\d\\d?",,,,,,,[2,3]
]
,,,[,,"1(?:12|5)",,,,"15"]
,[,,,,,,,,,[-1]
]
,,,,"YT",,,,,,,,,,,,,,,,,,[,,"1(?:12|5)",,,,"15"]
,,[,,"1(?:12|5)",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ZA":[,[,,"[134]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:01\\d\\d|12)",,,,"112",,,[3,5]
]
,[,,"41(?:348|851)",,,,"41348",,,[5]
]
,,,,"ZA",,,,,,,,,,,,,,,,,,[,,"1(?:01(?:11|77)|12)",,,,"112",,,[3,5]
]
,,[,,"1(?:0(?:1(?:11|77)|20|7)|1[12]|77(?:3[237]|[45]7|6[279]|9[26]))|[34]\\d{4}",,,,"107"]
,[,,"3(?:078[23]|7(?:064|567)|8126)|4(?:394[16]|7751|8837)|4[23]699",,,,"30782",,,[5]
]
,[,,"111",,,,"111",,,[3]
]
,,[,,"[34]\\d{4}",,,,"30000",,,[5]
]
]
,"ZM":[,[,,"[19]\\d\\d",,,,,,,[3]
]
,,,[,,"112|99[139]",,,,"112"]
,[,,,,,,,,,[-1]
]
,,,,"ZM",,,,,,,,,,,,,,,,,,[,,"112|99[139]",,,,"112"]
,,[,,"112|99[139]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ZW":[,[,,"[139]\\d\\d(?:\\d{2})?",,,,,,,[3,5]
]
,,,[,,"112|9(?:5[023]|61|9[3-59])",,,,"112",,,[3]
]
,[,,"3[013-57-9]\\d{3}",,,,"30000",,,[5]
]
,,,,"ZW",,,,,,,,,,,,,,,,,,[,,"112|99[3-59]",,,,"112",,,[3]
]
,,[,,"11[2469]|3[013-57-9]\\d{3}|9(?:5[023]|6[0-25]|9[3-59])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"114|9(?:5[023]|6[0-25])",,,,"114",,,[3]
]
,,[,,,,,,,,,[-1]
]
]
};
