/*
 * Copyright (C) 2013 The Libphonenumber Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* This file is automatically generated by {@link BuildMetadataProtoFromXml}.
 * Please don't modify it directly.
 */

package com.google.i18n.phonenumbers;

import java.util.HashSet;
import java.util.Set;

public class ShortNumbersRegionCodeSet {
  // A set of all region codes for which data is available.
  static Set<String> getRegionCodeSet() {
    // The capacity is set to 320 as there are 240 different entries,
    // and this offers a load factor of roughly 0.75.
    Set<String> regionCodeSet = new HashSet<String>(320);

    regionCodeSet.add("AC");
    regionCodeSet.add("AD");
    regionCodeSet.add("AE");
    regionCodeSet.add("AF");
    regionCodeSet.add("AG");
    regionCodeSet.add("AI");
    regionCodeSet.add("AL");
    regionCodeSet.add("AM");
    regionCodeSet.add("AO");
    regionCodeSet.add("AR");
    regionCodeSet.add("AS");
    regionCodeSet.add("AT");
    regionCodeSet.add("AU");
    regionCodeSet.add("AW");
    regionCodeSet.add("AX");
    regionCodeSet.add("AZ");
    regionCodeSet.add("BA");
    regionCodeSet.add("BB");
    regionCodeSet.add("BD");
    regionCodeSet.add("BE");
    regionCodeSet.add("BF");
    regionCodeSet.add("BG");
    regionCodeSet.add("BH");
    regionCodeSet.add("BI");
    regionCodeSet.add("BJ");
    regionCodeSet.add("BL");
    regionCodeSet.add("BM");
    regionCodeSet.add("BN");
    regionCodeSet.add("BO");
    regionCodeSet.add("BQ");
    regionCodeSet.add("BR");
    regionCodeSet.add("BS");
    regionCodeSet.add("BT");
    regionCodeSet.add("BW");
    regionCodeSet.add("BY");
    regionCodeSet.add("BZ");
    regionCodeSet.add("CA");
    regionCodeSet.add("CC");
    regionCodeSet.add("CD");
    regionCodeSet.add("CF");
    regionCodeSet.add("CG");
    regionCodeSet.add("CH");
    regionCodeSet.add("CI");
    regionCodeSet.add("CK");
    regionCodeSet.add("CL");
    regionCodeSet.add("CM");
    regionCodeSet.add("CN");
    regionCodeSet.add("CO");
    regionCodeSet.add("CR");
    regionCodeSet.add("CU");
    regionCodeSet.add("CV");
    regionCodeSet.add("CW");
    regionCodeSet.add("CX");
    regionCodeSet.add("CY");
    regionCodeSet.add("CZ");
    regionCodeSet.add("DE");
    regionCodeSet.add("DJ");
    regionCodeSet.add("DK");
    regionCodeSet.add("DM");
    regionCodeSet.add("DO");
    regionCodeSet.add("DZ");
    regionCodeSet.add("EC");
    regionCodeSet.add("EE");
    regionCodeSet.add("EG");
    regionCodeSet.add("EH");
    regionCodeSet.add("ER");
    regionCodeSet.add("ES");
    regionCodeSet.add("ET");
    regionCodeSet.add("FI");
    regionCodeSet.add("FJ");
    regionCodeSet.add("FK");
    regionCodeSet.add("FM");
    regionCodeSet.add("FO");
    regionCodeSet.add("FR");
    regionCodeSet.add("GA");
    regionCodeSet.add("GB");
    regionCodeSet.add("GD");
    regionCodeSet.add("GE");
    regionCodeSet.add("GF");
    regionCodeSet.add("GG");
    regionCodeSet.add("GH");
    regionCodeSet.add("GI");
    regionCodeSet.add("GL");
    regionCodeSet.add("GM");
    regionCodeSet.add("GN");
    regionCodeSet.add("GP");
    regionCodeSet.add("GR");
    regionCodeSet.add("GT");
    regionCodeSet.add("GU");
    regionCodeSet.add("GW");
    regionCodeSet.add("GY");
    regionCodeSet.add("HK");
    regionCodeSet.add("HN");
    regionCodeSet.add("HR");
    regionCodeSet.add("HT");
    regionCodeSet.add("HU");
    regionCodeSet.add("ID");
    regionCodeSet.add("IE");
    regionCodeSet.add("IL");
    regionCodeSet.add("IM");
    regionCodeSet.add("IN");
    regionCodeSet.add("IQ");
    regionCodeSet.add("IR");
    regionCodeSet.add("IS");
    regionCodeSet.add("IT");
    regionCodeSet.add("JE");
    regionCodeSet.add("JM");
    regionCodeSet.add("JO");
    regionCodeSet.add("JP");
    regionCodeSet.add("KE");
    regionCodeSet.add("KG");
    regionCodeSet.add("KH");
    regionCodeSet.add("KI");
    regionCodeSet.add("KM");
    regionCodeSet.add("KN");
    regionCodeSet.add("KP");
    regionCodeSet.add("KR");
    regionCodeSet.add("KW");
    regionCodeSet.add("KY");
    regionCodeSet.add("KZ");
    regionCodeSet.add("LA");
    regionCodeSet.add("LB");
    regionCodeSet.add("LC");
    regionCodeSet.add("LI");
    regionCodeSet.add("LK");
    regionCodeSet.add("LR");
    regionCodeSet.add("LS");
    regionCodeSet.add("LT");
    regionCodeSet.add("LU");
    regionCodeSet.add("LV");
    regionCodeSet.add("LY");
    regionCodeSet.add("MA");
    regionCodeSet.add("MC");
    regionCodeSet.add("MD");
    regionCodeSet.add("ME");
    regionCodeSet.add("MF");
    regionCodeSet.add("MG");
    regionCodeSet.add("MH");
    regionCodeSet.add("MK");
    regionCodeSet.add("ML");
    regionCodeSet.add("MM");
    regionCodeSet.add("MN");
    regionCodeSet.add("MO");
    regionCodeSet.add("MP");
    regionCodeSet.add("MQ");
    regionCodeSet.add("MR");
    regionCodeSet.add("MS");
    regionCodeSet.add("MT");
    regionCodeSet.add("MU");
    regionCodeSet.add("MV");
    regionCodeSet.add("MW");
    regionCodeSet.add("MX");
    regionCodeSet.add("MY");
    regionCodeSet.add("MZ");
    regionCodeSet.add("NA");
    regionCodeSet.add("NC");
    regionCodeSet.add("NE");
    regionCodeSet.add("NF");
    regionCodeSet.add("NG");
    regionCodeSet.add("NI");
    regionCodeSet.add("NL");
    regionCodeSet.add("NO");
    regionCodeSet.add("NP");
    regionCodeSet.add("NR");
    regionCodeSet.add("NU");
    regionCodeSet.add("NZ");
    regionCodeSet.add("OM");
    regionCodeSet.add("PA");
    regionCodeSet.add("PE");
    regionCodeSet.add("PF");
    regionCodeSet.add("PG");
    regionCodeSet.add("PH");
    regionCodeSet.add("PK");
    regionCodeSet.add("PL");
    regionCodeSet.add("PM");
    regionCodeSet.add("PR");
    regionCodeSet.add("PS");
    regionCodeSet.add("PT");
    regionCodeSet.add("PW");
    regionCodeSet.add("PY");
    regionCodeSet.add("QA");
    regionCodeSet.add("RE");
    regionCodeSet.add("RO");
    regionCodeSet.add("RS");
    regionCodeSet.add("RU");
    regionCodeSet.add("RW");
    regionCodeSet.add("SA");
    regionCodeSet.add("SB");
    regionCodeSet.add("SC");
    regionCodeSet.add("SD");
    regionCodeSet.add("SE");
    regionCodeSet.add("SG");
    regionCodeSet.add("SH");
    regionCodeSet.add("SI");
    regionCodeSet.add("SJ");
    regionCodeSet.add("SK");
    regionCodeSet.add("SL");
    regionCodeSet.add("SM");
    regionCodeSet.add("SN");
    regionCodeSet.add("SO");
    regionCodeSet.add("SR");
    regionCodeSet.add("ST");
    regionCodeSet.add("SV");
    regionCodeSet.add("SX");
    regionCodeSet.add("SY");
    regionCodeSet.add("SZ");
    regionCodeSet.add("TC");
    regionCodeSet.add("TD");
    regionCodeSet.add("TG");
    regionCodeSet.add("TH");
    regionCodeSet.add("TJ");
    regionCodeSet.add("TL");
    regionCodeSet.add("TM");
    regionCodeSet.add("TN");
    regionCodeSet.add("TO");
    regionCodeSet.add("TR");
    regionCodeSet.add("TT");
    regionCodeSet.add("TV");
    regionCodeSet.add("TW");
    regionCodeSet.add("TZ");
    regionCodeSet.add("UA");
    regionCodeSet.add("UG");
    regionCodeSet.add("US");
    regionCodeSet.add("UY");
    regionCodeSet.add("UZ");
    regionCodeSet.add("VA");
    regionCodeSet.add("VC");
    regionCodeSet.add("VE");
    regionCodeSet.add("VG");
    regionCodeSet.add("VI");
    regionCodeSet.add("VN");
    regionCodeSet.add("VU");
    regionCodeSet.add("WF");
    regionCodeSet.add("WS");
    regionCodeSet.add("XK");
    regionCodeSet.add("YE");
    regionCodeSet.add("YT");
    regionCodeSet.add("ZA");
    regionCodeSet.add("ZM");
    regionCodeSet.add("ZW");

    return regionCodeSet;
  }
}
