/**
 * @license
 * Copyright (C) 2010 The Libphonenumber Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generated metadata for file
 * ../resources/PhoneNumberMetadata.xml
 * @author Nikolaos Trogkanis
 */

goog.provide('i18n.phonenumbers.metadata');

/**
 * A mapping from a country calling code to the region codes which denote the
 * region represented by that country calling code. In the case of multiple
 * countries sharing a calling code, such as the NANPA regions, the one
 * indicated with "isMainCountryForCode" in the metadata should be first.
 * @type {!Object.<number, Array.<string>>}
 */
i18n.phonenumbers.metadata.countryCodeToRegionCodeMap = {
1:["US","AG","AI","AS","BB","BM","BS","CA","DM","DO","GD","GU","JM","KN","KY","LC","MP","MS","PR","SX","TC","TT","VC","VG","VI"]
,7:["RU","KZ"]
,20:["EG"]
,27:["ZA"]
,30:["GR"]
,31:["NL"]
,32:["BE"]
,33:["FR"]
,34:["ES"]
,36:["HU"]
,39:["IT","VA"]
,40:["RO"]
,41:["CH"]
,43:["AT"]
,44:["GB","GG","IM","JE"]
,45:["DK"]
,46:["SE"]
,47:["NO","SJ"]
,48:["PL"]
,49:["DE"]
,51:["PE"]
,52:["MX"]
,53:["CU"]
,54:["AR"]
,55:["BR"]
,56:["CL"]
,57:["CO"]
,58:["VE"]
,60:["MY"]
,61:["AU","CC","CX"]
,62:["ID"]
,63:["PH"]
,64:["NZ"]
,65:["SG"]
,66:["TH"]
,81:["JP"]
,82:["KR"]
,84:["VN"]
,86:["CN"]
,90:["TR"]
,91:["IN"]
,92:["PK"]
,93:["AF"]
,94:["LK"]
,95:["MM"]
,98:["IR"]
,211:["SS"]
,212:["MA","EH"]
,213:["DZ"]
,216:["TN"]
,218:["LY"]
,220:["GM"]
,221:["SN"]
,222:["MR"]
,223:["ML"]
,224:["GN"]
,225:["CI"]
,226:["BF"]
,227:["NE"]
,228:["TG"]
,229:["BJ"]
,230:["MU"]
,231:["LR"]
,232:["SL"]
,233:["GH"]
,234:["NG"]
,235:["TD"]
,236:["CF"]
,237:["CM"]
,238:["CV"]
,239:["ST"]
,240:["GQ"]
,241:["GA"]
,242:["CG"]
,243:["CD"]
,244:["AO"]
,245:["GW"]
,246:["IO"]
,247:["AC"]
,248:["SC"]
,249:["SD"]
,250:["RW"]
,251:["ET"]
,252:["SO"]
,253:["DJ"]
,254:["KE"]
,255:["TZ"]
,256:["UG"]
,257:["BI"]
,258:["MZ"]
,260:["ZM"]
,261:["MG"]
,262:["RE","YT"]
,263:["ZW"]
,264:["NA"]
,265:["MW"]
,266:["LS"]
,267:["BW"]
,268:["SZ"]
,269:["KM"]
,290:["SH","TA"]
,291:["ER"]
,297:["AW"]
,298:["FO"]
,299:["GL"]
,350:["GI"]
,351:["PT"]
,352:["LU"]
,353:["IE"]
,354:["IS"]
,355:["AL"]
,356:["MT"]
,357:["CY"]
,358:["FI","AX"]
,359:["BG"]
,370:["LT"]
,371:["LV"]
,372:["EE"]
,373:["MD"]
,374:["AM"]
,375:["BY"]
,376:["AD"]
,377:["MC"]
,378:["SM"]
,380:["UA"]
,381:["RS"]
,382:["ME"]
,385:["HR"]
,386:["SI"]
,387:["BA"]
,389:["MK"]
,420:["CZ"]
,421:["SK"]
,423:["LI"]
,500:["FK"]
,501:["BZ"]
,502:["GT"]
,503:["SV"]
,504:["HN"]
,505:["NI"]
,506:["CR"]
,507:["PA"]
,508:["PM"]
,509:["HT"]
,590:["GP","BL","MF"]
,591:["BO"]
,592:["GY"]
,593:["EC"]
,594:["GF"]
,595:["PY"]
,596:["MQ"]
,597:["SR"]
,598:["UY"]
,599:["CW","BQ"]
,670:["TL"]
,672:["NF"]
,673:["BN"]
,674:["NR"]
,675:["PG"]
,676:["TO"]
,677:["SB"]
,678:["VU"]
,679:["FJ"]
,680:["PW"]
,681:["WF"]
,682:["CK"]
,683:["NU"]
,685:["WS"]
,686:["KI"]
,687:["NC"]
,688:["TV"]
,689:["PF"]
,690:["TK"]
,691:["FM"]
,692:["MH"]
,800:["001"]
,808:["001"]
,850:["KP"]
,852:["HK"]
,853:["MO"]
,855:["KH"]
,856:["LA"]
,870:["001"]
,878:["001"]
,880:["BD"]
,881:["001"]
,882:["001"]
,883:["001"]
,886:["TW"]
,888:["001"]
,960:["MV"]
,961:["LB"]
,962:["JO"]
,963:["SY"]
,964:["IQ"]
,965:["KW"]
,966:["SA"]
,967:["YE"]
,968:["OM"]
,970:["PS"]
,971:["AE"]
,972:["IL"]
,973:["BH"]
,974:["QA"]
,975:["BT"]
,976:["MN"]
,977:["NP"]
,979:["001"]
,992:["TJ"]
,993:["TM"]
,994:["AZ"]
,995:["GE"]
,996:["KG"]
,998:["UZ"]
};

/**
 * A mapping from a region code to the PhoneMetadata for that region.
 * @type {!Object.<string, Array>}
 */
i18n.phonenumbers.metadata.countryToMetadata = {
"AC":[,[,,"[46]\\d{4}|[01589]\\d{5}",,,,,,,[5,6]
]
,[,,"6[2-467]\\d{3}",,,,,,,[5]
]
,[,,"4\\d{4}",,,,,,,[5]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"AC",247,"00",,,,,,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"[01589]\\d{5}",,,,,,,[6]
]
,,,[,,,,,,,,,[-1]
]
]
,"AD":[,[,,"[16]\\d{5,8}|[37-9]\\d{5}",,,,,,,[6,8,9]
]
,[,,"[78]\\d{5}",,,,,,,[6]
]
,[,,"(?:3\\d|6(?:[0-8]|90\\d{2}))\\d{4}",,,,,,,[6,9]
]
,[,,"180[02]\\d{4}",,,,,,,[8]
]
,[,,"[19]\\d{5}",,,,,,,[6]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"AD",376,"00",,,,,,,,[[,"(\\d{3})(\\d{3})","$1 $2",["[137-9]|6[0-8]"]
]
,[,"(\\d{4})(\\d{4})","$1 $2",["180","180[02]"]
]
,[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["690"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"1800\\d{4}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"AE":[,[,,"[2-79]\\d{7,8}|800\\d{2,9}",,,,,,,[5,6,7,8,9,10,11,12]
]
,[,,"[2-4679][2-8]\\d{6}",,,,,,,[8]
,[7]
]
,[,,"5[024-68]\\d{7}",,,,,,,[9]
]
,[,,"400\\d{6}|800\\d{2,9}"]
,[,,"900[02]\\d{5}",,,,,,,[9]
]
,[,,"700[05]\\d{5}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"AE",971,"00","0",,,"0",,,,[[,"([2-4679])(\\d{3})(\\d{4})","$1 $2 $3",["[2-4679][2-8]"]
,"0$1"]
,[,"(5\\d)(\\d{3})(\\d{4})","$1 $2 $3",["5"]
,"0$1"]
,[,"([479]00)(\\d)(\\d{5})","$1 $2 $3",["[479]00"]
,"$1"]
,[,"([68]00)(\\d{2,9})","$1 $2",["[68]00"]
,"$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"600[25]\\d{5}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
]
,"AF":[,[,,"[2-7]\\d{8}",,,,,,,[9]
,[7]
]
,[,,"(?:[25][0-8]|[34][0-4]|6[0-5])[2-9]\\d{6}",,,,,,,,[7]
]
,[,,"7(?:[014-9]\\d|2[89]|30)\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"AF",93,"00","0",,,"0",,,,[[,"([2-7]\\d)(\\d{3})(\\d{4})","$1 $2 $3",["[2-7]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"AG":[,[,,"[2589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"268(?:4(?:6[0-38]|84)|56[0-2])\\d{4}",,,,,,,,[7]
]
,[,,"268(?:464|7(?:1[3-9]|2\\d|3[246]|64|7[0-689]|8[02-68]))\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,"26848[01]\\d{4}",,,,,,,,[7]
]
,"AG",1,"011","1",,,"1",,,,,,[,,"26840[69]\\d{4}",,,,,,,,[7]
]
,,"268",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"AI":[,[,,"[2589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"2644(?:6[12]|9[78])\\d{4}",,,,,,,,[7]
]
,[,,"264(?:235|476|5(?:3[6-9]|8[1-4])|7(?:29|72))\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"AI",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"264",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"AL":[,[,,"[2-57]\\d{7}|6\\d{8}|8\\d{5,7}|9\\d{5}",,,,,,,[6,7,8,9]
,[5]
]
,[,,"(?:[2358](?:[16-9]\\d[2-9]|[2-5][2-9]\\d)|4(?:[2-57-9][2-9]\\d|6\\d{2}))\\d{4}",,,,,,,[8]
,[5,6,7]
]
,[,,"6(?:[689][2-9]|7[2-6])\\d{6}",,,,,,,[9]
]
,[,,"800\\d{4}",,,,,,,[7]
]
,[,,"900[1-9]\\d{2}",,,,,,,[6]
]
,[,,"808[1-9]\\d{2}",,,,,,,[6]
]
,[,,"700[2-9]\\d{4}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,"AL",355,"00","0",,,"0",,,,[[,"(4)(\\d{3})(\\d{4})","$1 $2 $3",["4[0-6]"]
,"0$1"]
,[,"(6\\d)(\\d{3})(\\d{4})","$1 $2 $3",["6"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["[2358][2-5]|4[7-9]"]
,"0$1"]
,[,"(\\d{3})(\\d{3,5})","$1 $2",["[235][16-9]|[79]|8[016-9]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"AM":[,[,,"[1-9]\\d{7}",,,,,,,[8]
,[5,6]
]
,[,,"(?:1[0-2]\\d|2(?:2[2-46]|3[1-8]|4[2-69]|5[2-7]|6[1-9]|8[1-7])|3[12]2|47\\d)\\d{5}",,,,,,,,[5,6]
]
,[,,"(?:4[1349]|55|77|88|9[1-9])\\d{6}"]
,[,,"800\\d{5}"]
,[,,"90[016]\\d{5}"]
,[,,"80[1-4]\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,"60(?:2[078]|[3-7]\\d|8[0-5])\\d{4}"]
,"AM",374,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{6})","$1 $2",["1|47"]
,"(0$1)"]
,[,"(\\d{2})(\\d{6})","$1 $2",["4[1349]|[5-7]|88|9[1-9]"]
,"0$1"]
,[,"(\\d{3})(\\d{5})","$1 $2",["[23]"]
,"(0$1)"]
,[,"(\\d{3})(\\d{2})(\\d{3})","$1 $2 $3",["8|90"]
,"0 $1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"AO":[,[,,"[29]\\d{8}",,,,,,,[9]
]
,[,,"2\\d(?:[26-9]\\d|\\d[26-9])\\d{5}"]
,[,,"9[1-49]\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"AO",244,"00",,,,,,,,[[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"AR":[,[,,"11\\d{8}|[2368]\\d{9}|9\\d{10}",,,,,,,[10,11]
,[6,7,8]
]
,[,,"11\\d{8}|(?:2(?:2(?:[013]\\d|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8]|[067]\\d)|4(?:7[3-8]|9\\d)|6(?:[01346]\\d|2[24-6]|5[15-8])|80\\d|9(?:[0124789]\\d|3[1-6]|5[234]|6[2-46]))|3(?:3(?:2[79]|6\\d|8[2578])|4(?:[78]\\d|0[0124-9]|[1-35]\\d|4[24-7]|6[02-9]|9[123678])|5(?:[138]\\d|2[1245]|4[1-9]|6[2-4]|7[1-6])|6[24]\\d|7(?:[0469]\\d|1[1568]|2[013-9]|3[145]|5[14-8]|7[2-57]|8[0-24-9])|8(?:[013578]\\d|2[15-7]|4[13-6]|6[1-357-9]|9[124]))|670\\d)\\d{6}",,,,,,,[10]
,[6,7,8]
]
,[,,"675\\d{7}|9(?:11[2-9]\\d{7}|(?:2(?:2[013]|3[067]|49|6[01346]|80|9[147-9])|3(?:36|4[12358]|5[138]|6[24]|7[069]|8[013578]))[2-9]\\d{6}|\\d{4}[2-9]\\d{5})",,,,,,,,[6,7,8]
]
,[,,"800\\d{7}",,,,,,,[10]
]
,[,,"60[04579]\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"AR",54,"00","0",,,"0?(?:(11|2(?:2(?:02?|[13]|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:02?|1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8]|[67])|4(?:7[3-578]|9)|6(?:[0136]|2[24-6]|4[6-8]?|5[15-8])|80|9(?:0[1-3]|[19]|2\\d|3[1-6]|4[02568]?|5[2-4]|6[2-46]|72?|8[23]?))|3(?:3(?:2[79]|6|8[2578])|4(?:0[0-24-9]|[12]|3[5-8]?|4[24-7]|5[4-68]?|6[02-9]|7[126]|8[2379]?|9[1-36-8])|5(?:1|2[1245]|3[237]?|4[1-46-9]|6[2-4]|7[1-6]|8[2-5]?)|6[24]|7(?:[069]|1[1568]|2[15]|3[145]|4[13]|5[14-8]|7[2-57]|8[126])|8(?:[01]|2[15-7]|3[2578]?|4[13-6]|5[4-8]?|6[1-357-9]|7[36-8]?|8[5-8]?|9[124])))?15)?","9$1",,,[[,"([68]\\d{2})(\\d{3})(\\d{4})","$1-$2-$3",["[68]"]
,"0$1"]
,[,"(\\d{2})(\\d{4})","$1-$2",["[2-9]"]
,"$1"]
,[,"(\\d{3})(\\d{4})","$1-$2",["[2-9]"]
,"$1"]
,[,"(\\d{4})(\\d{4})","$1-$2",["[2-9]"]
,"$1"]
,[,"(9)(11)(\\d{4})(\\d{4})","$2 15-$3-$4",["911"]
,"0$1"]
,[,"(9)(\\d{3})(\\d{3})(\\d{4})","$2 15-$3-$4",["9(?:2[2-4689]|3[3-8])","9(?:2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578]))","9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))","9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))"]
,"0$1"]
,[,"(9)(\\d{4})(\\d{2})(\\d{4})","$2 15-$3-$4",["9[23]"]
,"0$1"]
,[,"(11)(\\d{4})(\\d{4})","$1 $2-$3",["11"]
,"0$1",,1]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2-$3",["2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578])","2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))","2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))"]
,"0$1",,1]
,[,"(\\d{4})(\\d{2})(\\d{4})","$1 $2-$3",["[23]"]
,"0$1",,1]
,[,"(\\d{3})","$1",["1[0-2]|911"]
,"$1"]
]
,[[,"([68]\\d{2})(\\d{3})(\\d{4})","$1-$2-$3",["[68]"]
,"0$1"]
,[,"(9)(11)(\\d{4})(\\d{4})","$1 $2 $3-$4",["911"]
]
,[,"(9)(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3-$4",["9(?:2[2-4689]|3[3-8])","9(?:2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578]))","9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))","9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))"]
]
,[,"(9)(\\d{4})(\\d{2})(\\d{4})","$1 $2 $3-$4",["9[23]"]
]
,[,"(11)(\\d{4})(\\d{4})","$1 $2-$3",["11"]
,"0$1",,1]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2-$3",["2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578])","2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))","2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))"]
,"0$1",,1]
,[,"(\\d{4})(\\d{2})(\\d{4})","$1 $2-$3",["[23]"]
,"0$1",,1]
]
,[,,,,,,,,,[-1]
]
,,,[,,"810\\d{7}",,,,,,,[10]
]
,[,,"810\\d{7}",,,,,,,[10]
]
,,,[,,,,,,,,,[-1]
]
]
,"AS":[,[,,"[5689]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"6846(?:22|33|44|55|77|88|9[19])\\d{4}",,,,,,,,[7]
]
,[,,"684(?:2(?:5[2468]|72)|7(?:3[13]|70))\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"AS",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"684",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"AT":[,[,,"[1-9]\\d{3,12}",,,,,,,[4,5,6,7,8,9,10,11,12,13]
,[3]
]
,[,,"1\\d{3,12}|(?:2(?:1[467]|2[13-8]|5[2357]|6[1-46-8]|7[1-8]|8[124-7]|9[1458])|3(?:1[1-8]|3[23568]|4[5-7]|5[1378]|6[1-38]|8[3-68])|4(?:2[1-8]|35|63|7[1368]|8[2457])|5(?:12|2[1-8]|3[357]|4[147]|5[12578]|6[37])|6(?:13|2[1-47]|4[1-35-8]|5[468]|62)|7(?:2[1-8]|3[25]|4[13478]|5[68]|6[16-8]|7[1-6]|9[45]))\\d{3,10}",,,,,,,,[3]
]
,[,,"6(?:5[0-3579]|6[013-9]|[7-9]\\d)\\d{4,10}",,,,,,,[7,8,9,10,11,12,13]
]
,[,,"800\\d{6,10}",,,,,,,[9,10,11,12,13]
]
,[,,"9(?:0[01]|3[019])\\d{6,10}",,,,,,,[9,10,11,12,13]
]
,[,,"8(?:10\\d|2(?:[01]\\d|8\\d?))\\d{5,9}",,,,,,,[8,9,10,11,12,13]
]
,[,,,,,,,,,[-1]
]
,[,,"780\\d{6,10}",,,,,,,[9,10,11,12,13]
]
,"AT",43,"00","0",,,"0",,,,[[,"(116\\d{3})","$1",["116"]
,"$1"]
,[,"(1)(\\d{3,12})","$1 $2",["1"]
,"0$1"]
,[,"(5\\d)(\\d{3,5})","$1 $2",["5[079]"]
,"0$1"]
,[,"(5\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["5[079]"]
,"0$1"]
,[,"(5\\d)(\\d{4})(\\d{4,7})","$1 $2 $3",["5[079]"]
,"0$1"]
,[,"(\\d{3})(\\d{3,10})","$1 $2",["(?:31|4)6|51|6(?:5[0-3579]|[6-9])|7(?:[28]0|32)|[89]"]
,"0$1"]
,[,"(\\d{4})(\\d{3,9})","$1 $2",["2|3(?:1[1-578]|[3-8])|4[2378]|5[2-6]|6(?:[12]|4[1-9]|5[468])|7(?:[24][1-8]|35|[5-79])"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"5(?:(?:0[1-9]|17)\\d{2,10}|[79]\\d{3,11})|720\\d{6,10}",,,,,,,[5,6,7,8,9,10,11,12,13]
]
,,,[,,,,,,,,,[-1]
]
]
,"AU":[,[,,"1\\d{4,9}|[2-578]\\d{8}",,,,,,,[5,6,7,8,9,10]
]
,[,,"[237]\\d{8}|8(?:51(?:0(?:0[03-9]|[1247]\\d|3[2-9]|5[0-8]|6[1-9]|8[0-6])|1(?:1[69]|[23]\\d|4[0-4]))|[6-8]\\d{4}|9(?:[02-9]\\d{3}|1(?:[0-57-9]\\d{2}|6[0135-9]\\d)))\\d{3}",,,,,,,[9]
,[8]
]
,[,,"14(?:5\\d|71)\\d{5}|4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[6-9]|7[02-9]|8[12457-9]|9[017-9])\\d{6}",,,,,,,[9]
]
,[,,"180(?:0\\d{3}|2)\\d{3}",,,,,,,[7,10]
]
,[,,"19(?:0[0126]\\d|[679])\\d{5}",,,,,,,[8,10]
]
,[,,"13(?:00\\d{3}|45[0-4]|\\d)\\d{3}",,,,,,,[6,8,10]
]
,[,,"500\\d{6}",,,,,,,[9]
]
,[,,"550\\d{6}",,,,,,,[9]
]
,"AU",61,"(?:14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011)|001[14-689]","0",,,"0",,"0011",,[[,"([2378])(\\d{4})(\\d{4})","$1 $2 $3",["[2378]"]
,"(0$1)"]
,[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["14|[45]"]
,"0$1"]
,[,"(16)(\\d{3,4})","$1 $2",["16"]
,"0$1"]
,[,"(16)(\\d{3})(\\d{2,4})","$1 $2 $3",["16"]
,"0$1"]
,[,"(1[389]\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["1[389]0","1(?:[38]0|9)0"]
]
,[,"(180)(2\\d{3})","$1 $2",["180","1802"]
]
,[,"(19\\d)(\\d{3})","$1 $2",["19[13]"]
]
,[,"(19\\d{2})(\\d{4})","$1 $2",["19[679]"]
]
,[,"(13)(\\d{2})(\\d{2})","$1 $2 $3",["13[1-9]"]
]
]
,,[,,"16\\d{3,7}",,,,,,,[5,6,7,8,9]
]
,1,,[,,"1(?:3(?:00\\d{3}|45[0-4]|\\d)\\d{3}|80(?:0\\d{6}|2\\d{3}))",,,,,,,[6,7,8,10]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"AW":[,[,,"[25-9]\\d{6}",,,,,,,[7]
]
,[,,"5(?:2\\d|8[1-9])\\d{4}"]
,[,,"(?:290|5[69]\\d|6(?:[03]0|22|4[0-2]|[69]\\d)|7(?:[34]\\d|7[07])|9(?:6[45]|9[4-8]))\\d{4}"]
,[,,"800\\d{4}"]
,[,,"900\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"28\\d{5}|501\\d{4}"]
,"AW",297,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"AX":[,[,,"[13]\\d{5,9}|2\\d{4,9}|4\\d{6,10}|5\\d{6,9}|[67]\\d{7,9}|8\\d{7,8}",,,,,,,[5,6,7,8,9,10]
]
,[,,"18[1-8]\\d{4,6}",,,,,,,[7,8,9]
]
,[,,"4(?:[0-8]\\d{5,8}|9\\d{9})|50\\d{6,8}",,,,,,,[7,8,9,10]
]
,[,,"800\\d{5,6}",,,,,,,[8,9]
]
,[,,"[67]00\\d{5,6}",,,,,,,[8,9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"AX",358,"00|99(?:[02469]|5(?:11|33|5[59]|88|9[09]))","0",,,"0",,"00",,,,[,,,,,,,,,[-1]
]
,,,[,,"100\\d{4,6}|20(?:0\\d{4,6}|2[023]\\d{4,5}|9[89]\\d{1,6})|300\\d{3,7}|60(?:[12]\\d{5,6}|6\\d{7})|7(?:1\\d{7}|3\\d{8}|5[03-9]\\d{5,6})"]
,[,,"10(?:0\\d{4,6}|[1-37-9]\\d{5,7}|[46]\\d{3,7}|5\\d{4,7})|2(?:0(?:0\\d{4,6}|[1346-8]\\d{5,7}|2(?:[023]\\d{4,5}|[14-9]\\d{4,6})|5(?:\\d{3}|\\d{5,7})|9(?:[0-7]\\d{4,6}|[89]\\d{1,6}))|9\\d{5,8})|3(?:0(?:0\\d{3,7}|[1-57-9]\\d{5,7}|6(?:\\d{3}|\\d{5,7}))|44\\d{3}|93\\d{5,7})|60(?:[12]\\d{5,6}|6\\d{7})|7(?:1\\d{7}|3\\d{8}|5[03-9]\\d{5,6})"]
,,,[,,,,,,,,,[-1]
]
]
,"AZ":[,[,,"[1-9]\\d{8}",,,,,,,[9]
,[7]
]
,[,,"(?:1[28]\\d{3}|2(?:02|1[24]|2[2-4]|33|[45]2|6[23])\\d{2}|365(?:[0-46-9]\\d|5[0-35-9]))\\d{4}",,,,,,,,[7]
]
,[,,"(?:36554|(?:4[04]|5[015]|60|7[07])\\d{3})\\d{4}"]
,[,,"88\\d{7}"]
,[,,"900200\\d{3}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"AZ",994,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["1[28]|2(?:[0-36]|[45]2)|365"]
,"(0$1)"]
,[,"(\\d{2})(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[4-8]"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["9"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BA":[,[,,"[3-9]\\d{7,8}",,,,,,,[8,9]
,[6]
]
,[,,"(?:[35]\\d|49)\\d{6}",,,,,,,[8]
,[6]
]
,[,,"6(?:0(?:3\\d|40)|[1-356]\\d|44[0-6]|71[137])\\d{5}"]
,[,,"8[08]\\d{6}",,,,,,,[8]
]
,[,,"9[0246]\\d{6}",,,,,,,[8]
]
,[,,"8[12]\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BA",387,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{3})(\\d{3})","$1 $2-$3",["[3-5]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["6[1-356]|[7-9]"]
,"0$1"]
,[,"(\\d{2})(\\d{2})(\\d{2})(\\d{3})","$1 $2 $3 $4",["6[047]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"70[23]\\d{5}",,,,,,,[8]
]
,,,[,,,,,,,,,[-1]
]
]
,"BB":[,[,,"[2589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"246(?:2(?:2[78]|7[0-4])|4(?:1[024-6]|2\\d|3[2-9])|5(?:20|[34]\\d|54|7[1-3])|6(?:2\\d|38)|7(?:37|57)|9(?:1[89]|63))\\d{4}",,,,,,,,[7]
]
,[,,"246(?:2(?:[356]\\d|4[0-57-9]|8[0-79])|45\\d|69[5-7]|8(?:[2-5]\\d|83))\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900\\d{7}|246976\\d{4}",,,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,"24631\\d{5}",,,,,,,,[7]
]
,"BB",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"246",[,,,,,,,,,[-1]
]
,[,,"246(?:292|367|4(?:1[7-9]|3[01]|44|67)|736)\\d{4}",,,,,,,,[7]
]
,,,[,,,,,,,,,[-1]
]
]
,"BD":[,[,,"[2-79]\\d{5,9}|1\\d{9}|8[0-7]\\d{4,8}",,,,,,,[6,7,8,9,10]
]
,[,,"2(?:[45]\\d{3}|7(?:1[0-267]|2[0-289]|3[0-29]|4[01]|5[1-3]|6[013]|7[0178]|91)|8(?:0[125]|[139][1-6]|2[0157-9]|41|6[1-35]|7[1-5]|8[1-8]|90)|9(?:0[0-2]|1[0-4]|2[568]|3[3-6]|5[5-7]|6[0167]|7[15]|8[0146-9]))\\d{4}|3(?:12?[5-7]\\d{2}|0(?:2(?:[025-79]\\d|[348]\\d{1,2})|3(?:[2-4]\\d|[56]\\d?))|2(?:1\\d{2}|2(?:[12]\\d|[35]\\d{1,2}|4\\d?))|3(?:1\\d{2}|2(?:[2356]\\d|4\\d{1,2}))|4(?:1\\d{2}|2(?:2\\d{1,2}|[47]|5\\d{2}))|5(?:1\\d{2}|29)|[67]1\\d{2}|8(?:1\\d{2}|2(?:2\\d{2}|3|4\\d)))\\d{3}|4(?:0(?:2(?:[09]\\d|7)|33\\d{2})|1\\d{3}|2(?:1\\d{2}|2(?:[25]\\d?|[348]\\d|[67]\\d{1,2}))|3(?:1\\d{2}(?:\\d{2})?|2(?:[045]\\d|[236-9]\\d{1,2})|32\\d{2})|4(?:[18]\\d{2}|2(?:[2-46]\\d{2}|3)|5[25]\\d{2})|5(?:1\\d{2}|2(?:3\\d|5))|6(?:[18]\\d{2}|2(?:3(?:\\d{2})?|[46]\\d{1,2}|5\\d{2}|7\\d)|5(?:3\\d?|4\\d|[57]\\d{1,2}|6\\d{2}|8))|71\\d{2}|8(?:[18]\\d{2}|23\\d{2}|54\\d{2})|9(?:[18]\\d{2}|2[2-5]\\d{2}|53\\d{1,2}))\\d{3}|5(?:02[03489]\\d{2}|1\\d{2}|2(?:1\\d{2}|2(?:2(?:\\d{2})?|[457]\\d{2}))|3(?:1\\d{2}|2(?:[37](?:\\d{2})?|[569]\\d{2}))|4(?:1\\d{2}|2[46]\\d{2})|5(?:1\\d{2}|26\\d{1,2})|6(?:[18]\\d{2}|2|53\\d{2})|7(?:1|24)\\d{2}|8(?:1|26)\\d{2}|91\\d{2})\\d{3}|6(?:0(?:1\\d{2}|2(?:3\\d{2}|4\\d{1,2}))|2(?:2[2-5]\\d{2}|5(?:[3-5]\\d{2}|7)|8\\d{2})|3(?:1|2[3478])\\d{2}|4(?:1|2[34])\\d{2}|5(?:1|2[47])\\d{2}|6(?:[18]\\d{2}|6(?:2(?:2\\d|[34]\\d{2})|5(?:[24]\\d{2}|3\\d|5\\d{1,2})))|72[2-5]\\d{2}|8(?:1\\d{2}|2[2-5]\\d{2})|9(?:1\\d{2}|2[2-6]\\d{2}))\\d{3}|7(?:(?:02|[3-589]1|6[12]|72[24])\\d{2}|21\\d{3}|32)\\d{3}|8(?:(?:4[12]|[5-7]2|1\\d?)|(?:0|3[12]|[5-7]1|217)\\d)\\d{4}|9(?:[35]1|(?:[024]2|81)\\d|(?:1|[24]1)\\d{2})\\d{3}",,,,,,,[6,7,8,9]
]
,[,,"(?:1[13-9]\\d|(?:3[78]|44)[02-9]|6(?:44|6[02-9]))\\d{7}",,,,,,,[10]
]
,[,,"80[03]\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"96(?:0[49]|1[0-4]|6[69])\\d{6}",,,,,,,[10]
]
,"BD",880,"00","0",,,"0",,,,[[,"(2)(\\d{7,8})","$1-$2",["2"]
,"0$1"]
,[,"(\\d{2})(\\d{4,6})","$1-$2",["[3-79]1"]
,"0$1"]
,[,"(\\d{4})(\\d{3,6})","$1-$2",["1|3(?:0|[2-58]2)|4(?:0|[25]2|3[23]|[4689][25])|5(?:[02-578]2|6[25])|6(?:[0347-9]2|[26][25])|7[02-9]2|8(?:[023][23]|[4-7]2)|9(?:[02][23]|[458]2|6[016])"]
,"0$1"]
,[,"(\\d{3})(\\d{3,7})","$1-$2",["[3-79][2-9]|8"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BE":[,[,,"[1-9]\\d{7,8}",,,,,,,[8,9]
]
,[,,"(?:1[0-69]|[23][2-8]|4[23]|5\\d|6[013-57-9]|71|8[1-79]|9[2-4])\\d{6}|80[2-8]\\d{5}",,,,,,,[8]
]
,[,,"4(?:6[0135-8]|[79]\\d|8[3-9])\\d{6}",,,,,,,[9]
]
,[,,"800\\d{5}",,,,,,,[8]
]
,[,,"(?:70[2-467]|90[0-79])\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BE",32,"00","0",,,"0",,,,[[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["4[6-9]"]
,"0$1"]
,[,"(\\d)(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[23]|4[23]|9[2-4]"]
,"0$1"]
,[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[156]|7[018]|8(?:0[1-9]|[1-79])"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{3})","$1 $2 $3",["(?:80|9)0"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"78\\d{6}",,,,,,,[8]
]
,,,[,,,,,,,,,[-1]
]
]
,"BF":[,[,,"[25-7]\\d{7}",,,,,,,[8]
]
,[,,"2(?:0(?:49|5[23]|6[56]|9[016-9])|4(?:4[569]|5[4-6]|6[56]|7[0179])|5(?:[34]\\d|50|6[5-7]))\\d{4}"]
,[,,"(?:5[15-8]|[67]\\d)\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BF",226,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BG":[,[,,"[23567]\\d{5,7}|[489]\\d{6,8}",,,,,,,[6,7,8,9]
,[4,5]
]
,[,,"2\\d{5,7}|(?:[36]\\d|5[1-9]|8[1-6]|9[1-7])\\d{5,6}|(?:4(?:[124-7]\\d|3[1-6])|7(?:0[1-9]|[1-9]\\d))\\d{4,5}",,,,,,,[6,7,8]
,[4,5]
]
,[,,"(?:8[7-9]\\d|9(?:8\\d|9[69]))\\d{6}|4(?:3[0789]|8\\d)\\d{5}",,,,,,,[8,9]
]
,[,,"800\\d{5}",,,,,,,[8]
]
,[,,"90\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,"700\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,"BG",359,"00","0",,,"0",,,,[[,"(2)(\\d)(\\d{2})(\\d{2})","$1 $2 $3 $4",["2"]
,"0$1"]
,[,"(2)(\\d{3})(\\d{3,4})","$1 $2 $3",["2"]
,"0$1"]
,[,"(\\d{3})(\\d{4})","$1 $2",["43[124-7]|70[1-9]"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{2})","$1 $2 $3",["43[124-7]|70[1-9]"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{3})","$1 $2 $3",["[78]00"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["99[69]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{2,3})","$1 $2 $3",["[356]|4[124-7]|7[1-9]|8[1-6]|9[1-7]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{3,4})","$1 $2 $3",["48|8[7-9]|9[08]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BH":[,[,,"[136-9]\\d{7}",,,,,,,[8]
]
,[,,"(?:1(?:3[1356]|6[0156]|7\\d)\\d|6(?:1[16]\\d|500|6(?:0\\d|3[12]|44|7[7-9])|9[69][69])|7(?:1(?:11|78)|7\\d{2}))\\d{4}"]
,[,,"(?:3(?:[1-4679]\\d|5[013-69]|8[0-47-9])\\d|6(?:3(?:00|33|6[16])|6(?:[69]\\d|3[03-9]|7[0-6])))\\d{4}"]
,[,,"80\\d{6}"]
,[,,"(?:87|9[014578])\\d{6}"]
,[,,"84\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BH",973,"00",,,,,,,,[[,"(\\d{4})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BI":[,[,,"[267]\\d{7}",,,,,,,[8]
]
,[,,"22\\d{6}"]
,[,,"(?:29|6[189]|7[124-9])\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BI",257,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BJ":[,[,,"[2689]\\d{7}",,,,,,,[8]
]
,[,,"2(?:02|1[037]|2[45]|3[68])\\d{5}"]
,[,,"(?:6[1-8]|9[03-9])\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"857[58]\\d{4}"]
,"BJ",229,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[2689]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"81\\d{6}"]
,,,[,,,,,,,,,[-1]
]
]
,"BL":[,[,,"[56]\\d{8}",,,,,,,[9]
]
,[,,"590(?:2[7-9]|5[12]|87)\\d{4}"]
,[,,"690(?:0[05-9]|[1-9]\\d)\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BL",590,"00","0",,,"0",,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BM":[,[,,"[4589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"441(?:2(?:02|23|61|[3479]\\d)|[46]\\d{2}|5(?:4\\d|60|89)|824)\\d{4}",,,,,,,,[7]
]
,[,,"441(?:[37]\\d|5[0-39])\\d{5}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"BM",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"441",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BN":[,[,,"[2-578]\\d{6}",,,,,,,[7]
]
,[,,"2(?:[013-9]\\d|2[0-7])\\d{4}|[3-5]\\d{6}"]
,[,,"22[89]\\d{4}|[78]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BN",673,"00",,,,,,,,[[,"([2-578]\\d{2})(\\d{4})","$1 $2",["[2-578]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BO":[,[,,"[23467]\\d{7}|8\\d{8}",,,,,,,[8,9]
,[7]
]
,[,,"(?:2(?:2\\d{2}|5(?:11|[258]\\d|9[67])|6(?:12|2\\d|9[34])|8(?:2[34]|39|62))|3(?:3\\d{2}|4(?:6\\d|8[24])|8(?:25|42|5[257]|86|9[25])|9(?:2\\d|3[234]|4[248]|5[24]|6[2-6]|7\\d))|4(?:4\\d{2}|6(?:11|[24689]\\d|72)))\\d{4}",,,,,,,[8]
,[7]
]
,[,,"[67]\\d{7}",,,,,,,[8]
]
,[,,"80017\\d{4}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BO",591,"00(1\\d)?","0",,,"0(1\\d)?",,,,[[,"([234])(\\d{7})","$1 $2",["[2-4]"]
,,"0$CC $1"]
,[,"([67]\\d{7})","$1",["[67]"]
,,"0$CC $1"]
,[,"(800)(\\d{2})(\\d{4})","$1 $2 $3",["800"]
,,"0$CC $1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BQ":[,[,,"[347]\\d{6}",,,,,,,[7]
]
,[,,"(?:318[023]|41(?:6[023]|70)|7(?:1[578]|50)\\d)\\d{3}"]
,[,,"(?:31(?:8[14-8]|9[14578])|416[145-9]|7(?:0[01]|7[07]|8\\d|9[056])\\d)\\d{3}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BQ",599,"00",,,,,,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BR":[,[,,"[1-46-9]\\d{7,10}|5(?:[0-4]\\d{7,9}|5(?:[2-8]\\d{7}|9\\d{7,8}))",,,,,,,[8,9,10,11]
]
,[,,"(?:[14689][1-9]|2[12478]|3[1-578]|5[13-5]|7[13-579])[2-5]\\d{7}",,,,,,,[10]
,[8]
]
,[,,"(?:[189][1-9]|2[12478])(?:7|9\\d)\\d{7}|(?:3[1-578]|[46][1-9]|5[13-5]|7[13-579])(?:[6-8]|9\\d?)\\d{7}",,,,,,,[10,11]
,[8]
]
,[,,"800\\d{6,7}",,,,,,,[9,10]
]
,[,,"(?:300|[59]00\\d?)\\d{6}",,,,,,,[9,10]
]
,[,,"(?:300\\d(?:\\d{2})?|40(?:0\\d|20))\\d{4}",,,,,,,[8,10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BR",55,"00(?:1[245]|2[1-35]|31|4[13]|[56]5|99)","0",,,"0(?:(1[245]|2[1-35]|31|4[13]|[56]5|99)(\\d{10,11}))?","$2",,,[[,"(\\d{4})(\\d{4})","$1-$2",["300|40[02]","300|40(?:0|20)"]
]
,[,"([3589]00)(\\d{2,3})(\\d{4})","$1 $2 $3",["[3589]00"]
,"0$1"]
,[,"(\\d{3,5})","$1",["1[125689]"]
]
,[,"(\\d{4})(\\d{4})","$1-$2",["[2-9](?:0[1-9]|[1-9])"]
]
,[,"(\\d{5})(\\d{4})","$1-$2",["9(?:0[1-9]|[1-9])"]
]
,[,"(\\d{2})(\\d{4})(\\d{4})","$1 $2-$3",["[1-9][1-9]"]
,"($1)","0 $CC ($1)"]
,[,"(\\d{2})(\\d{5})(\\d{4})","$1 $2-$3",["[1-9][1-9]9"]
,"($1)","0 $CC ($1)"]
]
,[[,"(\\d{4})(\\d{4})","$1-$2",["300|40[02]","300|40(?:0|20)"]
]
,[,"([3589]00)(\\d{2,3})(\\d{4})","$1 $2 $3",["[3589]00"]
,"0$1"]
,[,"(\\d{2})(\\d{4})(\\d{4})","$1 $2-$3",["[1-9][1-9]"]
,"($1)","0 $CC ($1)"]
,[,"(\\d{2})(\\d{5})(\\d{4})","$1 $2-$3",["[1-9][1-9]9"]
,"($1)","0 $CC ($1)"]
]
,[,,,,,,,,,[-1]
]
,,,[,,"(?:300\\d|40(?:0\\d|20))\\d{4}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BS":[,[,,"[2589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"242(?:3(?:02|[236][1-9]|4[0-24-9]|5[0-68]|7[347]|8[0-4]|9[2-467])|461|502|6(?:0[1-4]|12|2[013]|[45]0|7[67]|8[78]|9[89])|7(?:02|88))\\d{4}",,,,,,,,[7]
]
,[,,"242(?:3(?:5[79]|7[56]|95)|4(?:[23][1-9]|4[1-35-9]|5[1-8]|6[2-8]|7\\d|81)|5(?:2[45]|3[35]|44|5[1-46-9]|65|77)|6[34]6|7(?:27|38)|8(?:0[1-9]|1[02-9]|2\\d|[89]9))\\d{4}",,,,,,,,[7]
]
,[,,"242300\\d{4}|8(?:00|33|44|55|66|77|88)[2-9]\\d{6}",,,,,,,,[7]
]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"BS",1,"011?","1",,,"1",,"011",,,,[,,,,,,,,,[-1]
]
,,"242",[,,,,,,,,,[-1]
]
,[,,"242225[0-46-9]\\d{3}"]
,,,[,,,,,,,,,[-1]
]
]
,"BT":[,[,,"[1-8]\\d{6,7}",,,,,,,[7,8]
,[6]
]
,[,,"(?:2[3-6]|[34][5-7]|5[236]|6[2-46]|7[246]|8[2-4])\\d{5}",,,,,,,[7]
,[6]
]
,[,,"(?:1[67]|77)\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BT",975,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["1|77"]
]
,[,"([2-8])(\\d{3})(\\d{3})","$1 $2 $3",["[2-68]|7[246]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BW":[,[,,"[2-79]\\d{6,7}",,,,,,,[7,8]
]
,[,,"(?:2(?:4[0-48]|6[0-24]|9[0578])|3(?:1[0-35-9]|55|[69]\\d|7[01])|4(?:6[03]|7[1267]|9[0-5])|5(?:3[0389]|4[0489]|7[1-47]|88|9[0-49])|6(?:2[1-35]|5[149]|8[067]))\\d{4}",,,,,,,[7]
]
,[,,"7(?:[1-6]\\d|7[014-8])\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,"90\\d{5}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"79[12][01]\\d{4}",,,,,,,[8]
]
,"BW",267,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2",["[2-6]"]
]
,[,"(7\\d)(\\d{3})(\\d{3})","$1 $2 $3",["7"]
]
,[,"(90)(\\d{5})","$1 $2",["90"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BY":[,[,,"[1-4]\\d{8}|8(?:0(?:0\\d{3,7}|[13]\\d{7})|(?:10|20\\d)\\d{7})|9\\d{9,10}",,,,,,,[6,7,8,9,10,11]
,[5]
]
,[,,"(?:1(?:5(?:1[1-5]|[24]\\d|6[2-4]|9[1-7])|6(?:[235]\\d|4[1-7])|7\\d{2})|2(?:1(?:[246]\\d|3[0-35-9]|5[1-9])|2(?:[235]\\d|4[0-8])|3(?:[26]\\d|3[02-79]|4[024-7]|5[03-7])))\\d{5}",,,,,,,[9]
,[5,6,7]
]
,[,,"(?:2(?:5[5679]|9[1-9])|33\\d|44\\d)\\d{6}",,,,,,,[9]
]
,[,,"8(?:0[13]|20\\d)\\d{7}|800\\d{3,7}"]
,[,,"(?:810|902)\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"249\\d{6}",,,,,,,[9]
]
,"BY",375,"810","8",,,"8?0?",,"8~10",,[[,"(\\d{2})(\\d{3})(\\d{2})(\\d{2})","$1 $2-$3-$4",["17[0-3589]|2[4-9]|[34]","17(?:[02358]|1[0-2]|9[0189])|2[4-9]|[34]"]
,"8 0$1"]
,[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2-$3-$4",["1(?:5[24]|6[235]|7[467])|2(?:1[246]|2[25]|3[26])","1(?:5[24]|6(?:2|3[04-9]|5[0346-9])|7(?:[46]|7[37-9]))|2(?:1[246]|2[25]|3[26])"]
,"8 0$1"]
,[,"(\\d{4})(\\d{2})(\\d{3})","$1 $2-$3",["1(?:5[169]|6[3-5]|7[179])|2(?:1[35]|2[34]|3[3-5])","1(?:5[169]|6(?:3[1-3]|4|5[125])|7(?:1[3-9]|7[0-24-6]|9[2-7]))|2(?:1[35]|2[34]|3[3-5])"]
,"8 0$1"]
,[,"([89]\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["8[01]|9"]
,"8 $1"]
,[,"(82\\d)(\\d{4})(\\d{4})","$1 $2 $3",["82"]
,"8 $1"]
,[,"(800)(\\d{3})","$1 $2",["800"]
,"8 $1"]
,[,"(800)(\\d{2})(\\d{2,4})","$1 $2 $3",["800"]
,"8 $1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"8(?:0[13]|10|20\\d)\\d{7}|800\\d{3,7}|902\\d{7}"]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"BZ":[,[,,"[2-8]\\d{6}|0\\d{10}",,,,,,,[7,11]
]
,[,,"(?:2(?:[02]\\d|36)|[3-58][02]\\d|7(?:[02]\\d|32))\\d{4}",,,,,,,[7]
]
,[,,"6[0-35-7]\\d{5}",,,,,,,[7]
]
,[,,"0800\\d{7}",,,,,,,[11]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"BZ",501,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1-$2",["[2-8]"]
]
,[,"(0)(800)(\\d{4})(\\d{3})","$1-$2-$3-$4",["080","0800"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CA":[,[,,"[2-9]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"(?:2(?:04|[23]6|[48]9|50)|3(?:06|43|65)|4(?:03|1[68]|3[178]|50)|5(?:06|1[49]|48|79|8[17])|6(?:0[04]|13|22|39|47)|7(?:0[59]|78|8[02])|8(?:[06]7|19|25|73)|90[25])[2-9]\\d{6}",,,,,,,,[7]
]
,[,,"(?:2(?:04|[23]6|[48]9|50)|3(?:06|43|65)|4(?:03|1[68]|3[178]|50)|5(?:06|1[49]|48|79|8[17])|6(?:0[04]|13|22|39|47)|7(?:0[59]|78|8[02])|8(?:[06]7|19|25|73)|90[25])[2-9]\\d{6}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"CA",1,"011","1",,,"1",,,1,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CC":[,[,,"[1458]\\d{5,9}",,,,,,,[6,7,8,9,10]
]
,[,,"89162\\d{4}",,,,,,,[9]
,[8]
]
,[,,"14(?:5\\d|71)\\d{5}|4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[6-9]|7[02-9]|8[12547-9]|9[017-9])\\d{6}",,,,,,,[9]
]
,[,,"180(?:0\\d{3}|2)\\d{3}",,,,,,,[7,10]
]
,[,,"19(?:0[0126]\\d|[679])\\d{5}",,,,,,,[8,10]
]
,[,,"13(?:00\\d{2})?\\d{4}",,,,,,,[6,10]
]
,[,,"500\\d{6}",,,,,,,[9]
]
,[,,"550\\d{6}",,,,,,,[9]
]
,"CC",61,"(?:14(?:1[14]|34|4[17]|[56]6|7[47]|88))?001[14-689]","0",,,"0",,"0011",,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CD":[,[,,"[2-6]\\d{6}|[18]\\d{6,8}|9\\d{8}",,,,,,,[7,9]
]
,[,,"1(?:2\\d{7}|\\d{6})|[2-6]\\d{6}"]
,[,,"8(?:[0-2459]\\d{2}|8)\\d{5}|9[017-9]\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CD",243,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["12"]
,"0$1"]
,[,"([89]\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["8[0-2459]|9"]
,"0$1"]
,[,"(\\d{2})(\\d{2})(\\d{3})","$1 $2 $3",["88"]
,"0$1"]
,[,"(\\d{2})(\\d{5})","$1 $2",["[1-6]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CF":[,[,,"[278]\\d{7}",,,,,,,[8]
]
,[,,"2[12]\\d{6}"]
,[,,"7[0257]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"8776\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CF",236,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CG":[,[,,"[028]\\d{8}",,,,,,,[9]
]
,[,,"222[1-589]\\d{5}"]
,[,,"0[14-6]\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,"80(?:0\\d{2}|11[01])\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CG",242,"00",,,,,,,,[[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["801"]
]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["[02]"]
]
,[,"(\\d)(\\d{4})(\\d{4})","$1 $2 $3",["800"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CH":[,[,,"[2-9]\\d{8}|860\\d{9}",,,,,,,[9,12]
]
,[,,"(?:2[12467]|3[1-4]|4[134]|5[256]|6[12]|[7-9]1)\\d{7}",,,,,,,[9]
]
,[,,"7[5-9]\\d{7}",,,,,,,[9]
]
,[,,"800\\d{6}",,,,,,,[9]
]
,[,,"90[016]\\d{6}",,,,,,,[9]
]
,[,,"84[0248]\\d{6}",,,,,,,[9]
]
,[,,"878\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,"CH",41,"00","0",,,"0",,,,[[,"([2-9]\\d)(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[2-7]|[89]1"]
,"0$1"]
,[,"([89]\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["8[047]|90"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4 $5",["860"]
,"0$1"]
]
,,[,,"74[0248]\\d{6}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
,[,,"5[18]\\d{7}",,,,,,,[9]
]
,,,[,,"860\\d{9}",,,,,,,[12]
]
]
,"CI":[,[,,"[02-8]\\d{7}",,,,,,,[8]
]
,[,,"(?:2(?:0[023]|1[02357]|[23][045]|4[03-5])|3(?:0[06]|1[069]|[2-4][07]|5[09]|6[08]))\\d{5}"]
,[,,"(?:0[1-9]|4\\d|5[14-9]|6[015-79]|[78][4-9])\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CI",225,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CK":[,[,,"[2-8]\\d{4}",,,,,,,[5]
]
,[,,"(?:2\\d|3[13-7]|4[1-5])\\d{3}"]
,[,,"[5-8]\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CK",682,"00",,,,,,,,[[,"(\\d{2})(\\d{3})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CL":[,[,,"1230\\d{7}|[2-46-9]\\d{8,10}|5[1-3578]\\d{7}",,,,,,,[9,10,11]
,[7,8]
]
,[,,"2(?:1962\\d{4}|2\\d{7}|32[0-467]\\d{5})|(?:3[2-5]|[47][1-35]|5[1-3578]|6[13-57]|9[3-9])\\d{7}",,,,,,,[9]
,[7,8]
]
,[,,"2(?:1962\\d{4}|2\\d{7}|32[0-467]\\d{5})|(?:3[2-5]|[47][1-35]|5[1-3578]|6[13-57]|9[3-9])\\d{7}",,,,,,,[9]
,[8]
]
,[,,"800\\d{6}|1230\\d{7}",,,,,,,[9,11]
]
,[,,,,,,,,,[-1]
]
,[,,"600\\d{7,8}",,,,,,,[10,11]
]
,[,,,,,,,,,[-1]
]
,[,,"44\\d{7}",,,,,,,[9]
]
,"CL",56,"(?:0|1(?:1[0-69]|2[0-57]|5[13-58]|69|7[0167]|8[018]))0","0",,,"0|(1(?:1[0-69]|2[0-57]|5[13-58]|69|7[0167]|8[018]))",,,1,[[,"(\\d)(\\d{4})(\\d{4})","$1 $2 $3",["2[23]"]
,"($1)","$CC ($1)"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["[357]|4[1-35]|6[13-57]"]
,"($1)","$CC ($1)"]
,[,"(9)(\\d{4})(\\d{4})","$1 $2 $3",["9"]
,"0$1"]
,[,"(44)(\\d{3})(\\d{4})","$1 $2 $3",["44"]
,"0$1"]
,[,"([68]00)(\\d{3})(\\d{3,4})","$1 $2 $3",["[68]00"]
,"$1"]
,[,"(600)(\\d{3})(\\d{2})(\\d{3})","$1 $2 $3 $4",["600"]
,"$1"]
,[,"(1230)(\\d{3})(\\d{4})","$1 $2 $3",["123","1230"]
,"$1"]
,[,"(\\d{5})(\\d{4})","$1 $2",["219"]
,"($1)","$CC ($1)"]
,[,"(\\d{4,5})","$1",["[1-9]"]
,"$1"]
]
,[[,"(\\d)(\\d{4})(\\d{4})","$1 $2 $3",["2[23]"]
,"($1)","$CC ($1)"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["[357]|4[1-35]|6[13-57]"]
,"($1)","$CC ($1)"]
,[,"(9)(\\d{4})(\\d{4})","$1 $2 $3",["9"]
,"0$1"]
,[,"(44)(\\d{3})(\\d{4})","$1 $2 $3",["44"]
,"0$1"]
,[,"([68]00)(\\d{3})(\\d{3,4})","$1 $2 $3",["[68]00"]
,"$1"]
,[,"(600)(\\d{3})(\\d{2})(\\d{3})","$1 $2 $3 $4",["600"]
,"$1"]
,[,"(1230)(\\d{3})(\\d{4})","$1 $2 $3",["123","1230"]
,"$1"]
,[,"(\\d{5})(\\d{4})","$1 $2",["219"]
,"($1)","$CC ($1)"]
]
,[,,,,,,,,,[-1]
]
,,,[,,"600\\d{7,8}",,,,,,,[10,11]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CM":[,[,,"[2368]\\d{7,8}",,,,,,,[8,9]
]
,[,,"2(?:22|33|4[23])\\d{6}",,,,,,,[9]
]
,[,,"6[5-9]\\d{7}",,,,,,,[9]
]
,[,,"88\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CM",237,"00",,,,,,,,[[,"([26])(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4 $5",["[26]"]
]
,[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[23]|88"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CN":[,[,,"[1-7]\\d{6,11}|8[0-357-9]\\d{6,9}|9\\d{7,10}",,,,,,,[7,8,9,10,11,12]
,[5,6]
]
,[,,"21(?:100\\d{2}|95\\d{3,4}|\\d{8,10})|(?:10|2[02-57-9]|3(?:11|7[179])|4(?:[15]1|3[1-35])|5(?:1\\d|2[37]|3[12]|51|7[13-79]|9[15])|7(?:31|5[457]|6[09]|91)|8(?:[57]1|98))(?:100\\d{2}|95\\d{3,4}|\\d{8})|(?:3(?:1[02-9]|35|49|5\\d|7[02-68]|9[1-68])|4(?:1[02-9]|2[179]|3[3-9]|5[2-9]|6[4789]|7\\d|8[23])|5(?:3[03-9]|4[36]|5[02-9]|6[1-46]|7[028]|80|9[2-46-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[17]\\d|2[248]|3[04-9]|4[3-6]|5[0-4689]|6[2368]|9[02-9])|8(?:078|1[236-8]|2[5-7]|3\\d|5[1-9]|7[02-9]|8[3678]|9[1-7])|9(?:0[1-3689]|1[1-79]|[379]\\d|4[13]|5[1-5]))(?:100\\d{2}|95\\d{3,4}|\\d{7})|80(?:29|6[03578]|7[018]|81)\\d{4}",,,,,,,,[5,6]
]
,[,,"1(?:[38]\\d{3}|4[57]\\d{2}|5[0-35-9]\\d{2}|66\\d{2}|7(?:[0-35-8]\\d{2}|40[0-5])|99\\d{2})\\d{6}",,,,,,,[11]
]
,[,,"(?:10)?800\\d{7}",,,,,,,[10,12]
]
,[,,"16[08]\\d{5}",,,,,,,[8]
]
,[,,"400\\d{7}|950\\d{7,8}|(?:10|2[0-57-9]|3(?:[157]\\d|35|49|9[1-68])|4(?:[17]\\d|2[179]|[35][1-9]|6[4789]|8[23])|5(?:[1357]\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\d|5[14-9]|8[3678]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]\\d|4[13]|5[1-5]))96\\d{3,4}",,,,,,,[7,8,9,10,11]
,[5,6]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CN",86,"(1(?:[129]\\d{3}|79\\d{2}))?00","0",,,"(1(?:[129]\\d{3}|79\\d{2}))|0",,"00",,[[,"(80\\d{2})(\\d{4})","$1 $2",["80[26-8]"]
,"0$1","$CC $1",1]
,[,"([48]00)(\\d{3})(\\d{4})","$1 $2 $3",["[48]00"]
]
,[,"(\\d{5,6})","$1",["100|95"]
]
,[,"(\\d{2})(\\d{5,6})","$1 $2",["(?:10|2\\d)[19]","(?:10|2\\d)(?:10|9[56])","(?:10|2\\d)(?:100|9[56])"]
,"0$1","$CC $1"]
,[,"(\\d{3})(\\d{5,6})","$1 $2",["[3-9]","[3-9]\\d\\d[19]","[3-9]\\d\\d(?:10|9[56])"]
,"0$1","$CC $1"]
,[,"(\\d{3,4})(\\d{4})","$1 $2",["[2-9]"]
]
,[,"(21)(\\d{4})(\\d{4,6})","$1 $2 $3",["21"]
,"0$1","$CC $1",1]
,[,"([12]\\d)(\\d{4})(\\d{4})","$1 $2 $3",["10[1-9]|2[02-9]","10[1-9]|2[02-9]","10(?:[1-79]|8(?:0[1-9]|[1-9]))|2[02-9]"]
,"0$1","$CC $1",1]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["3(?:1[02-9]|35|49|5|7[02-68]|9[1-68])|4(?:1[02-9]|2[179]|[35][2-9]|6[47-9]|7|8[23])|5(?:3[03-9]|4[36]|5[02-9]|6[1-46]|7[028]|80|9[2-46-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]|2[248]|3[04-9]|4[3-6]|6[2368])|8(?:1[236-8]|2[5-7]|3|5[1-9]|7[02-9]|8[36-8]|9[1-7])|9(?:0[1-3689]|1[1-79]|[379]|4[13]|5[1-5])"]
,"0$1","$CC $1",1]
,[,"(\\d{3})(\\d{4})(\\d{4})","$1 $2 $3",["3(?:11|7[179])|4(?:[15]1|3[1-35])|5(?:1|2[37]|3[12]|51|7[13-79]|9[15])|7(?:[39]1|5[457]|6[09])|8(?:[57]1|98)"]
,"0$1","$CC $1",1]
,[,"(\\d{4})(\\d{3})(\\d{4})","$1 $2 $3",["807","8078"]
,"0$1","$CC $1",1]
,[,"(\\d{3})(\\d{4})(\\d{4})","$1 $2 $3",["1(?:[3-57-9]|66)"]
,,"$CC $1"]
,[,"(10800)(\\d{3})(\\d{4})","$1 $2 $3",["108","1080","10800"]
]
,[,"(\\d{3})(\\d{7,8})","$1 $2",["950"]
]
]
,[[,"(80\\d{2})(\\d{4})","$1 $2",["80[26-8]"]
,"0$1","$CC $1",1]
,[,"([48]00)(\\d{3})(\\d{4})","$1 $2 $3",["[48]00"]
]
,[,"(\\d{2})(\\d{5,6})","$1 $2",["(?:10|2\\d)[19]","(?:10|2\\d)(?:10|9[56])","(?:10|2\\d)(?:100|9[56])"]
,"0$1","$CC $1"]
,[,"(\\d{3})(\\d{5,6})","$1 $2",["[3-9]","[3-9]\\d\\d[19]","[3-9]\\d\\d(?:10|9[56])"]
,"0$1","$CC $1"]
,[,"(21)(\\d{4})(\\d{4,6})","$1 $2 $3",["21"]
,"0$1","$CC $1",1]
,[,"([12]\\d)(\\d{4})(\\d{4})","$1 $2 $3",["10[1-9]|2[02-9]","10[1-9]|2[02-9]","10(?:[1-79]|8(?:0[1-9]|[1-9]))|2[02-9]"]
,"0$1","$CC $1",1]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["3(?:1[02-9]|35|49|5|7[02-68]|9[1-68])|4(?:1[02-9]|2[179]|[35][2-9]|6[47-9]|7|8[23])|5(?:3[03-9]|4[36]|5[02-9]|6[1-46]|7[028]|80|9[2-46-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]|2[248]|3[04-9]|4[3-6]|6[2368])|8(?:1[236-8]|2[5-7]|3|5[1-9]|7[02-9]|8[36-8]|9[1-7])|9(?:0[1-3689]|1[1-79]|[379]|4[13]|5[1-5])"]
,"0$1","$CC $1",1]
,[,"(\\d{3})(\\d{4})(\\d{4})","$1 $2 $3",["3(?:11|7[179])|4(?:[15]1|3[1-35])|5(?:1|2[37]|3[12]|51|7[13-79]|9[15])|7(?:[39]1|5[457]|6[09])|8(?:[57]1|98)"]
,"0$1","$CC $1",1]
,[,"(\\d{4})(\\d{3})(\\d{4})","$1 $2 $3",["807","8078"]
,"0$1","$CC $1",1]
,[,"(\\d{3})(\\d{4})(\\d{4})","$1 $2 $3",["1(?:[3-57-9]|66)"]
,,"$CC $1"]
,[,"(10800)(\\d{3})(\\d{4})","$1 $2 $3",["108","1080","10800"]
]
,[,"(\\d{3})(\\d{7,8})","$1 $2",["950"]
]
]
,[,,,,,,,,,[-1]
]
,,,[,,"(?:4|(?:10)?8)00\\d{7}|950\\d{7,8}",,,,,,,[10,11,12]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CO":[,[,,"(?:[13]\\d{0,3}|[24-8])\\d{7}",,,,,,,[8,10,11]
,[7]
]
,[,,"[124-8][2-9]\\d{6}",,,,,,,[8]
,[7]
]
,[,,"3(?:0[0-5]|1\\d|2[0-3]|5[01])\\d{7}",,,,,,,[10]
]
,[,,"1800\\d{7}",,,,,,,[11]
]
,[,,"19(?:0[01]|4[78])\\d{7}",,,,,,,[11]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CO",57,"00(?:4(?:[14]4|56)|[579])","0",,,"0([3579]|4(?:44|56))?",,,,[[,"(\\d)(\\d{7})","$1 $2",["1(?:[2-7]|8[2-9]|9[0-3])|[24-8]","1(?:[2-7]|8[2-9]|9(?:09|[1-3]))|[24-8]"]
,"($1)","0$CC $1"]
,[,"(\\d{3})(\\d{7})","$1 $2",["3"]
,,"0$CC $1"]
,[,"(1)(\\d{3})(\\d{7})","$1-$2-$3",["1(?:80|9[04])","1(?:800|9(?:0[01]|4[78]))"]
,"0$1"]
]
,[[,"(\\d)(\\d{7})","$1 $2",["1(?:[2-7]|8[2-9]|9[0-3])|[24-8]","1(?:[2-7]|8[2-9]|9(?:09|[1-3]))|[24-8]"]
,"($1)","0$CC $1"]
,[,"(\\d{3})(\\d{7})","$1 $2",["3"]
,,"0$CC $1"]
,[,"(1)(\\d{3})(\\d{7})","$1 $2 $3",["1(?:80|9[04])","1(?:800|9(?:0[01]|4[78]))"]
]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CR":[,[,,"[24-9]\\d{7,9}",,,,,,,[8,10]
]
,[,,"2(?:[024-7]\\d{2}|1(?:0[7-9]|[1-9]\\d))\\d{4}",,,,,,,[8]
]
,[,,"5(?:0[01]|7[0-3])\\d{5}|6(?:[0-4]\\d{3}|500[01])\\d{3}|(?:7[0-3]|8[3-9])\\d{6}",,,,,,,[8]
]
,[,,"800\\d{7}",,,,,,,[10]
]
,[,,"90[059]\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"210[0-6]\\d{4}|4\\d{7}|5100\\d{4}",,,,,,,[8]
]
,"CR",506,"00",,,,"(19(?:0[012468]|1[09]|20|66|77|99))",,,,[[,"(\\d{4})(\\d{4})","$1 $2",["[24-7]|8[3-9]"]
,,"$CC $1"]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1-$2-$3",["[89]0"]
,,"$CC $1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CU":[,[,,"[2-57]\\d{5,7}",,,,,,,[6,7,8]
,[4,5]
]
,[,,"2[1-4]\\d{5,6}|3(?:1\\d{6}|[23]\\d{4,6})|4(?:[125]\\d{5,6}|[36]\\d{6}|[78]\\d{4,6})|7\\d{6,7}",,,,,,,,[4,5]
]
,[,,"5\\d{7}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CU",53,"119","0",,,"0",,,,[[,"(\\d)(\\d{6,7})","$1 $2",["7"]
,"(0$1)"]
,[,"(\\d{2})(\\d{4,6})","$1 $2",["[2-4]"]
,"(0$1)"]
,[,"(\\d)(\\d{7})","$1 $2",["5"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CV":[,[,,"[259]\\d{6}",,,,,,,[7]
]
,[,,"2(?:2[1-7]|3[0-8]|4[12]|5[1256]|6\\d|7[1-3]|8[1-5])\\d{4}"]
,[,,"(?:9\\d|59)\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CV",238,"0",,,,,,,,[[,"(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CW":[,[,,"[134679]\\d{6,7}",,,,,,,[7,8]
]
,[,,"9(?:[48]\\d{2}|50\\d|7(?:2[0-24]|[34]\\d|6[35-7]|77|8[7-9]))\\d{4}",,,,,,,[8]
]
,[,,"9(?:5(?:[12467]\\d|3[01])|6(?:[15-9]\\d|3[01]))\\d{4}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"60[0-2]\\d{4}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"CW",599,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2",["[13-7]"]
]
,[,"(9)(\\d{3})(\\d{4})","$1 $2 $3",["9"]
]
]
,,[,,"955\\d{5}",,,,,,,[8]
]
,1,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CX":[,[,,"[1458]\\d{5,9}",,,,,,,[6,7,8,9,10]
]
,[,,"89164\\d{4}",,,,,,,[9]
,[8]
]
,[,,"14(?:5\\d|71)\\d{5}|4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[6-9]|7[02-9]|8[12547-9]|9[017-9])\\d{6}",,,,,,,[9]
]
,[,,"180(?:0\\d{3}|2)\\d{3}",,,,,,,[7,10]
]
,[,,"19(?:0[0126]\\d|[679])\\d{5}",,,,,,,[8,10]
]
,[,,"13(?:00\\d{2})?\\d{4}",,,,,,,[6,8,10]
]
,[,,"500\\d{6}",,,,,,,[9]
]
,[,,"550\\d{6}",,,,,,,[9]
]
,"CX",61,"(?:14(?:1[14]|34|4[17]|[56]6|7[47]|88))?001[14-689]","0",,,"0",,"0011",,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"CY":[,[,,"[257-9]\\d{7}",,,,,,,[8]
]
,[,,"2[2-6]\\d{6}"]
,[,,"9[4-79]\\d{6}"]
,[,,"800\\d{5}"]
,[,,"90[09]\\d{5}"]
,[,,"80[1-9]\\d{5}"]
,[,,"700\\d{5}"]
,[,,,,,,,,,[-1]
]
,"CY",357,"00",,,,,,,,[[,"(\\d{2})(\\d{6})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"(?:50|77)\\d{6}"]
,,,[,,,,,,,,,[-1]
]
]
,"CZ":[,[,,"[2-8]\\d{8}|9\\d{8,11}",,,,,,,[9,10,11,12]
]
,[,,"2\\d{8}|(?:3[1257-9]|4[16-9]|5[13-9])\\d{7}",,,,,,,[9]
]
,[,,"(?:60[1-8]|7(?:0[2-5]|[2379]\\d))\\d{6}",,,,,,,[9]
]
,[,,"800\\d{6}",,,,,,,[9]
]
,[,,"9(?:0[05689]|76)\\d{6}",,,,,,,[9]
]
,[,,"8[134]\\d{7}",,,,,,,[9]
]
,[,,"70[01]\\d{6}",,,,,,,[9]
]
,[,,"9[17]0\\d{6}",,,,,,,[9]
]
,"CZ",420,"00",,,,,,,,[[,"([2-9]\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["[2-8]|9[015-7]"]
]
,[,"(96\\d)(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3 $4",["96"]
]
,[,"(9\\d)(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3 $4",["9[36]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"9(?:5\\d|7[234])\\d{6}",,,,,,,[9]
]
,,,[,,"9(?:3\\d{9}|6\\d{7,10})"]
]
,"DE":[,[,,"[1-35-9]\\d{3,14}|4(?:[0-8]\\d{3,12}|9(?:[0-37]\\d|4(?:[1-35-8]|4\\d?)|5\\d{1,2}|6[1-8]\\d?)\\d{2,8})",,,,,,,[4,5,6,7,8,9,10,11,12,13,14,15]
,[3]
]
,[,,"2\\d{5,13}|3(?:0\\d{3,13}|2\\d{9}|[3-9]\\d{4,13})|4(?:0\\d{3,12}|[1-8]\\d{4,12}|9(?:[0-37]\\d|4(?:[1-35-8]|4\\d?)|5\\d{1,2}|6[1-8]\\d?)\\d{2,8})|5(?:0[2-8]|[1256]\\d|[38][0-8]|4\\d{0,2}|[79][0-7])\\d{3,11}|6(?:\\d{5,13}|9\\d{3,12})|7(?:0[2-8]|[1-9]\\d)\\d{3,10}|8(?:0[2-9]|[1-8]\\d|9\\d?)\\d{3,10}|9(?:0[6-9]\\d{3,10}|1\\d{4,12}|[2-9]\\d{4,11})",,,,,,,[5,6,7,8,9,10,11,12,13,14,15]
,[3,4]
]
,[,,"1(?:5[0-25-9]\\d{8}|6[023]\\d{7,8}|7\\d{8,9})",,,,,,,[10,11]
]
,[,,"800\\d{7,12}",,,,,,,[10,11,12,13,14,15]
]
,[,,"137[7-9]\\d{6}|900(?:[135]\\d{6}|9\\d{7})",,,,,,,[10,11]
]
,[,,"1(?:3(?:7[1-6]\\d{6}|8\\d{4})|80\\d{5,11})",,,,,,,[7,8,9,10,11,12,13,14]
]
,[,,"700\\d{8}",,,,,,,[11]
]
,[,,,,,,,,,[-1]
]
,"DE",49,"00","0",,,"0",,,,[[,"(1\\d{2})(\\d{7,8})","$1 $2",["1[67]"]
,"0$1"]
,[,"(15\\d{3})(\\d{6})","$1 $2",["15[0568]"]
,"0$1"]
,[,"(1\\d{3})(\\d{7})","$1 $2",["15"]
,"0$1"]
,[,"(\\d{2})(\\d{3,11})","$1 $2",["3[02]|40|[68]9"]
,"0$1"]
,[,"(\\d{3})(\\d{3,11})","$1 $2",["2(?:0[1-389]|1[124]|2[18]|3[14]|[4-9]1)|3(?:[35-9][15]|4[015])|[4-8][1-9]1|9(?:06|[1-9]1)"]
,"0$1"]
,[,"(\\d{4})(\\d{2,11})","$1 $2",["[24-6]|3(?:[3569][02-46-9]|4[2-4679]|7[2-467]|8[2-46-8])|[7-9](?:0[1-9]|[1-9])","[24-6]|3(?:3(?:0[1-467]|2[127-9]|3[124578]|[46][1246]|7[1257-9]|8[1256]|9[145])|4(?:2[135]|3[1357]|4[13578]|6[1246]|7[1356]|9[1346])|5(?:0[14]|2[1-3589]|3[1357]|[49][1246]|6[1-4]|7[1346]|8[13568])|6(?:0[356]|2[1-489]|3[124-6]|4[1347]|6[13]|7[12579]|8[1-356]|9[135])|7(?:2[1-7]|3[1357]|4[145]|6[1-5]|7[1-4])|8(?:21|3[1468]|4[1347]|6[0135-9]|7[1467]|8[136])|9(?:0[12479]|2[1358]|3[1357]|4[134679]|6[1-9]|7[136]|8[147]|9[1468]))|[7-9](?:0[1-9]|[1-9])"]
,"0$1"]
,[,"(3\\d{4})(\\d{1,10})","$1 $2",["3"]
,"0$1"]
,[,"(800)(\\d{7,12})","$1 $2",["800"]
,"0$1"]
,[,"(\\d{3})(\\d)(\\d{4,10})","$1 $2 $3",["1(?:37|80)|900","1(?:37|80)|900[1359]"]
,"0$1"]
,[,"(1\\d{2})(\\d{5,11})","$1 $2",["181"]
,"0$1"]
,[,"(18\\d{3})(\\d{6})","$1 $2",["185","1850","18500"]
,"0$1"]
,[,"(18\\d{2})(\\d{7})","$1 $2",["18[68]"]
,"0$1"]
,[,"(18\\d)(\\d{8})","$1 $2",["18[2-579]"]
,"0$1"]
,[,"(700)(\\d{4})(\\d{4})","$1 $2 $3",["700"]
,"0$1"]
,[,"(138)(\\d{4})","$1 $2",["138"]
,"0$1"]
,[,"(15[013-68])(\\d{2})(\\d{8})","$1 $2 $3",["15[013-68]"]
,"0$1"]
,[,"(15[279]\\d)(\\d{2})(\\d{7})","$1 $2 $3",["15[279]"]
,"0$1"]
,[,"(1[67]\\d)(\\d{2})(\\d{7,8})","$1 $2 $3",["1(?:6[023]|7)"]
,"0$1"]
]
,,[,,"16(?:4\\d{1,10}|[89]\\d{1,11})",,,,,,,[4,5,6,7,8,9,10,11,12,13,14]
]
,,,[,,,,,,,,,[-1]
]
,[,,"18(?:1\\d{5,11}|[2-9]\\d{8})",,,,,,,[8,9,10,11,12,13,14]
]
,,,[,,"1(?:5(?:(?:2\\d55|7\\d99|9\\d33)\\d{7}|(?:[034568]00|113)\\d{8})|6(?:013|255|399)\\d{7,8}|7(?:[015]13|[234]55|[69]33|[78]99)\\d{7,8})",,,,,,,[12,13]
]
]
,"DJ":[,[,,"[27]\\d{7}",,,,,,,[8]
]
,[,,"2(?:1[2-5]|7[45])\\d{5}"]
,[,,"77\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"DJ",253,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"DK":[,[,,"[2-9]\\d{7}",,,,,,,[8]
]
,[,,"(?:[2-7]\\d|8[126-9]|9[1-36-9])\\d{6}"]
,[,,"(?:[2-7]\\d|8[126-9]|9[1-36-9])\\d{6}"]
,[,,"80\\d{6}"]
,[,,"90\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"DK",45,"00",,,,,,,1,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"DM":[,[,,"[57-9]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"767(?:2(?:55|66)|4(?:2[01]|4[0-25-9])|50[0-4]|70[1-3])\\d{4}",,,,,,,,[7]
]
,[,,"767(?:2(?:[234689]5|7[5-7])|31[5-7]|61[1-7])\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"DM",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"767",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"DO":[,[,,"[589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"8(?:[04]9[2-9]\\d{6}|29(?:2(?:[0-59]\\d|6[04-9]|7[0-27]|8[0237-9])|3(?:[0-35-9]\\d|4[7-9])|[45]\\d{2}|6(?:[0-27-9]\\d|[3-5][1-9]|6[0135-8])|7(?:0[013-9]|[1-37]\\d|4[1-35689]|5[1-4689]|6[1-57-9]|8[1-79]|9[1-8])|8(?:0[146-9]|1[0-48]|[248]\\d|3[1-79]|5[01589]|6[013-68]|7[124-8]|9[0-8])|9(?:[0-24]\\d|3[02-46-9]|5[0-79]|60|7[0169]|8[57-9]|9[02-9]))\\d{4})",,,,,,,,[7]
]
,[,,"8[024]9[2-9]\\d{6}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"DO",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"8[024]9",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"DZ":[,[,,"(?:[1-4]|[5-9]\\d)\\d{7}",,,,,,,[8,9]
]
,[,,"(?:1\\d|2[013-79]|3[0-8]|4[0135689])\\d{6}|9619\\d{5}"]
,[,,"(?:5[4-6]|7[7-9])\\d{7}|6(?:[569]\\d|7[0-6])\\d{6}",,,,,,,[9]
]
,[,,"800\\d{6}",,,,,,,[9]
]
,[,,"80[3-689]1\\d{5}",,,,,,,[9]
]
,[,,"80[12]1\\d{5}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,"98[23]\\d{6}",,,,,,,[9]
]
,"DZ",213,"00","0",,,"0",,,,[[,"([1-4]\\d)(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[1-4]"]
,"0$1"]
,[,"([5-8]\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[5-8]"]
,"0$1"]
,[,"(9\\d)(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["9"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"EC":[,[,,"1\\d{9,10}|[2-8]\\d{7}|9\\d{8}",,,,,,,[8,9,10,11]
,[7]
]
,[,,"[2-7][2-7]\\d{6}",,,,,,,[8]
,[7]
]
,[,,"9(?:(?:39|[45][89]|7[7-9]|[89]\\d)\\d{2}|6(?:[017-9]\\d{2}|2(?:[0-47-9]\\d|5[1-9]|60)|30\\d))\\d{4}",,,,,,,[9]
]
,[,,"1800\\d{6,7}",,,,,,,[10,11]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"[2-7]890\\d{4}",,,,,,,[8]
]
,"EC",593,"00","0",,,"0",,,,[[,"(\\d)(\\d{3})(\\d{4})","$1 $2-$3",["[247]|[356][2-8]"]
,"(0$1)"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["9"]
,"0$1"]
,[,"(1800)(\\d{3})(\\d{3,4})","$1 $2 $3",["180","1800"]
,"$1"]
]
,[[,"(\\d)(\\d{3})(\\d{4})","$1-$2-$3",["[247]|[356][2-8]"]
]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["9"]
,"0$1"]
,[,"(1800)(\\d{3})(\\d{3,4})","$1 $2 $3",["180","1800"]
,"$1"]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"EE":[,[,,"[3-9]\\d{6,7}|800\\d{6,7}",,,,,,,[7,8,10]
]
,[,,"(?:3[23589]|4[3-8]|6\\d|7[1-9]|88)\\d{5}",,,,,,,[7]
]
,[,,"(?:5\\d|8[1-5])\\d{6}|5(?:[02]\\d{2}|1(?:[0-8]\\d|95)|5[0-478]\\d|64[0-4]|65[1-589])\\d{3}",,,,,,,[7,8]
]
,[,,"800(?:0\\d{3}|1\\d|[2-9])\\d{3}"]
,[,,"(?:40\\d{2}|900)\\d{4}",,,,,,,[7,8]
]
,[,,,,,,,,,[-1]
]
,[,,"70[0-2]\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,"EE",372,"00",,,,,,,,[[,"([3-79]\\d{2})(\\d{4})","$1 $2",["[369]|4[3-8]|5(?:[0-2]|5[0-478]|6[45])|7[1-9]","[369]|4[3-8]|5(?:[02]|1(?:[0-8]|95)|5[0-478]|6(?:4[0-4]|5[1-589]))|7[1-9]"]
]
,[,"(70)(\\d{2})(\\d{4})","$1 $2 $3",["70"]
]
,[,"(8000)(\\d{3})(\\d{3})","$1 $2 $3",["800","8000"]
]
,[,"([458]\\d{3})(\\d{3,4})","$1 $2",["40|5|8(?:00|[1-5])","40|5|8(?:00[1-9]|[1-5])"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"800[2-9]\\d{3}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"EG":[,[,,"1\\d{4,9}|[24-6]\\d{8}|3\\d{7}|[89]\\d{8,9}",,,,,,,[8,9,10]
,[7]
]
,[,,"(?:1(?:3[23]\\d|5(?:[23]|9\\d))|2[2-4]\\d{2}|3\\d{2}|4(?:0[2-5]|[578][23]|64)\\d|5(?:0[2-7]|5\\d|7[23])\\d|6[24-689]3\\d|8(?:2[2-57]|4[26]|6[237]|8[2-4])\\d|9(?:2[27]|3[24]|52|6[2356]|7[2-4])\\d)\\d{5}",,,,,,,[8,9]
,[7]
]
,[,,"1[0125]\\d{8}",,,,,,,[10]
]
,[,,"800\\d{7}",,,,,,,[10]
]
,[,,"900\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"EG",20,"00","0",,,"0",,,,[[,"(\\d)(\\d{7,8})","$1 $2",["[23]"]
,"0$1"]
,[,"(\\d{2})(\\d{6,7})","$1 $2",["1(?:3|5[239])|[4-6]|[89][2-9]"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["1[0-25]|[89]00"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"EH":[,[,,"[5-9]\\d{8}",,,,,,,[9]
]
,[,,"528[89]\\d{5}"]
,[,,"(?:6(?:[0-79]\\d|8[0-247-9])|7(?:0[067]|6[1267]|7[07]))\\d{6}"]
,[,,"80\\d{7}"]
,[,,"89\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"5924[01]\\d{4}"]
,"EH",212,"00","0",,,"0",,,,,,[,,,,,,,,,[-1]
]
,,"528[89]",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"ER":[,[,,"[178]\\d{6}",,,,,,,[7]
,[6]
]
,[,,"1(?:1[12568]|20|40|55|6[146])\\d{4}|8\\d{6}",,,,,,,,[6]
]
,[,,"17[1-3]\\d{4}|7\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"ER",291,"00","0",,,"0",,,,[[,"(\\d)(\\d{3})(\\d{3})","$1 $2 $3",,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"ES":[,[,,"[5-9]\\d{8}",,,,,,,[9]
]
,[,,"8(?:[1356]\\d|[28][0-8]|[47][1-9])\\d{6}|9(?:[135]\\d{7}|[28][0-8]\\d{6}|4[1-9]\\d{6}|6(?:[0-8]\\d{6}|9(?:0(?:[0-57-9]\\d{4}|6(?:0[0-8]|1[1-9]|[2-9]\\d)\\d{2})|[1-9]\\d{5}))|7(?:[124-9]\\d{2}|3(?:[0-8]\\d|9[1-9]))\\d{4})"]
,[,,"(?:6\\d{6}|7[1-48]\\d{5}|9(?:6906(?:09|10)|7390\\d{2}))\\d{2}"]
,[,,"[89]00\\d{6}"]
,[,,"80[367]\\d{6}"]
,[,,"90[12]\\d{6}"]
,[,,"70\\d{7}"]
,[,,,,,,,,,[-1]
]
,"ES",34,"00",,,,,,,,[[,"([89]00)(\\d{3})(\\d{3})","$1 $2 $3",["[89]00"]
]
,[,"([5-9]\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[568]|[79][0-8]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"51\\d{7}"]
,,,[,,,,,,,,,[-1]
]
]
,"ET":[,[,,"[1-59]\\d{8}",,,,,,,[9]
,[7]
]
,[,,"(?:11(?:1(?:1[124]|2[2-57]|3[1-5]|5[5-8]|8[6-8])|2(?:13|3[6-8]|5[89]|7[05-9]|8[2-6])|3(?:2[01]|3[0-289]|4[1289]|7[1-4]|87)|4(?:1[69]|3[2-49]|4[0-3]|6[5-8])|5(?:1[578]|44|5[0-4])|6(?:18|2[69]|39|4[5-7]|5[1-5]|6[0-59]|8[015-8]))|2(?:2(?:11[1-9]|22[0-7]|33\\d|44[1467]|66[1-68])|5(?:11[124-6]|33[2-8]|44[1467]|55[14]|66[1-3679]|77[124-79]|880))|3(?:3(?:11[0-46-8]|22[0-6]|33[0134689]|44[04]|55[0-6]|66[01467])|4(?:44[0-8]|55[0-69]|66[0-3]|77[1-5]))|4(?:6(?:22[0-24-7]|33[1-5]|44[13-69]|55[14-689]|660|88[1-4])|7(?:11[1-9]|22[1-9]|33[13-7]|44[13-6]|55[1-689]))|5(?:7(?:227|55[05]|(?:66|77)[14-8])|8(?:11[149]|22[013-79]|33[0-68]|44[013-8]|550|66[1-5]|77\\d)))\\d{4}",,,,,,,,[7]
]
,[,,"9(?:[1-46-8]\\d|5[89])\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"ET",251,"00","0",,,"0",,,,[[,"([1-59]\\d)(\\d{3})(\\d{4})","$1 $2 $3",["[1-59]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"FI":[,[,,"1\\d{5,9}|2\\d{4,9}|[35]\\d{5,9}|4\\d{5,10}|6\\d{6,9}|7\\d{7,9}|8\\d{6,8}|9\\d{4,8}",,,,,,,[5,6,7,8,9,10,11]
]
,[,,"1[3-79][1-8]\\d{4,6}|[23568][1-8]\\d{5,7}|9[1-8]\\d{3,7}",,,,,,,[5,6,7,8,9]
]
,[,,"4[0-8]\\d{5,8}|50\\d{4,8}",,,,,,,[6,7,8,9,10,11]
]
,[,,"800\\d{5,6}",,,,,,,[8,9]
]
,[,,"[67]00\\d{5,6}",,,,,,,[8,9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"FI",358,"00|99(?:[02469]|5(?:11|33|5[59]|88|9[09]))","0",,,"0",,"00",,[[,"(\\d{3})(\\d{3,7})","$1 $2",["(?:[1-3]0|[6-8])0"]
,"0$1"]
,[,"(116\\d{3})","$1",["116"]
,"$1"]
,[,"(\\d{2})(\\d{3,9})","$1 $2",["1(?:0[1-9]|[3-9])|2(?:0[1-9]|9)|30[1-9]|4|50|7(?:[13]|5[03-9])"]
,"0$1"]
,[,"(75\\d{3})","$1",["75[12]"]
,"0$1"]
,[,"(\\d)(\\d{4})","$1 $2",["9[1-8]"]
,"0$1"]
,[,"(\\d)(\\d{5,9})","$1 $2",["[235689][1-8]"]
,"0$1"]
,[,"(39\\d)(\\d{3})(\\d{3})","$1 $2 $3",["39"]
,"0$1"]
]
,[[,"(\\d{3})(\\d{3,7})","$1 $2",["(?:[1-3]0|[6-8])0"]
,"0$1"]
,[,"(116\\d{3})","$1",["116"]
,"$1"]
,[,"(\\d{2})(\\d{3,9})","$1 $2",["1(?:0[1-9]|[3-9])|2(?:0[1-9]|9)|30[1-9]|4|50|7(?:[13]|5[03-9])"]
,"0$1"]
,[,"(\\d)(\\d{4})","$1 $2",["9[1-8]"]
,"0$1"]
,[,"(\\d)(\\d{5,9})","$1 $2",["[235689][1-8]"]
,"0$1"]
,[,"(39\\d)(\\d{3})(\\d{3})","$1 $2 $3",["39"]
,"0$1"]
]
,[,,,,,,,,,[-1]
]
,1,,[,,"100\\d{4,6}|20(?:0\\d{4,6}|2[023]\\d{4,5}|9[89]\\d{1,6})|300\\d{3,7}|60(?:[12]\\d{5,6}|6\\d{7})|7(?:1\\d{7}|3\\d{8}|5[03-9]\\d{5,6})",,,,,,,[5,6,7,8,9,10]
]
,[,,"10(?:0\\d{4,6}|[1-37-9]\\d{5,7}|[46]\\d{3,7}|5\\d{4,7})|2(?:0(?:0\\d{4,6}|[1346-8]\\d{5,7}|2(?:[023]\\d{4,5}|[14-9]\\d{4,6})|5(?:\\d{3}|\\d{5,7})|9(?:[0-7]\\d{4,6}|[89]\\d{1,6}))|9\\d{5,8})|3(?:0(?:0\\d{3,7}|[1-57-9]\\d{5,7}|6(?:\\d{3}|\\d{5,7}))|44\\d{3}|93\\d{5,7})|60(?:[12]\\d{5,6}|6\\d{7})|7(?:1\\d{7}|3\\d{8}|5[03-9]\\d{5,6})",,,,,,,[5,6,7,8,9,10]
]
,,,[,,,,,,,,,[-1]
]
]
,"FJ":[,[,,"[2-9]\\d{6}|0\\d{10}",,,,,,,[7,11]
]
,[,,"(?:3[0-5]|6[25-7]|8[58])\\d{5}",,,,,,,[7]
]
,[,,"(?:[279]\\d|45|5[01568]|8[034679])\\d{5}",,,,,,,[7]
]
,[,,"0800\\d{7}",,,,,,,[11]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"FJ",679,"0(?:0|52)",,,,,,"00",,[[,"(\\d{3})(\\d{4})","$1 $2",["[2-9]"]
]
,[,"(\\d{4})(\\d{3})(\\d{4})","$1 $2 $3",["0"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"FK":[,[,,"[2-7]\\d{4}",,,,,,,[5]
]
,[,,"[2-47]\\d{4}"]
,[,,"[56]\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"FK",500,"00",,,,,,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"FM":[,[,,"[39]\\d{6}",,,,,,,[7]
]
,[,,"3[2357]0[1-9]\\d{3}|9[2-6]\\d{5}"]
,[,,"3[2357]0[1-9]\\d{3}|9[2-7]\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"FM",691,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"FO":[,[,,"[2-9]\\d{5}",,,,,,,[6]
]
,[,,"(?:20|[3-4]\\d|8[19])\\d{4}"]
,[,,"(?:[27][1-9]|5\\d)\\d{4}"]
,[,,"80[257-9]\\d{3}"]
,[,,"90(?:[1345][15-7]|2[125-7]|99)\\d{2}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"(?:6[0-36]|88)\\d{4}"]
,"FO",298,"00",,,,"(10(?:01|[12]0|88))",,,,[[,"(\\d{6})","$1",,,"$CC $1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"FR":[,[,,"[1-9]\\d{8}",,,,,,,[9]
]
,[,,"[1-5]\\d{8}"]
,[,,"(?:6\\d|7[3-9])\\d{7}"]
,[,,"80[0-5]\\d{6}"]
,[,,"89[1-37-9]\\d{6}"]
,[,,"8(?:1[0-29]|2[0156]|84|90)\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"9\\d{8}"]
,"FR",33,"00","0",,,"0",,,,[[,"([1-79])(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4 $5",["[1-79]"]
,"0$1"]
,[,"(1\\d{2})(\\d{3})","$1 $2",["11"]
,"$1"]
,[,"(8\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["8"]
,"0 $1"]
]
,[[,"([1-79])(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4 $5",["[1-79]"]
,"0$1"]
,[,"(8\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["8"]
,"0 $1"]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"80[6-9]\\d{6}"]
,,,[,,,,,,,,,[-1]
]
]
,"GA":[,[,,"0?\\d{7}",,,,,,,[7,8]
]
,[,,"01\\d{6}",,,,,,,[8]
]
,[,,"0?[2-7]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"GA",241,"00",,,,,,,,[[,"(\\d)(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[2-7]"]
,"0$1"]
,[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["0"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GB":[,[,,"\\d{7,10}",,,,,,,[7,9,10]
,[4,5,6,8]
]
,[,,"2(?:0[01378]|3[0189]|4[017]|8[0-46-9]|9[0-2])\\d{7}|1(?:1(?:3[0-48]|[46][0-4]|5[0-26-9]|[78][0-49])|21[0-7]|31[0-8]|[4-69]1\\d)\\d{6}|1(?:2(?:0[024-9]|2[3-9]|3[3-79]|4[1-689]|[58][02-9]|6[0-47-9]|7[013-9]|9\\d)|3(?:0\\d|[25][02-9]|3[02-579]|[468][0-46-9]|7[1-35-79]|9[2-578])|4(?:0[03-9]|[28][02-57-9]|[37]\\d|4[02-69]|5[0-8]|[69][0-79])|5(?:0[1-35-9]|2[024-9]|3[015689]|4[02-9]|5[03-9]|6\\d|7[0-35-9]|8[0-468]|9[0-57-9])|6(?:0[034689]|2[0-35689]|[38][013-9]|4[1-467]|5[0-69]|6[13-9]|7[0-8]|9[0124578])|7(?:0[0246-9]|2\\d|3[0236-8]|4[03-9]|5[0-46-9]|6[013-9]|7[0-35-9]|8[024-9]|9[02-9])|8(?:0[35-9]|2[1-57-9]|3[02-578]|4[0-578]|5[124-9]|6[2-69]|7\\d|8[02-9]|9[02569])|9(?:0[02-589]|2[02-689]|3[1-57-9]|4[2-9]|5[0-579]|6[2-47-9]|7[0-24578]|8\\d|9[2-57]))\\d{6}|1(?:2(?:0(?:46[1-4]|87[2-9])|545[1-79]|76(?:2\\d|3[1-8]|6[1-6])|9(?:7(?:2[0-4]|3[2-5])|8(?:2[2-8]|7[0-47-9]|8[345])))|3(?:638[2-5]|647[23]|8(?:47[04-9]|64[0157-9]))|4(?:044[1-7]|20(?:2[23]|8\\d)|6(?:0(?:30|5[2-57]|6[1-8]|7[2-8])|140)|8(?:052|87[123]))|5(?:24(?:3[2-79]|6\\d)|276\\d|6(?:26[06-9]|686))|6(?:06(?:4\\d|7[4-79])|295[567]|35[34]\\d|47(?:24|61)|59(?:5[08]|6[67]|74)|955[0-4])|7(?:26(?:6[13-9]|7[0-7])|442\\d|50(?:2[0-3]|[3-68]2|76))|8(?:27[56]\\d|37(?:5[2-5]|8[239])|84(?:3[2-58]))|9(?:0(?:0(?:6[1-8]|85)|52\\d)|3583|4(?:66[1-8]|9(?:2[01]|81))|63(?:23|3[1-4])|9561))\\d{3}|176888[2-46-8]\\d{2}|16977[23]\\d{3}",,,,,,,[9,10]
,[4,5,6,7,8]
]
,[,,"7(?:[1-3]\\d{3}|4(?:[0-46-9]\\d{2}|5(?:[0-689]\\d|7[0-57-9]))|5(?:0[0-8]|[13-9]\\d|2[0-35-9])\\d|7(?:0(?:0[01]|[1-9]\\d)|[1-7]\\d{2}|8[02-9]\\d|9[0-689]\\d)|8(?:[014-9]\\d|[23][0-8])\\d|9(?:[024-9]\\d{2}|1(?:[02-9]\\d|1[028])|3[0-689]\\d))\\d{5}",,,,,,,[10]
]
,[,,"80(?:0(?:1111|\\d{6,7})|8\\d{7})"]
,[,,"(?:87[123]|9(?:[01]\\d|8[2349]))\\d{7}",,,,,,,[10]
]
,[,,"8(?:4(?:5464\\d|[2-5]\\d{7})|70\\d{7})",,,,,,,[7,10]
]
,[,,"70\\d{8}",,,,,,,[10]
]
,[,,"56\\d{8}",,,,,,,[10]
]
,"GB",44,"00","0"," x",,"0",,,,[[,"(7\\d{3})(\\d{6})","$1 $2",["7(?:[1-57-9]|62)","7(?:[1-57-9]|624)"]
,"0$1"]
,[,"(\\d{2})(\\d{4})(\\d{4})","$1 $2 $3",["2|5[56]|7[06]"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["1(?:[02-9]1|1)|3|9[018]"]
,"0$1"]
,[,"(\\d{5})(\\d{4,5})","$1 $2",["1(?:38|5[23]|69|76|94)","1(?:(?:38|69)7|5(?:24|39)|768|946)","1(?:3873|5(?:242|39[4-6])|(?:697|768)[347]|9467)"]
,"0$1"]
,[,"(1\\d{3})(\\d{5,6})","$1 $2",["1"]
,"0$1"]
,[,"(800)(\\d{4})","$1 $2",["800","8001","80011","800111","8001111"]
,"0$1"]
,[,"(845)(46)(4\\d)","$1 $2 $3",["845","8454","84546","845464"]
,"0$1"]
,[,"(8\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["8(?:4[2-5]|7[0-3])"]
,"0$1"]
,[,"(80\\d)(\\d{3})(\\d{4})","$1 $2 $3",["80"]
,"0$1"]
,[,"(800)(\\d{6})","$1 $2",["800"]
,"0$1"]
]
,,[,,"76(?:0[012]|2[356]|4[0134]|5[49]|6[0-369]|77|81|9[39])\\d{6}",,,,,,,[10]
]
,1,,[,,,,,,,,,[-1]
]
,[,,"(?:3[0347]|55)\\d{8}",,,,,,,[10]
]
,,,[,,,,,,,,,[-1]
]
]
,"GD":[,[,,"[4589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"473(?:2(?:3[0-2]|69)|3(?:2[89]|86)|4(?:[06]8|3[5-9]|4[0-49]|5[5-79]|68|73|90)|63[68]|7(?:58|84)|800|938)\\d{4}",,,,,,,,[7]
]
,[,,"473(?:4(?:0[2-79]|1[04-9]|2[0-5]|58)|5(?:2[01]|3[3-8])|901)\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"GD",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"473",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GE":[,[,,"[34578]\\d{8}",,,,,,,[9]
,[6]
]
,[,,"(?:3(?:[256]\\d|4[124-9]|7[0-4])|4(?:1\\d|2[2-7]|3[1-79]|4[2-8]|7[239]|9[1-7]))\\d{6}",,,,,,,,[6]
]
,[,,"5(?:[14]4|5[0157-9]|68|7[0147-9]|9[0-35-9])\\d{6}"]
,[,,"800\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"706\\d{6}"]
,"GE",995,"00","0",,,"0",,,,[[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[348]"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["7"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["5"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"706\\d{6}"]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GF":[,[,,"[56]\\d{8}",,,,,,,[9]
]
,[,,"594(?:10|2[012457-9]|3[0-57-9]|4[3-9]|5[7-9]|6[0-3]|9[014])\\d{4}"]
,[,,"694(?:[0249]\\d|1[2-9]|3[0-48])\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"GF",594,"00","0",,,"0",,,,[[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GG":[,[,,"[135789]\\d{6,9}",,,,,,,[7,9,10]
,[6]
]
,[,,"1481[25-9]\\d{5}",,,,,,,[10]
,[6]
]
,[,,"7(?:781\\d|839\\d|911[17])\\d{5}",,,,,,,[10]
]
,[,,"80(?:0(?:1111|\\d{6,7})|8\\d{7})"]
,[,,"(?:87[123]|9(?:[01]\\d|8[0-3]))\\d{7}",,,,,,,[10]
]
,[,,"8(?:4(?:5464\\d|[2-5]\\d{7})|70\\d{7})",,,,,,,[7,10]
]
,[,,"70\\d{8}",,,,,,,[10]
]
,[,,"56\\d{8}",,,,,,,[10]
]
,"GG",44,"00","0",,,"0",,,,,,[,,"76(?:0[012]|2[356]|4[0134]|5[49]|6[0-369]|77|81|9[39])\\d{6}",,,,,,,[10]
]
,,,[,,,,,,,,,[-1]
]
,[,,"(?:3[0347]|55)\\d{8}",,,,,,,[10]
]
,,,[,,,,,,,,,[-1]
]
]
,"GH":[,[,,"[235]\\d{8}|8\\d{7}",,,,,,,[8,9]
,[7]
]
,[,,"3(?:0(?:[237]\\d|80)|[167](?:2[0-6]|7\\d|80)|2(?:2[0-5]|7\\d|80)|3(?:2[0-3]|7\\d|80)|4(?:2[013-9]|3[01]|7\\d|80)|5(?:2[0-7]|7\\d|80)|8(?:2[0-2]|7\\d|80)|9(?:[28]0|7\\d))\\d{5}",,,,,,,[9]
,[7]
]
,[,,"(?:2[034678]\\d|5(?:[0457]\\d|6[01]))\\d{6}",,,,,,,[9]
]
,[,,"800\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"GH",233,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["[235]"]
,"0$1"]
,[,"(\\d{3})(\\d{5})","$1 $2",["8"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"800\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GI":[,[,,"[256]\\d{7}",,,,,,,[8]
]
,[,,"2(?:00\\d{2}|1(?:6[24-7]\\d|90[0-2])|2(?:2[2457]\\d|50[0-2]))\\d{3}"]
,[,,"(?:5[46-8]|62)\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"GI",350,"00",,,,,,,,[[,"(\\d{3})(\\d{5})","$1 $2",["2"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GL":[,[,,"[1-689]\\d{5}",,,,,,,[6]
]
,[,,"(?:19|3[1-7]|6[14689]|8[14-79]|9\\d)\\d{4}"]
,[,,"(?:[25][1-9]|4[2-9])\\d{4}"]
,[,,"80\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"3[89]\\d{4}"]
,"GL",299,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GM":[,[,,"[2-9]\\d{6}",,,,,,,[7]
]
,[,,"(?:4(?:[23]\\d{2}|4(?:1[024679]|[6-9]\\d))|5(?:54[0-7]|6(?:[67]\\d)|7(?:1[04]|2[035]|3[58]|48))|8\\d{3})\\d{3}"]
,[,,"[23679]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"GM",220,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GN":[,[,,"[367]\\d{7,8}",,,,,,,[8,9]
]
,[,,"30(?:24|3[12]|4[1-35-7]|5[13]|6[189]|[78]1|9[1478])\\d{4}",,,,,,,[8]
]
,[,,"6[02356]\\d{7}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"722\\d{6}",,,,,,,[9]
]
,"GN",224,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["3"]
]
,[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[67]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GP":[,[,,"[56]\\d{8}",,,,,,,[9]
]
,[,,"590(?:0[13468]|1[012]|2[0-68]|3[28]|4[0-8]|5[579]|6[0189]|70|8[0-689]|9\\d)\\d{4}"]
,[,,"690(?:0[05-9]|[1-9]\\d)\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"GP",590,"00","0",,,"0",,,,[[,"([56]90)(\\d{2})(\\d{4})","$1 $2-$3",["[56]90"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,1,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GQ":[,[,,"[23589]\\d{8}",,,,,,,[9]
]
,[,,"3(?:3(?:3\\d[7-9]|[0-24-9]\\d[46])|5\\d{2}[7-9])\\d{4}"]
,[,,"(?:222|55[15])\\d{6}"]
,[,,"80\\d[1-9]\\d{5}"]
,[,,"90\\d[1-9]\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"GQ",240,"00",,,,,,,,[[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["[235]"]
]
,[,"(\\d{3})(\\d{6})","$1 $2",["[89]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GR":[,[,,"[26-9]\\d{9}",,,,,,,[10]
]
,[,,"2(?:1\\d{2}|2(?:2[1-46-9]|3[1-8]|4[1-7]|5[1-4]|6[1-8]|7[1-5]|[89][1-9])|3(?:1\\d|2[1-57]|[35][1-3]|4[13]|7[1-7]|8[124-6]|9[1-79])|4(?:1\\d|2[1-8]|3[1-4]|4[13-5]|6[1-578]|9[1-5])|5(?:1\\d|[29][1-4]|3[1-5]|4[124]|5[1-6])|6(?:1\\d|3[1245]|4[1-7]|5[13-9]|[269][1-6]|7[14]|8[1-5])|7(?:1\\d|2[1-5]|3[1-6]|4[1-7]|5[1-57]|6[135]|9[125-7])|8(?:1\\d|2[1-5]|[34][1-4]|9[1-57]))\\d{6}"]
,[,,"69\\d{8}"]
,[,,"800\\d{7}"]
,[,,"90[19]\\d{7}"]
,[,,"8(?:0[16]|12|25)\\d{7}"]
,[,,"70\\d{8}"]
,[,,,,,,,,,[-1]
]
,"GR",30,"00",,,,,,,,[[,"([27]\\d)(\\d{4})(\\d{4})","$1 $2 $3",["21|7"]
]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["2[2-9]1|[689]"]
]
,[,"(2\\d{3})(\\d{6})","$1 $2",["2[2-9][02-9]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GT":[,[,,"[2-7]\\d{7}|1[89]\\d{9}",,,,,,,[8,11]
]
,[,,"[267][2-9]\\d{6}",,,,,,,[8]
]
,[,,"[345]\\d{7}",,,,,,,[8]
]
,[,,"18[01]\\d{8}",,,,,,,[11]
]
,[,,"19\\d{9}",,,,,,,[11]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"GT",502,"00",,,,,,,,[[,"(\\d{4})(\\d{4})","$1 $2",["[2-7]"]
]
,[,"(\\d{4})(\\d{3})(\\d{4})","$1 $2 $3",["1"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GU":[,[,,"[5689]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"671(?:3(?:00|3[39]|4[349]|55|6[26])|4(?:00|56|7[1-9]|8[0236-9])|5(?:55|6[2-5]|88)|6(?:3[2-578]|4[24-9]|5[34]|78|8[235-9])|7(?:[079]7|2[0167]|3[45]|47|8[7-9])|8(?:[2-57-9]8|6[48])|9(?:2[29]|6[79]|7[1279]|8[7-9]|9[78]))\\d{4}",,,,,,,,[7]
]
,[,,"671(?:3(?:00|3[39]|4[349]|55|6[26])|4(?:00|56|7[1-9]|8[0236-9])|5(?:55|6[2-5]|88)|6(?:3[2-578]|4[24-9]|5[34]|78|8[235-9])|7(?:[079]7|2[0167]|3[45]|47|8[7-9])|8(?:[2-57-9]8|6[48])|9(?:2[29]|6[79]|7[1279]|8[7-9]|9[78]))\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"GU",1,"011","1",,,"1",,,1,,,[,,,,,,,,,[-1]
]
,,"671",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GW":[,[,,"(?:4(?:0\\d{5}|4\\d{7})|9\\d{8})",,,,,,,[7,9]
]
,[,,"443\\d{6}",,,,,,,[9]
]
,[,,"9(?:5(?:5\\d|6[0-2])|6(?:5[0-2]|6\\d|9[012])|77\\d)\\d{5}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"40\\d{5}",,,,,,,[7]
]
,"GW",245,"00",,,,,,,,[[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["44|9[5-7]"]
]
,[,"(\\d{3})(\\d{4})","$1 $2",["40"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"GY":[,[,,"[2-46-9]\\d{6}",,,,,,,[7]
]
,[,,"(?:2(?:1[6-9]|2[0-35-9]|3[1-4]|5[3-9]|6\\d|7[0-24-79])|3(?:2[25-9]|3\\d)|4(?:4[0-24]|5[56])|77[1-57])\\d{4}"]
,[,,"6\\d{6}"]
,[,,"(?:289|862)\\d{4}"]
,[,,"9008\\d{3}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"GY",592,"001",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"HK":[,[,,"[2-7]\\d{7}|8[0-3]\\d{6,7}|9\\d{4,10}",,,,,,,[5,6,7,8,9,11]
]
,[,,"(?:2(?:[13-8]\\d|2[013-9]|9[0-24-9])|3(?:[1569][0-24-9]|4[0-246-9]|7[0-24-69]|89)|58[01])\\d{5}",,,,,,,[8]
]
,[,,"(?:464|5(?:[1-59][0-46-9]|6[0-4689]|7[0-469])|6(?:0[1-9]|[1459]\\d|[2368][0-57-9]|7[0-79])|9(?:0[1-9]|1[02-9]|[2358][0-8]|[467]\\d))\\d{5}",,,,,,,[8]
]
,[,,"800\\d{6}",,,,,,,[9]
]
,[,,"900(?:[0-24-9]\\d{7}|3\\d{1,4})",,,,,,,[5,6,7,8,11]
]
,[,,,,,,,,,[-1]
]
,[,,"8(?:1[1-4679]|2[0-367]|3[02-47])\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,"HK",852,"00(?:[126-9]|30|5[09])?",,,,,,"00",,[[,"(\\d{4})(\\d{4})","$1 $2",["[2-7]|[89](?:0[1-9]|[1-9])"]
]
,[,"(800)(\\d{3})(\\d{3})","$1 $2 $3",["800"]
]
,[,"(900)(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3 $4",["900"]
]
,[,"(900)(\\d{2,5})","$1 $2",["900"]
]
]
,,[,,"7(?:1[0-369]|[23][0-37-9]|47|5[1578]|6[0235]|7[278]|8[236-9]|9[025-9])\\d{5}",,,,,,,[8]
]
,,,[,,,,,,,,,[-1]
]
,[,,"30(?:0[1-9]|[15-7]\\d|2[047]|89)\\d{4}",,,,,,,[8]
]
,,,[,,,,,,,,,[-1]
]
]
,"HN":[,[,,"[237-9]\\d{7}",,,,,,,[8]
]
,[,,"2(?:2(?:0[019]|1[1-36]|[23]\\d|4[04-6]|5[57]|7[013689]|8[0146-9]|9[012])|4(?:07|2[3-59]|3[13-689]|4[0-68]|5[1-35])|5(?:16|4[03-5]|5\\d|6[4-6]|74)|6(?:[056]\\d|17|3[04]|4[0-378]|[78][0-8]|9[01])|7(?:6[46-9]|7[02-9]|8[034])|8(?:79|8[0-35789]|9[1-57-9]))\\d{4}"]
,[,,"[37-9]\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"HN",504,"00",,,,,,,,[[,"(\\d{4})(\\d{4})","$1-$2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"HR":[,[,,"[1-7]\\d{5,8}|[89]\\d{6,8}",,,,,,,[6,7,8,9]
]
,[,,"1\\d{7}|(?:2[0-3]|3[1-5]|4[02-47-9]|5[1-3])\\d{6,7}",,,,,,,[8,9]
,[6,7]
]
,[,,"9(?:01\\d|[1259]\\d{2}|7(?:[0679]\\d|51)|8\\d{1,2})\\d{5}",,,,,,,[8,9]
]
,[,,"80[01]\\d{4,6}",,,,,,,[7,8,9]
]
,[,,"6(?:[01]\\d{0,2}|[459]\\d{2})\\d{4}",,,,,,,[6,7,8]
]
,[,,,,,,,,,[-1]
]
,[,,"7[45]\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,"HR",385,"00","0",,,"0",,,,[[,"(1)(\\d{4})(\\d{3})","$1 $2 $3",["1"]
,"0$1"]
,[,"([2-5]\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["[2-5]"]
,"0$1"]
,[,"(9\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["9"]
,"0$1"]
,[,"(6[01])(\\d{2})(\\d{2,3})","$1 $2 $3",["6[01]"]
,"0$1"]
,[,"([67]\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["[67]"]
,"0$1"]
,[,"(80[01])(\\d{2})(\\d{2,3})","$1 $2 $3",["80[01]"]
,"0$1"]
,[,"(80[01])(\\d{3})(\\d{3})","$1 $2 $3",["80[01]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"(?:62\\d?|72)\\d{6}",,,,,,,[8,9]
]
,,,[,,,,,,,,,[-1]
]
]
,"HT":[,[,,"[2-489]\\d{7}",,,,,,,[8]
]
,[,,"2(?:2\\d|5[1-5]|81|9[149])\\d{5}"]
,[,,"[34]\\d{7}"]
,[,,"8\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"(?:9(?:[67][0-4]|8[0-3589]|9\\d))\\d{5}"]
,"HT",509,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{4})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"HU":[,[,,"[1-9]\\d{7,8}",,,,,,,[8,9]
,[6]
]
,[,,"(?:1\\d|2[2-9]|3[2-7]|4[24-9]|5[2-79]|6[23689]|7[2-9]|8[2-57-9]|9[2-69])\\d{6}",,,,,,,[8]
,[6]
]
,[,,"(?:[257]0|3[01])\\d{7}",,,,,,,[9]
]
,[,,"[48]0\\d{6}",,,,,,,[8]
]
,[,,"9[01]\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"21\\d{7}",,,,,,,[9]
]
,"HU",36,"00","06",,,"06",,,,[[,"(1)(\\d{3})(\\d{4})","$1 $2 $3",["1"]
,"($1)"]
,[,"(\\d{2})(\\d{3})(\\d{3,4})","$1 $2 $3",["[2-9]"]
,"($1)"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"[48]0\\d{6}",,,,,,,[8]
]
,[,,"38\\d{7}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
]
,"ID":[,[,,"(?:[1-79]\\d{6,10}|8\\d{7,11})",,,,,,,[7,8,9,10,11,12]
,[5,6]
]
,[,,"2(?:1(?:14\\d{3}|[0-8]\\d{6,7}|500\\d{3}|9\\d{6})|2\\d{6,8}|4\\d{7,8})|(?:2(?:[35][1-4]|6[0-8]|7[1-6]|8\\d|9[1-8])|3(?:1|[25][1-8]|3[1-68]|4[1-3]|6[1-3568]|7[0-469]|8\\d)|4(?:0[1-589]|1[01347-9]|2[0-36-8]|3[0-24-68]|43|5[1-378]|6[1-5]|7[134]|8[1245])|5(?:1[1-35-9]|2[25-8]|3[124-9]|4[1-3589]|5[1-46]|6[1-8])|6(?:19?|[25]\\d|3[1-69]|4[1-6])|7(?:02|[125][1-9]|[36]\\d|4[1-8]|7[0-36-9])|9(?:0[12]|1[013-8]|2[0-479]|5[125-8]|6[23679]|7[159]|8[01346]))\\d{5,8}",,,,,,,[7,8,9,10,11]
,[5,6]
]
,[,,"(?:2(?:1(?:3[145]|4[01]|5[1-469]|60|8[0359]|9\\d)|2(?:88|9[1256])|3[1-4]9|4(?:36|91)|5(?:1[349]|[2-4]9)|6[0-7]9|7(?:[1-36]9|4[39])|8[1-5]9|9[1-48]9)|3(?:19[1-3]|2[12]9|3[13]9|4(?:1[69]|39)|5[14]9|6(?:1[69]|2[89])|709)|4[13]19|5(?:1(?:19|8[39])|4[129]9|6[12]9)|6(?:19[12]|2(?:[23]9|77))|7(?:1[13]9|2[15]9|419|5(?:1[89]|29)|6[15]9|7[178]9))\\d{5,6}|8[1-35-9]\\d{7,10}",,,,,,,[9,10,11,12]
]
,[,,"177\\d{6,8}|800\\d{5,7}",,,,,,,[8,9,10,11]
]
,[,,"809\\d{7}",,,,,,,[10]
]
,[,,"804\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"ID",62,"0(?:0[1789]|10(?:00|1[67]))","0",,,"0",,,,[[,"(\\d{2})(\\d{5,8})","$1 $2",["2[124]|[36]1"]
,"(0$1)"]
,[,"(\\d{3})(\\d{5,8})","$1 $2",["2[035-9]|[36][02-9]|[4579]"]
,"(0$1)"]
,[,"(8\\d{2})(\\d{3,4})(\\d{3})","$1-$2-$3",["8[1-35-9]"]
,"0$1"]
,[,"(8\\d{2})(\\d{4})(\\d{4,5})","$1-$2-$3",["8[1-35-9]"]
,"0$1"]
,[,"(1)(500)(\\d{3})","$1 $2 $3",["150","1500"]
,"$1"]
,[,"(177)(\\d{6,8})","$1 $2",["177"]
,"0$1"]
,[,"(800)(\\d{5,7})","$1 $2",["800"]
,"0$1"]
,[,"(804)(\\d{3})(\\d{4})","$1 $2 $3",["804"]
,"0$1"]
,[,"(80\\d)(\\d)(\\d{3})(\\d{3})","$1 $2 $3 $4",["80[79]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"8071\\d{6}",,,,,,,[10]
]
,[,,"1500\\d{3}|8071\\d{6}",,,,,,,[7,10]
]
,,,[,,,,,,,,,[-1]
]
]
,"IE":[,[,,"[124-9]\\d{6,9}",,,,,,,[7,8,9,10]
,[5,6]
]
,[,,"1\\d{7,8}|2(?:1\\d{6,7}|3\\d{7}|[24-9]\\d{5})|4(?:0[24]\\d{5}|[1-469]\\d{7}|5\\d{6}|7\\d{5}|8[0-46-9]\\d{7})|5(?:0[45]\\d{5}|1\\d{6}|[23679]\\d{7}|8\\d{5})|6(?:1\\d{6}|[237-9]\\d{5}|[4-6]\\d{7})|7[14]\\d{7}|9(?:1\\d{6}|[04]\\d{7}|[35-9]\\d{5})",,,,,,,,[5,6]
]
,[,,"8(?:22\\d{6}|[35-9]\\d{7})",,,,,,,[9]
]
,[,,"1800\\d{6}",,,,,,,[10]
]
,[,,"15(?:1[2-8]|[2-8]0|9[089])\\d{6}",,,,,,,[10]
]
,[,,"18[59]0\\d{6}",,,,,,,[10]
]
,[,,"700\\d{6}",,,,,,,[9]
]
,[,,"76\\d{7}",,,,,,,[9]
]
,"IE",353,"00","0",,,"0",,,,[[,"(1)(\\d{3,4})(\\d{4})","$1 $2 $3",["1"]
,"(0$1)"]
,[,"(\\d{2})(\\d{5})","$1 $2",["2[24-9]|47|58|6[237-9]|9[35-9]"]
,"(0$1)"]
,[,"(\\d{3})(\\d{5})","$1 $2",["40[24]|50[45]"]
,"(0$1)"]
,[,"(48)(\\d{4})(\\d{4})","$1 $2 $3",["48"]
,"(0$1)"]
,[,"(818)(\\d{3})(\\d{3})","$1 $2 $3",["818"]
,"(0$1)"]
,[,"(\\d{2})(\\d{3})(\\d{3,4})","$1 $2 $3",["[24-69]|7[14]"]
,"(0$1)"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["76|8[35-9]"]
,"0$1"]
,[,"(8\\d)(\\d)(\\d{3})(\\d{4})","$1 $2 $3 $4",["8[35-9]5"]
,"0$1"]
,[,"(700)(\\d{3})(\\d{3})","$1 $2 $3",["700"]
,"0$1"]
,[,"(\\d{4})(\\d{3})(\\d{3})","$1 $2 $3",["1(?:5|8[059])","1(?:5|8[059]0)"]
,"$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"18[59]0\\d{6}",,,,,,,[10]
]
,[,,"818\\d{6}",,,,,,,[9]
]
,,,[,,"8[35-9]5\\d{7}",,,,,,,[10]
]
]
,"IL":[,[,,"1\\d{6,11}|[2-589]\\d{3}(?:\\d{3,6})?|6\\d{3}|7\\d{6,9}",,,,,,,[4,7,8,9,10,11,12]
]
,[,,"(?:153\\d{1,2}|[2-489])\\d{7}",,,,,,,[8,11,12]
,[7]
]
,[,,"5(?:[0-47-9]\\d{2}|5(?:01|2[23]|3[2-4]|4[45]|5[5689]|6[6-8]|7[0178]|8[6-9]|9[2-9])|6[2-9]\\d)\\d{5}",,,,,,,[9]
]
,[,,"1(?:80[019]\\d{3}|255)\\d{3}",,,,,,,[7,10]
]
,[,,"1(?:212|(?:9(?:0[01]|19)|200)\\d{2})\\d{4}",,,,,,,[8,9,10]
]
,[,,"1700\\d{6}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,"7(?:18\\d|2[23]\\d|3[237]\\d|47\\d|6[58]\\d|7\\d{2}|8(?:2\\d|33|55|77|81)|9[2579]\\d)\\d{5}",,,,,,,[9]
]
,"IL",972,"0(?:0|1[2-9])","0",,,"0",,,,[[,"([2-489])(\\d{3})(\\d{4})","$1-$2-$3",["[2-489]"]
,"0$1"]
,[,"([57]\\d)(\\d{3})(\\d{4})","$1-$2-$3",["[57]"]
,"0$1"]
,[,"(153)(\\d{1,2})(\\d{3})(\\d{4})","$1 $2 $3 $4",["153"]
]
,[,"(1)([7-9]\\d{2})(\\d{3})(\\d{3})","$1-$2-$3-$4",["1[7-9]"]
]
,[,"(1255)(\\d{3})","$1-$2",["125","1255"]
]
,[,"(1200)(\\d{3})(\\d{3})","$1-$2-$3",["120","1200"]
]
,[,"(1212)(\\d{2})(\\d{2})","$1-$2-$3",["121","1212"]
]
,[,"(1599)(\\d{6})","$1-$2",["159","1599"]
]
,[,"(151)(\\d{1,2})(\\d{3})(\\d{4})","$1-$2 $3-$4",["151"]
]
,[,"(\\d{4})","*$1",["[2-689]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"1700\\d{6}|[2-689]\\d{3}",,,,,,,[4,10]
]
,[,,"[2-689]\\d{3}|1599\\d{6}",,,,,,,[4,10]
]
,,,[,,"151\\d{8,9}",,,,,,,[11,12]
]
]
,"IM":[,[,,"[135789]\\d{6,9}",,,,,,,[10]
,[6]
]
,[,,"1624[5-8]\\d{5}",,,,,,,,[6]
]
,[,,"7(?:4576|[59]24\\d|624[0-4689])\\d{5}"]
,[,,"808162\\d{4}"]
,[,,"(?:872299|90[0167]624)\\d{4}"]
,[,,"8(?:4(?:40[49]06|5624\\d)|70624\\d)\\d{3}"]
,[,,"70\\d{8}"]
,[,,"56\\d{8}"]
,"IM",44,"00","0",,,"0",,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"3(?:08162\\d|3\\d{5}|4(?:40[49]06|5624\\d)|7(?:0624\\d|2299\\d))\\d{3}|55\\d{8}"]
,,,[,,,,,,,,,[-1]
]
]
,"IN":[,[,,"008\\d{9}|1\\d{7,12}|[2-9]\\d{9,10}",,,,,,,[8,9,10,11,12,13]
,[6,7]
]
,[,,"(?:11|2[02]|33|4[04]|79|80)[2-7]\\d{7}|(?:1(?:2[0-249]|3[0-25]|4[145]|[59][14]|6[014]|7[1257]|8[01346])|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|[36][25]|22|4[28]|5[12]|[78]1|9[15])|6(?:12|[2345]1|57|6[13]|7[14]|80)|7(?:12|2[14]|3[134]|4[47]|5[15]|[67]1|88)|8(?:16|2[014]|3[126]|6[136]|7[078]|8[34]|91))[2-7]\\d{6}|(?:(?:1(?:2[35-8]|3[346-9]|4[236-9]|[59][0235-9]|6[235-9]|7[34689]|8[257-9])|2(?:1[134689]|3[24-8]|4[2-8]|5[25689]|6[2-4679]|7[13-79]|8[2-479]|9[235-9])|3(?:01|1[79]|2[1-5]|4[25-8]|5[125689]|6[235-7]|7[157-9]|8[2-46-8])|4(?:1[14578]|2[5689]|3[2-467]|5[4-7]|6[35]|73|8[2689]|9[2389])|5(?:[16][146-9]|2[14-8]|3[1346]|4[14-69]|5[46]|7[2-4]|8[2-8]|9[246])|6(?:1[1358]|2[2457]|3[2-4]|4[235-7]|[57][2-689]|6[24-578]|8[1-6])|8(?:1[1357-9]|2[235-8]|3[03-57-9]|4[0-24-9]|5\\d|6[2457-9]|7[1-6]|8[1256]|9[2-4]))\\d|7(?:(?:1[013-9]|2[0235-9]|3[2679]|4[1-35689]|5[2-46-9]|[67][02-9]|9\\d)\\d|8(?:2[0-6]|[013-8]\\d)))[2-7]\\d{5}",,,,,,,[10]
,[6,7,8]
]
,[,,"(?:6(?:00[1-3]\\d|28[0-2]\\d|3(?:5(?:0[0-6]|1\\d)|[89]0\\d)|900\\d)|7(?:0\\d{3}|19[0-5]\\d|2(?:[0235679]\\d{2}|[14][017-9]\\d|8(?:[0-59]\\d|[678][089]))|3(?:[05-8]\\d{2}|1(?:[089]\\d|11|7[5-8])|2(?:[0-49][089]|[5-8]\\d)|3[017-9]\\d|4(?:[07-9]\\d|11)|9(?:[016-9]\\d|[2-5][089]))|4(?:0\\d{2}|1(?:[015-9]\\d|[23][089]|4[089])|2(?:0[089]|[1-7][089]|[89]\\d)|3(?:[0-8][089]|9\\d)|4(?:[089]\\d|11|7[02-8])|[56]\\d[089]|7(?:[089]\\d|11|7[02-8])|8(?:[0-24-7][089]|[389]\\d)|9(?:[0-6][089]|7[089]|[89]\\d))|5(?:[0346-8]\\d{2}|1(?:[07-9]\\d|11)|2(?:[04-9]\\d|[123][089])|5[017-9]\\d|9(?:[0-6][089]|[7-9]\\d))|6(?:0(?:[0-47]\\d|[5689][089])|(?:1[0-257-9]|[6-9]\\d)\\d|2(?:[0-4]\\d|[5-9][089])|3(?:[02-8][089]|[19]\\d)|4\\d[089]|5(?:[0-367][089]|[4589]\\d))|7(?:0(?:0[02-9]|[13-7][089]|[289]\\d)|[1-9]\\d{2})|8(?:[0-79]\\d{2}|8(?:[089]\\d|11|7[02-9]))|9(?:[089]\\d{2}|313|7(?:[02-8]\\d|9[07-9])))|8(?:0(?:[01589]\\d{2}|6[67]\\d|7(?:[02-8]\\d|9[05-9]))|1(?:[02-57-9]\\d{2}|1(?:[0-35-9]\\d|4[0-46-9])|6(?:[089]\\d|7[02-8]))|2(?:0(?:[089]\\d|7[02])|[14](?:[089]\\d|7[02-8])|[235-9]\\d{2})|3(?:[0357-9]\\d{2}|1(?:[089]\\d|7[02-6])|2(?:[09]\\d|77|8[0-689])|4\\d{2}|6(?:[089]\\d|7[02-7]))|[45]\\d{3}|6(?:[02457-9]\\d{2}|1(?:[089]\\d|7[02-8])|3(?:[089]\\d|7[02-8])|6(?:[08]\\d|7[02-8]|9\\d))|7(?:0[07-9]\\d|[1-69]\\d{2}|[78](?:[089]\\d|7[02-8]))|8(?:[0-25-9]\\d{2}|3(?:[089]\\d|7[02-8])|4(?:[0489]\\d|7[02-68]))|9(?:[02-9]\\d{2}|1(?:[0289]\\d|7[2-6])))|9\\d{4})\\d{5}",,,,,,,[10]
]
,[,,"00800\\d{7}|1(?:600\\d{6}|80(?:0\\d{4,9}|3\\d{9}))"]
,[,,"186[12]\\d{9}",,,,,,,[13]
]
,[,,"1860\\d{7}",,,,,,,[11]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"IN",91,"00","0",,,"0",,,,[[,"(\\d{8})","$1",["561","5616","56161"]
,"$1",,1]
,[,"(\\d{5})(\\d{5})","$1 $2",["6(?:[09]0|28|3[589])|7(?:[02-8]|19|9[037-9])|8(?:0[015-9]|[1-9])|9","6(?:[09]0|28[0-2]|3(?:5[01]|[89]0))|7(?:[07]|19[0-5]|2(?:[0235-9]|[14][017-9])|3(?:[025-9]|[134][017-9])|4(?:[0-35689]|[47][017-9])|5(?:[02-46-9]|[15][017-9])|6(?:[02-9]|1[0-257-9])|8(?:[0-79]|8[0189])|9(?:[089]|31|7[02-9]))|8(?:0(?:[01589]|6[67]|7[02-9])|1(?:[0-57-9]|6[07-9])|2(?:[014][07-9]|[235-9])|3(?:[03-57-9]|[126][07-9])|[45]|6(?:[02457-9]|[136][07-9])|7(?:[078][07-9]|[1-69])|8(?:[0-25-9]|3[07-9]|4[047-9])|9(?:[02-9]|1[027-9]))|9","6(?:[09]0|28[0-2]|3(?:5(?:0[0-6]|1)|[89]0))|7(?:0|19[0-5]|2(?:[0235-79]|[14][017-9]|8(?:[0-69]|[78][089]))|3(?:[05-8]|1(?:[0189]|7[5-9])|2(?:[0-49][089]|[5-8])|3[017-9]|4(?:[07-9]|11)|9(?:[01689]|[2-5][089]|7[0189]))|4(?:[056]|1(?:[0135-9]|[24][089])|[29](?:[0-7][089]|[89])|3(?:[0-8][089]|9)|[47](?:[089]|11|7[02-8])|8(?:[0-24-7][089]|[389]))|5(?:[0346-9]|[15][017-9]|2(?:[03-9]|[12][089]))|6(?:[0346-9]|1[0-257-9]|2(?:[0-4]|[5-9][089])|5(?:[0-367][089]|[4589]))|7(?:0(?:[02-9]|1[089])|[1-9])|8(?:[0-79]|8(?:0[0189]|11|8[013-9]|9))|9(?:[089]|313|7(?:[02-8]|9[07-9])))|8(?:0(?:[01589]|6[67]|7(?:[02-8]|9[05-9]))|1(?:[02-57-9]|1(?:[0-35-9]|4[0-46-9])|6(?:[089]|7[02-8]))|2(?:0(?:[089]|7[02])|[14](?:[089]|7[02-8])|[235-9])|3(?:[03-57-9]|1(?:[089]|7[02-6])|2(?:[09]|77|8[0-689])|6(?:[089]|7[02-7]))|[45]|6(?:[02457-9]|[136](?:[089]|7[02-8]))|7(?:0[07-9]|[1-69]|[78](?:[089]|7[02-8]))|8(?:[0-25-9]|3(?:[089]|7[02-8])|4(?:[0489]|7[02-68]))|9(?:[02-9]|1(?:[0289]|7[2-6])))|9"]
,"0$1",,1]
,[,"(\\d{2})(\\d{4})(\\d{4})","$1 $2 $3",["11|2[02]|33|4[04]|79[1-9]|80[2-46]"]
,"0$1",,1]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["1(?:2[0-249]|3[0-25]|4[145]|[59][14]|[68][1-9]|7[1257])|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5[12]|[78]1|9[15])|6(?:12|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|2[14]|3[134]|4[47]|5[15]|[67]1|88)|8(?:16|2[014]|3[126]|6[136]|7[078]|8[34]|91)"]
,"0$1",,1]
,[,"(\\d{4})(\\d{3})(\\d{3})","$1 $2 $3",["1(?:[23579]|[468][1-9])|[2-8]"]
,"0$1",,1]
,[,"(\\d{2})(\\d{3})(\\d{4})(\\d{3})","$1 $2 $3 $4",["008"]
,"0$1",,1]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["140"]
,"$1",,1]
,[,"(\\d{4})(\\d{2})(\\d{4})","$1 $2 $3",["160","1600"]
,"$1",,1]
,[,"(\\d{4})(\\d{4,5})","$1 $2",["180","1800"]
,"$1",,1]
,[,"(\\d{4})(\\d{2,4})(\\d{4})","$1 $2 $3",["180","1800"]
,"$1",,1]
,[,"(\\d{4})(\\d{3,4})(\\d{4})","$1 $2 $3",["186","1860"]
,"$1",,1]
,[,"(\\d{4})(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3 $4",["18[06]"]
,"$1",,1]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"00800\\d{7}|1(?:600\\d{6}|8(?:0(?:0\\d{4,9}|3\\d{9})|6(?:0\\d{7}|[12]\\d{9})))"]
,[,,"140\\d{7}",,,,,,,[10]
]
,,,[,,,,,,,,,[-1]
]
]
,"IO":[,[,,"3\\d{6}",,,,,,,[7]
]
,[,,"37\\d{5}"]
,[,,"38\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"IO",246,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"IQ":[,[,,"[1-7]\\d{7,9}",,,,,,,[8,9,10]
,[6,7]
]
,[,,"1\\d{7}|(?:2[13-5]|3[02367]|4[023]|5[03]|6[026])\\d{6,7}",,,,,,,[8,9]
,[6,7]
]
,[,,"7[3-9]\\d{8}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"IQ",964,"00","0",,,"0",,,,[[,"(1)(\\d{3})(\\d{4})","$1 $2 $3",["1"]
,"0$1"]
,[,"([2-6]\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["[2-6]"]
,"0$1"]
,[,"(7\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["7"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"IR":[,[,,"[1-8]\\d{5,9}|9(?:[0-4]\\d{8}|9\\d{8})",,,,,,,[6,7,10]
,[4,5,8]
]
,[,,"(?:(?:1[137]|2[13-68]|3[1458]|4[145]|5[1468]|6[16]|7[1467]|8[13467])(?:\\d{8}|(?:[16]|[289]\\d?)\\d{3}))|94(?:000|11[0-7]|2\\d{2}|30[01]|440)\\d{5}",,,,,,,,[4,5,8]
]
,[,,"9(?:0(?:[1-3]\\d{2}|44\\d)|[13]\\d{3}|2[0-2]\\d{2}|9(?:[01]\\d{2}|44\\d|810|9(?:0[013]|1[134]|21|9[89])))\\d{5}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"(?:[2-6]0\\d|993)\\d{7}",,,,,,,[10]
]
,"IR",98,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{4})(\\d{4})","$1 $2 $3",["[1-8]"]
,"0$1"]
,[,"(\\d{2})(\\d{4,5})","$1 $2",["[1-8]"]
,"0$1"]
,[,"(\\d{4,5})","$1",["96"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{3,4})","$1 $2 $3",["9"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"(?:9411[1-7]|94440)\\d{5}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"IS":[,[,,"[4-9]\\d{6}|38\\d{7}",,,,,,,[7,9]
]
,[,,"(?:4(?:1[0-24-69]|2[0-7]|[37][0-8]|4[0-245]|5[0-68]|6\\d|8[0-36-8])|5(?:05|[156]\\d|2[02578]|3[0-79]|4[03-7]|7[0-2578]|8[0-35-9]|9[013-689])|87[23])\\d{4}",,,,,,,[7]
]
,[,,"38[589]\\d{6}|(?:6(?:1[1-8]|2[0-6]|3[027-9]|4[014679]|5[0159]|[67][0-69]|9\\d)|7(?:5[057]|[6-8]\\d)|8(?:2[0-59]|3[0-4]|[469]\\d|5[1-9]|88))\\d{4}"]
,[,,"800\\d{4}",,,,,,,[7]
]
,[,,"90\\d{5}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"49\\d{5}",,,,,,,[7]
]
,"IS",354,"1(?:0(?:01|10|20)|100)|00",,,,,,"00",,[[,"(\\d{3})(\\d{4})","$1 $2",["[4-9]"]
]
,[,"(3\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["3"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"809\\d{4}",,,,,,,[7]
]
,,,[,,"(?:6(?:2[78]|8\\d)|8(?:7[0189]|80)|95[48])\\d{4}",,,,,,,[7]
]
]
,"IT":[,[,,"[01589]\\d{5,10}|3(?:[12457-9]\\d{8}|[36]\\d{7,9})",,,,,,,[6,7,8,9,10,11]
]
,[,,"0(?:[26]\\d{4,9}|(?:1(?:[0159]\\d|[27][1-5]|31|4[1-4]|6[1356]|8[2-57])|3(?:[0159]\\d|2[1-4]|3[12]|[48][1-6]|6[2-59]|7[1-7])|4(?:[0159]\\d|[23][1-9]|4[245]|6[1-5]|7[1-4]|81)|5(?:[0159]\\d|2[1-5]|3[2-6]|4[1-79]|6[4-6]|7[1-578]|8[3-8])|7(?:[0159]\\d|2[12]|3[1-7]|4[2346]|6[13569]|7[13-6]|8[1-59])|8(?:[0159]\\d|2[34578]|3[1-356]|[6-8][1-5])|9(?:[0159]\\d|[238][1-5]|4[12]|6[1-8]|7[1-6]))\\d{2,7})"]
,[,,"3(?:[12457-9]\\d{8}|6\\d{7,8}|3\\d{7,9})",,,,,,,[9,10,11]
]
,[,,"80(?:0\\d{6}|3\\d{3})",,,,,,,[6,9]
]
,[,,"0878\\d{5}|1(?:44|6[346])\\d{6}|89(?:2\\d{3}|4(?:[0-4]\\d{2}|[5-9]\\d{4})|5(?:[0-4]\\d{2}|[5-9]\\d{6})|9\\d{6})",,,,,,,[6,8,9,10]
]
,[,,"84(?:[08]\\d{6}|[17]\\d{3})",,,,,,,[6,9]
]
,[,,"1(?:78\\d|99)\\d{6}",,,,,,,[9,10]
]
,[,,"55\\d{8}",,,,,,,[10]
]
,"IT",39,"00",,,,,,,,[[,"(\\d{2})(\\d{3,4})(\\d{4})","$1 $2 $3",["0[26]|55"]
]
,[,"(0[26])(\\d{4})(\\d{5})","$1 $2 $3",["0[26]"]
]
,[,"(0[26])(\\d{4,6})","$1 $2",["0[26]"]
]
,[,"(0\\d{2})(\\d{3,4})(\\d{4})","$1 $2 $3",["0[13-57-9][0159]"]
]
,[,"(\\d{3})(\\d{3,6})","$1 $2",["0[13-57-9][0159]|8(?:03|4[17]|9[245])","0[13-57-9][0159]|8(?:03|4[17]|9(?:2|[45][0-4]))"]
]
,[,"(0\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["0[13-57-9][2-46-8]"]
]
,[,"(0\\d{3})(\\d{2,6})","$1 $2",["0[13-57-9][2-46-8]"]
]
,[,"(\\d{3})(\\d{3})(\\d{3,4})","$1 $2 $3",["[13]|8(?:00|4[08]|9[59])","[13]|8(?:00|4[08]|9(?:5[5-9]|9))"]
]
,[,"(\\d{4})(\\d{4})","$1 $2",["894","894[5-9]"]
]
,[,"(\\d{3})(\\d{4})(\\d{4})","$1 $2 $3",["3"]
]
]
,,[,,,,,,,,,[-1]
]
,1,,[,,"848\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"JE":[,[,,"[135789]\\d{6,9}",,,,,,,[10]
,[6]
]
,[,,"1534[0-24-8]\\d{5}",,,,,,,,[6]
]
,[,,"7(?:509\\d|7(?:00[378]|97[7-9])|829\\d|937\\d)\\d{5}"]
,[,,"80(?:07(?:35|81)|8901)\\d{4}"]
,[,,"(?:871206|90(?:066[59]|1810|71(?:07|55)))\\d{4}"]
,[,,"8(?:4(?:4(?:4(?:05|42|69)|703)|5(?:041|800))|70002)\\d{4}"]
,[,,"701511\\d{4}"]
,[,,"56\\d{8}"]
,"JE",44,"00","0",,,"0",,,,,,[,,"76(?:0[012]|2[356]|4[0134]|5[49]|6[0-369]|77|81|9[39])\\d{6}"]
,,,[,,,,,,,,,[-1]
]
,[,,"3(?:0(?:07(?:35|81)|8901)|3\\d{4}|4(?:4(?:4(?:05|42|69)|703)|5(?:041|800))|7(?:0002|1206))\\d{4}|55\\d{8}"]
,,,[,,,,,,,,,[-1]
]
]
,"JM":[,[,,"[589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"876(?:5(?:0[12]|1[0-468]|2[35]|63)|6(?:0[1-3579]|1[027-9]|[23]\\d|40|5[06]|6[2-589]|7[05]|8[04]|9[4-9])|7(?:0[2-689]|[1-6]\\d|8[056]|9[45])|9(?:0[1-8]|1[02378]|[2-8]\\d|9[2-468]))\\d{4}",,,,,,,,[7]
]
,[,,"876(?:2[14-9]\\d|[348]\\d{2}|5(?:0[3-9]|[2-57-9]\\d|6[0-24-9])|7(?:0[07]|7\\d|8[1-47-9]|9[0-36-9])|9(?:[01]9|9[0579]))\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"JM",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"876",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"JO":[,[,,"[235-9]\\d{7,8}",,,,,,,[8,9]
]
,[,,"(?:2(?:6(?:2[0-35-9]|3[0-57-8]|4[24-7]|5[0-24-8]|[6-8][023]|9[0-3])|7(?:0[1-79]|10|2[014-7]|3[0-689]|4[019]|5[0-3578]))|32(?:0[1-69]|1[1-35-7]|2[024-7]|3\\d|4[0-3]|[57][023]|6[03])|53(?:0[0-3]|[13][023]|2[0-59]|49|5[0-35-9]|6[15]|7[45]|8[1-6]|9[0-36-9])|6(?:2[50]0|3(?:00|33)|4(?:0[0125]|1[2-7]|2[0569]|[38][07-9]|4[025689]|6[0-589]|7\\d|9[0-2])|5(?:[01][056]|2[034]|3[0-57-9]|4[17-8]|5[0-69]|6[0-35-9]|7[1-379]|8[0-68]|9[02-39]))|87(?:[02]0|7[08]|90))\\d{4}",,,,,,,[8]
]
,[,,"7(?:55[0-49]|7[025-9]\\d|8[0-25-9]\\d|9[0-25-9]\\d)\\d{5}",,,,,,,[9]
]
,[,,"80\\d{6}",,,,,,,[8]
]
,[,,"900\\d{5}",,,,,,,[8]
]
,[,,"85\\d{6}",,,,,,,[8]
]
,[,,"70\\d{7}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,"JO",962,"00","0",,,"0",,,,[[,"(\\d)(\\d{3})(\\d{4})","$1 $2 $3",["[2356]|87"]
,"(0$1)"]
,[,"(7)(\\d{4})(\\d{4})","$1 $2 $3",["7[457-9]"]
,"0$1"]
,[,"(\\d{2})(\\d{7})","$1 $2",["70"]
,"0$1"]
,[,"(\\d{3})(\\d{5,6})","$1 $2",["8[0158]|9"]
,"0$1"]
]
,,[,,"74(?:66|77)\\d{5}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
,[,,"8(?:10|8\\d)\\d{5}",,,,,,,[8]
]
,,,[,,,,,,,,,[-1]
]
]
,"JP":[,[,,"[1-9]\\d{8,9}|00(?:[36]\\d{7,14}|7\\d{5,7}|8\\d{7})",,,,,,,[8,9,10,11,12,13,14,15,16,17]
]
,[,,"(?:1(?:1[235-8]|2[3-6]|3[3-9]|4[2-6]|[58][2-8]|6[2-7]|7[2-9]|9[1-9])|2[2-9]\\d|[36][1-9]\\d|4(?:6[02-8]|[2-578]\\d|9[2-59])|5(?:6[1-9]|7[2-8]|[2-589]\\d)|7(?:3[4-9]|4[02-9]|[25-9]\\d)|8(?:3[2-9]|4[5-9]|5[1-9]|8[03-9]|[2679]\\d)|9(?:[679][1-9]|[2-58]\\d))\\d{6}",,,,,,,[9]
]
,[,,"[7-9]0[1-9]\\d{7}",,,,,,,[10]
]
,[,,"120\\d{6}|800\\d{7}|00(?:37\\d{6,13}|66\\d{6,13}|777(?:[01]\\d{2}|5\\d{3}|8\\d{4})|882[1245]\\d{4})"]
,[,,"990\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,"60\\d{7}",,,,,,,[9]
]
,[,,"50[1-9]\\d{7}",,,,,,,[10]
]
,"JP",81,"010","0",,,"0",,,,[[,"(\\d{3})(\\d{3})(\\d{3})","$1-$2-$3",["(?:12|57|99)0"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1-$2-$3",["800"]
,"0$1"]
,[,"(\\d{4})(\\d{4})","$1-$2",["007","0077"]
,"$1"]
,[,"(\\d{4})(\\d{2})(\\d{3,4})","$1-$2-$3",["007","0077"]
,"$1"]
,[,"(\\d{4})(\\d{2})(\\d{4})","$1-$2-$3",["008","0088"]
,"$1"]
,[,"(\\d{4})(\\d{3})(\\d{3,4})","$1-$2-$3",["00[36]","00(?:37|66)"]
,"$1"]
,[,"(\\d{4})(\\d{4})(\\d{4,5})","$1-$2-$3",["00[36]","00(?:37|66)"]
,"$1"]
,[,"(\\d{4})(\\d{5})(\\d{5,6})","$1-$2-$3",["00[36]","00(?:37|66)"]
,"$1"]
,[,"(\\d{4})(\\d{6})(\\d{6,7})","$1-$2-$3",["00[36]","00(?:37|66)"]
,"$1"]
,[,"(\\d{2})(\\d{4})(\\d{4})","$1-$2-$3",["[2579]0|80[1-9]"]
,"0$1"]
,[,"(\\d{4})(\\d)(\\d{4})","$1-$2-$3",["1(?:26|3[79]|4[56]|5[4-68]|6[3-5])|499|5(?:76|97)|746|8(?:3[89]|47|51|63)|9(?:49|80|9[16])","1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:76|97)9|7468|8(?:3(?:8[78]|96)|477|51[24]|636)|9(?:496|802|9(?:1[23]|69))","1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:769|979[2-69])|7468|8(?:3(?:8[78]|96[2457-9])|477|51[24]|636[2-57-9])|9(?:496|802|9(?:1[23]|69))"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{4})","$1-$2-$3",["1(?:2[3-6]|3[3-9]|4[2-6]|5[2-8]|[68][2-7]|7[2-689]|9[1-578])|2(?:2[03-689]|3[3-58]|4[0-468]|5[04-8]|6[013-8]|7[06-9]|8[02-57-9]|9[13])|4(?:2[28]|3[689]|6[035-7]|7[05689]|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|6[1-9]|7[2-8]|8[14-7]|9[4-9])|7(?:2[15]|3[5-9]|4[02-9]|6[135-8]|7[0-4689]|9[014-9])|8(?:2[49]|3[3-8]|4[5-8]|5[2-9]|6[35-9]|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9[3-7])","1(?:2[3-6]|3[3-9]|4[2-6]|5(?:[236-8]|[45][2-69])|[68][2-7]|7[2-689]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|6[1-9]|7[2-8]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4[02-9]|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9[2-8])|3(?:[3-6][2-9]|7[2-6]|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5[4-7]|6[2-9]|8[2-8]|9[236-9])|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3[34]|4[2-69]|[5-7]))","1(?:2[3-6]|3[3-9]|4[2-6]|5(?:[236-8]|[45][2-69])|[68][2-7]|7[2-689]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|6[1-9]|7[2-8]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4[02-9]|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6[56]))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))","1(?:2[3-6]|3[3-9]|4[2-6]|5(?:[236-8]|[45][2-69])|[68][2-7]|7[2-689]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|6[1-9]|7[2-8]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4[02-9]|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6(?:5[25]|60)))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1-$2-$3",["1|2(?:2[37]|5[5-9]|64|78|8[39]|91)|4(?:2[2689]|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93)","1|2(?:2[37]|5(?:[57]|[68]0|9[19])|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93[34])","1|2(?:2[37]|5(?:[57]|[68]0|9(?:17|99))|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93(?:31|4))"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{4})","$1-$2-$3",["2(?:[34]7|[56]9|74|9[14-79])|82|993"]
,"0$1"]
,[,"(\\d)(\\d{4})(\\d{4})","$1-$2-$3",["3|4(?:2[09]|7[01])|6[1-9]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1-$2-$3",["[2479][1-9]"]
,"0$1"]
]
,[[,"(\\d{3})(\\d{3})(\\d{3})","$1-$2-$3",["(?:12|57|99)0"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1-$2-$3",["800"]
,"0$1"]
,[,"(\\d{2})(\\d{4})(\\d{4})","$1-$2-$3",["[2579]0|80[1-9]"]
,"0$1"]
,[,"(\\d{4})(\\d)(\\d{4})","$1-$2-$3",["1(?:26|3[79]|4[56]|5[4-68]|6[3-5])|499|5(?:76|97)|746|8(?:3[89]|47|51|63)|9(?:49|80|9[16])","1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:76|97)9|7468|8(?:3(?:8[78]|96)|477|51[24]|636)|9(?:496|802|9(?:1[23]|69))","1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:769|979[2-69])|7468|8(?:3(?:8[78]|96[2457-9])|477|51[24]|636[2-57-9])|9(?:496|802|9(?:1[23]|69))"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{4})","$1-$2-$3",["1(?:2[3-6]|3[3-9]|4[2-6]|5[2-8]|[68][2-7]|7[2-689]|9[1-578])|2(?:2[03-689]|3[3-58]|4[0-468]|5[04-8]|6[013-8]|7[06-9]|8[02-57-9]|9[13])|4(?:2[28]|3[689]|6[035-7]|7[05689]|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|6[1-9]|7[2-8]|8[14-7]|9[4-9])|7(?:2[15]|3[5-9]|4[02-9]|6[135-8]|7[0-4689]|9[014-9])|8(?:2[49]|3[3-8]|4[5-8]|5[2-9]|6[35-9]|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9[3-7])","1(?:2[3-6]|3[3-9]|4[2-6]|5(?:[236-8]|[45][2-69])|[68][2-7]|7[2-689]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|6[1-9]|7[2-8]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4[02-9]|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9[2-8])|3(?:[3-6][2-9]|7[2-6]|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5[4-7]|6[2-9]|8[2-8]|9[236-9])|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3[34]|4[2-69]|[5-7]))","1(?:2[3-6]|3[3-9]|4[2-6]|5(?:[236-8]|[45][2-69])|[68][2-7]|7[2-689]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|6[1-9]|7[2-8]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4[02-9]|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6[56]))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))","1(?:2[3-6]|3[3-9]|4[2-6]|5(?:[236-8]|[45][2-69])|[68][2-7]|7[2-689]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|6[1-9]|7[2-8]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4[02-9]|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6(?:5[25]|60)))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1-$2-$3",["1|2(?:2[37]|5[5-9]|64|78|8[39]|91)|4(?:2[2689]|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93)","1|2(?:2[37]|5(?:[57]|[68]0|9[19])|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93[34])","1|2(?:2[37]|5(?:[57]|[68]0|9(?:17|99))|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93(?:31|4))"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{4})","$1-$2-$3",["2(?:[34]7|[56]9|74|9[14-79])|82|993"]
,"0$1"]
,[,"(\\d)(\\d{4})(\\d{4})","$1-$2-$3",["3|4(?:2[09]|7[01])|6[1-9]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1-$2-$3",["[2479][1-9]"]
,"0$1"]
]
,[,,"20\\d{8}",,,,,,,[10]
]
,,,[,,"00(?:37\\d{6,13}|66\\d{6,13}|777(?:[01]\\d{2}|5\\d{3}|8\\d{4})|882[1245]\\d{4})"]
,[,,"570\\d{6}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
]
,"KE":[,[,,"20\\d{6,7}|[4-9]\\d{6,9}",,,,,,,[7,8,9,10]
]
,[,,"20\\d{6,7}|4(?:0\\d{6,7}|[136]\\d{7}|[245]\\d{5,7})|5(?:[08]\\d{7}|[1-79]\\d{5,7})|6(?:[01457-9]\\d{5,7}|2\\d{7}|6\\d{6,7})",,,,,,,[7,8,9]
]
,[,,"7(?:[0-3679]\\d|4[0-46-9]|5[0-6]|8[0-25-9])\\d{6}",,,,,,,[9]
]
,[,,"800[24-8]\\d{5,6}",,,,,,,[9,10]
]
,[,,"900[02-9]\\d{5}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"KE",254,"000","0",,,"005|0",,,,[[,"(\\d{2})(\\d{5,7})","$1 $2",["[24-6]"]
,"0$1"]
,[,"(\\d{3})(\\d{6})","$1 $2",["7"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{3,4})","$1 $2 $3",["[89]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"KG":[,[,,"[235-8]\\d{8,9}",,,,,,,[9,10]
,[5,6]
]
,[,,"(?:3(?:1(?:[256]\\d|3[1-9]|47)|2(?:22|3[0-479]|6[0-7])|4(?:22|5[6-9]|6\\d)|5(?:22|3[4-7]|59|6\\d)|6(?:22|5[35-7]|6\\d)|7(?:22|3[468]|4[1-9]|59|[67]\\d)|9(?:22|4[1-8]|6\\d))|6(?:09|12|2[2-4])\\d)\\d{5}",,,,,,,[9]
,[5,6]
]
,[,,"(?:20[0-35]|5[0-24-7]\\d|7[07]\\d)\\d{6}",,,,,,,[9]
]
,[,,"800\\d{6,7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"KG",996,"00","0",,,"0",,,,[[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["[25-7]|31[25]"]
,"0$1"]
,[,"(\\d{4})(\\d{5})","$1 $2",["3(?:1[36]|[2-9])"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d)(\\d{3})","$1 $2 $3 $4",["8"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"KH":[,[,,"[1-9]\\d{7,9}",,,,,,,[8,9,10]
,[6,7]
]
,[,,"(?:2[3-6]|3[2-6]|4[2-4]|[5-7][2-5])(?:[237-9]|4[56]|5\\d|6\\d?)\\d{5}|23(?:4[234]|8\\d{2})\\d{4}",,,,,,,[8,9]
,[6,7]
]
,[,,"(?:1(?:[013-79]\\d|[28]\\d{1,2})|2[3-6]48|3(?:[18]\\d{2}|[2-6]48)|4[2-4]48|5[2-5]48|6(?:[016-9]\\d|[2-5]48)|7(?:[07-9]\\d|[16]\\d{2}|[2-5]48)|8(?:[013-79]\\d|8\\d{2})|9(?:6\\d{2}|7\\d{1,2}|[0-589]\\d))\\d{5}",,,,,,,[8,9]
]
,[,,"1800(?:1\\d|2[019])\\d{4}",,,,,,,[10]
]
,[,,"1900(?:1\\d|2[09])\\d{4}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"KH",855,"00[14-9]","0",,,"0",,,,[[,"(\\d{2})(\\d{3})(\\d{3,4})","$1 $2 $3",["1\\d[1-9]|[2-9]"]
,"0$1"]
,[,"(1[89]00)(\\d{3})(\\d{3})","$1 $2 $3",["1[89]0","1[89]00"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"KI":[,[,,"[2458]\\d{4}|3\\d{4,7}|[67]\\d{7}",,,,,,,[5,8]
]
,[,,"(?:[24]\\d|3[1-9]|50|8[0-5])\\d{3}|(?:65(?:02[12]|12[56]|22[89]|[3-5]00)|7(?:27\\d{2}|3100|5(?:02[12]|12[56]|22[89]|[34](?:00|81)|500)))\\d{3}"]
,[,,"(?:6(?:200[01]|30[01]\\d)|7(?:200[01]|3(?:0[0-5]\\d|140)))\\d{3}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"30(?:0[01]\\d{2}|12(?:11|20))\\d{2}",,,,,,,[8]
]
,"KI",686,"00",,,,"0",,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"KM":[,[,,"[3478]\\d{6}",,,,,,,[7]
]
,[,,"7[4-7]\\d{5}"]
,[,,"[34]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"8\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"KM",269,"00",,,,,,,,[[,"(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"KN":[,[,,"[589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"869(?:2(?:29|36)|302|4(?:6[015-9]|70))\\d{4}",,,,,,,,[7]
]
,[,,"869(?:5(?:5[6-8]|6[5-7])|66\\d|76[02-7])\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"KN",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"869",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"KP":[,[,,"1\\d{9}|[28]\\d{7}",,,,,,,[8,10]
,[6,7]
]
,[,,"2\\d{7}|85\\d{6}",,,,,,,[8]
,[6,7]
]
,[,,"19[123]\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"KP",850,"00|99","0",,,"0",,,,[[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["1"]
,"0$1"]
,[,"(\\d)(\\d{3})(\\d{4})","$1 $2 $3",["2"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["8"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"2(?:[0-24-9]\\d{2}|3(?:[0-79]\\d|8[02-9]))\\d{4}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"KR":[,[,,"00(?:3\\d{8,9}|7\\d{9,11})|[1-7]\\d{4,9}|8\\d{8}",,,,,,,[5,6,8,9,10,11,12,13,14]
,[3,7]
]
,[,,"2[1-9]\\d{6,7}|(?:3[1-3]|[46][1-4]|5[1-5])(?:1\\d{2,3}|[1-9]\\d{6,7})",,,,,,,[5,6,8,9,10]
,[3,7]
]
,[,,"1[0-26-9]\\d{7,8}",,,,,,,[9,10]
]
,[,,"(?:00(?:3(?:08|68\\d)|798\\d{1,3})|80\\d)\\d{6}",,,,,,,[9,11,12,13,14]
]
,[,,"60[2-9]\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,"50\\d{8}",,,,,,,[10]
]
,[,,"70\\d{8}",,,,,,,[10]
]
,"KR",82,"00(?:[1259]|3(?:[46]5|91)|7(?:00|27|3|55|6[126]))","0",,,"0(8[1-46-8]|85\\d{2})?",,,,[[,"(\\d{2})(\\d{3,4})","$1-$2",["(?:3[1-3]|[46][1-4]|5[1-5])1"]
,"0$1","0$CC-$1"]
,[,"(\\d{4})(\\d{4})","$1-$2",["1(?:5[246-9]|6[046-8]|8[03579])","1(?:5(?:22|44|66|77|88|99)|6(?:[07]0|44|6[16]|88)|8(?:00|33|55|77|99))"]
,"$1","0$CC-$1"]
,[,"(\\d{5})","$1",["1[016-9]1","1[016-9]11","1[016-9]114"]
,"0$1","0$CC-$1"]
,[,"(\\d)(\\d{3,4})(\\d{4})","$1-$2-$3",["2[1-9]"]
,"0$1","0$CC-$1"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1-$2-$3",["60[2-9]|80"]
,"0$1","0$CC-$1"]
,[,"(\\d{2})(\\d{3,4})(\\d{4})","$1-$2-$3",["1[0-25-9]|(?:3[1-3]|[46][1-4]|5[1-5])[1-9]"]
,"0$1","0$CC-$1"]
,[,"(\\d{2})(\\d{4})(\\d{4})","$1-$2-$3",["[57]0"]
,"0$1","0$CC-$1"]
,[,"(\\d{5})(\\d{3})(\\d{3})","$1 $2 $3",["003","0030","00308"]
,"$1","0$CC-$1"]
,[,"(\\d{5})(\\d{3,4})(\\d{4})","$1 $2 $3",["00[37]","00(?:36|79)","00(?:36|79)8"]
,"$1","0$CC-$1"]
,[,"(\\d{5})(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3 $4",["007","0079","00798"]
,"$1","0$CC-$1"]
]
,[[,"(\\d{2})(\\d{3,4})","$1-$2",["(?:3[1-3]|[46][1-4]|5[1-5])1"]
,"0$1","0$CC-$1"]
,[,"(\\d{4})(\\d{4})","$1-$2",["1(?:5[246-9]|6[046-8]|8[03579])","1(?:5(?:22|44|66|77|88|99)|6(?:[07]0|44|6[16]|88)|8(?:00|33|55|77|99))"]
,"$1","0$CC-$1"]
,[,"(\\d{5})","$1",["1[016-9]1","1[016-9]11","1[016-9]114"]
,"0$1","0$CC-$1"]
,[,"(\\d)(\\d{3,4})(\\d{4})","$1-$2-$3",["2[1-9]"]
,"0$1","0$CC-$1"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1-$2-$3",["60[2-9]|80"]
,"0$1","0$CC-$1"]
,[,"(\\d{2})(\\d{3,4})(\\d{4})","$1-$2-$3",["1[0-25-9]|(?:3[1-3]|[46][1-4]|5[1-5])[1-9]"]
,"0$1","0$CC-$1"]
,[,"(\\d{2})(\\d{4})(\\d{4})","$1-$2-$3",["[57]0"]
,"0$1","0$CC-$1"]
]
,[,,"15\\d{7,8}",,,,,,,[9,10]
]
,,,[,,"00(?:3(?:08|68\\d)|798\\d{1,3})\\d{6}",,,,,,,[11,12,13,14]
]
,[,,"1(?:5(?:22|44|66|77|88|99)|6(?:00|44|6[16]|70|88)|8(?:00|33|55|77|99))\\d{4}",,,,,,,[8]
]
,,,[,,,,,,,,,[-1]
]
]
,"KW":[,[,,"[12569]\\d{6,7}",,,,,,,[7,8]
]
,[,,"(?:18\\d|2(?:[23]\\d{2}|4(?:[1-35-9]\\d|44)|5(?:0[034]|[2-46]\\d|5[1-3]|7[1-7])))\\d{4}"]
,[,,"(?:5(?:[05]\\d{2}|1[0-7]\\d|2(?:22|5[25])|6[56]\\d)|6(?:0[034679]\\d|222|5[015-9]\\d|6\\d{2}|7(?:0[013-9]|[67]\\d)|9(?:[069]\\d|3[039]))|9(?:0[09]\\d|22\\d|4[01479]\\d|55\\d|6[0679]\\d|7(?:02|[1-9]\\d)|8[057-9]\\d|9\\d{2}))\\d{4}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"KW",965,"00",,,,,,,,[[,"(\\d{4})(\\d{3,4})","$1 $2",["[16]|2(?:[0-35-9]|4[0-35-9])|52[25]|9[024-9]"]
]
,[,"(\\d{3})(\\d{5})","$1 $2",["244|5(?:[015]|6[56])"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"KY":[,[,,"[3589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"345(?:2(?:22|44)|444|6(?:23|38|40)|7(?:4[35-79]|6[6-9]|77)|8(?:00|1[45]|25|[48]8)|9(?:14|4[035-9]))\\d{4}",,,,,,,,[7]
]
,[,,"345(?:32[1-9]|5(?:1[67]|2[5-79]|4[6-9]|50|76)|649|9(?:1[67]|2[2-9]|3[689]))\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}|345976\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"KY",1,"011","1",,,"1",,,,,,[,,"345849\\d{4}"]
,,"345",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"KZ":[,[,,"(?:33\\d|7\\d{2}|80[089])\\d{7}",,,,,,,[10]
]
,[,,"33622\\d{5}|7(?:1(?:0(?:[23]\\d|4[0-3]|59|63)|1(?:[23]\\d|4[0-79]|59)|2(?:[23]\\d|59)|3(?:2\\d|3[0-79]|4[0-35-9]|59)|4(?:[24]\\d|3[013-9]|5[1-9])|5(?:2\\d|3[1-9]|4[0-7]|59)|6(?:[234]\\d|5[19]|61)|72\\d|8(?:[27]\\d|3[1-46-9]|4[0-5]))|2(?:1(?:[23]\\d|4[46-9]|5[3469])|2(?:2\\d|3[0679]|46|5[12679])|3(?:[234]\\d|5[139])|4(?:2\\d|3[1235-9]|59)|5(?:[23]\\d|4[01246-8]|59|61)|6(?:2\\d|3[1-9]|4[0-4]|59)|7(?:[2379]\\d|40|5[279])|8(?:[23]\\d|4[0-3]|59)|9(?:2\\d|3[124578]|59)))\\d{5}"]
,[,,"7(?:0[012578]|47|6[02-4]|7[15-8]|85)\\d{7}"]
,[,,"800\\d{7}"]
,[,,"809\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,"808\\d{7}"]
,[,,"751\\d{7}"]
,"KZ",7,"810","8",,,"8",,"8~10",,,,[,,,,,,,,,[-1]
]
,,,[,,"751\\d{7}"]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"LA":[,[,,"[2-8]\\d{7,9}",,,,,,,[8,9,10]
,[6]
]
,[,,"(?:2[13]|3(?:0\\d|[14])|[5-7][14]|41|8[1468])\\d{6}",,,,,,,[8,9]
,[6]
]
,[,,"20(?:2[2389]|5[24-689]|7[6-8]|9[125-9])\\d{6}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"LA",856,"00","0",,,"0",,,,[[,"(20)(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3 $4",["20"]
,"0$1"]
,[,"([2-8]\\d)(\\d{3})(\\d{3})","$1 $2 $3",["2[13]|3[14]|[4-8]"]
,"0$1"]
,[,"(30)(\\d{2})(\\d{2})(\\d{3})","$1 $2 $3 $4",["30"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"LB":[,[,,"[13-9]\\d{6,7}",,,,,,,[7,8]
]
,[,,"(?:[14-6]\\d{2}|7(?:[2-57]\\d|62|8[0-7]|9[04-9])|8[02-9]\\d|9\\d{2})\\d{4}",,,,,,,[7]
]
,[,,"(?:3\\d|7(?:[01]\\d|6[013-9]|8[89]|9[1-3])|81\\d)\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,"9[01]\\d{6}",,,,,,,[8]
]
,[,,"80\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"LB",961,"00","0",,,"0",,,,[[,"(\\d)(\\d{3})(\\d{3})","$1 $2 $3",["[13-69]|7(?:[2-57]|62|8[0-7]|9[04-9])|8[02-9]"]
,"0$1"]
,[,"([7-9]\\d)(\\d{3})(\\d{3})","$1 $2 $3",["7(?:[01]|6[013-9]|8[89]|9[1-3])|[89][01]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"LC":[,[,,"[5789]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"758(?:4(?:30|5[0-9]|6[2-9]|8[0-2])|57[0-2]|638)\\d{4}",,,,,,,,[7]
]
,[,,"758(?:28[4-7]|384|4(?:6[01]|8[4-9])|5(?:1[89]|20|84)|7(?:1[2-9]|2\\d|3[01]))\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"LC",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"758",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"LI":[,[,,"6\\d{8}|[23789]\\d{6}",,,,,,,[7,9]
]
,[,,"(?:2(?:01|1[27]|3\\d|6[02-578]|96)|3(?:7[0135-7]|8[048]|9[0269]))\\d{4}",,,,,,,[7]
]
,[,,"6(?:5(?:09|1\\d|20)|6(?:0[0-6]|10|2[06-9]|39))\\d{5}|7(?:[37-9]\\d|42|56)\\d{4}"]
,[,,"80(?:02[28]|9\\d{2})\\d{2}",,,,,,,[7]
]
,[,,"90(?:02[258]|1(?:23|3[14])|66[136])\\d{2}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"LI",423,"00","0",,,"0|10(?:01|20|66)",,,,[[,"(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3",["[237-9]"]
]
,[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["6[56]"]
]
,[,"(69)(7\\d{2})(\\d{4})","$1 $2 $3",["697"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"870(?:28|87)\\d{2}",,,,,,,[7]
]
,,,[,,"697(?:42|56|[78]\\d)\\d{4}",,,,,,,[9]
]
]
,"LK":[,[,,"[1-9]\\d{8}",,,,,,,[9]
,[7]
]
,[,,"1(?:1[2-57]\\d{6}|973\\d{5})|(?:2[13-7]|3[1-8]|4[157]|5[12457]|6[35-7]|[89]1)[2-57]\\d{6}",,,,,,,,[7]
]
,[,,"7[0125-8]\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"LK",94,"00","0",,,"0",,,,[[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["[1-689]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["7"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"LR":[,[,,"2\\d{7,8}|[378]\\d{8}|4\\d{6}|5\\d{6,8}",,,,,,,[7,8,9]
]
,[,,"(?:2\\d{3}|33333)\\d{4}",,,,,,,[8,9]
]
,[,,"(?:20\\d{2}|330\\d|4[67]|5(?:55)?\\d|77\\d{2}|88\\d{2})\\d{5}",,,,,,,[7,9]
]
,[,,,,,,,,,[-1]
]
,[,,"332(?:02|[2-5]\\d)\\d{4}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"LR",231,"00","0",,,"0",,,,[[,"(2\\d)(\\d{3})(\\d{3})","$1 $2 $3",["2"]
,"0$1"]
,[,"([4-5])(\\d{3})(\\d{3})","$1 $2 $3",["[45]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["[23578]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"LS":[,[,,"[2568]\\d{7}",,,,,,,[8]
]
,[,,"2\\d{7}"]
,[,,"[56]\\d{7}"]
,[,,"800[256]\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"LS",266,"00",,,,,,,,[[,"(\\d{4})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"LT":[,[,,"[3-9]\\d{7}",,,,,,,[8]
]
,[,,"(?:3[1478]|4[124-6]|52)\\d{6}"]
,[,,"6\\d{7}"]
,[,,"800\\d{5}"]
,[,,"9(?:0[0239]|10)\\d{5}"]
,[,,"808\\d{5}"]
,[,,"700\\d{5}"]
,[,,,,,,,,,[-1]
]
,"LT",370,"00","8",,,"[08]",,,,[[,"([34]\\d)(\\d{6})","$1 $2",["37|4(?:1|5[45]|6[2-4])"]
,"(8-$1)",,1]
,[,"([3-6]\\d{2})(\\d{5})","$1 $2",["3[148]|4(?:[24]|6[09])|528|6"]
,"(8-$1)",,1]
,[,"([7-9]\\d{2})(\\d{2})(\\d{3})","$1 $2 $3",["[7-9]"]
,"8 $1",,1]
,[,"(5)(2\\d{2})(\\d{4})","$1 $2 $3",["52[0-79]"]
,"(8-$1)",,1]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"70[67]\\d{5}"]
,,,[,,,,,,,,,[-1]
]
]
,"LU":[,[,,"[24-9]\\d{3,10}|3(?:[0-46-9]\\d{2,9}|5[013-9]\\d{1,8})",,,,,,,[4,5,6,7,8,9,10,11]
]
,[,,"(?:2[2-9]\\d{2,9}|(?:3(?:[0-46-9]\\d|5[013-9])|[457]\\d{2}|8(?:0[2-9]|[13-9]\\d)|9(?:0[89]|[2-579]\\d))\\d{1,8})"]
,[,,"6[25-79][18]\\d{6}",,,,,,,[9]
]
,[,,"800\\d{5}",,,,,,,[8]
]
,[,,"90[015]\\d{5}",,,,,,,[8]
]
,[,,"801\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,"20(?:1\\d{5}|[2-689]\\d{1,7})",,,,,,,[4,5,6,7,8,9,10]
]
,"LU",352,"00",,,,"(15(?:0[06]|1[12]|35|4[04]|55|6[26]|77|88|99)\\d)",,,,[[,"(\\d{2})(\\d{3})","$1 $2",["[2-5]|7[1-9]|[89](?:0[2-9]|[1-9])"]
,,"$CC $1"]
,[,"(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3",["[2-5]|7[1-9]|[89](?:0[2-9]|[1-9])"]
,,"$CC $1"]
,[,"(\\d{2})(\\d{2})(\\d{3})","$1 $2 $3",["20"]
,,"$CC $1"]
,[,"(\\d{2})(\\d{2})(\\d{2})(\\d{1,2})","$1 $2 $3 $4",["2(?:[0367]|4[3-8])"]
,,"$CC $1"]
,[,"(\\d{2})(\\d{2})(\\d{2})(\\d{3})","$1 $2 $3 $4",["20"]
,,"$CC $1"]
,[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{1,2})","$1 $2 $3 $4 $5",["2(?:[0367]|4[3-8])"]
,,"$CC $1"]
,[,"(\\d{2})(\\d{2})(\\d{2})(\\d{1,4})","$1 $2 $3 $4",["2(?:[12589]|4[12])|[3-5]|7[1-9]|8(?:0[2-9]|[1-9])|9(?:0[2-46-9]|[1-9])"]
,,"$CC $1"]
,[,"(\\d{3})(\\d{2})(\\d{3})","$1 $2 $3",["70|80[01]|90[015]"]
,,"$CC $1"]
,[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["6"]
,,"$CC $1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"LV":[,[,,"[2689]\\d{7}",,,,,,,[8]
]
,[,,"6\\d{7}"]
,[,,"2\\d{7}"]
,[,,"80\\d{6}"]
,[,,"90\\d{6}"]
,[,,"81\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"LV",371,"00",,,,,,,,[[,"([2689]\\d)(\\d{3})(\\d{3})","$1 $2 $3",["[2689]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"LY":[,[,,"[25679]\\d{8}",,,,,,,[9]
,[7]
]
,[,,"(?:2[1345]|5[1347]|6[123479]|71)\\d{7}",,,,,,,,[7]
]
,[,,"9[1-6]\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"LY",218,"00","0",,,"0",,,,[[,"([25-79]\\d)(\\d{7})","$1-$2",["[25-79]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MA":[,[,,"[5-9]\\d{8}",,,,,,,[9]
]
,[,,"5(?:2(?:[015-79]\\d|2[02-9]|3[2-57]|4[2-8]|8[235-7])\\d|3(?:[0-48]\\d|[57][2-9]|6[2-8]|9[3-9])\\d|4[067]\\d{2}|5[03]\\d{2})\\d{4}"]
,[,,"(?:6(?:[0-79]\\d|8[0-247-9])|7(?:0[067]|6[1267]|7[07]))\\d{6}"]
,[,,"80\\d{7}"]
,[,,"89\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"5924[01]\\d{4}"]
,"MA",212,"00","0",,,"0",,,,[[,"([5-7]\\d{2})(\\d{6})","$1-$2",["5(?:2[015-7]|3[0-4])|[67]"]
,"0$1"]
,[,"([58]\\d{3})(\\d{5})","$1-$2",["5(?:2[2-489]|3[5-9]|92)|892","5(?:2(?:[2-48]|9[0-7])|3(?:[5-79]|8[0-7])|924)|892"]
,"0$1"]
,[,"(5\\d{4})(\\d{4})","$1-$2",["5(?:29|38)","5(?:29|38)[89]"]
,"0$1"]
,[,"([5]\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["5(?:4[067]|5[03])"]
,"0$1"]
,[,"(8[09])(\\d{7})","$1-$2",["8(?:0|9[013-9])"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,1,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MC":[,[,,"[34689]\\d{7,8}",,,,,,,[8,9]
]
,[,,"870\\d{5}|9[2-47-9]\\d{6}",,,,,,,[8]
]
,[,,"3\\d{7}|4(?:4\\d|5[1-9])\\d{5}|6\\d{8}"]
,[,,"90\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"MC",377,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[39]"]
,"$1"]
,[,"(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["4"]
,"0$1"]
,[,"(6)(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4 $5",["6"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{2})","$1 $2 $3",["8"]
,"$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"870\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MD":[,[,,"[235-9]\\d{7}",,,,,,,[8]
]
,[,,"(?:2[1-9]\\d|3[1-79]\\d|5(?:33|5[257]))\\d{5}"]
,[,,"(?:562|6\\d{2}|7(?:[189]\\d|6[07]|7[457-9]))\\d{5}"]
,[,,"800\\d{5}"]
,[,,"90[056]\\d{5}"]
,[,,"808\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,"3[08]\\d{6}"]
,"MD",373,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["22|3"]
,"0$1"]
,[,"([25-7]\\d{2})(\\d{2})(\\d{3})","$1 $2 $3",["2[13-9]|[5-7]"]
,"0$1"]
,[,"([89]\\d{2})(\\d{5})","$1 $2",["[89]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"803\\d{5}"]
,,,[,,,,,,,,,[-1]
]
]
,"ME":[,[,,"[2-9]\\d{7,8}",,,,,,,[8]
,[6]
]
,[,,"(?:20[2-8]|3(?:0[2-7]|[12][235-7]|3[24-7])|4(?:0[2-467]|1[267])|5(?:0[2467]|1[267]|2[2367]))\\d{5}",,,,,,,,[6]
]
,[,,"6(?:00\\d|3[024]\\d|6[0-25]\\d|[7-9]\\d{2})\\d{4}"]
,[,,"80[0-258]\\d{5}"]
,[,,"(?:9(?:4[1568]|5[178]))\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"78[1-49]\\d{5}"]
,"ME",382,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["[2-57-9]|6[036-9]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"77[1-9]\\d{5}"]
,,,[,,,,,,,,,[-1]
]
]
,"MF":[,[,,"[56]\\d{8}",,,,,,,[9]
]
,[,,"590(?:[02][79]|13|5[0-268]|[78]7)\\d{4}"]
,[,,"690(?:0[05-9]|[1-9]\\d)\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"MF",590,"00","0",,,"0",,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MG":[,[,,"[23]\\d{8}",,,,,,,[9]
,[7]
]
,[,,"20(?:2\\d{2}|4[47]\\d|5[3467]\\d|6[279]\\d|7(?:2[29]|[35]\\d)|8[268]\\d|9[245]\\d)\\d{4}",,,,,,,,[7]
]
,[,,"3[2-49]\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"22\\d{7}"]
,"MG",261,"00","0",,,"0",,,,[[,"([23]\\d)(\\d{2})(\\d{3})(\\d{2})","$1 $2 $3 $4",["[23]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MH":[,[,,"[2-6]\\d{6}",,,,,,,[7]
]
,[,,"(?:247|528|625)\\d{4}"]
,[,,"(?:235|329|45[56]|545)\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"635\\d{4}"]
,"MH",692,"011","1",,,"1",,,,[[,"(\\d{3})(\\d{4})","$1-$2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MK":[,[,,"[2-578]\\d{7}",,,,,,,[8]
,[6,7]
]
,[,,"(?:2(?:[23]\\d|5[124578]|6[01])|3(?:1[3-6]|[23][2-6]|4[2356])|4(?:[23][2-6]|4[3-6]|5[256]|6[25-8]|7[24-6]|8[4-6]))\\d{5}",,,,,,,,[6,7]
]
,[,,"7(?:[0-25-8]\\d{2}|32\\d|421|9[23]\\d)\\d{4}"]
,[,,"800\\d{5}"]
,[,,"5[02-9]\\d{6}"]
,[,,"8(?:0[1-9]|[1-9]\\d)\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"MK",389,"00","0",,,"0",,,,[[,"(2)(\\d{3})(\\d{4})","$1 $2 $3",["2"]
,"0$1"]
,[,"([347]\\d)(\\d{3})(\\d{3})","$1 $2 $3",["[347]"]
,"0$1"]
,[,"([58]\\d{2})(\\d)(\\d{2})(\\d{2})","$1 $2 $3 $4",["[58]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"ML":[,[,,"[246-9]\\d{7}",,,,,,,[8]
]
,[,,"(?:2(?:0(?:2\\d|7[0-8])|1(?:2[5-7]|[3-689]\\d))|44[1239]\\d)\\d{4}"]
,[,,"(?:2(?:079|17\\d)|[679]\\d{3}|8[239]\\d{2})\\d{4}"]
,[,,"80\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"ML",223,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[246-9]"]
]
,[,"(\\d{4})","$1",["67|74"]
]
]
,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[246-9]"]
]
]
,[,,,,,,,,,[-1]
]
,,,[,,"80\\d{6}"]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MM":[,[,,"[178]\\d{5,7}|[24-6]\\d{5,8}|9(?:[279]\\d{0,2}|5|[34]\\d{1,2}|6(?:\\d{1,2})?|8(?:\\d{2})?)\\d{6}",,,,,,,[6,7,8,9,10]
,[5]
]
,[,,"1(?:2\\d{1,2}|[35]\\d|4(?:\\d|2[236]|39)|6\\d?|[89][0-6]\\d)\\d{4}|2(?:2(?:000\\d{3}|\\d{4})|3\\d{4}|4(?:0\\d{5}|26\\d{4}|39\\d{4}|\\d{4})|5(?:1\\d{3,6}|[02-9]\\d{3,5})|[6-9]\\d{4})|4(?:2[245-8]|3(?:2(?:02)?|[346]|56?)|[46][2-6]|5[3-5])\\d{4}|5(?:2(?:2(?:\\d{1,2})?|[3-8])|3[2-68]|4(?:21?|[4-8])|5[23]|6[2-4]|7[2-8]|8[24-7]|9[2-7])\\d{4}|6(?:0[23]|1(?:2(?:0|4\\d)?|[356])|2[2-6]|3[24-6]|4(?:2(?:4\\d)?|[3-6])|5[2-4]|6[2-8]|7(?:[2367]|4(?:\\d|39)|5\\d?|8[145]\\d)|8[245]|9(?:20?|4))\\d{4}|7(?:[04][24-8]|1(?:20?|[3-7])|22|3[2-4]|5[2-7])\\d{4}|8(?:1(?:2\\d{1,2}|[3-689]\\d)|2(?:2\\d|3(?:\\d|20)|[4-8]\\d)|3[24]\\d|4[24-7]\\d|5[245]\\d|6[23]\\d)\\d{3}",,,,,,,[6,7,8,9]
,[5]
]
,[,,"17[01]\\d{4}|9(?:2(?:[0-4]|5\\d{2}|6[0-5]\\d)|3(?:[0-36]|4[069])\\d|4(?:0[0-4]\\d|[1379]\\d|2\\d{2}|4[0-589]\\d|5\\d{2}|88)|5[0-6]|6(?:1\\d|9\\d{2}|\\d)|7(?:3\\d|[6-9]\\d{2})|8(?:\\d|9\\d{2})|9(?:1\\d|[5-7]\\d{2}|[089]))\\d{5}",,,,,,,[7,8,9,10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"1333\\d{4}",,,,,,,[8]
]
,"MM",95,"00","0",,,"0",,,,[[,"(\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["1|2[245]"]
,"0$1"]
,[,"(2)(\\d{4})(\\d{4})","$1 $2 $3",["251"]
,"0$1"]
,[,"(\\d)(\\d{2})(\\d{3})","$1 $2 $3",["16|2"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{3,4})","$1 $2 $3",["432|67|81"]
,"0$1"]
,[,"(\\d{2})(\\d{2})(\\d{3,4})","$1 $2 $3",["[4-8]"]
,"0$1"]
,[,"(9)(\\d{3})(\\d{4,6})","$1 $2 $3",["9(?:2[0-4]|[35-9]|4[137-9])"]
,"0$1"]
,[,"(9)([34]\\d{4})(\\d{4})","$1 $2 $3",["9(?:3[0-36]|4[0-57-9])"]
,"0$1"]
,[,"(9)(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3 $4",["92[56]"]
,"0$1"]
,[,"(9)(\\d{3})(\\d{3})(\\d{2})","$1 $2 $3 $4",["93"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MN":[,[,,"[12]\\d{7,9}|[57-9]\\d{7}",,,,,,,[8,9,10]
,[6,7]
]
,[,,"[12](?:1\\d|2(?:[1-3]\\d?|7\\d)|3[2-8]\\d{1,2}|4[2-68]\\d{1,2}|5[1-4689]\\d{1,2})\\d{5}|5[0568]\\d{6}",,,,,,,,[6,7]
]
,[,,"(?:8(?:[05689]\\d|3[01])|9[013-9]\\d)\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"7[05-8]\\d{6}",,,,,,,[8]
]
,"MN",976,"001","0",,,"0",,,,[[,"([12]\\d)(\\d{2})(\\d{4})","$1 $2 $3",["[12]1"]
,"0$1"]
,[,"([12]2\\d)(\\d{5,6})","$1 $2",["[12]2[1-3]"]
,"0$1"]
,[,"([12]\\d{3})(\\d{5})","$1 $2",["[12](?:27|[3-5])","[12](?:27|[3-5]\\d)2"]
,"0$1"]
,[,"(\\d{4})(\\d{4})","$1 $2",["[57-9]"]
,"$1"]
,[,"([12]\\d{4})(\\d{4,5})","$1 $2",["[12](?:27|[3-5])","[12](?:27|[3-5]\\d)[4-9]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MO":[,[,,"[268]\\d{7}",,,,,,,[8]
]
,[,,"(?:28[2-57-9]|8(?:11|[2-57-9]\\d))\\d{5}"]
,[,,"6(?:[2356]\\d|8[158])\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"MO",853,"00",,,,,,,,[[,"([268]\\d{3})(\\d{4})","$1 $2",["[268]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MP":[,[,,"[5689]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"670(?:2(?:3[3-7]|56|8[5-8])|32[1238]|4(?:33|8[348])|5(?:32|55|88)|6(?:64|70|82)|78[3589]|8[3-9]8|989)\\d{4}",,,,,,,,[7]
]
,[,,"670(?:2(?:3[3-7]|56|8[5-8])|32[1238]|4(?:33|8[348])|5(?:32|55|88)|6(?:64|70|82)|78[3589]|8[3-9]8|989)\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"MP",1,"011","1",,,"1",,,1,,,[,,,,,,,,,[-1]
]
,,"670",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MQ":[,[,,"[56]\\d{8}",,,,,,,[9]
]
,[,,"596(?:0[2-5]|[12]0|3[05-9]|4[024-8]|[5-7]\\d|89|9[4-8])\\d{4}"]
,[,,"696(?:[0-47-9]\\d|5[0-6]|6[0-4])\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"MQ",596,"00","0",,,"0",,,,[[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MR":[,[,,"[2-48]\\d{7}",,,,,,,[8]
]
,[,,"25[08]\\d{5}|35\\d{6}|45[1-7]\\d{5}"]
,[,,"[234][0-46-9]\\d{6}"]
,[,,"800\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"MR",222,"00",,,,,,,,[[,"([2-48]\\d)(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[2-48]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MS":[,[,,"[5689]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"664491\\d{4}",,,,,,,,[7]
]
,[,,"66449[2-6]\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"MS",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"664",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MT":[,[,,"[2357-9]\\d{7}",,,,,,,[8]
]
,[,,"2(?:0(?:[169]\\d|3[1-4])|[1-357]\\d{2})\\d{4}"]
,[,,"(?:7(?:210|[79]\\d{2})|9(?:2(?:1[01]|31)|69[67]|8(?:1[1-3]|89|97)|9\\d{2}))\\d{4}"]
,[,,"800[3467]\\d{4}"]
,[,,"5(?:0(?:0(?:37|43)|6\\d{2}|70\\d|9[0168]\\d)|[12]\\d0[1-5])\\d{3}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"3550\\d{4}"]
,"MT",356,"00",,,,,,,,[[,"(\\d{4})(\\d{4})","$1 $2"]
]
,,[,,"7117\\d{4}"]
,,,[,,,,,,,,,[-1]
]
,[,,"501\\d{5}"]
,,,[,,,,,,,,,[-1]
]
]
,"MU":[,[,,"[2-9]\\d{6,7}",,,,,,,[7,8]
]
,[,,"(?:2(?:[03478]\\d|1[0-7]|6[1-69])|4(?:[013568]\\d|2[4-7])|5(?:44\\d|471)|6\\d{2}|8(?:14|3[129]))\\d{4}"]
,[,,"5(?:2[59]\\d|4(?:2[1-389]|4\\d|7[1-9]|9\\d)|7\\d{2}|8(?:[0-25689]\\d|4[3479]|7[15-8])|9[0-8]\\d)\\d{4}",,,,,,,[8]
]
,[,,"80[012]\\d{4}",,,,,,,[7]
]
,[,,"30\\d{5}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"3(?:20|9\\d)\\d{4}",,,,,,,[7]
]
,"MU",230,"0(?:0|[2-7]0|33)",,,,,,"020",,[[,"([2-46-9]\\d{2})(\\d{4})","$1 $2",["[2-46-9]"]
]
,[,"(5\\d{3})(\\d{4})","$1 $2",["5"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MV":[,[,,"[346-8]\\d{6,9}|9(?:00\\d{7}|\\d{6})",,,,,,,[7,10]
]
,[,,"(?:3(?:0[0-3]|3[0-59])|6(?:[57][02468]|6[024568]|8[024689]))\\d{4}",,,,,,,[7]
]
,[,,"(?:46[46]|7[2-9]\\d|9[15-9]\\d)\\d{4}",,,,,,,[7]
]
,[,,"800\\d{7}",,,,,,,[10]
]
,[,,"900\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"MV",960,"0(?:0|19)",,,,,,"00",,[[,"(\\d{3})(\\d{4})","$1-$2",["[3467]|9(?:0[1-9]|[1-9])"]
]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["[89]00"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"4[05]0\\d{4}",,,,,,,[7]
]
,,,[,,,,,,,,,[-1]
]
]
,"MW":[,[,,"(?:1(?:\\d{2})?|[2789]\\d{2})\\d{6}",,,,,,,[7,9]
]
,[,,"(?:1[2-9]|21\\d{2})\\d{5}"]
,[,,"(?:111|77\\d|88\\d|99\\d)\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"MW",265,"00","0",,,"0",,,,[[,"(\\d)(\\d{3})(\\d{3})","$1 $2 $3",["1"]
,"0$1"]
,[,"(2\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["2"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[17-9]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MX":[,[,,"[1-9]\\d{9,10}",,,,,,,[10,11]
,[7,8]
]
,[,,"(?:33|55|81)\\d{8}|(?:2(?:0[01]|2[1-9]|3[1-35-8]|4[13-9]|7[1-689]|8[1-578]|9[467])|3(?:1[1-79]|[2458][1-9]|7[1-8]|9[1-5])|4(?:1[1-57-9]|[24-6][1-9]|[37][1-8]|8[1-35-9]|9[2-689])|5(?:88|9[1-79])|6(?:1[2-68]|[234][1-9]|5[1-3689]|6[12457-9]|7[1-7]|8[67]|9[4-8])|7(?:[13467][1-9]|2[1-8]|5[13-9]|8[1-69]|9[17])|8(?:2[13-689]|3[1-6]|4[124-6]|6[1246-9]|7[1-378]|9[12479])|9(?:1[346-9]|2[1-4]|3[2-46-8]|5[1348]|[69][1-9]|7[12]|8[1-8]))\\d{7}",,,,,,,[10]
,[7,8]
]
,[,,"1(?:(?:33|55|81)\\d{8}|(?:2(?:2[1-9]|3[1-35-8]|4[13-9]|7[1-689]|8[1-578]|9[467])|3(?:1[1-79]|[2458][1-9]|7[1-8]|9[1-5])|4(?:1[1-57-9]|[24-6][1-9]|[37][1-8]|8[1-35-9]|9[2-689])|5(?:88|9[1-79])|6(?:1[2-68]|[2-4][1-9]|5[1-3689]|6[12457-9]|7[1-7]|8[67]|9[4-8])|7(?:[13467][1-9]|2[1-8]|5[13-9]|8[1-69]|9[17])|8(?:2[13-689]|3[1-6]|4[124-6]|6[1246-9]|7[1-378]|9[12479])|9(?:1[346-9]|2[1-4]|3[2-46-8]|5[1348]|[69][1-9]|7[12]|8[1-8]))\\d{7})",,,,,,,[11]
]
,[,,"8(?:00|88)\\d{7}",,,,,,,[10]
]
,[,,"900\\d{7}",,,,,,,[10]
]
,[,,"300\\d{7}",,,,,,,[10]
]
,[,,"500\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,"MX",52,"0[09]","01",,,"0[12]|04[45](\\d{10})","1$1",,,[[,"([358]\\d)(\\d{4})(\\d{4})","$1 $2 $3",["33|55|81"]
,"01 $1",,1]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["[2467]|3[0-2457-9]|5[089]|8[02-9]|9[0-35-9]"]
,"01 $1",,1]
,[,"(1)([358]\\d)(\\d{4})(\\d{4})","044 $2 $3 $4",["1(?:33|55|81)"]
,"$1",,1]
,[,"(1)(\\d{3})(\\d{3})(\\d{4})","044 $2 $3 $4",["1(?:[2467]|3[0-2457-9]|5[089]|8[2-9]|9[1-35-9])"]
,"$1",,1]
]
,[[,"([358]\\d)(\\d{4})(\\d{4})","$1 $2 $3",["33|55|81"]
,"01 $1",,1]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["[2467]|3[0-2457-9]|5[089]|8[02-9]|9[0-35-9]"]
,"01 $1",,1]
,[,"(1)([358]\\d)(\\d{4})(\\d{4})","$1 $2 $3 $4",["1(?:33|55|81)"]
]
,[,"(1)(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3 $4",["1(?:[2467]|3[0-2457-9]|5[089]|8[2-9]|9[1-35-9])"]
]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MY":[,[,,"[13-9]\\d{7,9}",,,,,,,[8,9,10]
,[6,7]
]
,[,,"(?:3[2-9]\\d|[4-9][2-9])\\d{6}",,,,,,,[8,9]
,[6,7]
]
,[,,"1(?:0(?:[23568]\\d|4[0-6]|7[016-9]|9[0-8])\\d|1(?:[1-5]\\d{2}|6(?:0[5-9]|[1-9]\\d))\\d|[23679][2-9]\\d{2}|4(?:[235-9]\\d{2}|400)|59\\d{3}|8(?:1[23]\\d|[236]\\d{2}|4(?:[06]\\d|7[0-4])\\d|5[7-9]\\d|7[016-9]\\d|8(?:[01]\\d|[27][0-4])|9[0-8]\\d))\\d{4}",,,,,,,[9,10]
]
,[,,"1[378]00\\d{6}",,,,,,,[10]
]
,[,,"1600\\d{6}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"154(?:6(?:0\\d|1[0-3])|8(?:[25]1|4[0189]|7[0-4679]))\\d{4}",,,,,,,[10]
]
,"MY",60,"00","0",,,"0",,,,[[,"([4-79])(\\d{3})(\\d{4})","$1-$2 $3",["[4-79]"]
,"0$1"]
,[,"(3)(\\d{4})(\\d{4})","$1-$2 $3",["3"]
,"0$1"]
,[,"([18]\\d)(\\d{3})(\\d{3,4})","$1-$2 $3",["1[02-46-9][1-9]|8"]
,"0$1"]
,[,"(1)([36-8]00)(\\d{2})(\\d{4})","$1-$2-$3-$4",["1[36-8]0","1[36-8]00"]
]
,[,"(11)(\\d{4})(\\d{4})","$1-$2 $3",["11"]
,"0$1"]
,[,"(15[49])(\\d{3})(\\d{4})","$1-$2 $3",["15[49]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"MZ":[,[,,"[28]\\d{7,8}",,,,,,,[8,9]
]
,[,,"2(?:[1346]\\d|5[0-2]|[78][12]|93)\\d{5}",,,,,,,[8]
]
,[,,"8[2-7]\\d{7}",,,,,,,[9]
]
,[,,"800\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"MZ",258,"00",,,,,,,,[[,"([28]\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["2|8[2-7]"]
]
,[,"(80\\d)(\\d{3})(\\d{3})","$1 $2 $3",["80"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"NA":[,[,,"[68]\\d{7,8}",,,,,,,[8,9]
]
,[,,"6(?:1(?:17|2(?:[0189]\\d|[2-6]|7\\d?)|3(?:[01378]|2\\d)|4(?:[024]|10?|3[15]?)|69|7[014])|2(?:17|5(?:[0-36-8]|4\\d?)|69|70)|3(?:17|2(?:[0237]\\d?|[14-689])|34|6[289]|7[01]|81)|4(?:17|2(?:[012]|7\\d?)|4(?:[06]|1\\d?)|5(?:[01357]|[25]\\d?)|69|7[01])|5(?:17|2(?:[0459]|[23678]\\d?)|69|7[01])|6(?:17|2(?:5|6\\d?)|38|42|69|7[01])|7(?:17|2(?:[569]|[234]\\d?)|3(?:0\\d?|[13])|6[89]|7[01]))\\d{4}"]
,[,,"(?:60|8[125])\\d{7}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,"8701\\d{5}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"8(?:3\\d{2}|86)\\d{5}"]
,"NA",264,"00","0",,,"0",,,,[[,"(8\\d)(\\d{3})(\\d{4})","$1 $2 $3",["8[1-35]"]
,"0$1"]
,[,"(6\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["6"]
,"0$1"]
,[,"(88)(\\d{3})(\\d{3})","$1 $2 $3",["88"]
,"0$1"]
,[,"(870)(\\d{3})(\\d{3})","$1 $2 $3",["870"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"NC":[,[,,"[2-57-9]\\d{5}",,,,,,,[6]
]
,[,,"(?:2[03-9]|3[0-5]|4[1-7]|88)\\d{4}"]
,[,,"(?:5[0-4]|[79]\\d|8[0-79])\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,"36\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"NC",687,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})","$1.$2.$3",["[2-46-9]|5[0-4]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"NE":[,[,,"[0289]\\d{7}",,,,,,,[8]
]
,[,,"2(?:0(?:20|3[1-7]|4[134]|5[14]|6[14578]|7[1-578])|1(?:4[145]|5[14]|6[14-68]|7[169]|88))\\d{4}"]
,[,,"(?:8[089]|9\\d)\\d{6}"]
,[,,"08\\d{6}"]
,[,,"09\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"NE",227,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["09|[289]"]
]
,[,"(08)(\\d{3})(\\d{3})","$1 $2 $3",["08"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"NF":[,[,,"[13]\\d{5}",,,,,,,[6]
,[5]
]
,[,,"(?:1(?:06|17|28|39)|3[012]\\d)\\d{3}",,,,,,,,[5]
]
,[,,"3[58]\\d{4}",,,,,,,,[5]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"NF",672,"00",,,,,,,,[[,"(\\d{2})(\\d{4})","$1 $2",["1"]
]
,[,"(\\d)(\\d{5})","$1 $2",["3"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"NG":[,[,,"[1-6]\\d{5,8}|9\\d{5,9}|[78]\\d{5,13}",,,,,,,[7,8,10,11,12,13,14]
,[5,6]
]
,[,,"[12]\\d{6,7}|9(?:0[3-9]|[1-9]\\d)\\d{5}|(?:3\\d|4[023568]|5[02368]|6[02-469]|7[4-69]|8[2-9])\\d{6}|(?:4[47]|5[14579]|6[1578]|7[0-357])\\d{5,6}|(?:78|41)\\d{5}",,,,,,,[7,8]
,[5,6]
]
,[,,"(?:1(?:7[34]\\d|8(?:04|[124579]\\d|8[0-3])|95\\d)|287[0-7]|3(?:18[1-8]|88[0-7]|9(?:8[5-9]|6[1-5]))|4(?:28[0-2]|6(?:7[1-9]|8[02-47])|88[0-2])|5(?:2(?:7[7-9]|8\\d)|38[1-79]|48[0-7]|68[4-7])|6(?:2(?:7[7-9]|8\\d)|4(?:3[7-9]|[68][129]|7[04-69]|9[1-8])|58[0-2]|98[7-9])|7(?:38[0-7]|69[1-8]|78[2-4])|8(?:28[3-9]|38[0-2]|4(?:2[12]|3[147-9]|5[346]|7[4-9]|8[014-689]|90)|58[1-8]|78[2-9]|88[5-7])|98[07]\\d)\\d{4}|(?:70(?:[1-689]\\d|7[0-3])|8(?:0(?:1[01]|[2-9]\\d)|1(?:[0-8]\\d|9[01]))|90[235-9]\\d)\\d{6}",,,,,,,[8,10]
]
,[,,"800\\d{7,11}",,,,,,,[10,11,12,13,14]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"NG",234,"009","0",,,"0",,,,[[,"(\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["[12]|9(?:0[3-9]|[1-9])"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{2,3})","$1 $2 $3",["[3-6]|7(?:0[1-9]|[1-79])|8[2-9]"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{3,4})","$1 $2 $3",["70|8[01]|90[235-9]"]
,"0$1"]
,[,"([78]00)(\\d{4})(\\d{4,5})","$1 $2 $3",["[78]00"]
,"0$1"]
,[,"([78]00)(\\d{5})(\\d{5,6})","$1 $2 $3",["[78]00"]
,"0$1"]
,[,"(78)(\\d{2})(\\d{3})","$1 $2 $3",["78"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"700\\d{7,11}",,,,,,,[10,11,12,13,14]
]
,,,[,,,,,,,,,[-1]
]
]
,"NI":[,[,,"[125-8]\\d{7}",,,,,,,[8]
]
,[,,"2\\d{7}"]
,[,,"(?:5(?:5[0-7]|[78]\\d)|6(?:20|3[035]|4[045]|5[05]|77|8[1-9]|9[059])|7[5-8]\\d|8\\d{2})\\d{5}"]
,[,,"1800\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"NI",505,"00",,,,,,,,[[,"(\\d{4})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"NL":[,[,,"1\\d{4,8}|[2-7]\\d{8}|[89]\\d{6,9}",,,,,,,[5,6,7,8,9,10]
]
,[,,"(?:1[0135-8]|2[02-69]|3[0-68]|4[0135-9]|[57]\\d|8[478])\\d{7}",,,,,,,[9]
]
,[,,"6[1-58]\\d{7}",,,,,,,[9]
]
,[,,"800\\d{4,7}",,,,,,,[7,8,9,10]
]
,[,,"90[069]\\d{4,7}",,,,,,,[7,8,9,10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"(?:6760|85\\d{2})\\d{5}",,,,,,,[9]
]
,"NL",31,"00","0",,,"0",,,,[[,"([1-578]\\d)(\\d{3})(\\d{4})","$1 $2 $3",["1[035]|2[0346]|3[03568]|4[0356]|5[0358]|7|8[4578]"]
,"0$1"]
,[,"([1-5]\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["1[16-8]|2[259]|3[124]|4[17-9]|5[124679]"]
,"0$1"]
,[,"(6)(\\d{8})","$1 $2",["6[0-57-9]"]
,"0$1"]
,[,"(66)(\\d{7})","$1 $2",["66"]
,"0$1"]
,[,"(14)(\\d{3,4})","$1 $2",["14"]
,"$1"]
,[,"([89]0\\d)(\\d{4,7})","$1 $2",["[89]0"]
,"0$1"]
]
,,[,,"66\\d{7}",,,,,,,[9]
]
,,,[,,"140(?:1(?:[035]|[16-8]\\d)|2(?:[0346]|[259]\\d)|3(?:[03568]|[124]\\d)|4(?:[0356]|[17-9]\\d)|5(?:[0358]|[124679]\\d)|7\\d|8[458])",,,,,,,[5,6]
]
,[,,"140(?:1(?:[035]|[16-8]\\d)|2(?:[0346]|[259]\\d)|3(?:[03568]|[124]\\d)|4(?:[0356]|[17-9]\\d)|5(?:[0358]|[124679]\\d)|7\\d|8[458])",,,,,,,[5,6]
]
,,,[,,,,,,,,,[-1]
]
]
,"NO":[,[,,"0\\d{4}|[2-9]\\d{7}",,,,,,,[5,8]
]
,[,,"(?:2[1-4]|3[1-3578]|5[1-35-7]|6[1-4679]|7[0-8])\\d{6}",,,,,,,[8]
]
,[,,"(?:4[015-8]|5[89]|87|9\\d)\\d{6}",,,,,,,[8]
]
,[,,"80[01]\\d{5}",,,,,,,[8]
]
,[,,"82[09]\\d{5}",,,,,,,[8]
]
,[,,"810(?:0[0-6]|[2-8]\\d)\\d{3}",,,,,,,[8]
]
,[,,"880\\d{5}",,,,,,,[8]
]
,[,,"85[0-5]\\d{5}",,,,,,,[8]
]
,"NO",47,"00",,,,,,,,[[,"([489]\\d{2})(\\d{2})(\\d{3})","$1 $2 $3",["[489]"]
]
,[,"([235-7]\\d)(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[235-7]"]
]
]
,,[,,,,,,,,,[-1]
]
,1,,[,,,,,,,,,[-1]
]
,[,,"0\\d{4}|81(?:0(?:0[7-9]|1\\d)|5\\d{2})\\d{3}"]
,,,[,,"81[23]\\d{5}",,,,,,,[8]
]
]
,"NP":[,[,,"[1-8]\\d{7}|9(?:[1-69]\\d{6,8}|7[2-6]\\d{5,7}|8\\d{8})",,,,,,,[8,10]
,[6,7]
]
,[,,"(?:1[0-6]\\d|2[13-79][2-6]|3[135-8][2-6]|4[146-9][2-6]|5[135-7][2-6]|6[13-9][2-6]|7[15-9][2-6]|8[1-46-9][2-6]|9[1-79][2-6])\\d{5}",,,,,,,[8]
,[6,7]
]
,[,,"9(?:6[013]|7[245]|8[0-24-6])\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"NP",977,"00","0",,,"0",,,,[[,"(1)(\\d{7})","$1-$2",["1[2-6]"]
,"0$1"]
,[,"(\\d{2})(\\d{6})","$1-$2",["1[01]|[2-8]|9(?:[1-69]|7[15-9])"]
,"0$1"]
,[,"(9\\d{2})(\\d{7})","$1-$2",["9(?:6[013]|7[245]|8)"]
,"$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"NR":[,[,,"[458]\\d{6}",,,,,,,[7]
]
,[,,"(?:444|888)\\d{4}"]
,[,,"55[4-9]\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"NR",674,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"NU":[,[,,"[1-5]\\d{3}",,,,,,,[4]
]
,[,,"[34]\\d{3}"]
,[,,"[125]\\d{3}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"NU",683,"00",,,,,,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"NZ":[,[,,"6[235-9]\\d{6}|[2-57-9]\\d{7,9}",,,,,,,[8,9,10]
,[7]
]
,[,,"(?:3[2-79]|[49][2-9]|6[235-9]|7[2-57-9])\\d{6}|24099\\d{3}",,,,,,,[8]
,[7]
]
,[,,"2(?:[028]\\d{7,8}|1(?:[03]\\d{5,7}|[12457]\\d{5,6}|[689]\\d{5})|[79]\\d{7})"]
,[,,"508\\d{6,7}|80\\d{6,8}"]
,[,,"90\\d{6,7}",,,,,,,[8,9]
]
,[,,,,,,,,,[-1]
]
,[,,"70\\d{7}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,"NZ",64,"0(?:0|161)","0",,,"0",,"00",,[[,"(\\d)(\\d{3})(\\d{4})","$1-$2 $3",["240|[346]|7[2-57-9]|9[1-9]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["21"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{3,5})","$1 $2 $3",["2(?:1[1-9]|[69]|7[0-35-9])|70|86"]
,"0$1"]
,[,"(2\\d)(\\d{3,4})(\\d{4})","$1 $2 $3",["2[028]"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{3})","$1 $2 $3",["90"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{3,4})","$1 $2 $3",["2(?:10|74)|5|[89]0"]
,"0$1"]
]
,,[,,"[28]6\\d{6,7}",,,,,,,[8,9]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"OM":[,[,,"(?:5|[279]\\d)\\d{6}|800\\d{5,6}",,,,,,,[7,8,9]
]
,[,,"2[2-6]\\d{6}",,,,,,,[8]
]
,[,,"7[19]\\d{6}|9(?:0[1-9]|[1-9]\\d)\\d{5}",,,,,,,[8]
]
,[,,"8007\\d{4,5}|500\\d{4}"]
,[,,"900\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"OM",968,"00",,,,,,,,[[,"(2\\d)(\\d{6})","$1 $2",["2"]
]
,[,"([79]\\d{3})(\\d{4})","$1 $2",["[79]"]
]
,[,"([58]00)(\\d{4,6})","$1 $2",["[58]00"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"PA":[,[,,"[1-9]\\d{6,7}",,,,,,,[7,8]
]
,[,,"(?:1(?:0[0-8]|1[49]|2[37]|3[0137]|4[147]|5[05]|6[58]|7[0167]|8[58]|9[139])|2(?:[0235679]\\d|1[0-7]|4[04-9]|8[028])|3(?:[09]\\d|1[014-7]|2[0-3]|3[03]|4[03-57]|55|6[068]|7[06-8]|8[06-9])|4(?:3[013-69]|4\\d|7[0-589])|5(?:[01]\\d|2[0-7]|[56]0|79)|7(?:0[09]|2[0-267]|3[06]|[469]0|5[06-9]|7[0-24-79]|8[7-9])|8(?:09|[34]\\d|5[0134]|8[02])|9(?:0[6-9]|1[016-8]|2[036-8]|3[3679]|40|5[0489]|6[06-9]|7[046-9]|8[36-8]|9[1-9]))\\d{4}",,,,,,,[7]
]
,[,,"(?:1[16]1|21[89]|8(?:1[01]|7[23]))\\d{4}|6(?:[024-9]\\d|1[0-5]|3[0-24-9])\\d{5}"]
,[,,"800\\d{4}",,,,,,,[7]
]
,[,,"(?:8(?:55|60|7[78])|9(?:00|81))\\d{4}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"PA",507,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1-$2",["[1-57-9]"]
]
,[,"(\\d{4})(\\d{4})","$1-$2",["6"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"PE":[,[,,"[14-9]\\d{7,8}",,,,,,,[8,9]
,[6,7]
]
,[,,"(?:1\\d|4[1-4]|5[1-46]|6[1-7]|7[2-46]|8[2-4])\\d{6}",,,,,,,[8]
,[6,7]
]
,[,,"9\\d{8}",,,,,,,[9]
]
,[,,"800\\d{5}",,,,,,,[8]
]
,[,,"805\\d{5}",,,,,,,[8]
]
,[,,"801\\d{5}",,,,,,,[8]
]
,[,,"80[24]\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,"PE",51,"19(?:1[124]|77|90)00","0"," Anexo ",,"0",,,,[[,"(1)(\\d{7})","$1 $2",["1"]
,"(0$1)"]
,[,"([4-8]\\d)(\\d{6})","$1 $2",["[4-7]|8[2-4]"]
,"(0$1)"]
,[,"(\\d{3})(\\d{5})","$1 $2",["80"]
,"(0$1)"]
,[,"(9\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["9"]
,"$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"PF":[,[,,"4\\d{5,7}|8\\d{7}",,,,,,,[6,8]
]
,[,,"4(?:[09][45689]\\d|4)\\d{4}"]
,[,,"8[79]\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"PF",689,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["4[09]|8[79]"]
]
,[,"(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3",["44"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"44\\d{4}",,,,,,,[6]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"PG":[,[,,"[1-9]\\d{6,7}",,,,,,,[7,8]
]
,[,,"(?:3[0-2]\\d|4[257]\\d|5[34]\\d|64[1-9]|77(?:[0-24]\\d|30)|85[02-46-9]|9[78]\\d)\\d{4}",,,,,,,[7]
]
,[,,"7(?:[0-689]\\d|75)\\d{5}",,,,,,,[8]
]
,[,,"180\\d{4}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"2(?:0[0-47]|7[568])\\d{4}",,,,,,,[7]
]
,"PG",675,"140[1-3]|00",,,,,,"00",,[[,"(\\d{3})(\\d{4})","$1 $2",["[13-689]|27"]
]
,[,"(\\d{4})(\\d{4})","$1 $2",["20|7"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"PH":[,[,,"1\\d{10,12}|2\\d{5,7}|[3-7]\\d{8}|8\\d{7,9}|9\\d{9}",,,,,,,[6,8,9,10,11,12,13]
,[5,7]
]
,[,,"2\\d{5}(?:\\d{2})?|(?:3[2-68]|4[2-9]|5[2-6]|6[2-58]|7[24578]|8[2-8])\\d{7}|88(?:22\\d{6}|42\\d{4})",,,,,,,[6,8,9,10]
,[5,7]
]
,[,,"(?:81[37]|9(?:0[5-9]|1[024-9]|2[0-35-9]|3[02-9]|4[235-9]|5[056]|6[5-7]|7[34-79]|89|9[4-9]))\\d{7}",,,,,,,[10]
]
,[,,"1800\\d{7,9}",,,,,,,[11,12,13]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"PH",63,"00","0",,,"0",,,,[[,"(2)(\\d{3})(\\d{4})","$1 $2 $3",["2"]
,"(0$1)"]
,[,"(2)(\\d{5})","$1 $2",["2"]
,"(0$1)"]
,[,"(\\d{4})(\\d{4,6})","$1 $2",["3(?:23|39|46)|4(?:2[3-6]|[35]9|4[26]|76)|5(?:22|44)|642|8(?:62|8[245])","3(?:230|397|461)|4(?:2(?:35|[46]4|51)|396|4(?:22|63)|59[347]|76[15])|5(?:221|446)|642[23]|8(?:622|8(?:[24]2|5[13]))"]
,"(0$1)"]
,[,"(\\d{5})(\\d{4})","$1 $2",["346|4(?:27|9[35])|883","3469|4(?:279|9(?:30|56))|8834"]
,"(0$1)"]
,[,"([3-8]\\d)(\\d{3})(\\d{4})","$1 $2 $3",["[3-8]"]
,"(0$1)"]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["81|9"]
,"0$1"]
,[,"(1800)(\\d{3})(\\d{4})","$1 $2 $3",["180","1800"]
]
,[,"(1800)(\\d{1,2})(\\d{3})(\\d{4})","$1 $2 $3 $4",["180","1800"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"PK":[,[,,"1\\d{8}|[2-8]\\d{5,11}|9(?:[013-9]\\d{4,10}|2\\d(?:111\\d{6}|\\d{3,7}))",,,,,,,[8,9,10,11,12]
,[6,7]
]
,[,,"(?:21|42)[2-9]\\d{7}|(?:2[25]|4[0146-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91)[2-9]\\d{6}|(?:2(?:3[2358]|4[2-4]|9[2-8])|45[3479]|54[2-467]|60[468]|72[236]|8(?:2[2-689]|3[23578]|4[3478]|5[2356])|9(?:2[2-8]|3[27-9]|4[2-6]|6[3569]|9[25-8]))[2-9]\\d{5,6}|58[126]\\d{7}",,,,,,,[9,10]
,[6,7,8]
]
,[,,"3(?:[014]\\d|2[0-5]|3[0-7]|55|64)\\d{7}",,,,,,,[10]
]
,[,,"800\\d{5}",,,,,,,[8]
]
,[,,"900\\d{5}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,"122\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,"PK",92,"00","0",,,"0",,,,[[,"([89]00)(\\d{3})(\\d{2})","$1 $2 $3",["[89]00"]
,"0$1"]
,[,"(1\\d{3})(\\d{5})","$1 $2",["1"]
,"$1"]
,[,"(\\d{2})(\\d{7,8})","$1 $2",["(?:2[125]|4[0-246-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91)[2-9]"]
,"(0$1)"]
,[,"(\\d{3})(\\d{6,7})","$1 $2",["2[349]|45|54|60|72|8[2-5]|9[2-469]","(?:2[349]|45|54|60|72|8[2-5]|9[2-469])\\d[2-9]"]
,"(0$1)"]
,[,"(58\\d{3})(\\d{5})","$1 $2",["58[126]"]
,"(0$1)"]
,[,"(3\\d{2})(\\d{7})","$1 $2",["3"]
,"0$1"]
,[,"(\\d{2})(111)(\\d{3})(\\d{3})","$1 $2 $3 $4",["(?:2[125]|4[0-246-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91)1","(?:2[125]|4[0-246-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91)11","(?:2[125]|4[0-246-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91)111"]
,"(0$1)"]
,[,"(\\d{3})(111)(\\d{3})(\\d{3})","$1 $2 $3 $4",["2[349]|45|54|60|72|8[2-5]|9[2-9]","(?:2[349]|45|54|60|72|8[2-5]|9[2-9])\\d1","(?:2[349]|45|54|60|72|8[2-5]|9[2-9])\\d11","(?:2[349]|45|54|60|72|8[2-5]|9[2-9])\\d111"]
,"(0$1)"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"(?:2(?:[125]|3[2358]|4[2-4]|9[2-8])|4(?:[0-246-9]|5[3479])|5(?:[1-35-7]|4[2-467])|6(?:[1-8]|0[468])|7(?:[14]|2[236])|8(?:[16]|2[2-689]|3[23578]|4[3478]|5[2356])|9(?:1|22|3[27-9]|4[2-6]|6[3569]|9[2-7]))111\\d{6}",,,,,,,[11,12]
]
,,,[,,,,,,,,,[-1]
]
]
,"PL":[,[,,"[1-57-9]\\d{6,8}|6\\d{5,8}",,,,,,,[6,7,8,9]
]
,[,,"(?:1[2-8]|2[2-69]|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145])(?:\\d{7}|19\\d{3})",,,,,,,[7,9]
]
,[,,"(?:45|5[0137]|6[069]|7[2389]|88)\\d{7}",,,,,,,[9]
]
,[,,"800\\d{6}",,,,,,,[9]
]
,[,,"70[01346-8]\\d{6}",,,,,,,[9]
]
,[,,"801\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,"39\\d{7}",,,,,,,[9]
]
,"PL",48,"00",,,,,,,,[[,"(\\d{3})(\\d{3})","$1 $2",["11[68]|64"]
]
,[,"(\\d{5})","$1",["19"]
]
,[,"(\\d{2})(\\d{2})(\\d{3})","$1 $2 $3",["1[2-8]|2[2-69]|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145]"]
]
,[,"(\\d{3})(\\d{2})(\\d{2,3})","$1 $2 $3",["64"]
]
,[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["26|39|45|5[0137]|6[0469]|7[02389]|8[08]"]
]
,[,"(\\d{2})(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[14]|2[0-57-9]|3[2-4]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145]"]
]
]
,,[,,"64\\d{4,7}"]
,,,[,,,,,,,,,[-1]
]
,[,,"804\\d{6}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
]
,"PM":[,[,,"[45]\\d{5}",,,,,,,[6]
]
,[,,"41\\d{4}"]
,[,,"(?:40|55)\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"PM",508,"00","0",,,"0",,,,[[,"([45]\\d)(\\d{2})(\\d{2})","$1 $2 $3",["[45]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"PR":[,[,,"[5789]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"(?:787|939)[2-9]\\d{6}",,,,,,,,[7]
]
,[,,"(?:787|939)[2-9]\\d{6}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"PR",1,"011","1",,,"1",,,1,,,[,,,,,,,,,[-1]
]
,,"787|939",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"PS":[,[,,"1\\d{9}|[24589]\\d{7,8}",,,,,,,[8,9,10]
,[7]
]
,[,,"(?:22[234789]|42[45]|82[01458]|92[369])\\d{5}",,,,,,,[8]
,[7]
]
,[,,"5[69]\\d{7}",,,,,,,[9]
]
,[,,"1800\\d{6}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,"1700\\d{6}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"PS",970,"00","0",,,"0",,,,[[,"([2489])(2\\d{2})(\\d{4})","$1 $2 $3",["[2489]2"]
,"0$1"]
,[,"(5[69]\\d)(\\d{3})(\\d{3})","$1 $2 $3",["5[69]"]
,"0$1"]
,[,"(1[78]00)(\\d{3})(\\d{3})","$1 $2 $3",["1[78]0","1[78]00"]
,"$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"PT":[,[,,"[2-46-9]\\d{8}",,,,,,,[9]
]
,[,,"2(?:[12]\\d|[35][1-689]|4[1-59]|6[1-35689]|7[1-9]|8[1-69]|9[1256])\\d{6}"]
,[,,"9(?:[1236]\\d{2}|480)\\d{5}"]
,[,,"80[02]\\d{6}"]
,[,,"6(?:0[178]|4[68])\\d{6}|76(?:0[1-57]|1[2-47]|2[237])\\d{5}"]
,[,,"80(?:8\\d|9[1579])\\d{5}"]
,[,,"884[0-4689]\\d{5}"]
,[,,"30\\d{7}"]
,"PT",351,"00",,,,,,,,[[,"(2\\d)(\\d{3})(\\d{4})","$1 $2 $3",["2[12]"]
]
,[,"([2-46-9]\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["2[3-9]|[346-9]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"7(?:0(?:7\\d|8[17]))\\d{5}"]
,,,[,,"600\\d{6}"]
]
,"PW":[,[,,"[2-8]\\d{6}",,,,,,,[7]
]
,[,,"2552255|(?:277|345|488|5(?:35|44|87)|6(?:22|54|79)|7(?:33|47)|8(?:24|55|76))\\d{4}"]
,[,,"(?:6[234689]0|77[45789])\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"PW",680,"01[12]",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"PY":[,[,,"5[0-5]\\d{4,7}|[2-46-9]\\d{5,8}",,,,,,,[6,7,8,9]
,[5]
]
,[,,"(?:[26]1|3[289]|4[124678]|7[123]|8[1236])\\d{5,7}|(?:2(?:2[4568]|7[15]|9[1-5])|3(?:18|3[167]|4[2357]|51)|4(?:18|2[45]|3[12]|5[13]|64|71|9[1-47])|5(?:[1-4]\\d|5[0234])|6(?:3[1-3]|44|7[1-4678])|7(?:17|4[0-4]|6[1-578]|75|8[0-8])|858)\\d{5,6}",,,,,,,[7,8,9]
,[5,6]
]
,[,,"9(?:6[12]|[78][1-6]|9[1-5])\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"8700[0-4]\\d{4}",,,,,,,[9]
]
,"PY",595,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{5})","$1 $2",["[26]1|3[289]|4[1246-8]|7[1-3]|8[1-36]"]
,"(0$1)"]
,[,"(\\d{2})(\\d{3})(\\d{3,4})","$1 $2 $3",["[26]1|3[289]|4[1246-8]|7[1-3]|8[1-36]"]
,"(0$1)"]
,[,"(\\d{3})(\\d{3,6})","$1 $2",["[2-9]0"]
,"0$1"]
,[,"(\\d{3})(\\d{6})","$1 $2",["9[1-9]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["870","8700"]
]
,[,"(\\d{3})(\\d{4,5})","$1 $2",["[2-8][1-9]"]
,"(0$1)"]
,[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["[2-8][1-9]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"[2-9]0\\d{4,7}"]
,,,[,,,,,,,,,[-1]
]
]
,"QA":[,[,,"[2-8]\\d{6,7}",,,,,,,[7,8]
]
,[,,"4[04]\\d{6}",,,,,,,[8]
]
,[,,"[3567]\\d{7}",,,,,,,[8]
]
,[,,"800\\d{4}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"QA",974,"00",,,,,,,,[[,"([28]\\d{2})(\\d{4})","$1 $2",["[28]"]
]
,[,"([3-7]\\d{3})(\\d{4})","$1 $2",["[3-7]"]
]
]
,,[,,"2(?:[12]\\d|61)\\d{4}",,,,,,,[7]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"RE":[,[,,"[268]\\d{8}",,,,,,,[9]
]
,[,,"262\\d{6}"]
,[,,"69(?:2\\d{2}|3(?:0[0-46]|1[013]|2[0-2]|3[039]|4[0-7]|5[05]|6[06]|7[07]|8[0-38]|9[0-479]))\\d{4}"]
,[,,"80\\d{7}"]
,[,,"89[1-37-9]\\d{6}"]
,[,,"8(?:1[019]|2[0156]|84|90)\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"RE",262,"00","0",,,"0",,,,[[,"([268]\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[268]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,1,"262|69|8",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"RO":[,[,,"[23]\\d{5,8}|[7-9]\\d{8}",,,,,,,[6,9]
]
,[,,"2(?:1(?:\\d{7}|9\\d{3})|[3-6](?:\\d{7}|\\d9\\d{2}))|3(?:1\\d{4}(?:\\d{3})?|[3-6]\\d{7})"]
,[,,"7(?:[0-8]\\d{2}|99\\d)\\d{5}",,,,,,,[9]
]
,[,,"800\\d{6}",,,,,,,[9]
]
,[,,"90[036]\\d{6}",,,,,,,[9]
]
,[,,"801\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"RO",40,"00","0"," int ",,"0",,,,[[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["[23]1"]
,"0$1"]
,[,"(\\d{2})(\\d{4})","$1 $2",["[23]1"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["[23][3-7]|[7-9]"]
,"0$1"]
,[,"(2\\d{2})(\\d{3})","$1 $2",["2[3-6]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"37\\d{7}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
]
,"RS":[,[,,"[126-9]\\d{4,11}|3(?:[0-79]\\d{3,10}|8[2-9]\\d{2,9})",,,,,,,[6,7,8,9,10,11,12]
,[5]
]
,[,,"(?:1(?:[02-9][2-9]|1[1-9])\\d|2(?:[0-24-7][2-9]\\d|[389](?:0[2-9]|[2-9]\\d))|3(?:[0-8][2-9]\\d|9(?:[2-9]\\d|0[2-9])))\\d{3,8}",,,,,,,[7,8,9,10,11,12]
,[5,6]
]
,[,,"6(?:[0-689]|7\\d)\\d{6,7}",,,,,,,[8,9,10]
]
,[,,"800\\d{3,9}"]
,[,,"(?:90[0169]|78\\d)\\d{3,7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"RS",381,"00","0",,,"0",,,,[[,"([23]\\d{2})(\\d{4,9})","$1 $2",["(?:2[389]|39)0"]
,"0$1"]
,[,"([1-3]\\d)(\\d{5,10})","$1 $2",["1|2(?:[0-24-7]|[389][1-9])|3(?:[0-8]|9[1-9])"]
,"0$1"]
,[,"(6\\d)(\\d{6,8})","$1 $2",["6"]
,"0$1"]
,[,"([89]\\d{2})(\\d{3,9})","$1 $2",["[89]"]
,"0$1"]
,[,"(7[26])(\\d{4,9})","$1 $2",["7[26]"]
,"0$1"]
,[,"(7[08]\\d)(\\d{4,9})","$1 $2",["7[08]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"7[06]\\d{4,10}"]
,,,[,,,,,,,,,[-1]
]
]
,"RU":[,[,,"[347-9]\\d{9}",,,,,,,[10]
]
,[,,"(?:3(?:0[12]|4[1-35-79]|5[1-3]|65|8[1-58]|9[0145])|4(?:01|1[1356]|2[13467]|7[1-5]|8[1-7]|9[1-689])|8(?:1[1-8]|2[01]|3[13-6]|4[0-8]|5[15]|6[1-35-79]|7[1-37-9]))\\d{7}"]
,[,,"9\\d{9}"]
,[,,"80[04]\\d{7}"]
,[,,"80[39]\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,"808\\d{7}"]
,[,,,,,,,,,[-1]
]
,"RU",7,"810","8",,,"8",,"8~10",,[[,"(\\d{3})(\\d{2})(\\d{2})","$1-$2-$3",["[1-79]"]
,"$1",,1]
,[,"([3489]\\d{2})(\\d{3})(\\d{2})(\\d{2})","$1 $2-$3-$4",["[3489]"]
,"8 ($1)",,1]
,[,"(7\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["7"]
,"8 ($1)",,1]
]
,[[,"([3489]\\d{2})(\\d{3})(\\d{2})(\\d{2})","$1 $2-$3-$4",["[3489]"]
,"8 ($1)",,1]
,[,"(7\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["7"]
,"8 ($1)",,1]
]
,[,,,,,,,,,[-1]
]
,1,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"RW":[,[,,"[027-9]\\d{7,8}",,,,,,,[8,9]
]
,[,,"2[258]\\d{7}|06\\d{6}"]
,[,,"7[238]\\d{7}",,,,,,,[9]
]
,[,,"800\\d{6}",,,,,,,[9]
]
,[,,"900\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"RW",250,"00","0",,,"0",,,,[[,"(2\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["2"]
]
,[,"([7-9]\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["[7-9]"]
,"0$1"]
,[,"(0\\d)(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["0"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SA":[,[,,"1\\d{7,8}|(?:[2-467]|92)\\d{7}|5\\d{8}|8\\d{9}",,,,,,,[8,9,10]
,[7]
]
,[,,"11\\d{7}|1?(?:2[24-8]|3[35-8]|4[3-68]|6[2-5]|7[235-7])\\d{6}",,,,,,,[8,9]
,[7]
]
,[,,"(?:5(?:[013-689]\\d|7[0-36-8])|811\\d)\\d{6}",,,,,,,[9,10]
]
,[,,"800\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,"92[05]\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"SA",966,"00","0",,,"0",,,,[[,"([1-467])(\\d{3})(\\d{4})","$1 $2 $3",["[1-467]"]
,"0$1"]
,[,"(1\\d)(\\d{3})(\\d{4})","$1 $2 $3",["1[1-467]"]
,"0$1"]
,[,"(5\\d)(\\d{3})(\\d{4})","$1 $2 $3",["5"]
,"0$1"]
,[,"(92\\d{2})(\\d{5})","$1 $2",["92"]
,"$1"]
,[,"(800)(\\d{3})(\\d{4})","$1 $2 $3",["800"]
,"$1"]
,[,"(811)(\\d{3})(\\d{3,4})","$1 $2 $3",["811"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SB":[,[,,"[1-9]\\d{4,6}",,,,,,,[5,7]
]
,[,,"(?:1[4-79]|[23]\\d|4[0-2]|5[03]|6[0-37])\\d{3}",,,,,,,[5]
]
,[,,"48\\d{3}|7(?:30|[46-8]\\d|5[025-9]|9[0-5])\\d{4}|8[4-9]\\d{5}|9(?:1[2-9]|2[013-9]|3[0-2]|[46]\\d|5[0-46-9]|7[0-689]|8[0-79]|9[0-8])\\d{4}"]
,[,,"1[38]\\d{3}",,,,,,,[5]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"5[12]\\d{3}",,,,,,,[5]
]
,"SB",677,"0[01]",,,,,,,,[[,"(\\d{2})(\\d{5})","$1 $2",["[7-9]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SC":[,[,,"[24689]\\d{5,6}",,,,,,,[7]
]
,[,,"4[2-46]\\d{5}"]
,[,,"2[5-8]\\d{5}"]
,[,,"8000\\d{3}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"(?:64\\d|971)\\d{4}"]
,"SC",248,"0(?:[02]|10?)",,,,,,"00",,[[,"(\\d)(\\d{3})(\\d{3})","$1 $2 $3",["[246]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SD":[,[,,"[19]\\d{8}",,,,,,,[9]
]
,[,,"1(?:[125]\\d|8[3567])\\d{6}"]
,[,,"9[0-3569]\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"SD",249,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SE":[,[,,"[1-35-9]\\d{5,11}|4\\d{6,8}",,,,,,,[6,7,8,9,10,12]
]
,[,,"1(?:0[1-8]\\d{6}|[136]\\d{5,7}|(?:2[0-35]|4[0-4]|5[0-25-9]|7[13-6]|[89]\\d)\\d{5,6})|2(?:[136]\\d{5,7}|(?:2[0-7]|4[0136-8]|5[0138]|7[018]|8[01]|9[0-57])\\d{5,6})|3(?:[356]\\d{5,7}|(?:0[0-4]|1\\d|2[0-25]|4[056]|7[0-2]|8[0-3]|9[023])\\d{5,6})|4(?:[0246]\\d{5,7}|(?:1[013-8]|3[0135]|5[14-79]|7[0-246-9]|8[0156]|9[0-689])\\d{5,6})|5(?:0[0-6]|[15][0-5]|2[0-68]|3[0-4]|4\\d|6[03-5]|7[013]|8[0-79]|9[01])\\d{5,6}|6(?:[03]\\d{5,7}|(?:1[1-3]|2[0-4]|4[02-57]|5[0-37]|6[0-3]|7[0-2]|8[0247]|9[0-356])\\d{5,6})|8\\d{6,8}|9(?:0[1-9]\\d{4,6}|(?:1[0-68]|2\\d|3[02-5]|4[0-3]|5[0-4]|[68][01]|7[0135-8])\\d{5,6})",,,,,,,[7,8,9]
]
,[,,"7[02369]\\d{7}",,,,,,,[9]
]
,[,,"20\\d{4,7}",,,,,,,[6,7,8,9]
]
,[,,"649\\d{6}|9(?:00|39|44)[1-8]\\d{3,6}",,,,,,,[7,8,9,10]
]
,[,,"77(?:0\\d{3}(?:\\d{3})?|[1-7]\\d{6})",,,,,,,[6,9]
]
,[,,"75[1-8]\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,"SE",46,"00","0",,,"0",,,,[[,"(8)(\\d{2,3})(\\d{2,3})(\\d{2})","$1-$2 $3 $4",["8"]
,"0$1"]
,[,"([1-69]\\d)(\\d{2,3})(\\d{2})(\\d{2})","$1-$2 $3 $4",["1[013689]|2[0136]|3[1356]|4[0246]|54|6[03]|90"]
,"0$1"]
,[,"([1-469]\\d)(\\d{3})(\\d{2})","$1-$2 $3",["[12][136]|3[356]|4[0246]|6[03]|90"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1-$2 $3 $4",["1[2457]|2(?:[247-9]|5[0138])|3[0247-9]|4[1357-9]|5[0-35-9]|6(?:[124-689]|7[0-2])|9(?:[125-8]|3[0-5]|4[0-3])"]
,"0$1"]
,[,"(\\d{3})(\\d{2,3})(\\d{2})","$1-$2 $3",["1[2457]|2(?:[247-9]|5[0138])|3[0247-9]|4[1357-9]|5[0-35-9]|6(?:[124-689]|7[0-2])|9(?:[125-8]|3[0-5]|4[0-3])"]
,"0$1"]
,[,"(7\\d)(\\d{3})(\\d{2})(\\d{2})","$1-$2 $3 $4",["7"]
,"0$1"]
,[,"(77)(\\d{2})(\\d{2})","$1-$2$3",["77"]
,"0$1"]
,[,"(20)(\\d{2,3})(\\d{2})","$1-$2 $3",["20"]
,"0$1"]
,[,"(9[034]\\d)(\\d{2})(\\d{2})(\\d{3})","$1-$2 $3 $4",["9[034]"]
,"0$1"]
,[,"(9[034]\\d)(\\d{4})","$1-$2",["9[034]"]
,"0$1"]
,[,"(\\d{3})(\\d{2})(\\d{3})(\\d{2})(\\d{2})","$1-$2 $3 $4 $5",["25[245]|67[3-6]"]
,"0$1"]
]
,[[,"(8)(\\d{2,3})(\\d{2,3})(\\d{2})","$1 $2 $3 $4",["8"]
]
,[,"([1-69]\\d)(\\d{2,3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["1[013689]|2[0136]|3[1356]|4[0246]|54|6[03]|90"]
]
,[,"([1-469]\\d)(\\d{3})(\\d{2})","$1 $2 $3",["[12][136]|3[356]|4[0246]|6[03]|90"]
]
,[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["1[2457]|2(?:[247-9]|5[0138])|3[0247-9]|4[1357-9]|5[0-35-9]|6(?:[124-689]|7[0-2])|9(?:[125-8]|3[0-5]|4[0-3])"]
]
,[,"(\\d{3})(\\d{2,3})(\\d{2})","$1 $2 $3",["1[2457]|2(?:[247-9]|5[0138])|3[0247-9]|4[1357-9]|5[0-35-9]|6(?:[124-689]|7[0-2])|9(?:[125-8]|3[0-5]|4[0-3])"]
]
,[,"(7\\d)(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["7"]
]
,[,"(77)(\\d{2})(\\d{2})","$1 $2 $3",["77"]
]
,[,"(20)(\\d{2,3})(\\d{2})","$1 $2 $3",["20"]
]
,[,"(9[034]\\d)(\\d{2})(\\d{2})(\\d{3})","$1 $2 $3 $4",["9[034]"]
]
,[,"(9[034]\\d)(\\d{4})","$1 $2",["9[034]"]
]
,[,"(\\d{3})(\\d{2})(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4 $5",["25[245]|67[3-6]"]
]
]
,[,,"74[02-9]\\d{6}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,"(?:25[245]|67[3-6])\\d{9}",,,,,,,[12]
]
]
,"SG":[,[,,"[36]\\d{7}|[17-9]\\d{7,10}",,,,,,,[8,10,11]
]
,[,,"6[1-9]\\d{6}",,,,,,,[8]
]
,[,,"(?:8[1-8]|9[0-8])\\d{6}",,,,,,,[8]
]
,[,,"1?800\\d{7}",,,,,,,[10,11]
]
,[,,"1900\\d{7}",,,,,,,[11]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"3[12]\\d{6}",,,,,,,[8]
]
,"SG",65,"0[0-3]\\d",,,,,,,,[[,"([3689]\\d{3})(\\d{4})","$1 $2",["[369]|8[1-9]"]
]
,[,"(1[89]00)(\\d{3})(\\d{4})","$1 $2 $3",["1[89]0","1[89]00"]
]
,[,"(7000)(\\d{4})(\\d{3})","$1 $2 $3",["700","7000"]
]
,[,"(800)(\\d{3})(\\d{4})","$1 $2 $3",["800"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"7000\\d{7}",,,,,,,[11]
]
,,,[,,,,,,,,,[-1]
]
]
,"SH":[,[,,"[256]\\d{4}|8\\d{3}",,,,,,,[4,5]
]
,[,,"2(?:[0-57-9]\\d|6[4-9])\\d{2}"]
,[,,"[56]\\d{4}",,,,,,,[5]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"262\\d{2}",,,,,,,[5]
]
,"SH",290,"00",,,,,,,,,,[,,,,,,,,,[-1]
]
,1,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SI":[,[,,"[1-7]\\d{6,7}|[89]\\d{4,7}",,,,,,,[5,6,7,8]
]
,[,,"(?:1\\d|[25][2-8]|3[24-8]|4[24-8]|7[3-8])\\d{6}",,,,,,,[8]
,[7]
]
,[,,"(?:[37][01]\\d|4[0139]\\d|51\\d|6(?:[48]\\d|9[69]))\\d{5}",,,,,,,[8]
]
,[,,"80\\d{4,6}",,,,,,,[6,7,8]
]
,[,,"90\\d{4,6}|89[1-3]\\d{2,5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"(?:59|8[1-3])\\d{6}",,,,,,,[8]
]
,"SI",386,"00","0",,,"0",,,,[[,"(\\d)(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[12]|[34][24-8]|5[2-8]|7[3-8]"]
,"(0$1)"]
,[,"([3-7]\\d)(\\d{3})(\\d{3})","$1 $2 $3",["[37][01]|4[0139]|51|6"]
,"0$1"]
,[,"([89][09])(\\d{3,6})","$1 $2",["[89][09]"]
,"0$1"]
,[,"([58]\\d{2})(\\d{5})","$1 $2",["59|8[1-3]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SJ":[,[,,"0\\d{4}|[45789]\\d{7}",,,,,,,[5,8]
]
,[,,"79\\d{6}",,,,,,,[8]
]
,[,,"(?:4[015-8]|5[89]|9\\d)\\d{6}",,,,,,,[8]
]
,[,,"80[01]\\d{5}",,,,,,,[8]
]
,[,,"82[09]\\d{5}",,,,,,,[8]
]
,[,,"810(?:0[0-6]|[2-8]\\d)\\d{3}",,,,,,,[8]
]
,[,,"880\\d{5}",,,,,,,[8]
]
,[,,"85[0-5]\\d{5}",,,,,,,[8]
]
,"SJ",47,"00",,,,,,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"0\\d{4}|81(?:0(?:0[7-9]|1\\d)|5\\d{2})\\d{3}"]
,,,[,,"81[23]\\d{5}",,,,,,,[8]
]
]
,"SK":[,[,,"(?:[2-68]\\d{5,8}|9\\d{6,8})",,,,,,,[6,7,9]
]
,[,,"2(?:1(?:6\\d{3,4}|7\\d{3})|[2-9]\\d{7})|[3-5][1-8](?:1(?:6\\d{2,3}|7\\d{3})|\\d{7})"]
,[,,"9(?:0(?:[1-8]\\d|9[1-9])|(?:1[0-24-9]|[45]\\d)\\d)\\d{5}",,,,,,,[9]
]
,[,,"800\\d{6}",,,,,,,[9]
]
,[,,"9(?:[78]\\d{7}|00\\d{6})",,,,,,,[9]
]
,[,,"8[5-9]\\d{7}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,"6(?:02|5[0-4]|9[0-6])\\d{6}",,,,,,,[9]
]
,"SK",421,"00","0",,,"0",,,,[[,"(2)(1[67])(\\d{3,4})","$1 $2 $3",["21[67]"]
,"0$1"]
,[,"([3-5]\\d)(\\d{2})(\\d{2,3})","$1 $2 $3",["[3-5]"]
,"0$1"]
,[,"(2)(\\d{3})(\\d{3})(\\d{2})","$1/$2 $3 $4",["2"]
,"0$1"]
,[,"([3-5]\\d)(\\d{3})(\\d{2})(\\d{2})","$1/$2 $3 $4",["[3-5]"]
,"0$1"]
,[,"([689]\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["[689]"]
,"0$1"]
,[,"(9090)(\\d{3})","$1 $2",["909","9090"]
,"0$1"]
]
,,[,,"9090\\d{3}",,,,,,,[7]
]
,,,[,,"(?:602|8(?:00|[5-9]\\d)|9(?:00|[78]\\d))\\d{6}|9090\\d{3}",,,,,,,[7,9]
]
,[,,"96\\d{7}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
]
,"SL":[,[,,"[2-9]\\d{7}",,,,,,,[8]
,[6]
]
,[,,"[235]2[2-4][2-9]\\d{4}",,,,,,,,[6]
]
,[,,"(?:2[15]|3[03-5]|4[04]|5[05]|66|7[6-9]|8[08]|99)\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"SL",232,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{6})","$1 $2",,"(0$1)"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SM":[,[,,"[05-7]\\d{7,9}",,,,,,,[8,10]
,[6]
]
,[,,"0549(?:8[0157-9]|9\\d)\\d{4}",,,,,,,[10]
,[6]
]
,[,,"6[16]\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,"7[178]\\d{6}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"5[158]\\d{6}",,,,,,,[8]
]
,"SM",378,"00",,,,"([89]\\d{5})","0549$1",,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[5-7]"]
]
,[,"(0549)(\\d{6})","$1 $2",["054","0549"]
]
,[,"(\\d{6})","0549 $1",["[89]"]
]
]
,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[5-7]"]
]
,[,"(0549)(\\d{6})","($1) $2",["054","0549"]
]
,[,"(\\d{6})","(0549) $1",["[89]"]
]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SN":[,[,,"[3789]\\d{8}",,,,,,,[9]
]
,[,,"3(?:0(?:1[0-2]|80)|282|3(?:8[1-9]|9[3-9])|611)\\d{5}"]
,[,,"7(?:[06-8]\\d|21|90)\\d{6}"]
,[,,"800\\d{6}"]
,[,,"88[4689]\\d{6}"]
,[,,"81[02468]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"39[01]\\d{6}|3392\\d{5}|93330\\d{4}"]
,"SN",221,"00",,,,,,,,[[,"(\\d{2})(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[379]"]
]
,[,"(\\d{3})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["8"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SO":[,[,,"[1-9]\\d{5,8}",,,,,,,[6,7,8,9]
]
,[,,"(?:1\\d{1,2}|2[0-79]\\d|3[0-46-8]?\\d|4[0-7]?\\d|59\\d|8[125])\\d{4}",,,,,,,[6,7]
]
,[,,"(?:15\\d|2(?:4\\d|8)|3[59]\\d{2}|4[89]\\d{2}|6[1-9]?\\d{2}|7(?:[1-8]\\d|9\\d{1,2})|8[08]\\d{2}|9(?:0[67]|[2-9])\\d)\\d{5}",,,,,,,[7,8,9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"SO",252,"00","0",,,"0",,,,[[,"(\\d{6})","$1",["[134]"]
]
,[,"(\\d)(\\d{6})","$1 $2",["[13-5]|2[0-79]"]
]
,[,"(\\d)(\\d{7})","$1 $2",["24|[67]"]
]
,[,"(\\d{2})(\\d{4})","$1 $2",["8[125]"]
]
,[,"(\\d{2})(\\d{5,7})","$1 $2",["15|28|6[1-35-9]|799|9[2-9]"]
]
,[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["3[59]|4[89]|6[24-6]|79|8[08]|90"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SR":[,[,,"[2-8]\\d{5,6}",,,,,,,[6,7]
]
,[,,"(?:2[1-3]|3[0-7]|4\\d|5[2-58]|68\\d)\\d{4}"]
,[,,"(?:7[124-7]|8[125-9])\\d{5}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"56\\d{4}",,,,,,,[6]
]
,"SR",597,"00",,,,,,,,[[,"(\\d{3})(\\d{3})","$1-$2",["[2-4]|5[2-58]"]
]
,[,"(\\d{2})(\\d{2})(\\d{2})","$1-$2-$3",["56"]
]
,[,"(\\d{3})(\\d{4})","$1-$2",["[6-8]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SS":[,[,,"[19]\\d{8}",,,,,,,[9]
]
,[,,"18\\d{7}"]
,[,,"(?:12|9[1257])\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"SS",211,"00","0",,,"0",,,,[[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"ST":[,[,,"[29]\\d{6}",,,,,,,[7]
]
,[,,"22\\d{5}"]
,[,,"9(?:0(?:0[5-9]|[1-9]\\d)|[89]\\d{2})\\d{3}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"ST",239,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SV":[,[,,"[267]\\d{7}|[89]\\d{6}(?:\\d{4})?",,,,,,,[7,8,11]
]
,[,,"2[1-6]\\d{6}",,,,,,,[8]
]
,[,,"[67]\\d{7}",,,,,,,[8]
]
,[,,"800\\d{4}(?:\\d{4})?",,,,,,,[7,11]
]
,[,,"900\\d{4}(?:\\d{4})?",,,,,,,[7,11]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"SV",503,"00",,,,,,,,[[,"(\\d{4})(\\d{4})","$1 $2",["[267]"]
]
,[,"(\\d{3})(\\d{4})","$1 $2",["[89]"]
]
,[,"(\\d{3})(\\d{4})(\\d{4})","$1 $2 $3",["[89]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SX":[,[,,"[5789]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"7215(?:4[2-8]|8[239]|9[056])\\d{4}",,,,,,,,[7]
]
,[,,"7215(?:1[02]|2\\d|5[034679]|8[014-8])\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"SX",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"721",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SY":[,[,,"[1-59]\\d{7,8}",,,,,,,[8,9]
,[6,7]
]
,[,,"(?:1(?:1\\d?|4\\d|[2356])|2(?:1\\d?|[235])|3(?:[13]\\d|4)|4[13]|5[1-3])\\d{6}",,,,,,,,[6,7]
]
,[,,"9(?:22|[3-589]\\d|6[024-9])\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"SY",963,"00","0",,,"0",,,,[[,"(\\d{2})(\\d{3})(\\d{3,4})","$1 $2 $3",["[1-5]"]
,"0$1",,1]
,[,"(9\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["9"]
,"0$1",,1]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"SZ":[,[,,"[027]\\d{7}",,,,,,,[8]
]
,[,,"2[2-9]\\d{6}"]
,[,,"7[6-9]\\d{6}"]
,[,,"0800\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"SZ",268,"00",,,,,,,,[[,"(\\d{4})(\\d{4})","$1 $2",["[027]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"0800\\d{4}"]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TA":[,[,,"8\\d{3}",,,,,,,[4]
]
,[,,"8\\d{3}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"TA",290,"00",,,,,,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TC":[,[,,"[5689]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"649(?:712|9(?:4\\d|50))\\d{4}",,,,,,,,[7]
]
,[,,"649(?:2(?:3[129]|4[1-7])|3(?:3[1-389]|4[1-8])|4[34][1-3])\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,"64971[01]\\d{4}",,,,,,,,[7]
]
,"TC",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"649",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TD":[,[,,"[2679]\\d{7}",,,,,,,[8]
]
,[,,"22(?:[3789]0|5[0-5]|6[89])\\d{4}"]
,[,,"(?:6[023568]\\d|77\\d|9\\d{2})\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"TD",235,"00|16",,,,,,"00",,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TG":[,[,,"[29]\\d{7}",,,,,,,[8]
]
,[,,"2(?:2[2-7]|3[23]|44|55|66|77)\\d{5}"]
,[,,"9[0-36-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"TG",228,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[29]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TH":[,[,,"1\\d{8,9}|[2-9]\\d{7,8}",,,,,,,[8,9,10]
]
,[,,"(?:2\\d|3[2-9]|4[2-5]|5[2-6]|7[3-7])\\d{6}",,,,,,,[8]
]
,[,,"(?:14|6[1-6]|[89]\\d)\\d{7}",,,,,,,[9]
]
,[,,"1800\\d{6}",,,,,,,[10]
]
,[,,"1900\\d{6}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"6[08]\\d{7}",,,,,,,[9]
]
,"TH",66,"00","0",,,"0",,,,[[,"(2)(\\d{3})(\\d{4})","$1 $2 $3",["2"]
,"0$1"]
,[,"([13-9]\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["14|[3-9]"]
,"0$1"]
,[,"(1[89]00)(\\d{3})(\\d{3})","$1 $2 $3",["1[89]0","1[89]00"]
,"$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TJ":[,[,,"[3-57-9]\\d{8}",,,,,,,[9]
,[3,5,7]
]
,[,,"(?:3(?:1[3-5]|2[245]|3[12]|4[24-7]|5[25]|72)|4(?:46|74|87))\\d{6}",,,,,,,,[3,5,7]
]
,[,,"(?:41[18]|(?:5[05]|77|88|9[0-35-9])\\d)\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"TJ",992,"810","8",,,"8",,"8~10",,[[,"([349]\\d{2})(\\d{2})(\\d{4})","$1 $2 $3",["[34]7|91[78]"]
,,,1]
,[,"([457-9]\\d)(\\d{3})(\\d{4})","$1 $2 $3",["4[148]|[578]|9(?:[0235-9]|1[59])"]
,,,1]
,[,"(331700)(\\d)(\\d{2})","$1 $2 $3",["331","3317","33170","331700"]
,,,1]
,[,"(\\d{4})(\\d)(\\d{4})","$1 $2 $3",["3[1-5]","3(?:[1245]|3(?:[02-9]|1[0-589]))"]
,,,1]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TK":[,[,,"[2-47]\\d{3,6}",,,,,,,[4,5,6,7]
]
,[,,"(?:2[2-4]|[34]\\d)\\d{2,5}"]
,[,,"7[2-4]\\d{2,5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"TK",690,"00",,,,,,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TL":[,[,,"[2-489]\\d{6}|7\\d{6,7}",,,,,,,[7,8]
]
,[,,"(?:2[1-5]|3[1-9]|4[1-4])\\d{5}",,,,,,,[7]
]
,[,,"7[3-8]\\d{6}",,,,,,,[8]
]
,[,,"80\\d{5}",,,,,,,[7]
]
,[,,"90\\d{5}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,"70\\d{5}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,"TL",670,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2",["[2-489]|70"]
]
,[,"(\\d{4})(\\d{4})","$1 $2",["7[3-8]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TM":[,[,,"[1-6]\\d{7}",,,,,,,[8]
]
,[,,"(?:1(?:2\\d|3[1-9])|2(?:22|4[0-35-8])|3(?:22|4[03-9])|4(?:22|3[128]|4\\d|6[15])|5(?:22|5[7-9]|6[014-689]))\\d{5}"]
,[,,"6[1-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"TM",993,"810","8",,,"8",,"8~10",,[[,"(\\d{2})(\\d{2})(\\d{2})(\\d{2})","$1 $2-$3-$4",["12"]
,"(8 $1)"]
,[,"(\\d{2})(\\d{6})","$1 $2",["6"]
,"8 $1"]
,[,"(\\d{3})(\\d)(\\d{2})(\\d{2})","$1 $2-$3-$4",["13|[2-5]"]
,"(8 $1)"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TN":[,[,,"[2-57-9]\\d{7}",,,,,,,[8]
]
,[,,"3(?:[012]\\d|6[0-4]|91)\\d{5}|7\\d{7}|81200\\d{3}"]
,[,,"(?:[259]\\d|4[0-6])\\d{6}"]
,[,,"8010\\d{4}"]
,[,,"88\\d{6}"]
,[,,"8[12]10\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"TN",216,"00",,,,,,,,[[,"(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TO":[,[,,"[02-8]\\d{4,6}",,,,,,,[5,7]
]
,[,,"(?:2\\d|3[1-8]|4[1-4]|[56]0|7[0149]|8[05])\\d{3}",,,,,,,[5]
]
,[,,"(?:7[578]|8[47-9])\\d{5}",,,,,,,[7]
]
,[,,"0800\\d{3}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"TO",676,"00",,,,,,,,[[,"(\\d{2})(\\d{3})","$1-$2",["[1-6]|7[0-4]|8[05]"]
]
,[,"(\\d{3})(\\d{4})","$1 $2",["7[5-9]|8[47-9]"]
]
,[,"(\\d{4})(\\d{3})","$1 $2",["0"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TR":[,[,,"[2-589]\\d{9}|444\\d{4}",,,,,,,[7,10]
]
,[,,"(?:2(?:[13][26]|[28][2468]|[45][268]|[67][246])|3(?:[13][28]|[24-6][2468]|[78][02468]|92)|4(?:[16][246]|[23578][2468]|4[26]))\\d{7}",,,,,,,[10]
]
,[,,"5(?:(?:0[1-7]|22|[34]\\d|5[1-59]|9[246])\\d{2}|6161)\\d{5}",,,,,,,[10]
]
,[,,"800\\d{7}",,,,,,,[10]
]
,[,,"900\\d{7}",,,,,,,[10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"TR",90,"00","0",,,"0",,,,[[,"(\\d{3})(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[23]|4(?:[0-35-9]|4[0-35-9])"]
,"(0$1)",,1]
,[,"(\\d{3})(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["5[02-69]"]
,"0$1",,1]
,[,"(\\d{3})(\\d{3})(\\d{4})","$1 $2 $3",["51|[89]"]
,"0$1",,1]
,[,"(444)(\\d{1})(\\d{3})","$1 $2 $3",["444"]
,,,1]
]
,,[,,"512\\d{7}",,,,,,,[10]
]
,,,[,,"444\\d{4}",,,,,,,[7]
]
,[,,"444\\d{4}|850\\d{7}"]
,,,[,,,,,,,,,[-1]
]
]
,"TT":[,[,,"[589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"868(?:2(?:01|[23]\\d)|6(?:0[79]|1[02-8]|2[1-9]|[3-69]\\d|7[0-79])|82[124])\\d{4}",,,,,,,,[7]
]
,[,,"868(?:2(?:6[6-9]|[789]\\d)|3(?:0[1-9]|1[02-9]|[2-9]\\d)|4[6-9]\\d|6(?:20|78|8\\d)|7(?:0[1-9]|1[02-9]|[2-9]\\d))\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"TT",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"868",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,"868619\\d{4}",,,,,,,,[7]
]
]
,"TV":[,[,,"[279]\\d{4,6}",,,,,,,[5,6,7]
]
,[,,"2[02-9]\\d{3}",,,,,,,[5]
]
,[,,"(?:70\\d|90)\\d{4}",,,,,,,[6,7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"TV",688,"00",,,,,,,,,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"TW":[,[,,"2\\d{6,8}|[3-689]\\d{7,8}|7\\d{7,9}",,,,,,,[7,8,9,10]
]
,[,,"(?:2(?:[235-8]\\d{3}|4\\d{2,3})|3[2-9]\\d{2}|4(?:[239]\\d|[78])\\d{2}|5[2-8]\\d{2}|6[235-79]\\d{2}|7[1-9]\\d{2}|8(?:2(?:3\\d|66)|[7-9]\\d{2}))\\d{4}",,,,,,,[8,9]
]
,[,,"9[0-8]\\d{7}",,,,,,,[9]
]
,[,,"80[0-79]\\d{6}",,,,,,,[9]
]
,[,,"20(?:2|[013-9]\\d{2})\\d{4}",,,,,,,[7,9]
]
,[,,,,,,,,,[-1]
]
,[,,"99\\d{7}",,,,,,,[9]
]
,[,,"70\\d{8}",,,,,,,[10]
]
,"TW",886,"0(?:0[25679]|19)","0","#",,"0",,,,[[,"(20)(\\d)(\\d{4})","$1 $2 $3",["202"]
,"0$1"]
,[,"([258]0)(\\d{3})(\\d{4})","$1 $2 $3",["20[013-9]|50[0-46-9]|80[0-79]"]
,"0$1"]
,[,"([2-8])(\\d{3,4})(\\d{4})","$1 $2 $3",["[25][2-8]|[346]|[78][1-9]"]
,"0$1"]
,[,"(9\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["9"]
,"0$1"]
,[,"(70)(\\d{4})(\\d{4})","$1 $2 $3",["70"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"50[0-46-9]\\d{6}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
]
,"TZ":[,[,,"\\d{9}",,,,,,,[7,9]
]
,[,,"2[2-8]\\d{7}"]
,[,,"(?:6[2-9]|7[13-9])\\d{7}",,,,,,,[9]
]
,[,,"80[08]\\d{6}",,,,,,,[9]
]
,[,,"90\\d{7}",,,,,,,[9]
]
,[,,"8(?:40|6[01])\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,"41\\d{7}",,,,,,,[9]
]
,"TZ",255,"00[056]","0",,,"0",,,,[[,"([24]\\d)(\\d{3})(\\d{4})","$1 $2 $3",["[24]"]
,"0$1"]
,[,"([67]\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["[67]"]
,"0$1"]
,[,"([89]\\d{2})(\\d{2})(\\d{4})","$1 $2 $3",["[89]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"(?:8(?:[04]0|6[01])|90\\d)\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"UA":[,[,,"[3-9]\\d{8}",,,,,,,[9]
,[5,6,7]
]
,[,,"(?:3[1-8]|4[13-8]|5[1-7]|6[12459])\\d{7}",,,,,,,,[5,6,7]
]
,[,,"(?:39|50|6[36-8]|7[1-3]|9[1-9])\\d{7}"]
,[,,"800\\d{6}"]
,[,,"900[2-49]\\d{5}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"89[1-579]\\d{6}"]
,"UA",380,"00","0",,,"0",,"0~0",,[[,"([3-9]\\d)(\\d{3})(\\d{4})","$1 $2 $3",["[38]9|4(?:[45][0-5]|87)|5(?:0|[67][37])|6[36-8]|7|9[1-9]","[38]9|4(?:[45][0-5]|87)|5(?:0|6(?:3[14-7]|7)|7[37])|6[36-8]|7|9[1-9]"]
,"0$1"]
,[,"([3-689]\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["(?:3[1-8]|4[136-8])2|5(?:[12457]2|6[24])|6(?:[12][29]|[49]2|5[24])|8[0-8]|90","3(?:[1-46-8]2[013-9]|52)|4(?:[1378]2|62[013-9])|5(?:[12457]2|6[24])|6(?:[12][29]|[49]2|5[24])|8[0-8]|90"]
,"0$1"]
,[,"([3-6]\\d{3})(\\d{5})","$1 $2",["3(?:[1-46-8]|5[013-9])|4(?:[137][013-9]|[45][6-9]|6|8[4-6])|5(?:[1245][013-9]|3|6[0135689]|7[4-6])|6(?:[12][13-8]|[49][013-9]|5[0135-9])","3(?:[1-46-8](?:[013-9]|22)|5[013-9])|4(?:[137][013-9]|[45][6-9]|6(?:[013-9]|22)|8[4-6])|5(?:[1245][013-9]|3|6(?:[015689]|3[02389])|7[4-6])|6(?:[12][13-8]|[49][013-9]|5[0135-9])"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"UG":[,[,,"\\d{9}",,,,,,,[9]
,[5,6,7]
]
,[,,"20(?:[0147]\\d{3}|2(?:40|[5-9]\\d)\\d|3(?:0[0-4]|[2367]\\d)\\d|5[0-4]\\d{2}|6(?:00[0-2]|30[0-4]|[5-9]\\d{2})|8[0-2]\\d{2})\\d{3}|[34]\\d{8}",,,,,,,,[5,6,7]
]
,[,,"7(?:0[0-7]\\d|[1578]\\d{2}|2(?:[03]\\d|60)|30\\d|4[0-4]\\d|9(?:[0-6]\\d|74))\\d{5}"]
,[,,"800[123]\\d{5}"]
,[,,"90[123]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"UG",256,"00[057]","0",,,"0",,,,[[,"(\\d{3})(\\d{6})","$1 $2",["20[0-8]|4(?:6[45]|[7-9])|[7-9]","20(?:[013-8]|2[5-9])|4(?:6[45]|[7-9])|[7-9]"]
,"0$1"]
,[,"(\\d{2})(\\d{7})","$1 $2",["3|4(?:[1-5]|6[0-36-9])"]
,"0$1"]
,[,"(2024)(\\d{5})","$1 $2",["202","2024"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"US":[,[,,"[2-9]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"(?:2(?:0[1-35-9]|1[02-9]|2[03-589]|3[149]|4[08]|5[1-46]|6[0279]|7[026]|8[13])|3(?:0[1-57-9]|1[02-9]|2[0135]|3[0-24679]|4[67]|5[12]|6[014]|8[056])|4(?:0[124-9]|1[02-579]|2[3-5]|3[0245]|4[0235]|58|6[39]|7[0589]|8[04])|5(?:0[1-57-9]|1[0235-8]|20|3[0149]|4[01]|5[19]|6[1-47]|7[013-5]|8[056])|6(?:0[1-35-9]|1[024-9]|2[03689]|3[016]|4[16]|5[017]|6[0-279]|78|8[012])|7(?:0[1-46-8]|1[02-9]|2[04-7]|3[1247]|4[037]|5[47]|6[02359]|7[02-59]|8[156])|8(?:0[1-68]|1[02-8]|28|3[0-258]|4[3578]|5[046-9]|6[02-5]|7[028])|9(?:0[1346-9]|1[02-9]|2[0589]|3[014678]|4[0179]|5[12469]|7[0-3589]|8[04-69]))[2-9]\\d{6}",,,,,,,,[7]
]
,[,,"(?:2(?:0[1-35-9]|1[02-9]|2[03-589]|3[149]|4[08]|5[1-46]|6[0279]|7[026]|8[13])|3(?:0[1-57-9]|1[02-9]|2[0135]|3[0-24679]|4[67]|5[12]|6[014]|8[056])|4(?:0[124-9]|1[02-579]|2[3-5]|3[0245]|4[0235]|58|6[39]|7[0589]|8[04])|5(?:0[1-57-9]|1[0235-8]|20|3[0149]|4[01]|5[19]|6[1-47]|7[013-5]|8[056])|6(?:0[1-35-9]|1[024-9]|2[03689]|3[016]|4[16]|5[017]|6[0-279]|78|8[012])|7(?:0[1-46-8]|1[02-9]|2[04-7]|3[1247]|4[037]|5[47]|6[02359]|7[02-59]|8[156])|8(?:0[1-68]|1[02-8]|28|3[0-258]|4[3578]|5[046-9]|6[02-5]|7[028])|9(?:0[1346-9]|1[02-9]|2[0589]|3[014678]|4[0179]|5[12469]|7[0-3589]|8[04-69]))[2-9]\\d{6}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"US",1,"011","1",,,"1",,,1,[[,"(\\d{3})(\\d{4})","$1-$2",,,,1]
,[,"(\\d{3})(\\d{3})(\\d{4})","($1) $2-$3",,,,1]
]
,[[,"(\\d{3})(\\d{3})(\\d{4})","$1-$2-$3"]
]
,[,,,,,,,,,[-1]
]
,1,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"UY":[,[,,"[2489]\\d{6,7}",,,,,,,[7,8]
]
,[,,"2\\d{7}|4[2-7]\\d{6}",,,,,,,[8]
,[7]
]
,[,,"9[1-9]\\d{6}",,,,,,,[8]
]
,[,,"80[05]\\d{4}",,,,,,,[7]
]
,[,,"90[0-8]\\d{4}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"UY",598,"0(?:1[3-9]\\d|0)","0"," int. ",,"0",,"00",,[[,"(\\d{4})(\\d{4})","$1 $2",["[24]"]
]
,[,"(\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["9[1-9]"]
,"0$1"]
,[,"(\\d{3})(\\d{4})","$1 $2",["[89]0"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"UZ":[,[,,"[679]\\d{8}",,,,,,,[9]
,[7]
]
,[,,"(?:6(?:1(?:22|3[124]|4[1-4]|5[123578]|64)|2(?:22|3[0-57-9]|41)|5(?:22|3[3-7]|5[024-8])|6\\d{2}|7(?:[23]\\d|7[69])|9(?:22|4[1-8]|6[135]))|7(?:0(?:5[4-9]|6[0146]|7[12456]|9[135-8])|1[12]\\d|2(?:22|3[1345789]|4[123579]|5[14])|3(?:2\\d|3[1578]|4[1-35-7]|5[1-57]|61)|4(?:2\\d|3[1-579]|7[1-79])|5(?:22|5[1-9]|6[1457])|6(?:22|3[12457]|4[13-8])|9(?:22|5[1-9])))\\d{5}",,,,,,,,[7]
]
,[,,"6(?:1(?:2(?:98|2[01])|35[0-4]|50\\d|61[23]|7(?:[01][017]|4\\d|55|9[5-9]))|2(?:11\\d|2(?:[12]1|9[01379])|5(?:[126]\\d|3[0-4])|7\\d{2})|5(?:19[01]|2(?:27|9[26])|30\\d|59\\d|7\\d{2})|6(?:2(?:1[5-9]|2[0367]|38|41|52|60)|3[79]\\d|4(?:56|83)|7(?:[07]\\d|1[017]|3[07]|4[047]|5[057]|67|8[0178]|9[79])|9[0-3]\\d)|7(?:2(?:24|3[237]|4[5-9]|7[15-8])|5(?:7[12]|8[0589])|7(?:0\\d|[39][07])|9(?:0\\d|7[079]))|9(?:2(?:1[1267]|5\\d|3[01]|7[0-4])|5[67]\\d|6(?:2[0-26]|8\\d)|7\\d{2}))\\d{4}|7(?:0\\d{3}|1(?:13[01]|6(?:0[47]|1[67]|66)|71[3-69]|98\\d)|2(?:2(?:2[79]|95)|3(?:2[5-9]|6[0-6])|57\\d|7(?:0\\d|1[17]|2[27]|3[37]|44|5[057]|66|88))|3(?:2(?:1[0-6]|21|3[469]|7[159])|33\\d|5(?:0[0-4]|5[579]|9\\d)|7(?:[0-3579]\\d|4[0467]|6[67]|8[078])|9[4-6]\\d)|4(?:2(?:29|5[0257]|6[0-7]|7[1-57])|5(?:1[0-4]|8\\d|9[5-9])|7(?:0\\d|1[024589]|2[0127]|3[0137]|[46][07]|5[01]|7[5-9]|9[079])|9(?:7[015-9]|[89]\\d))|5(?:112|2(?:0\\d|2[29]|[49]4)|3[1568]\\d|52[6-9]|7(?:0[01578]|1[017]|[23]7|4[047]|[5-7]\\d|8[78]|9[079]))|6(?:2(?:2[1245]|4[2-4])|39\\d|41[179]|5(?:[349]\\d|5[0-2])|7(?:0[017]|[13]\\d|22|44|55|67|88))|9(?:22[128]|3(?:2[0-4]|7\\d)|57[05629]|7(?:2[05-9]|3[37]|4\\d|60|7[2579]|87|9[07])))\\d{4}|9[0-57-9]\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"UZ",998,"810","8",,,"8",,"8~10",,[[,"([679]\\d)(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["[679]"]
,"8 $1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"VA":[,[,,"(?:0(?:878\\d{5}|6698\\d{5})|[1589]\\d{5,10}|3(?:[12457-9]\\d{8}|[36]\\d{7,9}))",,,,,,,[6,8,9,10,11]
]
,[,,"06698\\d{5}",,,,,,,[10]
]
,[,,"3(?:[12457-9]\\d{8}|6\\d{7,8}|3\\d{7,9})",,,,,,,[9,10,11]
]
,[,,"80(?:0\\d{6}|3\\d{3})",,,,,,,[6,9]
]
,[,,"0878\\d{5}|1(?:44|6[346])\\d{6}|89(?:2\\d{3}|4(?:[0-4]\\d{2}|[5-9]\\d{4})|5(?:[0-4]\\d{2}|[5-9]\\d{6})|9\\d{6})",,,,,,,[6,8,9,10]
]
,[,,"84(?:[08]\\d{6}|[17]\\d{3})",,,,,,,[6,9]
]
,[,,"1(?:78\\d|99)\\d{6}",,,,,,,[9,10]
]
,[,,"55\\d{8}",,,,,,,[10]
]
,"VA",39,"00",,,,,,,,,,[,,,,,,,,,[-1]
]
,,,[,,"848\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"VC":[,[,,"[5789]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"784(?:266|3(?:6[6-9]|7\\d|8[0-24-6])|4(?:38|5[0-36-8]|8[0-8])|5(?:55|7[0-2]|93)|638|784)\\d{4}",,,,,,,,[7]
]
,[,,"784(?:4(?:3[0-5]|5[45]|89|9[0-58])|5(?:2[6-9]|3[0-4]))\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"VC",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"784",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"VE":[,[,,"[24589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"(?:2(?:12|3[457-9]|[58][1-9]|[467]\\d|9[1-6])|50[01])\\d{7}",,,,,,,,[7]
]
,[,,"4(?:1[24-8]|2[46])\\d{7}"]
,[,,"800\\d{7}"]
,[,,"900\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"VE",58,"00","0",,,"0",,,,[[,"(\\d{3})(\\d{7})","$1-$2",,"0$1","$CC $1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"VG":[,[,,"[2589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"284(?:(?:229|4(?:22|9[45])|774|8(?:52|6[459]))\\d{4}|496[0-5]\\d{3})",,,,,,,,[7]
]
,[,,"284(?:(?:3(?:0[0-3]|4[0-7]|68|9[34])|4(?:4[0-6]|68|99)|54[0-57])\\d{4}|496[6-9]\\d{3})",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"VG",1,"011","1",,,"1",,,,,,[,,,,,,,,,[-1]
]
,,"284",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"VI":[,[,,"[3589]\\d{9}",,,,,,,[10]
,[7]
]
,[,,"340(?:2(?:01|2[0678]|44|77)|3(?:32|44)|4(?:22|7[34])|5(?:1[34]|55)|6(?:26|4[23]|77|9[023])|7(?:1[2-589]|27|7\\d)|884|998)\\d{4}",,,,,,,,[7]
]
,[,,"340(?:2(?:01|2[0678]|44|77)|3(?:32|44)|4(?:22|7[34])|5(?:1[34]|55)|6(?:26|4[23]|77|9[023])|7(?:1[2-589]|27|7\\d)|884|998)\\d{4}",,,,,,,,[7]
]
,[,,"8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"]
,[,,"900[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,"5(?:00|22|33|44|66|77|88)[2-9]\\d{6}"]
,[,,,,,,,,,[-1]
]
,"VI",1,"011","1",,,"1",,,1,,,[,,,,,,,,,[-1]
]
,,"340",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"VN":[,[,,"1\\d{6,9}|2\\d{9}|6\\d{6,7}|7\\d{6}|8\\d{6,8}|9\\d{8}",,,,,,,[7,8,9,10]
]
,[,,"2(?:0[3-9]|1[0-689]|2[0-25-9]|3[2-9]|4[2-8]|5[124-9]|6[0-39]|7[0-7]|8[2-7]|9[0-4679])\\d{7}",,,,,,,[10]
]
,[,,"(?:9\\d|1(?:2\\d|6[2-9]|8[68]|99))\\d{7}|8(?:6[89]|8\\d|9[89])\\d{6}",,,,,,,[9,10]
]
,[,,"1800\\d{4,6}",,,,,,,[8,9,10]
]
,[,,"1900\\d{4,6}",,,,,,,[8,9,10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"VN",84,"00","0",,,"0",,,,[[,"([17]99)(\\d{4})","$1 $2",["[17]99"]
,"0$1",,1]
,[,"(\\d{2})(\\d{4})(\\d{4})","$1 $2 $3",["2[48]"]
,"0$1",,1]
,[,"(80)(\\d{5})","$1 $2",["80"]
,"0$1",,1]
,[,"(69\\d)(\\d{4,5})","$1 $2",["69"]
,"0$1",,1]
,[,"(\\d{3})(\\d{4})(\\d{3})","$1 $2 $3",["2[0-35-79]"]
,"0$1",,1]
,[,"([89]\\d)(\\d{3})(\\d{2})(\\d{2})","$1 $2 $3 $4",["8(?:8|9[89])|9"]
,"0$1",,1]
,[,"(1[2689]\\d)(\\d{3})(\\d{4})","$1 $2 $3",["1(?:[26]|8[68]|99)"]
,"0$1",,1]
,[,"(86[89])(\\d{3})(\\d{3})","$1 $2 $3",["86[89]"]
,"0$1",,1]
,[,"(1[89]00)(\\d{4,6})","$1 $2",["1[89]0","1[89]00"]
,"$1",,1]
]
,,[,,,,,,,,,[-1]
]
,,,[,,"[17]99\\d{4}|69\\d{5,6}",,,,,,,[7,8]
]
,[,,"[17]99\\d{4}|69\\d{5,6}|80\\d{5}",,,,,,,[7,8]
]
,,,[,,,,,,,,,[-1]
]
]
,"VU":[,[,,"[2-57-9]\\d{4,6}",,,,,,,[5,7]
]
,[,,"(?:2[02-9]\\d|3(?:[5-7]\\d|8[0-8])|48[4-9]|88\\d)\\d{2}",,,,,,,[5]
]
,[,,"(?:5(?:7[2-5]|[0-689]\\d)|7[013-7]\\d)\\d{4}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"VU",678,"00",,,,,,,,[[,"(\\d{3})(\\d{4})","$1 $2",["[579]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"3[03]\\d{3}|900\\d{4}"]
,,,[,,,,,,,,,[-1]
]
]
,"WF":[,[,,"[4-8]\\d{5}",,,,,,,[6]
]
,[,,"(?:50|68|72)\\d{4}"]
,[,,"(?:50|68|72|8[23])\\d{4}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"WF",681,"00",,,,,,,,[[,"(\\d{2})(\\d{2})(\\d{2})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,"[48]0\\d{4}"]
]
,"WS":[,[,,"[2-8]\\d{4,6}",,,,,,,[5,6,7]
]
,[,,"(?:[2-5]\\d|6[1-9]|84\\d{2})\\d{3}",,,,,,,[5,7]
]
,[,,"(?:60|7[25-7]\\d)\\d{4}",,,,,,,[6,7]
]
,[,,"800\\d{3}",,,,,,,[6]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"WS",685,"0",,,,,,,,[[,"(8\\d{2})(\\d{3,4})","$1 $2",["8"]
]
,[,"(7\\d)(\\d{5})","$1 $2",["7"]
]
,[,"(\\d{5})","$1",["[2-6]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"YE":[,[,,"[1-7]\\d{6,8}",,,,,,,[7,8,9]
,[6]
]
,[,,"(?:1(?:7\\d|[2-68])|2[2-68]|3[2358]|4[2-58]|5[2-6]|6[3-58]|7[24-68])\\d{5}",,,,,,,[7,8]
,[6]
]
,[,,"7[0137]\\d{7}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"YE",967,"00","0",,,"0",,,,[[,"([1-7])(\\d{3})(\\d{3,4})","$1 $2 $3",["[1-6]|7[24-68]"]
,"0$1"]
,[,"(7\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["7[0137]"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"YT":[,[,,"[268]\\d{8}",,,,,,,[9]
]
,[,,"269(?:6[0-4]|50)\\d{4}"]
,[,,"639(?:0[0-79]|1[019]|[26]\\d|3[09]|[45]0|7[06]|9[04-79])\\d{4}"]
,[,,"80\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"YT",262,"00","0",,,"0",,,,,,[,,,,,,,,,[-1]
]
,,"269|63",[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"ZA":[,[,,"[1-79]\\d{8}|8\\d{4,8}",,,,,,,[5,6,7,8,9]
]
,[,,"(?:1[0-8]|2[1-378]|3[1-69]|4\\d|5[1346-8])\\d{7}",,,,,,,[9]
]
,[,,"(?:6\\d|7[0-46-9])\\d{7}|8(?:[1-4]\\d{1,5}|5\\d{5})\\d{2}"]
,[,,"80\\d{7}",,,,,,,[9]
]
,[,,"86[2-9]\\d{6}|9[0-2]\\d{7}",,,,,,,[9]
]
,[,,"860\\d{6}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,"87\\d{7}",,,,,,,[9]
]
,"ZA",27,"00","0",,,"0",,,,[[,"(860)(\\d{3})(\\d{3})","$1 $2 $3",["860"]
,"0$1"]
,[,"(\\d{2})(\\d{3,4})","$1 $2",["8[1-4]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{2,3})","$1 $2 $3",["8[1-4]"]
,"0$1"]
,[,"(\\d{2})(\\d{3})(\\d{4})","$1 $2 $3",["[1-79]|8(?:[0-57]|6[1-9])"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"861\\d{6}",,,,,,,[9]
]
,,,[,,,,,,,,,[-1]
]
]
,"ZM":[,[,,"[289]\\d{8}",,,,,,,[9]
]
,[,,"21[1-8]\\d{6}"]
,[,,"9[4-9]\\d{7}"]
,[,,"800\\d{6}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"ZM",260,"00","0",,,"0",,,,[[,"([29]\\d)(\\d{7})","$1 $2",["[29]"]
,"0$1"]
,[,"(800)(\\d{3})(\\d{3})","$1 $2 $3",["800"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"ZW":[,[,,"2(?:[0-57-9]\\d{3,8}|6(?:[14]\\d{7}|\\d{4}))|[13-79]\\d{4,9}|8[06]\\d{5,8}",,,,,,,[5,6,7,8,9,10]
,[3,4]
]
,[,,"(?:2(?:0(?:4\\d|5\\d{2})|2[278]\\d|48\\d|7(?:[1-7]\\d|[089]\\d{2})|8(?:[2-57-9]|[146]\\d{2})|98)|3(?:08|17|3[78]|7(?:[19]|[56]\\d)|8[37]|98)|5[15][78]|6(?:28\\d{2}|37|6[78]|75\\d|98|8(?:7\\d|8)))\\d{3}|(?:2(?:1[39]|2[0157]|31|[56][14]|7[35]|84)|329)\\d{7}|(?:1(?:3\\d{2}|[4-8]|9\\d)|2(?:0\\d{2}|12|292|[569]\\d)|3(?:[26]|[013459]\\d)|5(?:0|1[2-4]|26|[37]2|5\\d{2}|[689]\\d)|6(?:[39]|[01246]\\d|[78]\\d{2}))\\d{3}|(?:29\\d|39|54)\\d{6}|(?:(?:25|54)83\\d|2582\\d{2}|65[2-8])\\d{2}|(?:4\\d{6,7}|9[2-9]\\d{4,5})",,,,,,,,[3,4]
]
,[,,"(?:7(?:1[2-8]|3[2-9]|7[1-9]|8[2-5])|8644)\\d{6}",,,,,,,[9,10]
]
,[,,"80(?:[01]\\d|20|8[0-8])\\d{3}",,,,,,,[7]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"86(?:1[12]|30|55|77|8[368])\\d{6}",,,,,,,[10]
]
,"ZW",263,"00","0",,,"0",,,,[[,"([49])(\\d{3})(\\d{2,4})","$1 $2 $3",["4|9[2-9]"]
,"0$1"]
,[,"(7\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["7"]
,"0$1"]
,[,"(86\\d{2})(\\d{3})(\\d{3})","$1 $2 $3",["86[24]"]
,"0$1"]
,[,"([2356]\\d{2})(\\d{3,5})","$1 $2",["2(?:0[45]|2[278]|[49]8|[78])|3(?:[09]8|17|3[78]|7[1569]|8[37])|5[15][78]|6(?:[29]8|37|[68][78]|75)"]
,"0$1"]
,[,"(\\d{3})(\\d{3})(\\d{3,4})","$1 $2 $3",["2(?:1[39]|2[0157]|31|[56][14]|7[35]|84)|329"]
,"0$1"]
,[,"([1-356]\\d)(\\d{3,5})","$1 $2",["1[3-9]|2[02569]|3[0-69]|5[05689]|6"]
,"0$1"]
,[,"([235]\\d)(\\d{3})(\\d{3,4})","$1 $2 $3",["[23]9|54"]
,"0$1"]
,[,"([25]\\d{3})(\\d{3,5})","$1 $2",["(?:25|54)8","258[23]|5483"]
,"0$1"]
,[,"(8\\d{3})(\\d{6})","$1 $2",["86"]
,"0$1"]
,[,"(80\\d)(\\d{4})","$1 $2",["80"]
,"0$1"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"800":[,[,,"\\d{8}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"\\d{8}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"001",800,,,,,,,,1,[[,"(\\d{4})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"808":[,[,,"\\d{8}",,,,,,,[8]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"\\d{8}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"001",808,,,,,,,,1,[[,"(\\d{4})(\\d{4})","$1 $2"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"870":[,[,,"[35-7]\\d{8}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,"(?:[356]\\d|7[6-8])\\d{7}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"001",870,,,,,,,,,[[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"878":[,[,,"1\\d{11}",,,,,,,[12]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"10\\d{10}"]
,"001",878,,,,,,,,1,[[,"(\\d{2})(\\d{5})(\\d{5})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"881":[,[,,"[67]\\d{8}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,"[67]\\d{8}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"001",881,,,,,,,,,[[,"(\\d)(\\d{3})(\\d{5})","$1 $2 $3",["[67]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"882":[,[,,"[13]\\d{6,11}",,,,,,,[7,8,9,10,11,12]
]
,[,,,,,,,,,[-1]
]
,[,,"3(?:2\\d{3}|37\\d{2}|4(?:2|7\\d{3}))\\d{4}",,,,,,,[7,9,10]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"1(?:3(?:0[0347]|[13][0139]|2[035]|4[013568]|6[0459]|7[06]|8[15678]|9[0689])\\d{4}|6\\d{5,10})|3(?:45|9\\d{3})\\d{7}"]
,"001",882,,,,,,,,,[[,"(\\d{2})(\\d{4})(\\d{3})","$1 $2 $3",["3[23]"]
]
,[,"(\\d{2})(\\d{5})","$1 $2",["16|342"]
]
,[,"(\\d{2})(\\d{4})(\\d{4})","$1 $2 $3",["34[57]"]
]
,[,"(\\d{3})(\\d{4})(\\d{4})","$1 $2 $3",["348"]
]
,[,"(\\d{2})(\\d{2})(\\d{4})","$1 $2 $3",["1"]
]
,[,"(\\d{2})(\\d{3,4})(\\d{4})","$1 $2 $3",["16"]
]
,[,"(\\d{2})(\\d{4,5})(\\d{5})","$1 $2 $3",["16|39"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,"348[57]\\d{7}",,,,,,,[11]
]
]
,"883":[,[,,"51\\d{7}(?:\\d{3})?",,,,,,,[9,12]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"51(?:00\\d{5}(?:\\d{3})?|[13]0\\d{8})"]
,"001",883,,,,,,,,1,[[,"(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3",["510"]
]
,[,"(\\d{3})(\\d{3})(\\d{3})(\\d{3})","$1 $2 $3 $4",["510"]
]
,[,"(\\d{4})(\\d{4})(\\d{4})","$1 $2 $3",["51[13]"]
]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
,"888":[,[,,"\\d{11}",,,,,,,[11]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"001",888,,,,,,,,1,[[,"(\\d{3})(\\d{3})(\\d{5})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,"\\d{11}"]
,,,[,,,,,,,,,[-1]
]
]
,"979":[,[,,"\\d{9}",,,,,,,[9]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,"\\d{9}"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,"001",979,,,,,,,,1,[[,"(\\d)(\\d{4})(\\d{4})","$1 $2 $3"]
]
,,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,[,,,,,,,,,[-1]
]
]
};
