/**
 * @license
 * Copyright (C) 2010 The Libphonenumber Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generated metadata for file
 * ../resources/ShortNumberMetadata.xml
 * @author Nikolaos Trogkanis
 */

goog.provide('i18n.phonenumbers.shortnumbermetadata');

/**
 * A mapping from a country calling code to the region codes which denote the
 * region represented by that country calling code. In the case of multiple
 * countries sharing a calling code, such as the NANPA regions, the one
 * indicated with "isMainCountryForCode" in the metadata should be first.
 * @type {!Object.<number, Array.<string>>}
 */
i18n.phonenumbers.shortnumbermetadata.countryCodeToRegionCodeMap = {
0:["AC","AD","AE","AF","AG","AI","AL","AM","AO","AR","AS","AT","AU","AW","AX","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BL","BM","BN","BO","BQ","BR","BS","BT","BW","BY","BZ","CA","CC","CD","CF","CG","CH","CI","CK","CL","CM","CN","CO","CR","CU","CV","CW","CX","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG","EH","ER","ES","ET","FI","FJ","FK","FM","FO","FR","GA","GB","GD","GE","GF","GG","GH","GI","GL","GM","GN","GP","GR","GT","GU","GW","GY","HK","HN","HR","HT","HU","ID","IE","IL","IM","IN","IQ","IR","IS","IT","JE","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KY","KZ","LA","LB","LC","LI","LK","LR","LS","LT","LU","LV","LY","MA","MC","MD","ME","MF","MG","MH","MK","ML","MM","MN","MO","MP","MQ","MR","MS","MT","MU","MV","MW","MX","MY","MZ","NA","NC","NE","NF","NG","NI","NL","NO","NP","NR","NU","NZ","OM","PA","PE","PF","PG","PH","PK","PL","PM","PR","PS","PT","PW","PY","QA","RE","RO","RS","RU","RW","SA","SB","SC","SD","SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO","SR","ST","SV","SX","SY","SZ","TC","TD","TG","TH","TJ","TL","TM","TN","TO","TR","TT","TV","TW","TZ","UA","UG","US","UY","UZ","VA","VC","VE","VG","VI","VN","VU","WF","WS","XK","YE","YT","ZA","ZM","ZW"]
};

/**
 * A mapping from a region code to the PhoneMetadata for that region.
 * @type {!Object.<string, Array>}
 */
i18n.phonenumbers.shortnumbermetadata.countryToMetadata = {
"AC":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AC",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"AD":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AD",,,,,,,,,,,,,,,,,,[,,"11[0268]",,,,"112"]
,,[,,"11[0268]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"AE":[,[,,"[149]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AE",,,,,,,,,,,,,,,,,,[,,"112|99[789]",,,,"112",,,[3]
]
,,[,,"112|445[16]|99[789]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"445[16]",,,,"4451",,,[4]
]
]
,"AF":[,[,,"[14]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AF",,,,,,,,,,,,,,,,,,[,,"1(?:02|19)",,,,"119",,,[3]
]
,,[,,"1(?:02|19)|40404",,,,"119"]
,[,,,,,,,,,[-1]
]
,[,,"40404",,,,"40404",,,[5]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"AG":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AG",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"176|9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"AI":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AI",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"AL":[,[,,"[15]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:3[15]|41|16\\d{3})",,,,"116000",,,[3,6]
]
,[,,"5\\d{4}",,,,"50123",,,[5]
]
,,,,"AL",,,,,,,,,,,,,,,,,,[,,"1(?:12|2[7-9])",,,,"129",,,[3]
]
,,[,,"1(?:1(?:\\d|6(?:000|1(?:06|11|23))|8\\d{2})|2[2-9]|[349]\\d|65\\d|89[12])|5\\d{4}",,,,"129"]
,[,,,,,,,,,[-1]
]
,[,,"123",,,,"123",,,[3]
]
,,[,,"131|5\\d{4}",,,,"51234",,,[3,5]
]
]
,"AM":[,[,,"[148]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AM",,,,,,,,,,,,,,,,,,[,,"10[123]",,,,"102",,,[3]
]
,,[,,"1\\d{2}|40404|8[1-7]\\d{2}",,,,"8711"]
,[,,,,,,,,,[-1]
]
,[,,"40404",,,,"40404",,,[5]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"AO":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AO",,,,,,,,,,,,,,,,,,[,,"11[235]",,,,"113"]
,,[,,"11[235]",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"AR":[,[,,"[01389]\\d{1,4}",,,,,,,[2,3,4,5]
]
,,,[,,"[09]\\d{2}|1(?:[02-9]\\d?|1[0-24-9]?)",,,,"111",,,[2,3]
]
,[,,,,,,,,,[-1]
]
,,,,"AR",,,,,,,,,,,,,,,,,,[,,"10[017]|911",,,,"101",,,[3]
]
,,[,,"000|1(?:0[0-35-7]|1[02-5]|2[15]|9)|3372|89338|911",,,,"121"]
,[,,,,,,,,,[-1]
]
,[,,"89338",,,,"89338",,,[5]
]
,,[,,"3372|89338",,,,"3372",,,[4,5]
]
]
,"AS":[,[,,"[49]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AS",,,,,,,,,,,,,,,,,,[,,"911",,,,"911",,,[3]
]
,,[,,"40404|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"AT":[,[,,"1\\d{2,5}",,,,,,,[3,6]
]
,,,[,,"116(?:00[06]|1(?:17|23))",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"AT",,,,,,,,,,,,,,,,,,[,,"1(?:[12]2|33|44)",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:00[06]|1(?:17|23)))|22|33|44)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"AU":[,[,,"[027]\\d{2}|1\\d{2,7}",,,,,,,[3,4,5,6,7,8]
]
,,,[,,"1(?:258885|555)|733",,,,"733",,,[3,4,7]
]
,[,,"1(?:2(?:34|456)|9\\d{4})",,,,"191123",,,[4,5,6]
]
,,,,"AU",,,,,,,,,,,,,,,,,,[,,"000|1(?:06|12)",,,,"112",,,[3]
]
,,[,,"000|1(?:06|1(?:00|2|9[46])|2(?:[23]\\d|4\\d{2,3}|5\\d{3,4}|8(?:2|[013-9]\\d))|555|9\\d{4,6})|225|7(?:33|67)",,,,"112"]
,[,,"1(?:1\\d{2}|24733)|225|767",,,,"225",,,[3,4,6]
]
,[,,"1(?:258885|555)",,,,"1555",,,[4,7]
]
,,[,,"19\\d{4,6}",,,,"191123",,,[6,7,8]
]
]
,"AW":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AW",,,,,,,,,,,,,,,,,,[,,"100|911",,,,"911"]
,,[,,"1(?:00|76)|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"AX":[,[,,"1\\d{2}|75[12]\\d{2}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AX",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"112|75[12]\\d{2}",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"AZ":[,[,,"[148]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"AZ",,,,,,,,,,,,,,,,,,[,,"1(?:0[123]|12)",,,,"101",,,[3]
]
,,[,,"1(?:0[123]|12)|4040|8800",,,,"101"]
,[,,,,,,,,,[-1]
]
,[,,"4040|8800",,,,"4040",,,[4]
]
,,[,,"4040|8800",,,,"4040",,,[4]
]
]
,"BA":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"BA",,,,,,,,,,,,,,,,,,[,,"12[2-4]",,,,"122",,,[3]
]
,,[,,"1(?:1(?:6(?:00[06]|1(?:1[17]|23))|8\\d{1,2})|2(?:0[0-7]|[2-5]|6[0-26]|[78]\\d{1,2})|[3-5]\\d{2}|7\\d{3})",,,,"122"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BB":[,[,,"[2-689]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BB",,,,,,,,,,,,,,,,,,[,,"[2359]11",,,,"211"]
,,[,,"[2-689]11",,,,"211"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BD":[,[,,"[179]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"106",,,,"106",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"BD",,,,,,,,,,,,,,,,,,[,,"1(?:0[0-2]|99)|999",,,,"999",,,[3]
]
,,[,,"1(?:0(?:[0-39]|5(?:0\\d|[1-4])|6(\\d{2})?|7[0-4]|8[0-29])|1[16-9]|2(?:[134]|2[0-5])|3(?:1\\d?|3\\d|6[3-6])|4(?:0\\d|1\\d{2})|5[2-9]|99)|786|5012|9(?:594|99)",,,,"103"]
,[,,,,,,,,,[-1]
]
,[,,"1(?:11|2[13])|786|5012|9594",,,,"9594",,,[3,4]
]
,,[,,"9594",,,,"9594",,,[4]
]
]
,"BE":[,[,,"1\\d{2,5}|[2-9]\\d{3}",,,,,,,[3,4,6]
]
,,,[,,"1(?:0[25-8]|1(?:0|6\\d{3})|7(?:12|77)|813)|8\\d{3}",,,,"116000"]
,[,,"1(?:2(?:12|34)|3(?:07|13)|414|\\d04)|[2-79]\\d{3}",,,,"7212",,,[4]
]
,,,,"BE",,,,,,,,,,,,,,,,,,[,,"1(?:0[01]|12)",,,,"112",,,[3]
]
,,[,,"1(?:0[0-8]|1(?:[027]|6(?:000|117))|2(?:0[47]|12|3[0-24]|99)|3(?:0[47]|13|99)|4(?:0[47]|14|50|99)|5(?:1[05]|5[15]|66|95)|6(?:1[167]|36|6[16])|7(?:0[07]|1[27-9]|22|33|65|7[017]|89)|81[39])|[2-9]\\d{3}",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"[2-9]\\d{3}",,,,"2787",,,[4]
]
]
,"BF":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BF",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17"]
,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BG":[,[,,"1\\d{2,5}",,,,,,,[3,6]
]
,,,[,,"116(?:000|111)",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"BG",,,,,,,,,,,,,,,,,,[,,"1(?:12|50|6[06])",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:000|111))|50|6[06])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BH":[,[,,"[0189]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,"(?:0[167]|81)\\d{3}",,,,"07123",,,[5]
]
,[,,"9[148]\\d{3}",,,,"94123",,,[5]
]
,,,,"BH",,,,,,,,,,,,,,,,,,[,,"[19]99",,,,"999",,,[3]
]
,,[,,"0[167]\\d{3}|1(?:[02]\\d|12|4[01]|51|8[18]|9[169])|8[158]\\d{3}|9(?:[148]\\d{3}|9[02489])",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,"0[67]\\d{3}|88000|98555",,,,"88000",,,[5]
]
,,[,,"88000|98555",,,,"88000",,,[5]
]
]
,"BI":[,[,,"[16-9]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"611",,,,"611",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"BI",,,,,,,,,,,,,,,,,,[,,"11[237]",,,,"117",,,[3]
]
,,[,,"1(?:1\\d|5[2-9]|6[0-256])|611|7(?:10|77|979)|8[28]8|900",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,"611|7(?:10|77)|888|900",,,,"611",,,[3]
]
,,[,,"710|900",,,,"900",,,[3]
]
]
,"BJ":[,[,,"[17]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"7[3-5]\\d{2}",,,,"7312",,,[4]
]
,[,,,,,,,,,[-1]
]
,,,,"BJ",,,,,,,,,,,,,,,,,,[,,"11[78]",,,,"117",,,[3]
]
,,[,,"1(?:1[78]|2[02-5]|60)|7[0-5]\\d{2}",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,"12\\d",,,,"122",,,[3]
]
,,[,,,,,,,,,[-1]
]
]
,"BL":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BL",,,,,,,,,,,,,,,,,,[,,"18",,,,"18"]
,,[,,"18",,,,"18"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BM":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BM",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"176|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"BN":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BN",,,,,,,,,,,,,,,,,,[,,"99[135]",,,,"991"]
,,[,,"99[135]",,,,"991"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BO":[,[,,"[14]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BO",,,,,,,,,,,,,,,,,,[,,"11[089]",,,,"110",,,[3]
]
,,[,,"11[089]|40404",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"BQ":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BQ",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112"]
,,[,,"1(?:12|76)|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"BR":[,[,,"[12469]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:00|[89]\\d)|4(?:57|828)",,,,"181",,,[3,4]
]
,[,,,,,,,,,[-1]
]
,,,,"BR",,,,,,,,,,,,,,,,,,[,,"1(?:12|28|9[023])|911",,,,"190",,,[3]
]
,,[,,"1(?:0(?:[02]|3(?:1[2-579]|2[13-9]|3[124-9]|4[1-3578]|5[1-468]|6[139]|8[149]|9[168])|5[0-35-9]|6(?:0|1[0-35-8]?|2[0145]|3[0137]?|4[37-9]?|5[0-35]|6[016]?|7[137]?|8[5-8]|9[1359]))|1[25-8]|2[35789]|3(?:[024568]|3[12])|4[12568]|5\\d|6[0-8]|8[015]|9[0-4789])|2(?:7(?:330|878)|85959?)|4(?:0404?|11[12]|57|828)|55555|6(?:0\\d{4}|10000)|911",,,,"168"]
,[,,"102|27330",,,,"27330",,,[3,5]
]
,[,,"151|27878|4(?:0404?|11[12]|57)|55555",,,,"27878",,,[3,4,5]
]
,,[,,"2(?:7(?:330|878)|85959?)|4(?:0404|828)|6(?:0\\d{4}|10000)",,,,"27878",,,[4,5,6]
]
]
,"BS":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BS",,,,,,,,,,,,,,,,,,[,,"91[19]",,,,"911"]
,,[,,"91[19]",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BT":[,[,,"[14]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BT",,,,,,,,,,,,,,,,,,[,,"11[023]",,,,"113",,,[3]
]
,,[,,"11[0-6]|40404",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"BW":[,[,,"[19]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BW",,,,,,,,,,,,,,,,,,[,,"99[789]",,,,"999",,,[3]
]
,,[,,"13123|99[789]",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,"13123",,,,"13123",,,[5]
]
,,[,,"13123",,,,"13123",,,[5]
]
]
,"BY":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BY",,,,,,,,,,,,,,,,,,[,,"1(?:0[123]|12)",,,,"112"]
,,[,,"1(?:0[1-79]|1[246]|35|5[1235]|6[89]|7[5-7]|8[58]|9[1-7])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"BZ":[,[,,"9\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"BZ",,,,,,,,,,,,,,,,,,[,,"9(?:0|11)",,,,"911"]
,,[,,"9(?:0|11)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CA":[,[,,"[124-9]\\d{2,5}|3(?:\\d{2,5}|\\d{7})",,,,,,,[3,5,6,8]
]
,,,[,,"211",,,,"211",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"CA",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"911",,,[3]
]
,,[,,"1(?:12|\\d{4,5})|[25-9](?:11|\\d{4,5})|3(?:\\d{4,5}|0000\\d{3}|11)|411",,,,"12345"]
,[,,,,,,,,,[-1]
]
,[,,"[23567]11",,,,"611",,,[3]
]
,,[,,"[125-9]\\d{4,5}|3(?:\\d{4,5}|0000\\d{3})",,,,"30001",,,[5,6,8]
]
]
,"CC":[,[,,"[01]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CC",,,,,,,,,,,,,,,,,,[,,"000|112",,,,"112"]
,,[,,"000|112",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CD":[,[,,"[14]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CD",,,,,,,,,,,,,,,,,,[,,"1(?:1[348]|77|88)",,,,"113",,,[3]
]
,,[,,"1(?:1[348]|23|77|88)|40404",,,,"40404"]
,[,,,,,,,,,[-1]
]
,[,,"40404",,,,"40404",,,[5]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"CF":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CF",,,,,,,,,,,,,,,,,,[,,"1(?:1[78]|220)",,,,"1220"]
,,[,,"1(?:1[478]|220)",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CG":[,[,,"11\\d",,,,,,,[3]
]
,,,[,,"111",,,,"111"]
,[,,,,,,,,,[-1]
]
,,,,"CG",,,,,,,,,,,,,,,,,,[,,"11[78]",,,,"117"]
,,[,,"11[12678]",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CH":[,[,,"[1-9]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:16\\d{3}|47)|5200",,,,"116000",,,[3,4,6]
]
,[,,"1(?:145|8\\d{2})|543|83111",,,,"543",,,[3,4,5]
]
,,,,"CH",,,,,,,,,,,,,,,,,,[,,"1(?:1[278]|44)",,,,"112",,,[3]
]
,,[,,"1(?:0[78]\\d{2}|1(?:[278]|45|6(?:000|111))|4(?:[03457]|1[45])|6(?:00|[1-46])|8(?:02|1[189]|50|7|8[08]|99))|[2-9]\\d{2,4}",,,,"147"]
,[,,"1(?:4(?:[035]|1\\d)|6\\d{1,2})",,,,"1600",,,[3,4]
]
,[,,"5(?:200|35)",,,,"535",,,[3,4]
]
,,[,,"[2-9]\\d{2,4}",,,,"600",,,[3,4,5]
]
]
,"CI":[,[,,"[14]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CI",,,,,,,,,,,,,,,,,,[,,"1(?:1[01]|[78]0)",,,,"110",,,[3]
]
,,[,,"1(?:1[01]|[78]0)|4443",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,"4443",,,,"4443",,,[4]
]
,,[,,"4443",,,,"4443",,,[4]
]
]
,"CK":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CK",,,,,,,,,,,,,,,,,,[,,"99[689]",,,,"998"]
,,[,,"99[689]",,,,"998"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CL":[,[,,"[1-9]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1213|4342",,,,"4342",,,[4]
]
,[,,"1(?:060|211|3(?:13|[348]0|5[01])|417|560|818|9(?:19|80))|2(?:0122|22[47]|323|777|882)|3(?:0(?:51|99)|132|3(?:29|77|90)|665)|4(?:142|243|3656|4(?:02|15|77)|554)|5(?:004|4154|5(?:66|77)|995)|6(?:0700|131|222|3(?:00|66)|500|699)|7878|8(?:011|11[28]|482|889)|9(?:011|[12]00|330)",,,,"2224",,,[4,5]
]
,,,,"CL",,,,,,,,,,,,,,,,,,[,,"13[123]|911",,,,"133",,,[3]
]
,,[,,"1(?:06?0|21[13]|3(?:[02679]|13?|[348]0?|5[01]?)|4(?:0[02-6]|17|[379])|560|818|9(?:19|80))|2(?:0(?:01|122)|22[47]|323|777|882)|3(?:0(?:51|99)|132|3(?:29|37|77|90)|665)|4(?:142|243|3(?:42|656)|4(?:02|15|77)|554)|5(?:004|4154|5(?:66|77)|995)|6(?:0700|131|222|3(?:00|66)|500|699)|7878|8(?:011|11[28]|482|889)|9(?:011|1(?:1|00)|200|330)",,,,"139"]
,[,,"2001|3337",,,,"3337",,,[4]
]
,[,,,,,,,,,[-1]
]
,,[,,"(?:[137-9]|[2456]\\d?)\\d{3}",,,,"5577",,,[4,5]
]
]
,"CM":[,[,,"[18]\\d{1,3}",,,,,,,[2,3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CM",,,,,,,,,,,,,,,,,,[,,"1?1[37]",,,,"113",,,[2,3]
]
,,[,,"1?1[37]|8711",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,"8711",,,,"8711",,,[4]
]
,,[,,"8711",,,,"8711",,,[4]
]
]
,"CN":[,[,,"[19]\\d{2,5}",,,,,,,[3,5,6]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CN",,,,,,,,,,,,,,,,,,[,,"1(?:1[09]|20)",,,,"119",,,[3]
]
,,[,,"1(?:00\\d{2}|1[09]|20)|95\\d{3,4}",,,,"119"]
,[,,"100\\d{2}|95\\d{3,4}",,,,"95566",,,[5,6]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CO":[,[,,"[148]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CO",,,,,,,,,,,,,,,,,,[,,"1(?:1[29]|23|32|56)",,,,"112",,,[3]
]
,,[,,"1(?:06|1[2569]|2[357]|3[27]|4[467]|5[36]|6[45]|95)|40404|85432",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"40404|85432",,,,"40404",,,[5]
]
,,[,,"40404|85432",,,,"40404",,,[5]
]
]
,"CR":[,[,,"[1359]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CR",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"911",,,[3]
]
,,[,,"1(?:0(?:00|15|2[2-4679])|1(?:1[0-35-9]|2|37|[46]6|7[57]|8[79]|9[0-379])|2(?:00|[12]2|34|55)|3(?:21|33)|4(?:0[06]|1[4-6])|5(?:15|5[15])|693|7(?:00|1[789]|2[02]|[67]7)|975)|3855|5(?:0(?:30|49)|510)|911",,,,"1022"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"3855|5(?:0(?:30|49)|510)",,,,"3855",,,[4]
]
]
,"CU":[,[,,"1\\d{2,5}",,,,,,,[3,6]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CU",,,,,,,,,,,,,,,,,,[,,"10[456]",,,,"106",,,[3]
]
,,[,,"1(?:0[456]|1(?:6111|8)|40)",,,,"140"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CV":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CV",,,,,,,,,,,,,,,,,,[,,"13[012]",,,,"132"]
,,[,,"13[012]",,,,"132"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CW":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CW",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112"]
,,[,,"1(?:12|76)|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"CX":[,[,,"[01]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"CX",,,,,,,,,,,,,,,,,,[,,"000|112",,,,"112"]
,,[,,"000|112",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CY":[,[,,"1\\d{2,5}",,,,,,,[3,6]
]
,,,[,,"116(?:000|111)",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"CY",,,,,,,,,,,,,,,,,,[,,"1(?:12|99)",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:000|111))|99)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"CZ":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"116(?:00[06]|111|123)",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"CZ",,,,,,,,,,,,,,,,,,[,,"1(?:12|5[0568])",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6\\d{3}|8\\d)|2\\d{2,3}|3\\d{3,4}|4\\d{3}|5[0568]|99)",,,,"116123"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DE":[,[,,"1\\d{2,5}",,,,,,,[3,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"DE",,,,,,,,,,,,,,,,,,[,,"11[02]",,,,"112",,,[3]
]
,,[,,"11(?:[025]|6(?:00[06]|1(?:1[17]|23)))",,,,"115"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DJ":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"DJ",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17"]
,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DK":[,[,,"1\\d{2,5}",,,,,,,[3,4,6]
]
,,,[,,"116(?:00[06]|111)",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"DK",,,,,,,,,,,,,,,,,,[,,"11[24]",,,,"112",,,[3]
]
,,[,,"1(?:1(?:[2-48]|6(?:00[06]|111))|8(?:01|1[0238]|28|30|5[13]|81))",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DM":[,[,,"[39]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"DM",,,,,,,,,,,,,,,,,,[,,"333|9(?:11|99)",,,,"999"]
,,[,,"333|9(?:11|99)",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DO":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"DO",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112"]
,,[,,"112|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"DZ":[,[,,"[17]\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"DZ",,,,,,,,,,,,,,,,,,[,,"1[47]",,,,"17",,,[2]
]
,,[,,"1[47]|730",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,"730",,,,"730",,,[3]
]
,,[,,"730",,,,"730",,,[3]
]
]
,"EC":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"EC",,,,,,,,,,,,,,,,,,[,,"1(?:0[12]|12)|911",,,,"911"]
,,[,,"1(?:0[12]|12)|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"EE":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:1(?:[02]|6(?:000|111))|2(?:05|28)|3(?:014|3(?:21|5)|660)|492|5(?:1[03]|410|501)|6(?:112|333|644)|7(?:012|127|89)|8(?:10|8[57])|9(?:0[134]|14))",,,,"116000"]
,[,,"1(?:18(?:[12458]|00)|2(?:0(?:[02-46-8]|1[0-36])|1(?:[0-4]|6[06])|2(?:[0-4]|5[25])|[367]|4(?:0[04]|[12]|4[24]|54)|55[12457])|3(?:0(?:[02]|1[13578]|3[356])|1[1347]|2[02-5]|3(?:[01347]|2[023]|88)|4(?:[35]|4[34])|5(?:3[134]|5[035])|666)|4(?:2(?:00|4)|4(?:0[01358]|1[024]|50|7)|900)|5(?:0[0-35]|1(?:[1267]|5[0-7]|82)|2(?:[014-6]|22)|330|4(?:[35]|44)|5(?:00|[1-69])|9(?:[159]|[38]0|77))|6(?:1(?:00|1[19]|[356-9])|2(?:2[26]|[68])|3(?:22|36|6[36])|5|6(?:[0-359]|6[0-26])|7(?:00|55|7|8[89])|9(?:00|1|69))|7(?:0(?:[023]|1[0578])|1(?:00|2[034]|[4-9])|2(?:[07]|20|44)|7(?:[0-57]|9[79])|8(?:0[08]|2|8[0178])|9(?:00|97))|8(?:1[127]|8[1268]|9[269])|9(?:0(?:[02]|69|9[0269])|1[123689]|21))",,,,"1182",,,[3,4,5]
]
,,,,"EE",,,,,,,,,,,,,,,,,,[,,"11[02]",,,,"112",,,[3]
]
,,[,,"1(?:1(?:[02-579]|6(?:000|111)|8(?:[09]\\d|[1-8]))|2(?:[0-245]\\d{1,2}|[36-9])|3(?:[0-6]\\d{1,2}|[7-9])|4(?:[1-489]\\d{1,2}|[05-7])|5(?:[0-59]\\d{1,2}|[6-8])|6(?:[05]|[1-46-9]\\d{1,2})|7(?:[0-27-9]\\d{1,2}|[3-6])|8(?:[02-7]|[189]\\d{1,2})|9(?:[0-2]\\d{1,2}|[3-9]))",,,,"115"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"1(?:18[1258]|2(?:0(?:1[036]|[46])|166|21|4(?:0[04]|1|5[47])|[67])|3(?:0(?:1[13-578]|2|3[56])|1[15]|2[045]|3(?:[13]|2[13])|43|5(?:00|3[34]|53))|44(?:0[0135]|14|50|7)|5(?:05|1(?:[12]|5[1246]|8[12])|2(?:[01]|22)|3(?:00|3[03])|4(?:15|5)|500|9(?:5|77|80))|6(?:1[35-8]|226|3(?:22|3[36]|66)|644|7(?:00|7|89)|9(?:00|69))|7(?:01[258]|1(?:00|[15])|2(?:44|7)|8(?:00|87|9))|8(?:1[128]|8[56]|9(?:[26]|77))|90(?:2|69|92))",,,,"13500",,,[3,4,5]
]
]
,"EG":[,[,,"[13]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"EG",,,,,,,,,,,,,,,,,,[,,"1(?:2[23]|80)",,,,"122",,,[3]
]
,,[,,"1(?:2[23]|[69]\\d{3}|80)|34400",,,,"122"]
,[,,,,,,,,,[-1]
]
,[,,"34400",,,,"34400",,,[5]
]
,,[,,"34400",,,,"34400",,,[5]
]
]
,"EH":[,[,,"1\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"EH",,,,,,,,,,,,,,,,,,[,,"1(?:[59]|77)",,,,"15"]
,,[,,"1(?:[59]|77)",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ER":[,[,,"[12]\\d{2,5}",,,,,,,[3,6]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"ER",,,,,,,,,,,,,,,,,,[,,"1(?:1[2-46]|2(?:4422|7799))|2(?:0(?:1(?:606|917)|2(?:099|914)))",,,,"113"]
,,[,,"1(?:1[2-6]|2(?:4422|7799))|2(?:0(?:1(?:606|917)|2(?:099|914)))",,,,"114"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ES":[,[,,"[0-379]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"0(?:16|6[57]|88)|1(?:006|16\\d{3}|[3-7]\\d{2})|20\\d{4}",,,,"116111",,,[3,4,6]
]
,[,,"1(?:18\\d{2}|2\\d{1,4})|2(?:2\\d{1,4}|[3-9]\\d{3,4})|9(?:0(?:5[124578]|7)|\\d{4,5})|[37]\\d{4,5}",,,,"23456"]
,,,,"ES",,,,,,,,,,,,,,,,,,[,,"08[58]|112",,,,"112",,,[3]
]
,,[,,"0(?:1[0-26]|6[0-257]|8[058]|9[12])|1(?:0[03-57]\\d{1,3}|1(?:2|6(?:000|111)|8\\d{2})|2\\d{1,4}|3(?:[34]|\\d{2})|7(?:7|\\d{2})|[4-689]\\d{2})|2(?:[01]\\d{4}|2\\d{1,4}|[357]\\d{3}|80\\d{2})|3[357]\\d{3}|79[57]\\d{3}|9(?:0(?:5[124578]|7)|9[57]\\d{3})",,,,"010"]
,[,,"0(?:[16][0-2]|80|9[12])|21\\d{4}",,,,"211234",,,[3,6]
]
,[,,"1(?:2\\d{1,4}|3[34]|77)|22\\d{1,4}",,,,"123"]
,,[,,"[2379]\\d{4,5}",,,,"23456",,,[5,6]
]
]
,"ET":[,[,,"9\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"ET",,,,,,,,,,,,,,,,,,[,,"9(?:11?|[23]|9[17])",,,,"991"]
,,[,,"9(?:11?|[23]|9[17])",,,,"991"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"FI":[,[,,"1\\d{2,5}|75[12]\\d{2}",,,,,,,[3,5,6]
]
,,,[,,"116111",,,,"116111",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"FI",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"11(?:2|6111)|75[12]\\d{2}",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"FJ":[,[,,"[0-579]\\d{1,4}",,,,,,,[2,3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"FJ",,,,,,,,,,,,,,,,,,[,,"91[17]",,,,"911",,,[3]
]
,,[,,"0(?:1[34]|8[1-4])|1(?:0[1-3]|[25]9)|2[289]|30|4(?:0404|4)|54|75|91[137]",,,,"22"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"FK":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"FK",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"1\\d{2}|999",,,,"123"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"FM":[,[,,"3\\d{5}|9\\d{2}",,,,,,,[3,6]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"FM",,,,,,,,,,,,,,,,,,[,,"320221|911",,,,"911"]
,,[,,"320221|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"FO":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"FO",,,,,,,,,,,,,,,,,,[,,"11[24]",,,,"112",,,[3]
]
,,[,,"1(?:1[248]|4[124]\\d|71\\d|8[7-9]\\d)",,,,"114"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"FR":[,[,,"1\\d{1,5}|[267]\\d{2,4}|3\\d{3,4}|[458]\\d{4}",,,,,,,[2,3,4,5,6]
]
,,,[,,"1(?:0(?:07|13)|1(?:[0459]|[68]\\d{3})|9[167])|224|3(?:[01]\\d{2}|3700)|740",,,,"3010",,,[3,4,5,6]
]
,[,,"36665|[4-8]\\d{4}",,,,"42000",,,[5]
]
,,,,"FR",,,,,,,,,,,,,,,,,,[,,"1(?:[578]|12)",,,,"112",,,[2,3]
]
,,[,,"1(?:0\\d{2}|1(?:[02459]|6(?:000|111)|8\\d{3})|9[167]|[578])|2(?:0(?:000|20)|24)|3\\d{3,4}|6(?:1[14]|34|\\d{4})|7(?:0[06]|22|40|\\d{4})|[458]\\d{4}",,,,"1010"]
,[,,"10(?:14|2[23]|34|6[14]|99)|2020|3(?:646|9[07]0)|6(?:1[14]|34)|70[06]",,,,"1023",,,[3,4]
]
,[,,"118777|2(?:0(?:000|20)|24)|6(?:1[14]|34)|7\\d{2}",,,,"118777",,,[3,4,5,6]
]
,,[,,"(?:114|[3-8]\\d{4})",,,,"33700",,,[3,5]
]
]
,"GA":[,[,,"1\\d{1,3}",,,,,,,[2,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GA",,,,,,,,,,,,,,,,,,[,,"1(?:730|8|3\\d{2})",,,,"1730"]
,,[,,"1(?:730|8|3\\d{2})",,,,"1730"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GB":[,[,,"[1-467-9]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:05|16\\d{3}|7[56]0|8000)|2(?:202|48)|4444",,,,"116000"]
,[,,,,,,,,,[-1]
]
,,,,"GB",,,,,,,,,,,,,,,,,,[,,"112|999",,,,"112",,,[3]
]
,,[,,"1(?:0[015]|1(?:[12]|6(?:000|1(?:11|23))|8\\d{3})|2(?:[123]|50)|33|4(?:1|7\\d)|5(?:\\d|71)|7(?:0\\d|[56]0)|800\\d|9[15])|2(?:02(?:02)?|1300|2(?:02|11|2)|3(?:02|336|45)|4(?:25|8))|3[13]3|4(?:0[02]|35[01]|44[45]|5\\d)|6(?:50|\\d{4})|7(?:0\\d{3}|8(?:9|\\d{3})|9\\d{3})|8\\d{4}|9(?:01|99)",,,,"150"]
,[,,,,,,,,,[-1]
]
,[,,"1(?:250|571|7[56]0)|2(?:02(?:02)?|1300|3336|48)|4444|901",,,,"1571",,,[3,4,5]
]
,,[,,"1250|2(?:0202|1300)|7\\d{4}|8[01]\\d{3}",,,,"20202",,,[4,5]
]
]
,"GD":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GD",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"GE":[,[,,"[041]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GE",,,,,,,,,,,,,,,,,,[,,"0(?:11|22|33)|1(?:1[123]|22)",,,,"112",,,[3]
]
,,[,,"0(?:11|22|33)|1(?:1[123]|22)|40404",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"40404",,,,"40404",,,[5]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"GF":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GF",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"15"]
,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GG":[,[,,"[19]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GG",,,,,,,,,,,,,,,,,,[,,"112|999",,,,"999",,,[3]
]
,,[,,"1(?:0[01]|1(?:[12]|[68]\\d{3})|23|4(?:1|7\\d)|55|800\\d|9[05])|999",,,,"155"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GH":[,[,,"[14589]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GH",,,,,,,,,,,,,,,,,,[,,"19[123]|999",,,,"999",,,[3]
]
,,[,,"19[123]|40404|(?:54|83)00|999",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,"40404|(?:54|83)00",,,,"5400",,,[4,5]
]
,,[,,"40404|(?:54|83)00",,,,"5400",,,[4,5]
]
]
,"GI":[,[,,"[158]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1(?:00|16\\d{3}|23|4(?:1|7\\d)|5[15]|9[2-4])|555|80\\d{2}",,,,"100",,,[3,4,6]
]
,[,,"8[1-69]\\d{2}",,,,"8112",,,[4]
]
,,,,"GI",,,,,,,,,,,,,,,,,,[,,"1(?:12|9[09])",,,,"112",,,[3]
]
,,[,,"1(?:00|1(?:2|6(?:00[06]|1(?:1[17]|23))|8\\d{2})|23|4(?:1|7[014])|5[015]|9[02349])|555|8(?:0(?:0|\\d{2})|[1-35-79]\\d{2}|4(?:[0-2]|\\d{2})|8[1-589])",,,,"116000"]
,[,,"150|87\\d{2}",,,,"150",,,[3,4]
]
,[,,"1(?:18\\d{2}|23|51|9[2-4])|555|8(?:00|88)",,,,"123",,,[3,5]
]
,,[,,,,,,,,,[-1]
]
]
,"GL":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GL",,,,,,,,,,,,,,,,,,[,,"112",,,,"112"]
,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GM":[,[,,"1\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GM",,,,,,,,,,,,,,,,,,[,,"1?1[678]",,,,"117"]
,,[,,"1?1[678]",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GN":[,[,,"4\\d{4}",,,,,,,[5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GN",,,,,,,,,,,,,,,,,,[,,,,,,,,,[-1]
]
,,[,,"40404",,,,"40404"]
,[,,,,,,,,,[-1]
]
,[,,"40404",,,,"40404"]
,,[,,"40404",,,,"40404"]
]
,"GP":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GP",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"18"]
,,[,,"1[578]",,,,"18"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GR":[,[,,"1\\d{2,5}",,,,,,,[3,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"GR",,,,,,,,,,,,,,,,,,[,,"1(?:00|12|66|99)",,,,"112",,,[3]
]
,,[,,"1(?:00|1(?:2|6(?:000|1(?:11|23)))|66|99)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GT":[,[,,"[14]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GT",,,,,,,,,,,,,,,,,,[,,"1(?:10|2[03])",,,,"110",,,[3]
]
,,[,,"1(?:10|2\\d|[57]\\d{2})|40404",,,,"123"]
,[,,,,,,,,,[-1]
]
,[,,"40404",,,,"40404",,,[5]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"GU":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GU",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GW":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GW",,,,,,,,,,,,,,,,,,[,,"11[378]",,,,"113"]
,,[,,"11[378]",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"GY":[,[,,"[019]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"GY",,,,,,,,,,,,,,,,,,[,,"91[123]",,,,"911",,,[3]
]
,,[,,"0(?:02|171|444|7(?:[67]7|9)|801|9(?:0[78]|[2-47]))|1(?:443|5[568])|91[123]",,,,"0801"]
,[,,,,,,,,,[-1]
]
,[,,"1443",,,,"1443",,,[4]
]
,,[,,"1443",,,,"1443",,,[4]
]
]
,"HK":[,[,,"[19]\\d{2,6}",,,,,,,[3,4,5,6,7]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"HK",,,,,,,,,,,,,,,,,,[,,"112|99[29]",,,,"999",,,[3]
]
,,[,,"1(?:0(?:[0136]\\d{0,4}|2[14]\\d{0,3}|8[138]|9)|12|2(?:[0-3]\\d{0,4}|58\\d{0,3}|8[13]\\d{0,3})|7(?:[135-9]\\d{0,4}|21[89]\\d{0,2}|421\\d{0,2})|8(?:0(?:[13]\\d|60\\d{2}|8)|1(?:0\\d|[2-8])|2(?:0[5-9]|182|22|3|8[128])|3\\d{4}|4(?:1[1-5]|[23]1|6[12])|50[138]|6(?:000|1(?:[13]1|86)|8)|7(?:13|2[1-389]|8[0235-9]|93)\\d{2}|8\\d))|99[29]",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,"1(?:0(?:8\\d|9)|850\\d)",,,,"1088",,,[3,4,5]
]
,,[,,"992",,,,"992",,,[3]
]
]
,"HN":[,[,,"[14]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"HN",,,,,,,,,,,,,,,,,,[,,"199",,,,"199",,,[3]
]
,,[,,"199|40404",,,,"199"]
,[,,,,,,,,,[-1]
]
,[,,"40404",,,,"40404",,,[5]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"HR":[,[,,"[19]\\d{1,5}",,,,,,,[2,3,4,5,6]
]
,,,[,,"1(?:16\\d{3}|3977)",,,,"116000",,,[5,6]
]
,[,,"118\\d{2}",,,,"11812",,,[5]
]
,,,,"HR",,,,,,,,,,,,,,,,,,[,,"1(?:12|9[2-4])|9[34]",,,,"112",,,[2,3]
]
,,[,,"1(?:1(?:2|6(?:00[06]|1(?:1[17]|23))|8\\d{2})|3977|9(?:[2-5]|87))|9[34]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"13977",,,,"13977",,,[5]
]
,,[,,"13977",,,,"13977",,,[5]
]
]
,"HT":[,[,,"[14]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"HT",,,,,,,,,,,,,,,,,,[,,"11[48]",,,,"118",,,[3]
]
,,[,,"11[48]|40404",,,,"114"]
,[,,,,,,,,,[-1]
]
,[,,"40404",,,,"40404",,,[5]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"HU":[,[,,"1\\d{2,5}",,,,,,,[3,6]
]
,,,[,,"116(?:000|1(?:11|23))",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"HU",,,,,,,,,,,,,,,,,,[,,"1(?:0[457]|12)",,,,"112",,,[3]
]
,,[,,"1(?:0[457]|1(?:2|6(?:000|1(?:11|23))))",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ID":[,[,,"[178]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"ID",,,,,,,,,,,,,,,,,,[,,"11[02389]",,,,"112",,,[3]
]
,,[,,"1(?:1[02389]|40\\d{2})|71400|89887",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"71400|89887",,,,"71400",,,[5]
]
,,[,,"71400",,,,"71400",,,[5]
]
]
,"IE":[,[,,"[159]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,"5[37]\\d{3}",,,,"53012",,,[5]
]
,,,,"IE",,,,,,,,,,,,,,,,,,[,,"112|999",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:00[06]|1(?:1[17]|23))|8\\d{2})|9\\d{2})|5[0137]\\d{3}|999",,,,"112"]
,[,,"51\\d{3}",,,,"51012",,,[5]
]
,[,,"51210",,,,"51210",,,[5]
]
,,[,,"118\\d{2}|5(?:[037]\\d{3}|1210)",,,,"51210",,,[5]
]
]
,"IL":[,[,,"1\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"IL",,,,,,,,,,,,,,,,,,[,,"1(?:0[012]|12)",,,,"112",,,[3]
]
,,[,,"1(?:0(?:[012]|400)|1(?:[013-9]\\d|2)|[2-9]\\d{2})",,,,"1455"]
,[,,,,,,,,,[-1]
]
,[,,"10400",,,,"10400",,,[5]
]
,,[,,"10400",,,,"10400",,,[5]
]
]
,"IM":[,[,,"[189]\\d{2,5}",,,,,,,[3,5,6]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"IM",,,,,,,,,,,,,,,,,,[,,"999",,,,"999",,,[3]
]
,,[,,"1\\d{2}(?:\\d{3})?|8(?:6444|9887)|999",,,,"150"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"8(?:6444|9887)",,,,"86444",,,[5]
]
]
,"IN":[,[,,"[12578]\\d{2,8}",,,,,,,[3,4,5,6,7,8,9]
]
,,,[,,"1\\d{2,5}|777|800",,,,"105010",,,[3,4,5,6]
]
,[,,"11[67][0-2]\\d{3}|56161561",,,,"1160530",,,[7,8]
]
,,,,"IN",,,,,,,,,,,,,,,,,,[,,"1(?:0[0128]|12|298)|2611",,,,"108",,,[3,4]
]
,,[,,"1(?:0(?:[01248]|3[39]|5(?:010|6|[79]\\d{2})|6[3468]|7(?:[013578]|20?|4[01]|80)|9[0135-9])|1(?:00|[289]|[67][0-2]\\d{3})|2(?:1|98)|3(?:11|2[0-2]|63|[89])|4[01]|5(?:1(?:0[0-36]|[127])|5(?:[23]\\d{2}|4))|6(?:1|6[01]?)|7000|8(?:02\\d{3}|[12])|9(?:0[013-59]|12|25|4[4-9]\\d?|50|6[1347]|[89]))|2611|5(?:0(?:0(?:0\\d{1}(?:\\d{2})?|1(?:\\d{2})?|20?)|325|40\\d{1,2}|5(?:0\\d{1,4}|1\\d{2,5}|[2-79]\\d{3,5}))|1(?:0[12]\\d|234|4[2-4]\\d|555|717|818|96[49])|2(?:0(?:0[01]|[14]0)|151|2(?:[0267]\\d{1,2}|1\\d{1,4}|[3589]\\d)|3(?:1(?:\\d{1,2}|\\d{4})|2\\d|6\\d{1,2})|4[04]\\d|555|666|7[78]\\d|888|9(?:06|99\\d?))|3(?:0(?:[01]0|3\\d{1,4}|4\\d{4})|131|3[23]\\d{1,4}|553|666|776)|4(?:04|1[04]\\d?|2(?:0\\d?|4)|3(?:0\\d?|2(?:\\d|\\d{4})?)|4[04]|64(?:\\d{1,2})?|99)\\d|5(?:1[25]|3(?:[16]\\d?|5)|4[45]|5[05](?:\\d{1,2})?|6(?:5|7\\d?)|93)\\d|6(?:0(?:6\\d{1,2}|70)|16\\d{4}|3[68]|43|[67]\\d{2,3})|7(?:17(?:\\d{3})?|[27]7|57\\d{2}|8(?:7\\d?|8))\\d|8(?:3[4-69]|4[01]|5[58]|8(?:0\\d?|8(?:8\\d{2}|9))|99)\\d|9(?:00|55|6(?:4\\d?|[67])|77|88|90\\d?)\\d)|777|800",,,,"108"]
,[,,"5(?:14(?:2[5-9]|[34]\\d)|757555)",,,,"5757555",,,[5,7]
]
,[,,"1(?:1(?:[67][0-2]\\d{3}|[89])|21|4[01]|55330|7\\d{3}|9(?:[89]|09))|5(?:3000|6161(?:17[89]|561))",,,,"53000",,,[3,4,5,6,7,8]
]
,,[,,"1(?:39|90[019])|5(?:14(?:2[5-9]|[34]\\d)|6161(?:17[89]|561)|757555)",,,,"51431",,,[3,4,5,7,8]
]
]
,"IQ":[,[,,"[1479]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"IQ",,,,,,,,,,,,,,,,,,[,,"1(?:0[04]|15|22)",,,,"122",,,[3]
]
,,[,,"1(?:0[04]|15|22)|4432|71117|9988",,,,"4432"]
,[,,,,,,,,,[-1]
]
,[,,"4432|71117|9988",,,,"4432",,,[4,5]
]
,,[,,"4432|71117|9988",,,,"4432",,,[4,5]
]
]
,"IR":[,[,,"[0-29]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"1[129]\\d",,,,"123",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"IR",,,,,,,,,,,,,,,,,,[,,"1(?:1[025]|25)|911",,,,"112",,,[3]
]
,,[,,"096(?:0[12]|2[16-8]|3(?:08|[14]5|[23]|66)|4(?:0|80)|5[01]|6[89]|86|9[19])|1(?:1[0-68]|2[0-59]|3[346-8]|4(?:[0147]|[289]0)|5(?:0[14]|1[02479]|2[0-3]|39|[49]0|65)|6(?:[16]6|[27]|90)|8(?:03|1[18]|22|3[37]|4[28]|88|99)|9[0-579])|20(?:00|1(?:[038]|1[079]|26|9[69])|2[01]|90)|9(?:11|9(?:90|0009))",,,,"112"]
,[,,"(?:096|1[58])\\d{2}",,,,"09612",,,[4,5]
]
,[,,"1[58]\\d{2}|99(?:90|0009)",,,,"9990",,,[4,6]
]
,,[,,"990009",,,,"990009",,,[6]
]
]
,"IS":[,[,,"1\\d{2,5}",,,,,,,[3,4,6]
]
,,,[,,"1717",,,,"1717",,,[4]
]
,[,,,,,,,,,[-1]
]
,,,,"IS",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"1(?:1(?:[28]|6(?:1(?:23|16)))|4(?:00|1[145]|4[0146])|55|7(?:00|17|7[07-9])|8(?:[02]0|1[16-9]|88)|900)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"14(?:00|41)",,,,"1441",,,[4]
]
,,[,,"1(?:415|900)",,,,"1415",,,[4]
]
]
,"IT":[,[,,"[14]\\d{2,6}",,,,,,,[3,4,5,6,7]
]
,,,[,,"1(?:16\\d{3}|87)",,,,"187",,,[3,6]
]
,[,,"(?:12|4(?:[478]\\d{1,3}|55))\\d{2}",,,,"1254",,,[4,5,6,7]
]
,,,,"IT",,,,,,,,,,,,,,,,,,[,,"11[2358]",,,,"112",,,[3]
]
,,[,,"1(?:0\\d{2,3}|1(?:[2-5789]|6(?:000|111))|2\\d{2}|3[39]|4(?:82|9\\d{1,3})|5(?:00|1[58]|2[25]|3[03]|44|[59])|60|8[67]|9(?:[01]|2(?:[01]\\d{2}|[2-9])|4\\d|696))|4(?:2323|3(?:[01]|[45]\\d{2})\\d{2}|[478](?:[0-4]|[5-9]\\d{2})\\d{2}|5(?:045|5\\d{2}))",,,,"114"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"4[3-578]\\d{3,5}",,,,"43000",,,[5,6,7]
]
]
,"JE":[,[,,"[129]\\d{2,5}",,,,,,,[3,4,6]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"JE",,,,,,,,,,,,,,,,,,[,,"112|999",,,,"999",,,[3]
]
,,[,,"1(?:00|1(?:2|8\\d{3})|23|4(?:[14]|28|7\\d)|5\\d|7(?:0[12]|[128]|35?)|808|9[0135])|23[234]|999",,,,"150"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"JM":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"JM",,,,,,,,,,,,,,,,,,[,,"11[029]|911",,,,"112"]
,,[,,"1(?:1[029]|76)|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,"176",,,,"176"]
,,[,,"176",,,,"176"]
]
,"JO":[,[,,"[19]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"JO",,,,,,,,,,,,,,,,,,[,,"1(?:12|9[127])|911",,,,"112",,,[3]
]
,,[,,"1(?:09|1[0-2]|9[0-24-79])|9(?:0903|11|8788)",,,,"111"]
,[,,,,,,,,,[-1]
]
,[,,"9(?:0903|8788)",,,,"90903",,,[5]
]
,,[,,"9(?:0903|8788)",,,,"90903",,,[5]
]
]
,"JP":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"JP",,,,,,,,,,,,,,,,,,[,,"11[09]",,,,"110"]
,,[,,"11[09]",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KE":[,[,,"[1-9]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:1(?:6|9\\d)|5(?:01|2[127]|6(?:29|6[67])))",,,,"1501"]
,[,,"909\\d{2}",,,,"90912",,,[5]
]
,,,,"KE",,,,,,,,,,,,,,,,,,[,,"112|114|999",,,,"999",,,[3]
]
,,[,,"1(?:0(?:[07-9]|1[0-25]|400)|1(?:[02456]|9[0-579])|2[123]|3[01]|4[14]|5(?:[01][01]|2[0-24-79]|33|4[05]|5[59]|6(?:00|29|6[67]))|6[035]\\d{2}|[78]\\d|9(?:[02-9]\\d{2}|19))|(?:2[0-79]|3[0-29]|4[0-4])\\d{3}|5(?:[0-7]\\d|99)\\d{2}|(?:6[2357]|7[0-29])\\d{3}|8(?:[0-9]\\d{3}|988)|9(?:09\\d{2}|99)",,,,"116"]
,[,,,,,,,,,[-1]
]
,[,,"1(?:0400|3[01]|4[14]|5(?:1[01]|2[25])|6[35]\\d{2})|(?:2[0-79]|3[0-29]|4[0-4])\\d{3}|5(?:[0-7]\\d|99)\\d{2}|(?:6[2357]|7[0-29])\\d{3}|8(?:988|[0-9]\\d{3})|909\\d{2}",,,,"90912"]
,,[,,"1(?:0400|4[14]|5(?:01|55|6(?:29|6[67]))|6[035]\\d{2})|40404|8988|909\\d{2}",,,,"8988"]
]
,"KG":[,[,,"[14]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"KG",,,,,,,,,,,,,,,,,,[,,"10[123]",,,,"101",,,[3]
]
,,[,,"10[123]|4040",,,,"101"]
,[,,,,,,,,,[-1]
]
,[,,"4040",,,,"4040",,,[4]
]
,,[,,"4040",,,,"4040",,,[4]
]
]
,"KH":[,[,,"[146]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"KH",,,,,,,,,,,,,,,,,,[,,"11[789]|666",,,,"117",,,[3]
]
,,[,,"11[789]|40404|666",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,"40404",,,,"40404",,,[5]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"KI":[,[,,"[179]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"KI",,,,,,,,,,,,,,,,,,[,,"19[2-5]|99[2349]",,,,"192",,,[3]
]
,,[,,"1(?:0(?:[0-8]|5[01259])|88|9[2-5])|777|99[2349]",,,,"100"]
,[,,"103",,,,"103",,,[3]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KM":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"KM",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17"]
,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KN":[,[,,"[39]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"KN",,,,,,,,,,,,,,,,,,[,,"333|9(?:11|99)",,,,"999"]
,,[,,"333|9(?:11|99)",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KP":[,[,,"[18]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"KP",,,,,,,,,,,,,,,,,,[,,"1(?:12|19)|819",,,,"112"]
,,[,,"1(?:12|19)|819",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KR":[,[,,"1\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:1[78]|28|330|82)",,,,"118",,,[3,4]
]
,[,,,,,,,,,[-1]
]
,,,,"KR",,,,,,,,,,,,,,,,,,[,,"11[29]",,,,"112",,,[3]
]
,,[,,"1(?:0(?:[01]|114)|1(?:[0247-9]|114)|2[01389]|3(?:2|3[039]|45|66|88|9[18])|[679]114|8(?:114|2))",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"1(?:0(?:[01]|114)|1(?:114|4)|[6-9]114)",,,,"100",,,[3,5]
]
,,[,,,,,,,,,[-1]
]
]
,"KW":[,[,,"[18]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"KW",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"1[0-7]\\d|89887",,,,"177"]
,[,,,,,,,,,[-1]
]
,[,,"89887",,,,"89887",,,[5]
]
,,[,,,,,,,,,[-1]
]
]
,"KY":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"KY",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"KZ":[,[,,"[134]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"KZ",,,,,,,,,,,,,,,,,,[,,"1(?:0[123]|12)",,,,"112",,,[3]
]
,,[,,"1(?:0[1-4]|12)|30400|4040",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"30400|4040",,,,"30400",,,[4,5]
]
,,[,,"30400|4040",,,,"30400",,,[4,5]
]
]
,"LA":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"LA",,,,,,,,,,,,,,,,,,[,,"19[015]",,,,"190"]
,,[,,"19[015]",,,,"190"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LB":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"LB",,,,,,,,,,,,,,,,,,[,,"1(?:12|40|75)|999",,,,"112"]
,,[,,"1(?:12|40|75)|999",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LC":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"LC",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LI":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"LI",,,,,,,,,,,,,,,,,,[,,"1(?:1[278]|44)",,,,"112",,,[3]
]
,,[,,"1(?:1(?:[278]|45)|4[3-57]|50|75|81[18])",,,,"1145"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LK":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"LK",,,,,,,,,,,,,,,,,,[,,"11[02689]",,,,"119"]
,,[,,"11[024-9]",,,,"119"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LR":[,[,,"[3489]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"LR",,,,,,,,,,,,,,,,,,[,,"355|911",,,,"911",,,[3]
]
,,[,,"355|4040|8(?:400|933)|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,"4040|8(?:400|933)",,,,"8400",,,[4]
]
,,[,,"4040|8(?:400|933)",,,,"8400",,,[4]
]
]
,"LS":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"LS",,,,,,,,,,,,,,,,,,[,,"11[257]",,,,"112"]
,,[,,"11[257]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LT":[,[,,"[01]\\d{1,5}",,,,,,,[2,3,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"LT",,,,,,,,,,,,,,,,,,[,,"0(?:11?|22?|33?)|1(?:0[123]|12)",,,,"112",,,[2,3]
]
,,[,,"0(?:11?|22?|33?)|1(?:0[123]|1(?:2|6(?:000|1(?:11|23))))",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LU":[,[,,"1\\d{2,5}",,,,,,,[3,5,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"LU",,,,,,,,,,,,,,,,,,[,,"11[23]",,,,"112",,,[3]
]
,,[,,"1(?:1(?:[23]|6(?:000|111))|2\\d{3})",,,,"12123"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"LV":[,[,,"0\\d|1\\d{2,6}|8\\d{3,4}",,,,,,,[2,3,4,5,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,"1180|8(?:2\\d{3}|[89]\\d{2})",,,,"1180",,,[4,5]
]
,,,,"LV",,,,,,,,,,,,,,,,,,[,,"0[123]|11[023]",,,,"112",,,[2,3]
]
,,[,,"0[1-4]|1(?:1(?:[02-4]|6(?:000|111)|8[0189])|55|655|77)|821[57]4",,,,"112"]
,[,,"1181",,,,"1181",,,[4]
]
,[,,"16\\d{2}",,,,"1655",,,[4]
]
,,[,,,,,,,,,[-1]
]
]
,"LY":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"LY",,,,,,,,,,,,,,,,,,[,,"19[013]",,,,"193"]
,,[,,"19[013]",,,,"193"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MA":[,[,,"1\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MA",,,,,,,,,,,,,,,,,,[,,"1(?:[59]|77)",,,,"15"]
,,[,,"1(?:[59]|77)",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MC":[,[,,"1\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MC",,,,,,,,,,,,,,,,,,[,,"1(?:12|[578])",,,,"112"]
,,[,,"1(?:12|41|[578])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MD":[,[,,"[19]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"MD",,,,,,,,,,,,,,,,,,[,,"112|90[1-3]",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:000|1(?:11|23))|8\\d{1,2}|99)|4\\d{3}|6[0-389]\\d|9(?:0[04-9]|[1-4]\\d))|90[1-3]",,,,"116000"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ME":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"ME",,,,,,,,,,,,,,,,,,[,,"1(?:12|2[234])",,,,"112",,,[3]
]
,,[,,"1(?:[03]\\d{2}|1(?:[013-57-9]\\d|2|6\\d{3})|2\\d{1,3}|4\\d{2,3}|5(?:\\d{2}|999)|60[06]|700|8(?:0[089]|1[0-8]|888)|9\\d{3})",,,,"1011"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MF":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MF",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"18"]
,,[,,"1[578]",,,,"18"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MG":[,[,,"1\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MG",,,,,,,,,,,,,,,,,,[,,"11?[78]",,,,"117"]
,,[,,"11?[78]",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MH":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MH",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MK":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MK",,,,,,,,,,,,,,,,,,[,,"1(?:12|9[234])",,,,"112"]
,,[,,"1(?:12|9[234])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ML":[,[,,"[13678]\\d{1,4}",,,,,,,[2,3,4,5]
]
,,,[,,"35200|67(?:00|77)|74(?:02|44)|8000[12]",,,,"35200",,,[4,5]
]
,[,,"122[13]|3(?:52(?:11|2[02]|3[04-6]|99)|7574)|8002[12]",,,,"35211",,,[4,5]
]
,,,,"ML",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"17",,,[2]
]
,,[,,"1(?:1(?:2|[013-9]\\d)|2(?:1[02-469]|2[13])|[578])|3(?:5(?:0(?:35|57)|2\\d{2})|[67]\\d{3})|67(?:0[09]|59|77|8[89]|99)|74(?:0[02]|44|55)|800[012][12]",,,,"1210"]
,[,,"37(?:433|575)|7400|8001[12]",,,,"7400",,,[4,5]
]
,[,,"3(?:5035|[67]\\d{3})|800[012][12]",,,,"35035",,,[5]
]
,,[,,"3(?:6\\d{3}|7(?:4(?:0[24-9]|[1-9]\\d)|5\\d{2}))|7400",,,,"37575",,,[4,5]
]
]
,"MM":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MM",,,,,,,,,,,,,,,,,,[,,"199",,,,"199"]
,,[,,"199",,,,"199"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MN":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MN",,,,,,,,,,,,,,,,,,[,,"10[0-3]",,,,"102"]
,,[,,"10[0-3]",,,,"102"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MO":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MO",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MP":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MP",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MQ":[,[,,"1\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MQ",,,,,,,,,,,,,,,,,,[,,"1(?:12|[578])",,,,"15"]
,,[,,"1(?:12|[578])",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MR":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MR",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17"]
,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MS":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MS",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MT":[,[,,"1\\d{2,5}",,,,,,,[3,6]
]
,,,[,,"116(?:000|1(?:11|23))",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"MT",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"11(?:2|6(?:000|1(?:11|23)))",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MU":[,[,,"[189]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MU",,,,,,,,,,,,,,,,,,[,,"11[45]|99[59]",,,,"999",,,[3]
]
,,[,,"1\\d{2,4}|8\\d{3}|99\\d",,,,"995"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MV":[,[,,"[14]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MV",,,,,,,,,,,,,,,,,,[,,"1(?:02|1[89])",,,,"102",,,[3]
]
,,[,,"1(?:[0-37-9]\\d|[45](?:1|\\d{2})|6\\d{2})|4040",,,,"123"]
,[,,,,,,,,,[-1]
]
,[,,"1[45]1",,,,"141",,,[3]
]
,,[,,,,,,,,,[-1]
]
]
,"MW":[,[,,"[189]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MW",,,,,,,,,,,,,,,,,,[,,"199|99[789]",,,,"997",,,[3]
]
,,[,,"199|80400|99[789]",,,,"997"]
,[,,,,,,,,,[-1]
]
,[,,"80400",,,,"80400",,,[5]
]
,,[,,"80400",,,,"80400",,,[5]
]
]
,"MX":[,[,,"[0579]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,"53053|7766",,,,"7766",,,[4,5]
]
,,,,"MX",,,,,,,,,,,,,,,,,,[,,"0(?:6[0568]|80)|911",,,,"066",,,[3]
]
,,[,,"0(?:[249]0|3[01]|5[015]|6[01568]|7[0-578]|8[089])|53053|7766|911",,,,"030"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"MY":[,[,,"[139]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MY",,,,,,,,,,,,,,,,,,[,,"112|999",,,,"999",,,[3]
]
,,[,,"1(?:0(?:[01348]|[569]\\d)|1(?:[02]|1[128]|311)|2(?:0[125]|[13-6]|2\\d{0,2})|3(?:09\\d|[1-39]\\d{1,2}|6|[5-7]\\d{0,2})|5(?:[12]\\d|454|5\\d{1,2}|77|888|999?)|7(?:[136-9]\\d|[45]\\d{1,2})|8(?:18?|2|8[18])|9(?:[03]\\d|[124]\\d?|68|71|9[0679]))|3[23679]\\d{3}|99[1-469]",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"3[23679]\\d{3}",,,,"36000",,,[5]
]
]
,"MZ":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"MZ",,,,,,,,,,,,,,,,,,[,,"1(?:1[79]|9[78])",,,,"119",,,[3]
]
,,[,,"1(?:[02-5]\\d{2}|1[79]|9[78])",,,,"1011"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NA":[,[,,"[19]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"NA",,,,,,,,,,,,,,,,,,[,,"10111",,,,"10111",,,[5]
]
,,[,,"1(?:0111|\\d{3})|9(?:3111|\\d{2})",,,,"93111"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NC":[,[,,"1\\d{1,3}|3\\d{3}|5\\d{2}",,,,,,,[2,3,4]
]
,,,[,,"10(?:00|1[23]|3[0-2]|88)|3631|577",,,,"1000",,,[3,4]
]
,[,,,,,,,,,[-1]
]
,,,,"NC",,,,,,,,,,,,,,,,,,[,,"1[5-8]",,,,"15",,,[2]
]
,,[,,"1(?:0(?:0[06]|1[02-46]|20|3[0125]|42|5[058]|77|88)|[5-8])|3631|5[6-8]\\d",,,,"1000"]
,[,,"5(?:67|88)",,,,"567",,,[3]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NE":[,[,,"[1-358]\\d{1,2}|723141",,,,,,,[2,3,6]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"NE",,,,,,,,,,,,,,,,,,[,,"1[578]|723141",,,,"17",,,[2,6]
]
,,[,,"1(?:0[01]|1[12]|2[034]|3[013]|40|55?|60|7|8)|222|333|555|723141|888",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"1(?:0[01]|1[12]|2[034]|3[013]|40|55|60)|222|333|555|888",,,,"100",,,[3]
]
,,[,,,,,,,,,[-1]
]
]
,"NF":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"NF",,,,,,,,,,,,,,,,,,[,,"9(?:11|55|77)",,,,"911"]
,,[,,"9(?:11|55|77)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NG":[,[,,"[14]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"NG",,,,,,,,,,,,,,,,,,[,,"199",,,,"199",,,[3]
]
,,[,,"199|40700",,,,"199"]
,[,,,,,,,,,[-1]
]
,[,,"40700",,,,"40700",,,[5]
]
,,[,,"40700",,,,"40700",,,[5]
]
]
,"NI":[,[,,"[12467]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"7373",,,,"7373",,,[4]
]
,[,,,,,,,,,[-1]
]
,,,,"NI",,,,,,,,,,,,,,,,,,[,,"1(?:1[58]|2[08])",,,,"118",,,[3]
]
,,[,,"1(?:1[58]|2(?:[158]|00?)|900)|2100|4878|6100|7(?:010|100|373)",,,,"118"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NL":[,[,,"[1349]\\d{2,5}",,,,,,,[3,4,6]
]
,,,[,,"116(?:00[06]|1(?:11|23))",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"NL",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:00[06]|1(?:11|23)))|2(?:0[0-4]|3[34]|44)|3[03-9]\\d|400|8(?:[02-9]\\d|1[0-79]))|[34]000|911",,,,"1833"]
,[,,,,,,,,,[-1]
]
,[,,"120[0-4]",,,,"1202",,,[4]
]
,,[,,"[34]000",,,,"4000",,,[4]
]
]
,"NO":[,[,,"1\\d{2,5}",,,,,,,[3,4,6]
]
,,,[,,"1161(?:1[17]|23)",,,,"116117",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"NO",,,,,,,,,,,,,,,,,,[,,"11[023]",,,,"112",,,[3]
]
,,[,,"1(?:1(?:[0239]|61(?:1[17]|23))|2[048]|4(?:12|[59])|7[57]|90)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NP":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"NP",,,,,,,,,,,,,,,,,,[,,"1(?:0[0-3]|12)",,,,"112"]
,,[,,"1(?:0[0-3]|12)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NR":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"NR",,,,,,,,,,,,,,,,,,[,,"11[0-2]",,,,"110"]
,,[,,"1(?:1[0-2]|23|92)",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"NU":[,[,,"[019]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"NU",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"01[05]|101|999",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,"010",,,,"010"]
,,[,,,,,,,,,[-1]
]
]
,"NZ":[,[,,"\\d{3,4}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,"018",,,,"018",,,[3]
]
,,,,"NZ",,,,,,,,,,,,,,,,,,[,,"111",,,,"111",,,[3]
]
,,[,,"018|1(?:11|234|371|7[03]7|944)|[2-57-9]\\d{2,3}|6(?:161|26[0-3]|742)",,,,"111"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"018|1(?:234|371|7[03]7|944)|[2-57-9]\\d{2,3}|6(?:161|26[0-3]|742)",,,,"4098"]
]
,"OM":[,[,,"9\\d{3}",,,,,,,[4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"OM",,,,,,,,,,,,,,,,,,[,,"9999",,,,"9999"]
,,[,,"9999",,,,"9999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PA":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"PA",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"10[2-4]|911",,,,"102"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PE":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"PE",,,,,,,,,,,,,,,,,,[,,"1(?:05|1[67])",,,,"105"]
,,[,,"1(?:05|1[67])",,,,"105"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PF":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"PF",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"15"]
,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PG":[,[,,"0\\d{2}|1\\d{2,6}",,,,,,,[3,4,5,6,7]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"PG",,,,,,,,,,,,,,,,,,[,,"000|11[01]",,,,"000",,,[3]
]
,,[,,"000|1(?:1[01]|5\\d{2}|6\\d{2,5})",,,,"000"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"16\\d{2,5}",,,,"1612",,,[4,5,6,7]
]
]
,"PH":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"PH",,,,,,,,,,,,,,,,,,[,,"11[27]|911",,,,"117"]
,,[,,"11[27]|911",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PK":[,[,,"1\\d{1,3}",,,,,,,[2,3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"PK",,,,,,,,,,,,,,,,,,[,,"1(?:1(?:22?|5)|[56])",,,,"112"]
,,[,,"1(?:1(?:22?|5)|[56])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PL":[,[,,"1\\d{2}(?:\\d{2,3})?|9\\d{2}",,,,,,,[3,5,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"PL",,,,,,,,,,,,,,,,,,[,,"112|99[789]",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:000|1(?:11|23))|8(?:000|91[23]))|9\\d{3})|9(?:8[4-7]|9[1-9])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PM":[,[,,"1\\d|3103",,,,,,,[2,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"PM",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"17",,,[2]
]
,,[,,"1[578]|3103",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,"3103",,,,"3103",,,[4]
]
,,[,,,,,,,,,[-1]
]
]
,"PR":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"PR",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PS":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,"166",,,,"166"]
,[,,,,,,,,,[-1]
]
,,,,"PS",,,,,,,,,,,,,,,,,,[,,"10[0-2]",,,,"100"]
,,[,,"1(?:0[0-2]|44|66|99)",,,,"199"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PT":[,[,,"1\\d{2,5}",,,,,,,[3,6]
]
,,,[,,"116(?:000|111)",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"PT",,,,,,,,,,,,,,,,,,[,,"11[25]",,,,"112",,,[3]
]
,,[,,"11(?:[2578]|6(?:000|111))",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PW":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"PW",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"PY":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"PY",,,,,,,,,,,,,,,,,,[,,"128|911",,,,"911"]
,,[,,"1[1-4]\\d|911",,,,"123"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"QA":[,[,,"[129]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"QA",,,,,,,,,,,,,,,,,,[,,"999",,,,"999",,,[3]
]
,,[,,"(?:1|20|9[27]\\d)\\d{2}|999",,,,"2012"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"RE":[,[,,"1\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"RE",,,,,,,,,,,,,,,,,,[,,"1(?:12|[578])",,,,"15"]
,,[,,"1(?:12|[578])",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"RO":[,[,,"[18]\\d{2,5}",,,,,,,[3,4,6]
]
,,,[,,"116(?:000|111)",,,,"116000",,,[6]
]
,[,,"(?:1(?:18(?:300|932)|[24]\\d{2})|8[48]\\d{2})",,,,"8844",,,[4,6]
]
,,,,"RO",,,,,,,,,,,,,,,,,,[,,"112",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:000|111)|8(?:300|932))|[24]\\d{2}|9(?:21|3[02]|5[178]))|8[48]\\d{2}",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"(?:1[24]|8[48])\\d{2}",,,,"8844",,,[4]
]
]
,"RS":[,[,,"[19]\\d{1,5}",,,,,,,[2,3,4,5,6]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"RS",,,,,,,,,,,,,,,,,,[,,"112|9[234]",,,,"112",,,[2,3]
]
,,[,,"1[189]\\d{1,4}|9[234]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"RU":[,[,,"[01]\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"RU",,,,,,,,,,,,,,,,,,[,,"0[1-3]|1(?:0[1-3]|12)",,,,"112"]
,,[,,"0[1-4]|1(?:0[1-4]|12)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"RW":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"RW",,,,,,,,,,,,,,,,,,[,,"112",,,,"112"]
,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SA":[,[,,"[19]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"116111|937|998",,,,"116111",,,[3,6]
]
,[,,,,,,,,,[-1]
]
,,,,"SA",,,,,,,,,,,,,,,,,,[,,"112|9(?:11|9[79])",,,,"999",,,[3]
]
,,[,,"1(?:1(?:00|2|6111)|410|9(?:00|1[89]|9(?:099|22|91)))|9(?:0[24-79]|11|3[379]|40|66|8[5-9]|9[02-9])",,,,"937"]
,[,,"1410",,,,"1410",,,[4]
]
,[,,"1(?:100|410)|90[24679]",,,,"902",,,[3,4]
]
,,[,,,,,,,,,[-1]
]
]
,"SB":[,[,,"[127-9]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SB",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"1(?:[02]\\d|1[12]|[35][01]|[49][1-9]|6[2-9]|7[7-9]|8[0-8])|269|777|835|9(?:[01]1|22|33|55|77|88|99)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SC":[,[,,"[19]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SC",,,,,,,,,,,,,,,,,,[,,"999",,,,"999",,,[3]
]
,,[,,"1(?:0\\d|1[027]|2[0-8]|3[13]|4[0-2]|[59][15]|6[1-9]|7[124-6]|8[158])|9(?:6\\d{2}|99)",,,,"100"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SD":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SD",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SE":[,[,,"[1-37-9]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,"11811[89]|72\\d{3}",,,,"118118",,,[5,6]
]
,,,,"SE",,,,,,,,,,,,,,,,,,[,,"112|90000",,,,"112",,,[3,5]
]
,,[,,"11(?:[25]|313|4\\d{2}|6(?:00[06]|11[17]|123)|7[0-8]|8(?:1(?:[02-9]\\d|1[013-9])|[02-46-9]\\d{2}))|2(?:2[02358]|33|4[01]|50|6[1-4])|32[13]|7\\d{4}|8(?:22|88)|9(?:0(?:000|1(?:[02-9]\\d|1[013-9])|[2-4]\\d{2}|510)|12)",,,,"11313"]
,[,,,,,,,,,[-1]
]
,[,,"2(?:2[02358]|33|4[01]|50|6[1-4])|32[13]|8(?:22|88)|912",,,,"222",,,[3]
]
,,[,,"7\\d{4}",,,,"72123",,,[5]
]
]
,"SG":[,[,,"[179]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SG",,,,,,,,,,,,,,,,,,[,,"99[359]",,,,"999",,,[3]
]
,,[,,"1(?:[0136]\\d{2}|[89](?:[1-9]\\d|0[1-9])|[57]\\d{2,3})|77222|99[02-9]",,,,"1312"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,"77222",,,,"77222",,,[5]
]
]
,"SH":[,[,,"[19]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SH",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"999",,,[3]
]
,,[,,"1\\d{2,3}|9(?:11|99)",,,,"1234"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SI":[,[,,"1\\d{2,5}",,,,,,,[3,6]
]
,,,[,,"116(?:000|1(?:11|23))",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"SI",,,,,,,,,,,,,,,,,,[,,"11[23]",,,,"112",,,[3]
]
,,[,,"11(?:[23]|6(?:000|1(?:11|23)))",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SJ":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SJ",,,,,,,,,,,,,,,,,,[,,"11[023]",,,,"112"]
,,[,,"11[023]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SK":[,[,,"1\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"116\\d{3}",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"SK",,,,,,,,,,,,,,,,,,[,,"1(?:12|5[058])",,,,"112",,,[3]
]
,,[,,"1(?:1(?:2|6(?:000|111)|8[0-8])|[24]\\d{3}|5[0589]|8\\d{3})",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SL":[,[,,"[069]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SL",,,,,,,,,,,,,,,,,,[,,"(?:01|99)9",,,,"999",,,[3]
]
,,[,,"(?:01|99)9|60400",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,"60400",,,,"60400",,,[5]
]
,,[,,"60400",,,,"60400",,,[5]
]
]
,"SM":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SM",,,,,,,,,,,,,,,,,,[,,"11[358]",,,,"113"]
,,[,,"11[358]",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SN":[,[,,"[12]\\d{1,5}",,,,,,,[2,3,4,5,6]
]
,,,[,,"1515|2(?:00|1)\\d{3}",,,,"200133",,,[4,5,6]
]
,[,,"2(?:0[246]|[468])\\d{3}",,,,"202222",,,[5,6]
]
,,,,"SN",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17",,,[2]
]
,,[,,"1(?:1[69]|2(?:\\d{2})?|[46]\\d{2}|51\\d|[78])|2(?:0[0-246]|[12468])\\d{3}",,,,"17"]
,[,,"2(?:01|2)\\d{3}",,,,"201202",,,[5,6]
]
,[,,"1[46]\\d{2}",,,,"1415",,,[4]
]
,,[,,"2[468]\\d{3}",,,,"24123",,,[5]
]
]
,"SO":[,[,,"[5789]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SO",,,,,,,,,,,,,,,,,,[,,"555|888|999",,,,"555"]
,,[,,"555|777|888|999",,,,"777"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SR":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SR",,,,,,,,,,,,,,,,,,[,,"115",,,,"115",,,[3]
]
,,[,,"1\\d{2,3}",,,,"1234"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ST":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"ST",,,,,,,,,,,,,,,,,,[,,"112",,,,"112"]
,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SV":[,[,,"[49]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SV",,,,,,,,,,,,,,,,,,[,,"911",,,,"911",,,[3]
]
,,[,,"40404|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,"40404",,,,"40404",,,[5]
]
,,[,,"40404",,,,"40404",,,[5]
]
]
,"SX":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SX",,,,,,,,,,,,,,,,,,[,,"919",,,,"919"]
,,[,,"919",,,,"919"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SY":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SY",,,,,,,,,,,,,,,,,,[,,"11[023]",,,,"112"]
,,[,,"11[023]",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"SZ":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"SZ",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TC":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TC",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TD":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TD",,,,,,,,,,,,,,,,,,[,,"1[78]",,,,"17"]
,,[,,"1[78]",,,,"17"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TG":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TG",,,,,,,,,,,,,,,,,,[,,"1(?:1[78]|7[127])",,,,"117",,,[3]
]
,,[,,"1(?:011|1[078]|7[127])",,,,"117"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TH":[,[,,"1\\d{2,3}",,,,,,,[3,4]
]
,,,[,,"1(?:1(?:00|2[03]|3[3479]|55|7[67]|9[0246])|5(?:55|78)|6(?:44|6[79]|88|9[16])|888)",,,,"1669",,,[4]
]
,[,,"1(?:113|2(?:22|3[89])|5(?:09|56))",,,,"1509",,,[4]
]
,,,,"TH",,,,,,,,,,,,,,,,,,[,,"1(?:669|9[19])",,,,"191"]
,,[,,"1(?:0[0-2]|1(?:0[03]|1[1-35]|2[0358]|3[03-79]|4[02-489]|5[04-9]|6[04-79]|7[03-9]|8[027-9]|9[02-79])|2(?:22|3[89])|3(?:18|2[23]|3[013]|5[56]|6[45]|73)|477|5(?:0\\d|4[0-37-9]|5[1-8]|6[01679]|7[12568]|8[0-24589]|9[013589])|6(?:0[0-29]|2[03]|4[3-6]|6[1-9]|7[0257-9]|8[0158]|9[014-9])|7(?:19|7[27]|90)|888|9[19])",,,,"191"]
,[,,"1(?:1(?:03|1[15]|2[58]|3[056]|4[02-49]|5[046-9]|6[04-79]|7[03-589]|8[02789]|9[579])|3(?:18|2[23]|3[013]|5[4-6])|5(?:0[0-8]|4[0-378]|5[1-478]|6[01679]|7[156]|8[0-24589]|9[013589])|6(?:0[0-29]|20|4[356]|6[1-68]|7[05789]|8[015]|9[0457-9])|7(?:19|7[27]))",,,,"1149",,,[4]
]
,[,,"114[89]",,,,"1148",,,[4]
]
,,[,,,,,,,,,[-1]
]
]
,"TJ":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TJ",,,,,,,,,,,,,,,,,,[,,"1(?:0[1-3]|12)",,,,"112"]
,,[,,"1(?:0[1-3]|12)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TL":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TL",,,,,,,,,,,,,,,,,,[,,"11[25]",,,,"112"]
,,[,,"1(?:0[02]|1[25]|2[0138]|72|9[07])",,,,"102"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TM":[,[,,"0\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TM",,,,,,,,,,,,,,,,,,[,,"0[1-3]",,,,"03"]
,,[,,"0[1-3]",,,,"03"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TN":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TN",,,,,,,,,,,,,,,,,,[,,"19[078]",,,,"197"]
,,[,,"19[078]",,,,"197"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TO":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TO",,,,,,,,,,,,,,,,,,[,,"9(?:11|22|33|99)",,,,"911"]
,,[,,"9(?:11|22|33|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TR":[,[,,"[1-9]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,"1(?:22|3[126]|4[04]|5[16-9]|6[18]|77|83)",,,,"183",,,[3]
]
,[,,,,,,,,,[-1]
]
,,,,"TR",,,,,,,,,,,,,,,,,,[,,"1(?:1[02]|55)",,,,"112",,,[3]
]
,,[,,"1(?:1(?:[0239]|811)|2[126]|3(?:[126]|37?|[58]6|65)|4(?:[014]|71)|5(?:[135-9]|07|78)|6(?:[02]6|[1389]|99)|7[0-79]|8(?:\\d|63|95))|2(?:077|268|4(?:17|23)|5(?:7[26]|82)|6[14]4|8\\d{2}|9(?:30|89))|3(?:0(?:05|72)|353|4(?:06|30|64)|502|674|747|851|9(?:1[29]|60))|4(?:0(?:25|3[12]|[47]2)|3(?:3[13]|[89]1)|439|5(?:43|55)|717|832)|5(?:145|290|[4-6]\\d{2}|772|833|9(?:[06]1|92))|6(?:236|6(?:12|39|8[59])|769)|7890|8(?:688|7(?:28|65)|85[06])|9(?:159|290)",,,,"112"]
,[,,"2850|5420",,,,"5420",,,[4]
]
,[,,,,,,,,,[-1]
]
,,[,,"1(?:3(?:37|[58]6|65)|4(?:4|71)|5(?:07|78)|6(?:[02]6|99)|8(?:3|63|95))|2(?:077|268|4(?:17|23)|5(?:7[26]|82)|6[14]4|8\\d{2}|9(?:30|89))|3(?:0(?:05|72)|353|4(?:06|30|64)|502|674|747|851|9(?:1[29]|60))|4(?:0(?:25|3[12]|[47]2)|3(?:3[13]|[89]1)|439|5(?:43|55)|717|832)|5(?:145|290|[4-6]\\d{2}|772|833|9(?:[06]1|92))|6(?:236|6(?:12|39|8[59])|769)|7890|8(?:688|7(?:28|65)|85[06])|9(?:159|290)",,,,"5420",,,[3,4]
]
]
,"TT":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TT",,,,,,,,,,,,,,,,,,[,,"99[09]",,,,"999"]
,,[,,"99[09]",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TV":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TV",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"1\\d{2}|911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TW":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TW",,,,,,,,,,,,,,,,,,[,,"11[029]",,,,"110"]
,,[,,"11[029]",,,,"110"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"TZ":[,[,,"[149]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"TZ",,,,,,,,,,,,,,,,,,[,,"11[12]|999",,,,"111",,,[3]
]
,,[,,"11[12]|46400|999",,,,"111"]
,[,,,,,,,,,[-1]
]
,[,,"46400",,,,"46400",,,[5]
]
,,[,,"46400",,,,"46400",,,[5]
]
]
,"UA":[,[,,"[189]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"116(?:000|1(?:11|23))",,,,"116000",,,[6]
]
,[,,,,,,,,,[-1]
]
,,,,"UA",,,,,,,,,,,,,,,,,,[,,"1(?:0[1-3]|12)",,,,"112",,,[3]
]
,,[,,"1(?:0(?:[1-49]|6\\d{2})|1(?:2|6(?:000|1(?:11|23))|8\\d{1,2})|[278]\\d|4\\d{3}|5(?:1|\\d{2})|6\\d{2})|[89]00\\d{1,2}",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,"(?:118|[89]00)\\d{1,2}",,,,"11812",,,[4,5]
]
,,[,,,,,,,,,[-1]
]
]
,"UG":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"UG",,,,,,,,,,,,,,,,,,[,,"999",,,,"999"]
,,[,,"999",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"US":[,[,,"[1-9]\\d{2,5}",,,,,,,[3,4,5,6]
]
,,,[,,"611",,,,"611",,,[3]
]
,[,,"2(?:4280|5209|7(?:449|663))|3(?:2340|3786|5564|8(?:135|254))|4(?:1(?:366|463)|3355|6(?:157|327)|7553|8(?:221|277))|5(?:2944|4892|5928|9(?:187|342))|69388|7(?:2(?:078|087)|3(?:288|909)|6426)|8(?:6234|9616)|9(?:5297|6(?:040|835)|7(?:294|688)|9(?:689|796))",,,,"24280",,,[5]
]
,,,,"US",,,,,,,,,,,,,,,,,,[,,"112|911",,,,"911",,,[3]
]
,,[,,"1(?:1(?:2|5[1-47]|[68]\\d|7[0-57]|98))|[2-9](?:11|\\d{3,5})",,,,"911"]
,[,,"2(?:3333|42242|56447|6688|75622|9002)|3(?:1010|2665|7404)|40404|560560|6(?:0060|22639|5246|7622)|7(?:0701|3822|4666)|8(?:38255|4816|72265)|99099",,,,"73822",,,[5,6]
]
,[,,"[2-9]\\d{3}|33669|[2356]11",,,,"33669",,,[3,4,5]
]
,,[,,"[2-9]\\d{4,5}",,,,"20566",,,[5,6]
]
]
,"UY":[,[,,"[19]\\d{2,3}",,,,,,,[3,4]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"UY",,,,,,,,,,,,,,,,,,[,,"128|911",,,,"911",,,[3]
]
,,[,,"1(?:0[4-9]|1[2368]|2[0-3568]|787)|911",,,,"104"]
,[,,"1787",,,,"1787",,,[4]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"UZ":[,[,,"[04]\\d{1,4}",,,,,,,[2,3,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"UZ",,,,,,,,,,,,,,,,,,[,,"0(?:0[123]|[123]|50)",,,,"01",,,[2,3]
]
,,[,,"0(?:0[123]|[123]|50)|45400",,,,"01"]
,[,,,,,,,,,[-1]
]
,[,,"45400",,,,"45400",,,[5]
]
,,[,,"45400",,,,"45400",,,[5]
]
]
,"VA":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"VA",,,,,,,,,,,,,,,,,,[,,"11[2358]",,,,"113"]
,,[,,"11[2358]",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VC":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"VC",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VE":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"VE",,,,,,,,,,,,,,,,,,[,,"1(?:12|71)|911",,,,"171"]
,,[,,"1(?:12|71)|911",,,,"171"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VG":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"VG",,,,,,,,,,,,,,,,,,[,,"9(?:11|99)",,,,"911"]
,,[,,"9(?:11|99)",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VI":[,[,,"9\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"VI",,,,,,,,,,,,,,,,,,[,,"911",,,,"911"]
,,[,,"911",,,,"911"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VN":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"VN",,,,,,,,,,,,,,,,,,[,,"11[345]",,,,"113"]
,,[,,"11[345]",,,,"113"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"VU":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"VU",,,,,,,,,,,,,,,,,,[,,"112",,,,"112"]
,,[,,"112",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"WF":[,[,,"1\\d",,,,,,,[2]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"WF",,,,,,,,,,,,,,,,,,[,,"1[578]",,,,"15"]
,,[,,"1[578]",,,,"15"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"WS":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"WS",,,,,,,,,,,,,,,,,,[,,"9(?:11|9[4-69])",,,,"994"]
,,[,,"1(?:1[12]|2[0-6])|9(?:11|9[4-79])",,,,"994"]
,[,,,,,,,,,[-1]
]
,[,,"12[0-6]",,,,"121"]
,,[,,,,,,,,,[-1]
]
]
,"XK":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"XK",,,,,,,,,,,,,,,,,,[,,"1(?:12|9[2-4])",,,,"112"]
,,[,,"1(?:12|9[2-4])",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"YE":[,[,,"1\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"YE",,,,,,,,,,,,,,,,,,[,,"19[1459]",,,,"191"]
,,[,,"19[1459]",,,,"191"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"YT":[,[,,"1\\d{1,2}",,,,,,,[2,3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"YT",,,,,,,,,,,,,,,,,,[,,"1(?:12|5)",,,,"15"]
,,[,,"1(?:12|5)",,,,"112"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ZA":[,[,,"[134]\\d{2,4}",,,,,,,[3,4,5]
]
,,,[,,,,,,,,,[-1]
]
,[,,"41(?:348|851)",,,,"41851",,,[5]
]
,,,,"ZA",,,,,,,,,,,,,,,,,,[,,"1(?:0(?:1(?:11|77))|12)",,,,"10111",,,[3,5]
]
,,[,,"1(?:0(?:1(?:11|77)|20|7)|1[12]|77(?:3[237]|[45]7|6[279]|9[26]))|[34]\\d{4}",,,,"10111"]
,[,,"3(?:078[23]|7(?:064|567)|8126)|4(?:2699|3(?:699|94[16])|7751|8837)",,,,"47751",,,[5]
]
,[,,"111",,,,"111",,,[3]
]
,,[,,"[34]\\d{4}",,,,"47751",,,[5]
]
]
,"ZM":[,[,,"[19]\\d{2}",,,,,,,[3]
]
,,,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,,,"ZM",,,,,,,,,,,,,,,,,,[,,"(?:112|99[139])",,,,"999"]
,,[,,"(?:112|99[139])",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,,,,,,,,[-1]
]
,,[,,,,,,,,,[-1]
]
]
,"ZW":[,[,,"[139]\\d{2,4}",,,,,,,[3,5]
]
,,,[,,"9(?:5[023]|61)",,,,"961",,,[3]
]
,[,,"3\\d{4}",,,,"30123",,,[5]
]
,,,,"ZW",,,,,,,,,,,,,,,,,,[,,"(?:112|99[3-59])",,,,"999",,,[3]
]
,,[,,"11[2469]|3\\d{4}|9(?:5[023]|6[0-25]|9[3-59])",,,,"999"]
,[,,,,,,,,,[-1]
]
,[,,"(?:114|9(?:5[023]|6[0-25]))",,,,"114",,,[3]
]
,,[,,,,,,,,,[-1]
]
]
};
