/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: win32-config.h,v 1.19 2002/11/07 07:09:45 kingofgib Exp $
 */


# ifndef WIN32_CONFIG_H
# define WIN32_CONFIG_H

# if defined STDWin32 		/* { */

# define DONT_HAVE_OWN_TLP	1

# define WIN32_LEAN_AND_MEAN
# define NOSOUND

# ifdef STD_WIN98	/* {{ */

# include <winsock.h>

typedef size_t	socklen_t;

# else			/* }{ */

# include <winsock2.h>
# include <ws2tcpip.h>

# define USE_IPHLPAPI_H		1
# include <iphlpapi.h>

# define IFNAMSIZ		MAX_ADAPTER_NAME_LENGTH

/* # include <iptypes.h> */
#ifndef __GNUC__
# define HAVE_GETNAMEINFO	1
# define HAVE_GETADDRINFO	1
#endif
/*** 
 *** Make sure the INCLUDE path contains the SDK include directory
 *** first, so that the new ipifcons.h header file is used instead of
 *** the old one, distributed with MSVC.
 ***/
# define HAVE_IPIFCONS_H	1
# include <ipifcons.h>

# endif			/* }} */

# include <io.h>		/* temporary for _dup */

# define dup(x)			_dup( (x) )

# define sleep(x)		Sleep(1000 * x)

# define close(x)		closesocket(x)

# define gethostbyname2(x,y)	gethostbyname((x))

# define snprintf		_snprintf

typedef unsigned int 		in_addr_t;

# define iovec			_WSABUF
# define iov_base		buf
# define iov_len		len

# endif				/* } */

# define PNET_HAVE_PACKET_ACCESS	1
# define PNET_HAVE_WIN32_PACKET		1

# define HAVE_WINDOWS_THREADS		1
# define HAVE_STRUCT_SOCKADDR_IN	1
# define HAVE_STRUCT_SOCKADDR_IN6	1


# ifndef EINPROGRESS
#   define EINPROGRESS		WSAEINPROGRESS
# endif
# ifndef EAFNOSUPPORT
#   define EAFNOSUPPORT		WSAEAFNOSUPPORT
# endif
# ifndef ENOSPC
#   define ENOSPC		WSAENOSPC
# endif
# ifndef SIGCHLD
#   define SIGCHLD		14
# endif
# endif /* ! WIN32_CONFIG_H */
