/*
 * $Id: ifinfo.c,v 1.16 2002/10/02 06:51:36 kingofgib Exp $
 */
# include <pnet6.h>
# include <stdio.h>
# include <string.h>

/*----------------------------------------------------------------------*/
/* Nothing fancy, simply an example that fetches information about 	*/
/* interfaces on the local machine, then prints miscellaneous details	*/
/* about them. If arg[1] is inet6, we only list inet6 info, if inet4	*/
/* only list IP info, else list info on both IPv4 and IPv6.		*/
/*----------------------------------------------------------------------*/
int
main(int argc,char **argv)
{
    int 	pfam = 0;
    PNETIF	pif;

    if (argc == 2)
    {
	if ( !strcmp(argv[1],"inet4") )
	    pfam = PNET_IPv4;
	else if ( !strcmp(argv[1],"inet6") )
	    pfam = PNET_IPv6;
    }

    pif = pnetGetIfInfo(pfam);

    printf("Interfaces with family %s:\n",pnetFamilyToAscii(pfam));

    while ( pif )
    {
	PNETIFADDR pia = NULL;
	char buf[128];

	printf("%s (%d) %s: <",pnetIfName(pif),pnetIfIndex(pif),
				pnetIfTypeString(pif));

	if (pnetIfIsUp(pif)) printf(" UP");
	if (pnetIfIsRunning(pif)) printf(" RUNNING");
	if (pnetIfIsBroadcast(pif)) printf(" BROADCAST");
	if (pnetIfIsDebug(pif)) printf(" DEBUG");
	if (pnetIfIsLoopback(pif)) printf(" LOOPBACK");
	if (pnetIfIsPointopoint(pif)) printf(" POINTOPOINT");
	if (pnetIfIsPromiscuous(pif)) printf(" PROMISCUOUS" );
	if (pnetIfIsSimplex(pif)) printf(" SIMPLEX");
	if (pnetIfIsMulticast(pif)) printf(" MULTICAST");

	printf(">");
	printf(", MTU: %d\n", pnetIfGetMTU( pif ));

	if (pnetIfAddrToAscii(pif,PNETIF_HWADDR,buf,sizeof(buf)))
	    printf("   Hardware address: %s\n",buf);

	while ( (pia = pnetIfGetNextAddr( pif, pia )) ) 
	{
	    const pnet_byte * netmask;
	    int	fam;

	    pnetIfAddrToString( pia, buf, sizeof( buf ) );

	    fam = pnetIfAddrGetFamily( pia );
	    if ( fam == PNET_IPv4 )
	    {
		printf("   IP addr: %s",buf);

		netmask = pnetIfAddrGetNetmask( pia );
		if ( netmask )
		{
		    sprintf(buf,"0x%.2x%.2x%.2x%.2x",
			    netmask[0],netmask[1],netmask[2],netmask[3]);
		    printf(", netmask: %s",buf);
		}
		netmask = pnetIfAddrGetBroadcast( pia );
		if ( netmask )
		{
		    sprintf(buf,"%d.%d.%d.%d",
			    netmask[0],netmask[1],netmask[2],netmask[3]);
		    printf(", broadcast: %s",buf);
		}
	    }
	    else if ( fam == PNET_IPv6 )
	    {
		printf("   IPV6 addr: %s/%d scope_id 0x%X", buf,
			pnetIfAddrGetPrefixLength( pia ),
			pnetIfAddrGetScopeId( pia ));
	    }
	    else 
	    {
		printf(" Interface address family of %d unrecognized\n",fam);
	    }
	    printf( "\n" );
	}
	if (pnetIfAddrToAscii(pif,PNETIF_BADDR,buf,sizeof(buf)))
	    printf("   Broadcast address: %s\n",buf);
	if (pnetIfAddrToAscii(pif,PNETIF_DADDR,buf,sizeof(buf)))
	    printf("   Destination address: %s\n",buf);

	pif = pnetIfNext(pif);
    }

    return 0;
}
