%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  lsrtags = "pitches, really-cool, scheme-language"

  texidoc = "
This Scheme-based snippet generates random notes. Use as

@code{\\randomNotes }@emph{@code{n}}@code{ }@emph{@code{from}}@code{ }@emph{@code{to}}@code{ }@emph{@code{dur}}

to generate @emph{n} random notes between pitches @emph{from} and
@emph{to}, with duration @emph{dur}.
"

  doctitle = "Generating random notes"
} % begin verbatim


randomNotes =
#(define-music-function (n from to dur)
   (integer? ly:pitch? ly:pitch? ly:duration?)
   (let ((from-step (ly:pitch-steps from))
         (to-step (ly:pitch-steps to)))
     (make-sequential-music
      (map (lambda (_)
             (let* ((step (+ from-step
                             (random (- to-step from-step))))
                    (pitch (ly:make-pitch 0 step 0)))
               #{ $pitch $dur #}))
           (iota n)))))

\randomNotes 24 c' g'' 8
