  ;;;; This file is part of LilyPond, the GNU music typesetter.
;;;;
;;;; Copyright (C) 2005--2023 Bernard Hurley <bernard@fong-hurley.org.uk>
;;;;
;;;; LilyPond is free software: you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or
;;;; (at your option) any later version.
;;;;
;;;; LilyPond is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with LilyPond.  If not, see <http://www.gnu.org/licenses/>.

(use-modules (ice-9 match))

(define-public standard-color-list '())

(define-syntax-rule (define-color name value)
  (begin
    (define-public name value)
    (set! standard-color-list (acons 'name value standard-color-list))))

(define-color black '(0.0 0.0 0.0))

(define-color white '(1.0 1.0 1.0))
(define-color red '(1.0 0.0 0.0))
(define-color green '(0.0 1.0 0.0))
(define-color blue '(0.0 0.0 1.0))
(define-color cyan '(0.0 1.0 1.0))
(define-color magenta '(1.0 0.0 1.0))
(define-color yellow '(1.0 1.0 0.0))

(define-color grey '(0.5 0.5 0.5))
(define-color darkred '(0.5 0.0 0.0))
(define-color darkgreen '(0.0 0.5 0.0))
(define-color darkblue '(0.0 0.0 0.5))
(define-color darkcyan '(0.0 0.5 0.5))
(define-color darkmagenta '(0.5 0.0 0.5))
(define-color darkyellow '(0.5 0.5 0.0))

(set! standard-color-list (reverse! standard-color-list))

(define shared-color-list
  '((aliceblue 0.94117647058823528 0.97254901960784312 1)
    (antiquewhite 0.98039215686274506 0.92156862745098034 0.84313725490196079)
    (aquamarine 0.49803921568627452 1 0.83137254901960789)
    (azure 0.94117647058823528 1 1)
    (beige 0.96078431372549022 0.96078431372549022 0.86274509803921573)
    (bisque 1 0.89411764705882357 0.7686274509803922)
    (black 0 0 0)
    (blanchedalmond 1 0.92156862745098034 0.80392156862745101)
    (blue 0 0 1)
    (blueviolet 0.54117647058823526 0.16862745098039217 0.88627450980392153)
    (brown 0.6470588235294118 0.16470588235294117 0.16470588235294117)
    (burlywood 0.87058823529411766 0.72156862745098038 0.52941176470588236)
    (cadetblue 0.37254901960784315 0.61960784313725492 0.62745098039215685)
    (chartreuse 0.49803921568627452 1 0)
    (chocolate 0.82352941176470584 0.41176470588235292 0.11764705882352941)
    (coral 1 0.49803921568627452 0.31372549019607843)
    (cornflowerblue 0.39215686274509803 0.58431372549019611 0.92941176470588238)
    (cornsilk 1 0.97254901960784312 0.86274509803921573)
    (cyan 0 1 1)
    (darkblue 0 0 0.54509803921568623)
    (darkcyan 0 0.54509803921568623 0.54509803921568623)
    (darkgoldenrod 0.72156862745098038 0.52549019607843139 0.043137254901960784)
    (darkgray 0.66274509803921566 0.66274509803921566 0.66274509803921566)
    (darkgreen 0 0.39215686274509803 0)
    (darkgrey 0.66274509803921566 0.66274509803921566 0.66274509803921566)
    (darkkhaki 0.74117647058823533 0.71764705882352942 0.41960784313725491)
    (darkmagenta 0.54509803921568623 0 0.54509803921568623)
    (darkolivegreen 0.33333333333333331 0.41960784313725491 0.18431372549019609)
    (darkorange 1 0.5490196078431373 0)
    (darkorchid 0.59999999999999998 0.19607843137254902 0.80000000000000004)
    (darkred 0.54509803921568623 0 0)
    (darksalmon 0.9137254901960784 0.58823529411764708 0.47843137254901963)
    (darkseagreen 0.5607843137254902 0.73725490196078436 0.5607843137254902)
    (darkslateblue 0.28235294117647058 0.23921568627450981 0.54509803921568623)
    (darkslategray 0.18431372549019609 0.30980392156862746 0.30980392156862746)
    (darkslategrey 0.18431372549019609 0.30980392156862746 0.30980392156862746)
    (darkturquoise 0 0.80784313725490198 0.81960784313725488)
    (darkviolet 0.58039215686274515 0 0.82745098039215681)
    (deeppink 1 0.078431372549019607 0.57647058823529407)
    (deepskyblue 0 0.74901960784313726 1)
    (dimgray 0.41176470588235292 0.41176470588235292 0.41176470588235292)
    (dimgrey 0.41176470588235292 0.41176470588235292 0.41176470588235292)
    (dodgerblue 0.11764705882352941 0.56470588235294117 1)
    (firebrick 0.69803921568627447 0.13333333333333333 0.13333333333333333)
    (floralwhite 1 0.98039215686274506 0.94117647058823528)
    (forestgreen 0.13333333333333333 0.54509803921568623 0.13333333333333333)
    (gainsboro 0.86274509803921573 0.86274509803921573 0.86274509803921573)
    (ghostwhite 0.97254901960784312 0.97254901960784312 1)
    (gold 1 0.84313725490196079 0)
    (goldenrod 0.85490196078431369 0.6470588235294118 0.12549019607843137)
    (greenyellow 0.67843137254901964 1 0.18431372549019609)
    (honeydew 0.94117647058823528 1 0.94117647058823528)
    (hotpink 1 0.41176470588235292 0.70588235294117652)
    (indianred 0.80392156862745101 0.36078431372549019 0.36078431372549019)
    (ivory 1 1 0.94117647058823528)
    (khaki 0.94117647058823528 0.90196078431372551 0.5490196078431373)
    (lavender 0.90196078431372551 0.90196078431372551 0.98039215686274506)
    (lavenderblush 1 0.94117647058823528 0.96078431372549022)
    (lawngreen 0.48627450980392156 0.9882352941176471 0)
    (lemonchiffon 1 0.98039215686274506 0.80392156862745101)
    (lightblue 0.67843137254901964 0.84705882352941175 0.90196078431372551)
    (lightcoral 0.94117647058823528 0.50196078431372548 0.50196078431372548)
    (lightcyan 0.8784313725490196 1 1)
    (lightgoldenrodyellow 0.98039215686274506 0.98039215686274506 0.82352941176470584)
    (lightgray 0.82745098039215681 0.82745098039215681 0.82745098039215681)
    (lightgreen 0.56470588235294117 0.93333333333333335 0.56470588235294117)
    (lightgrey 0.82745098039215681 0.82745098039215681 0.82745098039215681)
    (lightpink 1 0.71372549019607845 0.75686274509803919)
    (lightsalmon 1 0.62745098039215685 0.47843137254901963)
    (lightseagreen 0.12549019607843137 0.69803921568627447 0.66666666666666663)
    (lightskyblue 0.52941176470588236 0.80784313725490198 0.98039215686274506)
    (lightslategray 0.46666666666666667 0.53333333333333333 0.59999999999999998)
    (lightslategrey 0.46666666666666667 0.53333333333333333 0.59999999999999998)
    (lightsteelblue 0.69019607843137254 0.7686274509803922 0.87058823529411766)
    (lightyellow 1 1 0.8784313725490196)
    (limegreen 0.19607843137254902 0.80392156862745101 0.19607843137254902)
    (linen 0.98039215686274506 0.94117647058823528 0.90196078431372551)
    (magenta 1 0 1)
    (mediumaquamarine 0.40000000000000002 0.80392156862745101 0.66666666666666663)
    (mediumblue 0 0 0.80392156862745101)
    (mediumorchid 0.72941176470588232 0.33333333333333331 0.82745098039215681)
    (mediumpurple 0.57647058823529407 0.4392156862745098 0.85882352941176465)
    (mediumseagreen 0.23529411764705882 0.70196078431372544 0.44313725490196076)
    (mediumslateblue 0.4823529411764706 0.40784313725490196 0.93333333333333335)
    (mediumspringgreen 0 0.98039215686274506 0.60392156862745094)
    (mediumturquoise 0.28235294117647058 0.81960784313725488 0.80000000000000004)
    (mediumvioletred 0.7803921568627451 0.082352941176470587 0.52156862745098043)
    (midnightblue 0.098039215686274508 0.098039215686274508 0.4392156862745098)
    (mintcream 0.96078431372549022 1 0.98039215686274506)
    (mistyrose 1 0.89411764705882357 0.88235294117647056)
    (moccasin 1 0.89411764705882357 0.70980392156862748)
    (navajowhite 1 0.87058823529411766 0.67843137254901964)
    (navy 0 0 0.50196078431372548)
    (oldlace 0.99215686274509807 0.96078431372549022 0.90196078431372551)
    (olivedrab 0.41960784313725491 0.55686274509803924 0.13725490196078433)
    (orange 1 0.6470588235294118 0)
    (orangered 1 0.27058823529411763 0)
    (orchid 0.85490196078431369 0.4392156862745098 0.83921568627450982)
    (palegoldenrod 0.93333333333333335 0.90980392156862744 0.66666666666666663)
    (palegreen 0.59607843137254901 0.98431372549019602 0.59607843137254901)
    (paleturquoise 0.68627450980392157 0.93333333333333335 0.93333333333333335)
    (palevioletred 0.85882352941176465 0.4392156862745098 0.57647058823529407)
    (papayawhip 1 0.93725490196078431 0.83529411764705885)
    (peachpuff 1 0.85490196078431369 0.72549019607843135)
    (peru 0.80392156862745101 0.52156862745098043 0.24705882352941178)
    (pink 1 0.75294117647058822 0.79607843137254897)
    (plum 0.8666666666666667 0.62745098039215685 0.8666666666666667)
    (powderblue 0.69019607843137254 0.8784313725490196 0.90196078431372551)
    (red 1 0 0)
    (rosybrown 0.73725490196078436 0.5607843137254902 0.5607843137254902)
    (royalblue 0.25490196078431371 0.41176470588235292 0.88235294117647056)
    (saddlebrown 0.54509803921568623 0.27058823529411763 0.074509803921568626)
    (salmon 0.98039215686274506 0.50196078431372548 0.44705882352941179)
    (sandybrown 0.95686274509803926 0.64313725490196083 0.37647058823529411)
    (seagreen 0.1803921568627451 0.54509803921568623 0.3411764705882353)
    (seashell 1 0.96078431372549022 0.93333333333333335)
    (sienna 0.62745098039215685 0.32156862745098042 0.17647058823529413)
    (skyblue 0.52941176470588236 0.80784313725490198 0.92156862745098034)
    (slateblue 0.41568627450980394 0.35294117647058826 0.80392156862745101)
    (slategray 0.4392156862745098 0.50196078431372548 0.56470588235294117)
    (slategrey 0.4392156862745098 0.50196078431372548 0.56470588235294117)
    (snow 1 0.98039215686274506 0.98039215686274506)
    (springgreen 0 1 0.49803921568627452)
    (steelblue 0.27450980392156865 0.50980392156862742 0.70588235294117652)
    (tan 0.82352941176470584 0.70588235294117652 0.5490196078431373)
    (thistle 0.84705882352941175 0.74901960784313726 0.84705882352941175)
    (tomato 1 0.38823529411764707 0.27843137254901962)
    (turquoise 0.25098039215686274 0.8784313725490196 0.81568627450980391)
    (violet 0.93333333333333335 0.50980392156862742 0.93333333333333335)
    (wheat 0.96078431372549022 0.87058823529411766 0.70196078431372544)
    (white 1 1 1)
    (whitesmoke 0.96078431372549022 0.96078431372549022 0.96078431372549022)
    (yellow 1 1 0)
    (yellowgreen 0.60392156862745094 0.80392156862745101 0.19607843137254902)))

(define x11-different-color-list
  '((gray 0.74509803921568629 0.74509803921568629 0.74509803921568629)
    (green 0 1 0)
    (grey 0.74509803921568629 0.74509803921568629 0.74509803921568629)
    (maroon 0.69019607843137254 0.18823529411764706 0.37647058823529411)
    (purple 0.62745098039215685 0.12549019607843137 0.94117647058823528)))

(define-public x11-grayN-list
  '((gray0 0 0 0)
    (gray1 0.011764705882352941 0.011764705882352941 0.011764705882352941)
    (gray2 0.019607843137254902 0.019607843137254902 0.019607843137254902)
    (gray3 0.031372549019607843 0.031372549019607843 0.031372549019607843)
    (gray4 0.039215686274509803 0.039215686274509803 0.039215686274509803)
    (gray5 0.050980392156862744 0.050980392156862744 0.050980392156862744)
    (gray6 0.058823529411764705 0.058823529411764705 0.058823529411764705)
    (gray7 0.070588235294117646 0.070588235294117646 0.070588235294117646)
    (gray8 0.078431372549019607 0.078431372549019607 0.078431372549019607)
    (gray9 0.090196078431372548 0.090196078431372548 0.090196078431372548)
    (gray10 0.10196078431372549 0.10196078431372549 0.10196078431372549)
    (gray11 0.10980392156862745 0.10980392156862745 0.10980392156862745)
    (gray12 0.12156862745098039 0.12156862745098039 0.12156862745098039)
    (gray13 0.12941176470588237 0.12941176470588237 0.12941176470588237)
    (gray14 0.14117647058823529 0.14117647058823529 0.14117647058823529)
    (gray15 0.14901960784313725 0.14901960784313725 0.14901960784313725)
    (gray16 0.16078431372549021 0.16078431372549021 0.16078431372549021)
    (gray17 0.16862745098039217 0.16862745098039217 0.16862745098039217)
    (gray18 0.1803921568627451 0.1803921568627451 0.1803921568627451)
    (gray19 0.18823529411764706 0.18823529411764706 0.18823529411764706)
    (gray20 0.20000000000000001 0.20000000000000001 0.20000000000000001)
    (gray21 0.21176470588235294 0.21176470588235294 0.21176470588235294)
    (gray22 0.2196078431372549 0.2196078431372549 0.2196078431372549)
    (gray23 0.23137254901960785 0.23137254901960785 0.23137254901960785)
    (gray24 0.23921568627450981 0.23921568627450981 0.23921568627450981)
    (gray25 0.25098039215686274 0.25098039215686274 0.25098039215686274)
    (gray26 0.25882352941176473 0.25882352941176473 0.25882352941176473)
    (gray27 0.27058823529411763 0.27058823529411763 0.27058823529411763)
    (gray28 0.27843137254901962 0.27843137254901962 0.27843137254901962)
    (gray29 0.29019607843137257 0.29019607843137257 0.29019607843137257)
    (gray30 0.30196078431372547 0.30196078431372547 0.30196078431372547)
    (gray31 0.30980392156862746 0.30980392156862746 0.30980392156862746)
    (gray32 0.32156862745098042 0.32156862745098042 0.32156862745098042)
    (gray33 0.32941176470588235 0.32941176470588235 0.32941176470588235)
    (gray34 0.3411764705882353 0.3411764705882353 0.3411764705882353)
    (gray35 0.34901960784313724 0.34901960784313724 0.34901960784313724)
    (gray36 0.36078431372549019 0.36078431372549019 0.36078431372549019)
    (gray37 0.36862745098039218 0.36862745098039218 0.36862745098039218)
    (gray38 0.38039215686274508 0.38039215686274508 0.38039215686274508)
    (gray39 0.38823529411764707 0.38823529411764707 0.38823529411764707)
    (gray40 0.40000000000000002 0.40000000000000002 0.40000000000000002)
    (gray41 0.41176470588235292 0.41176470588235292 0.41176470588235292)
    (gray42 0.41960784313725491 0.41960784313725491 0.41960784313725491)
    (gray43 0.43137254901960786 0.43137254901960786 0.43137254901960786)
    (gray44 0.4392156862745098 0.4392156862745098 0.4392156862745098)
    (gray45 0.45098039215686275 0.45098039215686275 0.45098039215686275)
    (gray46 0.45882352941176469 0.45882352941176469 0.45882352941176469)
    (gray47 0.47058823529411764 0.47058823529411764 0.47058823529411764)
    (gray48 0.47843137254901963 0.47843137254901963 0.47843137254901963)
    (gray49 0.49019607843137253 0.49019607843137253 0.49019607843137253)
    (gray50 0.49803921568627452 0.49803921568627452 0.49803921568627452)
    (gray51 0.50980392156862742 0.50980392156862742 0.50980392156862742)
    (gray52 0.52156862745098043 0.52156862745098043 0.52156862745098043)
    (gray53 0.52941176470588236 0.52941176470588236 0.52941176470588236)
    (gray54 0.54117647058823526 0.54117647058823526 0.54117647058823526)
    (gray55 0.5490196078431373 0.5490196078431373 0.5490196078431373)
    (gray56 0.5607843137254902 0.5607843137254902 0.5607843137254902)
    (gray57 0.56862745098039214 0.56862745098039214 0.56862745098039214)
    (gray58 0.58039215686274515 0.58039215686274515 0.58039215686274515)
    (gray59 0.58823529411764708 0.58823529411764708 0.58823529411764708)
    (gray60 0.59999999999999998 0.59999999999999998 0.59999999999999998)
    (gray61 0.61176470588235299 0.61176470588235299 0.61176470588235299)
    (gray62 0.61960784313725492 0.61960784313725492 0.61960784313725492)
    (gray63 0.63137254901960782 0.63137254901960782 0.63137254901960782)
    (gray64 0.63921568627450975 0.63921568627450975 0.63921568627450975)
    (gray65 0.65098039215686276 0.65098039215686276 0.65098039215686276)
    (gray66 0.6588235294117647 0.6588235294117647 0.6588235294117647)
    (gray67 0.6705882352941176 0.6705882352941176 0.6705882352941176)
    (gray68 0.67843137254901964 0.67843137254901964 0.67843137254901964)
    (gray69 0.69019607843137254 0.69019607843137254 0.69019607843137254)
    (gray70 0.70196078431372544 0.70196078431372544 0.70196078431372544)
    (gray71 0.70980392156862748 0.70980392156862748 0.70980392156862748)
    (gray72 0.72156862745098038 0.72156862745098038 0.72156862745098038)
    (gray73 0.72941176470588232 0.72941176470588232 0.72941176470588232)
    (gray74 0.74117647058823533 0.74117647058823533 0.74117647058823533)
    (gray75 0.74901960784313726 0.74901960784313726 0.74901960784313726)
    (gray76 0.76078431372549016 0.76078431372549016 0.76078431372549016)
    (gray77 0.7686274509803922 0.7686274509803922 0.7686274509803922)
    (gray78 0.7803921568627451 0.7803921568627451 0.7803921568627451)
    (gray79 0.78823529411764703 0.78823529411764703 0.78823529411764703)
    (gray80 0.80000000000000004 0.80000000000000004 0.80000000000000004)
    (gray81 0.81176470588235294 0.81176470588235294 0.81176470588235294)
    (gray82 0.81960784313725488 0.81960784313725488 0.81960784313725488)
    (gray83 0.83137254901960789 0.83137254901960789 0.83137254901960789)
    (gray84 0.83921568627450982 0.83921568627450982 0.83921568627450982)
    (gray85 0.85098039215686272 0.85098039215686272 0.85098039215686272)
    (gray86 0.85882352941176465 0.85882352941176465 0.85882352941176465)
    (gray87 0.87058823529411766 0.87058823529411766 0.87058823529411766)
    (gray88 0.8784313725490196 0.8784313725490196 0.8784313725490196)
    (gray89 0.8901960784313725 0.8901960784313725 0.8901960784313725)
    (gray90 0.89803921568627454 0.89803921568627454 0.89803921568627454)
    (gray91 0.90980392156862744 0.90980392156862744 0.90980392156862744)
    (gray92 0.92156862745098034 0.92156862745098034 0.92156862745098034)
    (gray93 0.92941176470588238 0.92941176470588238 0.92941176470588238)
    (gray94 0.94117647058823528 0.94117647058823528 0.94117647058823528)
    (gray95 0.94901960784313721 0.94901960784313721 0.94901960784313721)
    (gray96 0.96078431372549022 0.96078431372549022 0.96078431372549022)
    (gray97 0.96862745098039216 0.96862745098039216 0.96862745098039216)
    (gray98 0.98039215686274506 0.98039215686274506 0.98039215686274506)
    (gray99 0.9882352941176471 0.9882352941176471 0.9882352941176471)
    (gray100 1 1 1)))

(define x11-greyN-list
  '((grey0 0 0 0)
    (grey1 0.011764705882352941 0.011764705882352941 0.011764705882352941)
    (grey2 0.019607843137254902 0.019607843137254902 0.019607843137254902)
    (grey3 0.031372549019607843 0.031372549019607843 0.031372549019607843)
    (grey4 0.039215686274509803 0.039215686274509803 0.039215686274509803)
    (grey5 0.050980392156862744 0.050980392156862744 0.050980392156862744)
    (grey6 0.058823529411764705 0.058823529411764705 0.058823529411764705)
    (grey7 0.070588235294117646 0.070588235294117646 0.070588235294117646)
    (grey8 0.078431372549019607 0.078431372549019607 0.078431372549019607)
    (grey9 0.090196078431372548 0.090196078431372548 0.090196078431372548)
    (grey10 0.10196078431372549 0.10196078431372549 0.10196078431372549)
    (grey11 0.10980392156862745 0.10980392156862745 0.10980392156862745)
    (grey12 0.12156862745098039 0.12156862745098039 0.12156862745098039)
    (grey13 0.12941176470588237 0.12941176470588237 0.12941176470588237)
    (grey14 0.14117647058823529 0.14117647058823529 0.14117647058823529)
    (grey15 0.14901960784313725 0.14901960784313725 0.14901960784313725)
    (grey16 0.16078431372549021 0.16078431372549021 0.16078431372549021)
    (grey17 0.16862745098039217 0.16862745098039217 0.16862745098039217)
    (grey18 0.1803921568627451 0.1803921568627451 0.1803921568627451)
    (grey19 0.18823529411764706 0.18823529411764706 0.18823529411764706)
    (grey20 0.20000000000000001 0.20000000000000001 0.20000000000000001)
    (grey21 0.21176470588235294 0.21176470588235294 0.21176470588235294)
    (grey22 0.2196078431372549 0.2196078431372549 0.2196078431372549)
    (grey23 0.23137254901960785 0.23137254901960785 0.23137254901960785)
    (grey24 0.23921568627450981 0.23921568627450981 0.23921568627450981)
    (grey25 0.25098039215686274 0.25098039215686274 0.25098039215686274)
    (grey26 0.25882352941176473 0.25882352941176473 0.25882352941176473)
    (grey27 0.27058823529411763 0.27058823529411763 0.27058823529411763)
    (grey28 0.27843137254901962 0.27843137254901962 0.27843137254901962)
    (grey29 0.29019607843137257 0.29019607843137257 0.29019607843137257)
    (grey30 0.30196078431372547 0.30196078431372547 0.30196078431372547)
    (grey31 0.30980392156862746 0.30980392156862746 0.30980392156862746)
    (grey32 0.32156862745098042 0.32156862745098042 0.32156862745098042)
    (grey33 0.32941176470588235 0.32941176470588235 0.32941176470588235)
    (grey34 0.3411764705882353 0.3411764705882353 0.3411764705882353)
    (grey35 0.34901960784313724 0.34901960784313724 0.34901960784313724)
    (grey36 0.36078431372549019 0.36078431372549019 0.36078431372549019)
    (grey37 0.36862745098039218 0.36862745098039218 0.36862745098039218)
    (grey38 0.38039215686274508 0.38039215686274508 0.38039215686274508)
    (grey39 0.38823529411764707 0.38823529411764707 0.38823529411764707)
    (grey40 0.40000000000000002 0.40000000000000002 0.40000000000000002)
    (grey41 0.41176470588235292 0.41176470588235292 0.41176470588235292)
    (grey42 0.41960784313725491 0.41960784313725491 0.41960784313725491)
    (grey43 0.43137254901960786 0.43137254901960786 0.43137254901960786)
    (grey44 0.4392156862745098 0.4392156862745098 0.4392156862745098)
    (grey45 0.45098039215686275 0.45098039215686275 0.45098039215686275)
    (grey46 0.45882352941176469 0.45882352941176469 0.45882352941176469)
    (grey47 0.47058823529411764 0.47058823529411764 0.47058823529411764)
    (grey48 0.47843137254901963 0.47843137254901963 0.47843137254901963)
    (grey49 0.49019607843137253 0.49019607843137253 0.49019607843137253)
    (grey50 0.49803921568627452 0.49803921568627452 0.49803921568627452)
    (grey51 0.50980392156862742 0.50980392156862742 0.50980392156862742)
    (grey52 0.52156862745098043 0.52156862745098043 0.52156862745098043)
    (grey53 0.52941176470588236 0.52941176470588236 0.52941176470588236)
    (grey54 0.54117647058823526 0.54117647058823526 0.54117647058823526)
    (grey55 0.5490196078431373 0.5490196078431373 0.5490196078431373)
    (grey56 0.5607843137254902 0.5607843137254902 0.5607843137254902)
    (grey57 0.56862745098039214 0.56862745098039214 0.56862745098039214)
    (grey58 0.58039215686274515 0.58039215686274515 0.58039215686274515)
    (grey59 0.58823529411764708 0.58823529411764708 0.58823529411764708)
    (grey60 0.59999999999999998 0.59999999999999998 0.59999999999999998)
    (grey61 0.61176470588235299 0.61176470588235299 0.61176470588235299)
    (grey62 0.61960784313725492 0.61960784313725492 0.61960784313725492)
    (grey63 0.63137254901960782 0.63137254901960782 0.63137254901960782)
    (grey64 0.63921568627450975 0.63921568627450975 0.63921568627450975)
    (grey65 0.65098039215686276 0.65098039215686276 0.65098039215686276)
    (grey66 0.6588235294117647 0.6588235294117647 0.6588235294117647)
    (grey67 0.6705882352941176 0.6705882352941176 0.6705882352941176)
    (grey68 0.67843137254901964 0.67843137254901964 0.67843137254901964)
    (grey69 0.69019607843137254 0.69019607843137254 0.69019607843137254)
    (grey70 0.70196078431372544 0.70196078431372544 0.70196078431372544)
    (grey71 0.70980392156862748 0.70980392156862748 0.70980392156862748)
    (grey72 0.72156862745098038 0.72156862745098038 0.72156862745098038)
    (grey73 0.72941176470588232 0.72941176470588232 0.72941176470588232)
    (grey74 0.74117647058823533 0.74117647058823533 0.74117647058823533)
    (grey75 0.74901960784313726 0.74901960784313726 0.74901960784313726)
    (grey76 0.76078431372549016 0.76078431372549016 0.76078431372549016)
    (grey77 0.7686274509803922 0.7686274509803922 0.7686274509803922)
    (grey78 0.7803921568627451 0.7803921568627451 0.7803921568627451)
    (grey79 0.78823529411764703 0.78823529411764703 0.78823529411764703)
    (grey80 0.80000000000000004 0.80000000000000004 0.80000000000000004)
    (grey81 0.81176470588235294 0.81176470588235294 0.81176470588235294)
    (grey82 0.81960784313725488 0.81960784313725488 0.81960784313725488)
    (grey83 0.83137254901960789 0.83137254901960789 0.83137254901960789)
    (grey84 0.83921568627450982 0.83921568627450982 0.83921568627450982)
    (grey85 0.85098039215686272 0.85098039215686272 0.85098039215686272)
    (grey86 0.85882352941176465 0.85882352941176465 0.85882352941176465)
    (grey87 0.87058823529411766 0.87058823529411766 0.87058823529411766)
    (grey88 0.8784313725490196 0.8784313725490196 0.8784313725490196)
    (grey89 0.8901960784313725 0.8901960784313725 0.8901960784313725)
    (grey90 0.89803921568627454 0.89803921568627454 0.89803921568627454)
    (grey91 0.90980392156862744 0.90980392156862744 0.90980392156862744)
    (grey92 0.92156862745098034 0.92156862745098034 0.92156862745098034)
    (grey93 0.92941176470588238 0.92941176470588238 0.92941176470588238)
    (grey94 0.94117647058823528 0.94117647058823528 0.94117647058823528)
    (grey95 0.94901960784313721 0.94901960784313721 0.94901960784313721)
    (grey96 0.96078431372549022 0.96078431372549022 0.96078431372549022)
    (grey97 0.96862745098039216 0.96862745098039216 0.96862745098039216)
    (grey98 0.98039215686274506 0.98039215686274506 0.98039215686274506)
    (grey99 0.9882352941176471 0.9882352941176471 0.9882352941176471)
    (grey100 1 1 1)))

(define-public x11-colorN-list
  '((antiquewhite1 1 0.93725490196078431 0.85882352941176465)
    (antiquewhite2 0.93333333333333335 0.87450980392156863 0.80000000000000004)
    (antiquewhite3 0.80392156862745101 0.75294117647058822 0.69019607843137254)
    (antiquewhite4 0.54509803921568623 0.51372549019607838 0.47058823529411764)
    (aquamarine1 0.49803921568627452 1 0.83137254901960789)
    (aquamarine2 0.46274509803921571 0.93333333333333335 0.77647058823529413)
    (aquamarine3 0.40000000000000002 0.80392156862745101 0.66666666666666663)
    (aquamarine4 0.27058823529411763 0.54509803921568623 0.45490196078431372)
    (azure1 0.94117647058823528 1 1)
    (azure2 0.8784313725490196 0.93333333333333335 0.93333333333333335)
    (azure3 0.75686274509803919 0.80392156862745101 0.80392156862745101)
    (azure4 0.51372549019607838 0.54509803921568623 0.54509803921568623)
    (bisque1 1 0.89411764705882357 0.7686274509803922)
    (bisque2 0.93333333333333335 0.83529411764705885 0.71764705882352942)
    (bisque3 0.80392156862745101 0.71764705882352942 0.61960784313725492)
    (bisque4 0.54509803921568623 0.49019607843137253 0.41960784313725491)
    (blue1 0 0 1)
    (blue2 0 0 0.93333333333333335)
    (blue3 0 0 0.80392156862745101)
    (blue4 0 0 0.54509803921568623)
    (brown1 1 0.25098039215686274 0.25098039215686274)
    (brown2 0.93333333333333335 0.23137254901960785 0.23137254901960785)
    (brown3 0.80392156862745101 0.20000000000000001 0.20000000000000001)
    (brown4 0.54509803921568623 0.13725490196078433 0.13725490196078433)
    (burlywood1 1 0.82745098039215681 0.60784313725490191)
    (burlywood2 0.93333333333333335 0.77254901960784317 0.56862745098039214)
    (burlywood3 0.80392156862745101 0.66666666666666663 0.49019607843137253)
    (burlywood4 0.54509803921568623 0.45098039215686275 0.33333333333333331)
    (cadetblue1 0.59607843137254901 0.96078431372549022 1)
    (cadetblue2 0.55686274509803924 0.89803921568627454 0.93333333333333335)
    (cadetblue3 0.47843137254901963 0.77254901960784317 0.80392156862745101)
    (cadetblue4 0.32549019607843138 0.52549019607843139 0.54509803921568623)
    (chartreuse1 0.49803921568627452 1 0)
    (chartreuse2 0.46274509803921571 0.93333333333333335 0)
    (chartreuse3 0.40000000000000002 0.80392156862745101 0)
    (chartreuse4 0.27058823529411763 0.54509803921568623 0)
    (chocolate1 1 0.49803921568627452 0.14117647058823529)
    (chocolate2 0.93333333333333335 0.46274509803921571 0.12941176470588237)
    (chocolate3 0.80392156862745101 0.40000000000000002 0.11372549019607843)
    (chocolate4 0.54509803921568623 0.27058823529411763 0.074509803921568626)
    (coral1 1 0.44705882352941179 0.33725490196078434)
    (coral2 0.93333333333333335 0.41568627450980394 0.31372549019607843)
    (coral3 0.80392156862745101 0.35686274509803922 0.27058823529411763)
    (coral4 0.54509803921568623 0.24313725490196078 0.18431372549019609)
    (cornsilk1 1 0.97254901960784312 0.86274509803921573)
    (cornsilk2 0.93333333333333335 0.90980392156862744 0.80392156862745101)
    (cornsilk3 0.80392156862745101 0.78431372549019607 0.69411764705882351)
    (cornsilk4 0.54509803921568623 0.53333333333333333 0.47058823529411764)
    (cyan1 0 1 1)
    (cyan2 0 0.93333333333333335 0.93333333333333335)
    (cyan3 0 0.80392156862745101 0.80392156862745101)
    (cyan4 0 0.54509803921568623 0.54509803921568623)
    (darkgoldenrod1 1 0.72549019607843135 0.058823529411764705)
    (darkgoldenrod2 0.93333333333333335 0.67843137254901964 0.054901960784313725)
    (darkgoldenrod3 0.80392156862745101 0.58431372549019611 0.047058823529411764)
    (darkgoldenrod4 0.54509803921568623 0.396078431372549 0.031372549019607843)
    (darkolivegreen1 0.792156862745098 1 0.4392156862745098)
    (darkolivegreen2 0.73725490196078436 0.93333333333333335 0.40784313725490196)
    (darkolivegreen3 0.63529411764705879 0.80392156862745101 0.35294117647058826)
    (darkolivegreen4 0.43137254901960786 0.54509803921568623 0.23921568627450981)
    (darkorange1 1 0.49803921568627452 0)
    (darkorange2 0.93333333333333335 0.46274509803921571 0)
    (darkorange3 0.80392156862745101 0.40000000000000002 0)
    (darkorange4 0.54509803921568623 0.27058823529411763 0)
    (darkorchid1 0.74901960784313726 0.24313725490196078 1)
    (darkorchid2 0.69803921568627447 0.22745098039215686 0.93333333333333335)
    (darkorchid3 0.60392156862745094 0.19607843137254902 0.80392156862745101)
    (darkorchid4 0.40784313725490196 0.13333333333333333 0.54509803921568623)
    (darkseagreen1 0.75686274509803919 1 0.75686274509803919)
    (darkseagreen2 0.70588235294117652 0.93333333333333335 0.70588235294117652)
    (darkseagreen3 0.60784313725490191 0.80392156862745101 0.60784313725490191)
    (darkseagreen4 0.41176470588235292 0.54509803921568623 0.41176470588235292)
    (darkslategray1 0.59215686274509804 1 1)
    (darkslategray2 0.55294117647058827 0.93333333333333335 0.93333333333333335)
    (darkslategray3 0.47450980392156861 0.80392156862745101 0.80392156862745101)
    (darkslategray4 0.32156862745098042 0.54509803921568623 0.54509803921568623)
    (deeppink1 1 0.078431372549019607 0.57647058823529407)
    (deeppink2 0.93333333333333335 0.070588235294117646 0.53725490196078429)
    (deeppink3 0.80392156862745101 0.062745098039215685 0.46274509803921571)
    (deeppink4 0.54509803921568623 0.039215686274509803 0.31372549019607843)
    (deepskyblue1 0 0.74901960784313726 1)
    (deepskyblue2 0 0.69803921568627447 0.93333333333333335)
    (deepskyblue3 0 0.60392156862745094 0.80392156862745101)
    (deepskyblue4 0 0.40784313725490196 0.54509803921568623)
    (dodgerblue1 0.11764705882352941 0.56470588235294117 1)
    (dodgerblue2 0.10980392156862745 0.52549019607843139 0.93333333333333335)
    (dodgerblue3 0.094117647058823528 0.45490196078431372 0.80392156862745101)
    (dodgerblue4 0.062745098039215685 0.30588235294117649 0.54509803921568623)
    (firebrick1 1 0.18823529411764706 0.18823529411764706)
    (firebrick2 0.93333333333333335 0.17254901960784313 0.17254901960784313)
    (firebrick3 0.80392156862745101 0.14901960784313725 0.14901960784313725)
    (firebrick4 0.54509803921568623 0.10196078431372549 0.10196078431372549)
    (gold1 1 0.84313725490196079 0)
    (gold2 0.93333333333333335 0.78823529411764703 0)
    (gold3 0.80392156862745101 0.67843137254901964 0)
    (gold4 0.54509803921568623 0.45882352941176469 0)
    (goldenrod1 1 0.75686274509803919 0.14509803921568629)
    (goldenrod2 0.93333333333333335 0.70588235294117652 0.13333333333333333)
    (goldenrod3 0.80392156862745101 0.60784313725490191 0.11372549019607843)
    (goldenrod4 0.54509803921568623 0.41176470588235292 0.078431372549019607)
    (green1 0 1 0)
    (green2 0 0.93333333333333335 0)
    (green3 0 0.80392156862745101 0)
    (green4 0 0.54509803921568623 0)
    (honeydew1 0.94117647058823528 1 0.94117647058823528)
    (honeydew2 0.8784313725490196 0.93333333333333335 0.8784313725490196)
    (honeydew3 0.75686274509803919 0.80392156862745101 0.75686274509803919)
    (honeydew4 0.51372549019607838 0.54509803921568623 0.51372549019607838)
    (hotpink1 1 0.43137254901960786 0.70588235294117652)
    (hotpink2 0.93333333333333335 0.41568627450980394 0.65490196078431373)
    (hotpink3 0.80392156862745101 0.37647058823529411 0.56470588235294117)
    (hotpink4 0.54509803921568623 0.22745098039215686 0.3843137254901961)
    (indianred1 1 0.41568627450980394 0.41568627450980394)
    (indianred2 0.93333333333333335 0.38823529411764707 0.38823529411764707)
    (indianred3 0.80392156862745101 0.33333333333333331 0.33333333333333331)
    (indianred4 0.54509803921568623 0.22745098039215686 0.22745098039215686)
    (ivory1 1 1 0.94117647058823528)
    (ivory2 0.93333333333333335 0.93333333333333335 0.8784313725490196)
    (ivory3 0.80392156862745101 0.80392156862745101 0.75686274509803919)
    (ivory4 0.54509803921568623 0.54509803921568623 0.51372549019607838)
    (khaki1 1 0.96470588235294119 0.5607843137254902)
    (khaki2 0.93333333333333335 0.90196078431372551 0.52156862745098043)
    (khaki3 0.80392156862745101 0.77647058823529413 0.45098039215686275)
    (khaki4 0.54509803921568623 0.52549019607843139 0.30588235294117649)
    (lavenderblush1 1 0.94117647058823528 0.96078431372549022)
    (lavenderblush2 0.93333333333333335 0.8784313725490196 0.89803921568627454)
    (lavenderblush3 0.80392156862745101 0.75686274509803919 0.77254901960784317)
    (lavenderblush4 0.54509803921568623 0.51372549019607838 0.52549019607843139)
    (lemonchiffon1 1 0.98039215686274506 0.80392156862745101)
    (lemonchiffon2 0.93333333333333335 0.9137254901960784 0.74901960784313726)
    (lemonchiffon3 0.80392156862745101 0.78823529411764703 0.6470588235294118)
    (lemonchiffon4 0.54509803921568623 0.53725490196078429 0.4392156862745098)
    (lightblue1 0.74901960784313726 0.93725490196078431 1)
    (lightblue2 0.69803921568627447 0.87450980392156863 0.93333333333333335)
    (lightblue3 0.60392156862745094 0.75294117647058822 0.80392156862745101)
    (lightblue4 0.40784313725490196 0.51372549019607838 0.54509803921568623)
    (lightcyan1 0.8784313725490196 1 1)
    (lightcyan2 0.81960784313725488 0.93333333333333335 0.93333333333333335)
    (lightcyan3 0.70588235294117652 0.80392156862745101 0.80392156862745101)
    (lightcyan4 0.47843137254901963 0.54509803921568623 0.54509803921568623)
    (lightgoldenrod1 1 0.92549019607843142 0.54509803921568623)
    (lightgoldenrod2 0.93333333333333335 0.86274509803921573 0.50980392156862742)
    (lightgoldenrod3 0.80392156862745101 0.74509803921568629 0.4392156862745098)
    (lightgoldenrod4 0.54509803921568623 0.50588235294117645 0.29803921568627451)
    (lightpink1 1 0.68235294117647061 0.72549019607843135)
    (lightpink2 0.93333333333333335 0.63529411764705879 0.67843137254901964)
    (lightpink3 0.80392156862745101 0.5490196078431373 0.58431372549019611)
    (lightpink4 0.54509803921568623 0.37254901960784315 0.396078431372549)
    (lightsalmon1 1 0.62745098039215685 0.47843137254901963)
    (lightsalmon2 0.93333333333333335 0.58431372549019611 0.44705882352941179)
    (lightsalmon3 0.80392156862745101 0.50588235294117645 0.3843137254901961)
    (lightsalmon4 0.54509803921568623 0.3411764705882353 0.25882352941176473)
    (lightskyblue1 0.69019607843137254 0.88627450980392153 1)
    (lightskyblue2 0.64313725490196083 0.82745098039215681 0.93333333333333335)
    (lightskyblue3 0.55294117647058827 0.71372549019607845 0.80392156862745101)
    (lightskyblue4 0.37647058823529411 0.4823529411764706 0.54509803921568623)
    (lightsteelblue1 0.792156862745098 0.88235294117647056 1)
    (lightsteelblue2 0.73725490196078436 0.82352941176470584 0.93333333333333335)
    (lightsteelblue3 0.63529411764705879 0.70980392156862748 0.80392156862745101)
    (lightsteelblue4 0.43137254901960786 0.4823529411764706 0.54509803921568623)
    (lightyellow1 1 1 0.8784313725490196)
    (lightyellow2 0.93333333333333335 0.93333333333333335 0.81960784313725488)
    (lightyellow3 0.80392156862745101 0.80392156862745101 0.70588235294117652)
    (lightyellow4 0.54509803921568623 0.54509803921568623 0.47843137254901963)
    (magenta1 1 0 1)
    (magenta2 0.93333333333333335 0 0.93333333333333335)
    (magenta3 0.80392156862745101 0 0.80392156862745101)
    (magenta4 0.54509803921568623 0 0.54509803921568623)
    (maroon1 1 0.20392156862745098 0.70196078431372544)
    (maroon2 0.93333333333333335 0.18823529411764706 0.65490196078431373)
    (maroon3 0.80392156862745101 0.16078431372549021 0.56470588235294117)
    (maroon4 0.54509803921568623 0.10980392156862745 0.3843137254901961)
    (mediumorchid1 0.8784313725490196 0.40000000000000002 1)
    (mediumorchid2 0.81960784313725488 0.37254901960784315 0.93333333333333335)
    (mediumorchid3 0.70588235294117652 0.32156862745098042 0.80392156862745101)
    (mediumorchid4 0.47843137254901963 0.21568627450980393 0.54509803921568623)
    (mediumpurple1 0.6705882352941176 0.50980392156862742 1)
    (mediumpurple2 0.62352941176470589 0.47450980392156861 0.93333333333333335)
    (mediumpurple3 0.53725490196078429 0.40784313725490196 0.80392156862745101)
    (mediumpurple4 0.36470588235294116 0.27843137254901962 0.54509803921568623)
    (mistyrose1 1 0.89411764705882357 0.88235294117647056)
    (mistyrose2 0.93333333333333335 0.83529411764705885 0.82352941176470584)
    (mistyrose3 0.80392156862745101 0.71764705882352942 0.70980392156862748)
    (mistyrose4 0.54509803921568623 0.49019607843137253 0.4823529411764706)
    (navajowhite1 1 0.87058823529411766 0.67843137254901964)
    (navajowhite2 0.93333333333333335 0.81176470588235294 0.63137254901960782)
    (navajowhite3 0.80392156862745101 0.70196078431372544 0.54509803921568623)
    (navajowhite4 0.54509803921568623 0.47450980392156861 0.36862745098039218)
    (olivedrab1 0.75294117647058822 1 0.24313725490196078)
    (olivedrab2 0.70196078431372544 0.93333333333333335 0.22745098039215686)
    (olivedrab3 0.60392156862745094 0.80392156862745101 0.19607843137254902)
    (olivedrab4 0.41176470588235292 0.54509803921568623 0.13333333333333333)
    (orange1 1 0.6470588235294118 0)
    (orange2 0.93333333333333335 0.60392156862745094 0)
    (orange3 0.80392156862745101 0.52156862745098043 0)
    (orange4 0.54509803921568623 0.35294117647058826 0)
    (orangered1 1 0.27058823529411763 0)
    (orangered2 0.93333333333333335 0.25098039215686274 0)
    (orangered3 0.80392156862745101 0.21568627450980393 0)
    (orangered4 0.54509803921568623 0.14509803921568629 0)
    (orchid1 1 0.51372549019607838 0.98039215686274506)
    (orchid2 0.93333333333333335 0.47843137254901963 0.9137254901960784)
    (orchid3 0.80392156862745101 0.41176470588235292 0.78823529411764703)
    (orchid4 0.54509803921568623 0.27843137254901962 0.53725490196078429)
    (palegreen1 0.60392156862745094 1 0.60392156862745094)
    (palegreen2 0.56470588235294117 0.93333333333333335 0.56470588235294117)
    (palegreen3 0.48627450980392156 0.80392156862745101 0.48627450980392156)
    (palegreen4 0.32941176470588235 0.54509803921568623 0.32941176470588235)
    (paleturquoise1 0.73333333333333328 1 1)
    (paleturquoise2 0.68235294117647061 0.93333333333333335 0.93333333333333335)
    (paleturquoise3 0.58823529411764708 0.80392156862745101 0.80392156862745101)
    (paleturquoise4 0.40000000000000002 0.54509803921568623 0.54509803921568623)
    (palevioletred1 1 0.50980392156862742 0.6705882352941176)
    (palevioletred2 0.93333333333333335 0.47450980392156861 0.62352941176470589)
    (palevioletred3 0.80392156862745101 0.40784313725490196 0.53725490196078429)
    (palevioletred4 0.54509803921568623 0.27843137254901962 0.36470588235294116)
    (peachpuff1 1 0.85490196078431369 0.72549019607843135)
    (peachpuff2 0.93333333333333335 0.79607843137254897 0.67843137254901964)
    (peachpuff3 0.80392156862745101 0.68627450980392157 0.58431372549019611)
    (peachpuff4 0.54509803921568623 0.46666666666666667 0.396078431372549)
    (pink1 1 0.70980392156862748 0.77254901960784317)
    (pink2 0.93333333333333335 0.66274509803921566 0.72156862745098038)
    (pink3 0.80392156862745101 0.56862745098039214 0.61960784313725492)
    (pink4 0.54509803921568623 0.38823529411764707 0.42352941176470588)
    (plum1 1 0.73333333333333328 1)
    (plum2 0.93333333333333335 0.68235294117647061 0.93333333333333335)
    (plum3 0.80392156862745101 0.58823529411764708 0.80392156862745101)
    (plum4 0.54509803921568623 0.40000000000000002 0.54509803921568623)
    (purple1 0.60784313725490191 0.18823529411764706 1)
    (purple2 0.56862745098039214 0.17254901960784313 0.93333333333333335)
    (purple3 0.49019607843137253 0.14901960784313725 0.80392156862745101)
    (purple4 0.33333333333333331 0.10196078431372549 0.54509803921568623)
    (red1 1 0 0)
    (red2 0.93333333333333335 0 0)
    (red3 0.80392156862745101 0 0)
    (red4 0.54509803921568623 0 0)
    (rosybrown1 1 0.75686274509803919 0.75686274509803919)
    (rosybrown2 0.93333333333333335 0.70588235294117652 0.70588235294117652)
    (rosybrown3 0.80392156862745101 0.60784313725490191 0.60784313725490191)
    (rosybrown4 0.54509803921568623 0.41176470588235292 0.41176470588235292)
    (royalblue1 0.28235294117647058 0.46274509803921571 1)
    (royalblue2 0.2627450980392157 0.43137254901960786 0.93333333333333335)
    (royalblue3 0.22745098039215686 0.37254901960784315 0.80392156862745101)
    (royalblue4 0.15294117647058825 0.25098039215686274 0.54509803921568623)
    (salmon1 1 0.5490196078431373 0.41176470588235292)
    (salmon2 0.93333333333333335 0.50980392156862742 0.3843137254901961)
    (salmon3 0.80392156862745101 0.4392156862745098 0.32941176470588235)
    (salmon4 0.54509803921568623 0.29803921568627451 0.22352941176470589)
    (seagreen1 0.32941176470588235 1 0.62352941176470589)
    (seagreen2 0.30588235294117649 0.93333333333333335 0.58039215686274515)
    (seagreen3 0.2627450980392157 0.80392156862745101 0.50196078431372548)
    (seagreen4 0.1803921568627451 0.54509803921568623 0.3411764705882353)
    (seashell1 1 0.96078431372549022 0.93333333333333335)
    (seashell2 0.93333333333333335 0.89803921568627454 0.87058823529411766)
    (seashell3 0.80392156862745101 0.77254901960784317 0.74901960784313726)
    (seashell4 0.54509803921568623 0.52549019607843139 0.50980392156862742)
    (sienna1 1 0.50980392156862742 0.27843137254901962)
    (sienna2 0.93333333333333335 0.47450980392156861 0.25882352941176473)
    (sienna3 0.80392156862745101 0.40784313725490196 0.22352941176470589)
    (sienna4 0.54509803921568623 0.27843137254901962 0.14901960784313725)
    (skyblue1 0.52941176470588236 0.80784313725490198 1)
    (skyblue2 0.49411764705882355 0.75294117647058822 0.93333333333333335)
    (skyblue3 0.42352941176470588 0.65098039215686276 0.80392156862745101)
    (skyblue4 0.29019607843137257 0.4392156862745098 0.54509803921568623)
    (slateblue1 0.51372549019607838 0.43529411764705883 1)
    (slateblue2 0.47843137254901963 0.40392156862745099 0.93333333333333335)
    (slateblue3 0.41176470588235292 0.34901960784313724 0.80392156862745101)
    (slateblue4 0.27843137254901962 0.23529411764705882 0.54509803921568623)
    (slategray1 0.77647058823529413 0.88627450980392153 1)
    (slategray2 0.72549019607843135 0.82745098039215681 0.93333333333333335)
    (slategray3 0.62352941176470589 0.71372549019607845 0.80392156862745101)
    (slategray4 0.42352941176470588 0.4823529411764706 0.54509803921568623)
    (snow1 1 0.98039215686274506 0.98039215686274506)
    (snow2 0.93333333333333335 0.9137254901960784 0.9137254901960784)
    (snow3 0.80392156862745101 0.78823529411764703 0.78823529411764703)
    (snow4 0.54509803921568623 0.53725490196078429 0.53725490196078429)
    (springgreen1 0 1 0.49803921568627452)
    (springgreen2 0 0.93333333333333335 0.46274509803921571)
    (springgreen3 0 0.80392156862745101 0.40000000000000002)
    (springgreen4 0 0.54509803921568623 0.27058823529411763)
    (steelblue1 0.38823529411764707 0.72156862745098038 1)
    (steelblue2 0.36078431372549019 0.67450980392156867 0.93333333333333335)
    (steelblue3 0.30980392156862746 0.58039215686274515 0.80392156862745101)
    (steelblue4 0.21176470588235294 0.39215686274509803 0.54509803921568623)
    (tan1 1 0.6470588235294118 0.30980392156862746)
    (tan2 0.93333333333333335 0.60392156862745094 0.28627450980392155)
    (tan3 0.80392156862745101 0.52156862745098043 0.24705882352941178)
    (tan4 0.54509803921568623 0.35294117647058826 0.16862745098039217)
    (thistle1 1 0.88235294117647056 1)
    (thistle2 0.93333333333333335 0.82352941176470584 0.93333333333333335)
    (thistle3 0.80392156862745101 0.70980392156862748 0.80392156862745101)
    (thistle4 0.54509803921568623 0.4823529411764706 0.54509803921568623)
    (tomato1 1 0.38823529411764707 0.27843137254901962)
    (tomato2 0.93333333333333335 0.36078431372549019 0.25882352941176473)
    (tomato3 0.80392156862745101 0.30980392156862746 0.22352941176470589)
    (tomato4 0.54509803921568623 0.21176470588235294 0.14901960784313725)
    (turquoise1 0 0.96078431372549022 1)
    (turquoise2 0 0.89803921568627454 0.93333333333333335)
    (turquoise3 0 0.77254901960784317 0.80392156862745101)
    (turquoise4 0 0.52549019607843139 0.54509803921568623)
    (violetred1 1 0.24313725490196078 0.58823529411764708)
    (violetred2 0.93333333333333335 0.22745098039215686 0.5490196078431373)
    (violetred3 0.80392156862745101 0.19607843137254902 0.47058823529411764)
    (violetred4 0.54509803921568623 0.13333333333333333 0.32156862745098042)
    (wheat1 1 0.90588235294117647 0.72941176470588232)
    (wheat2 0.93333333333333335 0.84705882352941175 0.68235294117647061)
    (wheat3 0.80392156862745101 0.72941176470588232 0.58823529411764708)
    (wheat4 0.54509803921568623 0.49411764705882355 0.40000000000000002)
    (yellow1 1 1 0)
    (yellow2 0.93333333333333335 0.93333333333333335 0)
    (yellow3 0.80392156862745101 0.80392156862745101 0)
    (yellow4 0.54509803921568623 0.54509803921568623 0)))

(define css-different-color-list
  '((gray 0.501960784313725 0.501960784313725 0.501960784313725)
    (green 0 0.501960784313725 0)
    (grey 0.501960784313725 0.501960784313725 0.501960784313725)
    (maroon 0.501960784313725 0 0)
    (purple 0.501960784313725 0 0.501960784313725)))

(define-public x11-unnumbered-color-list
  (append
   shared-color-list
   x11-different-color-list
   '((lightgoldenrod 0.93333333333333335 0.8666666666666667 0.50980392156862742)
     (lightslateblue 0.51764705882352946 0.4392156862745098 1)
     (navyblue 0 0 0.50196078431372548)
     (violetred 0.81568627450980391 0.12549019607843137 0.56470588235294117))))

;; Documentation for the 'unnumbered-color', 'colorN', and 'grayN' sublists is
;; generated separately.
(define x11-color-list
  (append
   x11-unnumbered-color-list
   x11-colorN-list
   x11-grayN-list
   x11-greyN-list))

(define-public css-color-list
  (append
   shared-color-list
   css-different-color-list
   '((aqua 0 1 1)
     (crimson 0.862745098039216 0.784313725490196 0.235294117647059)
     (fuchsia 1 0 1)
     (indigo 0.294117647058824 0 0.509803921568627)
     (lime 0 1 0)
     (olive 0.501960784313725 0.501960784313725 0)
     (rebeccapurple 0.4 0.2 0.6)
     (silver 0.752941176470588 0.752941176470588 0.752941176470588)
     (teal 0 0.501960784313725 0.501960784313725))))

;; a color set unambiguous to both color-blind and non-color-blind
;; people (Okabe and Ito, https://jfly.uni-koeln.de/color)
(define-public universal-color-list
  '((black 0 0 0)
    (orange 0.9019607843137255 0.6235294117647059 0)
    (skyblue 0.3137254901960784 0.7058823529411765 0.9137254901960784)
    (bluegreen 0 0.6196078431372549 0.4509803921568628)
    (yellow 0.9411764705882353 0.8941176470588236 0.2588235294117647)
    (blue 0 0.4470588235294118 0.6980392156862745)
    (vermillion 0.8352941176470589 0.3686274509803922 0)
    (redpurple 0.8 0.4745098039215686 0.6549019607843137)))

(define (make-color-handler color-list)
  (let
      ((color-table (make-hash-table 31)))

    (lambda (arg)
      (let*
          ((arg-sym (if (string? arg)
                        (if (string-index arg #\ )
                            (let
                                ((arg-list (string-split (string-downcase arg) #\ )))

                              (string->symbol
                               (let append-all ((x arg-list))
                                 (if (null? x)
                                     ""
                                     (string-append (car x) (append-all (cdr x)))))))

                            (string->symbol (string-downcase arg)))
                        (string->symbol (string-downcase (symbol->string arg)))))

           (temp (hashq-ref color-table arg-sym)))

        (if temp
            temp
            (let*
                ((temp-1 (assq-ref color-list arg-sym))
                 (temp (if temp-1 temp-1 '(0 0 0))))
              (if (not temp-1)
                  (ly:warning (G_ "Requested color '~a' is not defined!") arg-sym))
              (hashq-create-handle! color-table arg-sym temp)
              temp))))))

(define-public x11-color (make-color-handler x11-color-list))
(define-public css-color (make-color-handler css-color-list))
(define-public universal-color (make-color-handler universal-color-list))

(define-public (normalize-color color)
  "Convert a color given in any of the supported formats into a list of 4 numbers:
R, G, B, A.  Possible formats are: such a list of 4 numbers; a list of 3 numbers
(transparency defaults to 1.0); a CSS string (named color, or @qq{#RRGGBB}, or
@qq{#RRGGBBAA}, or @qq{#RGB}, or @qq{#RGBA})."
  (unless (color? color)
    (scm-error 'wrong-type-arg "normalize-color" "color expected: ~a"
               (list color) #f))
  (match color
    ((r g b a)
     color)
    ((r g b)
     (list r g b 1.0))
    ((? string?)
     (let process ((char-list (string->list (string-downcase color))))
       (match char-list
         ((#\# r g b)
          (process (list #\# r r g g b b #\f #\f)))
         ((#\# r g b a)
          (process (list #\# r r g g b b a a)))
         ((#\# r1 r2 g1 g2 b1 b2)
          (process (list #\# r1 r2 g1 g2 b1 b2 #\f #\f)))
         ((#\# r1 r2 g1 g2 b1 b2 a1 a2)
          (map
           (lambda (s)
             (let ((val (string->number s 16)))
               (if val
                   (/ (exact->inexact val)
                      255)
                   (error 'misc-error
                          (format #f
                                  "wrong hexadecimal number in CSS color: '~a'" s)))))
           (list (string r1 r2)
                 (string g1 g2)
                 (string b1 b2)
                 (string a1 a2))))
         ((#\# . _)
          (error 'misc-error
                 (format #f "unrecognized CSS #-style color '~a'.
Color should be #RGB, #RGBA, #RRGGBB or #RRGGBBAA"
                         color)))
         (_
          (match (css-color color)
            ((r g b)
             (list r g b 1.0)))))))))
