// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +zbb -emit-llvm %s -o - \
// RUN:     | FileCheck %s  -check-prefix=RV32ZBB

// RV32ZBB-LABEL: @orc_b_32(
// RV32ZBB-NEXT:  entry:
// RV32ZBB-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// RV32ZBB-NEXT:    store i32 [[A:%.*]], ptr [[A_ADDR]], align 4
// RV32ZBB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// RV32ZBB-NEXT:    [[TMP1:%.*]] = call i32 @llvm.riscv.orc.b.i32(i32 [[TMP0]])
// RV32ZBB-NEXT:    ret i32 [[TMP1]]
//
int orc_b_32(int a) {
  return __builtin_riscv_orc_b_32(a);
}

// RV32ZBB-LABEL: @clz_32(
// RV32ZBB-NEXT:  entry:
// RV32ZBB-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// RV32ZBB-NEXT:    store i32 [[A:%.*]], ptr [[A_ADDR]], align 4
// RV32ZBB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// RV32ZBB-NEXT:    [[TMP1:%.*]] = call i32 @llvm.ctlz.i32(i32 [[TMP0]], i1 false)
// RV32ZBB-NEXT:    ret i32 [[TMP1]]
//
int clz_32(int a) {
  return __builtin_riscv_clz_32(a);
}

// RV32ZBB-LABEL: @ctz_32(
// RV32ZBB-NEXT:  entry:
// RV32ZBB-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// RV32ZBB-NEXT:    store i32 [[A:%.*]], ptr [[A_ADDR]], align 4
// RV32ZBB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// RV32ZBB-NEXT:    [[TMP1:%.*]] = call i32 @llvm.cttz.i32(i32 [[TMP0]], i1 false)
// RV32ZBB-NEXT:    ret i32 [[TMP1]]
//
int ctz_32(int a) {
  return __builtin_riscv_ctz_32(a);
}