#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "localizer.h"
#include "config.h"

int main (int argc, char **argv) {
	localizer *l = NULL;
	l_status_export lst;
	
	printf("loc-info (using localizer C-API %s)\n", PACKAGE_VERSION);
	
	if (argc != 1) {
		printf("Displays some information about the localizer DB\n");
		exit(-1);
	}
	
	l = localizer_init();
	
	if (localizer_read_shm(l, NULL)) return -1;
	if (localizer_status(l, &lst)) return -1;
	
	
	printf("API-Version    : %s\n", PACKAGE_VERSION);
	printf("num. of entries: %d\n", lst.num_elements);
	
	if (lst.shm_enabled) {
		char buf[255];
		strftime(buf, sizeof(buf)-1, "%d.%m.%Y", localtime(&(lst.shm_last_mod)));
		printf("Storage        : Shared Memory\n");
		printf("SHM size       : %d bytes\n", lst.shm_size);
		printf("DB  size       : %ld bytes\n", lst.shm_db_size);
		printf("last DB mod    : %s\n", buf);
	} else {
		printf("Storage        : Local Memory\n");
	}
		
	localizer_free(l);
	
	return 0;
}
