%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of VivoMind Prolog Unicode Resources
%  SPDX-License-Identifier: CC0-1.0
%
%  VivoMind Prolog Unicode Resources is free software distributed using the
%  Creative Commons CC0 1.0 Universal (CC0 1.0) - Public Domain Dedication
%  license
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  Last modified: June 20, 2013
%
%  File derived from the "unicode_alphabetic.pl" file by merging the
%  consecutive intervals for better performance of the unicode_alphabetic/2
%  predicate

unicode_alphabetic(CodePoint) :-
	(	var(CodePoint) ->
		% generate code point pairs
		unicode_range_alphabetic(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint)
	;	% try first-argument indexing first
		unicode_range_alphabetic(CodePoint, _) ->
		true
	;	% look for a code point range that includes the given code point
		unicode_range_alphabetic(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint) ->
		true
	).

unicode_range_alphabetic(0x0041, 0x005A).
unicode_range_alphabetic(0x0061, 0x007A).
unicode_range_alphabetic(0x00AA, 0x00AA).
unicode_range_alphabetic(0x00B5, 0x00B5).
unicode_range_alphabetic(0x00BA, 0x00BA).
unicode_range_alphabetic(0x00C0, 0x00D6).
unicode_range_alphabetic(0x00D8, 0x00F6).
unicode_range_alphabetic(0x00F8, 0x02C1).
unicode_range_alphabetic(0x02C6, 0x02D1).
unicode_range_alphabetic(0x02E0, 0x02E4).
unicode_range_alphabetic(0x02EC, 0x02EC).
unicode_range_alphabetic(0x02EE, 0x02EE).
unicode_range_alphabetic(0x0345, 0x0345).
unicode_range_alphabetic(0x0370, 0x0374).
unicode_range_alphabetic(0x0376, 0x0377).
unicode_range_alphabetic(0x037A, 0x037D).
unicode_range_alphabetic(0x0386, 0x0386).
unicode_range_alphabetic(0x0388, 0x038A).
unicode_range_alphabetic(0x038C, 0x038C).
unicode_range_alphabetic(0x038E, 0x03A1).
unicode_range_alphabetic(0x03A3, 0x03F5).
unicode_range_alphabetic(0x03F7, 0x0481).
unicode_range_alphabetic(0x048A, 0x0527).
unicode_range_alphabetic(0x0531, 0x0556).
unicode_range_alphabetic(0x0559, 0x0559).
unicode_range_alphabetic(0x0561, 0x0587).
unicode_range_alphabetic(0x05B0, 0x05BD).
unicode_range_alphabetic(0x05BF, 0x05BF).
unicode_range_alphabetic(0x05C1, 0x05C2).
unicode_range_alphabetic(0x05C4, 0x05C5).
unicode_range_alphabetic(0x05C7, 0x05C7).
unicode_range_alphabetic(0x05D0, 0x05EA).
unicode_range_alphabetic(0x05F0, 0x05F2).
unicode_range_alphabetic(0x0610, 0x061A).
unicode_range_alphabetic(0x0620, 0x0657).
unicode_range_alphabetic(0x0659, 0x065F).
unicode_range_alphabetic(0x066E, 0x06D3).
unicode_range_alphabetic(0x06D5, 0x06DC).
unicode_range_alphabetic(0x06E1, 0x06E8).
unicode_range_alphabetic(0x06ED, 0x06EF).
unicode_range_alphabetic(0x06FA, 0x06FC).
unicode_range_alphabetic(0x06FF, 0x06FF).
unicode_range_alphabetic(0x0710, 0x073F).
unicode_range_alphabetic(0x074D, 0x07B1).
unicode_range_alphabetic(0x07CA, 0x07EA).
unicode_range_alphabetic(0x07F4, 0x07F5).
unicode_range_alphabetic(0x07FA, 0x07FA).
unicode_range_alphabetic(0x0800, 0x0817).
unicode_range_alphabetic(0x081A, 0x082C).
unicode_range_alphabetic(0x0840, 0x0858).
unicode_range_alphabetic(0x08A0, 0x08A0).
unicode_range_alphabetic(0x08A2, 0x08AC).
unicode_range_alphabetic(0x08E4, 0x08E9).
unicode_range_alphabetic(0x08F0, 0x08FE).
unicode_range_alphabetic(0x0900, 0x093B).
unicode_range_alphabetic(0x093D, 0x094C).
unicode_range_alphabetic(0x094E, 0x0950).
unicode_range_alphabetic(0x0955, 0x0963).
unicode_range_alphabetic(0x0971, 0x0977).
unicode_range_alphabetic(0x0979, 0x097F).
unicode_range_alphabetic(0x0981, 0x0983).
unicode_range_alphabetic(0x0985, 0x098C).
unicode_range_alphabetic(0x098F, 0x0990).
unicode_range_alphabetic(0x0993, 0x09A8).
unicode_range_alphabetic(0x09AA, 0x09B0).
unicode_range_alphabetic(0x09B2, 0x09B2).
unicode_range_alphabetic(0x09B6, 0x09B9).
unicode_range_alphabetic(0x09BD, 0x09C4).
unicode_range_alphabetic(0x09C7, 0x09C8).
unicode_range_alphabetic(0x09CB, 0x09CC).
unicode_range_alphabetic(0x09CE, 0x09CE).
unicode_range_alphabetic(0x09D7, 0x09D7).
unicode_range_alphabetic(0x09DC, 0x09DD).
unicode_range_alphabetic(0x09DF, 0x09E3).
unicode_range_alphabetic(0x09F0, 0x09F1).
unicode_range_alphabetic(0x0A01, 0x0A03).
unicode_range_alphabetic(0x0A05, 0x0A0A).
unicode_range_alphabetic(0x0A0F, 0x0A10).
unicode_range_alphabetic(0x0A13, 0x0A28).
unicode_range_alphabetic(0x0A2A, 0x0A30).
unicode_range_alphabetic(0x0A32, 0x0A33).
unicode_range_alphabetic(0x0A35, 0x0A36).
unicode_range_alphabetic(0x0A38, 0x0A39).
unicode_range_alphabetic(0x0A3E, 0x0A42).
unicode_range_alphabetic(0x0A47, 0x0A48).
unicode_range_alphabetic(0x0A4B, 0x0A4C).
unicode_range_alphabetic(0x0A51, 0x0A51).
unicode_range_alphabetic(0x0A59, 0x0A5C).
unicode_range_alphabetic(0x0A5E, 0x0A5E).
unicode_range_alphabetic(0x0A70, 0x0A75).
unicode_range_alphabetic(0x0A81, 0x0A83).
unicode_range_alphabetic(0x0A85, 0x0A8D).
unicode_range_alphabetic(0x0A8F, 0x0A91).
unicode_range_alphabetic(0x0A93, 0x0AA8).
unicode_range_alphabetic(0x0AAA, 0x0AB0).
unicode_range_alphabetic(0x0AB2, 0x0AB3).
unicode_range_alphabetic(0x0AB5, 0x0AB9).
unicode_range_alphabetic(0x0ABD, 0x0AC5).
unicode_range_alphabetic(0x0AC7, 0x0AC9).
unicode_range_alphabetic(0x0ACB, 0x0ACC).
unicode_range_alphabetic(0x0AD0, 0x0AD0).
unicode_range_alphabetic(0x0AE0, 0x0AE3).
unicode_range_alphabetic(0x0B01, 0x0B03).
unicode_range_alphabetic(0x0B05, 0x0B0C).
unicode_range_alphabetic(0x0B0F, 0x0B10).
unicode_range_alphabetic(0x0B13, 0x0B28).
unicode_range_alphabetic(0x0B2A, 0x0B30).
unicode_range_alphabetic(0x0B32, 0x0B33).
unicode_range_alphabetic(0x0B35, 0x0B39).
unicode_range_alphabetic(0x0B3D, 0x0B44).
unicode_range_alphabetic(0x0B47, 0x0B48).
unicode_range_alphabetic(0x0B4B, 0x0B4C).
unicode_range_alphabetic(0x0B56, 0x0B57).
unicode_range_alphabetic(0x0B5C, 0x0B5D).
unicode_range_alphabetic(0x0B5F, 0x0B63).
unicode_range_alphabetic(0x0B71, 0x0B71).
unicode_range_alphabetic(0x0B82, 0x0B83).
unicode_range_alphabetic(0x0B85, 0x0B8A).
unicode_range_alphabetic(0x0B8E, 0x0B90).
unicode_range_alphabetic(0x0B92, 0x0B95).
unicode_range_alphabetic(0x0B99, 0x0B9A).
unicode_range_alphabetic(0x0B9C, 0x0B9C).
unicode_range_alphabetic(0x0B9E, 0x0B9F).
unicode_range_alphabetic(0x0BA3, 0x0BA4).
unicode_range_alphabetic(0x0BA8, 0x0BAA).
unicode_range_alphabetic(0x0BAE, 0x0BB9).
unicode_range_alphabetic(0x0BBE, 0x0BC2).
unicode_range_alphabetic(0x0BC6, 0x0BC8).
unicode_range_alphabetic(0x0BCA, 0x0BCC).
unicode_range_alphabetic(0x0BD0, 0x0BD0).
unicode_range_alphabetic(0x0BD7, 0x0BD7).
unicode_range_alphabetic(0x0C01, 0x0C03).
unicode_range_alphabetic(0x0C05, 0x0C0C).
unicode_range_alphabetic(0x0C0E, 0x0C10).
unicode_range_alphabetic(0x0C12, 0x0C28).
unicode_range_alphabetic(0x0C2A, 0x0C33).
unicode_range_alphabetic(0x0C35, 0x0C39).
unicode_range_alphabetic(0x0C3D, 0x0C44).
unicode_range_alphabetic(0x0C46, 0x0C48).
unicode_range_alphabetic(0x0C4A, 0x0C4C).
unicode_range_alphabetic(0x0C55, 0x0C56).
unicode_range_alphabetic(0x0C58, 0x0C59).
unicode_range_alphabetic(0x0C60, 0x0C63).
unicode_range_alphabetic(0x0C82, 0x0C83).
unicode_range_alphabetic(0x0C85, 0x0C8C).
unicode_range_alphabetic(0x0C8E, 0x0C90).
unicode_range_alphabetic(0x0C92, 0x0CA8).
unicode_range_alphabetic(0x0CAA, 0x0CB3).
unicode_range_alphabetic(0x0CB5, 0x0CB9).
unicode_range_alphabetic(0x0CBD, 0x0CC4).
unicode_range_alphabetic(0x0CC6, 0x0CC8).
unicode_range_alphabetic(0x0CCA, 0x0CCC).
unicode_range_alphabetic(0x0CD5, 0x0CD6).
unicode_range_alphabetic(0x0CDE, 0x0CDE).
unicode_range_alphabetic(0x0CE0, 0x0CE3).
unicode_range_alphabetic(0x0CF1, 0x0CF2).
unicode_range_alphabetic(0x0D02, 0x0D03).
unicode_range_alphabetic(0x0D05, 0x0D0C).
unicode_range_alphabetic(0x0D0E, 0x0D10).
unicode_range_alphabetic(0x0D12, 0x0D3A).
unicode_range_alphabetic(0x0D3D, 0x0D44).
unicode_range_alphabetic(0x0D46, 0x0D48).
unicode_range_alphabetic(0x0D4A, 0x0D4C).
unicode_range_alphabetic(0x0D4E, 0x0D4E).
unicode_range_alphabetic(0x0D57, 0x0D57).
unicode_range_alphabetic(0x0D60, 0x0D63).
unicode_range_alphabetic(0x0D7A, 0x0D7F).
unicode_range_alphabetic(0x0D82, 0x0D83).
unicode_range_alphabetic(0x0D85, 0x0D96).
unicode_range_alphabetic(0x0D9A, 0x0DB1).
unicode_range_alphabetic(0x0DB3, 0x0DBB).
unicode_range_alphabetic(0x0DBD, 0x0DBD).
unicode_range_alphabetic(0x0DC0, 0x0DC6).
unicode_range_alphabetic(0x0DCF, 0x0DD4).
unicode_range_alphabetic(0x0DD6, 0x0DD6).
unicode_range_alphabetic(0x0DD8, 0x0DDF).
unicode_range_alphabetic(0x0DF2, 0x0DF3).
unicode_range_alphabetic(0x0E01, 0x0E3A).
unicode_range_alphabetic(0x0E40, 0x0E46).
unicode_range_alphabetic(0x0E4D, 0x0E4D).
unicode_range_alphabetic(0x0E81, 0x0E82).
unicode_range_alphabetic(0x0E84, 0x0E84).
unicode_range_alphabetic(0x0E87, 0x0E88).
unicode_range_alphabetic(0x0E8A, 0x0E8A).
unicode_range_alphabetic(0x0E8D, 0x0E8D).
unicode_range_alphabetic(0x0E94, 0x0E97).
unicode_range_alphabetic(0x0E99, 0x0E9F).
unicode_range_alphabetic(0x0EA1, 0x0EA3).
unicode_range_alphabetic(0x0EA5, 0x0EA5).
unicode_range_alphabetic(0x0EA7, 0x0EA7).
unicode_range_alphabetic(0x0EAA, 0x0EAB).
unicode_range_alphabetic(0x0EAD, 0x0EB9).
unicode_range_alphabetic(0x0EBB, 0x0EBD).
unicode_range_alphabetic(0x0EC0, 0x0EC4).
unicode_range_alphabetic(0x0EC6, 0x0EC6).
unicode_range_alphabetic(0x0ECD, 0x0ECD).
unicode_range_alphabetic(0x0EDC, 0x0EDF).
unicode_range_alphabetic(0x0F00, 0x0F00).
unicode_range_alphabetic(0x0F40, 0x0F47).
unicode_range_alphabetic(0x0F49, 0x0F6C).
unicode_range_alphabetic(0x0F71, 0x0F81).
unicode_range_alphabetic(0x0F88, 0x0F97).
unicode_range_alphabetic(0x0F99, 0x0FBC).
unicode_range_alphabetic(0x1000, 0x1036).
unicode_range_alphabetic(0x1038, 0x1038).
unicode_range_alphabetic(0x103B, 0x103F).
unicode_range_alphabetic(0x1050, 0x1062).
unicode_range_alphabetic(0x1065, 0x1068).
unicode_range_alphabetic(0x106E, 0x1086).
unicode_range_alphabetic(0x108E, 0x108E).
unicode_range_alphabetic(0x109C, 0x109D).
unicode_range_alphabetic(0x10A0, 0x10C5).
unicode_range_alphabetic(0x10C7, 0x10C7).
unicode_range_alphabetic(0x10CD, 0x10CD).
unicode_range_alphabetic(0x10D0, 0x10FA).
unicode_range_alphabetic(0x10FC, 0x1248).
unicode_range_alphabetic(0x124A, 0x124D).
unicode_range_alphabetic(0x1250, 0x1256).
unicode_range_alphabetic(0x1258, 0x1258).
unicode_range_alphabetic(0x125A, 0x125D).
unicode_range_alphabetic(0x1260, 0x1288).
unicode_range_alphabetic(0x128A, 0x128D).
unicode_range_alphabetic(0x1290, 0x12B0).
unicode_range_alphabetic(0x12B2, 0x12B5).
unicode_range_alphabetic(0x12B8, 0x12BE).
unicode_range_alphabetic(0x12C0, 0x12C0).
unicode_range_alphabetic(0x12C2, 0x12C5).
unicode_range_alphabetic(0x12C8, 0x12D6).
unicode_range_alphabetic(0x12D8, 0x1310).
unicode_range_alphabetic(0x1312, 0x1315).
unicode_range_alphabetic(0x1318, 0x135A).
unicode_range_alphabetic(0x135F, 0x135F).
unicode_range_alphabetic(0x1380, 0x138F).
unicode_range_alphabetic(0x13A0, 0x13F4).
unicode_range_alphabetic(0x1401, 0x166C).
unicode_range_alphabetic(0x166F, 0x167F).
unicode_range_alphabetic(0x1681, 0x169A).
unicode_range_alphabetic(0x16A0, 0x16EA).
unicode_range_alphabetic(0x16EE, 0x16F0).
unicode_range_alphabetic(0x1700, 0x170C).
unicode_range_alphabetic(0x170E, 0x1713).
unicode_range_alphabetic(0x1720, 0x1733).
unicode_range_alphabetic(0x1740, 0x1753).
unicode_range_alphabetic(0x1760, 0x176C).
unicode_range_alphabetic(0x176E, 0x1770).
unicode_range_alphabetic(0x1772, 0x1773).
unicode_range_alphabetic(0x1780, 0x17B3).
unicode_range_alphabetic(0x17B6, 0x17C8).
unicode_range_alphabetic(0x17D7, 0x17D7).
unicode_range_alphabetic(0x17DC, 0x17DC).
unicode_range_alphabetic(0x1820, 0x1877).
unicode_range_alphabetic(0x1880, 0x18AA).
unicode_range_alphabetic(0x18B0, 0x18F5).
unicode_range_alphabetic(0x1900, 0x191C).
unicode_range_alphabetic(0x1920, 0x192B).
unicode_range_alphabetic(0x1930, 0x1938).
unicode_range_alphabetic(0x1950, 0x196D).
unicode_range_alphabetic(0x1970, 0x1974).
unicode_range_alphabetic(0x1980, 0x19AB).
unicode_range_alphabetic(0x19B0, 0x19C9).
unicode_range_alphabetic(0x1A00, 0x1A1B).
unicode_range_alphabetic(0x1A20, 0x1A5E).
unicode_range_alphabetic(0x1A61, 0x1A74).
unicode_range_alphabetic(0x1AA7, 0x1AA7).
unicode_range_alphabetic(0x1B00, 0x1B33).
unicode_range_alphabetic(0x1B35, 0x1B43).
unicode_range_alphabetic(0x1B45, 0x1B4B).
unicode_range_alphabetic(0x1B80, 0x1BA9).
unicode_range_alphabetic(0x1BAC, 0x1BAF).
unicode_range_alphabetic(0x1BBA, 0x1BE5).
unicode_range_alphabetic(0x1BE7, 0x1BF1).
unicode_range_alphabetic(0x1C00, 0x1C35).
unicode_range_alphabetic(0x1C4D, 0x1C4F).
unicode_range_alphabetic(0x1C5A, 0x1C7D).
unicode_range_alphabetic(0x1CE9, 0x1CEC).
unicode_range_alphabetic(0x1CEE, 0x1CF3).
unicode_range_alphabetic(0x1CF5, 0x1CF6).
unicode_range_alphabetic(0x1D00, 0x1DBF).
unicode_range_alphabetic(0x1E00, 0x1F15).
unicode_range_alphabetic(0x1F18, 0x1F1D).
unicode_range_alphabetic(0x1F20, 0x1F45).
unicode_range_alphabetic(0x1F48, 0x1F4D).
unicode_range_alphabetic(0x1F50, 0x1F57).
unicode_range_alphabetic(0x1F59, 0x1F59).
unicode_range_alphabetic(0x1F5B, 0x1F5B).
unicode_range_alphabetic(0x1F5D, 0x1F5D).
unicode_range_alphabetic(0x1F5F, 0x1F7D).
unicode_range_alphabetic(0x1F80, 0x1FB4).
unicode_range_alphabetic(0x1FB6, 0x1FBC).
unicode_range_alphabetic(0x1FBE, 0x1FBE).
unicode_range_alphabetic(0x1FC2, 0x1FC4).
unicode_range_alphabetic(0x1FC6, 0x1FCC).
unicode_range_alphabetic(0x1FD0, 0x1FD3).
unicode_range_alphabetic(0x1FD6, 0x1FDB).
unicode_range_alphabetic(0x1FE0, 0x1FEC).
unicode_range_alphabetic(0x1FF2, 0x1FF4).
unicode_range_alphabetic(0x1FF6, 0x1FFC).
unicode_range_alphabetic(0x2071, 0x2071).
unicode_range_alphabetic(0x207F, 0x207F).
unicode_range_alphabetic(0x2090, 0x209C).
unicode_range_alphabetic(0x2102, 0x2102).
unicode_range_alphabetic(0x2107, 0x2107).
unicode_range_alphabetic(0x210A, 0x2113).
unicode_range_alphabetic(0x2115, 0x2115).
unicode_range_alphabetic(0x2119, 0x211D).
unicode_range_alphabetic(0x2124, 0x2124).
unicode_range_alphabetic(0x2126, 0x2126).
unicode_range_alphabetic(0x2128, 0x2128).
unicode_range_alphabetic(0x212A, 0x212D).
unicode_range_alphabetic(0x212F, 0x2139).
unicode_range_alphabetic(0x213C, 0x213F).
unicode_range_alphabetic(0x2145, 0x2149).
unicode_range_alphabetic(0x214E, 0x214E).
unicode_range_alphabetic(0x2160, 0x2188).
unicode_range_alphabetic(0x24B6, 0x24E9).
unicode_range_alphabetic(0x2C00, 0x2C2E).
unicode_range_alphabetic(0x2C30, 0x2C5E).
unicode_range_alphabetic(0x2C60, 0x2CE4).
unicode_range_alphabetic(0x2CEB, 0x2CEE).
unicode_range_alphabetic(0x2CF2, 0x2CF3).
unicode_range_alphabetic(0x2D00, 0x2D25).
unicode_range_alphabetic(0x2D27, 0x2D27).
unicode_range_alphabetic(0x2D2D, 0x2D2D).
unicode_range_alphabetic(0x2D30, 0x2D67).
unicode_range_alphabetic(0x2D6F, 0x2D6F).
unicode_range_alphabetic(0x2D80, 0x2D96).
unicode_range_alphabetic(0x2DA0, 0x2DA6).
unicode_range_alphabetic(0x2DA8, 0x2DAE).
unicode_range_alphabetic(0x2DB0, 0x2DB6).
unicode_range_alphabetic(0x2DB8, 0x2DBE).
unicode_range_alphabetic(0x2DC0, 0x2DC6).
unicode_range_alphabetic(0x2DC8, 0x2DCE).
unicode_range_alphabetic(0x2DD0, 0x2DD6).
unicode_range_alphabetic(0x2DD8, 0x2DDE).
unicode_range_alphabetic(0x2DE0, 0x2DFF).
unicode_range_alphabetic(0x2E2F, 0x2E2F).
unicode_range_alphabetic(0x3005, 0x3007).
unicode_range_alphabetic(0x3021, 0x3029).
unicode_range_alphabetic(0x3031, 0x3035).
unicode_range_alphabetic(0x3038, 0x303C).
unicode_range_alphabetic(0x3041, 0x3096).
unicode_range_alphabetic(0x309D, 0x309F).
unicode_range_alphabetic(0x30A1, 0x30FA).
unicode_range_alphabetic(0x30FC, 0x30FF).
unicode_range_alphabetic(0x3105, 0x312D).
unicode_range_alphabetic(0x3131, 0x318E).
unicode_range_alphabetic(0x31A0, 0x31BA).
unicode_range_alphabetic(0x31F0, 0x31FF).
unicode_range_alphabetic(0x3400, 0x4DB5).
unicode_range_alphabetic(0x4E00, 0x9FCC).
unicode_range_alphabetic(0xA000, 0xA48C).
unicode_range_alphabetic(0xA4D0, 0xA4FD).
unicode_range_alphabetic(0xA500, 0xA60C).
unicode_range_alphabetic(0xA610, 0xA61F).
unicode_range_alphabetic(0xA62A, 0xA62B).
unicode_range_alphabetic(0xA640, 0xA66E).
unicode_range_alphabetic(0xA674, 0xA67B).
unicode_range_alphabetic(0xA67F, 0xA697).
unicode_range_alphabetic(0xA69F, 0xA6EF).
unicode_range_alphabetic(0xA717, 0xA71F).
unicode_range_alphabetic(0xA722, 0xA788).
unicode_range_alphabetic(0xA78B, 0xA78E).
unicode_range_alphabetic(0xA790, 0xA793).
unicode_range_alphabetic(0xA7A0, 0xA7AA).
unicode_range_alphabetic(0xA7F8, 0xA801).
unicode_range_alphabetic(0xA803, 0xA805).
unicode_range_alphabetic(0xA807, 0xA80A).
unicode_range_alphabetic(0xA80C, 0xA827).
unicode_range_alphabetic(0xA840, 0xA873).
unicode_range_alphabetic(0xA880, 0xA8C3).
unicode_range_alphabetic(0xA8F2, 0xA8F7).
unicode_range_alphabetic(0xA8FB, 0xA8FB).
unicode_range_alphabetic(0xA90A, 0xA92A).
unicode_range_alphabetic(0xA930, 0xA952).
unicode_range_alphabetic(0xA960, 0xA97C).
unicode_range_alphabetic(0xA980, 0xA9B2).
unicode_range_alphabetic(0xA9B4, 0xA9BF).
unicode_range_alphabetic(0xA9CF, 0xA9CF).
unicode_range_alphabetic(0xAA00, 0xAA36).
unicode_range_alphabetic(0xAA40, 0xAA4D).
unicode_range_alphabetic(0xAA60, 0xAA76).
unicode_range_alphabetic(0xAA7A, 0xAA7A).
unicode_range_alphabetic(0xAA80, 0xAABE).
unicode_range_alphabetic(0xAAC0, 0xAAC0).
unicode_range_alphabetic(0xAAC2, 0xAAC2).
unicode_range_alphabetic(0xAADB, 0xAADD).
unicode_range_alphabetic(0xAAE0, 0xAAEF).
unicode_range_alphabetic(0xAAF2, 0xAAF5).
unicode_range_alphabetic(0xAB01, 0xAB06).
unicode_range_alphabetic(0xAB09, 0xAB0E).
unicode_range_alphabetic(0xAB11, 0xAB16).
unicode_range_alphabetic(0xAB20, 0xAB26).
unicode_range_alphabetic(0xAB28, 0xAB2E).
unicode_range_alphabetic(0xABC0, 0xABEA).
unicode_range_alphabetic(0xAC00, 0xD7A3).
unicode_range_alphabetic(0xD7B0, 0xD7C6).
unicode_range_alphabetic(0xD7CB, 0xD7FB).
unicode_range_alphabetic(0xF900, 0xFA6D).
unicode_range_alphabetic(0xFA70, 0xFAD9).
unicode_range_alphabetic(0xFB00, 0xFB06).
unicode_range_alphabetic(0xFB13, 0xFB17).
unicode_range_alphabetic(0xFB1D, 0xFB28).
unicode_range_alphabetic(0xFB2A, 0xFB36).
unicode_range_alphabetic(0xFB38, 0xFB3C).
unicode_range_alphabetic(0xFB3E, 0xFB3E).
unicode_range_alphabetic(0xFB40, 0xFB41).
unicode_range_alphabetic(0xFB43, 0xFB44).
unicode_range_alphabetic(0xFB46, 0xFBB1).
unicode_range_alphabetic(0xFBD3, 0xFD3D).
unicode_range_alphabetic(0xFD50, 0xFD8F).
unicode_range_alphabetic(0xFD92, 0xFDC7).
unicode_range_alphabetic(0xFDF0, 0xFDFB).
unicode_range_alphabetic(0xFE70, 0xFE74).
unicode_range_alphabetic(0xFE76, 0xFEFC).
unicode_range_alphabetic(0xFF21, 0xFF3A).
unicode_range_alphabetic(0xFF41, 0xFF5A).
unicode_range_alphabetic(0xFF66, 0xFFBE).
unicode_range_alphabetic(0xFFC2, 0xFFC7).
unicode_range_alphabetic(0xFFCA, 0xFFCF).
unicode_range_alphabetic(0xFFD2, 0xFFD7).
unicode_range_alphabetic(0xFFDA, 0xFFDC).
unicode_range_alphabetic(0x10000, 0x1000B).
unicode_range_alphabetic(0x1000D, 0x10026).
unicode_range_alphabetic(0x10028, 0x1003A).
unicode_range_alphabetic(0x1003C, 0x1003D).
unicode_range_alphabetic(0x1003F, 0x1004D).
unicode_range_alphabetic(0x10050, 0x1005D).
unicode_range_alphabetic(0x10080, 0x100FA).
unicode_range_alphabetic(0x10140, 0x10174).
unicode_range_alphabetic(0x10280, 0x1029C).
unicode_range_alphabetic(0x102A0, 0x102D0).
unicode_range_alphabetic(0x10300, 0x1031E).
unicode_range_alphabetic(0x10330, 0x1034A).
unicode_range_alphabetic(0x10380, 0x1039D).
unicode_range_alphabetic(0x103A0, 0x103C3).
unicode_range_alphabetic(0x103C8, 0x103CF).
unicode_range_alphabetic(0x103D1, 0x103D5).
unicode_range_alphabetic(0x10400, 0x1049D).
unicode_range_alphabetic(0x10800, 0x10805).
unicode_range_alphabetic(0x10808, 0x10808).
unicode_range_alphabetic(0x1080A, 0x10835).
unicode_range_alphabetic(0x10837, 0x10838).
unicode_range_alphabetic(0x1083C, 0x1083C).
unicode_range_alphabetic(0x1083F, 0x10855).
unicode_range_alphabetic(0x10900, 0x10915).
unicode_range_alphabetic(0x10920, 0x10939).
unicode_range_alphabetic(0x10980, 0x109B7).
unicode_range_alphabetic(0x109BE, 0x109BF).
unicode_range_alphabetic(0x10A00, 0x10A03).
unicode_range_alphabetic(0x10A05, 0x10A06).
unicode_range_alphabetic(0x10A0C, 0x10A13).
unicode_range_alphabetic(0x10A15, 0x10A17).
unicode_range_alphabetic(0x10A19, 0x10A33).
unicode_range_alphabetic(0x10A60, 0x10A7C).
unicode_range_alphabetic(0x10B00, 0x10B35).
unicode_range_alphabetic(0x10B40, 0x10B55).
unicode_range_alphabetic(0x10B60, 0x10B72).
unicode_range_alphabetic(0x10C00, 0x10C48).
unicode_range_alphabetic(0x11000, 0x11045).
unicode_range_alphabetic(0x11082, 0x110B8).
unicode_range_alphabetic(0x110D0, 0x110E8).
unicode_range_alphabetic(0x11100, 0x11132).
unicode_range_alphabetic(0x11180, 0x111BF).
unicode_range_alphabetic(0x111C1, 0x111C4).
unicode_range_alphabetic(0x11680, 0x116B5).
unicode_range_alphabetic(0x12000, 0x1236E).
unicode_range_alphabetic(0x12400, 0x12462).
unicode_range_alphabetic(0x13000, 0x1342E).
unicode_range_alphabetic(0x16800, 0x16A38).
unicode_range_alphabetic(0x16F00, 0x16F44).
unicode_range_alphabetic(0x16F50, 0x16F7E).
unicode_range_alphabetic(0x16F93, 0x16F9F).
unicode_range_alphabetic(0x1B000, 0x1B001).
unicode_range_alphabetic(0x1D400, 0x1D454).
unicode_range_alphabetic(0x1D456, 0x1D49C).
unicode_range_alphabetic(0x1D49E, 0x1D49F).
unicode_range_alphabetic(0x1D4A2, 0x1D4A2).
unicode_range_alphabetic(0x1D4A5, 0x1D4A6).
unicode_range_alphabetic(0x1D4A9, 0x1D4AC).
unicode_range_alphabetic(0x1D4AE, 0x1D4B9).
unicode_range_alphabetic(0x1D4BB, 0x1D4BB).
unicode_range_alphabetic(0x1D4BD, 0x1D4C3).
unicode_range_alphabetic(0x1D4C5, 0x1D505).
unicode_range_alphabetic(0x1D507, 0x1D50A).
unicode_range_alphabetic(0x1D50D, 0x1D514).
unicode_range_alphabetic(0x1D516, 0x1D51C).
unicode_range_alphabetic(0x1D51E, 0x1D539).
unicode_range_alphabetic(0x1D53B, 0x1D53E).
unicode_range_alphabetic(0x1D540, 0x1D544).
unicode_range_alphabetic(0x1D546, 0x1D546).
unicode_range_alphabetic(0x1D54A, 0x1D550).
unicode_range_alphabetic(0x1D552, 0x1D6A5).
unicode_range_alphabetic(0x1D6A8, 0x1D6C0).
unicode_range_alphabetic(0x1D6C2, 0x1D6DA).
unicode_range_alphabetic(0x1D6DC, 0x1D6FA).
unicode_range_alphabetic(0x1D6FC, 0x1D714).
unicode_range_alphabetic(0x1D716, 0x1D734).
unicode_range_alphabetic(0x1D736, 0x1D74E).
unicode_range_alphabetic(0x1D750, 0x1D76E).
unicode_range_alphabetic(0x1D770, 0x1D788).
unicode_range_alphabetic(0x1D78A, 0x1D7A8).
unicode_range_alphabetic(0x1D7AA, 0x1D7C2).
unicode_range_alphabetic(0x1D7C4, 0x1D7CB).
unicode_range_alphabetic(0x1EE00, 0x1EE03).
unicode_range_alphabetic(0x1EE05, 0x1EE1F).
unicode_range_alphabetic(0x1EE21, 0x1EE22).
unicode_range_alphabetic(0x1EE24, 0x1EE24).
unicode_range_alphabetic(0x1EE27, 0x1EE27).
unicode_range_alphabetic(0x1EE29, 0x1EE32).
unicode_range_alphabetic(0x1EE34, 0x1EE37).
unicode_range_alphabetic(0x1EE39, 0x1EE39).
unicode_range_alphabetic(0x1EE3B, 0x1EE3B).
unicode_range_alphabetic(0x1EE42, 0x1EE42).
unicode_range_alphabetic(0x1EE47, 0x1EE47).
unicode_range_alphabetic(0x1EE49, 0x1EE49).
unicode_range_alphabetic(0x1EE4B, 0x1EE4B).
unicode_range_alphabetic(0x1EE4D, 0x1EE4F).
unicode_range_alphabetic(0x1EE51, 0x1EE52).
unicode_range_alphabetic(0x1EE54, 0x1EE54).
unicode_range_alphabetic(0x1EE57, 0x1EE57).
unicode_range_alphabetic(0x1EE59, 0x1EE59).
unicode_range_alphabetic(0x1EE5B, 0x1EE5B).
unicode_range_alphabetic(0x1EE5D, 0x1EE5D).
unicode_range_alphabetic(0x1EE5F, 0x1EE5F).
unicode_range_alphabetic(0x1EE61, 0x1EE62).
unicode_range_alphabetic(0x1EE64, 0x1EE64).
unicode_range_alphabetic(0x1EE67, 0x1EE6A).
unicode_range_alphabetic(0x1EE6C, 0x1EE72).
unicode_range_alphabetic(0x1EE74, 0x1EE77).
unicode_range_alphabetic(0x1EE79, 0x1EE7C).
unicode_range_alphabetic(0x1EE7E, 0x1EE7E).
unicode_range_alphabetic(0x1EE80, 0x1EE89).
unicode_range_alphabetic(0x1EE8B, 0x1EE9B).
unicode_range_alphabetic(0x1EEA1, 0x1EEA3).
unicode_range_alphabetic(0x1EEA5, 0x1EEA9).
unicode_range_alphabetic(0x1EEAB, 0x1EEBB).
unicode_range_alphabetic(0x20000, 0x2A6D6).
unicode_range_alphabetic(0x2A700, 0x2B734).
unicode_range_alphabetic(0x2B740, 0x2B81D).
unicode_range_alphabetic(0x2F800, 0x2FA1D).

% Total code points: 102159
