/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import java.util.List;
import org.eclipse.sisu.bean.BeanBinder;
import org.eclipse.sisu.bean.PropertyBinder;
import org.eclipse.sisu.plexus.PlexusBeanManager;
import org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.eclipse.sisu.plexus.PlexusBeanSource;
import org.eclipse.sisu.plexus.PlexusPropertyBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlexusBeanBinder
implements BeanBinder,
InjectionListener<Object> {
    private final PlexusBeanManager manager;
    private final PlexusBeanSource[] sources;

    PlexusBeanBinder(PlexusBeanManager manager, List<PlexusBeanSource> sources) {
        this.manager = manager;
        this.sources = sources.toArray(new PlexusBeanSource[sources.size()]);
    }

    public <B> PropertyBinder bindBean(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        Class clazz = type.getRawType();
        if (this.manager != null && this.manager.manage(clazz)) {
            encounter.register((InjectionListener)this);
        }
        PlexusBeanSource[] plexusBeanSourceArray = this.sources;
        int n = this.sources.length;
        int n2 = 0;
        while (n2 < n) {
            PlexusBeanSource source = plexusBeanSourceArray[n2];
            PlexusBeanMetadata metadata = source.getBeanMetadata(clazz);
            if (metadata != null) {
                return new PlexusPropertyBinder(this.manager, encounter, metadata);
            }
            ++n2;
        }
        return null;
    }

    public void afterInjection(Object bean) {
        this.manager.manage(bean);
    }
}

