/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transfer;

import java.nio.ByteBuffer;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transfer.TransferResource;

public final class TransferEvent {
    private final EventType type;
    private final RequestType requestType;
    private final RepositorySystemSession session;
    private final TransferResource resource;
    private final ByteBuffer dataBuffer;
    private final long transferredBytes;
    private final Exception exception;

    TransferEvent(Builder builder) {
        this.type = builder.type;
        this.requestType = builder.requestType;
        this.session = builder.session;
        this.resource = builder.resource;
        this.dataBuffer = builder.dataBuffer;
        this.transferredBytes = builder.transferredBytes;
        this.exception = builder.exception;
    }

    public EventType getType() {
        return this.type;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public TransferResource getResource() {
        return this.resource;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer != null ? this.dataBuffer.asReadOnlyBuffer() : null;
    }

    public int getDataLength() {
        return this.dataBuffer != null ? this.dataBuffer.remaining() : 0;
    }

    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        return (Object)((Object)this.getRequestType()) + " " + (Object)((Object)this.getType()) + " " + this.getResource();
    }

    public static final class Builder {
        EventType type;
        RequestType requestType;
        RepositorySystemSession session;
        TransferResource resource;
        ByteBuffer dataBuffer;
        long transferredBytes;
        Exception exception;

        public Builder(RepositorySystemSession session, TransferResource resource) {
            if (session == null) {
                throw new IllegalArgumentException("session not specified");
            }
            if (resource == null) {
                throw new IllegalArgumentException("transfer resource not specified");
            }
            this.session = session;
            this.resource = resource;
            this.type = EventType.INITIATED;
            this.requestType = RequestType.GET;
        }

        private Builder(Builder prototype) {
            this.session = prototype.session;
            this.resource = prototype.resource;
            this.type = prototype.type;
            this.requestType = prototype.requestType;
            this.dataBuffer = prototype.dataBuffer;
            this.transferredBytes = prototype.transferredBytes;
            this.exception = prototype.exception;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder resetType(EventType type) {
            if (type == null) {
                throw new IllegalArgumentException("event type not specified");
            }
            this.type = type;
            this.dataBuffer = null;
            this.exception = null;
            switch (type) {
                case INITIATED: 
                case STARTED: {
                    this.transferredBytes = 0L;
                }
            }
            return this;
        }

        public Builder setType(EventType type) {
            if (type == null) {
                throw new IllegalArgumentException("event type not specified");
            }
            this.type = type;
            return this;
        }

        public Builder setRequestType(RequestType requestType) {
            if (requestType == null) {
                throw new IllegalArgumentException("request type not specified");
            }
            this.requestType = requestType;
            return this;
        }

        public Builder setTransferredBytes(long transferredBytes) {
            if (transferredBytes < 0L) {
                throw new IllegalArgumentException("number of transferred bytes cannot be negative");
            }
            this.transferredBytes = transferredBytes;
            return this;
        }

        public Builder addTransferredBytes(long transferredBytes) {
            if (transferredBytes < 0L) {
                throw new IllegalArgumentException("number of transferred bytes cannot be negative");
            }
            this.transferredBytes += transferredBytes;
            return this;
        }

        public Builder setDataBuffer(byte[] buffer, int offset, int length) {
            return this.setDataBuffer(buffer != null ? ByteBuffer.wrap(buffer, offset, length) : null);
        }

        public Builder setDataBuffer(ByteBuffer dataBuffer) {
            this.dataBuffer = dataBuffer;
            return this;
        }

        public Builder setException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public TransferEvent build() {
            return new TransferEvent(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestType {
        GET,
        GET_EXISTENCE,
        PUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        INITIATED,
        STARTED,
        PROGRESSED,
        CORRUPTED,
        SUCCEEDED,
        FAILED;

    }
}

