/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.console.logging;

import groovy.util.AntBuilder;
import io.micronaut.cli.console.logging.ConsoleBuildListener;
import io.micronaut.cli.console.logging.MicronautConsole;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.types.LogLevel;
import org.apache.tools.ant.util.StringUtils;

public class ConsoleAntBuilder
extends AntBuilder {
    public ConsoleAntBuilder(Project project) {
        super(project);
    }

    public ConsoleAntBuilder() {
        super(ConsoleAntBuilder.createAntProject());
    }

    protected static Project createAntProject() {
        Project project = new Project();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        project.addReference("ant.projectHelper", helper);
        helper.getImportStack().addElement("AntBuilder");
        ConsoleAntBuilder.addMicronautConsoleBuildListener(project);
        project.init();
        project.getBaseDir();
        return project;
    }

    public static void addMicronautConsoleBuildListener(Project project) {
        MicronautConsoleLogger logger = new MicronautConsoleLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        project.addBuildListener(logger);
        MicronautConsole instance = MicronautConsole.getInstance();
        project.addBuildListener(new ConsoleBuildListener(instance));
        if (!instance.isVerbose()) {
            for (BuildListener buildListener : project.getBuildListeners()) {
                if (!(buildListener instanceof BuildLogger)) continue;
                ((BuildLogger)buildListener).setMessageOutputLevel(LogLevel.ERR.getLevel());
            }
        }
    }

    private static class MicronautConsoleLogger
    extends DefaultLogger {
        protected String targetName;
        protected MicronautConsole console = MicronautConsole.getInstance();

        private MicronautConsoleLogger() {
        }

        @Override
        public void targetStarted(BuildEvent event) {
            this.targetName = event.getTarget().getName();
        }

        @Override
        public void targetFinished(BuildEvent event) {
            this.targetName = null;
        }

        @Override
        public void messageLogged(BuildEvent event) {
            if (event.getPriority() > this.msgOutputLevel || null == event.getMessage() || "".equals(event.getMessage().trim())) {
                return;
            }
            if (null != this.targetName) {
                this.console.verbose(StringUtils.LINE_SEP + this.targetName + ":");
                this.targetName = null;
            }
        }
    }
}

